/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.asciiart;

import java.awt.geom.Dimension2D;
import java.util.List;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.asciiart.AbstractComponentText;
import net.sourceforge.plantuml.asciiart.UmlCharArea;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.txt.UGraphicTxt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentTextGroupingTail
extends AbstractComponentText {
    private final ComponentType type;
    private final List<? extends CharSequence> stringsToDisplay;
    private final FileFormat fileFormat;

    public ComponentTextGroupingTail(ComponentType componentType, List<? extends CharSequence> list, FileFormat fileFormat) {
        this.type = componentType;
        this.stringsToDisplay = list;
        this.fileFormat = fileFormat;
    }

    @Override
    public void drawU(UGraphic uGraphic, Area area, Context2D context2D) {
        Dimension2D dimension2D = area.getDimensionToUse();
        UmlCharArea umlCharArea = ((UGraphicTxt)uGraphic).getCharArea();
        int n = (int)dimension2D.getWidth();
        int n2 = (int)dimension2D.getHeight();
        if (this.fileFormat == FileFormat.UTXT) {
            umlCharArea.drawChar('\u255a', 0, n2 - 1);
            umlCharArea.drawChar('\u255d', n - 1, n2 - 1);
        }
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        return 1.0;
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        return 1.0;
    }
}

