#!/usr/bin/perl

package eBay::API::XML::Call::GetUserPreferences::GetUserPreferencesRequestType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetUserPreferencesRequestType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetUserPreferences::GetUserPreferencesRequestType

=head1 DESCRIPTION

Retrieves some or all of a user's preferences. The set of preferences retrieved depends
on the set of flags specified in the request.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetUserPreferences::GetUserPreferencesRequestType inherits from the L<eBay::API::XML::RequestDataType> class

=cut

use eBay::API::XML::RequestDataType;
our @ISA = ("eBay::API::XML::RequestDataType");



my @gaProperties = ( [ 'ShowBidderNoticePreferences', 'xs:boolean', '', '', '' ]
	, [ 'ShowCombinedPaymentPreferences', 'xs:boolean', '', '', '' ]
	, [ 'ShowCrossPromotionPreferences', 'xs:boolean', '', '', '' ]
	, [ 'ShowEmailShipmentTrackingNumberPreference', 'xs:boolean', '', '', '' ]
	, [ 'ShowEndOfAuctionEmailPreferences', 'xs:boolean', '', '', '' ]
	, [ 'ShowProStoresPreferences', 'xs:boolean', '', '', '' ]
	, [ 'ShowSellerFavoriteItemPreferences', 'xs:boolean', '', '', '' ]
	, [ 'ShowSellerPaymentPreferences', 'xs:boolean', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::RequestDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::RequestDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setShowBidderNoticePreferences()

If true, requests a seller's preferences for receiving bidder notices.

  RequiredInput: No
#    Argument: 'xs:boolean'

=cut

sub setShowBidderNoticePreferences {
  my $self = shift;
  $self->{'ShowBidderNoticePreferences'} = shift
}

=head2 isShowBidderNoticePreferences()

#    Returns: 'xs:boolean'

=cut

sub isShowBidderNoticePreferences {
  my $self = shift;
  return $self->{'ShowBidderNoticePreferences'};
}


=head2 setShowCombinedPaymentPreferences()

DO NOT USE THIS FIELD. Use 'GetShippingDiscountProfiles' to access
similar information.
If true, requests a seller's preferences for accepting payments
that combine item purchases into one order.

  RequiredInput: No
#    Argument: 'xs:boolean'

=cut

sub setShowCombinedPaymentPreferences {
  my $self = shift;
  $self->{'ShowCombinedPaymentPreferences'} = shift
}

=head2 isShowCombinedPaymentPreferences()

#    Returns: 'xs:boolean'

=cut

sub isShowCombinedPaymentPreferences {
  my $self = shift;
  return $self->{'ShowCombinedPaymentPreferences'};
}


=head2 setShowCrossPromotionPreferences()

If true, requests a seller's cross-promotion preferences, such as
whether cross-promotions are enabled and the sort filters used.

  RequiredInput: No
#    Argument: 'xs:boolean'

=cut

sub setShowCrossPromotionPreferences {
  my $self = shift;
  $self->{'ShowCrossPromotionPreferences'} = shift
}

=head2 isShowCrossPromotionPreferences()

#    Returns: 'xs:boolean'

=cut

sub isShowCrossPromotionPreferences {
  my $self = shift;
  return $self->{'ShowCrossPromotionPreferences'};
}


=head2 setShowEmailShipmentTrackingNumberPreference()

If true, returns the preference related to emailing the email shipment tracking number.

Default: false

  RequiredInput: No
#    Argument: 'xs:boolean'

=cut

sub setShowEmailShipmentTrackingNumberPreference {
  my $self = shift;
  $self->{'ShowEmailShipmentTrackingNumberPreference'} = shift
}

=head2 isShowEmailShipmentTrackingNumberPreference()

#    Returns: 'xs:boolean'

=cut

sub isShowEmailShipmentTrackingNumberPreference {
  my $self = shift;
  return $self->{'ShowEmailShipmentTrackingNumberPreference'};
}


=head2 setShowEndOfAuctionEmailPreferences()

If true, displays the seller's end of auction email preferences.

  RequiredInput: No
#    Argument: 'xs:boolean'

=cut

sub setShowEndOfAuctionEmailPreferences {
  my $self = shift;
  $self->{'ShowEndOfAuctionEmailPreferences'} = shift
}

=head2 isShowEndOfAuctionEmailPreferences()

#    Returns: 'xs:boolean'

=cut

sub isShowEndOfAuctionEmailPreferences {
  my $self = shift;
  return $self->{'ShowEndOfAuctionEmailPreferences'};
}


=head2 setShowProStoresPreferences()

If true, returns ProStores checkout preferences.

Default: false

  RequiredInput: No
#    Argument: 'xs:boolean'

=cut

sub setShowProStoresPreferences {
  my $self = shift;
  $self->{'ShowProStoresPreferences'} = shift
}

=head2 isShowProStoresPreferences()

#    Returns: 'xs:boolean'

=cut

sub isShowProStoresPreferences {
  my $self = shift;
  return $self->{'ShowProStoresPreferences'};
}


=head2 setShowSellerFavoriteItemPreferences()

If true, retrieves preferences the seller has set for displaying items
on a buyer's favorite sellers page and in the favorite sellers email digest.

  RequiredInput: No
#    Argument: 'xs:boolean'

=cut

sub setShowSellerFavoriteItemPreferences {
  my $self = shift;
  $self->{'ShowSellerFavoriteItemPreferences'} = shift
}

=head2 isShowSellerFavoriteItemPreferences()

#    Returns: 'xs:boolean'

=cut

sub isShowSellerFavoriteItemPreferences {
  my $self = shift;
  return $self->{'ShowSellerFavoriteItemPreferences'};
}


=head2 setShowSellerPaymentPreferences()

If true, displays a seller's payment preferences, for displaying
a Pay Now button, accepting PayPal, and so on.

  RequiredInput: No
#    Argument: 'xs:boolean'

=cut

sub setShowSellerPaymentPreferences {
  my $self = shift;
  $self->{'ShowSellerPaymentPreferences'} = shift
}

=head2 isShowSellerPaymentPreferences()

#    Returns: 'xs:boolean'

=cut

sub isShowSellerPaymentPreferences {
  my $self = shift;
  return $self->{'ShowSellerPaymentPreferences'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
