/*
 * Decompiled with CFR 0.152.
 */
package thredds.inventory;

import java.io.IOException;
import java.util.Date;
import java.util.Formatter;
import java.util.Map;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog.InvAccess;
import thredds.catalog.InvCatalogFactory;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvCatalogRef;
import thredds.catalog.InvDataset;
import thredds.catalog.crawl.CatalogCrawler;
import thredds.inventory.DatasetCollectionManager;
import thredds.inventory.DateExtractorFromName;
import thredds.inventory.MFile;
import ucar.nc2.ft.fmrc.Fmrc;
import ucar.nc2.thredds.ThreddsDataFactory;
import ucar.nc2.units.DateType;
import ucar.nc2.util.CancelTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class DatasetCollectionFromCatalog
extends DatasetCollectionManager
implements CatalogCrawler.Listener {
    private static final Logger log = LoggerFactory.getLogger(DatasetCollectionFromCatalog.class);
    private final String catalogUrl;
    private boolean debug = false;

    public DatasetCollectionFromCatalog(String collection) {
        int pos;
        this.collectionName = collection;
        if (collection.startsWith("catalog:")) {
            collection = collection.substring("catalog:".length());
        }
        if ((pos = collection.indexOf(63)) > 0) {
            this.dateExtractor = new DateExtractorFromName(collection.substring(pos + 1), true);
            collection = collection.substring(0, pos);
        }
        this.catalogUrl = collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void scan(Map<String, MFile> map, CancelTask cancelTask) throws IOException {
        StringBuilder buff;
        InvCatalogFactory catFactory = InvCatalogFactory.getDefaultFactory(true);
        InvCatalogImpl cat = catFactory.readXML(this.catalogUrl);
        boolean isValid = cat.check(buff = new StringBuilder(), false);
        if (!isValid) {
            log.warn("Catalog invalid= " + this.catalogUrl + " validation output= " + buff);
            return;
        }
        CatalogCrawler crawler = new CatalogCrawler(1, false, this);
        long start = System.currentTimeMillis();
        try {
            crawler.crawl(cat, null, null, map);
            Object var11_9 = null;
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            long took = System.currentTimeMillis() - start;
            if (this.debug) {
                System.out.format("***Done " + this.catalogUrl + " took = " + took + " msecs\n", new Object[0]);
            }
            throw throwable;
        }
        long took = System.currentTimeMillis() - start;
        if (this.debug) {
            System.out.format("***Done " + this.catalogUrl + " took = " + took + " msecs\n", new Object[0]);
        }
    }

    @Override
    public void getDataset(InvDataset ds, Object context) {
        if (ds.hasAccess()) {
            ThreddsDataFactory tdataFactory = new ThreddsDataFactory();
            InvAccess access = tdataFactory.chooseDatasetAccess(ds.getAccess());
            MFileRemote mfile = new MFileRemote(access);
            if (mfile.getPath().endsWith(".xml")) {
                return;
            }
            Map map = (Map)context;
            map.put(mfile.getPath(), mfile);
            if (this.debug) {
                System.out.format("add %s %n", mfile.getPath());
            }
        }
    }

    @Override
    public boolean getCatalogRef(InvCatalogRef dd, Object context) {
        return true;
    }

    public static void main(String[] arg) throws IOException {
        String catUrl = "http://motherlode.ucar.edu:8080/thredds/catalog/fmrc/NCEP/NDFD/CONUS_5km/files/catalog.xml";
        DatasetCollectionFromCatalog man = new DatasetCollectionFromCatalog(catUrl);
        man.debug = true;
        man.scan(null);
        Formatter errlog = new Formatter();
        Fmrc fmrc = Fmrc.open("catalog:" + catUrl, errlog);
        System.out.printf("errlog = %s %n", errlog);
    }

    private class MFileRemote
    implements MFile {
        private Object info;
        private final InvAccess access;
        private Date lastModified;

        MFileRemote(InvAccess access) {
            this.access = access;
            for (DateType dateType : access.getDataset().getDates()) {
                if (!dateType.getType().equals("modified")) continue;
                this.lastModified = dateType.getDate();
            }
        }

        public long getLastModified() {
            return this.lastModified == null ? -1L : this.lastModified.getTime();
        }

        public long getLength() {
            return (long)this.access.getDataSize();
        }

        public boolean isDirectory() {
            return false;
        }

        public String getPath() {
            return this.access.getStandardUrlName();
        }

        public String getName() {
            return this.access.getDataset().getName();
        }

        public int compareTo(MFile o) {
            return this.getPath().compareTo(o.getPath());
        }

        public Object getAuxInfo() {
            return this.info;
        }

        public void setAuxInfo(Object info) {
            this.info = info;
        }
    }
}

