package POE::Component::Server::AsyncEndpoint::Config;

use warnings;
use strict;
our @EXPORT = ( );
use base qw(Exporter);
use vars qw($VERSION);
$VERSION = '0.01';

use AppConfig ':argcount';
use File::Find;
use Carp qw(croak);

sub init {

    my $config = AppConfig->new(
        {GLOBAL => {ARGCOUNT => ARGCOUNT_ONE}},
        'aes_port' => {DEFAULT => 61613},
        'aes_addr' => {DEFAULT => '127.0.0.1'},
        'aes_host' => {DEFAULT => 'localhost'},
        'aes_cwdg' => {DEFAULT => 10},
        'aes_wdgr' => {DEFAULT => 3},
        'aes_rstc' => {DEFAULT => 15},
        'aes_log_conf' => {DEFAULT => undef},
        'aes_ikc_addr' => {DEFAULT => undef},
        'aes_ikc_port' => {DEFAULT => undef},
        'webserver_port' => {DEFAULT => 32090},
        'mqdb_path' => {DEFAULT => './mqdb'},
        'mqdb_timeout' => {DEFAULT => 2},
        'mqdb_throttle_max' => {DEFAULT => 2},
    );

    my $fn = undef;

    # find and load server config file...
    find( sub{ $fn = $File::Find::name if /^aes\.conf$/ }, '.');
    $config->file($fn) if($fn);

    # find the logger config file...
    find( sub{ $fn = $File::Find::name if /^aes_log\.conf$/ }, '.');

    croak "Refuse to run without a logger config file. See __PACKAGE__ doc for details."
        unless $fn;

    $config->set('aes_log_conf', $fn);

    return $config;

}

1;

__END__

=head1 NAME

POE::Component::Server::AsyncEndpoint::Config

=head1 DESCRIPTION

Encapsulation of the configuration details of the master aes process.

At the moment, you don't have to use this class directly because it
is used automatically by the AsyncEndpoint class. This will change in
the next version because we want people to be able to extend the
configuration options.

Inside the AsyncEndpoint class there is a bit of code as such:

    # init server configuration
    my $config = POE::Component::Server::AsyncEndpoint::Config->init();


The standard configuration options have default values and can be
changed with the configuration file generated by the helper script. As
stated above, the next release will have the possibility to extend this
class and let you define other config parameters for constants and
other implementation specific information.

Two configuration files are read at startup. The first is called
B<aes.conf> and will contain all the configurable stuff of the main
aes. The second is named B<aes_log.conf> and contains the
configuration directives for the logger.

=head1 IMPORTANT NOTES

The name of the configuration files are very strict. This will not
change in future versions.

=head1 SEE ALSO

L<AppConfig>

L<POE::Component::Server::AsyncEndpoint>
L<POE>


=head1 AUTHOR

Alejandro Imass <ait@p2ee.org>
Alejandro Imass <aimass@corcaribe.com>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2008 by Alejandro Imass / Corcaribe Tecnología C.A. for the P2EE Project

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.8.8 or,
at your option, any later version of Perl 5 you may have available.

=cut




