use Opendata::GTFS::Standard;
use strict;
use warnings;

# PODNAME: Opendata::GTFS::Feed::Exception::FeedContainsFaultyHeader

class Opendata::GTFS::Feed::Exception::FeedContainsFaultyHeader with Opendata::GTFS::Feed::Exception using Moose {

    our $VERSION = '0.0103'; # VERSION:
    use Opendata::GTFS::Feed::Exception -all;

    has filename => (
        is => 'ro',
        isa => Any,
        traits => [Payload],
    );
    has header => (
        is => 'ro',
        isa => Any,
        traits => [Payload],
    );
    has info => (
        is => 'ro',
        isa => Str,
        lazy => 1,
        default => q{Feed contains faulty header [%{header}s] in file [%{filename}s]},
    );
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Opendata::GTFS::Feed::Exception::FeedContainsFaultyHeader

=head1 VERSION

Version 0.0103, released 2015-02-21.

=head1 SOURCE

L<https://github.com/Csson/p5-Opendata-GTFS-Feed>

=head1 HOMEPAGE

L<https://metacpan.org/release/Opendata-GTFS-Feed>

=head1 AUTHOR

Erik Carlsson <info@code301.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by Erik Carlsson <info@code301.com>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
