
Option Explicit
'On Error Resume Next

Dim args
Dim fs
Dim textStream
Dim path
Dim server
Dim database
Dim dbFileData
Dim dbFileLog
Dim serverName
Dim saUser
Dim saPassword

Dim dbUserName
Dim dbUserPassword
Dim dbUserIsNt
Dim mailServiceType
Dim sql

' get command line args
' No error check here.  Make sure that the caller supplies appropriate args
Set args = WScript.Arguments

serverName = args(0) '0 "HeraXP"
saUser = args(1) '1 "sa"
saPassword = args(2) '2 ""
dbUserIsNt = args(3) '3 1=>user is NT; 0=user is SQL user
dbUserName = args(4) '4 "alpentia\chriss"
dbUserPassword = args(5) '5 ""
mailServiceType = args(6) '6 "EXCHANGE" | "SMTP"

'connect to the sql server
Set server = CreateObject("SQLDMO.SQLServer")
server.Connect serverName, saUser, saPassword
' TODO: error check

' check if DB already exists
For Each database In server.Databases
	If database.Name = "GSEventLogGathererDB" Then
		MsgBox "Database already exists"
		' TODO: exit
	End If
Next

Set database = Nothing

' create the database
Set database = CreateObject("SQLDMO.Database")
Set dbFileData = CreateObject("SQLDMO.DBFile")
Set dbFileLog = CreateObject("SQLDMO.LogFile")

'Set new database name
database.Name = "GSEventLogGathererDB"

'Define the PRIMARY data file.
dbFileData.Name = "GSEventLogGathererDB"
dbFileData.PhysicalName = server.Registry.SQLDataRoot & "\DATA\GSEventLogGathererDB.mdf"
dbFileData.PrimaryFile = True
dbFileData.Size = 10 'Set initial size (optional)

'Add the DBFile object
database.FileGroups("PRIMARY").DBFiles.Add dbFileData

'Define the database transaction log.
dbFIleLog.Name = "GSEventLogGathererDB" & "Log"
dbFIleLog.PhysicalName = server.Registry.SQLDataRoot & "\DATA\GSEventLogGathererDB.ldf"
dbFIleLog.Size = 2 'Set initial size (optional)
database.TransactionLog.LogFiles.Add dbFIleLog

'Create the database as defined.
server.Databases.Add database
' TODO: error check

Set dbFileData = Nothing
Set dbFileLog = Nothing

For Each database In server.Databases
	If database.Name = "GSEventLogGathererDB" Then
		Exit For
	End If
Next

' assign permissions

' if new SQL login, the create it
If dbUserIsNt = 0 Then
	sql = "EXEC sp_addlogin '" & dbUserName & "', '" & dbUserPassword & "', 'GsEventLogGathererDB'"
	database.ExecuteImmediate(sql)
	' TODO: error check
End If 


sql = "EXEC sp_grantdbaccess '" & dbUserName & "', 'GsElgDbUser'"
database.ExecuteImmediate(sql)
' TODO: error check

sql = "exec sp_addrolemember 'db_owner', 'GsElgDbUser'"
database.ExecuteImmediate(sql)
' TODO: error check

Set fs = CreateObject("Scripting.FileSystemObject")
path = fs.GetAbsolutePathName("Files\DB")
' MsgBox path & "\GSEventLogGathererDB_LoadSchema.sql"

' load schema
Set textStream = fs.OpenTextFile(path & "\GSEventLogGathererDB_LoadSchema.sql")
database.ExecuteImmediate(textStream.ReadAll)
' TODO: error check
Set textStream = Nothing

' load stored procedures
Set textStream = fs.OpenTextFile(path & "\GSEventLogGathererDB_SPsCreate.sql")
database.ExecuteImmediate(textStream.ReadAll)
' TODO: error check
Set textStream = Nothing

' load triggers
Set textStream = fs.OpenTextFile(path & "\GSEventLogGathererDB_TriggersCreate.sql")
database.ExecuteImmediate(textStream.ReadAll)

' Determin what type of mail service the user wants to use
' REMARKS:
' If mailServiceType = "SMTP" then SMTP service has to be running on the SQL server
' If mailServiceType = "EXCHANGE"  then Exchange client has to be installed on the Sql server
' and Sql Mail has to be running
If mailServiceType = "SMTP" Then ' CDONTS
	Set textStream = fs.OpenTextFile(path & "\GSEventLogGathererDB_SMTPMail.sql")
	database.ExecuteImmediate(textStream.ReadAll)
Else ' Exchange
	Set textStream = fs.OpenTextFile(path & "\GSEventLogGathererDB_ExchangeMail.sql")
	database.ExecuteImmediate(textStream.ReadAll)
End If
' TODO: error check
Set textStream = Nothing

' load lookup data
Set textStream = fs.OpenTextFile(path & "\GSEventLogGathererDB_LoadData.sql")
database.ExecuteImmediate(textStream.ReadAll)
' TODO: error check
Set textStream = Nothing

Set fs = Nothing

server.DisConnect

Set fs = Nothing
Set server  = Nothing
Set database = Nothing
