/****************************************************************************
 *
 * Class: NoEditField
 *
 * Author: Mark Roseman
 * 
 * This class is a static text field which has the appearance of an 
 * InterViews field editor.  
 *
 * Revision History:
 * 
 * Date     Modifier  Description
 * -------- --------- -------------------------------------------------------
 * 08/14/92 MR        initial version
 *
 ****************************************************************************/

/*
 *  This file is part of GroupKit.
 *
 *  (c) Copyright 1992 Department of Computer Science, University of
 *      Calgary, Calgary, Alberta, Canada.  All rights reserved.
 *    
 *  Permission to use, copy, modify, and distribute this software and its
 *  documentation for any purpose and without fee is hereby granted, provided
 *  that the above copyright notice appears in all copies.  The University
 *  of Calgary makes no representations about the suitability of this
 *  software for any purpose.  It is provided "as is" without express or
 *  implied warranty.
 */

#ifndef __noeditfield_h
#define __noeditfield_h

#include <IV-look/field.h>
#include <OS/string.h>
#include <IV-look/kit.h>

class NoEditField : public FieldEditor {
public:
  NoEditField( const char* sample, WidgetKit* kit) : FieldEditor(String(sample),kit,kit->style(),nil) {};
  virtual void press(const class Event&) { };
  virtual void drag(const class Event&)  { };
  virtual void release(const class Event&) { };
  virtual void keystroke(const class Event&) { };
  virtual InputHandler* focus_in() { return InputHandler::focus_in(); }
};

#endif
