/**************************************************************************
 *
 * Class:  Conference
 * Author: Mark Roseman
 *
 * The Conference class is an abstract class providing a common center for
 * a real-time conference.  The main job for this root class is to maintain
 * a list of others users of the conference.  We create messaging objects
 * (Reader/Writer) but subclasses must inform them about conference specific
 * messages.
 * 
 *
 * Revision History:
 * 
 * Date     Modifier  Description
 * -------- --------- -------------------------------------------------------
 * 02/18/92 MR        initial version
 * 02/19/92 MR        replaced createReaderAndWriter(fd) with ..(rpcstream)
 * 05/29/92 MR        redid to use CallbackRpcReader etc.
 * 08/14/92 MR        clean up
 * 09/17/92 MR        added callback for reader connection close
 * 
 ***************************************************************************/

/*
 *  This file is part of GroupKit.
 *
 *  (c) Copyright 1992 Department of Computer Science, University of
 *      Calgary, Calgary, Alberta, Canada.  All rights reserved.
 *    
 *  Permission to use, copy, modify, and distribute this software and its
 *  documentation for any purpose and without fee is hereby granted, provided
 *  that the above copyright notice appears in all copies.  The University
 *  of Calgary makes no representations about the suitability of this
 *  software for any purpose.  It is provided "as is" without express or
 *  implied warranty.
 */

#ifndef __conference_h
#define __conference_h

#include <Dispatch/rpcpeer.h>
#include <OS/list.h>
#include <gk/confmonitor.h>



declarePtrList(ConferenceMonitorList, ConferenceMonitor);

class Conference : public RpcPeer {
public:

  /*
  ** constructor / destructor 
  */
  Conference(char* name, const char* coord_host, int coord_port, int confnum);
  ~Conference();

  /*
  ** notification routines for users joining and leaving; subclasses may
  ** redefine, and others can be attached -- see ConferenceMonitor class
  */
  virtual void newUser(AttributeList*);
  virtual void userLeaving(int id);

  /*
  ** create a new connection, either connecting to another Conference
  ** (actually a Coordinator which will forward the request to the 
  ** Conference) or accepting a connection from another Conference
  */
  virtual boolean createReaderAndWriter(const char* host, int port);
  virtual void createReaderAndWriter(int fd);

  /*
  ** messages received from other conferences
  */
  virtual void info_callback(char* msg, class Connection* c);
  virtual void connectTo(char* msg);
  virtual void youAreID(char* msg);
  virtual void removeUser(char *msg);
  virtual void deleteConference(char *msg);

  /*
  ** access methods
  */
  int localID();
  class InfoConnectionList* connections();
  ConferenceMonitorList* monitors();

protected:
  void connectionClose(class CallbackRpcReader*, int);
  class InfoConnectionList* conns_;
  class Connection* coord_;
  class ConferenceMonitorList* monitors_;
  int conferenceID_;
  AttributeList* our_attributes_;
  class IntList* info_needed_;
};

#endif


