/**************************************************************************
 *
 * Class:  ConferenceMonitor
 * Author: Mark Roseman
 *
 * A virtual base for classes who need to be informed when users join or 
 * leave a conference.  To be notified, simply append to the monitors_ list
 * in the Conference, e.g.
 *       conf->monitors()->append(this)
 * 
 *
 * Revision History:
 * 
 * Date     Modifier  Description
 * -------- --------- -------------------------------------------------------
 * 05/29/92 MR        initial version
 * 08/14/92 MR        clean up
 * 
 ***************************************************************************/

/*
 *  This file is part of GroupKit.
 *
 *  (c) Copyright 1992 Department of Computer Science, University of
 *      Calgary, Calgary, Alberta, Canada.  All rights reserved.
 *    
 *  Permission to use, copy, modify, and distribute this software and its
 *  documentation for any purpose and without fee is hereby granted, provided
 *  that the above copyright notice appears in all copies.  The University
 *  of Calgary makes no representations about the suitability of this
 *  software for any purpose.  It is provided "as is" without express or
 *  implied warranty.
 */

#ifndef __confmonitor_h
#define __confmonitor_h

class ConferenceMonitor {
public:
  virtual void newUser(class AttributeList*) = 0;
  virtual void userLeaving(int id) = 0;
};

#endif
