/**************************************************************************
 * 
 * File:   groupkit.h  (general constants)
 * Author: Mark Roseman
 * 
 * General constants etc. used by the different components of the toolkit.
 *
 * Revision History:
 * 
 * Date     Modifier  Description
 * -------- --------- -------------------------------------------------------
 * 02/17/92 MR        initial version
 * 10/22/92 MR        added stuff for colors, etc.
 *
 **************************************************************************/

/*
 *  This file is part of GroupKit.
 *
 *  (c) Copyright 1992 Department of Computer Science, University of
 *      Calgary, Calgary, Alberta, Canada.  All rights reserved.
 *    
 *  Permission to use, copy, modify, and distribute this software and its
 *  documentation for any purpose and without fee is hereby granted, provided
 *  that the above copyright notice appears in all copies.  The University
 *  of Calgary makes no representations about the suitability of this
 *  software for any purpose.  It is provided "as is" without express or
 *  implied warranty.
 */

#ifndef __groupkit_h
#define __groupkit_h

/*
** Size of the hash table used in the Reader classes.  The table is used
** to hold the callback functions.
*/

#define FUNCTBLSIZE	30

/*
** Size of hash table in the coordinator for holding conferences.
*/

#define CONFTBLSIZE	15


/*
** The different ID's of the callback functions for the Reader classes.
*/

enum {
  CONNCONFNUM,   
  NEWCONF,
  DELCONF,
  DISPCONF,
  ADDUSER,
  DELUSER,
  DISPUSER,
  CONFLIST,
  USERLIST,
  CURSORMOVE,
  INFOMSG,
  CONNECTTO,
  YOUAREID,
  ADDRREQ,
  ADDRRESP,
  SCRIBBLE,
  NEWVOTE,
  CASTVOTE,
  NEWOBJ,
  REQCHGSTAT,
  CHGSTAT,
  DELOBJ,
  DENYCHGSTAT,
  REQCHOWN,
  CANCHOWN,
  CHOWN,
  REQDESTROY,
  DESTROY,
  REQGRAB,
  OKTOGRAB,
  DENYGRAB,
  DRAGMSG,
  IDEA
};


#endif
