/**************************************************************************
 * 
 * Class:  InfoConnection and InfoConnectionList
 * Author: Mark Roseman
 * 
 * Connection that maintains a special callback, typically used for passing
 * information messages needed to work with the connection (e.g. ID number).
 * See also the ConnAction class which is used to trap these information
 * messages.  Similarly, a list of these InfoConnections.
 *
 * Revision History:
 * 
 * Date     Modifier  Description
 * -------- --------- -------------------------------------------------------
 * 05/28/92 MR        initial version
 * 08/14/92 MR        clean up
 * 09/17/92 MR        changed add routines to also return created connection
 *
 **************************************************************************/

/*
 *  This file is part of GroupKit.
 *
 *  (c) Copyright 1992 Department of Computer Science, University of
 *      Calgary, Calgary, Alberta, Canada.  All rights reserved.
 *    
 *  Permission to use, copy, modify, and distribute this software and its
 *  documentation for any purpose and without fee is hereby granted, provided
 *  that the above copyright notice appears in all copies.  The University
 *  of Calgary makes no representations about the suitability of this
 *  software for any purpose.  It is provided "as is" without express or
 *  implied warranty.
 */

#ifndef __infoconn_h
#define __infoconn_h

#include <gk/connection.h>


class InfoConnection : public Connection {
public:

  /*
  ** constructors
  */
  InfoConnection(char* host, int port, int id=-1, class ReaderCallbackTable* cb=nil, 
                 int info_msg_num=-1, class ConnAction* act= nil);
  InfoConnection(int fd, int id=-1, class ReaderCallbackTable* act= nil, 
                 int info_msg_num=-1, class ConnAction* act= nil);
  InfoConnection(rpcstream*, int id=-1, class ReaderCallbackTable* cb= nil, 
                 int info_msg_num=-1, class ConnAction* act= nil);

protected:
  int infomsg_;
  class ConnAction* infoCB_;
  void infoMsg(char *);
};


declarePtrList(InfoConnList, InfoConnection);

class InfoConnectionList : public ConnectionList {
public:
  
  /*
  ** constructor
  */
  InfoConnectionList(int info_msg_num=-1, class ConnAction* = nil);

  /*
  ** add new connections
  */
  virtual Connection* add(char* host, int port ,int id=-1);
  virtual Connection* add(int fd, int id=-1);
  virtual Connection* add(rpcstream*, int id=-1);

protected:
  int infomsg_;
  class ConnAction* infoCB_;
};

#endif
