/***************************************************************************
 *
 * Class:  RpcAction
 * Author: Mark Roseman
 *
 * An action whose execute function takes a CallbackRpcReader and a file 
 * descriptor as parameters.  This is used by the CallbackRpcReader class as 
 * a callback for when socket connections are broken.
 * 
 * This code is based on ...iv/src/include/InterViews/action.h in the 
 * InterViews distribution.
 *
 *
 * Revision History:
 * 
 * Date     Modifier  Description
 * -------- --------- -------------------------------------------------------
 * 09/17/92 MR        initial version
 * 
 ***************************************************************************/

/*
 *  This file is part of GroupKit.
 *
 *  (c) Copyright 1992 Department of Computer Science, University of
 *      Calgary, Calgary, Alberta, Canada.  All rights reserved.
 *    
 *  Permission to use, copy, modify, and distribute this software and its
 *  documentation for any purpose and without fee is hereby granted, provided
 *  that the above copyright notice appears in all copies.  The University
 *  of Calgary makes no representations about the suitability of this
 *  software for any purpose.  It is provided "as is" without express or
 *  implied warranty.
 */

#ifndef __rpcaction_h
#define __rpcaction_h

#include <InterViews/resource.h>


class RpcAction : public Resource {
protected:
    RpcAction() {}
    virtual ~RpcAction() {}
public:
    virtual void execute(class CallbackRpcReader*, int) = 0;
};


/*
 * RpcAction denoted by an object and member function to call on the object.
 */

#if defined(__STDC__) || defined(__ANSI_CPP__)
#define __RpcActionCallback(T) T##_RpcActionCallback
#define RpcActionCallback(T) __RpcActionCallback(T)
#define __RpcActionMemberFunction(T) T##_RpcActionMemberFunction
#define RpcActionMemberFunction(T) __RpcActionMemberFunction(T)
#else
#define __RpcActionCallback(T) T/**/_RpcActionCallback
#define RpcActionCallback(T) __RpcActionCallback(T)
#define __RpcActionMemberFunction(T) T/**/_RpcActionMemberFunction
#define RpcActionMemberFunction(T) __RpcActionMemberFunction(T)
#endif

#define declareRpcActionCallback(T) \
typedef void T::RpcActionMemberFunction(T)(class CallbackRpcReader*, int); \
class RpcActionCallback(T) : public RpcAction { \
public: \
    RpcActionCallback(T)(T*, RpcActionMemberFunction(T)*); \
\
    virtual void execute(class CallbackRpcReader*, int); \
private: \
    T* obj_; \
    RpcActionMemberFunction(T)* func_; \
};

#define implementRpcActionCallback(T) \
RpcActionCallback(T)::RpcActionCallback(T)(T* obj, RpcActionMemberFunction(T)* func) { \
    obj_ = obj; \
    func_ = func; \
} \
\
void RpcActionCallback(T)::execute(class CallbackRpcReader* r, int fd) { (obj_->*func_)(r,fd); }

#endif
