/***************************************************************************
 * Class:  Sketchpad
 * Author: Mark Roseman
 * 
 * Bitmap sketchpad glyph.  Based on original prototype.
 * 
 * Revision History:
 * 
 * Date     Modifier  Description
 * -------- --------- -------------------------------------------------------
 * 06/15/92 MR        initial version
 * 
 ****************************************************************************/

/*
 *  This file is part of GroupKit.
 *
 *  (c) Copyright 1992 Department of Computer Science, University of
 *      Calgary, Calgary, Alberta, Canada.  All rights reserved.
 *    
 *  Permission to use, copy, modify, and distribute this software and its
 *  documentation for any purpose and without fee is hereby granted, provided
 *  that the above copyright notice appears in all copies.  The University
 *  of Calgary makes no representations about the suitability of this
 *  software for any purpose.  It is provided "as is" without express or
 *  implied warranty.
 */

#ifndef __sketchpad_h
#define __sketchpad_h

#include <gk/overlay.h>

class Sketchpad : public Overlay {
public:
    Sketchpad( ActiveHandler*, class Style*, class Conference*);
    virtual void press(const Event &);
    virtual void drag(const Event&);
    virtual void release(const Event &);
    virtual void doLine(int,int,int,int);
    void remoteScribble(char *);
    void bresline( int, int, int, int);
private:
    Coord dX(void);
    Coord dY(void);
    class Bitmap* bitmap_;
    class Patch* patch_;
    Coord lastx_, lasty_;
    class Display* display_;
};

#endif
