/***************************************************************************
 *
 * Class:  IntAction
 * Author: Mark Roseman
 *
 * An action whose execute function takes two int parameters.
 * 
 * This code is based on ...iv/src/include/InterViews/action.h in the 
 * InterViews distribution.
 *
 *
 * Revision History:
 * 
 * Date     Modifier  Description
 * -------- --------- -------------------------------------------------------
 * 09/17/92 MR        initial version
 * 
 ***************************************************************************/

#ifndef __intaction_h
#define __intaction_h

// #include <InterViews/resource.h>
#include <InterViews/action.h>

class IntAction : public Action {
protected:
    IntAction() {}
    virtual ~IntAction() {}
    int p1,p2;
public:
    virtual void execute() = 0;
};


/*
 * IntAction denoted by an object and member function to call on the object.
 */

#if defined(__STDC__) || defined(__ANSI_CPP__)
#define __IntActionCallback(T) T##_IntActionCallback
#define IntActionCallback(T) __IntActionCallback(T)
#define __IntActionMemberFunction(T) T##_IntActionMemberFunction
#define IntActionMemberFunction(T) __IntActionMemberFunction(T)
#else
#define __IntActionCallback(T) T/**/_IntActionCallback
#define IntActionCallback(T) __IntActionCallback(T)
#define __IntActionMemberFunction(T) T/**/_IntActionMemberFunction
#define IntActionMemberFunction(T) __IntActionMemberFunction(T)
#endif

#define declareIntActionCallback(T) \
typedef void T::IntActionMemberFunction(T)(int,int); \
class IntActionCallback(T) : public IntAction { \
public: \
    IntActionCallback(T)(T*, IntActionMemberFunction(T)*, int, int); \
\
    virtual void execute(); \
private: \
    T* obj_; \
    IntActionMemberFunction(T)* func_; \
};

#define implementIntActionCallback(T) \
IntActionCallback(T)::IntActionCallback(T)(T* obj, IntActionMemberFunction(T)* func, int p1_, int p2_) { \
    obj_ = obj; \
    func_ = func; \
    p1 = p1_; \
    p2 = p2_; \
} \
\
void IntActionCallback(T)::execute() { (obj_->*func_)(p1,p2); }

#endif



