/**************************************************************************
 * 
 * Class:  RegClientDisplay
 * Author: Mark Roseman
 * 
 * This class provides a simple user interface to the OpenRegClient,
 * giving a view of the conferences_ list (as well as a list of the
 * users of a selected conference).  Users can select to create new
 * conferences, join existing ones, or leave a selected conference.
 *
 * Revision History:
 * 
 * Date     Modifier  Description
 * -------- --------- -------------------------------------------------------
 * 05/28/92 MR        initial version
 * 06/08/92 MR        added support for reading conference types from resources
 * 08/14/92 MR        clean up
 * 09/13/92 MR        fixed for iv3.1b2 release
 * 09/21/92 MR        took out the leave conference button (for now anyway)
 *
 **************************************************************************/

/*
 *  This file is part of GroupKit.
 *
 *  (c) Copyright 1992 Department of Computer Science, University of
 *      Calgary, Calgary, Alberta, Canada.  All rights reserved.
 *    
 *  Permission to use, copy, modify, and distribute this software and its
 *  documentation for any purpose and without fee is hereby granted, provided
 *  that the above copyright notice appears in all copies.  The University
 *  of Calgary makes no representations about the suitability of this
 *  software for any purpose.  It is provided "as is" without express or
 *  implied warranty.
 */
 
#ifndef __rcdisplay_h
#define __rcdisplay_h

#define MAXCONFS    100


#include <InterViews/monoglyph.h>

class RegClientDisplay : public MonoGlyph {
public:
  
  /*
  ** constructor 
  */
  RegClientDisplay(class OpenRegClient*, class WidgetKit*);

  /*
  ** the conference or user lists should be updated
  */
  virtual void updateConference();
  virtual void updateUsers(int);

  /*
  ** unfortunate hack -- to use the dialogs, we have to say what window we
  ** want them positioned over; this remains public so whoever creates us
  ** can fill it in
  */
  class Window* win_;

protected:
  virtual Glyph* makeGlyph(void);

  void requestNewConference(void);
  void requestJoinConference(void);
  void requestLeaveConference(void);
  void requestViewConference(void);

  void accept1(class FieldEditor*);
  void cancel1(class FieldEditor*);
  void accept();
  void cancel();

  class StringBrowser* confs;
  class StringBrowser* users;
  class OpenRegClient* rc_;
  class Dialog* dialog_;
  class WidgetKit* kit_;
  int conf_id[MAXCONFS];
};

  
#endif
