/****************************************************************************
 * 
 * Class:  Registrar main program
 * Author: Mark Roseman
 * 
 * Revision History:
 * 
 * Date     Modifier  Description
 * -------- --------- -------------------------------------------------------
 * 02/17/92 MR        initial version
 * 08/14/92 MR        changed to use XDefaults for registrar path
 * 09/20/92 MR        works via host/port rather than RpcPeer registration
 *
 ****************************************************************************/

#include "registrar.h"
#include <gk/groupsession.h>
#include <InterViews/style.h>
#include <OS/string.h>
#include <OS/host.h>
#include <stdio.h>
#include <string.h>

static PropertyData props[] = {
  { "*ForceRegistrarHost", "off" },
  { nil }
};

static OptionDesc options[] = {
  { "-force", "*ForceRegistrarHost", OptionValueImplicit, "on" },
  { "port=",  "*RegistrarPort", OptionValueAfter },
  { nil }
};

main(int argc, char** argv) {
  GroupSession* session = new GroupSession("Registrar", argc, argv, options, props);
  String *host = new String();
  long port;
  if(session->style()->find_attribute("RegistrarHost", *host)) {
    if (session->style()->find_attribute("RegistrarPort", port)) {
      if(( strcmp(host->string(), session->host_name()) == 0) || 
	   session->style()->value_is_on("ForceRegistrarHost")) {
	Registrar* reg = new Registrar((int)port);
	reg->run();
      } else {
	fprintf(stderr, "Registrar: should be run on %s instead of %s.\n",
		host->string(), session->host_name());
	fprintf(stderr, "           Use \"registrar -force\" to override.\n");
      }
    } else
      fprintf(stderr, "Registrar: Could not get the RegistrarPort.\n");
  } else
    fprintf(stderr, "Registrar: Could not get the RegistrarHost.\n");
  delete session;
}
