/**************************************************************************
 * 
 * Class:  Connection implementation
 * Author: Mark Roseman
 * 
 * Revision History:
 * 
 * Date     Modifier  Description
 * -------- --------- -------------------------------------------------------
 * 02/17/92 MR        initial version
 * 05/17/92 MR        added findConnection
 * 05/28/92 MR        redid to work with CallbackRpcReader and RpcWriter
 * 09/20/92 MR        error checks on createReaderAndWriter
 *
 **************************************************************************/

/*
 *  This file is part of GroupKit.
 *
 *  (c) Copyright 1992 Department of Computer Science, University of
 *      Calgary, Calgary, Alberta, Canada.  All rights reserved.
 *    
 *  Permission to use, copy, modify, and distribute this software and its
 *  documentation for any purpose and without fee is hereby granted, provided
 *  that the above copyright notice appears in all copies.  The University
 *  of Calgary makes no representations about the suitability of this
 *  software for any purpose.  It is provided "as is" without express or
 *  implied warranty.
 */

#include <Dispatch/rpcstream.h>

#include <gk/reader.h>
#include <gk/writer.h>
#include <gk/connection.h>
#include <gk/groupkit.h>
#include <gk/msgsender.h>
#include <stdio.h>

implementPtrList(ConnList, Connection);


/**************************************************************************
 * 
 * Constructors for creating connections via host/port, file descriptor,
 * or rpcstream.
 *
 **************************************************************************/

Connection::Connection(const char* host, int port, int id, 
		       ReaderCallbackTable* tbl) : id_(id), callbacks_(tbl) 
{
  if( callbacks_ == nil) 
    callbacks_ = new ReaderCallbackTable(FUNCTBLSIZE);
  writer_ = new Writer( host, port );
  if(writer_->server()) 
    reader_ = new CallbackRpcReader(&writer_->server(), callbacks_, id_);
}


Connection::Connection(int fd, int id, ReaderCallbackTable* tbl) : 
       id_(id), callbacks_(tbl) 
{
  if( callbacks_ == nil) 
    callbacks_ = new ReaderCallbackTable(FUNCTBLSIZE);
  writer_ = new Writer( fd );
  if(writer_->server()) 
    reader_ = new CallbackRpcReader(&writer_->server(), callbacks_, id_);
}


Connection::Connection(rpcstream* server, int id, ReaderCallbackTable* tbl) : 
        id_(id), callbacks_(tbl) 
{
  if( callbacks_ == nil) 
    callbacks_ = new ReaderCallbackTable(FUNCTBLSIZE);
  writer_ = new Writer( server );
  if(writer_->server()) 
    reader_ = new CallbackRpcReader(&writer_->server(), callbacks_, id_);
}


/**************************************************************************
 * 
 * Destructor.  Needs a bit more thought!
 *
 **************************************************************************/

Connection::~Connection() { }


/**************************************************************************
 * 
 * Wrapper methods for instance variables.
 *
 **************************************************************************/

ReaderCallbackTable* Connection::callbacks(void) { return callbacks_; }
CallbackRpcReader* Connection::reader() { return reader_; }
Writer* Connection::writer() { return writer_; }


/**************************************************************************
 * 
 * Constructor for connection list.
 *
 **************************************************************************/

ConnectionList::ConnectionList() {
  callbacks_ = new ReaderCallbackTable(FUNCTBLSIZE);
  list_ = new ConnList();
}

/**************************************************************************
 * 
 * Destructor.
 *
 **************************************************************************/

ConnectionList::~ConnectionList() {
  delete callbacks_;
  delete list_;      // redo later to get rid of individual list items
}

/**************************************************************************
 * 
 * Wrapper methods for instance variables.
 *
 **************************************************************************/

ConnList* ConnectionList::list() { return list_; }
ReaderCallbackTable* ConnectionList::callbacks(void) { return callbacks_; }


/**************************************************************************
 * 
 * Routines to add a new connection to the list.
 *
 **************************************************************************/

Connection* ConnectionList::add(char* host, int port, int id) {
  Connection* c = new Connection(host,port,id, callbacks());
  if(c->writer()->server()) {
    list()->append( c );
    return c;
  } else 
    return nil;
}

Connection* ConnectionList::add(int fd, int id) {
  Connection* c = new Connection(fd, id, callbacks());
  list()->append( c );
  return c;
}

Connection* ConnectionList::add(rpcstream* server, int id) {
  Connection* c = new Connection (server, id, callbacks() );
  list()->append( c );
  return c;
}


/**************************************************************************
 * 
 * Find a particular user in the list by ID number.
 *
 **************************************************************************/

long ConnectionList::find(int id) {
  long i;
  for ( i=0L; i< list_->count(); i++)
    if(list_->item(i)->id_ == id)
      return i;
  return -1;
}


/**************************************************************************
 * 
 * Send a message to a particular user.
 *
 **************************************************************************/

void ConnectionList::sendTo(int id, MsgSender* messenger) {
  long idx;
  if ( (idx = find(id)) != -1)
    messenger->sendOn ( list()->item(idx)->writer() );
}


/**************************************************************************
 * 
 * Send a message to all users.
 *
 **************************************************************************/

void ConnectionList::toAll(MsgSender* messenger) {
  for ( ListItr(ConnList) i(*list()); i.more(); i.next()) {
    Connection* conn = i.cur();
    messenger->sendOn( conn->writer() );
  }
}

