/*
 * Gems
 */

#ifndef gems_h
#define gems_h

#include <InterViews/boolean.h>

class Session;
class Style;
class Display;
class SimulationController;
class Cursor;
class ColorScale;
//class server;
class client;

class Gems {
protected:
  Gems(Session* session, Style* style =nil, Display* display =nil);

public:
  ~Gems();

  static Gems* instance(
       Session* session =nil, Style* style =nil, Display* display =nil);

  int run();
  boolean dispatch();

  Style* style() { return(_style); }
  Session* session() { return(_session); }
  Display* display() { return(_display); }
  SimulationController* controller() { return(_simulation_controller); }
  char* datapath(char* append =nil);
  static void error(char* message =nil);
  ColorScale* color_scale() { return(_color_scale); }

  enum CursorType { hand };
  Cursor* cursor(CursorType t);
  boolean color();

  client* _air_db;  

private:
  SimulationController* _simulation_controller;
  static Gems* _instance;
  Session* _session;
  Style* _style;
  Display* _display;
  ColorScale* _color_scale;

  void cursor_init();
  Cursor* _hand_cursor;
};

#endif

