#ifndef query_h
#define query_h
#include <InterViews/patch.h>

class Map;

/*
 * Graphics
 */

#include "figure.h"
#include "toolbox_tools.h"
#include "selection.h"


class TPolyline : public Polyline {
public:
  TPolyline(const Color* fill, Coord* x, Coord* y, int count, Map*);
  ~TPolyline();
  virtual void draw(Canvas*, const Allocation&) const;
protected:
  Map* _map;
private:
};

class TPolygon : public Polygon {
public:
  TPolygon(const Color* fill, Coord* x, Coord* y, int count, Map*);
  ~TPolygon();
  virtual void draw(Canvas*, const Allocation&) const;
protected:
  Map* _map;
private:
}; 

class TRectangle : public Rectangle {
public:
  TRectangle(const Color* fill, Coord l, Coord b, Coord r, Coord t, Map*);
  ~TRectangle();
  virtual void draw(Canvas*, const Allocation&) const;
protected:
  Map* _map;
private:
}; 


class Street : public TPolyline {
public:
  Street(
        Coord* x, Coord* y, int count, char* name, Map* map,
	const Color* = nil);
  void set_name(char* name);
  ~Street();
private:
  virtual void press(Event&);
  char* _name;
};

class Area : public TPolygon {
public:
  Area(
        Coord* x, Coord* y, int count, char* name, Map* map,
        const Color* = nil
    );
 void set_name(char* name);
  ~Area();
private:
  virtual void press(Event&);
  char* _name;
};

class Grid : public TRectangle {
public:
  Grid(
       Coord l, Coord b, Coord r, Coord t, char* name, Map* map,
       const Color* = nil
       );
  void set_name(char* name);
  ~Grid();
private:
  virtual void press(Event&);
  char* _name;
};

/*
 * Tools
 */

class MapView : public MapViewTool {
public:
  MapView(
       Map* map, Coord label_width, Coord list_height, Coord list_width, 
       char* item1 =nil, char* item2 =nil,
       char* item3 =nil, char* item4 =nil,
       char* item5 =nil, char* item6 =nil,
       char* item7 =nil, char* item8 =nil,
       char* item9 =nil, char* item10 =nil
   );
protected:
  virtual void grids();

private:
  Map* _map;
};

#endif
