/*
 * Selection class - used to keep track of currently selected objects
 */

#ifndef selection_h
#define selection_h

#include <OS/list.h>

#include "figure.h"
#include "selector.h"
#include "map.h"

class Map;

declareList(FigureList, Figure*);

class Selection {
public:
  Selection(Map*);
  ~Selection();
  FigureList* get_selected() {return (_selected);}
  void add_selection(Figure*);
  void replace_selection(Figure*);
  Brush* unselected_brush() {return (_unselected_brush);}
  Brush* selected_brush() {return (_selected_brush);}
  Color* area_border() {return (_area_border);}
  Color* street_border() {return (_street_border);}
  Color* grid_border() {return (_grid_border);}
private:
  FigureList* _selected;
  Brush* _unselected_brush;
  Brush* _selected_brush;
  Color* _area_border;
  Color* _street_border;
  Color* _grid_border;
  Map* _map;
};

#endif
