/*
 * Simulation
 */

#include <InterViews/background.h>
#include <InterViews/box.h>
#include <InterViews/center.h>
#include <InterViews/display.h>
#include <InterViews/glue.h>
#include <InterViews/bitmap.h>
#include <InterViews/color.h>
#include <InterViews/label.h>
#include <InterViews/margin.h>
#include <InterViews/session.h>
#include <InterViews/style.h>
#include <InterViews/window.h>
#include <InterViews/action.h>
#include <InterViews/stencil.h>
#include <InterViews/canvas.h>
#include <InterViews/deck.h>
#include <InterViews/border.h>
#include <InterViews/patch.h>
#include <InterViews/page.h>
#include <InterViews/brush.h>
#include <InterViews/shapeof.h>
#include <InterViews/event.h>
#include <InterViews/hit.h>
#include <InterViews/listener.h>

#include <stream.h>

#include "gems.h"
#include "simulation.h"

/*
 * Simulation
 */

Simulation::Simulation(SimulationController* controller)
{
  _controller = controller;
  _running = false;

  _day = 0;
  _month = 0;
  _year = 0;
}

void Simulation::start()
{
  printf("Simulation::start()\n");

  _running = true;

  if (_controller)
    _controller->append(this);
}

void Simulation::stop()
{
 printf("Simulation::stop()\n");

 _running = false;

 if (_controller)
   _controller->remove(this); 
}

void Simulation::pause()
{ 
  printf("Simulation::pause()\n");

  if (_running)
    Simulation::stop();
  else
    Simulation::start();
}

void Simulation::update()
{ 
  printf("Simulation::update()\n");
}

/*
 * DynamicSimulation
 */

DynamicSimulation::DynamicSimulation(SimulationController *controller)
       : Simulation(controller)
{
  _update_counter = 0;
  _update_step = 100;

  // default time is one day

  _time_start = 0;
  _time_stop = 60*60*24 - 1;
  time_step(100);
}

void DynamicSimulation::update()
{ 
  //  printf("DynamicSimulation::update()\n");
  
  if (_time_display_action && (++_update_counter > _update_step))
    _time_display_action->execute();

  _time_counter += _time_step;
}

void DynamicSimulation::start()
{
  Simulation::start();
  _time_counter = _time_start;
}

void DynamicSimulation::stop()
{
  Simulation::stop();
}

/*
 * SimulationController
 */

implementList(SimulationList, Simulation*);

SimulationController::SimulationController()
{
  _simulation_list = new SimulationList();
}

SimulationController::~SimulationController()
{
  delete _simulation_list;
}

void SimulationController::append(Simulation* s)
{
  printf("SimulationController::append()\n");

  if (!contains(s)) {
    printf("\tappending\n");
    _simulation_list->append(s);
  }
}

void SimulationController::remove(Simulation* s)
{
  long index = lookup(s);

  if (index >= 0)
    _simulation_list->remove(index);
}

boolean SimulationController::contains(Simulation* s)
{
  return(lookup(s) >= 0);
}

void SimulationController::run()
{
  printf("SimulationController::run()\n");
  printf("\t_simulation_list->count()=%d\n", _simulation_list->count()); 

  while(_simulation_list->count() && Gems::instance()->dispatch()) 
    for (long i = 0 ; (i < _simulation_list->count()) ; ++i)
      _simulation_list->item(i)->update();
}

long SimulationController::lookup(Simulation* s)
{
  for (long i = 0 ; i < _simulation_list->count() ; ++i)
    if (s == _simulation_list->item(i))
      return(i);

  return(-1);
}
