/* File: simulation_tools.h
 * Created: 4/26/92 by John Butare(jb7p@andrew.cmu.edu)
 * Description:
 *	
 * Modifications:
 */

#ifndef simulation_tools_h
#define simulation_tools_h

#include <InterViews/monoglyph.h>
#include <InterViews/patch.h>

#include <IV-look/adjustable.h>

class ParticleTracker;
class GemsTextEditor;

/*
 * SimulationToolbox
 */

class SimulationTool;
class ToolboxListBox;

class SimulationToolbox : public Patch, public Adjustable {
public:
  SimulationToolbox(ToolboxListBox* toolbox_list_box);
  ~SimulationToolbox();

  virtual void append(Glyph*);
  virtual void append(SimulationTool*);
  virtual void remove(GlyphIndex);
  virtual void remove(Glyph*);
  Glyph* controls() { return(_control_patch); }
  ToolboxListBox* toolbox_list_box() { return(_toolbox_list_box); }
  SimulationTool* current();

 virtual void scroll_forward(DimensionName =Dimension_X);
 virtual void scroll_backward(DimensionName =Dimension_X);
 
 virtual Coord lower(DimensionName) const { return(0.0); }
 virtual Coord upper(DimensionName) const { return(0.0); }
 virtual Coord length(DimensionName) const { return(0.0); }
 virtual Coord cur_lower(DimensionName) const { return(0.0); }
 virtual Coord cur_upper(DimensionName) const { return(0.0); }
 virtual Coord cur_length(DimensionName) const { return(0.0); }
 
private:
  void control(boolean on);
  void enable();
  void update_display();
  void use(GlyphIndex index);

  class Deck* _deck;
  class ToolboxListBox* _toolbox_list_box;
  class GemsLabel* _display;
  Deck* _control;
  Glyph* _empty_control;
  Patch* _control_patch; 
  class SimulationToolList* _tool_list;
};

/*
 * SimulationTool
 */

class SimulationTool : public MonoGlyph {
public:
  SimulationTool(SimulationToolbox*);

  virtual void quit_cb();
  virtual void update_toolbox() { }
  virtual void update_value(GlyphIndex) { }
  GemsTextEditor* editor(GlyphIndex);
  
protected:
  SimulationToolbox* _simulation_toolbox;
};

/* 
 * ChemistrySimulationTool
 */

class ChemistrySimulationTool : public SimulationTool {
public:
  ChemistrySimulationTool(SimulationToolbox*);
  ~ChemistrySimulationTool();

  virtual void simulation(char* s);
  virtual char* simulation();

  virtual void chemical1(char* s);
  virtual char* chemical1();

  virtual void chemical2(char* s);
  virtual char* chemical2();
  
  virtual void height(float);
  virtual float height();

  virtual void set_date(int& month, int& day, int& year);
  virtual void get_date(int month, int day, int year);

  virtual void chemical1_cb() { };
  virtual void chemical2_cb() { };
  virtual void height_cb() { };
  virtual void date_cb() { };

  virtual void update_toolbox();
  virtual void update_value(GlyphIndex);

protected:
  enum { simulation_index=1, chemical1_index, chemical2_index, height_index, date_index };

  char* _simulation;
  char* _chemical1;
  char* _chemical2;

  int _month, _day, _year;
  float _height;
};

/*
 * ParticleTrackerTool
 */

class ParticleTrackerTool : public ChemistrySimulationTool {
public:
  ParticleTrackerTool(SimulationToolbox*, ParticleTracker*);
  ~ParticleTrackerTool();

  /*
   * Callbacks
   */

  virtual void start_cb();
  virtual void stop_cb();
  virtual void pause_cb();
  virtual void quit_cb();

  virtual void clear_particles_cb();
  virtual void clear_sources_cb();

  virtual void time_step_cb();
  virtual void release_step_cb();
  virtual void move_step_cb();
  virtual void height_cb();
  virtual void date_cb();

  virtual void sources_visible_cb();
  virtual void time_display_cb();
  virtual void update_toolbox();

private:
  GemsTextEditor* _time_step_editor;
  GemsTextEditor* _release_step_editor;
  GemsTextEditor* _move_step_editor;
  class GemsLabel* _time_display;

  class RBBox* _controls;
  class ToggleButton* _pause;
  class ToggleButton* _sources_visible;
  boolean _sources_visible_flag;
  ParticleTracker* _particle_tracker;
};

#endif
