/* File: toolbox.c
 * Created: 3/26/92 by John Butare(jb7p@andrew.cmu.edu)
 * Description:
 *	
 * Modifications:
 */

/*
 * Toolbox - a class for creating a GEMS toolbox
 */

#include <InterViews/background.h>
#include <InterViews/box.h>
#include <InterViews/display.h>
#include <InterViews/glue.h>
#include <InterViews/margin.h>
#include <InterViews/session.h>
#include <InterViews/style.h>
#include <InterViews/window.h>
#include <InterViews/action.h>
#include <InterViews/deck.h>
#include <InterViews/patch.h>

#include <IV-look/menu.h>
#include <IV-look/kit.h>

#include <OS/list.h>
#include <OS/string.h>

#include <stdio.h>

#include <UI/rbbox.h>

#include "gems.h"
#include "toolbox.h"
#include "toolbox_tools.h"

Coord natural(Glyph* g, DimensionName dimension);

/*
 * Toolbox
 *
 * A toolbox contains various tools.  Each tool has an icon.  When the icon
 * is pressed, the tool is displayed in the tool area.
 */

declareList(ToolList, ToolboxTool*);
implementList(ToolList, ToolboxTool*);

Toolbox::Toolbox(
       ToolboxTool *tool1, ToolboxTool *tool2, 
       ToolboxTool *tool3, ToolboxTool *tool4,
       ToolboxTool *tool5, ToolboxTool *tool6,
       ToolboxTool *tool7, ToolboxTool *tool8,
       ToolboxTool *tool9, ToolboxTool* tool10
   )
{
  Kit* kit = Kit::instance();
  Style* style = Gems::instance()->style();
  Display* display = Gems::instance()->display();

  Glyph* stretch_vsep = new VGlue(2.0, fil, 0.0);
  Glyph* fixed_vsep = new VGlue(2.0, 0.0, 0.0);
  Glyph* stretch_hsep = new HGlue(2.0, fil, 0.0);
  Glyph* fixed_hsep = new HGlue(2.0, 0.0, 0.0);

  _tool_area_deck = new Deck();
  _tool_area_deck->flip_to(0);
  _tool_area = new Patch(_tool_area_deck);
  _tool_list = new ToolList();
  _icon_area = new RBBox(new TBBox(new VGlue(0.0, 0.0, 0.0), stretch_vsep));

  if (tool1 != nil) append(tool1);
  if (tool2 != nil) append(tool2);
  if (tool3 != nil) append(tool3);
  if (tool4 != nil) append(tool4);
  if (tool5 != nil) append(tool5);
  if (tool6 != nil) append(tool6);
  if (tool7 != nil) append(tool7);
  if (tool8 != nil) append(tool8);
  if (tool9 != nil) append(tool9);
  if (tool10 != nil) append(tool10);

  /* 
   * Fix the icon box since all the tools are in, and then choose the
   * first tool.
   */
  _icon_area->choose(1);

  /*
   * Toolbox menu
   */

  Menu* menubar = kit->menubar(style);
  
  Menu* pull1 = kit->pulldown(style);
  Telltale* pullname1 = kit->menubar_item(kit->label("File", style), style);
  pull1->add_item(kit->menu_item(kit->label("New", style), style));
  pull1->add_item(kit->menu_item(kit->label("Open", style), style));
  pull1->add_item(kit->menu_item(kit->label("Close", style), style));
  pull1->add_item(kit->menu_item(kit->label("Save", style), style));
  pull1->add_item(kit->menu_item_separator(style));
  pull1->add_item(kit->menu_item(kit->label("Quit", style), style), kit->quit());
  menubar->add_item(pullname1, pull1);

  Menu* pull2 = kit->pulldown(style);
  Telltale* pullname2 = kit->menubar_item(kit->label("Edit", style), style);
  pull2->add_item(kit->menu_item(kit->label("Undo", style), style));
  pull2->add_item(kit->menu_item_separator(style));
  pull2->add_item(kit->menu_item(kit->label("Copy", style), style));
  pull2->add_item(kit->menu_item(kit->label("Cut", style), style));
  pull2->add_item(kit->menu_item(kit->label("Paste", style), style));
  menubar->add_item(pullname2, pull2);

  Menu* pull3 = kit->pulldown(style);
  Telltale* pullname3 = kit->menubar_item(kit->label("Help", style), style);
  pull3->add_item(kit->menu_item(kit->label("Help on...", style), style));
  pull3->add_item(kit->menu_item(kit->label("Help with GEMS", style), style));
  pull3->add_item(kit->menu_item(kit->label("Help with Help", style), style));
  menubar->add_item(pullname3, pull3);
  
  /*
   * Toolbox Layout
   */

  Glyph* toolbox =
    new Background(
       new TBBox(
       	   new VGlue(0.0, 0.0, 0.0),
	   fixed_vsep,
	   new LRBox(fixed_hsep, menubar, fixed_hsep),
    	   new LRBox(
       	       new HGlue(0.0, 0.0, 0.0),
	       fixed_hsep,	
       	       _icon_area,			 
	       fixed_hsep,
	       kit->outset_frame(fixed_hsep, style),
	       fixed_hsep,
	       new Margin(_tool_area, 2.0),
	   ),
       ),
       style->flat()
   );

  /*
   * Toolbox Window
   */

  _window = new ApplicationWindow(toolbox);
  _window->name("GEMS Toolbox");
  _window->place(10.0, display->height() / 2);
  _window->align(0.0, 0.0);
  _window->map();

}

Toolbox::~Toolbox()
{
  while (_tool_list->count() > 0) {
    delete _tool_list->item(0);
    _tool_list->remove(0);
  }
  delete _tool_list;
}

void Toolbox::append(ToolboxTool* tool) {
  Kit* kit = Kit::instance();
  Style* style = Gems::instance()->style();

  Glyph* stretch_vsep = new VGlue(2.0, fil, 0.0);

  tool->toolbox(this);
  tool->index(_tool_list->count());
  _tool_list->append(tool);

  _tool_area->append(tool->tool());
  _icon_area->append(tool->icon(), style, tool->select_action());
  _icon_area->append(stretch_vsep);
}	     
		   
void Toolbox::use(ToolboxTool* tool)
{
  _tool_area_deck->flip_to(tool->index());
  _tool_area->reallocate();
  _tool_area->redraw();
}

Coord natural(Glyph* g, DimensionName dimension)
{
  Requisition requisition;

  g->request(requisition);
  Requirement& r = requisition.requirement(dimension);
  if (r.defined())
    return(r.natural());
  else {
    printf("undefined requirement!\n");
    return(0.0);
  }
}
