/* File: toolbox_tools.h
 * Created: 3/26/92 by John Butare(jb7p@andrew.cmu.edu)
 * Description:
 *	
 * Modifications:
 */

#ifndef toolbox_tools_h
#define toolbox_tools_h

#include <InterViews/patch.h>

class Action;
class Toolbox;
class ToolboxTool;
class Map;
class RBBox;
class SimulationToolbox;
class GemsTextEditor;
class StringList;

/*
 * ToolboxListBox
 */
class ToolboxListBox : public Patch {
public:
  ToolboxListBox(
       ToolboxTool* toolbox_tool, Coord label_width, 
       Coord list_height, Coord list_width
   );

  ~ToolboxListBox();
  
  virtual void use(GlyphIndex);
  GlyphIndex current();
  GemsTextEditor* editor(GlyphIndex);
  int choice();
  char* value();

  RBBox* labels() { return(_labels); }
  Glyph* editors() { return(_editors); }
  Glyph* parameters() { return(_parameters); }
  SimulationToolbox* simulation_toolbox() { return(_simulation_toolbox); }
  Glyph* structure() { return(_structure); }

  void append_list(char* label, StringList* list);
  void replace_list(GlyphIndex i, StringList* list);

private:
  Glyph* _structure;
  Glyph* create_editor(
       Glyph* label, char* default_text, Action* ok);
  void button_press();
  void editor_ok();

  RBBox* _labels;
  Action* _ok_action;
  Action* _button_press_action;
  Glyph* _editors;
  Glyph* _parameters;
  Glyph* _lists;
  SimulationToolbox* _simulation_toolbox;

  class Deck* _deck;
  class ToolboxEditorList* _editor_list;
  ToolboxTool* _toolbox_tool;
};

/*
 * ToolboxTool
 *
 * Base class to hold and a tool and it's associated icon.
 * It is a subclass of action because the class is used as the
 * action procedure for the selection of the tool.
 */

class ToolboxTool {
public:
  ToolboxTool(Coord label_width, Coord list_height, Coord list_width);
  virtual ~ToolboxTool() { };

  void toolbox(Toolbox *toolbox) { _toolbox = toolbox; }

  void index(GlyphIndex index) { _index = index; }
  GlyphIndex index() { return(_index); }

  void icon(char* bitmap_file_name, char* tiff_file_name =nil);
  Glyph* icon() { return(_icon); }

  Glyph* tool() { return(_tool); }
  class Action* select_action() { return(_select_action); }

  int choice() { return(_list_box->choice()); }
  char* value() { return(_list_box->value()); }

  virtual void ok_cb() { };
  virtual void help_cb() { };

  virtual void append_list(char* label, StringList* list);
  virtual void replace_list(GlyphIndex i, StringList* list);

protected:
  virtual void select();

  Glyph* _icon;
  Glyph* _tool;
  Toolbox* _toolbox;
  GlyphIndex _index;
  Action* _select_action;
  
  ToolboxListBox* _list_box;
  
};


/*
 * MapViewTool
 */

class MapViewTool : public ToolboxTool {
public:
  MapViewTool(
       Coord label_width, Coord list_height, Coord list_width, 
       char* item1 =nil, char* item2 =nil,
       char* item3 =nil, char* item4 =nil,
       char* item5 =nil, char* item6 =nil,
       char* item7 =nil, char* item8 =nil,
       char* item9 =nil, char* item10 =nil
   );

  MapViewTool();

  virtual void ok_cb();
  virtual void help_cb();
  virtual void view_cb();

protected:
  RBBox* _view;
  boolean _view_on;
  GlyphIndex _view_item;
};

/*
 * WhereIsTool
 */

class WhereIsTool : public ToolboxTool {
public:
  WhereIsTool(Coord label_width, Coord list_height, Coord list_width);

  virtual void ok_cb();
  virtual void help_cb();
  virtual void info_cb();
  
protected:
};

/*
 * ChemistryTool
 */

class ChemistryTool : public ToolboxTool {
public:
  ChemistryTool(Map* map, Coord label_width, Coord list_height, Coord list_width);

  virtual void help_cb();
  virtual void ok_cb();

protected:
  virtual void particle_track();
  virtual void contor_map();

  Map* _map;
};

/*
 * PopulationTool
 */
class PopulationTool : public ToolboxTool {
public:
  PopulationTool(Coord label_width, Coord list_height, Coord list_width);

protected:
  boolean _link_to_chem_lab;
};

/*
 * PointSourceTool
 */

class PointSourceTool : public ToolboxTool {
public:
  PointSourceTool(Coord label_width, Coord list_height, Coord list_width);

};

#endif

