/* File: rbbox.h
 * Created: 4/4/92 by John Butare(jb7p@andrew.cmu.edu)
 * Description:
 *	
 * Modifications:
 */

/*
 * RBBox(RadioButtonBox)
 */

#ifndef rbbox_h
#define rbbox_h

#include <InterViews/coord.h>
#include <OS/string.h>
#include <InterViews/style.h>
#include <InterViews/monoglyph.h>
#include <InterViews/boolean.h>

#include <UI/radio_button.h>

class ButtonRef_List;

class RBBox : public MonoGlyph {
public:
  RBBox(
    	Glyph* context, 
    	GenericButton*, GenericButton* =nil,
    	GenericButton* =nil, GenericButton* =nil,
    	GenericButton* =nil, GenericButton* =nil,
    	GenericButton* =nil, GenericButton* =nil,
    	GenericButton* =nil, GenericButton* =nil
    );

  RBBox(
    	Glyph* context, Style* style, Action* action =nil,
    	Glyph* =nil, Glyph* =nil,
    	Glyph* =nil, Glyph* =nil,
    	Glyph* =nil, Glyph* =nil,
    	Glyph* =nil, Glyph* =nil,
    	Glyph* =nil, Glyph* =nil
    );

  RBBox(Glyph* context =nil, GlyphIndex size =10);
  ~RBBox();

  virtual void append(Glyph* g);
  virtual Glyph* append(GenericButton* button);
  virtual Glyph* append(Glyph* g, Style* s, Action* a = nil);

  GenericButton* chosen_button();
  GlyphIndex chosen() { return(_chosen_button); }
  void choose(GlyphIndex button);
  void choose(GenericButton* button);

  boolean enabled(GlyphIndex button);
  void enable(GlyphIndex button, boolean state);
  void enable(boolean state);

  GenericButton* button(GlyphIndex);
  void multiple_selections(boolean b) { _multiple_selections = b; };

private:
  boolean _multiple_selections;
  Glyph* _context;
  ButtonRef_List* _buttons;
  GlyphIndex _chosen_button;
};

#endif
