/******************************************************************* 
**
** EHTS was designed and implemented by:
**
**	Uffe Kock Wiil 		(kock@iesd.auc.dk)
**	Claus Bo Nielsen 	(cbn@cci.dk)
**
** at The University of Aalborg in Denmark spring 1990, and is provided
** for unrestricted use provided that this legend is included on all
** tape media and as a part of the software program in whole or part.
** Users may copy or modify EHTS without charge, but are not authorized
** to license or distribute it to anyone else except as part of a
** product or program developed by the user.
**   
** EHTS IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
** WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
** PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE
** PRACTICE.
** 
** EHTS is provided with no support and without any obligation on the
** part of the authors, to assist in its use, correction, modification
** or enhancement.
** 
** THE AUTHORS SHALL HAVE NO LIABILITY WITH RESPECT TO THE INFRINGEMENT
** OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY EHTS OR ANY PART
** THEREOF.
** 
** In no event will the authors and/or The University of Aalborg be
** liable for any lost revenue or profits or other special, indirect and
** consequential damages, even if the authors and/or The University of
** Aalborg has been advised of the possibility of such damages.
** 
** Please address all correspondence to:
** 
** Uffe Kock Wiil
** Department of Computer Science,
** The University of Aalborg,      Email:  kock@iesd.auc.dk
** Fredrik Bajers Vej 7E,          Phone:  + 45 98 15 42 11 (Ext 5051)
** DK-9220 Aalborg, Denmark.       Fax:    + 45 98 15 81 29
**
*******************************************************************/

/** Include files **/

#include <stdio.h>		/* for printf */
#include <X11/X.h>
#include <X11/Xlib.h>
#include <xview/xview.h>
#include <xview/canvas.h>
#include <xview/panel.h>

#include "browser.h"


/** Extern variabels **/

extern char hb_on_machine[];


/** Global definitions **/

Canvas canvas;
Frame baseframe;
Panel basepanel;

int debug = 0;		/* Global var. to define debug */


/*******************************************************************
** Main - it all begins here !
*******************************************************************/

main(argc, argv)
int argc;
char *argv[];
{
  xv_init(XV_INIT_ARGC_PTR_ARGV, &argc, argv, NULL); /* strip X stuf */
						     /* off the arg* */
  

  baseframe = (Frame)xv_create(NULL, FRAME,
			       XV_WIDTH, 800,
			       XV_HEIGHT, 600,
			       FRAME_LABEL, APP_NAME,
			       FRAME_SHOW_HEADER, TRUE,
			       FRAME_SHOW_FOOTER, TRUE,
			       NULL);

  print_left_footer("Welcome to the EHTS browser.");

  set_up_panel(); 

  set_up_canvas(); 

  set_up_ehts(); 

  if (argc > 2)
  {
    if (!strcmp(argv[1], "-h"))
    {
      strcpy(hb_on_machine, argv[2]);
      fprintf(stderr, "Connecting to HyperBase on `%s' ... ", argv[2]);
      connect_to_hb();
      fprintf(stderr, "OK\n");
    }
  }

  xv_main_loop(baseframe);
}


/*******************************************************************
** print_left/right_footer
*******************************************************************/

print_left_footer(str)
char *str;
{
  xv_set(baseframe, FRAME_LEFT_FOOTER, str, NULL);
}

print_right_footer(str)
char *str;
{
  xv_set(baseframe, FRAME_RIGHT_FOOTER, str, NULL);
}
