/******************************************************************* 
**
** EHTS was designed and implemented by:
**
**	Uffe Kock Wiil 		(kock@iesd.auc.dk)
**	Claus Bo Nielsen 	(cbn@cci.dk)
**
** at The University of Aalborg in Denmark spring 1990, and is provided
** for unrestricted use provided that this legend is included on all
** tape media and as a part of the software program in whole or part.
** Users may copy or modify EHTS without charge, but are not authorized
** to license or distribute it to anyone else except as part of a
** product or program developed by the user.
**   
** EHTS IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
** WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
** PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE
** PRACTICE.
** 
** EHTS is provided with no support and without any obligation on the
** part of the authors, to assist in its use, correction, modification
** or enhancement.
** 
** THE AUTHORS SHALL HAVE NO LIABILITY WITH RESPECT TO THE INFRINGEMENT
** OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY EHTS OR ANY PART
** THEREOF.
** 
** In no event will the authors and/or The University of Aalborg be
** liable for any lost revenue or profits or other special, indirect and
** consequential damages, even if the authors and/or The University of
** Aalborg has been advised of the possibility of such damages.
** 
** Please address all correspondence to:
** 
** Uffe Kock Wiil
** Department of Computer Science,
** The University of Aalborg,      Email:  kock@iesd.auc.dk
** Fredrik Bajers Vej 7E,          Phone:  + 45 98 15 42 11 (Ext 5051)
** DK-9220 Aalborg, Denmark.       Fax:    + 45 98 15 81 29
**
*******************************************************************/

/** frame **/
#define APP_NAME " EHTS Browser "

/** canvas **/
#define EHTS_WIDTH 1500
#define EHTS_HEIGHT 1500
#define EHTS_DELTA_PIXELS 10
#define CIR_RAD 10


/** Node types **/
#define NODE 0
#define DIR 1
#define HIDDEN 2		/* unused */

/** EHTS communication **/
#define EHTS_SOCK_NUM 10009
#define EHTS_DATA 0
#define EHTS_ATT 1

/** HyperBase **/
struct node_struct		/* Node struct */
{
  /* HyperBase information */
  int  num;
  char name[50];
  char created_by[50];
  char created_date[50];
  char last_modified_by[50];
  char last_modified_date[50];
  char font[50]; 
  char geometry[10]; 
  int  locked;
  struct link_list *link_num;	/* links from node (list of) */

  /* for the browser */
  int  type;
  int  x_coor;
  int  y_coor;
  int  shown;
  Frame att_frame;
  
  struct node_struct *next;
  struct node_struct *dir;
};
typedef struct node_struct HBNODE;


struct link_struct		/* Link struct */
{
  /* HyperBase information */
  int num;
  char name[50];
  int to_node;
  char created_by[50];
  char created_date[50];
  char last_modified_by[50];
  char last_modified_date[50];

  /* for the browser */
  Frame att_frame;

  struct link_struct *next;
};
typedef struct link_struct HBLINK;


struct link_list		/* Link list (to the node struct) */
{
  int num;

  struct link_list *next;
};
typedef struct link_list HBLINKLIST;


struct level_struct		/* the level stack */
{
  HBNODE *node_ptr;
  struct level_struct *next;
};

