/******************************************************************* 
**
** EHTS was designed and implemented by:
**
**	Uffe Kock Wiil 		(kock@iesd.auc.dk)
**	Claus Bo Nielsen 	(cbn@cci.dk)
**
** at The University of Aalborg in Denmark spring 1990, and is provided
** for unrestricted use provided that this legend is included on all
** tape media and as a part of the software program in whole or part.
** Users may copy or modify EHTS without charge, but are not authorized
** to license or distribute it to anyone else except as part of a
** product or program developed by the user.
**   
** EHTS IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
** WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
** PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE
** PRACTICE.
** 
** EHTS is provided with no support and without any obligation on the
** part of the authors, to assist in its use, correction, modification
** or enhancement.
** 
** THE AUTHORS SHALL HAVE NO LIABILITY WITH RESPECT TO THE INFRINGEMENT
** OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY EHTS OR ANY PART
** THEREOF.
** 
** In no event will the authors and/or The University of Aalborg be
** liable for any lost revenue or profits or other special, indirect and
** consequential damages, even if the authors and/or The University of
** Aalborg has been advised of the possibility of such damages.
** 
** Please address all correspondence to:
** 
** Uffe Kock Wiil
** Department of Computer Science,
** The University of Aalborg,      Email:  kock@iesd.auc.dk
** Fredrik Bajers Vej 7E,          Phone:  + 45 98 15 42 11 (Ext 5051)
** DK-9220 Aalborg, Denmark.       Fax:    + 45 98 15 81 29
**
*******************************************************************/

#include <fcntl.h>		/* file control */
#include <signal.h>		/* signals (alarm etc.) */
#include <sys/types.h>		/* include all the socket stuff */
#include <sys/socket.h>
#include <sys/time.h>
#include <netdb.h>
#include <netinet/in.h>

#include <stdio.h>
#include <xview/xview.h>
#include <xview/panel.h>
#include <xview/canvas.h>
#include <xview/notify.h>

#include "browser.h"

extern Frame baseframe;

/** Global variabels **/
int ehtsfd;			/* the socket for the EHTS */



/*******************************************************************
** ehts_input_func()
*******************************************************************/

ehts_input_func(client, fd)
Notify_client client;
int fd;
{
  struct sockaddr addr;
  int addrsize = sizeof(addr);

  ehtsfd = accept(fd, &addr, &addrsize);

  print_left_footer("Connected to EHTS (see `Options')");
}


/*******************************************************************
** set_up_ehts()
*******************************************************************/

set_up_ehts()
{
  makeserversock(EHTS_SOCK_NUM);
  notify_set_input_func(baseframe, ehts_input_func, ehtsfd);
}


/*******************************************************************
** makeserversock() --- creates an internet socket
*******************************************************************/

makeserversock(port)
int port;
{
  struct sockaddr_in server;
  
  ehtsfd = socket(AF_INET, SOCK_STREAM, 0);

  bzero(&server, sizeof(server));
  server.sin_family = AF_INET;
  server.sin_addr.s_addr = INADDR_ANY;
  server.sin_port = htons(port);
  
  bind(ehtsfd, &server, sizeof(server));

  listen(ehtsfd, 5);
  
  fcntl(ehtsfd, F_SETFL, FASYNC);
}


/*******************************************************************
** send_data_to_ehts()
*******************************************************************/

send_data_to_ehts(num)
int num;
{
  int str[2];

  str[0] = EHTS_DATA;
  str[1] = num;

  write(ehtsfd, (char *)&str[0], 8);
}


/*******************************************************************
** send_nodeatt_to_ehts()
*******************************************************************/

send_nodeatt_to_ehts(num)
int num;
{
  int str[2];

  str[0] = EHTS_ATT;
  str[1] = num;

  write(ehtsfd, (char *)&str[0], 8);
}


/*******************************************************************
** send_linkatt_to_ehts()
*******************************************************************/

send_linkatt_to_ehts(linknum,nodenum)
int linknum, nodenum;
{
  int str[3];

  str[0] = EHTS_ATT;
  str[1] = linknum;
  str[2] = nodenum;

  write(ehtsfd, (char *)&str[0], 12);
}


