;;!emacs
;; $Id: hgnus.el,v 1.2 1992/05/14 10:10:44 rsw Exp $
;;
;; FILE:         hgnus.el
;; SUMMARY:      Support Hyperbole buttons in news reader/poster: GNUS.
;; USAGE:        GNU Emacs Lisp Library
;;
;; AUTHOR:       Bob Weiner
;; ORG:          Brown U.
;;
;; ORIG-DATE:    24-Dec-91 at 22:29:28 by Bob Weiner
;; LAST-MOD:     18-Feb-92 at 18:43:06 by Bob Weiner
;;
;; This file is part of Hyperbole.
;;
;; Copyright (C) 1991, Brown University, Providence, RI
;; Developed with support from Motorola Inc.
;; 
;; Permission to use, modify and redistribute this software and its
;; documentation for any purpose other than its incorporation into a
;; commercial product is hereby granted without fee.  A distribution fee
;; may be charged with any redistribution.  Any distribution requires
;; that the above copyright notice appear in all copies, that both that
;; copyright notice and this permission notice appear in supporting
;; documentation, and that neither the name of Brown University nor the
;; author's name be used in advertising or publicity pertaining to
;; distribution of the software without specific, written prior permission.
;; 
;; Brown University makes no representations about the suitability of this
;; software for any purpose.  It is provided "as is" without express or
;; implied warranty.
;;
;;
;; DESCRIPTION:  
;;
;;   Automatically configured for use in "hsite.el".
;;   If hsite loading fails prior to initializing Hyperbole Gnus support,
;;
;;       {M-x Gnus-init RTN}
;;
;;   will do it.
;;
;;
;;   Have not yet overloaded 'news-reply-yank-original'
;;   to yank and hide button data from news article buffer.
;;
;; DESCRIP-END.

;;; ************************************************************************
;;; Other required Elisp libraries
;;; ************************************************************************

(require 'hmail)
(require 'hsmail)
(autoload 'news-reply-mode "rnewspost")
(require 'gnuspost)

;;; ************************************************************************
;;; Public variables
;;; ************************************************************************

(setq hnews:composer 'news-reply-mode
      hnews:lister   'gnus-Subject-mode
      hnews:reader   'gnus-Article-mode)


;;; ************************************************************************
;;; Public functions
;;; ************************************************************************

(defun Gnus-init ()
  "Initializes Hyperbole support for Gnus Usenet news reading."
  (interactive)
  )

(defun lnews:to ()
  "Sets current buffer to the Usenet news article summary listing buffer."
  (and (eq major-mode hnews:reader) (set-buffer gnus-Subject-buffer)))

(defun rnews:to ()
  "Sets current buffer to the Usenet news article reader buffer."
  (and (eq major-mode hnews:lister) (set-buffer gnus-Article-buffer)))

(defun rnews:summ-msg-to ()
  "Displays news message associated with current summary header."
  (let ((article (gnus-Subject-article-number)))
    (if (or (null gnus-current-article)
	    (/= article gnus-current-article))
	;; Selected subject is different from current article's.
	(gnus-Subject-display-article article))))


;;; Overlay 'gnus-inews-article' from "gnuspost.el" to make it include
;;; any signature before Hyperbole button data.  Does this by having
;;; signature inserted within narrowed buffer and then applies a hook to
;;; have the buffer widened before sending.
(hypb:function-symbol-replace
  'gnus-inews-article 'widen 'hmail:msg-narrow)

;;; Overload this function from "rnewspost.el" for supercite compatibility
;;; only when supercite is in use.
(if (hypb:supercite-p)
    (defun news-reply-yank-original (arg)
      "Supercite version of news-reply-yank-original.
Insert the message being replied to in the reply buffer. Puts point
before the mail headers and mark after body of the text.  Calls
mail-yank-original to actually yank the message into the buffer and
cite text.  

If mail-yank-original is not overloaded by supercite, each nonblank
line is indented ARG spaces (default 3).  Just \\[universal-argument]
as ARG means don't indent and don't delete any header fields."
      (interactive "P")
      (mail-yank-original arg)
      (exchange-point-and-mark)
      (run-hooks 'news-reply-header-hook))
  )

;;; ************************************************************************
;;; Private variables
;;; ************************************************************************
;;;
(var:append 'gnus-Inews-article-hook '(widen))
;;;
;;; Hide any Hyperbole button data and highlight buttons if possible
;;; in news article being read.
(var:append 'gnus-Article-prepare-hook
	    (if (fboundp 'ep:but-create)
		'(hmail:msg-narrow ep:but-create)
	      '(hmail:msg-narrow)))

(if (fboundp 'ep:but-create)
    (var:append 'gnus-Subject-prepare-hook '(ep:but-create)))

;;;
;;; Called from 'news-post-news' if prev unsent article exists and user
;;; says erase it.  Add a comment on Hyperbole button support.
(var:append 'news-setup-hook '(smail:comment-add))
;;;
;;; Called from 'news-post-news' if no prev unsent article exists.
;;; Add a comment on Hyperbole button support.
(var:append 'news-reply-mode-hook '(smail:comment-add))

(provide 'hgnus)
