/*******************************************************************
**
** HyperBase was designed and implemented by:
**
**	Uffe Kock Wiil 		(kock@iesd.auc.dk)
**	Claus Bo Nielsen 	(cbn@cci.dk)
**	Carsten Ruseng Jakobsen (ruseng@sun.com)
**	Finn Soelvsten
**	Per Magnus Petersen
**	Poul Larsen
**	Hans Mejdahl Jeppesen
**
** at The University of Aalborg in Denmark autumn 1989, and is provided
** for unrestricted use provided that this legend is included on all
** tape media and as a part of the software program in whole or part.
** Users may copy or modify HyperBase without charge, but are not
** authorized to license or distribute it to anyone else except as part
** of a product or program developed by the user.
**  
** HyperBase IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING
** THE WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A
** PARTICULAR PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR
** TRADE PRACTICE.
**  
** HyperBase is provided with no support and without any obligation on
** the part of the authors, to assist in its use, correction,
** modification or enhancement.
** 
** THE AUTHORS SHALL HAVE NO LIABILITY WITH RESPECT TO THE INFRINGEMENT
** OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY HyperBase OR ANY PART
** THEREOF.
** 
** In no event will the authors and/or The University of Aalborg be
** liable for any lost revenue or profits or other special, indirect and
** consequential damages, even if the authors and/or The University of
** Aalborg has been advised of the possibility of such damages.
** 
** Please address all correspondence to:
** 
** Uffe Kock Wiil
** Department of Computer Science,
** The University of Aalborg,      Email:  kock@iesd.auc.dk
** Fredrik Bajers Vej 7E,          Phone:  + 45 98 15 42 11 (Ext 5051)
** DK-9220 Aalborg, Denmark.       Fax:    + 45 98 15 81 29
**
*******************************************************************/

/*******************************************************************
** declaration of tree structure (class treelink)
*******************************************************************/

//#include <builtin.h>

#define FALSE 0
#define TRUE  1


typedef enum bal { minus, null, plus };
typedef void* ent;

class treelink {
friend class baltree;
    long nr;
    ent e;
    bal b;
    treelink* left;
    treelink* right;
    treelink(int n, ent a, bal c, treelink* l, treelink* r) 
            	{ nr = n; e = a; b = c, left = l; right = r; }
};

/*******************************************************************
** declaration of balanced tree (class baltree)
**
** insert() - inserts element n in tree, returns 0 if OK
** remove() - deletes element n from tree, returns 0 if OK
** search() - searches (and returns, if found) element n from tree
** clear()  - deletes all elements from tree
*******************************************************************/

class baltree {
    treelink* root;
    int h;
    long number;
    int treeinsert(treelink** t, long n, ent a);
    int treeremove(treelink** t, long n);
    ent treesearch(treelink* t, long n);
    void treeclear(treelink** t);
    void treehelpremove(treelink** t, treelink** ptr);
    void balanceleft(treelink** t);
    void balanceright(treelink** t);
    void treeinorder(treelink* t);	// til test
    void treepreorder(treelink* t);	// til test
    long treenext(treelink* t, long n, int s);
    long treefirst(treelink* t);
    void treecount(treelink* t);
    
public:
    int insert(long n, ent a);
    int remove(long n);
    ent search(long n);
    int clear();
    void inorder(); 			// til test
    void preorder(); 			// til test
    long first();
    long next(long n);
    long count();

    baltree() 		    { root = 0; h = FALSE; }
    baltree(long n, ent a)  { root = new treelink(n,a,null,0,0); h = FALSE; }
};
