/*******************************************************************
**
** HyperBase was designed and implemented by:
**
**	Uffe Kock Wiil 		(kock@iesd.auc.dk)
**	Claus Bo Nielsen 	(cbn@cci.dk)
**	Carsten Ruseng Jakobsen (ruseng@sun.com)
**	Finn Soelvsten
**	Per Magnus Petersen
**	Poul Larsen
**	Hans Mejdahl Jeppesen
**
** at The University of Aalborg in Denmark autumn 1989, and is provided
** for unrestricted use provided that this legend is included on all
** tape media and as a part of the software program in whole or part.
** Users may copy or modify HyperBase without charge, but are not
** authorized to license or distribute it to anyone else except as part
** of a product or program developed by the user.
**  
** HyperBase IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING
** THE WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A
** PARTICULAR PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR
** TRADE PRACTICE.
**  
** HyperBase is provided with no support and without any obligation on
** the part of the authors, to assist in its use, correction,
** modification or enhancement.
** 
** THE AUTHORS SHALL HAVE NO LIABILITY WITH RESPECT TO THE INFRINGEMENT
** OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY HyperBase OR ANY PART
** THEREOF.
** 
** In no event will the authors and/or The University of Aalborg be
** liable for any lost revenue or profits or other special, indirect and
** consequential damages, even if the authors and/or The University of
** Aalborg has been advised of the possibility of such damages.
** 
** Please address all correspondence to:
** 
** Uffe Kock Wiil
** Department of Computer Science,
** The University of Aalborg,      Email:  kock@iesd.auc.dk
** Fredrik Bajers Vej 7E,          Phone:  + 45 98 15 42 11 (Ext 5051)
** DK-9220 Aalborg, Denmark.       Fax:    + 45 98 15 81 29
**
*******************************************************************/

#ifdef SUN3
#include <stddef.h>
#else
#include <bool.h>
#endif

#include <sys/types.h>		// the socket stuff
#include <fcntl.h>
#include <sys/socket.h>
#include <signal.h>
#include <netdb.h>
#include <netinet/in.h>
#include <sys/time.h>

#include <stream.h>
#include <String.h>

#include "../ncb_config.h"
#include "../../config/hb_config.hh"
#include "block4a.hh"

extern int debug;
extern int socketid;

int hb_ncb_error;

int uniqsock;			// the uniq socket
int uniqfd;			// the uniq file descriptor

#include "../../block3/MainEventLock.hh" // block3 def
EventLock block3;		// make a block3 instance

extern int event_send_user;

hb_client client[MAXUSERS];	// make the client slots



/*******************************************************************
** getuserbynum() --- find the username(string) by the user number
*******************************************************************/

char *getuserbynum(int num)
{
  char *ch;
  ch = client[num].hb_the_username();
  return ch;
}


/*******************************************************************
** init() --- init function (makes the uniqsocket)
*******************************************************************/

int block4a_init()
{
  struct sockaddr_in server;
  
  uniqsock = socket(AF_INET, SOCK_STREAM, 0);
  if (uniqsock < 0)
    return FALSE;
  
  bzero(&server, sizeof(server));
  server.sin_family = AF_INET;
  server.sin_addr.s_addr = INADDR_ANY;
  server.sin_port = htons(socketid);
  
  int x = bind(uniqsock, &server, sizeof(server));
  if (x < 0)
  {
    close(uniqsock);
    return FALSE;
  }
  
  listen(uniqsock, 5);

  if (fcntl(uniqsock, F_SETFL, FASYNC + FNDELAY) < 0)
  {
    perror("fcntl F_SETFL, FASYNC");
    return FALSE;
  } 
  return TRUE;
}


/*******************************************************************
** handel_input() --- handel connection or input from client
*******************************************************************/

int handel_network_input()
{
  fd_set readfds;
  
  while(TRUE)			// just run forever (that's the meaning of 
  {				// a server !)
    FD_ZERO(&readfds);
    
    for(int i=0; i <= MAXUSERS; i++) // setup the file discript's
    {
      if (client[i].hb_isfree() == FALSE)
	FD_SET(client[i].hb_the_read_fd(), &readfds);
    }
    FD_SET(uniqsock, &readfds);	// also the uniq socket !!!
    
    select(FD_SETSIZE, &readfds,
	   (fd_set *)0, (fd_set *)0, (struct timeval *)NULL); // wait for input

    if (FD_ISSET (uniqsock, &readfds))
    {
      struct sockaddr addr;
      int addrsize = sizeof(addr);
      if((uniqfd = accept(uniqsock,&addr,&addrsize)) >= 0)  // connect 
      {
	for(int i=0; ((client[i].hb_isfree()==FALSE) && (i <= MAXUSERS)); i++);
	client[i].hb_connect(i);	// connect with him
      }
    }
    for(int j=0; j <= MAXUSERS; j++) // check all the clients
    {
      event_send_user = j;	// to handle if we get a sigpipe !
      client[j].hb_read_message();  
    }
  }
}


