/*******************************************************************
**
** HyperBase was designed and implemented by:
**
**	Uffe Kock Wiil 		(kock@iesd.auc.dk)
**	Claus Bo Nielsen 	(cbn@cci.dk)
**	Carsten Ruseng Jakobsen (ruseng@sun.com)
**	Finn Soelvsten
**	Per Magnus Petersen
**	Poul Larsen
**	Hans Mejdahl Jeppesen
**
** at The University of Aalborg in Denmark autumn 1989, and is provided
** for unrestricted use provided that this legend is included on all
** tape media and as a part of the software program in whole or part.
** Users may copy or modify HyperBase without charge, but are not
** authorized to license or distribute it to anyone else except as part
** of a product or program developed by the user.
**  
** HyperBase IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING
** THE WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A
** PARTICULAR PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR
** TRADE PRACTICE.
**  
** HyperBase is provided with no support and without any obligation on
** the part of the authors, to assist in its use, correction,
** modification or enhancement.
** 
** THE AUTHORS SHALL HAVE NO LIABILITY WITH RESPECT TO THE INFRINGEMENT
** OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY HyperBase OR ANY PART
** THEREOF.
** 
** In no event will the authors and/or The University of Aalborg be
** liable for any lost revenue or profits or other special, indirect and
** consequential damages, even if the authors and/or The University of
** Aalborg has been advised of the possibility of such damages.
** 
** Please address all correspondence to:
** 
** Uffe Kock Wiil
** Department of Computer Science,
** The University of Aalborg,      Email:  kock@iesd.auc.dk
** Fredrik Bajers Vej 7E,          Phone:  + 45 98 15 42 11 (Ext 5051)
** DK-9220 Aalborg, Denmark.       Fax:    + 45 98 15 81 29
**
*******************************************************************/

#ifdef SUN3			// this is brain damage
#include <stddef.h>
#else
#define _stddef_h
#include <bool.h>
#endif

#include <fcntl.h>		// file control
#include <signal.h>		// signals (alarm etc.)

#include <sys/types.h>		// include all the socket stuff
#include <sys/socket.h>
#include <netdb.h>
#include <netinet/in.h>

#include <stream.h>		// all the stream stuff
#include <String.h>

#include "../../config/hb_config.hh"	// The config file !
#include "../ncb_config.h"	// the ncb config file
#include "block4b.hh"		// include the "hb_block_4b" class


extern int debug;		// Global var. to define debug
extern int socketid;		// Global var. to define socketid




//*************   Functions to class `hb_block_4b'   *************//


/*******************************************************************
** hb_Write() ---
**
** input: 
** output: TRUE if all went okay, FALSE (see hb_ncb_error) if not.
*******************************************************************/
		 
int hb_block_4b::hb_Write(long ent_no, int key, char *value, long len)
{
  int func=WRITE;
  
  (void) write(writefd, &func, INTSIZE);
  (void) write(writefd, &ent_no, LONGSIZE);
  (void) write(writefd, &key, INTSIZE);
  sendsok(value, len);
  // delete value ???
  int ret;
  read(readfd, &ret, INTSIZE);
  return ret;
}


/*******************************************************************
** hb_Read() ---
**
** input: 
** output: TRUE if all went okay, FALSE (see hb_ncb_error) if not.
*******************************************************************/

int hb_block_4b::hb_Read(long ent_no, int key, char **value, long *len)
{
  int func=READ;
  
  (void) write(writefd, &func, INTSIZE);
  (void) write(writefd, &ent_no, LONGSIZE);
  (void) write(writefd, &key, INTSIZE);
  int ret;
  read(readfd, &ret, INTSIZE);
  if (ret >= 0)
    receivesok(value, len);
  return ret;
}


// THE NEXT TWO FUNCTIONS ARE NOT IMPLEMENTET !
// ============================================
//
///*******************************************************************
//** hb_Ewrite() ---
//**
//** input: 
//** output: TRUE if all went okay, FALSE (see hb_ncb_error) if not.
//*******************************************************************/
//
//int hb_block_4b::hb_Ewrite(long ent_no, char *value)
//{
//  int func=EWRITE;
//  
//  (void) write(writefd, &func, INTSIZE);
//  (void) write(writefd, &ent_no, LONGSIZE);
//  sendstring(value);
//  int ret;
//  read(readfd, &ret, INTSIZE);
//  return ret;
//}
//
//
///*******************************************************************
//** hb_Eread() ---
//**
//** input: 
//** output: TRUE if all went okay, FALSE (see hb_ncb_error) if not.
//*******************************************************************/
//
//int hb_block_4b::hb_Eread(long ent_no, char **value)
//{
//  int func=EREAD;
//  
//  (void) write(writefd, &func, INTSIZE);
//  (void) write(writefd, &ent_no, LONGSIZE);
//  int ret;
//  read(readfd, &ret, INTSIZE);
//  if (ret >= 0)
//    receivestring(value);
//  return ret;
//}


/*******************************************************************
** hb_CreateNode() ---
**
** input: 
** output: TRUE if all went okay, FALSE (see hb_ncb_error) if not.
*******************************************************************/

int hb_block_4b::hb_CreateNode(long *ent_no)
{
  int func=CREATE_NODE;
  long tmp;
  
  (void) write(writefd, &func, INTSIZE);
  int ret;
  read(readfd, &ret, INTSIZE);
  if (ret >= 0)
  {
    read(readfd, &tmp, LONGSIZE);
    *ent_no = tmp;
  }
  return ret;
}


/*******************************************************************
** hb_Delete() ---
**
** input: 
** output: TRUE if all went okay, FALSE (see hb_ncb_error) if not.
*******************************************************************/

int hb_block_4b::hb_Delete(long ent_no)
{
  int func=DELETE;
  
  (void) write(writefd, &func, INTSIZE);
  (void) write(writefd, &ent_no, LONGSIZE);
  int ret;
  read(readfd, &ret, INTSIZE);
  return ret;
}


/*******************************************************************
** hb_Link() ---
**
** input: 
** output: TRUE if all went okay, FALSE (see hb_ncb_error) if not.
*******************************************************************/

int hb_block_4b::hb_Link(long *ent_no, long ToNode)
{
  int func=LINK;
  long tmp;
  
  tmp = *ent_no;

  (void) write(writefd, &func, INTSIZE);
  (void) write(writefd, &tmp, LONGSIZE);
  (void) write(writefd, &ToNode, LONGSIZE);
  int ret;
  read(readfd, &ret, INTSIZE);
  if (ret >= 0)
  {
    read(readfd, &tmp, LONGSIZE);
    *ent_no = tmp;
  }
  return ret;
}


/*******************************************************************
** hb_MoveLink() ---
**
** input: 
** output: TRUE if all went okay, FALSE (see hb_ncb_error) if not.
*******************************************************************/

int hb_block_4b::hb_MoveLink(long Linkno, long NewNode)
{
  int func=MOVELINK;
  
  (void) write(writefd, &func, INTSIZE);
  (void) write(writefd, &Linkno, LONGSIZE);
  (void) write(writefd, &NewNode, LONGSIZE);
  int ret;
  read(readfd, &ret, INTSIZE);
  return ret;
}


/*******************************************************************
** hb_RemoveLink() ---
**
** input: 
** output: TRUE if all went okay, FALSE (see hb_ncb_error) if not.
*******************************************************************/

int hb_block_4b::hb_RemoveLink(long ent_no, long Link)
{
  int func=REMOVELINK;
  
  (void) write(writefd, &func, INTSIZE);
  (void) write(writefd, &ent_no, LONGSIZE);
  (void) write(writefd, &Link, LONGSIZE);
  int ret;
  read(readfd, &ret, INTSIZE);
  return ret;
}


/*******************************************************************
** hb_Event() ---
**
** input: 
** output: TRUE if all went okay, FALSE (see hb_ncb_error) if not.
*******************************************************************/

int hb_block_4b::hb_Event(long ent_no, int operation, int key)
{
  int func=EVENT;
  
  (void) write(writefd, &func, INTSIZE);
  (void) write(writefd, &ent_no, LONGSIZE);
  (void) write(writefd, &operation, INTSIZE);
  (void) write(writefd, &key, INTSIZE);
  int ret;
  read(readfd, &ret, INTSIZE);
  return ret;
}


/*******************************************************************
** hb_UnEvent() ---
**
** input: 
** output: TRUE if all went okay, FALSE (see hb_ncb_error) if not.
*******************************************************************/

int hb_block_4b::hb_UnEvent(long ent_no, int operation, int key)
{
  int func=UNEVENT;
  
  (void) write(writefd, &func, INTSIZE);
  (void) write(writefd, &ent_no, LONGSIZE);
  (void) write(writefd, &operation, INTSIZE);
  (void) write(writefd, &key, INTSIZE);
  int ret;
  read(readfd, &ret, INTSIZE);
  return ret;
}


/*******************************************************************
** hb_ShowEvent() ---
**
** input: 
** output: TRUE if all went okay, FALSE (see hb_ncb_error) if not.
*******************************************************************/

int hb_block_4b::hb_ShowEvent(char **Users, long ent_no, int operation, int key)
{
  int func=SHOWEVENT;
  long larg;
  
  (void) write(writefd, &func, INTSIZE);
  (void) write(writefd, &ent_no, LONGSIZE);
  (void) write(writefd, &operation, INTSIZE);
  (void) write(writefd, &key, INTSIZE);
  int ret;
  read(readfd, &ret, INTSIZE);
  if (ret >= 0)
    receivesok(Users, &larg);
  return ret;
}


/*******************************************************************
** hb_Lock() ---
**
** input: 
** output: TRUE if all went okay, FALSE (see hb_ncb_error) if not.
*******************************************************************/

int hb_block_4b::hb_Lock(long ent_no, int key)
{
  int func=LOCK;
  
  (void) write(writefd, &func, INTSIZE);
  (void) write(writefd, &ent_no, LONGSIZE);
  (void) write(writefd, &key, INTSIZE);
  int ret;
  read(readfd, &ret, INTSIZE);

  return ret;
}


/*******************************************************************
** hb_UnLock() ---
**
** input: 
** output: TRUE if all went okay, FALSE (see hb_ncb_error) if not.
*******************************************************************/

int hb_block_4b::hb_UnLock(long ent_no, int key)
{
  int func=UNLOCK;
  
  (void) write(writefd, &func, INTSIZE);
  (void) write(writefd, &ent_no, LONGSIZE);
  (void) write(writefd, &key, INTSIZE);
  int ret;
  read(readfd, &ret, INTSIZE);

  return ret;
}


/*******************************************************************
** hb_ShowLock() ---
**
** input: 
** output: TRUE if all went okay, FALSE (see hb_ncb_error) if not.
*******************************************************************/

int hb_block_4b::hb_ShowLock(char **User, long ent_no, int key)
{
  int func=SHOWLOCK;
  long larg;
  
  (void) write(writefd, &func, INTSIZE);
  (void) write(writefd, &ent_no, LONGSIZE);
  (void) write(writefd, &key, INTSIZE);
  int ret;
  read(readfd, &ret, INTSIZE);
  if (ret >= 0)
    receivesok(User, &larg);
  return ret;
}


/*******************************************************************
** hb_Connect()  ---  get connected to a HyperBase server (that is 
**                    make the read and write sockets)
**
** input: two strings, one for hostname (ex. hubert) and one for 
**        the username (ex. cbn@jac)
** output: TRUE if ok, FALSE if an error.
*******************************************************************/

int hb_block_4b::hb_Connect(char *host, char *username)
{
  int uniqportfd;		// uniq port file descriptor
  int readport, writeport, eventport;	// ports for read, write and event
  int ret;				// return value
  
  if (open == TRUE)		// allready connected
    return -401;
  
  if(debug)
    cerr << "Connect: socketid is: `" << socketid << "'\n";

  if(debug)
    cerr << "Connect: Conneting to the HyperBase Server ..... ";

  if ((ret=makeclientsock(host, socketid, &uniqportfd)) != 0)
    return ret;
  
  (void) read(uniqportfd, &readport, INTSIZE); // first the read port
  if ((ret=makeclientsock(host, readport, &readfd)) != 0) // the read socket
    return ret;

  (void) read(uniqportfd, &writeport, INTSIZE); // .. and then the write port
  if ((ret=makeclientsock(host, writeport, &writefd)) != 0)// the write socket
    return ret;
  
  (void) read(uniqportfd, &eventport, INTSIZE); // .. and then the event port
  if ((ret=makeclientsock(host, eventport, &eventfd)) != 0)// the event socket
    return ret;

  (void) close(uniqportfd);		// I don't need it any more

  if(debug)
    cerr << "OK!\nConnect: readport `" << readport << "', writeport `" \
      << writeport << "' and eventport `" << eventport << "'\n";

  char* tmp;
  tmp = (char *) username;		

  write(writefd,tmp,strlen(tmp));
  
  char i= '\0';
  write(writefd,&i,1);

  if(debug)
    cerr << "Connect: the username is: `" << username << "'\n";
  
  open = TRUE;			// set the open flag
  return 0;			// it's all ok
}


/*******************************************************************
** hb_Disconnect() --- disconnect the server
**
** input: none
** output: TRUE if disconnected, FALSE if not
*******************************************************************/

int hb_block_4b::hb_Disconnect()
{
  int func=DISCONNECT, rec;
  
  (void) write(writefd, &func, INTSIZE);
  (void) read(readfd, &rec, INTSIZE);

  if (rec != OK)		// the server can't disconnect
    return -405;

  open = FALSE;
  (void) close(readfd);
  (void) close(writefd);
  (void) close(eventfd);

  return 0;
}

/*******************************************************************
** hb_GetEvent() --- get an event, if there is on event goto sleep,
**                   wake up if a signal occur, and read the event
**
** input: a pointer to a buffer and a timelimit (in sec),  telling 
**        how long to wait for event (0=infinity)
** output: TRUE if got an event, FALSE if not or error
*******************************************************************/
			     
int hb_block_4b::hb_GetEvent(char **event, int timelimit, long *ent_no, \
			     int *operation, int *key)
{
  fd_set fds;
  struct timeval waittime;
  int ret;
  
  FD_ZERO(&fds);
  FD_SET(eventfd, &fds);

  if (timelimit == 0)
    ret=select(FD_SETSIZE, &fds, (fd_set *)0,(fd_set *)0,(struct timeval *)0);
  else
  {
    waittime.tv_sec = timelimit;
    waittime.tv_usec = 0;
    ret = select(FD_SETSIZE, &fds, (fd_set *)0,(fd_set *)0,&waittime);
  }
  if (ret <= 0)
    return -411;

  if(hb_ReadEvent(event, ent_no, operation, key) != 0)
    return -411;
  return 0;
}


/*******************************************************************
** hb_ReadEvent() --- get an event if any
**
** input: a pointer to a buffer
** output: TRUE if an event, FALSE if not or error
*******************************************************************/
		     
int hb_block_4b::hb_ReadEvent(char **event, long *ent_no, int *operation, \
			      int *key)
{
  char c;
  eventbuffer = "";
  
  read(eventfd, &c, 1); 
  while(c != '\0')
  {
    eventbuffer += c;
    read(eventfd, &c, 1);
  }

  *event = (char *) eventbuffer;

  read(eventfd, ent_no, LONGSIZE);
  read(eventfd, operation, INTSIZE);
  read(eventfd, key, INTSIZE);

  return 0;
}


/*******************************************************************
** hb_Browse() --- get alle used nodes or links
**
** input: type (node or link)
** output: TRUE if an event, FALSE if not or error
*******************************************************************/
		     
int hb_block_4b::hb_Browse(int type, long *vals[])
{
  int func=BROWSER;   // magnus
  long len;
  
  (void) write(writefd, &func, INTSIZE);
  (void) write(writefd, &type, INTSIZE);
  int ret;
  read(readfd, &ret, INTSIZE);
  if (ret >= 0)
    receivesok(((char **) vals), &len);
  return ret;
}



//*********   Private functions to class `hb_block_4b'   *********//


/*******************************************************************
** makeclientsock() --- make a connected client socket
**
** input: host name, port number to connect to, and a pointer to 
**        a var that after the call will contain the file descriptor
**        of the socket.
** output: FALSE if no socket could be created.
*******************************************************************/

int hb_block_4b::makeclientsock(char* host, int port, int *fd)
{
  struct sockaddr_in server;
  struct hostent *hp;

  hp = my_gethostbyname(host);	// get the inet number
  if (hp == NULL)
    return -402;

  *fd = (int) socket(AF_INET, SOCK_STREAM, 0); // make the socket
  if (*fd < 0)
    return -403;

  (void) bzero(&server, sizeof(server));
  server.sin_family = AF_INET;

  (void) bcopy(hp->h_addr, &server.sin_addr, hp->h_length);
  server.sin_port = htons(port); // give the port number
  if (connect(*fd, ((struct sockaddr*)&server), sizeof(server)) < 0)
  {
    (void) close (*fd);
    return -404;
  }
  return 0;
}


/*******************************************************************
** sendsok() --- send on the write-socket-port
**
** input: a pointer to a string, and the length
** output: True if all went okay
*******************************************************************/

int hb_block_4b::sendsok(char *str, long length)
{
  int j;
  char *tmp = str;

  write(writefd, &length, LONGSIZE); // send the length
  
  int put = write(writefd, tmp, length);
  if (put != length)
    return 1;
    
  return 0;
}


/*******************************************************************
** receivesok() --- receive on the read-socket-port
**
** input: a pointer to a string, and a pointer to a length
** output: True if all went okay
*******************************************************************/

int hb_block_4b::receivesok(char **str, long *len)
{
  int length;
  char *tmp;
  
  read(readfd, &length, LONGSIZE);	// read the size
  *len = length;			// return the length
  
  *str = tmp = new char[length];	// allocate mem
  
  while (length > 0)
  {
    int got = read(readfd, tmp, length); // read all there is room for
    length -= got;
    tmp += got;
  }
  return 0;
}
