;;; DO NOT MODIFY THIS FILE
(if (featurep 'tramp-autoloads) (error "Feature tramp-autoloads already loaded"))

(package-provide 'tramp :version 1.38 :author-version "2.0.56" :type 'regular)

;;;### (autoloads (tramp-ftp-enable-ange-ftp) "tramp-ftp" "lisp/tramp-ftp.el")

(autoload 'tramp-ftp-enable-ange-ftp "tramp-ftp" nil nil nil)

;;;***

;;;### (autoloads (tramp-unload-tramp tramp-completion-handle-file-name-completion tramp-completion-handle-file-name-all-completions tramp-unload-file-name-handlers tramp-file-name-handler tramp-completion-file-name-regexp tramp-file-name-regexp) "tramp" "lisp/tramp.el")

(defvar tramp-unified-filenames (not (featurep 'xemacs)) "\
Non-nil means to use unified Ange-FTP/Tramp filename syntax.
Otherwise, use a separate filename syntax for Tramp.")

(defconst tramp-file-name-regexp-unified "\\`/[^/:]+:" "\
Value for `tramp-file-name-regexp' for unified remoting.
Emacs (not XEmacs) uses a unified filename syntax for Ange-FTP and
Tramp.  See `tramp-file-name-structure-unified' for more explanations.")

(defconst tramp-file-name-regexp-separate "\\`/\\[.*\\]" "\
Value for `tramp-file-name-regexp' for separate remoting.
XEmacs uses a separate filename syntax for Tramp and EFS.
See `tramp-file-name-structure-separate' for more explanations.")

(defvar tramp-file-name-regexp (if tramp-unified-filenames tramp-file-name-regexp-unified tramp-file-name-regexp-separate) "\
*Regular expression matching file names handled by tramp.
This regexp should match tramp file names but no other file names.
\(When tramp.el is loaded, this regular expression is prepended to
`file-name-handler-alist', and that is searched sequentially.  Thus,
if the tramp entry appears rather early in the `file-name-handler-alist'
and is a bit too general, then some files might be considered tramp
files which are not really tramp files.

Please note that the entry in `file-name-handler-alist' is made when
this file (tramp.el) is loaded.  This means that this variable must be set
before loading tramp.el.  Alternatively, `file-name-handler-alist' can be
updated after changing this variable.

Also see `tramp-file-name-structure'.")

(defconst tramp-completion-file-name-regexp-unified "^/$\\|^/[^/:][^/]*$" "\
Value for `tramp-completion-file-name-regexp' for unified remoting.
Emacs (not XEmacs) uses a unified filename syntax for Ange-FTP and
Tramp.  See `tramp-file-name-structure-unified' for more explanations.")

(defconst tramp-completion-file-name-regexp-separate "^/\\([[][^]]*\\)?$" "\
Value for `tramp-completion-file-name-regexp' for separate remoting.
XEmacs uses a separate filename syntax for Tramp and EFS.
See `tramp-file-name-structure-separate' for more explanations.")

(defvar tramp-completion-file-name-regexp (if tramp-unified-filenames tramp-completion-file-name-regexp-unified tramp-completion-file-name-regexp-separate) "\
*Regular expression matching file names handled by tramp completion.
This regexp should match partial tramp file names only.

Please note that the entry in `file-name-handler-alist' is made when
this file (tramp.el) is loaded.  This means that this variable must be set
before loading tramp.el.  Alternatively, `file-name-handler-alist' can be
updated after changing this variable.

Also see `tramp-file-name-structure'.")

(defconst tramp-completion-file-name-handler-alist '((file-name-all-completions . tramp-completion-handle-file-name-all-completions) (file-name-completion . tramp-completion-handle-file-name-completion)) "\
Alist of completion handler functions.
Used for file names matching `tramp-file-name-regexp'. Operations not
mentioned here will be handled by `tramp-file-name-handler-alist' or the
normal Emacs functions.")

(defun tramp-run-real-handler (operation args) "\
Invoke normal file name handler for OPERATION.
First arg specifies the OPERATION, second arg is a list of arguments to
pass to the OPERATION." (let* ((inhibit-file-name-handlers (backquote (tramp-file-name-handler tramp-completion-file-name-handler cygwin-mount-name-hook-function cygwin-mount-map-drive-hook-function \, (and (eq inhibit-file-name-operation operation) inhibit-file-name-handlers)))) (inhibit-file-name-operation operation)) (apply operation args)))

(defun tramp-completion-run-real-handler (operation args) "\
Invoke `tramp-file-name-handler' for OPERATION.
First arg specifies the OPERATION, second arg is a list of arguments to
pass to the OPERATION." (let* ((inhibit-file-name-handlers (backquote (tramp-completion-file-name-handler cygwin-mount-name-hook-function cygwin-mount-map-drive-hook-function \, (and (eq inhibit-file-name-operation operation) inhibit-file-name-handlers)))) (inhibit-file-name-operation operation)) (apply operation args)))

(autoload 'tramp-file-name-handler "tramp" "\
Invoke Tramp file name handler.
Falls back to normal file name handler if no tramp file name handler exists." nil nil)

(defun tramp-completion-file-name-handler (operation &rest args) "\
Invoke tramp file name completion handler.
Falls back to normal file name handler if no tramp file name handler exists." (let ((fn (assoc operation tramp-completion-file-name-handler-alist))) (if fn (save-match-data (apply (cdr fn) args)) (tramp-completion-run-real-handler operation args))))

(defsubst tramp-register-file-name-handler nil "\
Add tramp file name handler to `file-name-handler-alist'." (add-to-list 'file-name-handler-alist (cons tramp-file-name-regexp 'tramp-file-name-handler)) (let ((jka (rassoc 'jka-compr-handler file-name-handler-alist))) (when jka (setq file-name-handler-alist (cons jka (delete jka file-name-handler-alist))))))

(defsubst tramp-register-completion-file-name-handler nil "\
Add tramp completion file name handler to `file-name-handler-alist'." (when (or (not (boundp 'partial-completion-mode)) (symbol-value 'partial-completion-mode) (featurep 'ido)) (add-to-list 'file-name-handler-alist (cons tramp-completion-file-name-regexp 'tramp-completion-file-name-handler)) (put 'tramp-completion-file-name-handler 'safe-magic t)) (let ((jka (rassoc 'jka-compr-handler file-name-handler-alist))) (when jka (setq file-name-handler-alist (cons jka (delete jka file-name-handler-alist))))))
(tramp-register-file-name-handler)
(add-hook
 'after-init-hook
 '(lambda () (tramp-register-completion-file-name-handler)))

(autoload 'tramp-unload-file-name-handlers "tramp" nil nil nil)

(autoload 'tramp-completion-handle-file-name-all-completions "tramp" "\
Like `file-name-all-completions' for partial tramp files." nil nil)

(autoload 'tramp-completion-handle-file-name-completion "tramp" "\
Like `file-name-completion' for tramp files." nil nil)

(autoload 'tramp-unload-tramp "tramp" "\
Discard Tramp from loading remote files." t nil)

;;;***

(provide 'tramp-autoloads)
