(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: Dispose.m3                                            *)
(* Last Modified On Tue Jun 30 08:59:33 PDT 1992 By kalsow     *)
(*      Modified On Tue Feb 12 11:52:16 1991 By muller         *)

MODULE Dispose;

IMPORT CallExpr, Expr, Type, Procedure, Void, Emit;
IMPORT Addr, Reff, Module, Error;
IMPORT ObjectRef, ObjectAdr, ObjectType, Temp;

VAR Z: CallExpr.MethodList;

PROCEDURE Check (<*UNUSED*> proc: Expr.T; VAR args: Expr.List;  <*UNUSED*> VAR cs: Expr.CheckState): Type.T =
  VAR t: Type.T;
  BEGIN
    t := Expr.TypeOf (args[0]);
    IF Module.IsSafe () THEN Error.Msg ("DISPOSE: unsafe operation") END;
    IF (NOT Type.IsSubtype (t, Reff.T))
      AND (NOT Type.IsSubtype (t, Addr.T)) THEN
      Error.Msg ("DISPOSE: must be applied to a reference type");
    ELSIF Type.IsEqual (t, Reff.T, NIL)
       OR Type.IsEqual (t, Addr.T, NIL)
       OR Type.IsEqual (t, ObjectRef.T, NIL)
       OR Type.IsEqual (t, ObjectAdr.T, NIL) THEN
      Error.Msg ("DISPOSE: must be applied to a fixed reference type");
    END;
    RETURN Void.T;
  END Check;

PROCEDURE Compile (<*UNUSED*> proc: Expr.T; args: Expr.List): Temp.T =
  VAR t: Type.T; e: Expr.T; x: Temp.T;
  BEGIN
    e := args[0];
    t := Type.Base (Expr.TypeOf (e));
    IF Expr.IsWritable (e) THEN
      x := Expr.CompileLValue (e);
      IF Type.IsTraced (t) THEN
        Emit.OpT ("_TDISPOSE(& @);\n", x);
      ELSIF ObjectType.Is (t) THEN
	Emit.OpT ("_ODISPOSE(& @);\n", x);
      ELSE
        Emit.OpT ("_UDISPOSE(& @);\n", x);
      END;
      Expr.NoteWrite (e);
      Temp.Free (x);
    ELSE
      Error.Msg ("DISPOSE: must be applied to a writable designator");
    END;
    RETURN x; (*DUMMY*)
  END Compile;

PROCEDURE Initialize () =
  BEGIN
    Z := CallExpr.NewMethodList (1, 1, FALSE, FALSE, Void.T,
                                 NIL, Check, Compile, CallExpr.NoValue, 
				 CallExpr.IsNever, (* writable *)
                                 CallExpr.IsNever, (* designator *)
                                 CallExpr.NotWritable (* noteWriter *));
    Procedure.Define ("DISPOSE", Z, TRUE);
  END Initialize;

BEGIN
END Dispose.
