(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: CChar.m3                                               *)
(* Last Modified On Fri May 29 16:18:09 PDT 1992 By muller     *)
(*      Modified On Mon Mar  2 10:31:25 PST 1992 By kalsow     *)

MODULE CChar;

IMPORT EnumType, Tipe, Scope, String, M3;

PROCEDURE Initialize () =
  VAR elts: Scope.T;  cs := M3.OuterCheckState;
  BEGIN
    elts := Scope.PushNew (FALSE, String.Add ("CHAR"));
    T := EnumType.New (256, elts);
    Scope.PopNew ();
    Scope.TypeCheck (elts, cs);
    Tipe.Define ("CHAR", T, TRUE);
  END Initialize;

BEGIN
END CChar.
