(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)
(*                                                                           *)
(* Last modified on Wed Jun  3 21:15:32 PDT 1992 by muller                   *)

UNSAFE MODULE RTThread;

IMPORT Word;

CONST 
  SP_pos = 2;

PROCEDURE SP (s: State): ADDRESS =
  BEGIN
    RETURN LOOPHOLE (s [SP_pos], ADDRESS);
  END SP;

PROCEDURE FlushStackCache () =
  VAR d: State;
  BEGIN
    IF Save (d) = 0 THEN
      Restore (d, 1); END;
  END FlushStackCache;

PROCEDURE UpdateStateForNewSP (VAR s: State; offset: INTEGER) =
  BEGIN
    INC (s [SP_pos], offset);
  END UpdateStateForNewSP;

PROCEDURE UpdateFrameForNewSP (a: ADDRESS;  offset: INTEGER) =
  BEGIN
    INC (LOOPHOLE (a + 14 * ADRSIZE (Word.T), UNTRACED REF INTEGER)^, offset);
  END UpdateFrameForNewSP;

BEGIN
END RTThread.
