#!/usr/bin/perl

use strict;
use lib 't/lib';
use utf8;

use Test::More;
use Test::Deep qw(cmp_deeply);
use XML::TreePP;

use FusionInventory::Agent::SNMP::Mock;
use FusionInventory::Agent::Task::NetDiscovery::Dictionary;
use FusionInventory::Agent::Tools::Hardware;

my %tests = (
    'juniper/ex2200.01.walk' => [
        {
            MANUFACTURER => 'Juniper',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Juniper Networks, Inc. ex2200-c-12p-2g internet router, kernel JUNOS 11.3R1.7 #0: 2011-08-30 11:49:21 UTC     builder@dagmath.juniper.net:/volume/build/junos/11.3/release/11.3R1.7/obj-arm/bsd/kernels/JUNIPER-EX-2200/kernel Build date: 2011-08-30 11:32:01',
            SNMPHOSTNAME => 'AB-B404-23-ex2200',
            MAC          => '00:0b:ca:fe:00:00',
            MODEL        => 'EX2200',
        },
        {
            MANUFACTURER => 'Juniper',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Juniper Networks, Inc. ex2200-c-12p-2g internet router, kernel JUNOS 11.3R1.7 #0: 2011-08-30 11:49:21 UTC     builder@dagmath.juniper.net:/volume/build/junos/11.3/release/11.3R1.7/obj-arm/bsd/kernels/JUNIPER-EX-2200/kernel Build date: 2011-08-30 11:32:01',
            SNMPHOSTNAME => 'AB-B404-23-ex2200',
            MAC          => '00:0b:ca:fe:00:00',
            MODELSNMP    => 'Networking2181',
            MODEL        => 'EX2200',
            FIRMWARE     => undef,
            SERIAL       => undef,
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Juniper',
                TYPE         => 'NETWORKING',
                MODEL        => 'EX2200',
                COMMENTS     => 'Juniper Networks, Inc. ex2200-c-12p-2g internet router, kernel JUNOS 11.3R1.7 #0: 2011-08-30 11:49:21 UTC     builder@dagmath.juniper.net:/volume/build/junos/11.3/release/11.3R1.7/obj-arm/bsd/kernels/JUNIPER-EX-2200/kernel Build date: 2011-08-30 11:32:01',
                NAME         => 'AB-B404-23-ex2200',
                IPS          => {
                    IP => [
                        '128.0.0.1',
                        '128.0.0.127',
                        '128.0.0.16',
                        '128.0.0.32',
                        '192.168.1.23',
                    ],
                },
                UPTIME       => '(1896073543) 219 days, 10:52:15.43',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '4',
                        IFNAME           => 'lsi',
                        IFDESCR          => 'lsi',
                        IFTYPE           => '150',
                        IFSPEED          => '0',
                        IFMTU            => '1496',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(210618496) 24 days, 9:03:04.96',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '5',
                        IFNAME           => 'dsc',
                        IFDESCR          => 'dsc',
                        IFTYPE           => '1',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(210651137) 24 days, 9:08:31.37',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '6',
                        IFNAME           => 'lo0',
                        IFDESCR          => 'lo0',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(210651144) 24 days, 9:08:31.44',
                        IFINOCTETS       => '3847149791',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3847149791',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '7',
                        IFNAME           => 'tap',
                        IFDESCR          => 'tap',
                        IFTYPE           => '1',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(210651150) 24 days, 9:08:31.50',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '8',
                        IFNAME           => 'gre',
                        IFDESCR          => 'gre',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(210651140) 24 days, 9:08:31.40',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '9',
                        IFNAME           => 'ipip',
                        IFDESCR          => 'ipip',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(210651143) 24 days, 9:08:31.43',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10',
                        IFNAME           => 'pime',
                        IFDESCR          => 'pime',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(210651130) 24 days, 9:08:31.30',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '11',
                        IFNAME           => 'pimd',
                        IFDESCR          => 'pimd',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(210651132) 24 days, 9:08:31.32',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '12',
                        IFNAME           => 'mtun',
                        IFDESCR          => 'mtun',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(210651149) 24 days, 9:08:31.49',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '33',
                        IFNAME           => 'me0',
                        IFDESCR          => 'me0',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:3f',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(210651147) 24 days, 9:08:31.47',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '37',
                        IFNAME           => 'bme0',
                        IFDESCR          => 'bme0',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1576',
                        MAC              => '00:0b:ca:fe:00:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(210651124) 24 days, 9:08:31.24',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1660461977',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '38',
                        IFNAME           => 'bme0.32768',
                        IFDESCR          => 'bme0.32768',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1562',
                        IP               => '128.0.0.32',
                        MAC              => '00:0b:ca:fe:00:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(210651153) 24 days, 9:08:31.53',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '501',
                        IFNAME           => 'jsrv',
                        IFDESCR          => 'jsrv',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1518',
                        MAC              => '78:fe:3d:df:20:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(795719864) 92 days, 2:19:58.64',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '502',
                        IFNAME           => 'jsrv.1',
                        IFDESCR          => 'jsrv.1',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        IP               => '128.0.0.127',
                        MAC              => '78:fe:3d:df:20:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(795719864) 92 days, 2:19:58.64',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '42',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '503',
                        IFNAME           => 'vlan',
                        IFDESCR          => 'vlan',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1518',
                        MAC              => '78:fe:3d:df:20:01',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(210651161) 24 days, 9:08:31.61',
                        IFINOCTETS       => '2169597684',
                        IFINERRORS       => '22',
                        IFOUTOCTETS      => '378679611',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '504',
                        IFNAME           => 'ge-0/0/0',
                        IFDESCR          => 'ge-0/0/0',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:03',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2080979263) 240 days, 20:29:52.63',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '54996177',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3775595507',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '505',
                        IFNAME           => 'ge-0/0/1',
                        IFDESCR          => 'ge-0/0/1',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:04',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2081029863) 240 days, 20:38:18.63',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '42701777',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '8617260',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '506',
                        IFNAME           => 'ge-0/0/2',
                        IFDESCR          => 'ge-0/0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:05',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2080957353) 240 days, 20:26:13.53',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '276103333',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1776301481',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '507',
                        IFNAME           => 'ge-0/0/3',
                        IFDESCR          => 'ge-0/0/3',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:06',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2081042643) 240 days, 20:40:26.43',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '743174854',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1617417859',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '508',
                        IFNAME           => 'ge-0/0/4',
                        IFDESCR          => 'ge-0/0/4',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:07',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2081034223) 240 days, 20:39:02.23',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '65424546',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '729029155',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '509',
                        IFNAME           => 'ge-0/0/5',
                        IFDESCR          => 'ge-0/0/5',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:08',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2081071652) 240 days, 20:45:16.52',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '121426929',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '786124744',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '510',
                        IFNAME           => 'ge-0/0/6',
                        IFDESCR          => 'ge-0/0/6',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:09',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2081053722) 240 days, 20:42:17.22',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '310326639',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1458885492',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '511',
                        IFNAME           => 'ge-0/0/7',
                        IFDESCR          => 'ge-0/0/7',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:0a',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(210651201) 24 days, 9:08:32.01',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '512',
                        IFNAME           => 'ge-0/0/8',
                        IFDESCR          => 'ge-0/0/8',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:0b',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(210651203) 24 days, 9:08:32.03',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '513',
                        IFNAME           => 'ge-0/0/0.0',
                        IFDESCR          => 'ge-0/0/0.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:03',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2080979263) 240 days, 20:29:52.63',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '12422938',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '5825457',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '514',
                        IFNAME           => 'ge-0/0/9',
                        IFDESCR          => 'ge-0/0/9',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:0c',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2080931282) 240 days, 20:21:52.82',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '703703523',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1577399105',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '515',
                        IFNAME           => 'ge-0/0/10',
                        IFDESCR          => 'ge-0/0/10',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:0d',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(210651209) 24 days, 9:08:32.09',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '516',
                        IFNAME           => 'ge-0/0/1.0',
                        IFDESCR          => 'ge-0/0/1.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:04',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2081029863) 240 days, 20:38:18.63',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '12416987',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '5824725',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '517',
                        IFNAME           => 'ge-0/0/11',
                        IFDESCR          => 'ge-0/0/11',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:0e',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2080999052) 240 days, 20:33:10.52',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '242475284',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1017324509',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '518',
                        IFNAME           => 'ge-0/0/2.0',
                        IFDESCR          => 'ge-0/0/2.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:05',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2080957353) 240 days, 20:26:13.53',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '37828621',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '127953081',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '519',
                        IFNAME           => 'ge-0/0/3.0',
                        IFDESCR          => 'ge-0/0/3.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:06',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2081042643) 240 days, 20:40:26.43',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '37862757',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '128037429',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '520',
                        IFNAME           => 'ge-0/0/4.0',
                        IFDESCR          => 'ge-0/0/4.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:07',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2081034223) 240 days, 20:39:02.23',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '18172757',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '33823397',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '521',
                        IFNAME           => 'ge-0/0/5.0',
                        IFDESCR          => 'ge-0/0/5.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:08',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2081071652) 240 days, 20:45:16.52',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '35637120',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '117501872',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '522',
                        IFNAME           => 'ge-0/0/6.0',
                        IFDESCR          => 'ge-0/0/6.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:09',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2081053722) 240 days, 20:42:17.22',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '38298814',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '130188996',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '523',
                        IFNAME           => 'ge-0/0/7.0',
                        IFDESCR          => 'ge-0/0/7.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:0a',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(210651217) 24 days, 9:08:32.17',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '524',
                        IFNAME           => 'ge-0/0/8.0',
                        IFDESCR          => 'ge-0/0/8.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:0b',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(210651220) 24 days, 9:08:32.20',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '525',
                        IFNAME           => 'ge-0/0/9.0',
                        IFDESCR          => 'ge-0/0/9.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:0c',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2080931282) 240 days, 20:21:52.82',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '37907646',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '128195994',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '526',
                        IFNAME           => 'ge-0/0/10.0',
                        IFDESCR          => 'ge-0/0/10.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:0d',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(210651225) 24 days, 9:08:32.25',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '527',
                        IFNAME           => 'ge-0/0/11.0',
                        IFDESCR          => 'ge-0/0/11.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:0e',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2080999052) 240 days, 20:33:10.52',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '33695673',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '108809558',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '528',
                        IFNAME           => 'ge-0/1/0',
                        IFDESCR          => 'ge-0/1/0',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:0f',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(210651230) 24 days, 9:08:32.30',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '529',
                        IFNAME           => 'ge-0/1/0.0',
                        IFDESCR          => 'ge-0/1/0.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:0f',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(210651234) 24 days, 9:08:32.34',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '530',
                        IFNAME           => 'ge-0/1/1',
                        IFDESCR          => 'ge-0/1/1',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:10',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(210651853) 24 days, 9:08:38.53',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1984754089',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2897992952',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '531',
                        IFNAME           => 'ge-0/1/1.0',
                        IFDESCR          => 'ge-0/1/1.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:10',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(210651853) 24 days, 9:08:38.53',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3925538024',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '515351797',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '532',
                        IFNAME           => 'vlan.0',
                        IFDESCR          => 'vlan.0',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        IP               => '192.168.1.23',
                        MAC              => '78:fe:3d:df:20:01',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(210651853) 24 days, 9:08:38.53',
                        IFINOCTETS       => '2169600207',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '344650884',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Juniper',
                TYPE         => 'NETWORKING',
                MODEL        => 'EX2200',
                COMMENTS     => 'Juniper Networks, Inc. ex2200-c-12p-2g internet router, kernel JUNOS 11.3R1.7 #0: 2011-08-30 11:49:21 UTC     builder@dagmath.juniper.net:/volume/build/junos/11.3/release/11.3R1.7/obj-arm/bsd/kernels/JUNIPER-EX-2200/kernel Build date: 2011-08-30 11:32:01',
                NAME         => 'AB-B404-23-ex2200',
                IPS          => {
                    IP => [
                        '128.0.0.1',
                        '128.0.0.127',
                        '128.0.0.16',
                        '128.0.0.32',
                        '192.168.1.23',
                    ],
                },
                UPTIME       => '(1896073543) 219 days, 10:52:15.43',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '4',
                        IFNAME           => 'lsi',
                        IFDESCR          => 'lsi',
                        IFTYPE           => '150',
                        IFSPEED          => '0',
                        IFMTU            => '1496',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(210618496) 24 days, 9:03:04.96',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '5',
                        IFNAME           => 'dsc',
                        IFDESCR          => 'dsc',
                        IFTYPE           => '1',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(210651137) 24 days, 9:08:31.37',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '6',
                        IFNAME           => 'lo0',
                        IFDESCR          => 'lo0',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(210651144) 24 days, 9:08:31.44',
                        IFINOCTETS       => '3847149791',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3847149791',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '7',
                        IFNAME           => 'tap',
                        IFDESCR          => 'tap',
                        IFTYPE           => '1',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(210651150) 24 days, 9:08:31.50',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '8',
                        IFNAME           => 'gre',
                        IFDESCR          => 'gre',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(210651140) 24 days, 9:08:31.40',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '9',
                        IFNAME           => 'ipip',
                        IFDESCR          => 'ipip',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(210651143) 24 days, 9:08:31.43',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10',
                        IFNAME           => 'pime',
                        IFDESCR          => 'pime',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(210651130) 24 days, 9:08:31.30',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '11',
                        IFNAME           => 'pimd',
                        IFDESCR          => 'pimd',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(210651132) 24 days, 9:08:31.32',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '12',
                        IFNAME           => 'mtun',
                        IFDESCR          => 'mtun',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(210651149) 24 days, 9:08:31.49',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '33',
                        IFNAME           => 'me0',
                        IFDESCR          => 'me0',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:3f',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(210651147) 24 days, 9:08:31.47',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '37',
                        IFNAME           => 'bme0',
                        IFDESCR          => 'bme0',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1576',
                        MAC              => '00:0b:ca:fe:00:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(210651124) 24 days, 9:08:31.24',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1660461977',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '38',
                        IFNAME           => 'bme0.32768',
                        IFDESCR          => 'bme0.32768',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1562',
                        IP               => '128.0.0.32',
                        MAC              => '00:0b:ca:fe:00:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(210651153) 24 days, 9:08:31.53',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '501',
                        IFNAME           => 'jsrv',
                        IFDESCR          => 'jsrv',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1518',
                        MAC              => '78:fe:3d:df:20:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(795719864) 92 days, 2:19:58.64',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '502',
                        IFNAME           => 'jsrv.1',
                        IFDESCR          => 'jsrv.1',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        IP               => '128.0.0.127',
                        MAC              => '78:fe:3d:df:20:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(795719864) 92 days, 2:19:58.64',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '42',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '503',
                        IFNAME           => 'vlan',
                        IFDESCR          => 'vlan',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1518',
                        MAC              => '78:fe:3d:df:20:01',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(210651161) 24 days, 9:08:31.61',
                        IFINOCTETS       => '2169597684',
                        IFINERRORS       => '22',
                        IFOUTOCTETS      => '378679611',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '504',
                        IFNAME           => 'ge-0/0/0',
                        IFDESCR          => 'ge-0/0/0',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:03',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2080979263) 240 days, 20:29:52.63',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '54996177',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3775595507',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '505',
                        IFNAME           => 'ge-0/0/1',
                        IFDESCR          => 'ge-0/0/1',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:04',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2081029863) 240 days, 20:38:18.63',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '42701777',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '8617260',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '506',
                        IFNAME           => 'ge-0/0/2',
                        IFDESCR          => 'ge-0/0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:05',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2080957353) 240 days, 20:26:13.53',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '276103333',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1776301481',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '507',
                        IFNAME           => 'ge-0/0/3',
                        IFDESCR          => 'ge-0/0/3',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:06',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2081042643) 240 days, 20:40:26.43',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '743174854',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1617417859',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '508',
                        IFNAME           => 'ge-0/0/4',
                        IFDESCR          => 'ge-0/0/4',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:07',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2081034223) 240 days, 20:39:02.23',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '65424546',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '729029155',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '509',
                        IFNAME           => 'ge-0/0/5',
                        IFDESCR          => 'ge-0/0/5',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:08',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2081071652) 240 days, 20:45:16.52',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '121426929',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '786124744',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '510',
                        IFNAME           => 'ge-0/0/6',
                        IFDESCR          => 'ge-0/0/6',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:09',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2081053722) 240 days, 20:42:17.22',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '310326639',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1458885492',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '511',
                        IFNAME           => 'ge-0/0/7',
                        IFDESCR          => 'ge-0/0/7',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:0a',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(210651201) 24 days, 9:08:32.01',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '512',
                        IFNAME           => 'ge-0/0/8',
                        IFDESCR          => 'ge-0/0/8',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:0b',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(210651203) 24 days, 9:08:32.03',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '513',
                        IFNAME           => 'ge-0/0/0.0',
                        IFDESCR          => 'ge-0/0/0.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:03',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2080979263) 240 days, 20:29:52.63',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '12422938',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '5825457',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '514',
                        IFNAME           => 'ge-0/0/9',
                        IFDESCR          => 'ge-0/0/9',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:0c',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2080931282) 240 days, 20:21:52.82',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '703703523',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1577399105',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '515',
                        IFNAME           => 'ge-0/0/10',
                        IFDESCR          => 'ge-0/0/10',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:0d',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(210651209) 24 days, 9:08:32.09',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '516',
                        IFNAME           => 'ge-0/0/1.0',
                        IFDESCR          => 'ge-0/0/1.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:04',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2081029863) 240 days, 20:38:18.63',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '12416987',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '5824725',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '517',
                        IFNAME           => 'ge-0/0/11',
                        IFDESCR          => 'ge-0/0/11',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:0e',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2080999052) 240 days, 20:33:10.52',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '242475284',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1017324509',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '518',
                        IFNAME           => 'ge-0/0/2.0',
                        IFDESCR          => 'ge-0/0/2.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:05',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2080957353) 240 days, 20:26:13.53',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '37828621',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '127953081',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '519',
                        IFNAME           => 'ge-0/0/3.0',
                        IFDESCR          => 'ge-0/0/3.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:06',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2081042643) 240 days, 20:40:26.43',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '37862757',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '128037429',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '520',
                        IFNAME           => 'ge-0/0/4.0',
                        IFDESCR          => 'ge-0/0/4.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:07',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2081034223) 240 days, 20:39:02.23',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '18172757',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '33823397',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '521',
                        IFNAME           => 'ge-0/0/5.0',
                        IFDESCR          => 'ge-0/0/5.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:08',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2081071652) 240 days, 20:45:16.52',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '35637120',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '117501872',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '522',
                        IFNAME           => 'ge-0/0/6.0',
                        IFDESCR          => 'ge-0/0/6.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:09',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2081053722) 240 days, 20:42:17.22',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '38298814',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '130188996',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '523',
                        IFNAME           => 'ge-0/0/7.0',
                        IFDESCR          => 'ge-0/0/7.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:0a',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(210651217) 24 days, 9:08:32.17',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '524',
                        IFNAME           => 'ge-0/0/8.0',
                        IFDESCR          => 'ge-0/0/8.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:0b',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(210651220) 24 days, 9:08:32.20',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '525',
                        IFNAME           => 'ge-0/0/9.0',
                        IFDESCR          => 'ge-0/0/9.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:0c',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2080931282) 240 days, 20:21:52.82',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '37907646',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '128195994',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '526',
                        IFNAME           => 'ge-0/0/10.0',
                        IFDESCR          => 'ge-0/0/10.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:0d',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(210651225) 24 days, 9:08:32.25',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '527',
                        IFNAME           => 'ge-0/0/11.0',
                        IFDESCR          => 'ge-0/0/11.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:0e',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2080999052) 240 days, 20:33:10.52',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '33695673',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '108809558',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '528',
                        IFNAME           => 'ge-0/1/0',
                        IFDESCR          => 'ge-0/1/0',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:0f',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(210651230) 24 days, 9:08:32.30',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '529',
                        IFNAME           => 'ge-0/1/0.0',
                        IFDESCR          => 'ge-0/1/0.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:0f',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(210651234) 24 days, 9:08:32.34',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '530',
                        IFNAME           => 'ge-0/1/1',
                        IFDESCR          => 'ge-0/1/1',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:10',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(210651853) 24 days, 9:08:38.53',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1984754089',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2897992952',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '531',
                        IFNAME           => 'ge-0/1/1.0',
                        IFDESCR          => 'ge-0/1/1.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:10',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(210651853) 24 days, 9:08:38.53',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3925538024',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '515351797',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '532',
                        IFNAME           => 'vlan.0',
                        IFDESCR          => 'vlan.0',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        IP               => '192.168.1.23',
                        MAC              => '78:fe:3d:df:20:01',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(210651853) 24 days, 9:08:38.53',
                        IFINOCTETS       => '2169600207',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '344650884',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'juniper/ex2200.02.walk' => [
        {
            MANUFACTURER => 'Juniper',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Juniper Networks, Inc. ex2200-c-12p-2g internet router, kernel JUNOS 11.4R1.6 #0: 2011-11-15 10:11:59 UTC     builder@evenath.juniper.net:/volume/build/junos/11.4/release/11.4R1.6/obj-arm/bsd/kernels/JUNIPER-EX-2200/kernel Build date: 2011-11-15 09:57:14',
            SNMPHOSTNAME => 'C005-236b-ex2200',
            MAC          => '00:0b:ca:fe:00:00',
            MODEL        => 'EX2200',
        },
        {
            MANUFACTURER => 'Juniper',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Juniper Networks, Inc. ex2200-c-12p-2g internet router, kernel JUNOS 11.4R1.6 #0: 2011-11-15 10:11:59 UTC     builder@evenath.juniper.net:/volume/build/junos/11.4/release/11.4R1.6/obj-arm/bsd/kernels/JUNIPER-EX-2200/kernel Build date: 2011-11-15 09:57:14',
            SNMPHOSTNAME => 'C005-236b-ex2200',
            MAC          => '00:0b:ca:fe:00:00',
            MODELSNMP    => 'Networking2180',
            MODEL        => 'EX2200',
            FIRMWARE     => undef,
            SERIAL       => undef,
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Juniper',
                TYPE         => 'NETWORKING',
                MODEL        => 'EX2200',
                COMMENTS     => 'Juniper Networks, Inc. ex2200-c-12p-2g internet router, kernel JUNOS 11.4R1.6 #0: 2011-11-15 10:11:59 UTC     builder@evenath.juniper.net:/volume/build/junos/11.4/release/11.4R1.6/obj-arm/bsd/kernels/JUNIPER-EX-2200/kernel Build date: 2011-11-15 09:57:14',
                NAME         => 'C005-236b-ex2200',
                IPS          => {
                    IP => [
                        '128.0.0.1',
                        '128.0.0.127',
                        '128.0.0.16',
                        '128.0.0.32',
                        '192.168.1.236',
                    ],
                },
                UPTIME       => '(1539344336) 178 days, 3:57:23.36',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '4',
                        IFNAME           => 'lsi',
                        IFDESCR          => 'lsi',
                        IFTYPE           => '150',
                        IFSPEED          => '0',
                        IFMTU            => '1496',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '5',
                        IFNAME           => 'dsc',
                        IFDESCR          => 'dsc',
                        IFTYPE           => '1',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1328) 0:00:13.28',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '6',
                        IFNAME           => 'lo0',
                        IFDESCR          => 'lo0',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1356) 0:00:13.56',
                        IFINOCTETS       => '1205099385',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1205099385',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '7',
                        IFNAME           => 'tap',
                        IFDESCR          => 'tap',
                        IFTYPE           => '1',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1371) 0:00:13.71',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '8',
                        IFNAME           => 'gre',
                        IFDESCR          => 'gre',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1336) 0:00:13.36',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '9',
                        IFNAME           => 'ipip',
                        IFDESCR          => 'ipip',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1352) 0:00:13.52',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10',
                        IFNAME           => 'pime',
                        IFDESCR          => 'pime',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1271) 0:00:12.71',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '11',
                        IFNAME           => 'pimd',
                        IFDESCR          => 'pimd',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1274) 0:00:12.74',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '12',
                        IFNAME           => 'mtun',
                        IFDESCR          => 'mtun',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1363) 0:00:13.63',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '33',
                        IFNAME           => 'me0',
                        IFDESCR          => 'me0',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:ff',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1358) 0:00:13.58',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '37',
                        IFNAME           => 'bme0',
                        IFDESCR          => 'bme0',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1576',
                        MAC              => '00:0b:ca:fe:00:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1268) 0:00:12.68',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '534363148',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '38',
                        IFNAME           => 'bme0.32768',
                        IFDESCR          => 'bme0.32768',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1562',
                        IP               => '128.0.0.32',
                        MAC              => '00:0b:ca:fe:00:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1377) 0:00:13.77',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '501',
                        IFNAME           => 'jsrv',
                        IFDESCR          => 'jsrv',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1518',
                        MAC              => '64:87:88:b0:39:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1288) 0:00:12.88',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '502',
                        IFNAME           => 'jsrv.1',
                        IFDESCR          => 'jsrv.1',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        IP               => '128.0.0.127',
                        MAC              => '64:87:88:b0:39:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1292) 0:00:12.92',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '42',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '503',
                        IFNAME           => 'vlan',
                        IFDESCR          => 'vlan',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1518',
                        MAC              => '64:87:88:b0:39:c1',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1391) 0:00:13.91',
                        IFINOCTETS       => '1895692302',
                        IFINERRORS       => '18',
                        IFOUTOCTETS      => '350482164',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '504',
                        IFNAME           => 'ge-0/0/0',
                        IFDESCR          => 'ge-0/0/0',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:c3',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1404) 0:00:14.04',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '505',
                        IFNAME           => 'ge-0/0/0.0',
                        IFDESCR          => 'ge-0/0/0.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:c3',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1407) 0:00:14.07',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '506',
                        IFNAME           => 'ge-0/0/1',
                        IFDESCR          => 'ge-0/0/1',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:c4',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1519198217) 175 days, 19:59:42.17',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '671285559',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1344808667',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '507',
                        IFNAME           => 'ge-0/0/1.0',
                        IFDESCR          => 'ge-0/0/1.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:c4',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1519198217) 175 days, 19:59:42.17',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '19465116',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '5704',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '508',
                        IFNAME           => 'ge-0/0/2',
                        IFDESCR          => 'ge-0/0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:c5',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1428) 0:00:14.28',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '509',
                        IFNAME           => 'ge-0/0/2.0',
                        IFDESCR          => 'ge-0/0/2.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:c5',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1441) 0:00:14.41',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '510',
                        IFNAME           => 'ge-0/0/3',
                        IFDESCR          => 'ge-0/0/3',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:c6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1519237117) 175 days, 20:06:11.17',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1801889333',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2786297666',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '511',
                        IFNAME           => 'ge-0/0/3.0',
                        IFDESCR          => 'ge-0/0/3.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:c6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1519237117) 175 days, 20:06:11.17',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '30642324',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '6670',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '512',
                        IFNAME           => 'ge-0/0/4',
                        IFDESCR          => 'ge-0/0/4',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:c7',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1519160047) 175 days, 19:53:20.47',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '749044509',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1606606341',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '513',
                        IFNAME           => 'ge-0/0/4.0',
                        IFDESCR          => 'ge-0/0/4.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:c7',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1519160047) 175 days, 19:53:20.47',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '24091394',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '6578',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '514',
                        IFNAME           => 'ge-0/0/5',
                        IFDESCR          => 'ge-0/0/5',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:c8',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1520147727) 175 days, 22:37:57.27',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1460221696',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2680801766',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '515',
                        IFNAME           => 'ge-0/0/5.0',
                        IFDESCR          => 'ge-0/0/5.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:c8',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1520147727) 175 days, 22:37:57.27',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '24573648',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '7636',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '516',
                        IFNAME           => 'ge-0/0/6',
                        IFDESCR          => 'ge-0/0/6',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:c9',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1519144687) 175 days, 19:50:46.87',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1204472549',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2280812113',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '517',
                        IFNAME           => 'ge-0/0/6.0',
                        IFDESCR          => 'ge-0/0/6.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:c9',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1519144687) 175 days, 19:50:46.87',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '25579766',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4784',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '518',
                        IFNAME           => 'ge-0/0/7',
                        IFDESCR          => 'ge-0/0/7',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:ca',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(276784128) 32 days, 0:50:41.28',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1884',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '538',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '519',
                        IFNAME           => 'ge-0/0/7.0',
                        IFDESCR          => 'ge-0/0/7.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:ca',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(276784128) 32 days, 0:50:41.28',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '826',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '92',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '520',
                        IFNAME           => 'ge-0/0/8',
                        IFDESCR          => 'ge-0/0/8',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:cb',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1519114587) 175 days, 19:45:45.87',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1293235433',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2255802556',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '521',
                        IFNAME           => 'ge-0/0/9',
                        IFDESCR          => 'ge-0/0/9',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:cc',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(276799604) 32 days, 0:53:16.04',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1998',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '576',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '522',
                        IFNAME           => 'ge-0/0/10',
                        IFDESCR          => 'ge-0/0/10',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:cd',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1507) 0:00:15.07',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '523',
                        IFNAME           => 'ge-0/0/8.0',
                        IFDESCR          => 'ge-0/0/8.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:cb',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1519114587) 175 days, 19:45:45.87',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '31177451',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '6532',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '524',
                        IFNAME           => 'ge-0/0/11',
                        IFDESCR          => 'ge-0/0/11',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:ce',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1512) 0:00:15.12',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '525',
                        IFNAME           => 'ge-0/0/9.0',
                        IFDESCR          => 'ge-0/0/9.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:cc',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(276799604) 32 days, 0:53:16.04',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1420',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '92',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '526',
                        IFNAME           => 'ge-0/0/10.0',
                        IFDESCR          => 'ge-0/0/10.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:cd',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1541) 0:00:15.41',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '527',
                        IFNAME           => 'ge-0/0/11.0',
                        IFDESCR          => 'ge-0/0/11.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:ce',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1554) 0:00:15.54',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '528',
                        IFNAME           => 'ge-0/1/0',
                        IFDESCR          => 'ge-0/1/0',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:cf',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1550) 0:00:15.50',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '529',
                        IFNAME           => 'ge-0/1/0.0',
                        IFDESCR          => 'ge-0/1/0.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:cf',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1572) 0:00:15.72',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '530',
                        IFNAME           => 'ge-0/1/1',
                        IFDESCR          => 'ge-0/1/1',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:d0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(28667) 0:04:46.67',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3750278254',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3165078235',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '531',
                        IFNAME           => 'ge-0/1/1.0',
                        IFDESCR          => 'ge-0/1/1.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:d0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(28667) 0:04:46.67',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2510254288',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '361557089',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '532',
                        IFNAME           => 'vlan.0',
                        IFDESCR          => 'vlan.0',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        IP               => '192.168.1.236',
                        MAC              => '64:87:88:b0:39:c1',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(28671) 0:04:46.71',
                        IFINOCTETS       => '1895694825',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '315971005',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Juniper',
                TYPE         => 'NETWORKING',
                MODEL        => 'EX2200',
                COMMENTS     => 'Juniper Networks, Inc. ex2200-c-12p-2g internet router, kernel JUNOS 11.4R1.6 #0: 2011-11-15 10:11:59 UTC     builder@evenath.juniper.net:/volume/build/junos/11.4/release/11.4R1.6/obj-arm/bsd/kernels/JUNIPER-EX-2200/kernel Build date: 2011-11-15 09:57:14',
                NAME         => 'C005-236b-ex2200',
                IPS          => {
                    IP => [
                        '128.0.0.1',
                        '128.0.0.127',
                        '128.0.0.16',
                        '128.0.0.32',
                        '192.168.1.236',
                    ],
                },
                UPTIME       => '(1539344336) 178 days, 3:57:23.36',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '4',
                        IFNAME           => 'lsi',
                        IFDESCR          => 'lsi',
                        IFTYPE           => '150',
                        IFSPEED          => '0',
                        IFMTU            => '1496',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '5',
                        IFNAME           => 'dsc',
                        IFDESCR          => 'dsc',
                        IFTYPE           => '1',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1328) 0:00:13.28',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '6',
                        IFNAME           => 'lo0',
                        IFDESCR          => 'lo0',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1356) 0:00:13.56',
                        IFINOCTETS       => '1205099385',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1205099385',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '7',
                        IFNAME           => 'tap',
                        IFDESCR          => 'tap',
                        IFTYPE           => '1',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1371) 0:00:13.71',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '8',
                        IFNAME           => 'gre',
                        IFDESCR          => 'gre',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1336) 0:00:13.36',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '9',
                        IFNAME           => 'ipip',
                        IFDESCR          => 'ipip',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1352) 0:00:13.52',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10',
                        IFNAME           => 'pime',
                        IFDESCR          => 'pime',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1271) 0:00:12.71',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '11',
                        IFNAME           => 'pimd',
                        IFDESCR          => 'pimd',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1274) 0:00:12.74',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '12',
                        IFNAME           => 'mtun',
                        IFDESCR          => 'mtun',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1363) 0:00:13.63',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '33',
                        IFNAME           => 'me0',
                        IFDESCR          => 'me0',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:ff',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1358) 0:00:13.58',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '37',
                        IFNAME           => 'bme0',
                        IFDESCR          => 'bme0',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1576',
                        MAC              => '00:0b:ca:fe:00:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1268) 0:00:12.68',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '534363148',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '38',
                        IFNAME           => 'bme0.32768',
                        IFDESCR          => 'bme0.32768',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1562',
                        IP               => '128.0.0.32',
                        MAC              => '00:0b:ca:fe:00:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1377) 0:00:13.77',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '501',
                        IFNAME           => 'jsrv',
                        IFDESCR          => 'jsrv',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1518',
                        MAC              => '64:87:88:b0:39:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1288) 0:00:12.88',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '502',
                        IFNAME           => 'jsrv.1',
                        IFDESCR          => 'jsrv.1',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        IP               => '128.0.0.127',
                        MAC              => '64:87:88:b0:39:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1292) 0:00:12.92',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '42',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '503',
                        IFNAME           => 'vlan',
                        IFDESCR          => 'vlan',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1518',
                        MAC              => '64:87:88:b0:39:c1',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1391) 0:00:13.91',
                        IFINOCTETS       => '1895692302',
                        IFINERRORS       => '18',
                        IFOUTOCTETS      => '350482164',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '504',
                        IFNAME           => 'ge-0/0/0',
                        IFDESCR          => 'ge-0/0/0',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:c3',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1404) 0:00:14.04',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '505',
                        IFNAME           => 'ge-0/0/0.0',
                        IFDESCR          => 'ge-0/0/0.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:c3',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1407) 0:00:14.07',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '506',
                        IFNAME           => 'ge-0/0/1',
                        IFDESCR          => 'ge-0/0/1',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:c4',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1519198217) 175 days, 19:59:42.17',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '671285559',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1344808667',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '507',
                        IFNAME           => 'ge-0/0/1.0',
                        IFDESCR          => 'ge-0/0/1.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:c4',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1519198217) 175 days, 19:59:42.17',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '19465116',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '5704',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '508',
                        IFNAME           => 'ge-0/0/2',
                        IFDESCR          => 'ge-0/0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:c5',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1428) 0:00:14.28',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '509',
                        IFNAME           => 'ge-0/0/2.0',
                        IFDESCR          => 'ge-0/0/2.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:c5',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1441) 0:00:14.41',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '510',
                        IFNAME           => 'ge-0/0/3',
                        IFDESCR          => 'ge-0/0/3',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:c6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1519237117) 175 days, 20:06:11.17',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1801889333',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2786297666',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '511',
                        IFNAME           => 'ge-0/0/3.0',
                        IFDESCR          => 'ge-0/0/3.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:c6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1519237117) 175 days, 20:06:11.17',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '30642324',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '6670',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '512',
                        IFNAME           => 'ge-0/0/4',
                        IFDESCR          => 'ge-0/0/4',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:c7',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1519160047) 175 days, 19:53:20.47',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '749044509',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1606606341',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '513',
                        IFNAME           => 'ge-0/0/4.0',
                        IFDESCR          => 'ge-0/0/4.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:c7',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1519160047) 175 days, 19:53:20.47',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '24091394',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '6578',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '514',
                        IFNAME           => 'ge-0/0/5',
                        IFDESCR          => 'ge-0/0/5',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:c8',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1520147727) 175 days, 22:37:57.27',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1460221696',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2680801766',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '515',
                        IFNAME           => 'ge-0/0/5.0',
                        IFDESCR          => 'ge-0/0/5.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:c8',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1520147727) 175 days, 22:37:57.27',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '24573648',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '7636',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '516',
                        IFNAME           => 'ge-0/0/6',
                        IFDESCR          => 'ge-0/0/6',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:c9',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1519144687) 175 days, 19:50:46.87',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1204472549',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2280812113',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '517',
                        IFNAME           => 'ge-0/0/6.0',
                        IFDESCR          => 'ge-0/0/6.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:c9',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1519144687) 175 days, 19:50:46.87',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '25579766',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4784',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '518',
                        IFNAME           => 'ge-0/0/7',
                        IFDESCR          => 'ge-0/0/7',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:ca',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(276784128) 32 days, 0:50:41.28',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1884',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '538',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '519',
                        IFNAME           => 'ge-0/0/7.0',
                        IFDESCR          => 'ge-0/0/7.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:ca',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(276784128) 32 days, 0:50:41.28',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '826',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '92',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '520',
                        IFNAME           => 'ge-0/0/8',
                        IFDESCR          => 'ge-0/0/8',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:cb',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1519114587) 175 days, 19:45:45.87',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1293235433',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2255802556',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '521',
                        IFNAME           => 'ge-0/0/9',
                        IFDESCR          => 'ge-0/0/9',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:cc',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(276799604) 32 days, 0:53:16.04',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1998',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '576',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '522',
                        IFNAME           => 'ge-0/0/10',
                        IFDESCR          => 'ge-0/0/10',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:cd',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1507) 0:00:15.07',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '523',
                        IFNAME           => 'ge-0/0/8.0',
                        IFDESCR          => 'ge-0/0/8.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:cb',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1519114587) 175 days, 19:45:45.87',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '31177451',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '6532',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '524',
                        IFNAME           => 'ge-0/0/11',
                        IFDESCR          => 'ge-0/0/11',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:ce',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1512) 0:00:15.12',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '525',
                        IFNAME           => 'ge-0/0/9.0',
                        IFDESCR          => 'ge-0/0/9.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:cc',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(276799604) 32 days, 0:53:16.04',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1420',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '92',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '526',
                        IFNAME           => 'ge-0/0/10.0',
                        IFDESCR          => 'ge-0/0/10.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:cd',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1541) 0:00:15.41',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '527',
                        IFNAME           => 'ge-0/0/11.0',
                        IFDESCR          => 'ge-0/0/11.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:ce',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1554) 0:00:15.54',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '528',
                        IFNAME           => 'ge-0/1/0',
                        IFDESCR          => 'ge-0/1/0',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:cf',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1550) 0:00:15.50',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '529',
                        IFNAME           => 'ge-0/1/0.0',
                        IFDESCR          => 'ge-0/1/0.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:cf',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1572) 0:00:15.72',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '530',
                        IFNAME           => 'ge-0/1/1',
                        IFDESCR          => 'ge-0/1/1',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:d0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(28667) 0:04:46.67',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3750278254',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3165078235',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '531',
                        IFNAME           => 'ge-0/1/1.0',
                        IFDESCR          => 'ge-0/1/1.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:d0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(28667) 0:04:46.67',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2510254288',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '361557089',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '532',
                        IFNAME           => 'vlan.0',
                        IFDESCR          => 'vlan.0',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        IP               => '192.168.1.236',
                        MAC              => '64:87:88:b0:39:c1',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(28671) 0:04:46.71',
                        IFINOCTETS       => '1895694825',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '315971005',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'juniper/ex2200.03.walk' => [
        {
            MANUFACTURER => 'Juniper',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Juniper Networks, Inc. ex2200-24t-4g internet router, kernel JUNOS 11.1R3.5 #0: 2011-06-25 00:35:00 UTC     builder@briath.juniper.net:/volume/build/junos/11.1/release/11.1R3.5/obj-arm/bsd/kernels/JUNIPER-EX/kernel Build date: 2011-06-25 00:31:37 UTC Cop',
            SNMPHOSTNAME => 'INTERUFR-219-ex2200-24',
            MAC          => '78:fe:3d:d5:0e:c0',
            MODEL        => 'EX2200',
        },
        {
            MANUFACTURER => 'Juniper',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Juniper Networks, Inc. ex2200-24t-4g internet router, kernel JUNOS 11.1R3.5 #0: 2011-06-25 00:35:00 UTC     builder@briath.juniper.net:/volume/build/junos/11.1/release/11.1R3.5/obj-arm/bsd/kernels/JUNIPER-EX/kernel Build date: 2011-06-25 00:31:37 UTC Cop',
            SNMPHOSTNAME => 'INTERUFR-219-ex2200-24',
            MAC          => '78:fe:3d:d5:0e:c0',
            MODELSNMP    => 'Networking2185',
            MODEL        => 'EX2200',
            FIRMWARE     => undef,
            SERIAL       => 'CW0211513175',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Juniper',
                TYPE         => 'NETWORKING',
                MODEL        => 'EX2200',
                COMMENTS     => 'Juniper Networks, Inc. ex2200-24t-4g internet router, kernel JUNOS 11.1R3.5 #0: 2011-06-25 00:35:00 UTC     builder@briath.juniper.net:/volume/build/junos/11.1/release/11.1R3.5/obj-arm/bsd/kernels/JUNIPER-EX/kernel Build date: 2011-06-25 00:31:37 UTC Cop',
                CONTACT      => 'cricesr@dauphine.fr',
                NAME         => 'INTERUFR-219-ex2200-24',
                MEMORY       => '0',
                LOCATION     => 'CB',
                IPS          => {
                    IP => [
                        '128.0.0.1',
                        '128.0.0.127',
                        '128.0.0.16',
                        '128.0.0.32',
                        '192.168.1.219',
                    ],
                },
                MAC          => '78:fe:3d:d5:0e:c0',
                UPTIME       => '(9174471) 1 day, 1:29:04.71',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '4',
                        IFNAME           => 'lsi',
                        IFDESCR          => 'lsi',
                        IFTYPE           => '150',
                        IFSPEED          => '0',
                        IFMTU            => '1496',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4298) 0:00:42.98',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '5',
                        IFNAME           => 'dsc',
                        IFDESCR          => 'dsc',
                        IFTYPE           => '1',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4128) 0:00:41.28',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '6',
                        IFNAME           => 'lo0',
                        IFDESCR          => 'lo0',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4295) 0:00:42.95',
                        IFINOCTETS       => '131885047',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '131885047',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '7',
                        IFNAME           => 'tap',
                        IFDESCR          => 'tap',
                        IFTYPE           => '1',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4311) 0:00:43.11',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '8',
                        IFNAME           => 'gre',
                        IFDESCR          => 'gre',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4282) 0:00:42.82',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '9',
                        IFNAME           => 'ipip',
                        IFDESCR          => 'ipip',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4288) 0:00:42.88',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10',
                        IFNAME           => 'pime',
                        IFDESCR          => 'pime',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4309) 0:00:43.09',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '11',
                        IFNAME           => 'pimd',
                        IFDESCR          => 'pimd',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4307) 0:00:43.07',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '12',
                        IFNAME           => 'mtun',
                        IFDESCR          => 'mtun',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4304) 0:00:43.04',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '33',
                        IFNAME           => 'me0',
                        IFDESCR          => 'me0',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:ff',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4300) 0:00:43.00',
                        IFINOCTETS       => '14638812',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '34',
                        IFNAME           => 'me0.0',
                        IFDESCR          => 'me0.0',
                        IFTYPE           => '53',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        IP               => '192.168.1.219',
                        MAC              => '78:fe:3d:d5:0e:ff',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4302) 0:00:43.02',
                        IFINOCTETS       => '14638898',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3954144',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '37',
                        IFNAME           => 'bme0',
                        IFDESCR          => 'bme0',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1576',
                        MAC              => '00:0b:ca:fe:00:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4123) 0:00:41.23',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '13256588',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '38',
                        IFNAME           => 'bme0.32768',
                        IFDESCR          => 'bme0.32768',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1562',
                        IP               => '128.0.0.32',
                        MAC              => '00:0b:ca:fe:00:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4125) 0:00:41.25',
                        IFINOCTETS       => '3337783',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '126',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '501',
                        IFNAME           => 'ge-0/0/0',
                        IFDESCR          => 'ge-0/0/0',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4130) 0:00:41.30',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '502',
                        IFNAME           => 'ge-0/0/0.0',
                        IFDESCR          => 'ge-0/0/0.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:c0',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4131) 0:00:41.31',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '503',
                        IFNAME           => 'ge-0/0/1',
                        IFDESCR          => 'ge-0/0/1',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:c1',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4134) 0:00:41.34',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '504',
                        IFNAME           => 'ge-0/0/1.0',
                        IFDESCR          => 'ge-0/0/1.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:c1',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4136) 0:00:41.36',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '505',
                        IFNAME           => 'ge-0/0/10',
                        IFDESCR          => 'ge-0/0/10',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:ca',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4172) 0:00:41.72',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '506',
                        IFNAME           => 'ge-0/0/10.0',
                        IFDESCR          => 'ge-0/0/10.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:ca',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4172) 0:00:41.72',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '507',
                        IFNAME           => 'ge-0/0/11',
                        IFDESCR          => 'ge-0/0/11',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:cb',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4264) 0:00:42.64',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '508',
                        IFNAME           => 'ge-0/0/11.0',
                        IFDESCR          => 'ge-0/0/11.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:cb',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4264) 0:00:42.64',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '509',
                        IFNAME           => 'ge-0/0/12',
                        IFDESCR          => 'ge-0/0/12',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:cc',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4332) 0:00:43.32',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '510',
                        IFNAME           => 'ge-0/0/12.0',
                        IFDESCR          => 'ge-0/0/12.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:cc',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4332) 0:00:43.32',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '511',
                        IFNAME           => 'ge-0/0/13',
                        IFDESCR          => 'ge-0/0/13',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:cd',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4357) 0:00:43.57',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '512',
                        IFNAME           => 'ge-0/0/13.0',
                        IFDESCR          => 'ge-0/0/13.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:cd',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4357) 0:00:43.57',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '513',
                        IFNAME           => 'ge-0/0/14',
                        IFDESCR          => 'ge-0/0/14',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:ce',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4383) 0:00:43.83',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '514',
                        IFNAME           => 'ge-0/0/14.0',
                        IFDESCR          => 'ge-0/0/14.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:ce',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4383) 0:00:43.83',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '515',
                        IFNAME           => 'ge-0/0/15',
                        IFDESCR          => 'ge-0/0/15',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:cf',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4418) 0:00:44.18',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '516',
                        IFNAME           => 'ge-0/0/15.0',
                        IFDESCR          => 'ge-0/0/15.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:cf',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4418) 0:00:44.18',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '517',
                        IFNAME           => 'ge-0/0/16',
                        IFDESCR          => 'ge-0/0/16',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4450) 0:00:44.50',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '518',
                        IFNAME           => 'ge-0/0/16.0',
                        IFDESCR          => 'ge-0/0/16.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:d0',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4450) 0:00:44.50',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '519',
                        IFNAME           => 'ge-0/0/17',
                        IFDESCR          => 'ge-0/0/17',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:d1',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4479) 0:00:44.79',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '520',
                        IFNAME           => 'ge-0/0/17.0',
                        IFDESCR          => 'ge-0/0/17.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:d1',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4479) 0:00:44.79',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '521',
                        IFNAME           => 'ge-0/0/18',
                        IFDESCR          => 'ge-0/0/18',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:d2',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4511) 0:00:45.11',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '522',
                        IFNAME           => 'ge-0/0/18.0',
                        IFDESCR          => 'ge-0/0/18.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:d2',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4511) 0:00:45.11',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '523',
                        IFNAME           => 'ge-0/0/19',
                        IFDESCR          => 'ge-0/0/19',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:d3',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4536) 0:00:45.36',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '524',
                        IFNAME           => 'ge-0/0/19.0',
                        IFDESCR          => 'ge-0/0/19.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:d3',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4536) 0:00:45.36',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '525',
                        IFNAME           => 'ge-0/0/2',
                        IFDESCR          => 'ge-0/0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:c2',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4211) 0:00:42.11',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '526',
                        IFNAME           => 'ge-0/0/2.0',
                        IFDESCR          => 'ge-0/0/2.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:c2',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4213) 0:00:42.13',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '527',
                        IFNAME           => 'ge-0/0/20',
                        IFDESCR          => 'ge-0/0/20',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:d4',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4557) 0:00:45.57',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '528',
                        IFNAME           => 'ge-0/0/20.0',
                        IFDESCR          => 'ge-0/0/20.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:d4',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4557) 0:00:45.57',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '529',
                        IFNAME           => 'ge-0/0/21',
                        IFDESCR          => 'ge-0/0/21',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:d5',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4567) 0:00:45.67',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '530',
                        IFNAME           => 'ge-0/0/21.0',
                        IFDESCR          => 'ge-0/0/21.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:d5',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4567) 0:00:45.67',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '531',
                        IFNAME           => 'ge-0/0/22',
                        IFDESCR          => 'ge-0/0/22',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:d6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4587) 0:00:45.87',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '532',
                        IFNAME           => 'ge-0/0/22.0',
                        IFDESCR          => 'ge-0/0/22.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:d6',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4587) 0:00:45.87',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '533',
                        IFNAME           => 'ge-0/0/23',
                        IFDESCR          => 'ge-0/0/23',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:d7',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4618) 0:00:46.18',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '534',
                        IFNAME           => 'ge-0/0/23.0',
                        IFDESCR          => 'ge-0/0/23.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:d7',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4618) 0:00:46.18',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '535',
                        IFNAME           => 'ge-0/0/3',
                        IFDESCR          => 'ge-0/0/3',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:c3',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4236) 0:00:42.36',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '536',
                        IFNAME           => 'ge-0/0/3.0',
                        IFDESCR          => 'ge-0/0/3.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:c3',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4238) 0:00:42.38',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '537',
                        IFNAME           => 'ge-0/0/4',
                        IFDESCR          => 'ge-0/0/4',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:c4',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4239) 0:00:42.39',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '538',
                        IFNAME           => 'ge-0/0/4.0',
                        IFDESCR          => 'ge-0/0/4.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:c4',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4240) 0:00:42.40',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '539',
                        IFNAME           => 'ge-0/0/5',
                        IFDESCR          => 'ge-0/0/5',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:c5',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4242) 0:00:42.42',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '540',
                        IFNAME           => 'ge-0/0/5.0',
                        IFDESCR          => 'ge-0/0/5.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:c5',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4245) 0:00:42.45',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '541',
                        IFNAME           => 'ge-0/0/6',
                        IFDESCR          => 'ge-0/0/6',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:c6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4247) 0:00:42.47',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '542',
                        IFNAME           => 'ge-0/0/6.0',
                        IFDESCR          => 'ge-0/0/6.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:c6',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4250) 0:00:42.50',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '543',
                        IFNAME           => 'ge-0/0/7',
                        IFDESCR          => 'ge-0/0/7',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:c7',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4254) 0:00:42.54',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '544',
                        IFNAME           => 'ge-0/0/7.0',
                        IFDESCR          => 'ge-0/0/7.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:c7',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4257) 0:00:42.57',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '545',
                        IFNAME           => 'ge-0/0/8',
                        IFDESCR          => 'ge-0/0/8',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:c8',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4260) 0:00:42.60',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '546',
                        IFNAME           => 'ge-0/0/8.0',
                        IFDESCR          => 'ge-0/0/8.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:c8',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4266) 0:00:42.66',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '547',
                        IFNAME           => 'ge-0/0/9',
                        IFDESCR          => 'ge-0/0/9',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:c9',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4269) 0:00:42.69',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '548',
                        IFNAME           => 'ge-0/0/9.0',
                        IFDESCR          => 'ge-0/0/9.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:c9',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4271) 0:00:42.71',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '549',
                        IFNAME           => 'ge-0/1/0',
                        IFDESCR          => 'ge-0/1/0',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:d8',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4627) 0:00:46.27',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2760591156',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '742321097',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '550',
                        IFNAME           => 'ge-0/1/0.0',
                        IFDESCR          => 'ge-0/1/0.0',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:d8',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4627) 0:00:46.27',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1518484',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '6487435',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:10:5a:13:a5:47',
                                    '00:10:5a:1b:c5:be',
                                    '00:d0:b7:45:80:30',
                                    '00:18:f3:f0:0c:0e',
                                    '00:19:d1:82:ab:f6',
                                    '00:1b:2f:b3:c0:d5',
                                    '00:1b:2f:b3:c0:d7',
                                    '00:1c:c0:bd:d2:82',
                                    '00:1c:c0:bd:d7:79',
                                    '00:1c:c0:bd:d7:54',
                                    '00:1c:c0:bd:d9:1b',
                                    '00:1c:c0:bd:d9:3f',
                                    '00:1c:c0:dc:69:5a',
                                    '00:1c:c0:dc:6b:fa',
                                    '00:1c:c0:dc:6d:47',
                                    '00:1c:c0:dc:7a:ea',
                                    '00:1c:c0:dc:7b:17',
                                    '00:1c:c0:dc:7d:7f',
                                    '00:1c:c0:df:39:ee',
                                    '00:1c:c0:df:39:f6',
                                    '00:1c:c0:df:3a:8a',
                                    '00:1c:c0:df:3a:8b',
                                    '00:1c:c0:df:3a:1f',
                                    '00:1c:c0:df:3a:55',
                                    '00:03:22:01:9b:19',
                                    '00:27:0e:2d:f8:64',
                                    '00:27:0e:2d:f9:60',
                                    '00:40:0d:8a:8b:47',
                                    '00:50:da:7c:51:52',
                                    '00:50:da:7c:63:4c',
                                    '00:50:da:d8:4e:47',
                                    '00:50:04:82:ce:89',
                                    '00:50:04:a9:60:39',
                                    '00:50:04:50:54:e8',
                                    '00:60:08:64:12:81',
                                    '00:60:08:64:15:f0',
                                    '00:60:08:64:16:8c',
                                    '00:60:08:64:16:11',
                                    '00:60:08:64:16:3f',
                                    '00:60:08:64:16:46',
                                    '00:60:08:64:16:4c',
                                    '00:60:08:64:23:e5',
                                    '00:60:08:72:78:cb',
                                    '00:60:08:0c:01:7d',
                                    '00:60:08:9f:35:83',
                                    '00:60:08:63:fa:63',
                                    '78:e7:d1:a9:3c:2b',
                                    '8c:89:a5:3a:ba:20',
                                    'b4:b5:2f:54:c9:30',
                                    'bc:ae:c5:43:da:70',
                                    'c8:9c:dc:f3:e7:71',
                                    'f8:0f:41:36:13:75',
                                    'f8:0f:41:36:13:63',
                                    'f8:0f:41:36:49:6b',
                                    'f8:0f:41:36:49:03',
                                    'f8:0f:41:3b:13:6f',
                                    'f8:0f:41:3d:1e:e6',
                                    'f8:0f:41:3d:38:66',
                                    'f8:0f:41:3d:38:a0',
                                    'f8:0f:41:3d:38:d7',
                                    'f8:0f:41:3d:38:da',
                                    'f8:0f:41:3d:38:26',
                                    'f8:0f:41:3d:39:85',
                                    'f8:0f:41:3d:39:32',
                                    'f8:0f:41:3d:39:35',
                                    'f8:0f:41:3d:43:64',
                                    'f8:0f:41:3d:43:69',
                                    'f8:0f:41:3d:43:8b',
                                    'f8:0f:41:3d:47:00',
                                    'f8:0f:41:3d:48:95',
                                    'f8:0f:41:3d:48:c4',
                                    'f8:0f:41:3d:48:ca',
                                    'f8:0f:41:3d:48:59',
                                    'f8:0f:41:3e:0a:d1',
                                    'f8:0f:41:3e:0a:29',
                                    'f8:0f:41:3e:0b:c5',
                                    'f8:0f:41:3e:0b:d2',
                                    'f8:0f:41:3e:0c:bd',
                                    'f8:0f:41:3e:0c:33',
                                    'f8:0f:41:3e:07:37',
                                    'f8:0f:41:3e:09:2e',
                                    '20:cf:30:f0:82:d8',
                                    '20:cf:30:f0:82:e6',
                                    'f8:0f:41:3d:49:2a',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '555',
                        IFNAME           => 'ge-0/1/3',
                        IFDESCR          => 'ge-0/1/3',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:db',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4674) 0:00:46.74',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '738384759',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2761755337',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '556',
                        IFNAME           => 'jsrv',
                        IFDESCR          => 'jsrv',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1518',
                        MAC              => '78:fe:3d:d5:0e:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4290) 0:00:42.90',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '557',
                        IFNAME           => 'jsrv.1',
                        IFDESCR          => 'jsrv.1',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        IP               => '128.0.0.127',
                        MAC              => '78:fe:3d:d5:0e:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4293) 0:00:42.93',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '42',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '558',
                        IFNAME           => 'vlan',
                        IFDESCR          => 'vlan',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1518',
                        MAC              => '78:fe:3d:d5:0e:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4316) 0:00:43.16',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '559',
                        IFNAME           => 'ge-0/1/3.0',
                        IFDESCR          => 'ge-0/1/3.0',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:db',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4674) 0:00:46.74',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '796377',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '6009138',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:11:85:69:2f:08',
                                    '00:11:85:69:2f:09',
                                    '00:12:79:39:3c:6e',
                                    '00:12:79:39:3c:30',
                                    '00:15:60:a8:9a:31',
                                    '00:15:60:a8:9a:32',
                                    '00:15:60:a8:c8:a5',
                                    '00:15:60:a8:c8:a6',
                                    '00:24:81:a5:8c:99',
                                    '00:24:81:a5:8c:9a',
                                    '00:24:81:a5:ad:82',
                                    '00:24:81:a5:ad:84',
                                    '00:25:b3:aa:d6:b6',
                                    '00:50:56:b7:0b:86',
                                    '00:50:56:b7:20:69',
                                    '78:e3:b5:12:97:d8',
                                    '78:e3:b5:12:97:da',
                                    '78:e3:b5:12:a7:0a',
                                    '78:e3:b5:12:a7:08',
                                    '9c:8e:99:14:8a:9c',
                                    '9c:8e:99:14:8a:9e',
                                    '9c:8e:99:14:8a:a4',
                                    '9c:8e:99:14:8a:a6',
                                    'b4:99:ba:c0:eb:a4',
                                    'b4:99:ba:c0:eb:a6',
                                    'b4:99:ba:c0:eb:a8',
                                    'b4:99:ba:c0:eb:aa',
                                    'e4:11:5b:b0:29:fe',
                                    'e4:11:5b:b0:2a:02',
                                    'e4:11:5b:b0:2a:04',
                                    '18:33:9d:e7:15:1a',
                                ],
                            }
                        }
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Juniper',
                TYPE         => 'NETWORKING',
                MODEL        => 'EX2200',
                COMMENTS     => 'Juniper Networks, Inc. ex2200-24t-4g internet router, kernel JUNOS 11.1R3.5 #0: 2011-06-25 00:35:00 UTC     builder@briath.juniper.net:/volume/build/junos/11.1/release/11.1R3.5/obj-arm/bsd/kernels/JUNIPER-EX/kernel Build date: 2011-06-25 00:31:37 UTC Cop',
                CONTACT      => 'cricesr@dauphine.fr',
                NAME         => 'INTERUFR-219-ex2200-24',
                MEMORY       => '0',
                LOCATION     => 'CB',
                SERIAL       => 'CW0211513175',
                IPS          => {
                    IP => [
                        '128.0.0.1',
                        '128.0.0.127',
                        '128.0.0.16',
                        '128.0.0.32',
                        '192.168.1.219',
                    ],
                },
                MAC          => '78:fe:3d:d5:0e:c0',
                UPTIME       => '(9174471) 1 day, 1:29:04.71',
                RAM          => '512',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '4',
                        IFNAME           => 'lsi',
                        IFDESCR          => 'lsi',
                        IFTYPE           => '150',
                        IFSPEED          => '0',
                        IFMTU            => '1496',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4298) 0:00:42.98',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '5',
                        IFNAME           => 'dsc',
                        IFDESCR          => 'dsc',
                        IFTYPE           => '1',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4128) 0:00:41.28',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '6',
                        IFNAME           => 'lo0',
                        IFDESCR          => 'lo0',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4295) 0:00:42.95',
                        IFINOCTETS       => '131885047',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '131885047',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '7',
                        IFNAME           => 'tap',
                        IFDESCR          => 'tap',
                        IFTYPE           => '1',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4311) 0:00:43.11',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '8',
                        IFNAME           => 'gre',
                        IFDESCR          => 'gre',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4282) 0:00:42.82',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '9',
                        IFNAME           => 'ipip',
                        IFDESCR          => 'ipip',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4288) 0:00:42.88',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10',
                        IFNAME           => 'pime',
                        IFDESCR          => 'pime',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4309) 0:00:43.09',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '11',
                        IFNAME           => 'pimd',
                        IFDESCR          => 'pimd',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4307) 0:00:43.07',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '12',
                        IFNAME           => 'mtun',
                        IFDESCR          => 'mtun',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4304) 0:00:43.04',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '33',
                        IFNAME           => 'me0',
                        IFDESCR          => 'me0',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:ff',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4300) 0:00:43.00',
                        IFINOCTETS       => '14638812',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '34',
                        IFNAME           => 'me0.0',
                        IFDESCR          => 'me0.0',
                        IFTYPE           => '53',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        IP               => '192.168.1.219',
                        MAC              => '78:fe:3d:d5:0e:ff',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4302) 0:00:43.02',
                        IFINOCTETS       => '14638898',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3954144',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '37',
                        IFNAME           => 'bme0',
                        IFDESCR          => 'bme0',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1576',
                        MAC              => '00:0b:ca:fe:00:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4123) 0:00:41.23',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '13256588',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '38',
                        IFNAME           => 'bme0.32768',
                        IFDESCR          => 'bme0.32768',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1562',
                        IP               => '128.0.0.32',
                        MAC              => '00:0b:ca:fe:00:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4125) 0:00:41.25',
                        IFINOCTETS       => '3337783',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '126',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '501',
                        IFNAME           => 'ge-0/0/0',
                        IFDESCR          => 'ge-0/0/0',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4130) 0:00:41.30',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '502',
                        IFNAME           => 'ge-0/0/0.0',
                        IFDESCR          => 'ge-0/0/0.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:c0',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4131) 0:00:41.31',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '503',
                        IFNAME           => 'ge-0/0/1',
                        IFDESCR          => 'ge-0/0/1',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:c1',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4134) 0:00:41.34',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '504',
                        IFNAME           => 'ge-0/0/1.0',
                        IFDESCR          => 'ge-0/0/1.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:c1',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4136) 0:00:41.36',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '505',
                        IFNAME           => 'ge-0/0/10',
                        IFDESCR          => 'ge-0/0/10',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:ca',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4172) 0:00:41.72',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '506',
                        IFNAME           => 'ge-0/0/10.0',
                        IFDESCR          => 'ge-0/0/10.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:ca',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4172) 0:00:41.72',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '507',
                        IFNAME           => 'ge-0/0/11',
                        IFDESCR          => 'ge-0/0/11',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:cb',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4264) 0:00:42.64',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '508',
                        IFNAME           => 'ge-0/0/11.0',
                        IFDESCR          => 'ge-0/0/11.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:cb',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4264) 0:00:42.64',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '509',
                        IFNAME           => 'ge-0/0/12',
                        IFDESCR          => 'ge-0/0/12',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:cc',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4332) 0:00:43.32',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '510',
                        IFNAME           => 'ge-0/0/12.0',
                        IFDESCR          => 'ge-0/0/12.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:cc',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4332) 0:00:43.32',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '511',
                        IFNAME           => 'ge-0/0/13',
                        IFDESCR          => 'ge-0/0/13',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:cd',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4357) 0:00:43.57',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '512',
                        IFNAME           => 'ge-0/0/13.0',
                        IFDESCR          => 'ge-0/0/13.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:cd',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4357) 0:00:43.57',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '513',
                        IFNAME           => 'ge-0/0/14',
                        IFDESCR          => 'ge-0/0/14',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:ce',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4383) 0:00:43.83',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '514',
                        IFNAME           => 'ge-0/0/14.0',
                        IFDESCR          => 'ge-0/0/14.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:ce',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4383) 0:00:43.83',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '515',
                        IFNAME           => 'ge-0/0/15',
                        IFDESCR          => 'ge-0/0/15',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:cf',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4418) 0:00:44.18',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '516',
                        IFNAME           => 'ge-0/0/15.0',
                        IFDESCR          => 'ge-0/0/15.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:cf',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4418) 0:00:44.18',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '517',
                        IFNAME           => 'ge-0/0/16',
                        IFDESCR          => 'ge-0/0/16',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4450) 0:00:44.50',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '518',
                        IFNAME           => 'ge-0/0/16.0',
                        IFDESCR          => 'ge-0/0/16.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:d0',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4450) 0:00:44.50',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '519',
                        IFNAME           => 'ge-0/0/17',
                        IFDESCR          => 'ge-0/0/17',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:d1',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4479) 0:00:44.79',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '520',
                        IFNAME           => 'ge-0/0/17.0',
                        IFDESCR          => 'ge-0/0/17.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:d1',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4479) 0:00:44.79',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '521',
                        IFNAME           => 'ge-0/0/18',
                        IFDESCR          => 'ge-0/0/18',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:d2',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4511) 0:00:45.11',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '522',
                        IFNAME           => 'ge-0/0/18.0',
                        IFDESCR          => 'ge-0/0/18.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:d2',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4511) 0:00:45.11',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '523',
                        IFNAME           => 'ge-0/0/19',
                        IFDESCR          => 'ge-0/0/19',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:d3',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4536) 0:00:45.36',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '524',
                        IFNAME           => 'ge-0/0/19.0',
                        IFDESCR          => 'ge-0/0/19.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:d3',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4536) 0:00:45.36',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '525',
                        IFNAME           => 'ge-0/0/2',
                        IFDESCR          => 'ge-0/0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:c2',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4211) 0:00:42.11',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '526',
                        IFNAME           => 'ge-0/0/2.0',
                        IFDESCR          => 'ge-0/0/2.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:c2',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4213) 0:00:42.13',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '527',
                        IFNAME           => 'ge-0/0/20',
                        IFDESCR          => 'ge-0/0/20',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:d4',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4557) 0:00:45.57',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '528',
                        IFNAME           => 'ge-0/0/20.0',
                        IFDESCR          => 'ge-0/0/20.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:d4',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4557) 0:00:45.57',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '529',
                        IFNAME           => 'ge-0/0/21',
                        IFDESCR          => 'ge-0/0/21',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:d5',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4567) 0:00:45.67',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '530',
                        IFNAME           => 'ge-0/0/21.0',
                        IFDESCR          => 'ge-0/0/21.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:d5',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4567) 0:00:45.67',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '531',
                        IFNAME           => 'ge-0/0/22',
                        IFDESCR          => 'ge-0/0/22',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:d6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4587) 0:00:45.87',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '532',
                        IFNAME           => 'ge-0/0/22.0',
                        IFDESCR          => 'ge-0/0/22.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:d6',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4587) 0:00:45.87',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '533',
                        IFNAME           => 'ge-0/0/23',
                        IFDESCR          => 'ge-0/0/23',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:d7',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4618) 0:00:46.18',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '534',
                        IFNAME           => 'ge-0/0/23.0',
                        IFDESCR          => 'ge-0/0/23.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:d7',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4618) 0:00:46.18',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '535',
                        IFNAME           => 'ge-0/0/3',
                        IFDESCR          => 'ge-0/0/3',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:c3',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4236) 0:00:42.36',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '536',
                        IFNAME           => 'ge-0/0/3.0',
                        IFDESCR          => 'ge-0/0/3.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:c3',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4238) 0:00:42.38',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '537',
                        IFNAME           => 'ge-0/0/4',
                        IFDESCR          => 'ge-0/0/4',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:c4',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4239) 0:00:42.39',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '538',
                        IFNAME           => 'ge-0/0/4.0',
                        IFDESCR          => 'ge-0/0/4.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:c4',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4240) 0:00:42.40',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '539',
                        IFNAME           => 'ge-0/0/5',
                        IFDESCR          => 'ge-0/0/5',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:c5',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4242) 0:00:42.42',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '540',
                        IFNAME           => 'ge-0/0/5.0',
                        IFDESCR          => 'ge-0/0/5.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:c5',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4245) 0:00:42.45',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '541',
                        IFNAME           => 'ge-0/0/6',
                        IFDESCR          => 'ge-0/0/6',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:c6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4247) 0:00:42.47',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '542',
                        IFNAME           => 'ge-0/0/6.0',
                        IFDESCR          => 'ge-0/0/6.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:c6',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4250) 0:00:42.50',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '543',
                        IFNAME           => 'ge-0/0/7',
                        IFDESCR          => 'ge-0/0/7',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:c7',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4254) 0:00:42.54',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '544',
                        IFNAME           => 'ge-0/0/7.0',
                        IFDESCR          => 'ge-0/0/7.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:c7',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4257) 0:00:42.57',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '545',
                        IFNAME           => 'ge-0/0/8',
                        IFDESCR          => 'ge-0/0/8',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:c8',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4260) 0:00:42.60',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '546',
                        IFNAME           => 'ge-0/0/8.0',
                        IFDESCR          => 'ge-0/0/8.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:c8',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4266) 0:00:42.66',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '547',
                        IFNAME           => 'ge-0/0/9',
                        IFDESCR          => 'ge-0/0/9',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:c9',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4269) 0:00:42.69',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '548',
                        IFNAME           => 'ge-0/0/9.0',
                        IFDESCR          => 'ge-0/0/9.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:c9',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4271) 0:00:42.71',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '549',
                        IFNAME           => 'ge-0/1/0',
                        IFDESCR          => 'ge-0/1/0',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:d8',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4627) 0:00:46.27',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2760591156',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '742321097',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '550',
                        IFNAME           => 'ge-0/1/0.0',
                        IFDESCR          => 'ge-0/1/0.0',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:d8',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4627) 0:00:46.27',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1518484',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '6487435',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:10:5a:13:a5:47',
                                    '00:10:5a:1b:c5:be',
                                    '00:d0:b7:45:80:30',
                                    '00:18:f3:f0:0c:0e',
                                    '00:19:d1:82:ab:f6',
                                    '00:1b:2f:b3:c0:d5',
                                    '00:1b:2f:b3:c0:d7',
                                    '00:1c:c0:bd:d2:82',
                                    '00:1c:c0:bd:d7:79',
                                    '00:1c:c0:bd:d7:54',
                                    '00:1c:c0:bd:d9:1b',
                                    '00:1c:c0:bd:d9:3f',
                                    '00:1c:c0:dc:69:5a',
                                    '00:1c:c0:dc:6b:fa',
                                    '00:1c:c0:dc:6d:47',
                                    '00:1c:c0:dc:7a:ea',
                                    '00:1c:c0:dc:7b:17',
                                    '00:1c:c0:dc:7d:7f',
                                    '00:1c:c0:df:39:ee',
                                    '00:1c:c0:df:39:f6',
                                    '00:1c:c0:df:3a:8a',
                                    '00:1c:c0:df:3a:8b',
                                    '00:1c:c0:df:3a:1f',
                                    '00:1c:c0:df:3a:55',
                                    '00:03:22:01:9b:19',
                                    '00:27:0e:2d:f8:64',
                                    '00:27:0e:2d:f9:60',
                                    '00:40:0d:8a:8b:47',
                                    '00:50:da:7c:51:52',
                                    '00:50:da:7c:63:4c',
                                    '00:50:da:d8:4e:47',
                                    '00:50:04:82:ce:89',
                                    '00:50:04:a9:60:39',
                                    '00:50:04:50:54:e8',
                                    '00:60:08:64:12:81',
                                    '00:60:08:64:15:f0',
                                    '00:60:08:64:16:8c',
                                    '00:60:08:64:16:11',
                                    '00:60:08:64:16:3f',
                                    '00:60:08:64:16:46',
                                    '00:60:08:64:16:4c',
                                    '00:60:08:64:23:e5',
                                    '00:60:08:72:78:cb',
                                    '00:60:08:0c:01:7d',
                                    '00:60:08:9f:35:83',
                                    '00:60:08:63:fa:63',
                                    '78:e7:d1:a9:3c:2b',
                                    '8c:89:a5:3a:ba:20',
                                    'b4:b5:2f:54:c9:30',
                                    'bc:ae:c5:43:da:70',
                                    'c8:9c:dc:f3:e7:71',
                                    'f8:0f:41:36:13:75',
                                    'f8:0f:41:36:13:63',
                                    'f8:0f:41:36:49:6b',
                                    'f8:0f:41:36:49:03',
                                    'f8:0f:41:3b:13:6f',
                                    'f8:0f:41:3d:1e:e6',
                                    'f8:0f:41:3d:38:66',
                                    'f8:0f:41:3d:38:a0',
                                    'f8:0f:41:3d:38:d7',
                                    'f8:0f:41:3d:38:da',
                                    'f8:0f:41:3d:38:26',
                                    'f8:0f:41:3d:39:85',
                                    'f8:0f:41:3d:39:32',
                                    'f8:0f:41:3d:39:35',
                                    'f8:0f:41:3d:43:64',
                                    'f8:0f:41:3d:43:69',
                                    'f8:0f:41:3d:43:8b',
                                    'f8:0f:41:3d:47:00',
                                    'f8:0f:41:3d:48:95',
                                    'f8:0f:41:3d:48:c4',
                                    'f8:0f:41:3d:48:ca',
                                    'f8:0f:41:3d:48:59',
                                    'f8:0f:41:3e:0a:d1',
                                    'f8:0f:41:3e:0a:29',
                                    'f8:0f:41:3e:0b:c5',
                                    'f8:0f:41:3e:0b:d2',
                                    'f8:0f:41:3e:0c:bd',
                                    'f8:0f:41:3e:0c:33',
                                    'f8:0f:41:3e:07:37',
                                    'f8:0f:41:3e:09:2e',
                                    '20:cf:30:f0:82:d8',
                                    '20:cf:30:f0:82:e6',
                                    'f8:0f:41:3d:49:2a',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '555',
                        IFNAME           => 'ge-0/1/3',
                        IFDESCR          => 'ge-0/1/3',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:db',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4674) 0:00:46.74',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '738384759',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2761755337',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '556',
                        IFNAME           => 'jsrv',
                        IFDESCR          => 'jsrv',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1518',
                        MAC              => '78:fe:3d:d5:0e:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4290) 0:00:42.90',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '557',
                        IFNAME           => 'jsrv.1',
                        IFDESCR          => 'jsrv.1',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        IP               => '128.0.0.127',
                        MAC              => '78:fe:3d:d5:0e:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4293) 0:00:42.93',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '42',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '558',
                        IFNAME           => 'vlan',
                        IFDESCR          => 'vlan',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1518',
                        MAC              => '78:fe:3d:d5:0e:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4316) 0:00:43.16',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '559',
                        IFNAME           => 'ge-0/1/3.0',
                        IFDESCR          => 'ge-0/1/3.0',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:db',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4674) 0:00:46.74',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '796377',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '6009138',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:11:85:69:2f:08',
                                    '00:11:85:69:2f:09',
                                    '00:12:79:39:3c:6e',
                                    '00:12:79:39:3c:30',
                                    '00:15:60:a8:9a:31',
                                    '00:15:60:a8:9a:32',
                                    '00:15:60:a8:c8:a5',
                                    '00:15:60:a8:c8:a6',
                                    '00:24:81:a5:8c:99',
                                    '00:24:81:a5:8c:9a',
                                    '00:24:81:a5:ad:82',
                                    '00:24:81:a5:ad:84',
                                    '00:25:b3:aa:d6:b6',
                                    '00:50:56:b7:0b:86',
                                    '00:50:56:b7:20:69',
                                    '78:e3:b5:12:97:d8',
                                    '78:e3:b5:12:97:da',
                                    '78:e3:b5:12:a7:0a',
                                    '78:e3:b5:12:a7:08',
                                    '9c:8e:99:14:8a:9c',
                                    '9c:8e:99:14:8a:9e',
                                    '9c:8e:99:14:8a:a4',
                                    '9c:8e:99:14:8a:a6',
                                    'b4:99:ba:c0:eb:a4',
                                    'b4:99:ba:c0:eb:a6',
                                    'b4:99:ba:c0:eb:a8',
                                    'b4:99:ba:c0:eb:aa',
                                    'e4:11:5b:b0:29:fe',
                                    'e4:11:5b:b0:2a:02',
                                    'e4:11:5b:b0:2a:04',
                                    '18:33:9d:e7:15:1a',
                                ],
                            }
                        }
                    },
                ]
            },
        },
    ],
    'juniper/ex2200.04.walk' => [
        {
            MANUFACTURER => 'Juniper',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Juniper Networks, Inc. ex2200-48t-4g internet router, kernel JUNOS 11.1R3.5 #0: 2011-06-25 00:35:00 UTC     builder@briath.juniper.net:/volume/build/junos/11.1/release/11.1R3.5/obj-arm/bsd/kernels/JUNIPER-EX/kernel Build date: 2011-06-25 00:31:37 UTC Cop',
            SNMPHOSTNAME => 'AB-BU6-132-ex2200-48',
            MAC          => '78:fe:3d:37:5e:c0',
            MODEL        => 'EX2200',
        },
        {
            MANUFACTURER => 'Juniper',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Juniper Networks, Inc. ex2200-48t-4g internet router, kernel JUNOS 11.1R3.5 #0: 2011-06-25 00:35:00 UTC     builder@briath.juniper.net:/volume/build/junos/11.1/release/11.1R3.5/obj-arm/bsd/kernels/JUNIPER-EX/kernel Build date: 2011-06-25 00:31:37 UTC Cop',
            SNMPHOSTNAME => 'AB-BU6-132-ex2200-48',
            MAC          => '78:fe:3d:37:5e:c0',
            MODELSNMP    => 'Networking2190',
            MODEL        => 'EX2200',
            FIRMWARE     => undef,
            SERIAL       => 'CU0211450517',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Juniper',
                TYPE         => 'NETWORKING',
                MODEL        => 'EX2200',
                COMMENTS     => 'Juniper Networks, Inc. ex2200-48t-4g internet router, kernel JUNOS 11.1R3.5 #0: 2011-06-25 00:35:00 UTC     builder@briath.juniper.net:/volume/build/junos/11.1/release/11.1R3.5/obj-arm/bsd/kernels/JUNIPER-EX/kernel Build date: 2011-06-25 00:31:37 UTC Cop',
                CONTACT      => 'cricesr@dauphine.fr',
                NAME         => 'AB-BU6-132-ex2200-48',
                MEMORY       => '0',
                LOCATION     => 'AB-BU6',
                IPS          => {
                    IP => [
                        '128.0.0.1',
                        '128.0.0.127',
                        '128.0.0.16',
                        '128.0.0.32',
                        '192.168.1.132',
                    ],
                },
                MAC          => '78:fe:3d:37:5e:c0',
                UPTIME       => '(1514669572) 175 days, 7:24:55.72',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '4',
                        IFNAME           => 'lsi',
                        IFDESCR          => 'lsi',
                        IFTYPE           => '150',
                        IFSPEED          => '0',
                        IFMTU            => '1496',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3055) 0:00:30.55',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '5',
                        IFNAME           => 'dsc',
                        IFDESCR          => 'dsc',
                        IFTYPE           => '1',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3012) 0:00:30.12',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '6',
                        IFNAME           => 'lo0',
                        IFDESCR          => 'lo0',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3019) 0:00:30.19',
                        IFINOCTETS       => '4148021786',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4148591022',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '7',
                        IFNAME           => 'tap',
                        IFDESCR          => 'tap',
                        IFTYPE           => '1',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3066) 0:00:30.66',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '8',
                        IFNAME           => 'gre',
                        IFDESCR          => 'gre',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3014) 0:00:30.14',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '9',
                        IFNAME           => 'ipip',
                        IFDESCR          => 'ipip',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3015) 0:00:30.15',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10',
                        IFNAME           => 'pime',
                        IFDESCR          => 'pime',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3065) 0:00:30.65',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '11',
                        IFNAME           => 'pimd',
                        IFDESCR          => 'pimd',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3063) 0:00:30.63',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '12',
                        IFNAME           => 'mtun',
                        IFDESCR          => 'mtun',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3060) 0:00:30.60',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '33',
                        IFNAME           => 'me0',
                        IFDESCR          => 'me0',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:ff',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3058) 0:00:30.58',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '37',
                        IFNAME           => 'bme0',
                        IFDESCR          => 'bme0',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1576',
                        MAC              => '00:0b:ca:fe:00:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3010) 0:00:30.10',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '901896814',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '38',
                        IFNAME           => 'bme0.32768',
                        IFDESCR          => 'bme0.32768',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1562',
                        IP               => '128.0.0.32',
                        MAC              => '00:0b:ca:fe:00:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3011) 0:00:30.11',
                        IFINOCTETS       => '2267152155',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '126',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '501',
                        IFNAME           => 'ge-0/0/0',
                        IFDESCR          => 'ge-0/0/0',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1513913595) 175 days, 5:18:55.95',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '62430575',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2121260600',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '502',
                        IFNAME           => 'ge-0/0/0.0',
                        IFDESCR          => 'ge-0/0/0.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1513913595) 175 days, 5:18:55.95',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '614461',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '323610',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:24:be:b6:4c:20',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '503',
                        IFNAME           => 'ge-0/0/1',
                        IFDESCR          => 'ge-0/0/1',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:c1',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1507307600) 174 days, 10:57:56.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '147698220',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '886946729',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '504',
                        IFNAME           => 'ge-0/0/1.0',
                        IFDESCR          => 'ge-0/0/1.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:c1',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1507307600) 174 days, 10:57:56.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1758171',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '754660',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '505',
                        IFNAME           => 'ge-0/0/10',
                        IFDESCR          => 'ge-0/0/10',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:ca',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1202418760) 139 days, 4:03:07.60',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '33040562',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '919887004',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '506',
                        IFNAME           => 'ge-0/0/10.0',
                        IFDESCR          => 'ge-0/0/10.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:ca',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1202418760) 139 days, 4:03:07.60',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '260404',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '113845',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '507',
                        IFNAME           => 'ge-0/0/11',
                        IFDESCR          => 'ge-0/0/11',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:cb',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1204402388) 139 days, 9:33:43.88',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '23866591',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '573739283',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '508',
                        IFNAME           => 'ge-0/0/11.0',
                        IFDESCR          => 'ge-0/0/11.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:cb',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1204402388) 139 days, 9:33:43.88',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '687393',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '75969',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '509',
                        IFNAME           => 'ge-0/0/12',
                        IFDESCR          => 'ge-0/0/12',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:cc',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1454505788) 168 days, 8:17:37.88',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '65490962',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3128608219',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '510',
                        IFNAME           => 'ge-0/0/12.0',
                        IFDESCR          => 'ge-0/0/12.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:cc',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1454505788) 168 days, 8:17:37.88',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1205122',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '668789',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '511',
                        IFNAME           => 'ge-0/0/13',
                        IFDESCR          => 'ge-0/0/13',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:cd',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1383988034) 160 days, 4:24:40.34',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '50434211',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2070139092',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '512',
                        IFNAME           => 'ge-0/0/13.0',
                        IFDESCR          => 'ge-0/0/13.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:cd',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1383988034) 160 days, 4:24:40.34',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '390894',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '131871',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '513',
                        IFNAME           => 'ge-0/0/14',
                        IFDESCR          => 'ge-0/0/14',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:ce',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1392608516) 161 days, 4:21:25.16',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '73541065',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2042948528',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '514',
                        IFNAME           => 'ge-0/0/14.0',
                        IFDESCR          => 'ge-0/0/14.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:ce',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1392608516) 161 days, 4:21:25.16',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '247639',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '142940',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '515',
                        IFNAME           => 'ge-0/0/15',
                        IFDESCR          => 'ge-0/0/15',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:cf',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1383987392) 160 days, 4:24:33.92',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '10291556',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '920149549',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '516',
                        IFNAME           => 'ge-0/0/15.0',
                        IFDESCR          => 'ge-0/0/15.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:cf',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1383987392) 160 days, 4:24:33.92',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '624396',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '193755',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '517',
                        IFNAME           => 'ge-0/0/16',
                        IFDESCR          => 'ge-0/0/16',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1402988034) 162 days, 9:11:20.34',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '144694897',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '373175314',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '518',
                        IFNAME           => 'ge-0/0/16.0',
                        IFDESCR          => 'ge-0/0/16.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:d0',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1402988034) 162 days, 9:11:20.34',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '4168655',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '800961',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '519',
                        IFNAME           => 'ge-0/0/17',
                        IFDESCR          => 'ge-0/0/17',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:d1',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1505111362) 174 days, 4:51:53.62',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '112282597',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3622860141',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '520',
                        IFNAME           => 'ge-0/0/17.0',
                        IFDESCR          => 'ge-0/0/17.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:d1',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1505111362) 174 days, 4:51:53.62',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3263756',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '388748',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '521',
                        IFNAME           => 'ge-0/0/18',
                        IFDESCR          => 'ge-0/0/18',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:d2',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1143701810) 132 days, 8:56:58.10',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '69571870',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2110991844',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '522',
                        IFNAME           => 'ge-0/0/18.0',
                        IFDESCR          => 'ge-0/0/18.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:d2',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1143701810) 132 days, 8:56:58.10',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2358039',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '498770',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '523',
                        IFNAME           => 'ge-0/0/19',
                        IFDESCR          => 'ge-0/0/19',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:d3',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1143887182) 132 days, 9:27:51.82',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '54665076',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1198628365',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '524',
                        IFNAME           => 'ge-0/0/19.0',
                        IFDESCR          => 'ge-0/0/19.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:d3',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1143887182) 132 days, 9:27:51.82',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '844445',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '84168',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '525',
                        IFNAME           => 'ge-0/0/2',
                        IFDESCR          => 'ge-0/0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:c2',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1514274855) 175 days, 6:19:08.55',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '71549018',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2214237751',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '526',
                        IFNAME           => 'ge-0/0/2.0',
                        IFDESCR          => 'ge-0/0/2.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:c2',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1514274855) 175 days, 6:19:08.55',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1344926',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '216986',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:26:b0:f1:25:3e',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '527',
                        IFNAME           => 'ge-0/0/20',
                        IFDESCR          => 'ge-0/0/20',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:d4',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1031918668) 119 days, 10:26:26.68',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '101162940',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3191603905',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '528',
                        IFNAME           => 'ge-0/0/20.0',
                        IFDESCR          => 'ge-0/0/20.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:d4',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1031918668) 119 days, 10:26:26.68',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '287186',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '331734',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '529',
                        IFNAME           => 'ge-0/0/21',
                        IFDESCR          => 'ge-0/0/21',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:d5',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1452971670) 168 days, 4:01:56.70',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '45333984',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1112146726',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '530',
                        IFNAME           => 'ge-0/0/21.0',
                        IFDESCR          => 'ge-0/0/21.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:d5',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1452971670) 168 days, 4:01:56.70',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2170170',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '118187',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '531',
                        IFNAME           => 'ge-0/0/22',
                        IFDESCR          => 'ge-0/0/22',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:d6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1507744280) 174 days, 12:10:42.80',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '349227121',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2349516312',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '532',
                        IFNAME           => 'ge-0/0/22.0',
                        IFDESCR          => 'ge-0/0/22.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:d6',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1507744280) 174 days, 12:10:42.80',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '7875686',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '837854',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '533',
                        IFNAME           => 'ge-0/0/23',
                        IFDESCR          => 'ge-0/0/23',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:d7',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1384857878) 160 days, 6:49:38.78',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '63700153',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3770626360',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '534',
                        IFNAME           => 'ge-0/0/23.0',
                        IFDESCR          => 'ge-0/0/23.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:d7',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1384857878) 160 days, 6:49:38.78',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1953525',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '505220',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '535',
                        IFNAME           => 'ge-0/0/24',
                        IFDESCR          => 'ge-0/0/24',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:d8',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1506337000) 174 days, 8:16:10.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '24341650',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1675279409',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '536',
                        IFNAME           => 'ge-0/0/24.0',
                        IFDESCR          => 'ge-0/0/24.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:d8',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1506337000) 174 days, 8:16:10.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '299238',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '215960',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '537',
                        IFNAME           => 'ge-0/0/25',
                        IFDESCR          => 'ge-0/0/25',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:d9',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1506965500) 174 days, 10:00:55.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '149804990',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '958374164',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '538',
                        IFNAME           => 'ge-0/0/25.0',
                        IFDESCR          => 'ge-0/0/25.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:d9',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1506965500) 174 days, 10:00:55.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3824745',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '429062',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '539',
                        IFNAME           => 'ge-0/0/26',
                        IFDESCR          => 'ge-0/0/26',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:da',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1030566650) 119 days, 6:41:06.50',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '8707382',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '314497846',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '540',
                        IFNAME           => 'ge-0/0/26.0',
                        IFDESCR          => 'ge-0/0/26.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:da',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1030566650) 119 days, 6:41:06.50',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '250977',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '6710',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '541',
                        IFNAME           => 'ge-0/0/27',
                        IFDESCR          => 'ge-0/0/27',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:db',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1507221140) 174 days, 10:43:31.40',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '59953469',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2945748283',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '542',
                        IFNAME           => 'ge-0/0/27.0',
                        IFDESCR          => 'ge-0/0/27.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:db',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1507221140) 174 days, 10:43:31.40',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '424630',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '118141',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '543',
                        IFNAME           => 'ge-0/0/28',
                        IFDESCR          => 'ge-0/0/28',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:dc',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(850490968) 98 days, 10:28:29.68',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '35974557',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '801954910',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '544',
                        IFNAME           => 'ge-0/0/28.0',
                        IFDESCR          => 'ge-0/0/28.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:dc',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(850490968) 98 days, 10:28:29.68',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1732098',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '460',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '545',
                        IFNAME           => 'ge-0/0/29',
                        IFDESCR          => 'ge-0/0/29',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:dd',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1470728810) 170 days, 5:21:28.10',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '62331862',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2935236434',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '546',
                        IFNAME           => 'ge-0/0/29.0',
                        IFDESCR          => 'ge-0/0/29.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:dd',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1470728810) 170 days, 5:21:28.10',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1758447',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '265039',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '547',
                        IFNAME           => 'ge-0/0/3',
                        IFDESCR          => 'ge-0/0/3',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:c3',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1092023384) 126 days, 9:23:53.84',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '63492350',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3428946165',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '548',
                        IFNAME           => 'ge-0/0/3.0',
                        IFDESCR          => 'ge-0/0/3.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:c3',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1092023384) 126 days, 9:23:53.84',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '671676',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '309544',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '549',
                        IFNAME           => 'ge-0/0/30',
                        IFDESCR          => 'ge-0/0/30',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:de',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1470404984) 170 days, 4:27:29.84',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '7460415',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '490225744',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '550',
                        IFNAME           => 'ge-0/0/30.0',
                        IFDESCR          => 'ge-0/0/30.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:de',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1470404984) 170 days, 4:27:29.84',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '350036',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '115652',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '551',
                        IFNAME           => 'ge-0/0/31',
                        IFDESCR          => 'ge-0/0/31',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:df',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1110357572) 128 days, 12:19:35.72',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '125852225',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1174250796',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '552',
                        IFNAME           => 'ge-0/0/31.0',
                        IFDESCR          => 'ge-0/0/31.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:df',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1110357572) 128 days, 12:19:35.72',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3504165',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '647546',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '553',
                        IFNAME           => 'ge-0/0/32',
                        IFDESCR          => 'ge-0/0/32',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:e0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1384810132) 160 days, 6:41:41.32',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '124837521',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3504587939',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '554',
                        IFNAME           => 'ge-0/0/32.0',
                        IFDESCR          => 'ge-0/0/32.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:e0',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1384810132) 160 days, 6:41:41.32',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3993337',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '566590',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '555',
                        IFNAME           => 'ge-0/0/33',
                        IFDESCR          => 'ge-0/0/33',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:e1',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1143565972) 132 days, 8:34:19.72',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '96592127',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2598548649',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '556',
                        IFNAME           => 'ge-0/0/33.0',
                        IFDESCR          => 'ge-0/0/33.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:e1',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1143565972) 132 days, 8:34:19.72',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2466593',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '356779',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '557',
                        IFNAME           => 'ge-0/0/34',
                        IFDESCR          => 'ge-0/0/34',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:e2',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1384542134) 160 days, 5:57:01.34',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '16553538',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '550813130',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '558',
                        IFNAME           => 'ge-0/0/35',
                        IFDESCR          => 'ge-0/0/35',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:e3',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1118850195) 129 days, 11:55:01.95',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '33379366',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1447930462',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '559',
                        IFNAME           => 'ge-0/0/36',
                        IFDESCR          => 'ge-0/0/36',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:e4',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1410733362) 163 days, 6:42:13.62',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '23981022',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '713660693',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '560',
                        IFNAME           => 'ge-0/0/37',
                        IFDESCR          => 'ge-0/0/37',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:e5',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1211950856) 140 days, 6:31:48.56',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '152170123',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3016135548',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '561',
                        IFNAME           => 'ge-0/0/38',
                        IFDESCR          => 'ge-0/0/38',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:e6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1455360768) 168 days, 10:40:07.68',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '76749283',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3017918010',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '562',
                        IFNAME           => 'ge-0/0/39',
                        IFDESCR          => 'ge-0/0/39',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:e7',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1505307478) 174 days, 5:24:34.78',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '203771803',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2659142896',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '563',
                        IFNAME           => 'ge-0/0/4',
                        IFDESCR          => 'ge-0/0/4',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:c4',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1099914508) 127 days, 7:19:05.08',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '38057500',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1007329801',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '564',
                        IFNAME           => 'ge-0/0/4.0',
                        IFDESCR          => 'ge-0/0/4.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:c4',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1099914508) 127 days, 7:19:05.08',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3524662',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '145026',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '565',
                        IFNAME           => 'ge-0/0/40',
                        IFDESCR          => 'ge-0/0/40',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:e8',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5428) 0:00:54.28',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '566',
                        IFNAME           => 'ge-0/0/41',
                        IFDESCR          => 'ge-0/0/41',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:e9',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5434) 0:00:54.34',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '567',
                        IFNAME           => 'ge-0/0/42',
                        IFDESCR          => 'ge-0/0/42',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:ea',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5441) 0:00:54.41',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '568',
                        IFNAME           => 'ge-0/0/43',
                        IFDESCR          => 'ge-0/0/43',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:eb',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5448) 0:00:54.48',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '569',
                        IFNAME           => 'ge-0/0/44',
                        IFDESCR          => 'ge-0/0/44',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:ec',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5458) 0:00:54.58',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '570',
                        IFNAME           => 'ge-0/0/45',
                        IFDESCR          => 'ge-0/0/45',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:ed',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5466) 0:00:54.66',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '571',
                        IFNAME           => 'ge-0/0/46',
                        IFDESCR          => 'ge-0/0/46',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:ee',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5473) 0:00:54.73',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '572',
                        IFNAME           => 'ge-0/0/47',
                        IFDESCR          => 'ge-0/0/47',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:ef',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(6575) 0:01:05.75',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3459942395',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '759695086',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '573',
                        IFNAME           => 'ge-0/0/5',
                        IFDESCR          => 'ge-0/0/5',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:c5',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(848117844) 98 days, 3:52:58.44',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '13515708',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '817163343',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '574',
                        IFNAME           => 'ge-0/0/5.0',
                        IFDESCR          => 'ge-0/0/5.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:c5',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(848117844) 98 days, 3:52:58.44',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '74580',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '460',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '575',
                        IFNAME           => 'ge-0/0/6',
                        IFDESCR          => 'ge-0/0/6',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:c6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1401432020) 162 days, 4:52:00.20',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '19677539',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '560323704',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '576',
                        IFNAME           => 'ge-0/0/6.0',
                        IFDESCR          => 'ge-0/0/6.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:c6',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1401432020) 162 days, 4:52:00.20',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1654420',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '85644',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '577',
                        IFNAME           => 'ge-0/0/7',
                        IFDESCR          => 'ge-0/0/7',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:c7',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1098601452) 127 days, 3:40:14.52',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '28825938',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1046046635',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '578',
                        IFNAME           => 'ge-0/0/7.0',
                        IFDESCR          => 'ge-0/0/7.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:c7',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1098601452) 127 days, 3:40:14.52',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '149457',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '75874',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '579',
                        IFNAME           => 'ge-0/0/8',
                        IFDESCR          => 'ge-0/0/8',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:c8',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1030139372) 119 days, 5:29:53.72',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '69584990',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4092848179',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '580',
                        IFNAME           => 'ge-0/0/8.0',
                        IFDESCR          => 'ge-0/0/8.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:c8',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1030139372) 119 days, 5:29:53.72',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '644434',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '656200',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '581',
                        IFNAME           => 'ge-0/0/9',
                        IFDESCR          => 'ge-0/0/9',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:c9',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1453646644) 168 days, 5:54:26.44',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1575617312',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3989857445',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '582',
                        IFNAME           => 'ge-0/0/9.0',
                        IFDESCR          => 'ge-0/0/9.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:c9',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1453646644) 168 days, 5:54:26.44',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1953950',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '601344',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '583',
                        IFNAME           => 'jsrv',
                        IFDESCR          => 'jsrv',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1518',
                        MAC              => '78:fe:3d:37:5e:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3017) 0:00:30.17',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '584',
                        IFNAME           => 'jsrv.1',
                        IFDESCR          => 'jsrv.1',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        IP               => '128.0.0.127',
                        MAC              => '78:fe:3d:37:5e:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3839) 0:00:38.39',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '42',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '585',
                        IFNAME           => 'vlan',
                        IFDESCR          => 'vlan',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1518',
                        MAC              => '78:fe:3d:37:5e:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4134) 0:00:41.34',
                        IFINOCTETS       => '1771188614',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '507220467',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '586',
                        IFNAME           => 'ge-0/0/34.0',
                        IFDESCR          => 'ge-0/0/34.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:e2',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1384542134) 160 days, 5:57:01.34',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1127322',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '154281',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '587',
                        IFNAME           => 'ge-0/0/35.0',
                        IFDESCR          => 'ge-0/0/35.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:e3',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1118850195) 129 days, 11:55:01.95',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '223310',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '225632',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '588',
                        IFNAME           => 'ge-0/0/36.0',
                        IFDESCR          => 'ge-0/0/36.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:e4',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1410733362) 163 days, 6:42:13.62',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '503203',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '48493',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '589',
                        IFNAME           => 'ge-0/0/37.0',
                        IFDESCR          => 'ge-0/0/37.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:e5',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1211950856) 140 days, 6:31:48.56',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '376559',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '165325',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '590',
                        IFNAME           => 'ge-0/0/38.0',
                        IFDESCR          => 'ge-0/0/38.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:e6',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1455360768) 168 days, 10:40:07.68',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1999894',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '393988',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '591',
                        IFNAME           => 'ge-0/0/39.0',
                        IFDESCR          => 'ge-0/0/39.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:e7',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1505307478) 174 days, 5:24:34.78',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3498450',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '810980',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '592',
                        IFNAME           => 'ge-0/0/40.0',
                        IFDESCR          => 'ge-0/0/40.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:e8',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5431) 0:00:54.31',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '593',
                        IFNAME           => 'ge-0/0/41.0',
                        IFDESCR          => 'ge-0/0/41.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:e9',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5438) 0:00:54.38',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '594',
                        IFNAME           => 'ge-0/0/42.0',
                        IFDESCR          => 'ge-0/0/42.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:ea',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5445) 0:00:54.45',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '595',
                        IFNAME           => 'ge-0/0/43.0',
                        IFDESCR          => 'ge-0/0/43.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:eb',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5453) 0:00:54.53',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '596',
                        IFNAME           => 'ge-0/0/44.0',
                        IFDESCR          => 'ge-0/0/44.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:ec',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5462) 0:00:54.62',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '597',
                        IFNAME           => 'ge-0/0/45.0',
                        IFDESCR          => 'ge-0/0/45.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:ed',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5470) 0:00:54.70',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '598',
                        IFNAME           => 'ge-0/0/46.0',
                        IFDESCR          => 'ge-0/0/46.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:ee',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5477) 0:00:54.77',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '599',
                        IFNAME           => 'ge-0/0/47.0',
                        IFDESCR          => 'ge-0/0/47.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:ef',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(6575) 0:01:05.75',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '85681745',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '593871581',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:0b:fd:15:bb:ee',
                                    '00:0b:5f:cc:d8:80',
                                    '00:19:d1:92:0c:4c',
                                    '00:09:43:09:04:18',
                                    'e8:e7:32:27:63:f4',
                                    'e8:e7:32:2a:e0:9e',
                                    'e8:e7:32:2a:e8:a4',
                                    'e8:e7:32:2b:c1:e2',
                                    'e8:e7:32:4b:7b:b4',
                                    'e8:e7:32:4b:8a:cc',
                                    '00:01:2e:2b:c1:82',
                                    '00:80:91:6c:d0:58',
                                    '00:19:d1:8b:25:86',
                                    '00:1c:c0:86:c3:a9',
                                    '00:1c:c0:a5:07:6a',
                                    '00:1c:c0:a5:07:4a',
                                    '00:1c:c0:a5:07:4b',
                                    '00:1c:c0:2c:d4:c5',
                                    '00:1c:c0:2c:d4:2e',
                                    '00:22:68:64:59:b9',
                                    '00:22:19:ba:3a:9f',
                                    '00:22:4d:47:f3:d1',
                                    '8c:89:a5:3b:2f:bb',
                                    '8c:89:a5:3b:32:79',
                                    '8c:89:a5:3b:32:7f',
                                    '8c:89:a5:3b:32:8d',
                                    '8c:89:a5:3b:32:e4',
                                    '8c:89:a5:3b:32:f2',
                                    '8c:89:a5:3b:32:4b',
                                    '8c:89:a5:3b:32:4c',
                                    'd0:27:88:54:76:6a',
                                    'f8:0f:41:35:e4:b5',
                                    '52:54:00:fe:d5:26',
                                    '00:50:ba:23:24:63',
                                    '1c:c1:de:c9:3d:6d',
                                    '00:14:6a:d6:b1:b8',
                                    '00:14:6a:d6:b1:d8',
                                    '00:14:6a:d6:b2:b8',
                                    '00:14:6a:d6:b2:ba',
                                    '00:14:6a:d6:b2:c0',
                                    '00:14:6a:d6:b2:f4',
                                    '00:14:6a:d6:b3:14',
                                    '00:15:f2:d5:b3:f6',
                                    '00:17:c4:ae:c8:b8',
                                    '00:18:de:e1:43:bf',
                                    '00:1b:77:df:5d:e1',
                                    '00:1b:a9:a2:a8:8e',
                                    '00:1b:b1:4c:10:34',
                                    '00:1b:63:cb:45:98',
                                    '00:1c:b3:bc:b5:f0',
                                    '00:1e:64:0a:41:ae',
                                    '00:1e:64:8e:40:0e',
                                    '00:1e:64:35:1c:38',
                                    '00:1e:64:3c:e3:80',
                                    '00:1e:64:53:d8:c4',
                                    '00:1e:65:2c:6c:aa',
                                    '00:1e:c2:ae:f4:c5',
                                    '00:1e:4c:13:ce:44',
                                    '00:1e:52:6f:aa:33',
                                    '00:1e:52:c8:8f:81',
                                    '00:1f:3c:a5:cc:ef',
                                    '00:1f:3c:e1:9a:87',
                                    '00:1f:5b:b4:0c:1f',
                                    '00:1f:5b:d7:41:1f',
                                    '00:21:00:30:65:1c',
                                    '00:21:6a:0f:10:68',
                                    '00:21:6a:b6:86:96',
                                    '00:21:6b:c7:95:50',
                                    '00:21:6b:31:e5:88',
                                    '00:21:e9:db:c8:5c',
                                    '00:21:5d:08:76:58',
                                    '00:22:fa:31:cd:40',
                                    '00:22:41:f6:e1:0f',
                                    '00:22:43:70:ac:5f',
                                    '00:22:43:25:f8:02',
                                    '00:22:4d:47:f6:65',
                                    '00:22:5f:b4:e2:c8',
                                    '00:23:6c:7a:2d:67',
                                    '00:23:6c:82:7a:e6',
                                    '00:23:6c:89:6f:5e',
                                    '00:23:6c:8a:00:b0',
                                    '00:23:6c:8b:88:6c',
                                    '00:23:6c:94:c6:40',
                                    '00:23:6c:99:48:86',
                                    '00:23:6c:09:bb:50',
                                    '00:23:12:0d:33:dc',
                                    '00:23:12:c3:d9:f5',
                                    '00:23:12:54:7f:d7',
                                    '00:23:12:57:99:6e',
                                    '00:23:14:1b:a7:d0',
                                    '00:23:14:3e:a1:2c',
                                    '00:23:14:56:47:d8',
                                    '00:23:4d:4f:93:97',
                                    '00:24:d2:bf:78:ed',
                                    '00:24:d6:0a:d1:94',
                                    '00:24:d6:98:03:5a',
                                    '00:24:d6:06:e2:64',
                                    '00:25:00:3d:c4:72',
                                    '00:25:00:3f:7c:c5',
                                    '00:25:00:3f:1d:f0',
                                    '00:25:00:4f:12:88',
                                    '00:25:d3:79:55:24',
                                    '00:25:d3:d4:3e:20',
                                    '00:25:d3:d4:52:d1',
                                    '00:25:d3:3f:65:6b',
                                    '00:25:d3:45:a7:ec',
                                    '00:25:4b:71:76:ec',
                                    '00:25:4b:85:a6:4f',
                                    '00:25:4b:8f:61:cb',
                                    '00:26:82:73:62:85',
                                    '00:26:82:86:b0:c7',
                                    '00:26:82:a0:97:b6',
                                    '00:26:82:f7:38:b8',
                                    '00:26:b0:be:84:a0',
                                    '00:26:b6:c3:a6:c5',
                                    '00:26:b6:53:ad:c3',
                                    '00:26:bb:0e:ad:6e',
                                    '00:26:bb:15:dd:9f',
                                    '00:26:bb:18:80:63',
                                    '00:26:bb:18:b3:2b',
                                    '00:26:bb:1b:ad:65',
                                    '00:26:bb:03:a5:36',
                                    '00:26:c7:a7:38:9a',
                                    '00:26:c7:c1:70:1e',
                                    '00:26:4d:43:92:01',
                                    '00:26:08:e6:73:9a',
                                    '00:26:08:e7:21:bf',
                                    '00:26:08:ec:e3:96',
                                    '00:26:08:f5:87:fb',
                                    '00:27:10:f2:a3:18',
                                    '00:27:10:42:50:14',
                                    '00:08:ca:e6:b3:26',
                                    '00:08:ca:e7:7e:29',
                                    '00:08:ca:e7:2f:6b',
                                    '00:08:ca:21:42:9d',
                                    '00:08:ca:46:9b:a1',
                                    '00:50:56:b7:2c:4e',
                                    '68:a3:c4:85:93:fc',
                                    '68:a3:c4:85:97:53',
                                    '68:a3:c4:db:f2:5e',
                                    '68:a3:c4:dd:e6:21',
                                    '68:a3:c4:dd:e9:2d',
                                    '68:a3:c4:e2:5e:03',
                                    '68:a3:c4:25:2f:4d',
                                    '68:a3:c4:37:e4:6a',
                                    '68:a3:c4:4c:b1:89',
                                    '68:a8:6d:10:ea:2e',
                                    '68:a8:6d:25:c9:0c',
                                    '68:a8:6d:04:a4:5e',
                                    '68:a8:6d:2a:55:cc',
                                    '68:a8:6d:37:37:f2',
                                    '68:a8:6d:42:5e:84',
                                    '68:a8:6d:45:c1:1e',
                                    '68:a8:6d:45:1f:2a',
                                    '68:a8:6d:4a:f8:a0',
                                    '68:a8:6d:4a:63:3c',
                                    '68:a8:6d:56:12:22',
                                    '68:ed:43:df:f7:9d',
                                    '68:09:27:f1:c9:b9',
                                    '70:f1:a1:89:2a:2b',
                                    '70:f1:a1:da:a6:9e',
                                    '70:f1:a1:ed:42:b7',
                                    '70:f3:95:36:76:93',
                                    '70:1a:04:34:27:90',
                                    '70:1a:04:36:f0:b2',
                                    '70:56:81:88:75:19',
                                    '70:56:81:89:b9:17',
                                    '70:56:81:8d:ca:91',
                                    '70:56:81:8f:79:69',
                                    '70:56:81:92:9e:31',
                                    '70:56:81:9c:e7:d9',
                                    '70:56:81:9c:ef:ef',
                                    '70:56:81:aa:68:11',
                                    '70:56:81:aa:bf:85',
                                    '70:56:81:ac:22:8b',
                                    '70:56:81:ac:33:81',
                                    '70:56:81:b6:2e:8d',
                                    '70:56:81:b8:55:93',
                                    '74:de:2b:9d:1c:45',
                                    '74:de:2b:c4:ea:49',
                                    '74:de:2b:f3:5c:74',
                                    '74:de:2b:25:dd:18',
                                    '74:e5:43:a4:1a:43',
                                    '74:e5:43:bb:6b:70',
                                    '74:f0:6d:30:05:d2',
                                    '74:f0:6d:07:97:5e',
                                    '74:f0:6d:50:ce:ce',
                                    '74:f0:6d:53:3f:c2',
                                    '74:f0:6d:09:69:1b',
                                    '74:2f:68:cd:75:49',
                                    '74:2f:68:29:fd:9c',
                                    '74:2f:68:30:de:80',
                                    '74:2f:68:31:5a:c5',
                                    '74:2f:68:32:a3:59',
                                    '74:2f:68:33:dd:f7',
                                    '74:2f:68:33:eb:50',
                                    '0c:74:c2:4f:7c:34',
                                    '0c:74:c2:61:bd:fe',
                                    '0c:d2:92:03:0d:7c',
                                    '0c:60:76:44:92:09',
                                    '0c:60:76:59:62:d0',
                                    '78:92:9c:29:8f:62',
                                    '78:92:9c:06:fd:a2',
                                    '78:ca:39:ae:65:df',
                                    '78:ca:39:ae:9e:d0',
                                    '78:ca:39:b0:1f:f1',
                                    '78:ca:39:b1:19:54',
                                    '78:ca:39:b1:34:d9',
                                    '78:ca:39:b3:f3:79',
                                    '78:ca:39:b4:59:1a',
                                    '78:ca:39:b8:3d:cb',
                                    '78:ca:39:b8:5c:e1',
                                    '78:ca:39:ba:57:d3',
                                    '78:ca:39:bb:24:e3',
                                    '78:ca:39:bc:d1:44',
                                    '78:ca:39:bd:55:20',
                                    '78:ca:39:19:6f:a4',
                                    '78:ca:39:34:b2:b6',
                                    '78:ca:39:35:8c:56',
                                    '78:ca:39:5b:db:36',
                                    '78:dd:08:d4:b1:d2',
                                    '78:dd:08:e1:36:9d',
                                    '78:dd:08:f6:36:47',
                                    '78:e4:00:9f:7f:56',
                                    '78:e4:00:04:a9:7f',
                                    '7c:d1:c3:70:ef:8e',
                                    '7c:d1:c3:72:e3:ea',
                                    '7c:d1:c3:75:a7:84',
                                    '7c:d1:c3:83:52:6c',
                                    '7c:d1:c3:88:a2:d6',
                                    '7c:d1:c3:88:df:76',
                                    '7c:d1:c3:89:ae:f2',
                                    '7c:d1:c3:95:46:b6',
                                    '7c:d1:c3:98:70:e2',
                                    '7c:d1:c3:9a:80:60',
                                    '7c:d1:c3:9a:84:7a',
                                    '7c:d1:c3:9c:3f:24',
                                    '7c:d1:c3:ec:1a:cb',
                                    '7c:d1:c3:ec:09:ff',
                                    '7c:d1:c3:f1:bc:35',
                                    '7c:d1:c3:f1:f4:79',
                                    '7c:d1:c3:f5:17:51',
                                    '7c:d1:c3:f6:dc:15',
                                    '7c:d1:c3:f7:d7:c3',
                                    '7c:e9:d3:6d:8c:d2',
                                    '7c:61:93:f5:37:96',
                                    '84:a6:c8:0d:d4:f5',
                                    '84:a6:c8:5d:b1:e1',
                                    '84:4b:f5:b6:73:09',
                                    '84:4b:f5:c2:6e:59',
                                    '84:4b:f5:ca:b4:7d',
                                    '84:4b:f5:cf:d0:eb',
                                    '84:4b:f5:26:b7:86',
                                    '84:4b:f5:4c:34:8b',
                                    '84:4b:f5:54:9f:03',
                                    '88:9f:fa:69:d8:51',
                                    '88:9f:fa:03:fa:4c',
                                    '88:53:2e:b2:e0:6c',
                                    '8c:7b:9d:d5:c5:82',
                                    '8c:7b:9d:d5:e8:55',
                                    '8c:a9:82:14:56:c6',
                                    '8c:2d:aa:65:ef:51',
                                    '90:00:4e:61:24:43',
                                    '90:84:0d:78:95:d2',
                                    '90:a4:de:c1:fe:0e',
                                    '90:a4:de:28:75:16',
                                    '90:fb:a6:9e:ac:91',
                                    '90:27:e4:eb:6f:dc',
                                    '90:27:e4:ed:4a:3a',
                                    '90:27:e4:f2:2d:90',
                                    '90:27:e4:f3:97:2f',
                                    '90:27:e4:f5:4d:6b',
                                    '90:27:e4:f7:31:30',
                                    '90:27:e4:fd:40:fc',
                                    '94:db:c9:44:d6:ff',
                                    '94:39:e5:b0:54:4f',
                                    '98:0c:82:cc:01:2c',
                                    '98:fe:94:3f:c8:94',
                                    '98:fe:94:41:65:d4',
                                    '98:fe:94:47:36:3e',
                                    '98:fe:94:4a:bf:8e',
                                    '9c:b7:0d:7b:2f:a3',
                                    '9c:b7:0d:d2:c1:a9',
                                    '9c:4e:36:53:76:74',
                                    '9c:4e:36:58:d0:94',
                                    '10:93:e9:00:c7:94',
                                    '10:93:e9:04:e0:c6',
                                    '10:93:e9:5d:4a:43',
                                    '10:93:e9:5e:37:5e',
                                    '10:9a:dd:a7:e0:92',
                                    '10:9a:dd:b2:fb:61',
                                    '10:9a:dd:c2:42:39',
                                    '10:9a:dd:c5:9e:76',
                                    '10:40:f3:7b:bc:78',
                                    '10:40:f3:80:06:34',
                                    '10:40:f3:86:39:6e',
                                    '10:40:f3:8d:83:0c',
                                    '10:40:f3:8d:85:32',
                                    '10:40:f3:8f:25:38',
                                    '10:40:f3:93:99:7c',
                                    '10:40:f3:99:50:8e',
                                    '10:40:f3:9c:35:ac',
                                    '10:40:f3:a5:45:30',
                                    '10:40:f3:a7:42:56',
                                    '10:40:f3:ef:ba:be',
                                    'a4:d1:d2:82:1a:a7',
                                    'a4:d1:d2:ac:32:1b',
                                    'a8:16:b2:67:31:2a',
                                    'a8:26:d9:e9:d6:63',
                                    'ac:81:12:8c:a2:10',
                                    'ac:81:12:47:d1:a5',
                                    'b0:65:bd:01:f6:c9',
                                    'b0:65:bd:60:60:17',
                                    '12:41:9b:00:62:fa',
                                    'b4:74:9f:7c:55:ec',
                                    'b8:8d:12:0c:3f:3a',
                                    'b8:8d:12:0d:49:64',
                                    'b8:8d:12:10:4b:3a',
                                    'b8:8d:12:12:f6:e8',
                                    'b8:8d:12:16:e3:7c',
                                    'b8:8d:12:1a:e9:6a',
                                    'b8:8d:12:1b:dc:1a',
                                    'b8:8d:12:1c:58:a6',
                                    'b8:8d:12:1e:21:1e',
                                    'b8:8d:12:20:04:78',
                                    'b8:8d:12:22:fc:e2',
                                    'b8:8d:12:22:37:3a',
                                    'b8:8d:12:22:5c:76',
                                    'b8:8d:12:24:35:c2',
                                    'b8:8d:12:05:12:56',
                                    'b8:8d:12:34:99:32',
                                    'b8:8d:12:34:b1:84',
                                    'b8:8d:12:38:fa:6a',
                                    'b8:8d:12:39:d7:e4',
                                    'b8:8d:12:39:f9:e4',
                                    'b8:8d:12:06:d5:74',
                                    'b8:8d:12:40:21:ae',
                                    'b8:8d:12:07:fc:32',
                                    'bc:67:78:9a:d9:82',
                                    'bc:67:78:17:6c:ec',
                                    'c0:9f:42:52:9a:5e',
                                    'c0:cb:38:01:35:18',
                                    'c0:f8:da:a7:e9:fe',
                                    'c4:85:08:69:9c:18',
                                    'c4:85:08:6a:0b:c6',
                                    'c4:85:08:22:d6:93',
                                    'c4:85:08:22:ff:74',
                                    'c4:85:08:34:39:74',
                                    'c4:85:08:37:c7:38',
                                    'c4:85:08:41:97:e5',
                                    'c4:85:08:56:d8:d5',
                                    'c4:85:08:57:0c:c4',
                                    'c4:17:fe:b5:48:8a',
                                    'c4:17:fe:55:91:75',
                                    'c4:17:fe:5c:24:68',
                                    'c4:2c:03:00:e7:8c',
                                    'c4:46:19:5f:74:ef',
                                    '14:74:11:ec:5e:a2',
                                    '14:8f:c6:5b:80:fe',
                                    '14:10:9f:f1:0e:a2',
                                    '14:10:9f:f1:99:a6',
                                    '14:10:9f:f1:9b:5a',
                                    'c8:bc:c8:bc:e7:28',
                                    'c8:bc:c8:cc:9a:b6',
                                    'c8:bc:c8:ce:3e:88',
                                    'c8:bc:c8:d5:ff:25',
                                    'c8:bc:c8:d9:92:35',
                                    'c8:bc:c8:dd:b7:01',
                                    'c8:bc:c8:dd:e5:56',
                                    'c8:bc:c8:ea:0c:60',
                                    'c8:f7:33:20:a6:89',
                                    'cc:af:78:73:a6:a0',
                                    'cc:af:78:15:18:89',
                                    'cc:af:78:2a:02:7c',
                                    'cc:af:78:08:7b:7c',
                                    'd0:df:9a:81:09:37',
                                    'd0:df:9a:e3:3d:ee',
                                    'd0:df:9a:21:f2:97',
                                    'd0:df:9a:04:4e:4a',
                                    'd4:9a:20:65:3a:98',
                                    'd4:9a:20:66:51:4d',
                                    'd4:9a:20:68:04:29',
                                    'd4:9a:20:6e:1c:23',
                                    'd4:9a:20:71:d6:db',
                                    'd4:9a:20:71:2d:a5',
                                    'd4:9a:20:72:81:66',
                                    'd4:9a:20:72:b8:1e',
                                    'd4:9a:20:72:ba:28',
                                    'd4:9a:20:72:d6:83',
                                    'd4:9a:20:72:e4:7e',
                                    'd8:a2:5e:8c:88:79',
                                    'd8:a2:5e:8e:ff:28',
                                    'd8:a2:5e:8e:48:c4',
                                    'd8:a2:5e:91:93:0e',
                                    'd8:a2:5e:91:9e:e5',
                                    'd8:a2:5e:91:a1:34',
                                    'd8:a2:5e:91:36:12',
                                    'd8:a2:5e:97:f7:91',
                                    'd8:30:62:81:6e:9f',
                                    'dc:85:de:69:44:24',
                                    'dc:85:de:13:b1:7a',
                                    'dc:85:de:15:d1:21',
                                    'e0:b9:a5:80:12:73',
                                    'e0:b9:a5:83:1b:d5',
                                    'e0:b9:a5:9d:00:f8',
                                    'e0:b9:a5:ae:01:43',
                                    'e0:b9:a5:c5:e8:12',
                                    'e0:b9:ba:87:f0:31',
                                    'e0:b9:ba:2b:eb:f0',
                                    'e0:ca:94:77:e2:76',
                                    'e0:ca:94:1d:15:ae',
                                    'e0:ca:94:24:ec:6f',
                                    'e0:f8:47:12:76:ea',
                                    'e0:f8:47:13:02:b4',
                                    'e0:f8:47:1b:f9:00',
                                    'e0:f8:47:03:e0:e8',
                                    'e0:f8:47:2b:8b:44',
                                    'e0:f8:47:35:7b:f6',
                                    'e0:f8:47:39:8f:2c',
                                    'e0:f8:47:39:c4:9c',
                                    'e0:f8:47:39:e3:0e',
                                    'e0:f8:47:43:cc:74',
                                    'e0:f8:47:09:95:0a',
                                    'e0:06:e6:6a:6c:0e',
                                    'e0:06:e6:93:5b:21',
                                    'e0:06:e6:96:d4:a1',
                                    'e0:06:e6:11:70:b7',
                                    'e0:06:e6:41:d7:d7',
                                    'e0:06:e6:43:24:17',
                                    'e4:ce:8f:0f:1c:64',
                                    'e4:ce:8f:0f:04:58',
                                    'e4:ce:8f:2d:07:f4',
                                    'e4:ce:8f:35:bb:f2',
                                    'e4:ce:8f:36:00:ee',
                                    'e4:ce:8f:4a:bd:8e',
                                    'e4:ce:8f:4b:21:16',
                                    'e4:ce:8f:50:71:0c',
                                    'e8:03:9a:8b:6d:12',
                                    'e8:39:df:6c:b3:07',
                                    'e8:39:df:84:76:cc',
                                    'e8:39:df:3f:05:c5',
                                    '18:a9:05:e3:0c:f5',
                                    '18:34:51:17:ff:78',
                                    'f0:7b:cb:01:a5:2c',
                                    'f0:7b:cb:18:ce:2a',
                                    'f0:b4:79:13:51:14',
                                    'f0:b4:79:14:aa:e7',
                                    'f0:b4:79:14:af:78',
                                    'f0:b4:79:14:b2:c6',
                                    'f0:b4:79:14:d5:04',
                                    'f0:b4:79:18:e4:4f',
                                    'f0:b4:79:19:71:e2',
                                    'f0:b4:79:1b:e4:5b',
                                    'f0:b4:79:1c:00:c4',
                                    'f0:b4:79:1c:12:90',
                                    'f0:b4:79:1c:4f:99',
                                    'f0:b4:79:1f:5b:76',
                                    'f0:b4:79:23:a1:ee',
                                    'f0:cb:a1:ca:da:f7',
                                    'f0:dc:e2:6b:35:48',
                                    'f0:e7:7e:51:28:f4',
                                    'f8:1e:df:d9:9f:79',
                                    'f8:1e:df:e9:69:37',
                                    'f8:1e:df:eb:11:47',
                                    'f8:1e:df:ed:3e:da',
                                    'f8:1e:df:f2:63:c8',
                                    'f8:1e:df:26:b4:55',
                                    '1c:4b:d6:80:6c:00',
                                    '1c:4b:d6:b9:19:c3',
                                    '1c:4b:d6:f2:d2:b8',
                                    '1c:4b:d6:1f:d4:05',
                                    '20:68:9d:bb:fd:17',
                                    '20:7c:8f:6b:79:0f',
                                    '20:02:af:55:ba:56',
                                    '20:c9:d0:7c:fc:3d',
                                    '20:c9:d0:80:c8:f5',
                                    '20:c9:d0:c3:10:f9',
                                    '20:c9:d0:c9:25:37',
                                    '20:c9:d0:d0:42:e9',
                                    '20:c9:d0:d1:45:05',
                                    '20:c9:d0:d1:56:0d',
                                    '20:c9:d0:d4:c8:ad',
                                    '20:c9:d0:d6:75:03',
                                    '20:c9:d0:da:82:61',
                                    '20:c9:d0:da:b2:81',
                                    '20:c9:d0:dd:c0:bd',
                                    '20:c9:d0:dd:d1:fb',
                                    '20:c9:d0:e0:83:db',
                                    '20:c9:d0:e4:2f:85',
                                    '20:c9:d0:44:8c:cb',
                                    '24:77:03:e2:30:74',
                                    '24:ab:81:06:f4:d4',
                                    '24:ec:99:23:1c:c6',
                                    '04:0c:ce:d0:a6:d2',
                                    '04:0c:ce:d3:ed:18',
                                    '04:0c:ce:d5:9f:a8',
                                    '04:0c:ce:d5:19:da',
                                    '04:0c:ce:d5:1c:4e',
                                    '04:0c:ce:dc:82:50',
                                    '04:0c:ce:dc:c3:40',
                                    '04:0c:ce:de:70:90',
                                    '04:0c:ce:e4:62:42',
                                    '04:0c:ce:20:b9:aa',
                                    '04:f7:e4:39:b1:57',
                                    '04:fe:31:99:65:bf',
                                    '04:1e:64:73:d2:b3',
                                    '04:1e:64:f8:5a:bd',
                                    '04:46:65:60:b2:7f',
                                    '04:54:53:06:bc:95',
                                    '28:94:0f:c1:1d:90',
                                    '28:cf:da:d6:81:fc',
                                    '28:cf:da:df:c4:50',
                                    '28:cf:da:e0:f1:1e',
                                    '28:cf:da:e7:68:26',
                                    '28:cf:da:e7:16:84',
                                    '28:cf:da:ec:03:d2',
                                    '28:e7:cf:08:ab:76',
                                    '28:37:37:24:94:1a',
                                    '28:37:37:25:c1:52',
                                    '28:37:37:25:dd:1e',
                                    '2c:81:58:fd:18:17',
                                    '2c:44:01:b4:87:f2',
                                    '30:39:26:e5:84:84',
                                    '34:c0:59:5f:ca:0f',
                                    '34:15:9e:8d:d4:71',
                                    '34:15:9e:91:f8:f0',
                                    '34:15:9e:94:10:71',
                                    '34:15:9e:95:e1:1a',
                                    '38:59:f9:44:5f:b2',
                                    '3c:07:54:11:e3:0f',
                                    '40:30:04:21:bc:bb',
                                    '44:6d:57:0d:03:2a',
                                    '44:6d:57:87:be:af',
                                    '44:6d:57:03:11:09',
                                    '44:2a:60:f2:f1:10',
                                    '48:5d:60:10:5a:39',
                                    '48:5d:60:b0:8c:ac',
                                    '48:5d:60:f5:96:80',
                                    '48:5d:60:5a:24:f8',
                                    '4c:0f:6e:e1:0d:bf',
                                    '4c:0f:6e:fa:2b:fd',
                                    '4c:0f:6e:fe:e9:78',
                                    '4c:bc:a5:ad:bf:6c',
                                    '4c:eb:42:98:9a:81',
                                    '4c:ed:de:65:5e:8e',
                                    '4c:ed:de:1c:60:a6',
                                    '08:ed:b9:9c:4e:2f',
                                    '08:ed:b9:f8:57:07',
                                    '08:ed:b9:34:c2:f4',
                                    '08:ed:b9:06:23:a2',
                                    '08:3e:8e:b2:c5:e1',
                                    '50:cc:f8:21:c2:58',
                                    '50:46:5d:29:77:c3',
                                    '54:04:a6:96:01:e1',
                                    '54:04:a6:07:54:9d',
                                    '58:94:6b:d2:d4:e4',
                                    '58:b0:35:66:11:6e',
                                    '58:b0:35:6c:f7:e4',
                                    '58:b0:35:75:f3:93',
                                    '58:b0:35:7e:cf:d3',
                                    '58:b0:35:80:a8:93',
                                    '58:b0:35:fc:6b:30',
                                    '58:b0:35:5c:95:64',
                                    '58:1f:aa:c8:62:d9',
                                    '58:55:ca:f6:86:6f',
                                    '58:55:ca:f8:15:4d',
                                    '5c:96:9d:76:2a:7f',
                                    '5c:96:9d:7a:9c:fb',
                                    '5c:96:9d:7c:71:c9',
                                    '5c:96:9d:7c:5a:15',
                                    '5c:96:9d:7d:1b:63',
                                    '5c:96:9d:8a:96:2f',
                                    '5c:96:9d:8b:05:db',
                                    '5c:59:48:a9:f0:37',
                                    '60:c5:47:0a:cb:34',
                                    '60:c5:47:8c:75:e0',
                                    '60:c5:47:8d:a6:7e',
                                    '60:c5:47:8d:b3:00',
                                    '60:c5:47:96:c3:26',
                                    '60:c5:47:07:6d:90',
                                    '60:d8:19:65:c4:df',
                                    '60:d8:19:08:a2:92',
                                    '60:33:4b:01:c7:d8',
                                    '60:33:4b:01:dd:f5',
                                    '60:33:4b:23:62:e2',
                                    '60:33:4b:26:8b:b7',
                                    '60:33:4b:26:bc:8f',
                                    '60:45:bd:24:de:76',
                                    '00:00:5e:00:01:02',
                                    '00:80:9f:ba:8d:d5',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '600',
                        IFNAME           => 'vlan.0',
                        IFDESCR          => 'vlan.0',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        IP               => '192.168.1.132',
                        MAC              => '78:fe:3d:37:5e:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(6577) 0:01:05.77',
                        IFINOCTETS       => '1771189919',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '447506369',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Juniper',
                TYPE         => 'NETWORKING',
                MODEL        => 'EX2200',
                COMMENTS     => 'Juniper Networks, Inc. ex2200-48t-4g internet router, kernel JUNOS 11.1R3.5 #0: 2011-06-25 00:35:00 UTC     builder@briath.juniper.net:/volume/build/junos/11.1/release/11.1R3.5/obj-arm/bsd/kernels/JUNIPER-EX/kernel Build date: 2011-06-25 00:31:37 UTC Cop',
                CONTACT      => 'cricesr@dauphine.fr',
                NAME         => 'AB-BU6-132-ex2200-48',
                MEMORY       => '0',
                LOCATION     => 'AB-BU6',
                SERIAL       => 'CU0211450517',
                IPS          => {
                    IP => [
                        '128.0.0.1',
                        '128.0.0.127',
                        '128.0.0.16',
                        '128.0.0.32',
                        '192.168.1.132',
                    ],
                },
                MAC          => '78:fe:3d:37:5e:c0',
                UPTIME       => '(1514669572) 175 days, 7:24:55.72',
                RAM          => '512',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '4',
                        IFNAME           => 'lsi',
                        IFDESCR          => 'lsi',
                        IFTYPE           => '150',
                        IFSPEED          => '0',
                        IFMTU            => '1496',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3055) 0:00:30.55',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '5',
                        IFNAME           => 'dsc',
                        IFDESCR          => 'dsc',
                        IFTYPE           => '1',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3012) 0:00:30.12',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '6',
                        IFNAME           => 'lo0',
                        IFDESCR          => 'lo0',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3019) 0:00:30.19',
                        IFINOCTETS       => '4148021786',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4148591022',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '7',
                        IFNAME           => 'tap',
                        IFDESCR          => 'tap',
                        IFTYPE           => '1',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3066) 0:00:30.66',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '8',
                        IFNAME           => 'gre',
                        IFDESCR          => 'gre',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3014) 0:00:30.14',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '9',
                        IFNAME           => 'ipip',
                        IFDESCR          => 'ipip',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3015) 0:00:30.15',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10',
                        IFNAME           => 'pime',
                        IFDESCR          => 'pime',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3065) 0:00:30.65',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '11',
                        IFNAME           => 'pimd',
                        IFDESCR          => 'pimd',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3063) 0:00:30.63',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '12',
                        IFNAME           => 'mtun',
                        IFDESCR          => 'mtun',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3060) 0:00:30.60',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '33',
                        IFNAME           => 'me0',
                        IFDESCR          => 'me0',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:ff',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3058) 0:00:30.58',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '37',
                        IFNAME           => 'bme0',
                        IFDESCR          => 'bme0',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1576',
                        MAC              => '00:0b:ca:fe:00:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3010) 0:00:30.10',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '901896814',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '38',
                        IFNAME           => 'bme0.32768',
                        IFDESCR          => 'bme0.32768',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1562',
                        IP               => '128.0.0.32',
                        MAC              => '00:0b:ca:fe:00:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3011) 0:00:30.11',
                        IFINOCTETS       => '2267152155',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '126',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '501',
                        IFNAME           => 'ge-0/0/0',
                        IFDESCR          => 'ge-0/0/0',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1513913595) 175 days, 5:18:55.95',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '62430575',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2121260600',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '502',
                        IFNAME           => 'ge-0/0/0.0',
                        IFDESCR          => 'ge-0/0/0.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1513913595) 175 days, 5:18:55.95',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '614461',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '323610',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:24:be:b6:4c:20',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '503',
                        IFNAME           => 'ge-0/0/1',
                        IFDESCR          => 'ge-0/0/1',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:c1',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1507307600) 174 days, 10:57:56.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '147698220',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '886946729',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '504',
                        IFNAME           => 'ge-0/0/1.0',
                        IFDESCR          => 'ge-0/0/1.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:c1',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1507307600) 174 days, 10:57:56.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1758171',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '754660',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '505',
                        IFNAME           => 'ge-0/0/10',
                        IFDESCR          => 'ge-0/0/10',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:ca',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1202418760) 139 days, 4:03:07.60',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '33040562',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '919887004',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '506',
                        IFNAME           => 'ge-0/0/10.0',
                        IFDESCR          => 'ge-0/0/10.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:ca',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1202418760) 139 days, 4:03:07.60',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '260404',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '113845',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '507',
                        IFNAME           => 'ge-0/0/11',
                        IFDESCR          => 'ge-0/0/11',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:cb',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1204402388) 139 days, 9:33:43.88',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '23866591',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '573739283',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '508',
                        IFNAME           => 'ge-0/0/11.0',
                        IFDESCR          => 'ge-0/0/11.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:cb',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1204402388) 139 days, 9:33:43.88',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '687393',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '75969',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '509',
                        IFNAME           => 'ge-0/0/12',
                        IFDESCR          => 'ge-0/0/12',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:cc',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1454505788) 168 days, 8:17:37.88',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '65490962',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3128608219',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '510',
                        IFNAME           => 'ge-0/0/12.0',
                        IFDESCR          => 'ge-0/0/12.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:cc',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1454505788) 168 days, 8:17:37.88',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1205122',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '668789',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '511',
                        IFNAME           => 'ge-0/0/13',
                        IFDESCR          => 'ge-0/0/13',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:cd',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1383988034) 160 days, 4:24:40.34',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '50434211',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2070139092',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '512',
                        IFNAME           => 'ge-0/0/13.0',
                        IFDESCR          => 'ge-0/0/13.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:cd',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1383988034) 160 days, 4:24:40.34',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '390894',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '131871',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '513',
                        IFNAME           => 'ge-0/0/14',
                        IFDESCR          => 'ge-0/0/14',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:ce',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1392608516) 161 days, 4:21:25.16',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '73541065',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2042948528',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '514',
                        IFNAME           => 'ge-0/0/14.0',
                        IFDESCR          => 'ge-0/0/14.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:ce',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1392608516) 161 days, 4:21:25.16',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '247639',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '142940',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '515',
                        IFNAME           => 'ge-0/0/15',
                        IFDESCR          => 'ge-0/0/15',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:cf',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1383987392) 160 days, 4:24:33.92',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '10291556',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '920149549',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '516',
                        IFNAME           => 'ge-0/0/15.0',
                        IFDESCR          => 'ge-0/0/15.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:cf',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1383987392) 160 days, 4:24:33.92',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '624396',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '193755',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '517',
                        IFNAME           => 'ge-0/0/16',
                        IFDESCR          => 'ge-0/0/16',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1402988034) 162 days, 9:11:20.34',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '144694897',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '373175314',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '518',
                        IFNAME           => 'ge-0/0/16.0',
                        IFDESCR          => 'ge-0/0/16.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:d0',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1402988034) 162 days, 9:11:20.34',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '4168655',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '800961',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '519',
                        IFNAME           => 'ge-0/0/17',
                        IFDESCR          => 'ge-0/0/17',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:d1',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1505111362) 174 days, 4:51:53.62',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '112282597',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3622860141',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '520',
                        IFNAME           => 'ge-0/0/17.0',
                        IFDESCR          => 'ge-0/0/17.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:d1',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1505111362) 174 days, 4:51:53.62',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3263756',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '388748',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '521',
                        IFNAME           => 'ge-0/0/18',
                        IFDESCR          => 'ge-0/0/18',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:d2',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1143701810) 132 days, 8:56:58.10',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '69571870',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2110991844',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '522',
                        IFNAME           => 'ge-0/0/18.0',
                        IFDESCR          => 'ge-0/0/18.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:d2',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1143701810) 132 days, 8:56:58.10',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2358039',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '498770',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '523',
                        IFNAME           => 'ge-0/0/19',
                        IFDESCR          => 'ge-0/0/19',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:d3',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1143887182) 132 days, 9:27:51.82',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '54665076',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1198628365',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '524',
                        IFNAME           => 'ge-0/0/19.0',
                        IFDESCR          => 'ge-0/0/19.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:d3',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1143887182) 132 days, 9:27:51.82',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '844445',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '84168',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '525',
                        IFNAME           => 'ge-0/0/2',
                        IFDESCR          => 'ge-0/0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:c2',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1514274855) 175 days, 6:19:08.55',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '71549018',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2214237751',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '526',
                        IFNAME           => 'ge-0/0/2.0',
                        IFDESCR          => 'ge-0/0/2.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:c2',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1514274855) 175 days, 6:19:08.55',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1344926',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '216986',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:26:b0:f1:25:3e',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '527',
                        IFNAME           => 'ge-0/0/20',
                        IFDESCR          => 'ge-0/0/20',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:d4',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1031918668) 119 days, 10:26:26.68',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '101162940',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3191603905',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '528',
                        IFNAME           => 'ge-0/0/20.0',
                        IFDESCR          => 'ge-0/0/20.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:d4',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1031918668) 119 days, 10:26:26.68',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '287186',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '331734',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '529',
                        IFNAME           => 'ge-0/0/21',
                        IFDESCR          => 'ge-0/0/21',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:d5',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1452971670) 168 days, 4:01:56.70',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '45333984',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1112146726',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '530',
                        IFNAME           => 'ge-0/0/21.0',
                        IFDESCR          => 'ge-0/0/21.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:d5',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1452971670) 168 days, 4:01:56.70',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2170170',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '118187',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '531',
                        IFNAME           => 'ge-0/0/22',
                        IFDESCR          => 'ge-0/0/22',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:d6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1507744280) 174 days, 12:10:42.80',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '349227121',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2349516312',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '532',
                        IFNAME           => 'ge-0/0/22.0',
                        IFDESCR          => 'ge-0/0/22.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:d6',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1507744280) 174 days, 12:10:42.80',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '7875686',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '837854',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '533',
                        IFNAME           => 'ge-0/0/23',
                        IFDESCR          => 'ge-0/0/23',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:d7',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1384857878) 160 days, 6:49:38.78',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '63700153',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3770626360',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '534',
                        IFNAME           => 'ge-0/0/23.0',
                        IFDESCR          => 'ge-0/0/23.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:d7',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1384857878) 160 days, 6:49:38.78',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1953525',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '505220',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '535',
                        IFNAME           => 'ge-0/0/24',
                        IFDESCR          => 'ge-0/0/24',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:d8',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1506337000) 174 days, 8:16:10.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '24341650',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1675279409',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '536',
                        IFNAME           => 'ge-0/0/24.0',
                        IFDESCR          => 'ge-0/0/24.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:d8',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1506337000) 174 days, 8:16:10.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '299238',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '215960',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '537',
                        IFNAME           => 'ge-0/0/25',
                        IFDESCR          => 'ge-0/0/25',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:d9',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1506965500) 174 days, 10:00:55.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '149804990',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '958374164',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '538',
                        IFNAME           => 'ge-0/0/25.0',
                        IFDESCR          => 'ge-0/0/25.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:d9',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1506965500) 174 days, 10:00:55.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3824745',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '429062',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '539',
                        IFNAME           => 'ge-0/0/26',
                        IFDESCR          => 'ge-0/0/26',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:da',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1030566650) 119 days, 6:41:06.50',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '8707382',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '314497846',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '540',
                        IFNAME           => 'ge-0/0/26.0',
                        IFDESCR          => 'ge-0/0/26.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:da',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1030566650) 119 days, 6:41:06.50',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '250977',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '6710',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '541',
                        IFNAME           => 'ge-0/0/27',
                        IFDESCR          => 'ge-0/0/27',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:db',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1507221140) 174 days, 10:43:31.40',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '59953469',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2945748283',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '542',
                        IFNAME           => 'ge-0/0/27.0',
                        IFDESCR          => 'ge-0/0/27.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:db',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1507221140) 174 days, 10:43:31.40',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '424630',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '118141',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '543',
                        IFNAME           => 'ge-0/0/28',
                        IFDESCR          => 'ge-0/0/28',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:dc',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(850490968) 98 days, 10:28:29.68',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '35974557',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '801954910',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '544',
                        IFNAME           => 'ge-0/0/28.0',
                        IFDESCR          => 'ge-0/0/28.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:dc',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(850490968) 98 days, 10:28:29.68',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1732098',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '460',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '545',
                        IFNAME           => 'ge-0/0/29',
                        IFDESCR          => 'ge-0/0/29',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:dd',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1470728810) 170 days, 5:21:28.10',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '62331862',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2935236434',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '546',
                        IFNAME           => 'ge-0/0/29.0',
                        IFDESCR          => 'ge-0/0/29.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:dd',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1470728810) 170 days, 5:21:28.10',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1758447',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '265039',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '547',
                        IFNAME           => 'ge-0/0/3',
                        IFDESCR          => 'ge-0/0/3',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:c3',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1092023384) 126 days, 9:23:53.84',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '63492350',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3428946165',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '548',
                        IFNAME           => 'ge-0/0/3.0',
                        IFDESCR          => 'ge-0/0/3.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:c3',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1092023384) 126 days, 9:23:53.84',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '671676',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '309544',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '549',
                        IFNAME           => 'ge-0/0/30',
                        IFDESCR          => 'ge-0/0/30',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:de',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1470404984) 170 days, 4:27:29.84',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '7460415',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '490225744',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '550',
                        IFNAME           => 'ge-0/0/30.0',
                        IFDESCR          => 'ge-0/0/30.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:de',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1470404984) 170 days, 4:27:29.84',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '350036',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '115652',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '551',
                        IFNAME           => 'ge-0/0/31',
                        IFDESCR          => 'ge-0/0/31',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:df',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1110357572) 128 days, 12:19:35.72',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '125852225',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1174250796',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '552',
                        IFNAME           => 'ge-0/0/31.0',
                        IFDESCR          => 'ge-0/0/31.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:df',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1110357572) 128 days, 12:19:35.72',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3504165',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '647546',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '553',
                        IFNAME           => 'ge-0/0/32',
                        IFDESCR          => 'ge-0/0/32',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:e0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1384810132) 160 days, 6:41:41.32',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '124837521',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3504587939',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '554',
                        IFNAME           => 'ge-0/0/32.0',
                        IFDESCR          => 'ge-0/0/32.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:e0',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1384810132) 160 days, 6:41:41.32',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3993337',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '566590',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '555',
                        IFNAME           => 'ge-0/0/33',
                        IFDESCR          => 'ge-0/0/33',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:e1',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1143565972) 132 days, 8:34:19.72',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '96592127',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2598548649',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '556',
                        IFNAME           => 'ge-0/0/33.0',
                        IFDESCR          => 'ge-0/0/33.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:e1',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1143565972) 132 days, 8:34:19.72',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2466593',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '356779',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '557',
                        IFNAME           => 'ge-0/0/34',
                        IFDESCR          => 'ge-0/0/34',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:e2',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1384542134) 160 days, 5:57:01.34',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '16553538',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '550813130',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '558',
                        IFNAME           => 'ge-0/0/35',
                        IFDESCR          => 'ge-0/0/35',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:e3',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1118850195) 129 days, 11:55:01.95',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '33379366',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1447930462',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '559',
                        IFNAME           => 'ge-0/0/36',
                        IFDESCR          => 'ge-0/0/36',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:e4',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1410733362) 163 days, 6:42:13.62',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '23981022',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '713660693',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '560',
                        IFNAME           => 'ge-0/0/37',
                        IFDESCR          => 'ge-0/0/37',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:e5',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1211950856) 140 days, 6:31:48.56',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '152170123',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3016135548',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '561',
                        IFNAME           => 'ge-0/0/38',
                        IFDESCR          => 'ge-0/0/38',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:e6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1455360768) 168 days, 10:40:07.68',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '76749283',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3017918010',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '562',
                        IFNAME           => 'ge-0/0/39',
                        IFDESCR          => 'ge-0/0/39',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:e7',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1505307478) 174 days, 5:24:34.78',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '203771803',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2659142896',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '563',
                        IFNAME           => 'ge-0/0/4',
                        IFDESCR          => 'ge-0/0/4',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:c4',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1099914508) 127 days, 7:19:05.08',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '38057500',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1007329801',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '564',
                        IFNAME           => 'ge-0/0/4.0',
                        IFDESCR          => 'ge-0/0/4.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:c4',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1099914508) 127 days, 7:19:05.08',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3524662',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '145026',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '565',
                        IFNAME           => 'ge-0/0/40',
                        IFDESCR          => 'ge-0/0/40',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:e8',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5428) 0:00:54.28',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '566',
                        IFNAME           => 'ge-0/0/41',
                        IFDESCR          => 'ge-0/0/41',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:e9',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5434) 0:00:54.34',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '567',
                        IFNAME           => 'ge-0/0/42',
                        IFDESCR          => 'ge-0/0/42',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:ea',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5441) 0:00:54.41',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '568',
                        IFNAME           => 'ge-0/0/43',
                        IFDESCR          => 'ge-0/0/43',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:eb',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5448) 0:00:54.48',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '569',
                        IFNAME           => 'ge-0/0/44',
                        IFDESCR          => 'ge-0/0/44',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:ec',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5458) 0:00:54.58',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '570',
                        IFNAME           => 'ge-0/0/45',
                        IFDESCR          => 'ge-0/0/45',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:ed',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5466) 0:00:54.66',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '571',
                        IFNAME           => 'ge-0/0/46',
                        IFDESCR          => 'ge-0/0/46',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:ee',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5473) 0:00:54.73',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '572',
                        IFNAME           => 'ge-0/0/47',
                        IFDESCR          => 'ge-0/0/47',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:ef',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(6575) 0:01:05.75',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3459942395',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '759695086',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '573',
                        IFNAME           => 'ge-0/0/5',
                        IFDESCR          => 'ge-0/0/5',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:c5',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(848117844) 98 days, 3:52:58.44',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '13515708',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '817163343',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '574',
                        IFNAME           => 'ge-0/0/5.0',
                        IFDESCR          => 'ge-0/0/5.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:c5',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(848117844) 98 days, 3:52:58.44',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '74580',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '460',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '575',
                        IFNAME           => 'ge-0/0/6',
                        IFDESCR          => 'ge-0/0/6',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:c6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1401432020) 162 days, 4:52:00.20',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '19677539',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '560323704',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '576',
                        IFNAME           => 'ge-0/0/6.0',
                        IFDESCR          => 'ge-0/0/6.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:c6',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1401432020) 162 days, 4:52:00.20',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1654420',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '85644',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '577',
                        IFNAME           => 'ge-0/0/7',
                        IFDESCR          => 'ge-0/0/7',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:c7',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1098601452) 127 days, 3:40:14.52',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '28825938',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1046046635',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '578',
                        IFNAME           => 'ge-0/0/7.0',
                        IFDESCR          => 'ge-0/0/7.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:c7',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1098601452) 127 days, 3:40:14.52',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '149457',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '75874',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '579',
                        IFNAME           => 'ge-0/0/8',
                        IFDESCR          => 'ge-0/0/8',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:c8',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1030139372) 119 days, 5:29:53.72',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '69584990',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4092848179',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '580',
                        IFNAME           => 'ge-0/0/8.0',
                        IFDESCR          => 'ge-0/0/8.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:c8',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1030139372) 119 days, 5:29:53.72',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '644434',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '656200',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '581',
                        IFNAME           => 'ge-0/0/9',
                        IFDESCR          => 'ge-0/0/9',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:c9',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1453646644) 168 days, 5:54:26.44',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1575617312',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3989857445',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '582',
                        IFNAME           => 'ge-0/0/9.0',
                        IFDESCR          => 'ge-0/0/9.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:c9',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1453646644) 168 days, 5:54:26.44',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1953950',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '601344',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '583',
                        IFNAME           => 'jsrv',
                        IFDESCR          => 'jsrv',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1518',
                        MAC              => '78:fe:3d:37:5e:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3017) 0:00:30.17',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '584',
                        IFNAME           => 'jsrv.1',
                        IFDESCR          => 'jsrv.1',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        IP               => '128.0.0.127',
                        MAC              => '78:fe:3d:37:5e:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3839) 0:00:38.39',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '42',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '585',
                        IFNAME           => 'vlan',
                        IFDESCR          => 'vlan',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1518',
                        MAC              => '78:fe:3d:37:5e:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4134) 0:00:41.34',
                        IFINOCTETS       => '1771188614',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '507220467',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '586',
                        IFNAME           => 'ge-0/0/34.0',
                        IFDESCR          => 'ge-0/0/34.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:e2',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1384542134) 160 days, 5:57:01.34',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1127322',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '154281',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '587',
                        IFNAME           => 'ge-0/0/35.0',
                        IFDESCR          => 'ge-0/0/35.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:e3',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1118850195) 129 days, 11:55:01.95',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '223310',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '225632',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '588',
                        IFNAME           => 'ge-0/0/36.0',
                        IFDESCR          => 'ge-0/0/36.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:e4',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1410733362) 163 days, 6:42:13.62',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '503203',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '48493',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '589',
                        IFNAME           => 'ge-0/0/37.0',
                        IFDESCR          => 'ge-0/0/37.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:e5',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1211950856) 140 days, 6:31:48.56',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '376559',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '165325',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '590',
                        IFNAME           => 'ge-0/0/38.0',
                        IFDESCR          => 'ge-0/0/38.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:e6',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1455360768) 168 days, 10:40:07.68',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1999894',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '393988',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '591',
                        IFNAME           => 'ge-0/0/39.0',
                        IFDESCR          => 'ge-0/0/39.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:e7',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1505307478) 174 days, 5:24:34.78',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3498450',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '810980',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '592',
                        IFNAME           => 'ge-0/0/40.0',
                        IFDESCR          => 'ge-0/0/40.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:e8',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5431) 0:00:54.31',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '593',
                        IFNAME           => 'ge-0/0/41.0',
                        IFDESCR          => 'ge-0/0/41.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:e9',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5438) 0:00:54.38',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '594',
                        IFNAME           => 'ge-0/0/42.0',
                        IFDESCR          => 'ge-0/0/42.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:ea',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5445) 0:00:54.45',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '595',
                        IFNAME           => 'ge-0/0/43.0',
                        IFDESCR          => 'ge-0/0/43.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:eb',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5453) 0:00:54.53',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '596',
                        IFNAME           => 'ge-0/0/44.0',
                        IFDESCR          => 'ge-0/0/44.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:ec',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5462) 0:00:54.62',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '597',
                        IFNAME           => 'ge-0/0/45.0',
                        IFDESCR          => 'ge-0/0/45.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:ed',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5470) 0:00:54.70',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '598',
                        IFNAME           => 'ge-0/0/46.0',
                        IFDESCR          => 'ge-0/0/46.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:ee',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5477) 0:00:54.77',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '599',
                        IFNAME           => 'ge-0/0/47.0',
                        IFDESCR          => 'ge-0/0/47.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:ef',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(6575) 0:01:05.75',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '85681745',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '593871581',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:0b:fd:15:bb:ee',
                                    '00:0b:5f:cc:d8:80',
                                    '00:19:d1:92:0c:4c',
                                    '00:09:43:09:04:18',
                                    'e8:e7:32:27:63:f4',
                                    'e8:e7:32:2a:e0:9e',
                                    'e8:e7:32:2a:e8:a4',
                                    'e8:e7:32:2b:c1:e2',
                                    'e8:e7:32:4b:7b:b4',
                                    'e8:e7:32:4b:8a:cc',
                                    '00:01:2e:2b:c1:82',
                                    '00:80:91:6c:d0:58',
                                    '00:19:d1:8b:25:86',
                                    '00:1c:c0:86:c3:a9',
                                    '00:1c:c0:a5:07:6a',
                                    '00:1c:c0:a5:07:4a',
                                    '00:1c:c0:a5:07:4b',
                                    '00:1c:c0:2c:d4:c5',
                                    '00:1c:c0:2c:d4:2e',
                                    '00:22:68:64:59:b9',
                                    '00:22:19:ba:3a:9f',
                                    '00:22:4d:47:f3:d1',
                                    '8c:89:a5:3b:2f:bb',
                                    '8c:89:a5:3b:32:79',
                                    '8c:89:a5:3b:32:7f',
                                    '8c:89:a5:3b:32:8d',
                                    '8c:89:a5:3b:32:e4',
                                    '8c:89:a5:3b:32:f2',
                                    '8c:89:a5:3b:32:4b',
                                    '8c:89:a5:3b:32:4c',
                                    'd0:27:88:54:76:6a',
                                    'f8:0f:41:35:e4:b5',
                                    '52:54:00:fe:d5:26',
                                    '00:50:ba:23:24:63',
                                    '1c:c1:de:c9:3d:6d',
                                    '00:14:6a:d6:b1:b8',
                                    '00:14:6a:d6:b1:d8',
                                    '00:14:6a:d6:b2:b8',
                                    '00:14:6a:d6:b2:ba',
                                    '00:14:6a:d6:b2:c0',
                                    '00:14:6a:d6:b2:f4',
                                    '00:14:6a:d6:b3:14',
                                    '00:15:f2:d5:b3:f6',
                                    '00:17:c4:ae:c8:b8',
                                    '00:18:de:e1:43:bf',
                                    '00:1b:77:df:5d:e1',
                                    '00:1b:a9:a2:a8:8e',
                                    '00:1b:b1:4c:10:34',
                                    '00:1b:63:cb:45:98',
                                    '00:1c:b3:bc:b5:f0',
                                    '00:1e:64:0a:41:ae',
                                    '00:1e:64:8e:40:0e',
                                    '00:1e:64:35:1c:38',
                                    '00:1e:64:3c:e3:80',
                                    '00:1e:64:53:d8:c4',
                                    '00:1e:65:2c:6c:aa',
                                    '00:1e:c2:ae:f4:c5',
                                    '00:1e:4c:13:ce:44',
                                    '00:1e:52:6f:aa:33',
                                    '00:1e:52:c8:8f:81',
                                    '00:1f:3c:a5:cc:ef',
                                    '00:1f:3c:e1:9a:87',
                                    '00:1f:5b:b4:0c:1f',
                                    '00:1f:5b:d7:41:1f',
                                    '00:21:00:30:65:1c',
                                    '00:21:6a:0f:10:68',
                                    '00:21:6a:b6:86:96',
                                    '00:21:6b:c7:95:50',
                                    '00:21:6b:31:e5:88',
                                    '00:21:e9:db:c8:5c',
                                    '00:21:5d:08:76:58',
                                    '00:22:fa:31:cd:40',
                                    '00:22:41:f6:e1:0f',
                                    '00:22:43:70:ac:5f',
                                    '00:22:43:25:f8:02',
                                    '00:22:4d:47:f6:65',
                                    '00:22:5f:b4:e2:c8',
                                    '00:23:6c:7a:2d:67',
                                    '00:23:6c:82:7a:e6',
                                    '00:23:6c:89:6f:5e',
                                    '00:23:6c:8a:00:b0',
                                    '00:23:6c:8b:88:6c',
                                    '00:23:6c:94:c6:40',
                                    '00:23:6c:99:48:86',
                                    '00:23:6c:09:bb:50',
                                    '00:23:12:0d:33:dc',
                                    '00:23:12:c3:d9:f5',
                                    '00:23:12:54:7f:d7',
                                    '00:23:12:57:99:6e',
                                    '00:23:14:1b:a7:d0',
                                    '00:23:14:3e:a1:2c',
                                    '00:23:14:56:47:d8',
                                    '00:23:4d:4f:93:97',
                                    '00:24:d2:bf:78:ed',
                                    '00:24:d6:0a:d1:94',
                                    '00:24:d6:98:03:5a',
                                    '00:24:d6:06:e2:64',
                                    '00:25:00:3d:c4:72',
                                    '00:25:00:3f:7c:c5',
                                    '00:25:00:3f:1d:f0',
                                    '00:25:00:4f:12:88',
                                    '00:25:d3:79:55:24',
                                    '00:25:d3:d4:3e:20',
                                    '00:25:d3:d4:52:d1',
                                    '00:25:d3:3f:65:6b',
                                    '00:25:d3:45:a7:ec',
                                    '00:25:4b:71:76:ec',
                                    '00:25:4b:85:a6:4f',
                                    '00:25:4b:8f:61:cb',
                                    '00:26:82:73:62:85',
                                    '00:26:82:86:b0:c7',
                                    '00:26:82:a0:97:b6',
                                    '00:26:82:f7:38:b8',
                                    '00:26:b0:be:84:a0',
                                    '00:26:b6:c3:a6:c5',
                                    '00:26:b6:53:ad:c3',
                                    '00:26:bb:0e:ad:6e',
                                    '00:26:bb:15:dd:9f',
                                    '00:26:bb:18:80:63',
                                    '00:26:bb:18:b3:2b',
                                    '00:26:bb:1b:ad:65',
                                    '00:26:bb:03:a5:36',
                                    '00:26:c7:a7:38:9a',
                                    '00:26:c7:c1:70:1e',
                                    '00:26:4d:43:92:01',
                                    '00:26:08:e6:73:9a',
                                    '00:26:08:e7:21:bf',
                                    '00:26:08:ec:e3:96',
                                    '00:26:08:f5:87:fb',
                                    '00:27:10:f2:a3:18',
                                    '00:27:10:42:50:14',
                                    '00:08:ca:e6:b3:26',
                                    '00:08:ca:e7:7e:29',
                                    '00:08:ca:e7:2f:6b',
                                    '00:08:ca:21:42:9d',
                                    '00:08:ca:46:9b:a1',
                                    '00:50:56:b7:2c:4e',
                                    '68:a3:c4:85:93:fc',
                                    '68:a3:c4:85:97:53',
                                    '68:a3:c4:db:f2:5e',
                                    '68:a3:c4:dd:e6:21',
                                    '68:a3:c4:dd:e9:2d',
                                    '68:a3:c4:e2:5e:03',
                                    '68:a3:c4:25:2f:4d',
                                    '68:a3:c4:37:e4:6a',
                                    '68:a3:c4:4c:b1:89',
                                    '68:a8:6d:10:ea:2e',
                                    '68:a8:6d:25:c9:0c',
                                    '68:a8:6d:04:a4:5e',
                                    '68:a8:6d:2a:55:cc',
                                    '68:a8:6d:37:37:f2',
                                    '68:a8:6d:42:5e:84',
                                    '68:a8:6d:45:c1:1e',
                                    '68:a8:6d:45:1f:2a',
                                    '68:a8:6d:4a:f8:a0',
                                    '68:a8:6d:4a:63:3c',
                                    '68:a8:6d:56:12:22',
                                    '68:ed:43:df:f7:9d',
                                    '68:09:27:f1:c9:b9',
                                    '70:f1:a1:89:2a:2b',
                                    '70:f1:a1:da:a6:9e',
                                    '70:f1:a1:ed:42:b7',
                                    '70:f3:95:36:76:93',
                                    '70:1a:04:34:27:90',
                                    '70:1a:04:36:f0:b2',
                                    '70:56:81:88:75:19',
                                    '70:56:81:89:b9:17',
                                    '70:56:81:8d:ca:91',
                                    '70:56:81:8f:79:69',
                                    '70:56:81:92:9e:31',
                                    '70:56:81:9c:e7:d9',
                                    '70:56:81:9c:ef:ef',
                                    '70:56:81:aa:68:11',
                                    '70:56:81:aa:bf:85',
                                    '70:56:81:ac:22:8b',
                                    '70:56:81:ac:33:81',
                                    '70:56:81:b6:2e:8d',
                                    '70:56:81:b8:55:93',
                                    '74:de:2b:9d:1c:45',
                                    '74:de:2b:c4:ea:49',
                                    '74:de:2b:f3:5c:74',
                                    '74:de:2b:25:dd:18',
                                    '74:e5:43:a4:1a:43',
                                    '74:e5:43:bb:6b:70',
                                    '74:f0:6d:30:05:d2',
                                    '74:f0:6d:07:97:5e',
                                    '74:f0:6d:50:ce:ce',
                                    '74:f0:6d:53:3f:c2',
                                    '74:f0:6d:09:69:1b',
                                    '74:2f:68:cd:75:49',
                                    '74:2f:68:29:fd:9c',
                                    '74:2f:68:30:de:80',
                                    '74:2f:68:31:5a:c5',
                                    '74:2f:68:32:a3:59',
                                    '74:2f:68:33:dd:f7',
                                    '74:2f:68:33:eb:50',
                                    '0c:74:c2:4f:7c:34',
                                    '0c:74:c2:61:bd:fe',
                                    '0c:d2:92:03:0d:7c',
                                    '0c:60:76:44:92:09',
                                    '0c:60:76:59:62:d0',
                                    '78:92:9c:29:8f:62',
                                    '78:92:9c:06:fd:a2',
                                    '78:ca:39:ae:65:df',
                                    '78:ca:39:ae:9e:d0',
                                    '78:ca:39:b0:1f:f1',
                                    '78:ca:39:b1:19:54',
                                    '78:ca:39:b1:34:d9',
                                    '78:ca:39:b3:f3:79',
                                    '78:ca:39:b4:59:1a',
                                    '78:ca:39:b8:3d:cb',
                                    '78:ca:39:b8:5c:e1',
                                    '78:ca:39:ba:57:d3',
                                    '78:ca:39:bb:24:e3',
                                    '78:ca:39:bc:d1:44',
                                    '78:ca:39:bd:55:20',
                                    '78:ca:39:19:6f:a4',
                                    '78:ca:39:34:b2:b6',
                                    '78:ca:39:35:8c:56',
                                    '78:ca:39:5b:db:36',
                                    '78:dd:08:d4:b1:d2',
                                    '78:dd:08:e1:36:9d',
                                    '78:dd:08:f6:36:47',
                                    '78:e4:00:9f:7f:56',
                                    '78:e4:00:04:a9:7f',
                                    '7c:d1:c3:70:ef:8e',
                                    '7c:d1:c3:72:e3:ea',
                                    '7c:d1:c3:75:a7:84',
                                    '7c:d1:c3:83:52:6c',
                                    '7c:d1:c3:88:a2:d6',
                                    '7c:d1:c3:88:df:76',
                                    '7c:d1:c3:89:ae:f2',
                                    '7c:d1:c3:95:46:b6',
                                    '7c:d1:c3:98:70:e2',
                                    '7c:d1:c3:9a:80:60',
                                    '7c:d1:c3:9a:84:7a',
                                    '7c:d1:c3:9c:3f:24',
                                    '7c:d1:c3:ec:1a:cb',
                                    '7c:d1:c3:ec:09:ff',
                                    '7c:d1:c3:f1:bc:35',
                                    '7c:d1:c3:f1:f4:79',
                                    '7c:d1:c3:f5:17:51',
                                    '7c:d1:c3:f6:dc:15',
                                    '7c:d1:c3:f7:d7:c3',
                                    '7c:e9:d3:6d:8c:d2',
                                    '7c:61:93:f5:37:96',
                                    '84:a6:c8:0d:d4:f5',
                                    '84:a6:c8:5d:b1:e1',
                                    '84:4b:f5:b6:73:09',
                                    '84:4b:f5:c2:6e:59',
                                    '84:4b:f5:ca:b4:7d',
                                    '84:4b:f5:cf:d0:eb',
                                    '84:4b:f5:26:b7:86',
                                    '84:4b:f5:4c:34:8b',
                                    '84:4b:f5:54:9f:03',
                                    '88:9f:fa:69:d8:51',
                                    '88:9f:fa:03:fa:4c',
                                    '88:53:2e:b2:e0:6c',
                                    '8c:7b:9d:d5:c5:82',
                                    '8c:7b:9d:d5:e8:55',
                                    '8c:a9:82:14:56:c6',
                                    '8c:2d:aa:65:ef:51',
                                    '90:00:4e:61:24:43',
                                    '90:84:0d:78:95:d2',
                                    '90:a4:de:c1:fe:0e',
                                    '90:a4:de:28:75:16',
                                    '90:fb:a6:9e:ac:91',
                                    '90:27:e4:eb:6f:dc',
                                    '90:27:e4:ed:4a:3a',
                                    '90:27:e4:f2:2d:90',
                                    '90:27:e4:f3:97:2f',
                                    '90:27:e4:f5:4d:6b',
                                    '90:27:e4:f7:31:30',
                                    '90:27:e4:fd:40:fc',
                                    '94:db:c9:44:d6:ff',
                                    '94:39:e5:b0:54:4f',
                                    '98:0c:82:cc:01:2c',
                                    '98:fe:94:3f:c8:94',
                                    '98:fe:94:41:65:d4',
                                    '98:fe:94:47:36:3e',
                                    '98:fe:94:4a:bf:8e',
                                    '9c:b7:0d:7b:2f:a3',
                                    '9c:b7:0d:d2:c1:a9',
                                    '9c:4e:36:53:76:74',
                                    '9c:4e:36:58:d0:94',
                                    '10:93:e9:00:c7:94',
                                    '10:93:e9:04:e0:c6',
                                    '10:93:e9:5d:4a:43',
                                    '10:93:e9:5e:37:5e',
                                    '10:9a:dd:a7:e0:92',
                                    '10:9a:dd:b2:fb:61',
                                    '10:9a:dd:c2:42:39',
                                    '10:9a:dd:c5:9e:76',
                                    '10:40:f3:7b:bc:78',
                                    '10:40:f3:80:06:34',
                                    '10:40:f3:86:39:6e',
                                    '10:40:f3:8d:83:0c',
                                    '10:40:f3:8d:85:32',
                                    '10:40:f3:8f:25:38',
                                    '10:40:f3:93:99:7c',
                                    '10:40:f3:99:50:8e',
                                    '10:40:f3:9c:35:ac',
                                    '10:40:f3:a5:45:30',
                                    '10:40:f3:a7:42:56',
                                    '10:40:f3:ef:ba:be',
                                    'a4:d1:d2:82:1a:a7',
                                    'a4:d1:d2:ac:32:1b',
                                    'a8:16:b2:67:31:2a',
                                    'a8:26:d9:e9:d6:63',
                                    'ac:81:12:8c:a2:10',
                                    'ac:81:12:47:d1:a5',
                                    'b0:65:bd:01:f6:c9',
                                    'b0:65:bd:60:60:17',
                                    '12:41:9b:00:62:fa',
                                    'b4:74:9f:7c:55:ec',
                                    'b8:8d:12:0c:3f:3a',
                                    'b8:8d:12:0d:49:64',
                                    'b8:8d:12:10:4b:3a',
                                    'b8:8d:12:12:f6:e8',
                                    'b8:8d:12:16:e3:7c',
                                    'b8:8d:12:1a:e9:6a',
                                    'b8:8d:12:1b:dc:1a',
                                    'b8:8d:12:1c:58:a6',
                                    'b8:8d:12:1e:21:1e',
                                    'b8:8d:12:20:04:78',
                                    'b8:8d:12:22:fc:e2',
                                    'b8:8d:12:22:37:3a',
                                    'b8:8d:12:22:5c:76',
                                    'b8:8d:12:24:35:c2',
                                    'b8:8d:12:05:12:56',
                                    'b8:8d:12:34:99:32',
                                    'b8:8d:12:34:b1:84',
                                    'b8:8d:12:38:fa:6a',
                                    'b8:8d:12:39:d7:e4',
                                    'b8:8d:12:39:f9:e4',
                                    'b8:8d:12:06:d5:74',
                                    'b8:8d:12:40:21:ae',
                                    'b8:8d:12:07:fc:32',
                                    'bc:67:78:9a:d9:82',
                                    'bc:67:78:17:6c:ec',
                                    'c0:9f:42:52:9a:5e',
                                    'c0:cb:38:01:35:18',
                                    'c0:f8:da:a7:e9:fe',
                                    'c4:85:08:69:9c:18',
                                    'c4:85:08:6a:0b:c6',
                                    'c4:85:08:22:d6:93',
                                    'c4:85:08:22:ff:74',
                                    'c4:85:08:34:39:74',
                                    'c4:85:08:37:c7:38',
                                    'c4:85:08:41:97:e5',
                                    'c4:85:08:56:d8:d5',
                                    'c4:85:08:57:0c:c4',
                                    'c4:17:fe:b5:48:8a',
                                    'c4:17:fe:55:91:75',
                                    'c4:17:fe:5c:24:68',
                                    'c4:2c:03:00:e7:8c',
                                    'c4:46:19:5f:74:ef',
                                    '14:74:11:ec:5e:a2',
                                    '14:8f:c6:5b:80:fe',
                                    '14:10:9f:f1:0e:a2',
                                    '14:10:9f:f1:99:a6',
                                    '14:10:9f:f1:9b:5a',
                                    'c8:bc:c8:bc:e7:28',
                                    'c8:bc:c8:cc:9a:b6',
                                    'c8:bc:c8:ce:3e:88',
                                    'c8:bc:c8:d5:ff:25',
                                    'c8:bc:c8:d9:92:35',
                                    'c8:bc:c8:dd:b7:01',
                                    'c8:bc:c8:dd:e5:56',
                                    'c8:bc:c8:ea:0c:60',
                                    'c8:f7:33:20:a6:89',
                                    'cc:af:78:73:a6:a0',
                                    'cc:af:78:15:18:89',
                                    'cc:af:78:2a:02:7c',
                                    'cc:af:78:08:7b:7c',
                                    'd0:df:9a:81:09:37',
                                    'd0:df:9a:e3:3d:ee',
                                    'd0:df:9a:21:f2:97',
                                    'd0:df:9a:04:4e:4a',
                                    'd4:9a:20:65:3a:98',
                                    'd4:9a:20:66:51:4d',
                                    'd4:9a:20:68:04:29',
                                    'd4:9a:20:6e:1c:23',
                                    'd4:9a:20:71:d6:db',
                                    'd4:9a:20:71:2d:a5',
                                    'd4:9a:20:72:81:66',
                                    'd4:9a:20:72:b8:1e',
                                    'd4:9a:20:72:ba:28',
                                    'd4:9a:20:72:d6:83',
                                    'd4:9a:20:72:e4:7e',
                                    'd8:a2:5e:8c:88:79',
                                    'd8:a2:5e:8e:ff:28',
                                    'd8:a2:5e:8e:48:c4',
                                    'd8:a2:5e:91:93:0e',
                                    'd8:a2:5e:91:9e:e5',
                                    'd8:a2:5e:91:a1:34',
                                    'd8:a2:5e:91:36:12',
                                    'd8:a2:5e:97:f7:91',
                                    'd8:30:62:81:6e:9f',
                                    'dc:85:de:69:44:24',
                                    'dc:85:de:13:b1:7a',
                                    'dc:85:de:15:d1:21',
                                    'e0:b9:a5:80:12:73',
                                    'e0:b9:a5:83:1b:d5',
                                    'e0:b9:a5:9d:00:f8',
                                    'e0:b9:a5:ae:01:43',
                                    'e0:b9:a5:c5:e8:12',
                                    'e0:b9:ba:87:f0:31',
                                    'e0:b9:ba:2b:eb:f0',
                                    'e0:ca:94:77:e2:76',
                                    'e0:ca:94:1d:15:ae',
                                    'e0:ca:94:24:ec:6f',
                                    'e0:f8:47:12:76:ea',
                                    'e0:f8:47:13:02:b4',
                                    'e0:f8:47:1b:f9:00',
                                    'e0:f8:47:03:e0:e8',
                                    'e0:f8:47:2b:8b:44',
                                    'e0:f8:47:35:7b:f6',
                                    'e0:f8:47:39:8f:2c',
                                    'e0:f8:47:39:c4:9c',
                                    'e0:f8:47:39:e3:0e',
                                    'e0:f8:47:43:cc:74',
                                    'e0:f8:47:09:95:0a',
                                    'e0:06:e6:6a:6c:0e',
                                    'e0:06:e6:93:5b:21',
                                    'e0:06:e6:96:d4:a1',
                                    'e0:06:e6:11:70:b7',
                                    'e0:06:e6:41:d7:d7',
                                    'e0:06:e6:43:24:17',
                                    'e4:ce:8f:0f:1c:64',
                                    'e4:ce:8f:0f:04:58',
                                    'e4:ce:8f:2d:07:f4',
                                    'e4:ce:8f:35:bb:f2',
                                    'e4:ce:8f:36:00:ee',
                                    'e4:ce:8f:4a:bd:8e',
                                    'e4:ce:8f:4b:21:16',
                                    'e4:ce:8f:50:71:0c',
                                    'e8:03:9a:8b:6d:12',
                                    'e8:39:df:6c:b3:07',
                                    'e8:39:df:84:76:cc',
                                    'e8:39:df:3f:05:c5',
                                    '18:a9:05:e3:0c:f5',
                                    '18:34:51:17:ff:78',
                                    'f0:7b:cb:01:a5:2c',
                                    'f0:7b:cb:18:ce:2a',
                                    'f0:b4:79:13:51:14',
                                    'f0:b4:79:14:aa:e7',
                                    'f0:b4:79:14:af:78',
                                    'f0:b4:79:14:b2:c6',
                                    'f0:b4:79:14:d5:04',
                                    'f0:b4:79:18:e4:4f',
                                    'f0:b4:79:19:71:e2',
                                    'f0:b4:79:1b:e4:5b',
                                    'f0:b4:79:1c:00:c4',
                                    'f0:b4:79:1c:12:90',
                                    'f0:b4:79:1c:4f:99',
                                    'f0:b4:79:1f:5b:76',
                                    'f0:b4:79:23:a1:ee',
                                    'f0:cb:a1:ca:da:f7',
                                    'f0:dc:e2:6b:35:48',
                                    'f0:e7:7e:51:28:f4',
                                    'f8:1e:df:d9:9f:79',
                                    'f8:1e:df:e9:69:37',
                                    'f8:1e:df:eb:11:47',
                                    'f8:1e:df:ed:3e:da',
                                    'f8:1e:df:f2:63:c8',
                                    'f8:1e:df:26:b4:55',
                                    '1c:4b:d6:80:6c:00',
                                    '1c:4b:d6:b9:19:c3',
                                    '1c:4b:d6:f2:d2:b8',
                                    '1c:4b:d6:1f:d4:05',
                                    '20:68:9d:bb:fd:17',
                                    '20:7c:8f:6b:79:0f',
                                    '20:02:af:55:ba:56',
                                    '20:c9:d0:7c:fc:3d',
                                    '20:c9:d0:80:c8:f5',
                                    '20:c9:d0:c3:10:f9',
                                    '20:c9:d0:c9:25:37',
                                    '20:c9:d0:d0:42:e9',
                                    '20:c9:d0:d1:45:05',
                                    '20:c9:d0:d1:56:0d',
                                    '20:c9:d0:d4:c8:ad',
                                    '20:c9:d0:d6:75:03',
                                    '20:c9:d0:da:82:61',
                                    '20:c9:d0:da:b2:81',
                                    '20:c9:d0:dd:c0:bd',
                                    '20:c9:d0:dd:d1:fb',
                                    '20:c9:d0:e0:83:db',
                                    '20:c9:d0:e4:2f:85',
                                    '20:c9:d0:44:8c:cb',
                                    '24:77:03:e2:30:74',
                                    '24:ab:81:06:f4:d4',
                                    '24:ec:99:23:1c:c6',
                                    '04:0c:ce:d0:a6:d2',
                                    '04:0c:ce:d3:ed:18',
                                    '04:0c:ce:d5:9f:a8',
                                    '04:0c:ce:d5:19:da',
                                    '04:0c:ce:d5:1c:4e',
                                    '04:0c:ce:dc:82:50',
                                    '04:0c:ce:dc:c3:40',
                                    '04:0c:ce:de:70:90',
                                    '04:0c:ce:e4:62:42',
                                    '04:0c:ce:20:b9:aa',
                                    '04:f7:e4:39:b1:57',
                                    '04:fe:31:99:65:bf',
                                    '04:1e:64:73:d2:b3',
                                    '04:1e:64:f8:5a:bd',
                                    '04:46:65:60:b2:7f',
                                    '04:54:53:06:bc:95',
                                    '28:94:0f:c1:1d:90',
                                    '28:cf:da:d6:81:fc',
                                    '28:cf:da:df:c4:50',
                                    '28:cf:da:e0:f1:1e',
                                    '28:cf:da:e7:68:26',
                                    '28:cf:da:e7:16:84',
                                    '28:cf:da:ec:03:d2',
                                    '28:e7:cf:08:ab:76',
                                    '28:37:37:24:94:1a',
                                    '28:37:37:25:c1:52',
                                    '28:37:37:25:dd:1e',
                                    '2c:81:58:fd:18:17',
                                    '2c:44:01:b4:87:f2',
                                    '30:39:26:e5:84:84',
                                    '34:c0:59:5f:ca:0f',
                                    '34:15:9e:8d:d4:71',
                                    '34:15:9e:91:f8:f0',
                                    '34:15:9e:94:10:71',
                                    '34:15:9e:95:e1:1a',
                                    '38:59:f9:44:5f:b2',
                                    '3c:07:54:11:e3:0f',
                                    '40:30:04:21:bc:bb',
                                    '44:6d:57:0d:03:2a',
                                    '44:6d:57:87:be:af',
                                    '44:6d:57:03:11:09',
                                    '44:2a:60:f2:f1:10',
                                    '48:5d:60:10:5a:39',
                                    '48:5d:60:b0:8c:ac',
                                    '48:5d:60:f5:96:80',
                                    '48:5d:60:5a:24:f8',
                                    '4c:0f:6e:e1:0d:bf',
                                    '4c:0f:6e:fa:2b:fd',
                                    '4c:0f:6e:fe:e9:78',
                                    '4c:bc:a5:ad:bf:6c',
                                    '4c:eb:42:98:9a:81',
                                    '4c:ed:de:65:5e:8e',
                                    '4c:ed:de:1c:60:a6',
                                    '08:ed:b9:9c:4e:2f',
                                    '08:ed:b9:f8:57:07',
                                    '08:ed:b9:34:c2:f4',
                                    '08:ed:b9:06:23:a2',
                                    '08:3e:8e:b2:c5:e1',
                                    '50:cc:f8:21:c2:58',
                                    '50:46:5d:29:77:c3',
                                    '54:04:a6:96:01:e1',
                                    '54:04:a6:07:54:9d',
                                    '58:94:6b:d2:d4:e4',
                                    '58:b0:35:66:11:6e',
                                    '58:b0:35:6c:f7:e4',
                                    '58:b0:35:75:f3:93',
                                    '58:b0:35:7e:cf:d3',
                                    '58:b0:35:80:a8:93',
                                    '58:b0:35:fc:6b:30',
                                    '58:b0:35:5c:95:64',
                                    '58:1f:aa:c8:62:d9',
                                    '58:55:ca:f6:86:6f',
                                    '58:55:ca:f8:15:4d',
                                    '5c:96:9d:76:2a:7f',
                                    '5c:96:9d:7a:9c:fb',
                                    '5c:96:9d:7c:71:c9',
                                    '5c:96:9d:7c:5a:15',
                                    '5c:96:9d:7d:1b:63',
                                    '5c:96:9d:8a:96:2f',
                                    '5c:96:9d:8b:05:db',
                                    '5c:59:48:a9:f0:37',
                                    '60:c5:47:0a:cb:34',
                                    '60:c5:47:8c:75:e0',
                                    '60:c5:47:8d:a6:7e',
                                    '60:c5:47:8d:b3:00',
                                    '60:c5:47:96:c3:26',
                                    '60:c5:47:07:6d:90',
                                    '60:d8:19:65:c4:df',
                                    '60:d8:19:08:a2:92',
                                    '60:33:4b:01:c7:d8',
                                    '60:33:4b:01:dd:f5',
                                    '60:33:4b:23:62:e2',
                                    '60:33:4b:26:8b:b7',
                                    '60:33:4b:26:bc:8f',
                                    '60:45:bd:24:de:76',
                                    '00:00:5e:00:01:02',
                                    '00:80:9f:ba:8d:d5',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '600',
                        IFNAME           => 'vlan.0',
                        IFDESCR          => 'vlan.0',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        IP               => '192.168.1.132',
                        MAC              => '78:fe:3d:37:5e:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(6577) 0:01:05.77',
                        IFINOCTETS       => '1771189919',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '447506369',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'juniper/ex2200.05.walk' => [
        {
            MANUFACTURER => 'Juniper',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Juniper Networks, Inc. ex2200-48t-4g internet router, kernel JUNOS 11.4R5.5 #0: 2012-08-25 05:21:13 UTC     builder@evenath.juniper.net:/volume/build/junos/11.4/release/11.4R5.5/obj-arm/bsd/kernels/JUNIPER-EX-2200/kernel Build date: 2012-08-25 04:48:47 U',
            SNMPHOSTNAME => 'jtc407-01',
            MAC          => '00:0b:ca:fe:00:00',
            MODEL        => 'EX2200',
        },
        {
            MANUFACTURER => 'Juniper',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Juniper Networks, Inc. ex2200-48t-4g internet router, kernel JUNOS 11.4R5.5 #0: 2012-08-25 05:21:13 UTC     builder@evenath.juniper.net:/volume/build/junos/11.4/release/11.4R5.5/obj-arm/bsd/kernels/JUNIPER-EX-2200/kernel Build date: 2012-08-25 04:48:47 U',
            SNMPHOSTNAME => 'jtc407-01',
            MAC          => '78:fe:3d:36:f7:00',
            MODELSNMP    => 'Networking2495',
            MODEL        => 'EX2200',
            FIRMWARE     => undef,
            SERIAL       => undef,
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Juniper',
                TYPE         => 'NETWORKING',
                MODEL        => 'EX2200',
                COMMENTS     => 'Juniper Networks, Inc. ex2200-48t-4g internet router, kernel JUNOS 11.4R5.5 #0: 2012-08-25 05:21:13 UTC     builder@evenath.juniper.net:/volume/build/junos/11.4/release/11.4R5.5/obj-arm/bsd/kernels/JUNIPER-EX-2200/kernel Build date: 2012-08-25 04:48:47 U',
                NAME         => 'jtc407-01',
                LOCATION     => 'PMF 4 n° 407',
                IPS          => {
                    IP => [
                        '128.0.0.1',
                        '128.0.0.16',
                        '128.0.0.32',
                        '192.168.100.65',
                    ],
                },
                UPTIME       => '(690838738) 79 days, 22:59:47.38',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '4',
                        IFNAME           => 'lsi',
                        IFDESCR          => 'lsi',
                        IFTYPE           => '150',
                        IFSPEED          => '0',
                        IFMTU            => '1496',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '5',
                        IFNAME           => 'dsc',
                        IFDESCR          => 'dsc',
                        IFTYPE           => '1',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3199) 0:00:31.99',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '6',
                        IFNAME           => 'lo0',
                        IFDESCR          => 'lo0',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3203) 0:00:32.03',
                        IFINOCTETS       => '3299710309',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3300277085',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '7',
                        IFNAME           => 'tap',
                        IFDESCR          => 'tap',
                        IFTYPE           => '1',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3204) 0:00:32.04',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '8',
                        IFNAME           => 'gre',
                        IFDESCR          => 'gre',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3201) 0:00:32.01',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '9',
                        IFNAME           => 'ipip',
                        IFDESCR          => 'ipip',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3202) 0:00:32.02',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10',
                        IFNAME           => 'pime',
                        IFDESCR          => 'pime',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3208) 0:00:32.08',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '11',
                        IFNAME           => 'pimd',
                        IFDESCR          => 'pimd',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3209) 0:00:32.09',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '12',
                        IFNAME           => 'mtun',
                        IFDESCR          => 'mtun',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3211) 0:00:32.11',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '33',
                        IFNAME           => 'me0',
                        IFDESCR          => 'me0',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:3f',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3210) 0:00:32.10',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '37',
                        IFNAME           => 'bme0',
                        IFDESCR          => 'bme0',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1576',
                        MAC              => '00:0b:ca:fe:00:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3198) 0:00:31.98',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2715463516',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '38',
                        IFNAME           => 'bme0.32768',
                        IFDESCR          => 'bme0.32768',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1562',
                        IP               => '128.0.0.32',
                        MAC              => '00:0b:ca:fe:00:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3213) 0:00:32.13',
                        IFINOCTETS       => '901244274',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '126',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '501',
                        IFNAME           => 'ge-0/0/0',
                        IFDESCR          => 'ge-0/0/0',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:03',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7247) 0:01:12.47',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3654820112',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1776131026',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '502',
                        IFNAME           => 'ge-0/0/46.0',
                        IFDESCR          => 'ge-0/0/46.0',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:03',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3891) 0:00:38.91',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '503',
                        IFNAME           => 'ge-0/0/1',
                        IFDESCR          => 'ge-0/0/1',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:04',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7247) 0:01:12.47',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '99911270',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3838463887',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '504',
                        IFNAME           => 'ge-0/0/1.0',
                        IFDESCR          => 'ge-0/0/1.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:04',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7247) 0:01:12.47',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '188602',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '465720827',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '505',
                        IFNAME           => 'ge-0/0/10',
                        IFDESCR          => 'ge-0/0/10',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:0d',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3345) 0:00:33.45',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '506',
                        IFNAME           => 'ge-0/0/10.0',
                        IFDESCR          => 'ge-0/0/10.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:0d',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3347) 0:00:33.47',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '507',
                        IFNAME           => 'ge-0/0/11',
                        IFDESCR          => 'ge-0/0/11',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:0e',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3356) 0:00:33.56',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '508',
                        IFNAME           => 'ge-0/0/11.0',
                        IFDESCR          => 'ge-0/0/11.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:0e',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3359) 0:00:33.59',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '509',
                        IFNAME           => 'ge-0/0/12',
                        IFDESCR          => 'ge-0/0/12',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:0f',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3367) 0:00:33.67',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '510',
                        IFNAME           => 'ge-0/0/12.0',
                        IFDESCR          => 'ge-0/0/12.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:0f',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3371) 0:00:33.71',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '511',
                        IFNAME           => 'ge-0/0/13',
                        IFDESCR          => 'ge-0/0/13',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:10',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(577843267) 66 days, 21:07:12.67',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3030652257',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3013626698',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '512',
                        IFNAME           => 'ge-0/0/13.0',
                        IFDESCR          => 'ge-0/0/13.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:10',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(577843267) 66 days, 21:07:12.67',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '33585640',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '465476805',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '513',
                        IFNAME           => 'ge-0/0/14',
                        IFDESCR          => 'ge-0/0/14',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:11',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(654577277) 75 days, 18:16:12.77',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3319962578',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1283149072',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '514',
                        IFNAME           => 'ge-0/0/14.0',
                        IFDESCR          => 'ge-0/0/14.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:11',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(654577277) 75 days, 18:16:12.77',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '8379249',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '465486252',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '515',
                        IFNAME           => 'ge-0/0/15',
                        IFDESCR          => 'ge-0/0/15',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:12',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3405) 0:00:34.05',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '516',
                        IFNAME           => 'ge-0/0/15.0',
                        IFDESCR          => 'ge-0/0/15.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:12',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3407) 0:00:34.07',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '517',
                        IFNAME           => 'ge-0/0/16',
                        IFDESCR          => 'ge-0/0/16',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:13',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3414) 0:00:34.14',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '518',
                        IFNAME           => 'ge-0/0/16.0',
                        IFDESCR          => 'ge-0/0/16.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:13',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3418) 0:00:34.18',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '519',
                        IFNAME           => 'ge-0/0/17',
                        IFDESCR          => 'ge-0/0/17',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:14',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3424) 0:00:34.24',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '520',
                        IFNAME           => 'ge-0/0/17.0',
                        IFDESCR          => 'ge-0/0/17.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:14',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3435) 0:00:34.35',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '521',
                        IFNAME           => 'ge-0/0/18',
                        IFDESCR          => 'ge-0/0/18',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:15',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3426) 0:00:34.26',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '522',
                        IFNAME           => 'ge-0/0/18.0',
                        IFDESCR          => 'ge-0/0/18.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:15',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3446) 0:00:34.46',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '523',
                        IFNAME           => 'ge-0/0/19',
                        IFDESCR          => 'ge-0/0/19',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:16',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3442) 0:00:34.42',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '524',
                        IFNAME           => 'ge-0/0/19.0',
                        IFDESCR          => 'ge-0/0/19.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:16',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3454) 0:00:34.54',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '525',
                        IFNAME           => 'ge-0/0/2',
                        IFDESCR          => 'ge-0/0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:05',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3248) 0:00:32.48',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '526',
                        IFNAME           => 'ge-0/0/2.0',
                        IFDESCR          => 'ge-0/0/2.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:05',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3250) 0:00:32.50',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '527',
                        IFNAME           => 'ge-0/0/20',
                        IFDESCR          => 'ge-0/0/20',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:17',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3449) 0:00:34.49',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '528',
                        IFNAME           => 'ge-0/0/20.0',
                        IFDESCR          => 'ge-0/0/20.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:17',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3460) 0:00:34.60',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '529',
                        IFNAME           => 'ge-0/0/21',
                        IFDESCR          => 'ge-0/0/21',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:18',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3456) 0:00:34.56',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '530',
                        IFNAME           => 'ge-0/0/21.0',
                        IFDESCR          => 'ge-0/0/21.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:18',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3474) 0:00:34.74',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '531',
                        IFNAME           => 'ge-0/0/22',
                        IFDESCR          => 'ge-0/0/22',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:19',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3462) 0:00:34.62',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '532',
                        IFNAME           => 'ge-0/0/22.0',
                        IFDESCR          => 'ge-0/0/22.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:19',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3501) 0:00:35.01',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '533',
                        IFNAME           => 'ge-0/0/23',
                        IFDESCR          => 'ge-0/0/23',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:1a',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3467) 0:00:34.67',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '534',
                        IFNAME           => 'ge-0/0/23.0',
                        IFDESCR          => 'ge-0/0/23.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:1a',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3519) 0:00:35.19',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '535',
                        IFNAME           => 'ge-0/0/24',
                        IFDESCR          => 'ge-0/0/24',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:1b',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3471) 0:00:34.71',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '536',
                        IFNAME           => 'ge-0/0/24.0',
                        IFDESCR          => 'ge-0/0/24.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:1b',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3532) 0:00:35.32',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '537',
                        IFNAME           => 'ge-0/0/25',
                        IFDESCR          => 'ge-0/0/25',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:1c',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7370) 0:01:13.70',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '995965943',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3951591485',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '538',
                        IFNAME           => 'ge-0/0/25.0',
                        IFDESCR          => 'ge-0/0/25.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:1c',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7370) 0:01:13.70',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '5187440',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '466471737',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '539',
                        IFNAME           => 'ge-0/0/26',
                        IFDESCR          => 'ge-0/0/26',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:1d',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3487) 0:00:34.87',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '540',
                        IFNAME           => 'ge-0/0/26.0',
                        IFDESCR          => 'ge-0/0/26.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:1d',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3589) 0:00:35.89',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '541',
                        IFNAME           => 'ge-0/0/27',
                        IFDESCR          => 'ge-0/0/27',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:1e',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3493) 0:00:34.93',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '542',
                        IFNAME           => 'ge-0/0/27.0',
                        IFDESCR          => 'ge-0/0/27.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:1e',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3605) 0:00:36.05',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '543',
                        IFNAME           => 'ge-0/0/28',
                        IFDESCR          => 'ge-0/0/28',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:1f',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3496) 0:00:34.96',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '544',
                        IFNAME           => 'ge-0/0/28.0',
                        IFDESCR          => 'ge-0/0/28.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:1f',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3630) 0:00:36.30',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '545',
                        IFNAME           => 'ge-0/0/29',
                        IFDESCR          => 'ge-0/0/29',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:20',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3505) 0:00:35.05',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '546',
                        IFNAME           => 'ge-0/0/29.0',
                        IFDESCR          => 'ge-0/0/29.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:20',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3641) 0:00:36.41',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '547',
                        IFNAME           => 'ge-0/0/3',
                        IFDESCR          => 'ge-0/0/3',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:06',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3252) 0:00:32.52',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '548',
                        IFNAME           => 'ge-0/0/3.0',
                        IFDESCR          => 'ge-0/0/3.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:06',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3253) 0:00:32.53',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '549',
                        IFNAME           => 'ge-0/0/30',
                        IFDESCR          => 'ge-0/0/30',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:21',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3508) 0:00:35.08',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '550',
                        IFNAME           => 'ge-0/0/30.0',
                        IFDESCR          => 'ge-0/0/30.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:21',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3645) 0:00:36.45',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '551',
                        IFNAME           => 'ge-0/0/31',
                        IFDESCR          => 'ge-0/0/31',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:22',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(688688737) 79 days, 17:01:27.37',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '141635944',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3460900081',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '552',
                        IFNAME           => 'ge-0/0/31.0',
                        IFDESCR          => 'ge-0/0/31.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:22',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(688688737) 79 days, 17:01:27.37',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '500773',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '421381483',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '553',
                        IFNAME           => 'ge-0/0/32',
                        IFDESCR          => 'ge-0/0/32',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:23',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(689602367) 79 days, 19:33:43.67',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '86562173',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1295216410',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '554',
                        IFNAME           => 'ge-0/0/32.0',
                        IFDESCR          => 'ge-0/0/32.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:23',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(689602367) 79 days, 19:33:43.67',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '694827',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '61338038',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '555',
                        IFNAME           => 'ge-0/0/33',
                        IFDESCR          => 'ge-0/0/33',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:24',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7371) 0:01:13.71',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '4011077581',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3301180591',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '556',
                        IFNAME           => 'ge-0/0/33.0',
                        IFDESCR          => 'ge-0/0/33.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:24',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7371) 0:01:13.71',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '7570937',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '449527190',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '557',
                        IFNAME           => 'ge-0/0/34',
                        IFDESCR          => 'ge-0/0/34',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:25',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(605122587) 70 days, 0:53:45.87',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1188771734',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3796981610',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '558',
                        IFNAME           => 'ge-0/0/34.0',
                        IFDESCR          => 'ge-0/0/34.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:25',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(605122587) 70 days, 0:53:45.87',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '5660368',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '464675284',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '559',
                        IFNAME           => 'ge-0/0/35',
                        IFDESCR          => 'ge-0/0/35',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:26',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(603753039) 69 days, 21:05:30.39',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '717085133',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1859341136',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '560',
                        IFNAME           => 'ge-0/0/35.0',
                        IFDESCR          => 'ge-0/0/35.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:26',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(603753039) 69 days, 21:05:30.39',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '6150747',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '407661671',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '561',
                        IFNAME           => 'ge-0/0/36',
                        IFDESCR          => 'ge-0/0/36',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:27',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(630152097) 72 days, 22:25:20.97',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2150647287',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3123063969',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '562',
                        IFNAME           => 'ge-0/0/36.0',
                        IFDESCR          => 'ge-0/0/36.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:27',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(630152097) 72 days, 22:25:20.97',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '210659779',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '76952215',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '563',
                        IFNAME           => 'ge-0/0/37',
                        IFDESCR          => 'ge-0/0/37',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:28',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(672589657) 77 days, 20:18:16.57',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2139115923',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '713610076',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '564',
                        IFNAME           => 'ge-0/0/37.0',
                        IFDESCR          => 'ge-0/0/37.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:28',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(672589657) 77 days, 20:18:16.57',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2007812',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '449518210',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '565',
                        IFNAME           => 'ge-0/0/38',
                        IFDESCR          => 'ge-0/0/38',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:29',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(671864217) 77 days, 18:17:22.17',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2276628107',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3562479292',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '566',
                        IFNAME           => 'ge-0/0/38.0',
                        IFDESCR          => 'ge-0/0/38.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:29',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(671864217) 77 days, 18:17:22.17',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3779632',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '449506711',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '567',
                        IFNAME           => 'ge-0/0/39',
                        IFDESCR          => 'ge-0/0/39',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:2a',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3579) 0:00:35.79',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '568',
                        IFNAME           => 'ge-0/0/39.0',
                        IFDESCR          => 'ge-0/0/39.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:2a',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3785) 0:00:37.85',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '569',
                        IFNAME           => 'ge-0/0/4',
                        IFDESCR          => 'ge-0/0/4',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:07',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3256) 0:00:32.56',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '570',
                        IFNAME           => 'ge-0/0/4.0',
                        IFDESCR          => 'ge-0/0/4.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:07',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3258) 0:00:32.58',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '571',
                        IFNAME           => 'ge-0/0/40',
                        IFDESCR          => 'ge-0/0/40',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:2b',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(623010977) 72 days, 2:35:09.77',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3533234512',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2633122441',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '572',
                        IFNAME           => 'ge-0/0/40.0',
                        IFDESCR          => 'ge-0/0/40.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:2b',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(623010977) 72 days, 2:35:09.77',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3134933',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '449446120',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '573',
                        IFNAME           => 'ge-0/0/41',
                        IFDESCR          => 'ge-0/0/41',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:2c',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(380811077) 44 days, 1:48:30.77',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3363359789',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1143757502',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '574',
                        IFNAME           => 'ge-0/0/41.0',
                        IFDESCR          => 'ge-0/0/41.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:2c',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(380811077) 44 days, 1:48:30.77',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '6930628',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '449497792',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '575',
                        IFNAME           => 'ge-0/0/42',
                        IFDESCR          => 'ge-0/0/42',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:2d',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(626710427) 72 days, 12:51:44.27',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '360348982',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1936465493',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '576',
                        IFNAME           => 'ge-0/0/42.0',
                        IFDESCR          => 'ge-0/0/42.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:2d',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(626710427) 72 days, 12:51:44.27',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '928054',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '93754257',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '577',
                        IFNAME           => 'ge-0/0/43',
                        IFDESCR          => 'ge-0/0/43',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:2e',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3616) 0:00:36.16',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '578',
                        IFNAME           => 'ge-0/0/43.0',
                        IFDESCR          => 'ge-0/0/43.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:2e',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3833) 0:00:38.33',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '579',
                        IFNAME           => 'ge-0/0/44',
                        IFDESCR          => 'ge-0/0/44',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:2f',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(654832517) 75 days, 18:58:45.17',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3158408642',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4246970219',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '580',
                        IFNAME           => 'ge-0/0/44.0',
                        IFDESCR          => 'ge-0/0/44.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:2f',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(654832517) 75 days, 18:58:45.17',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '41406521',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '449536917',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFNUMBER => '0x001A1ECDBB02',
                                IFDESCR  => 'eth0',
                                SYSNAME  => 'PMF-sap-c407',
                                SYSDESCR => 'ArubaOS (MODEL: 125), Version 6.2.1.2 (38711)',
                                SYSMAC   => '00:1a:1e:cd:bb:02',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '581',
                        IFNAME           => 'ge-0/0/45',
                        IFDESCR          => 'ge-0/0/45',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:30',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(561606847) 65 days, 0:01:08.47',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3458219972',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '244487005',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '582',
                        IFNAME           => 'ge-0/0/45.0',
                        IFDESCR          => 'ge-0/0/45.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:30',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(561606847) 65 days, 0:01:08.47',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '16584800',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '465451921',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '583',
                        IFNAME           => 'ge-0/0/46',
                        IFDESCR          => 'ge-0/0/46',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:03',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3635) 0:00:36.35',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '584',
                        IFNAME           => 'ge-0/0/47.0',
                        IFDESCR          => 'ge-0/0/47.0',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:03',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3903) 0:00:39.03',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '585',
                        IFNAME           => 'ge-0/0/47',
                        IFDESCR          => 'ge-0/0/47',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:03',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3638) 0:00:36.38',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '586',
                        IFNAME           => 'ge-0/0/0.0',
                        IFDESCR          => 'ge-0/0/0.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:03',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7247) 0:01:12.47',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3030702800',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '171078177',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '587',
                        IFNAME           => 'ge-0/0/5',
                        IFDESCR          => 'ge-0/0/5',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:08',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3259) 0:00:32.59',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '588',
                        IFNAME           => 'ge-0/0/5.0',
                        IFDESCR          => 'ge-0/0/5.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:08',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3261) 0:00:32.61',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '589',
                        IFNAME           => 'ge-0/0/6',
                        IFDESCR          => 'ge-0/0/6',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:09',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3301) 0:00:33.01',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '590',
                        IFNAME           => 'ge-0/0/6.0',
                        IFDESCR          => 'ge-0/0/6.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:09',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3304) 0:00:33.04',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '591',
                        IFNAME           => 'ge-0/0/7',
                        IFDESCR          => 'ge-0/0/7',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:0a',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3311) 0:00:33.11',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '592',
                        IFNAME           => 'ge-0/0/7.0',
                        IFDESCR          => 'ge-0/0/7.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:0a',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3314) 0:00:33.14',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '593',
                        IFNAME           => 'ge-0/0/8',
                        IFDESCR          => 'ge-0/0/8',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:0b',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3328) 0:00:33.28',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '594',
                        IFNAME           => 'ge-0/0/8.0',
                        IFDESCR          => 'ge-0/0/8.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:0b',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3333) 0:00:33.33',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '595',
                        IFNAME           => 'ge-0/0/9',
                        IFDESCR          => 'ge-0/0/9',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:0c',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3338) 0:00:33.38',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '596',
                        IFNAME           => 'ge-0/0/9.0',
                        IFDESCR          => 'ge-0/0/9.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:0c',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3340) 0:00:33.40',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '599',
                        IFNAME           => 'vlan',
                        IFDESCR          => 'vlan',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1518',
                        MAC              => '78:fe:3d:36:f7:01',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3224) 0:00:32.24',
                        IFINOCTETS       => '1782820774',
                        IFINERRORS       => '18',
                        IFOUTOCTETS      => '68750026',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '600',
                        IFNAME           => 'vlan.0',
                        IFDESCR          => 'vlan.0',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        IP               => '192.168.100.65',
                        MAC              => '78:fe:3d:36:f7:01',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7309) 0:01:13.09',
                        IFINOCTETS       => '1782820862',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '64824825',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '609',
                        IFNAME           => 'ae0',
                        IFDESCR          => 'ae0',
                        IFTYPE           => '161',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:03',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3215) 0:00:32.15',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '610',
                        IFNAME           => 'ae1',
                        IFDESCR          => 'ae1',
                        IFTYPE           => '161',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:04',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3216) 0:00:32.16',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '611',
                        IFNAME           => 'ae2',
                        IFDESCR          => 'ae2',
                        IFTYPE           => '161',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:05',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3218) 0:00:32.18',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '612',
                        IFNAME           => 'ae3',
                        IFDESCR          => 'ae3',
                        IFTYPE           => '161',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:06',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3219) 0:00:32.19',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '613',
                        IFNAME           => 'ae4',
                        IFDESCR          => 'ae4',
                        IFTYPE           => '161',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:07',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3221) 0:00:32.21',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '614',
                        IFNAME           => 'ae0.0',
                        IFDESCR          => 'ae0.0',
                        IFTYPE           => '161',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:03',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3222) 0:00:32.22',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Juniper',
                TYPE         => 'NETWORKING',
                MODEL        => 'EX2200',
                COMMENTS     => 'Juniper Networks, Inc. ex2200-48t-4g internet router, kernel JUNOS 11.4R5.5 #0: 2012-08-25 05:21:13 UTC     builder@evenath.juniper.net:/volume/build/junos/11.4/release/11.4R5.5/obj-arm/bsd/kernels/JUNIPER-EX-2200/kernel Build date: 2012-08-25 04:48:47 U',
                NAME         => 'jtc407-01',
                LOCATION     => 'PMF 4 n° 407',
                IPS          => {
                    IP => [
                        '128.0.0.1',
                        '128.0.0.16',
                        '128.0.0.32',
                        '192.168.100.65',
                    ],
                },
                MAC          => '78:fe:3d:36:f7:00',
                UPTIME       => '(690838738) 79 days, 22:59:47.38',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '4',
                        IFNAME           => 'lsi',
                        IFDESCR          => 'lsi',
                        IFTYPE           => '150',
                        IFSPEED          => '0',
                        IFMTU            => '1496',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '5',
                        IFNAME           => 'dsc',
                        IFDESCR          => 'dsc',
                        IFTYPE           => '1',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3199) 0:00:31.99',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '6',
                        IFNAME           => 'lo0',
                        IFDESCR          => 'lo0',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3203) 0:00:32.03',
                        IFINOCTETS       => '3299710309',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3300277085',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '7',
                        IFNAME           => 'tap',
                        IFDESCR          => 'tap',
                        IFTYPE           => '1',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3204) 0:00:32.04',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '8',
                        IFNAME           => 'gre',
                        IFDESCR          => 'gre',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3201) 0:00:32.01',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '9',
                        IFNAME           => 'ipip',
                        IFDESCR          => 'ipip',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3202) 0:00:32.02',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10',
                        IFNAME           => 'pime',
                        IFDESCR          => 'pime',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3208) 0:00:32.08',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '11',
                        IFNAME           => 'pimd',
                        IFDESCR          => 'pimd',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3209) 0:00:32.09',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '12',
                        IFNAME           => 'mtun',
                        IFDESCR          => 'mtun',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3211) 0:00:32.11',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '33',
                        IFNAME           => 'me0',
                        IFDESCR          => 'me0',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:3f',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3210) 0:00:32.10',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '37',
                        IFNAME           => 'bme0',
                        IFDESCR          => 'bme0',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1576',
                        MAC              => '00:0b:ca:fe:00:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3198) 0:00:31.98',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2715463516',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '38',
                        IFNAME           => 'bme0.32768',
                        IFDESCR          => 'bme0.32768',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1562',
                        IP               => '128.0.0.32',
                        MAC              => '00:0b:ca:fe:00:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3213) 0:00:32.13',
                        IFINOCTETS       => '901244274',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '126',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '501',
                        IFNAME           => 'ge-0/0/0',
                        IFDESCR          => 'ge-0/0/0',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:03',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7247) 0:01:12.47',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3654820112',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1776131026',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '502',
                        IFNAME           => 'ge-0/0/46.0',
                        IFDESCR          => 'ge-0/0/46.0',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:03',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3891) 0:00:38.91',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '503',
                        IFNAME           => 'ge-0/0/1',
                        IFDESCR          => 'ge-0/0/1',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:04',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7247) 0:01:12.47',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '99911270',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3838463887',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '504',
                        IFNAME           => 'ge-0/0/1.0',
                        IFDESCR          => 'ge-0/0/1.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:04',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7247) 0:01:12.47',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '188602',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '465720827',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '505',
                        IFNAME           => 'ge-0/0/10',
                        IFDESCR          => 'ge-0/0/10',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:0d',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3345) 0:00:33.45',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '506',
                        IFNAME           => 'ge-0/0/10.0',
                        IFDESCR          => 'ge-0/0/10.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:0d',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3347) 0:00:33.47',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '507',
                        IFNAME           => 'ge-0/0/11',
                        IFDESCR          => 'ge-0/0/11',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:0e',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3356) 0:00:33.56',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '508',
                        IFNAME           => 'ge-0/0/11.0',
                        IFDESCR          => 'ge-0/0/11.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:0e',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3359) 0:00:33.59',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '509',
                        IFNAME           => 'ge-0/0/12',
                        IFDESCR          => 'ge-0/0/12',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:0f',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3367) 0:00:33.67',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '510',
                        IFNAME           => 'ge-0/0/12.0',
                        IFDESCR          => 'ge-0/0/12.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:0f',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3371) 0:00:33.71',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '511',
                        IFNAME           => 'ge-0/0/13',
                        IFDESCR          => 'ge-0/0/13',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:10',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(577843267) 66 days, 21:07:12.67',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3030652257',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3013626698',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '512',
                        IFNAME           => 'ge-0/0/13.0',
                        IFDESCR          => 'ge-0/0/13.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:10',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(577843267) 66 days, 21:07:12.67',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '33585640',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '465476805',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '513',
                        IFNAME           => 'ge-0/0/14',
                        IFDESCR          => 'ge-0/0/14',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:11',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(654577277) 75 days, 18:16:12.77',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3319962578',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1283149072',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '514',
                        IFNAME           => 'ge-0/0/14.0',
                        IFDESCR          => 'ge-0/0/14.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:11',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(654577277) 75 days, 18:16:12.77',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '8379249',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '465486252',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '515',
                        IFNAME           => 'ge-0/0/15',
                        IFDESCR          => 'ge-0/0/15',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:12',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3405) 0:00:34.05',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '516',
                        IFNAME           => 'ge-0/0/15.0',
                        IFDESCR          => 'ge-0/0/15.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:12',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3407) 0:00:34.07',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '517',
                        IFNAME           => 'ge-0/0/16',
                        IFDESCR          => 'ge-0/0/16',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:13',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3414) 0:00:34.14',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '518',
                        IFNAME           => 'ge-0/0/16.0',
                        IFDESCR          => 'ge-0/0/16.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:13',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3418) 0:00:34.18',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '519',
                        IFNAME           => 'ge-0/0/17',
                        IFDESCR          => 'ge-0/0/17',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:14',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3424) 0:00:34.24',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '520',
                        IFNAME           => 'ge-0/0/17.0',
                        IFDESCR          => 'ge-0/0/17.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:14',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3435) 0:00:34.35',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '521',
                        IFNAME           => 'ge-0/0/18',
                        IFDESCR          => 'ge-0/0/18',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:15',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3426) 0:00:34.26',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '522',
                        IFNAME           => 'ge-0/0/18.0',
                        IFDESCR          => 'ge-0/0/18.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:15',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3446) 0:00:34.46',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '523',
                        IFNAME           => 'ge-0/0/19',
                        IFDESCR          => 'ge-0/0/19',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:16',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3442) 0:00:34.42',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '524',
                        IFNAME           => 'ge-0/0/19.0',
                        IFDESCR          => 'ge-0/0/19.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:16',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3454) 0:00:34.54',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '525',
                        IFNAME           => 'ge-0/0/2',
                        IFDESCR          => 'ge-0/0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:05',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3248) 0:00:32.48',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '526',
                        IFNAME           => 'ge-0/0/2.0',
                        IFDESCR          => 'ge-0/0/2.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:05',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3250) 0:00:32.50',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '527',
                        IFNAME           => 'ge-0/0/20',
                        IFDESCR          => 'ge-0/0/20',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:17',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3449) 0:00:34.49',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '528',
                        IFNAME           => 'ge-0/0/20.0',
                        IFDESCR          => 'ge-0/0/20.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:17',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3460) 0:00:34.60',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '529',
                        IFNAME           => 'ge-0/0/21',
                        IFDESCR          => 'ge-0/0/21',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:18',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3456) 0:00:34.56',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '530',
                        IFNAME           => 'ge-0/0/21.0',
                        IFDESCR          => 'ge-0/0/21.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:18',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3474) 0:00:34.74',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '531',
                        IFNAME           => 'ge-0/0/22',
                        IFDESCR          => 'ge-0/0/22',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:19',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3462) 0:00:34.62',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '532',
                        IFNAME           => 'ge-0/0/22.0',
                        IFDESCR          => 'ge-0/0/22.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:19',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3501) 0:00:35.01',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '533',
                        IFNAME           => 'ge-0/0/23',
                        IFDESCR          => 'ge-0/0/23',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:1a',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3467) 0:00:34.67',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '534',
                        IFNAME           => 'ge-0/0/23.0',
                        IFDESCR          => 'ge-0/0/23.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:1a',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3519) 0:00:35.19',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '535',
                        IFNAME           => 'ge-0/0/24',
                        IFDESCR          => 'ge-0/0/24',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:1b',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3471) 0:00:34.71',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '536',
                        IFNAME           => 'ge-0/0/24.0',
                        IFDESCR          => 'ge-0/0/24.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:1b',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3532) 0:00:35.32',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '537',
                        IFNAME           => 'ge-0/0/25',
                        IFDESCR          => 'ge-0/0/25',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:1c',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7370) 0:01:13.70',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '995965943',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3951591485',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '538',
                        IFNAME           => 'ge-0/0/25.0',
                        IFDESCR          => 'ge-0/0/25.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:1c',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7370) 0:01:13.70',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '5187440',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '466471737',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '539',
                        IFNAME           => 'ge-0/0/26',
                        IFDESCR          => 'ge-0/0/26',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:1d',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3487) 0:00:34.87',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '540',
                        IFNAME           => 'ge-0/0/26.0',
                        IFDESCR          => 'ge-0/0/26.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:1d',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3589) 0:00:35.89',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '541',
                        IFNAME           => 'ge-0/0/27',
                        IFDESCR          => 'ge-0/0/27',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:1e',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3493) 0:00:34.93',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '542',
                        IFNAME           => 'ge-0/0/27.0',
                        IFDESCR          => 'ge-0/0/27.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:1e',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3605) 0:00:36.05',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '543',
                        IFNAME           => 'ge-0/0/28',
                        IFDESCR          => 'ge-0/0/28',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:1f',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3496) 0:00:34.96',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '544',
                        IFNAME           => 'ge-0/0/28.0',
                        IFDESCR          => 'ge-0/0/28.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:1f',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3630) 0:00:36.30',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '545',
                        IFNAME           => 'ge-0/0/29',
                        IFDESCR          => 'ge-0/0/29',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:20',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3505) 0:00:35.05',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '546',
                        IFNAME           => 'ge-0/0/29.0',
                        IFDESCR          => 'ge-0/0/29.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:20',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3641) 0:00:36.41',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '547',
                        IFNAME           => 'ge-0/0/3',
                        IFDESCR          => 'ge-0/0/3',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:06',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3252) 0:00:32.52',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '548',
                        IFNAME           => 'ge-0/0/3.0',
                        IFDESCR          => 'ge-0/0/3.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:06',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3253) 0:00:32.53',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '549',
                        IFNAME           => 'ge-0/0/30',
                        IFDESCR          => 'ge-0/0/30',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:21',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3508) 0:00:35.08',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '550',
                        IFNAME           => 'ge-0/0/30.0',
                        IFDESCR          => 'ge-0/0/30.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:21',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3645) 0:00:36.45',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '551',
                        IFNAME           => 'ge-0/0/31',
                        IFDESCR          => 'ge-0/0/31',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:22',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(688688737) 79 days, 17:01:27.37',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '141635944',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3460900081',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '552',
                        IFNAME           => 'ge-0/0/31.0',
                        IFDESCR          => 'ge-0/0/31.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:22',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(688688737) 79 days, 17:01:27.37',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '500773',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '421381483',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '553',
                        IFNAME           => 'ge-0/0/32',
                        IFDESCR          => 'ge-0/0/32',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:23',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(689602367) 79 days, 19:33:43.67',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '86562173',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1295216410',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '554',
                        IFNAME           => 'ge-0/0/32.0',
                        IFDESCR          => 'ge-0/0/32.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:23',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(689602367) 79 days, 19:33:43.67',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '694827',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '61338038',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '555',
                        IFNAME           => 'ge-0/0/33',
                        IFDESCR          => 'ge-0/0/33',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:24',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7371) 0:01:13.71',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '4011077581',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3301180591',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '556',
                        IFNAME           => 'ge-0/0/33.0',
                        IFDESCR          => 'ge-0/0/33.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:24',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7371) 0:01:13.71',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '7570937',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '449527190',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '557',
                        IFNAME           => 'ge-0/0/34',
                        IFDESCR          => 'ge-0/0/34',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:25',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(605122587) 70 days, 0:53:45.87',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1188771734',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3796981610',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '558',
                        IFNAME           => 'ge-0/0/34.0',
                        IFDESCR          => 'ge-0/0/34.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:25',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(605122587) 70 days, 0:53:45.87',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '5660368',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '464675284',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '559',
                        IFNAME           => 'ge-0/0/35',
                        IFDESCR          => 'ge-0/0/35',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:26',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(603753039) 69 days, 21:05:30.39',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '717085133',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1859341136',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '560',
                        IFNAME           => 'ge-0/0/35.0',
                        IFDESCR          => 'ge-0/0/35.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:26',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(603753039) 69 days, 21:05:30.39',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '6150747',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '407661671',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '561',
                        IFNAME           => 'ge-0/0/36',
                        IFDESCR          => 'ge-0/0/36',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:27',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(630152097) 72 days, 22:25:20.97',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2150647287',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3123063969',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '562',
                        IFNAME           => 'ge-0/0/36.0',
                        IFDESCR          => 'ge-0/0/36.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:27',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(630152097) 72 days, 22:25:20.97',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '210659779',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '76952215',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '563',
                        IFNAME           => 'ge-0/0/37',
                        IFDESCR          => 'ge-0/0/37',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:28',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(672589657) 77 days, 20:18:16.57',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2139115923',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '713610076',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '564',
                        IFNAME           => 'ge-0/0/37.0',
                        IFDESCR          => 'ge-0/0/37.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:28',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(672589657) 77 days, 20:18:16.57',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2007812',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '449518210',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '565',
                        IFNAME           => 'ge-0/0/38',
                        IFDESCR          => 'ge-0/0/38',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:29',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(671864217) 77 days, 18:17:22.17',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2276628107',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3562479292',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '566',
                        IFNAME           => 'ge-0/0/38.0',
                        IFDESCR          => 'ge-0/0/38.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:29',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(671864217) 77 days, 18:17:22.17',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3779632',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '449506711',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '567',
                        IFNAME           => 'ge-0/0/39',
                        IFDESCR          => 'ge-0/0/39',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:2a',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3579) 0:00:35.79',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '568',
                        IFNAME           => 'ge-0/0/39.0',
                        IFDESCR          => 'ge-0/0/39.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:2a',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3785) 0:00:37.85',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '569',
                        IFNAME           => 'ge-0/0/4',
                        IFDESCR          => 'ge-0/0/4',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:07',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3256) 0:00:32.56',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '570',
                        IFNAME           => 'ge-0/0/4.0',
                        IFDESCR          => 'ge-0/0/4.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:07',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3258) 0:00:32.58',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '571',
                        IFNAME           => 'ge-0/0/40',
                        IFDESCR          => 'ge-0/0/40',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:2b',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(623010977) 72 days, 2:35:09.77',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3533234512',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2633122441',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '572',
                        IFNAME           => 'ge-0/0/40.0',
                        IFDESCR          => 'ge-0/0/40.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:2b',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(623010977) 72 days, 2:35:09.77',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3134933',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '449446120',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '573',
                        IFNAME           => 'ge-0/0/41',
                        IFDESCR          => 'ge-0/0/41',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:2c',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(380811077) 44 days, 1:48:30.77',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3363359789',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1143757502',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '574',
                        IFNAME           => 'ge-0/0/41.0',
                        IFDESCR          => 'ge-0/0/41.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:2c',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(380811077) 44 days, 1:48:30.77',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '6930628',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '449497792',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '575',
                        IFNAME           => 'ge-0/0/42',
                        IFDESCR          => 'ge-0/0/42',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:2d',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(626710427) 72 days, 12:51:44.27',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '360348982',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1936465493',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '576',
                        IFNAME           => 'ge-0/0/42.0',
                        IFDESCR          => 'ge-0/0/42.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:2d',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(626710427) 72 days, 12:51:44.27',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '928054',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '93754257',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '577',
                        IFNAME           => 'ge-0/0/43',
                        IFDESCR          => 'ge-0/0/43',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:2e',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3616) 0:00:36.16',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '578',
                        IFNAME           => 'ge-0/0/43.0',
                        IFDESCR          => 'ge-0/0/43.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:2e',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3833) 0:00:38.33',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '579',
                        IFNAME           => 'ge-0/0/44',
                        IFDESCR          => 'ge-0/0/44',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:2f',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(654832517) 75 days, 18:58:45.17',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3158408642',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4246970219',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '580',
                        IFNAME           => 'ge-0/0/44.0',
                        IFDESCR          => 'ge-0/0/44.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:2f',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(654832517) 75 days, 18:58:45.17',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '41406521',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '449536917',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFNUMBER => '0x001A1ECDBB02',
                                IFDESCR  => 'eth0',
                                SYSNAME  => 'PMF-sap-c407',
                                SYSDESCR => 'ArubaOS (MODEL: 125), Version 6.2.1.2 (38711)',
                                SYSMAC   => '00:1a:1e:cd:bb:02',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '581',
                        IFNAME           => 'ge-0/0/45',
                        IFDESCR          => 'ge-0/0/45',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:30',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(561606847) 65 days, 0:01:08.47',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3458219972',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '244487005',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '582',
                        IFNAME           => 'ge-0/0/45.0',
                        IFDESCR          => 'ge-0/0/45.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:30',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(561606847) 65 days, 0:01:08.47',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '16584800',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '465451921',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '583',
                        IFNAME           => 'ge-0/0/46',
                        IFDESCR          => 'ge-0/0/46',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:03',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3635) 0:00:36.35',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '584',
                        IFNAME           => 'ge-0/0/47.0',
                        IFDESCR          => 'ge-0/0/47.0',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:03',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3903) 0:00:39.03',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '585',
                        IFNAME           => 'ge-0/0/47',
                        IFDESCR          => 'ge-0/0/47',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:03',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3638) 0:00:36.38',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '586',
                        IFNAME           => 'ge-0/0/0.0',
                        IFDESCR          => 'ge-0/0/0.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:03',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7247) 0:01:12.47',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3030702800',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '171078177',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '587',
                        IFNAME           => 'ge-0/0/5',
                        IFDESCR          => 'ge-0/0/5',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:08',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3259) 0:00:32.59',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '588',
                        IFNAME           => 'ge-0/0/5.0',
                        IFDESCR          => 'ge-0/0/5.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:08',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3261) 0:00:32.61',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '589',
                        IFNAME           => 'ge-0/0/6',
                        IFDESCR          => 'ge-0/0/6',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:09',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3301) 0:00:33.01',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '590',
                        IFNAME           => 'ge-0/0/6.0',
                        IFDESCR          => 'ge-0/0/6.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:09',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3304) 0:00:33.04',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '591',
                        IFNAME           => 'ge-0/0/7',
                        IFDESCR          => 'ge-0/0/7',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:0a',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3311) 0:00:33.11',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '592',
                        IFNAME           => 'ge-0/0/7.0',
                        IFDESCR          => 'ge-0/0/7.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:0a',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3314) 0:00:33.14',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '593',
                        IFNAME           => 'ge-0/0/8',
                        IFDESCR          => 'ge-0/0/8',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:0b',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3328) 0:00:33.28',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '594',
                        IFNAME           => 'ge-0/0/8.0',
                        IFDESCR          => 'ge-0/0/8.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:0b',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3333) 0:00:33.33',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '595',
                        IFNAME           => 'ge-0/0/9',
                        IFDESCR          => 'ge-0/0/9',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:0c',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3338) 0:00:33.38',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '596',
                        IFNAME           => 'ge-0/0/9.0',
                        IFDESCR          => 'ge-0/0/9.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:0c',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3340) 0:00:33.40',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '599',
                        IFNAME           => 'vlan',
                        IFDESCR          => 'vlan',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1518',
                        MAC              => '78:fe:3d:36:f7:01',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3224) 0:00:32.24',
                        IFINOCTETS       => '1782820774',
                        IFINERRORS       => '18',
                        IFOUTOCTETS      => '68750026',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '600',
                        IFNAME           => 'vlan.0',
                        IFDESCR          => 'vlan.0',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        IP               => '192.168.100.65',
                        MAC              => '78:fe:3d:36:f7:01',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7309) 0:01:13.09',
                        IFINOCTETS       => '1782820862',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '64824825',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '609',
                        IFNAME           => 'ae0',
                        IFDESCR          => 'ae0',
                        IFTYPE           => '161',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:03',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3215) 0:00:32.15',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '610',
                        IFNAME           => 'ae1',
                        IFDESCR          => 'ae1',
                        IFTYPE           => '161',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:04',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3216) 0:00:32.16',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '611',
                        IFNAME           => 'ae2',
                        IFDESCR          => 'ae2',
                        IFTYPE           => '161',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:05',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3218) 0:00:32.18',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '612',
                        IFNAME           => 'ae3',
                        IFDESCR          => 'ae3',
                        IFTYPE           => '161',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:06',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3219) 0:00:32.19',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '613',
                        IFNAME           => 'ae4',
                        IFDESCR          => 'ae4',
                        IFTYPE           => '161',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:07',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3221) 0:00:32.21',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '614',
                        IFNAME           => 'ae0.0',
                        IFDESCR          => 'ae0.0',
                        IFTYPE           => '161',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:03',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3222) 0:00:32.22',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'juniper/ex2200.06.walk' => [
        {
            MANUFACTURER => 'Juniper',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Juniper Networks, Inc. ex2200-48t-4g internet router, kernel JUNOS 11.4R5.5 #0: 2012-08-25 05:21:13 UTC     builder@evenath.juniper.net:/volume/build/junos/11.4/release/11.4R5.5/obj-arm/bsd/kernels/JUNIPER-EX-2200/kernel Build date: 2012-08-25 04:48:47 U',
            SNMPHOSTNAME => 'jtc407-01',
            MAC          => undef,
            MODEL        => 'EX2200',
        },
        {
            MANUFACTURER => 'Juniper',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Juniper Networks, Inc. ex2200-48t-4g internet router, kernel JUNOS 11.4R5.5 #0: 2012-08-25 05:21:13 UTC     builder@evenath.juniper.net:/volume/build/junos/11.4/release/11.4R5.5/obj-arm/bsd/kernels/JUNIPER-EX-2200/kernel Build date: 2012-08-25 04:48:47 U',
            SNMPHOSTNAME => 'jtc407-01',
            MAC          => '78:fe:3d:36:f7:00',
            MODELSNMP    => 'Networking2495',
            MODEL        => 'EX2200',
            FIRMWARE     => undef,
            SERIAL       => undef,
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Juniper',
                TYPE         => 'NETWORKING',
                MODEL        => 'EX2200',
                COMMENTS     => 'Juniper Networks, Inc. ex2200-48t-4g internet router, kernel JUNOS 11.4R5.5 #0: 2012-08-25 05:21:13 UTC     builder@evenath.juniper.net:/volume/build/junos/11.4/release/11.4R5.5/obj-arm/bsd/kernels/JUNIPER-EX-2200/kernel Build date: 2012-08-25 04:48:47 U',
                NAME         => 'jtc407-01',
                LOCATION     => 'PMF 4 n° 407',
                UPTIME       => '(690835636) 79 days, 22:59:16.36',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '4',
                        IFNAME           => 'lsi',
                        IFDESCR          => 'lsi',
                        IFTYPE           => '150',
                        IFSPEED          => '0',
                        IFMTU            => '1496',
                    },
                    {
                        IFNUMBER         => '5',
                        IFNAME           => 'dsc',
                        IFDESCR          => 'dsc',
                        IFTYPE           => '1',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                    },
                    {
                        IFNUMBER         => '6',
                        IFNAME           => 'lo0',
                        IFDESCR          => 'lo0',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                    },
                    {
                        IFNUMBER         => '7',
                        IFNAME           => 'tap',
                        IFDESCR          => 'tap',
                        IFTYPE           => '1',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                    },
                    {
                        IFNUMBER         => '8',
                        IFNAME           => 'gre',
                        IFDESCR          => 'gre',
                        IFTYPE           => '131',
                        IFMTU            => '2147483647',
                    },
                    {
                        IFNUMBER         => '9',
                        IFNAME           => 'ipip',
                        IFDESCR          => 'ipip',
                        IFTYPE           => '131',
                        IFMTU            => '2147483647',
                    },
                    {
                        IFNUMBER         => '10',
                        IFNAME           => 'pime',
                        IFDESCR          => 'pime',
                        IFTYPE           => '131',
                        IFMTU            => '2147483647',
                    },
                    {
                        IFNUMBER         => '11',
                        IFNAME           => 'pimd',
                        IFDESCR          => 'pimd',
                        IFTYPE           => '131',
                        IFMTU            => '2147483647',
                    },
                    {
                        IFNUMBER         => '12',
                        IFNAME           => 'mtun',
                        IFDESCR          => 'mtun',
                        IFTYPE           => '131',
                        IFMTU            => '2147483647',
                    },
                    {
                        IFNUMBER         => '33',
                        IFNAME           => 'me0',
                        IFDESCR          => 'me0',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '37',
                        IFNAME           => 'bme0',
                        IFDESCR          => 'bme0',
                        IFTYPE           => '6',
                        IFMTU            => '1576',
                    },
                    {
                        IFNUMBER         => '38',
                        IFNAME           => 'bme0.32768',
                        IFDESCR          => 'bme0.32768',
                        IFTYPE           => '53',
                        IFMTU            => '1562',
                    },
                    {
                        IFNUMBER         => '501',
                        IFNAME           => 'ge-0/0/0',
                        IFDESCR          => 'ge-0/0/0',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '502',
                        IFNAME           => 'ge-0/0/46.0',
                        IFDESCR          => 'ge-0/0/46.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '503',
                        IFNAME           => 'ge-0/0/1',
                        IFDESCR          => 'ge-0/0/1',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '504',
                        IFNAME           => 'ge-0/0/1.0',
                        IFDESCR          => 'ge-0/0/1.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '505',
                        IFNAME           => 'ge-0/0/10',
                        IFDESCR          => 'ge-0/0/10',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '506',
                        IFNAME           => 'ge-0/0/10.0',
                        IFDESCR          => 'ge-0/0/10.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '507',
                        IFNAME           => 'ge-0/0/11',
                        IFDESCR          => 'ge-0/0/11',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '508',
                        IFNAME           => 'ge-0/0/11.0',
                        IFDESCR          => 'ge-0/0/11.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '509',
                        IFNAME           => 'ge-0/0/12',
                        IFDESCR          => 'ge-0/0/12',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '510',
                        IFNAME           => 'ge-0/0/12.0',
                        IFDESCR          => 'ge-0/0/12.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '511',
                        IFNAME           => 'ge-0/0/13',
                        IFDESCR          => 'ge-0/0/13',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '512',
                        IFNAME           => 'ge-0/0/13.0',
                        IFDESCR          => 'ge-0/0/13.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '513',
                        IFNAME           => 'ge-0/0/14',
                        IFDESCR          => 'ge-0/0/14',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '514',
                        IFNAME           => 'ge-0/0/14.0',
                        IFDESCR          => 'ge-0/0/14.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '515',
                        IFNAME           => 'ge-0/0/15',
                        IFDESCR          => 'ge-0/0/15',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '516',
                        IFNAME           => 'ge-0/0/15.0',
                        IFDESCR          => 'ge-0/0/15.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '517',
                        IFNAME           => 'ge-0/0/16',
                        IFDESCR          => 'ge-0/0/16',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '518',
                        IFNAME           => 'ge-0/0/16.0',
                        IFDESCR          => 'ge-0/0/16.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '519',
                        IFNAME           => 'ge-0/0/17',
                        IFDESCR          => 'ge-0/0/17',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '520',
                        IFNAME           => 'ge-0/0/17.0',
                        IFDESCR          => 'ge-0/0/17.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '521',
                        IFNAME           => 'ge-0/0/18',
                        IFDESCR          => 'ge-0/0/18',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '522',
                        IFNAME           => 'ge-0/0/18.0',
                        IFDESCR          => 'ge-0/0/18.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '523',
                        IFNAME           => 'ge-0/0/19',
                        IFDESCR          => 'ge-0/0/19',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '524',
                        IFNAME           => 'ge-0/0/19.0',
                        IFDESCR          => 'ge-0/0/19.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '525',
                        IFNAME           => 'ge-0/0/2',
                        IFDESCR          => 'ge-0/0/2',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '526',
                        IFNAME           => 'ge-0/0/2.0',
                        IFDESCR          => 'ge-0/0/2.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '527',
                        IFNAME           => 'ge-0/0/20',
                        IFDESCR          => 'ge-0/0/20',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '528',
                        IFNAME           => 'ge-0/0/20.0',
                        IFDESCR          => 'ge-0/0/20.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '529',
                        IFNAME           => 'ge-0/0/21',
                        IFDESCR          => 'ge-0/0/21',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '530',
                        IFNAME           => 'ge-0/0/21.0',
                        IFDESCR          => 'ge-0/0/21.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '531',
                        IFNAME           => 'ge-0/0/22',
                        IFDESCR          => 'ge-0/0/22',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '532',
                        IFNAME           => 'ge-0/0/22.0',
                        IFDESCR          => 'ge-0/0/22.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '533',
                        IFNAME           => 'ge-0/0/23',
                        IFDESCR          => 'ge-0/0/23',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '534',
                        IFNAME           => 'ge-0/0/23.0',
                        IFDESCR          => 'ge-0/0/23.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '535',
                        IFNAME           => 'ge-0/0/24',
                        IFDESCR          => 'ge-0/0/24',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '536',
                        IFNAME           => 'ge-0/0/24.0',
                        IFDESCR          => 'ge-0/0/24.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '537',
                        IFNAME           => 'ge-0/0/25',
                        IFDESCR          => 'ge-0/0/25',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '538',
                        IFNAME           => 'ge-0/0/25.0',
                        IFDESCR          => 'ge-0/0/25.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '539',
                        IFNAME           => 'ge-0/0/26',
                        IFDESCR          => 'ge-0/0/26',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '540',
                        IFNAME           => 'ge-0/0/26.0',
                        IFDESCR          => 'ge-0/0/26.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '541',
                        IFNAME           => 'ge-0/0/27',
                        IFDESCR          => 'ge-0/0/27',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '542',
                        IFNAME           => 'ge-0/0/27.0',
                        IFDESCR          => 'ge-0/0/27.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '543',
                        IFNAME           => 'ge-0/0/28',
                        IFDESCR          => 'ge-0/0/28',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '544',
                        IFNAME           => 'ge-0/0/28.0',
                        IFDESCR          => 'ge-0/0/28.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '545',
                        IFNAME           => 'ge-0/0/29',
                        IFDESCR          => 'ge-0/0/29',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '546',
                        IFNAME           => 'ge-0/0/29.0',
                        IFDESCR          => 'ge-0/0/29.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '547',
                        IFNAME           => 'ge-0/0/3',
                        IFDESCR          => 'ge-0/0/3',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '548',
                        IFNAME           => 'ge-0/0/3.0',
                        IFDESCR          => 'ge-0/0/3.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '549',
                        IFNAME           => 'ge-0/0/30',
                        IFDESCR          => 'ge-0/0/30',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '550',
                        IFNAME           => 'ge-0/0/30.0',
                        IFDESCR          => 'ge-0/0/30.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '551',
                        IFNAME           => 'ge-0/0/31',
                        IFDESCR          => 'ge-0/0/31',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '552',
                        IFNAME           => 'ge-0/0/31.0',
                        IFDESCR          => 'ge-0/0/31.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '553',
                        IFNAME           => 'ge-0/0/32',
                        IFDESCR          => 'ge-0/0/32',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '554',
                        IFNAME           => 'ge-0/0/32.0',
                        IFDESCR          => 'ge-0/0/32.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '555',
                        IFNAME           => 'ge-0/0/33',
                        IFDESCR          => 'ge-0/0/33',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '556',
                        IFNAME           => 'ge-0/0/33.0',
                        IFDESCR          => 'ge-0/0/33.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '557',
                        IFNAME           => 'ge-0/0/34',
                        IFDESCR          => 'ge-0/0/34',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '558',
                        IFNAME           => 'ge-0/0/34.0',
                        IFDESCR          => 'ge-0/0/34.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '559',
                        IFNAME           => 'ge-0/0/35',
                        IFDESCR          => 'ge-0/0/35',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '560',
                        IFNAME           => 'ge-0/0/35.0',
                        IFDESCR          => 'ge-0/0/35.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '561',
                        IFNAME           => 'ge-0/0/36',
                        IFDESCR          => 'ge-0/0/36',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '562',
                        IFNAME           => 'ge-0/0/36.0',
                        IFDESCR          => 'ge-0/0/36.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '563',
                        IFNAME           => 'ge-0/0/37',
                        IFDESCR          => 'ge-0/0/37',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '564',
                        IFNAME           => 'ge-0/0/37.0',
                        IFDESCR          => 'ge-0/0/37.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '565',
                        IFNAME           => 'ge-0/0/38',
                        IFDESCR          => 'ge-0/0/38',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '566',
                        IFNAME           => 'ge-0/0/38.0',
                        IFDESCR          => 'ge-0/0/38.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '567',
                        IFNAME           => 'ge-0/0/39',
                        IFDESCR          => 'ge-0/0/39',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '568',
                        IFNAME           => 'ge-0/0/39.0',
                        IFDESCR          => 'ge-0/0/39.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '569',
                        IFNAME           => 'ge-0/0/4',
                        IFDESCR          => 'ge-0/0/4',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '570',
                        IFNAME           => 'ge-0/0/4.0',
                        IFDESCR          => 'ge-0/0/4.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '571',
                        IFNAME           => 'ge-0/0/40',
                        IFDESCR          => 'ge-0/0/40',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '572',
                        IFNAME           => 'ge-0/0/40.0',
                        IFDESCR          => 'ge-0/0/40.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '573',
                        IFNAME           => 'ge-0/0/41',
                        IFDESCR          => 'ge-0/0/41',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '574',
                        IFNAME           => 'ge-0/0/41.0',
                        IFDESCR          => 'ge-0/0/41.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '575',
                        IFNAME           => 'ge-0/0/42',
                        IFDESCR          => 'ge-0/0/42',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '576',
                        IFNAME           => 'ge-0/0/42.0',
                        IFDESCR          => 'ge-0/0/42.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '577',
                        IFNAME           => 'ge-0/0/43',
                        IFDESCR          => 'ge-0/0/43',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '578',
                        IFNAME           => 'ge-0/0/43.0',
                        IFDESCR          => 'ge-0/0/43.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '579',
                        IFNAME           => 'ge-0/0/44',
                        IFDESCR          => 'ge-0/0/44',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '580',
                        IFNAME           => 'ge-0/0/44.0',
                        IFDESCR          => 'ge-0/0/44.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFNUMBER => '0x001A1ECDBB02',
                                IFDESCR  => 'eth0',
                                SYSNAME  => 'PMF-sap-c407',
                                SYSDESCR => 'ArubaOS (MODEL: 125), Version 6.2.1.2 (38711)',
                                SYSMAC   => '00:1a:1e:cd:bb:02',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '581',
                        IFNAME           => 'ge-0/0/45',
                        IFDESCR          => 'ge-0/0/45',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '582',
                        IFNAME           => 'ge-0/0/45.0',
                        IFDESCR          => 'ge-0/0/45.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '583',
                        IFNAME           => 'ge-0/0/46',
                        IFDESCR          => 'ge-0/0/46',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '584',
                        IFNAME           => 'ge-0/0/47.0',
                        IFDESCR          => 'ge-0/0/47.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '585',
                        IFNAME           => 'ge-0/0/47',
                        IFDESCR          => 'ge-0/0/47',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '586',
                        IFNAME           => 'ge-0/0/0.0',
                        IFDESCR          => 'ge-0/0/0.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '587',
                        IFNAME           => 'ge-0/0/5',
                        IFDESCR          => 'ge-0/0/5',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '588',
                        IFNAME           => 'ge-0/0/5.0',
                        IFDESCR          => 'ge-0/0/5.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '589',
                        IFNAME           => 'ge-0/0/6',
                        IFDESCR          => 'ge-0/0/6',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '590',
                        IFNAME           => 'ge-0/0/6.0',
                        IFDESCR          => 'ge-0/0/6.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '591',
                        IFNAME           => 'ge-0/0/7',
                        IFDESCR          => 'ge-0/0/7',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '592',
                        IFNAME           => 'ge-0/0/7.0',
                        IFDESCR          => 'ge-0/0/7.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '593',
                        IFNAME           => 'ge-0/0/8',
                        IFDESCR          => 'ge-0/0/8',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '594',
                        IFNAME           => 'ge-0/0/8.0',
                        IFDESCR          => 'ge-0/0/8.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '595',
                        IFNAME           => 'ge-0/0/9',
                        IFDESCR          => 'ge-0/0/9',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '596',
                        IFNAME           => 'ge-0/0/9.0',
                        IFDESCR          => 'ge-0/0/9.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '599',
                        IFNAME           => 'vlan',
                        IFDESCR          => 'vlan',
                        IFTYPE           => '6',
                        IFMTU            => '1518',
                    },
                    {
                        IFNUMBER         => '600',
                        IFNAME           => 'vlan.0',
                        IFDESCR          => 'vlan.0',
                        IFTYPE           => '53',
                        IFMTU            => '1500',
                    },
                    {
                        IFNUMBER         => '609',
                        IFNAME           => 'ae0',
                        IFDESCR          => 'ae0',
                        IFTYPE           => '161',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '610',
                        IFNAME           => 'ae1',
                        IFDESCR          => 'ae1',
                        IFTYPE           => '161',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '611',
                        IFNAME           => 'ae2',
                        IFDESCR          => 'ae2',
                        IFTYPE           => '161',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '612',
                        IFNAME           => 'ae3',
                        IFDESCR          => 'ae3',
                        IFTYPE           => '161',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '613',
                        IFNAME           => 'ae4',
                        IFDESCR          => 'ae4',
                        IFTYPE           => '161',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '614',
                        IFNAME           => 'ae0.0',
                        IFDESCR          => 'ae0.0',
                        IFTYPE           => '161',
                        IFMTU            => '1514',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Juniper',
                TYPE         => 'NETWORKING',
                MODEL        => 'EX2200',
                COMMENTS     => 'Juniper Networks, Inc. ex2200-48t-4g internet router, kernel JUNOS 11.4R5.5 #0: 2012-08-25 05:21:13 UTC     builder@evenath.juniper.net:/volume/build/junos/11.4/release/11.4R5.5/obj-arm/bsd/kernels/JUNIPER-EX-2200/kernel Build date: 2012-08-25 04:48:47 U',
                NAME         => 'jtc407-01',
                LOCATION     => 'PMF 4 n° 407',
                MAC          => '78:fe:3d:36:f7:00',
                UPTIME       => '(690835636) 79 days, 22:59:16.36',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '4',
                        IFNAME           => 'lsi',
                        IFDESCR          => 'lsi',
                        IFTYPE           => '150',
                        IFSPEED          => '0',
                        IFMTU            => '1496',
                    },
                    {
                        IFNUMBER         => '5',
                        IFNAME           => 'dsc',
                        IFDESCR          => 'dsc',
                        IFTYPE           => '1',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                    },
                    {
                        IFNUMBER         => '6',
                        IFNAME           => 'lo0',
                        IFDESCR          => 'lo0',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                    },
                    {
                        IFNUMBER         => '7',
                        IFNAME           => 'tap',
                        IFDESCR          => 'tap',
                        IFTYPE           => '1',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                    },
                    {
                        IFNUMBER         => '8',
                        IFNAME           => 'gre',
                        IFDESCR          => 'gre',
                        IFTYPE           => '131',
                        IFMTU            => '2147483647',
                    },
                    {
                        IFNUMBER         => '9',
                        IFNAME           => 'ipip',
                        IFDESCR          => 'ipip',
                        IFTYPE           => '131',
                        IFMTU            => '2147483647',
                    },
                    {
                        IFNUMBER         => '10',
                        IFNAME           => 'pime',
                        IFDESCR          => 'pime',
                        IFTYPE           => '131',
                        IFMTU            => '2147483647',
                    },
                    {
                        IFNUMBER         => '11',
                        IFNAME           => 'pimd',
                        IFDESCR          => 'pimd',
                        IFTYPE           => '131',
                        IFMTU            => '2147483647',
                    },
                    {
                        IFNUMBER         => '12',
                        IFNAME           => 'mtun',
                        IFDESCR          => 'mtun',
                        IFTYPE           => '131',
                        IFMTU            => '2147483647',
                    },
                    {
                        IFNUMBER         => '33',
                        IFNAME           => 'me0',
                        IFDESCR          => 'me0',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '37',
                        IFNAME           => 'bme0',
                        IFDESCR          => 'bme0',
                        IFTYPE           => '6',
                        IFMTU            => '1576',
                    },
                    {
                        IFNUMBER         => '38',
                        IFNAME           => 'bme0.32768',
                        IFDESCR          => 'bme0.32768',
                        IFTYPE           => '53',
                        IFMTU            => '1562',
                    },
                    {
                        IFNUMBER         => '501',
                        IFNAME           => 'ge-0/0/0',
                        IFDESCR          => 'ge-0/0/0',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '502',
                        IFNAME           => 'ge-0/0/46.0',
                        IFDESCR          => 'ge-0/0/46.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '503',
                        IFNAME           => 'ge-0/0/1',
                        IFDESCR          => 'ge-0/0/1',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '504',
                        IFNAME           => 'ge-0/0/1.0',
                        IFDESCR          => 'ge-0/0/1.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '505',
                        IFNAME           => 'ge-0/0/10',
                        IFDESCR          => 'ge-0/0/10',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '506',
                        IFNAME           => 'ge-0/0/10.0',
                        IFDESCR          => 'ge-0/0/10.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '507',
                        IFNAME           => 'ge-0/0/11',
                        IFDESCR          => 'ge-0/0/11',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '508',
                        IFNAME           => 'ge-0/0/11.0',
                        IFDESCR          => 'ge-0/0/11.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '509',
                        IFNAME           => 'ge-0/0/12',
                        IFDESCR          => 'ge-0/0/12',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '510',
                        IFNAME           => 'ge-0/0/12.0',
                        IFDESCR          => 'ge-0/0/12.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '511',
                        IFNAME           => 'ge-0/0/13',
                        IFDESCR          => 'ge-0/0/13',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '512',
                        IFNAME           => 'ge-0/0/13.0',
                        IFDESCR          => 'ge-0/0/13.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '513',
                        IFNAME           => 'ge-0/0/14',
                        IFDESCR          => 'ge-0/0/14',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '514',
                        IFNAME           => 'ge-0/0/14.0',
                        IFDESCR          => 'ge-0/0/14.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '515',
                        IFNAME           => 'ge-0/0/15',
                        IFDESCR          => 'ge-0/0/15',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '516',
                        IFNAME           => 'ge-0/0/15.0',
                        IFDESCR          => 'ge-0/0/15.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '517',
                        IFNAME           => 'ge-0/0/16',
                        IFDESCR          => 'ge-0/0/16',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '518',
                        IFNAME           => 'ge-0/0/16.0',
                        IFDESCR          => 'ge-0/0/16.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '519',
                        IFNAME           => 'ge-0/0/17',
                        IFDESCR          => 'ge-0/0/17',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '520',
                        IFNAME           => 'ge-0/0/17.0',
                        IFDESCR          => 'ge-0/0/17.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '521',
                        IFNAME           => 'ge-0/0/18',
                        IFDESCR          => 'ge-0/0/18',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '522',
                        IFNAME           => 'ge-0/0/18.0',
                        IFDESCR          => 'ge-0/0/18.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '523',
                        IFNAME           => 'ge-0/0/19',
                        IFDESCR          => 'ge-0/0/19',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '524',
                        IFNAME           => 'ge-0/0/19.0',
                        IFDESCR          => 'ge-0/0/19.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '525',
                        IFNAME           => 'ge-0/0/2',
                        IFDESCR          => 'ge-0/0/2',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '526',
                        IFNAME           => 'ge-0/0/2.0',
                        IFDESCR          => 'ge-0/0/2.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '527',
                        IFNAME           => 'ge-0/0/20',
                        IFDESCR          => 'ge-0/0/20',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '528',
                        IFNAME           => 'ge-0/0/20.0',
                        IFDESCR          => 'ge-0/0/20.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '529',
                        IFNAME           => 'ge-0/0/21',
                        IFDESCR          => 'ge-0/0/21',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '530',
                        IFNAME           => 'ge-0/0/21.0',
                        IFDESCR          => 'ge-0/0/21.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '531',
                        IFNAME           => 'ge-0/0/22',
                        IFDESCR          => 'ge-0/0/22',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '532',
                        IFNAME           => 'ge-0/0/22.0',
                        IFDESCR          => 'ge-0/0/22.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '533',
                        IFNAME           => 'ge-0/0/23',
                        IFDESCR          => 'ge-0/0/23',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '534',
                        IFNAME           => 'ge-0/0/23.0',
                        IFDESCR          => 'ge-0/0/23.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '535',
                        IFNAME           => 'ge-0/0/24',
                        IFDESCR          => 'ge-0/0/24',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '536',
                        IFNAME           => 'ge-0/0/24.0',
                        IFDESCR          => 'ge-0/0/24.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '537',
                        IFNAME           => 'ge-0/0/25',
                        IFDESCR          => 'ge-0/0/25',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '538',
                        IFNAME           => 'ge-0/0/25.0',
                        IFDESCR          => 'ge-0/0/25.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '539',
                        IFNAME           => 'ge-0/0/26',
                        IFDESCR          => 'ge-0/0/26',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '540',
                        IFNAME           => 'ge-0/0/26.0',
                        IFDESCR          => 'ge-0/0/26.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '541',
                        IFNAME           => 'ge-0/0/27',
                        IFDESCR          => 'ge-0/0/27',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '542',
                        IFNAME           => 'ge-0/0/27.0',
                        IFDESCR          => 'ge-0/0/27.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '543',
                        IFNAME           => 'ge-0/0/28',
                        IFDESCR          => 'ge-0/0/28',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '544',
                        IFNAME           => 'ge-0/0/28.0',
                        IFDESCR          => 'ge-0/0/28.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '545',
                        IFNAME           => 'ge-0/0/29',
                        IFDESCR          => 'ge-0/0/29',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '546',
                        IFNAME           => 'ge-0/0/29.0',
                        IFDESCR          => 'ge-0/0/29.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '547',
                        IFNAME           => 'ge-0/0/3',
                        IFDESCR          => 'ge-0/0/3',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '548',
                        IFNAME           => 'ge-0/0/3.0',
                        IFDESCR          => 'ge-0/0/3.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '549',
                        IFNAME           => 'ge-0/0/30',
                        IFDESCR          => 'ge-0/0/30',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '550',
                        IFNAME           => 'ge-0/0/30.0',
                        IFDESCR          => 'ge-0/0/30.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '551',
                        IFNAME           => 'ge-0/0/31',
                        IFDESCR          => 'ge-0/0/31',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '552',
                        IFNAME           => 'ge-0/0/31.0',
                        IFDESCR          => 'ge-0/0/31.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '553',
                        IFNAME           => 'ge-0/0/32',
                        IFDESCR          => 'ge-0/0/32',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '554',
                        IFNAME           => 'ge-0/0/32.0',
                        IFDESCR          => 'ge-0/0/32.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '555',
                        IFNAME           => 'ge-0/0/33',
                        IFDESCR          => 'ge-0/0/33',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '556',
                        IFNAME           => 'ge-0/0/33.0',
                        IFDESCR          => 'ge-0/0/33.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '557',
                        IFNAME           => 'ge-0/0/34',
                        IFDESCR          => 'ge-0/0/34',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '558',
                        IFNAME           => 'ge-0/0/34.0',
                        IFDESCR          => 'ge-0/0/34.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '559',
                        IFNAME           => 'ge-0/0/35',
                        IFDESCR          => 'ge-0/0/35',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '560',
                        IFNAME           => 'ge-0/0/35.0',
                        IFDESCR          => 'ge-0/0/35.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '561',
                        IFNAME           => 'ge-0/0/36',
                        IFDESCR          => 'ge-0/0/36',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '562',
                        IFNAME           => 'ge-0/0/36.0',
                        IFDESCR          => 'ge-0/0/36.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '563',
                        IFNAME           => 'ge-0/0/37',
                        IFDESCR          => 'ge-0/0/37',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '564',
                        IFNAME           => 'ge-0/0/37.0',
                        IFDESCR          => 'ge-0/0/37.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '565',
                        IFNAME           => 'ge-0/0/38',
                        IFDESCR          => 'ge-0/0/38',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '566',
                        IFNAME           => 'ge-0/0/38.0',
                        IFDESCR          => 'ge-0/0/38.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '567',
                        IFNAME           => 'ge-0/0/39',
                        IFDESCR          => 'ge-0/0/39',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '568',
                        IFNAME           => 'ge-0/0/39.0',
                        IFDESCR          => 'ge-0/0/39.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '569',
                        IFNAME           => 'ge-0/0/4',
                        IFDESCR          => 'ge-0/0/4',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '570',
                        IFNAME           => 'ge-0/0/4.0',
                        IFDESCR          => 'ge-0/0/4.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '571',
                        IFNAME           => 'ge-0/0/40',
                        IFDESCR          => 'ge-0/0/40',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '572',
                        IFNAME           => 'ge-0/0/40.0',
                        IFDESCR          => 'ge-0/0/40.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '573',
                        IFNAME           => 'ge-0/0/41',
                        IFDESCR          => 'ge-0/0/41',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '574',
                        IFNAME           => 'ge-0/0/41.0',
                        IFDESCR          => 'ge-0/0/41.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '575',
                        IFNAME           => 'ge-0/0/42',
                        IFDESCR          => 'ge-0/0/42',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '576',
                        IFNAME           => 'ge-0/0/42.0',
                        IFDESCR          => 'ge-0/0/42.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '577',
                        IFNAME           => 'ge-0/0/43',
                        IFDESCR          => 'ge-0/0/43',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '578',
                        IFNAME           => 'ge-0/0/43.0',
                        IFDESCR          => 'ge-0/0/43.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '579',
                        IFNAME           => 'ge-0/0/44',
                        IFDESCR          => 'ge-0/0/44',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '580',
                        IFNAME           => 'ge-0/0/44.0',
                        IFDESCR          => 'ge-0/0/44.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFNUMBER => '0x001A1ECDBB02',
                                IFDESCR  => 'eth0',
                                SYSNAME  => 'PMF-sap-c407',
                                SYSDESCR => 'ArubaOS (MODEL: 125), Version 6.2.1.2 (38711)',
                                SYSMAC   => '00:1a:1e:cd:bb:02',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '581',
                        IFNAME           => 'ge-0/0/45',
                        IFDESCR          => 'ge-0/0/45',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '582',
                        IFNAME           => 'ge-0/0/45.0',
                        IFDESCR          => 'ge-0/0/45.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '583',
                        IFNAME           => 'ge-0/0/46',
                        IFDESCR          => 'ge-0/0/46',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '584',
                        IFNAME           => 'ge-0/0/47.0',
                        IFDESCR          => 'ge-0/0/47.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '585',
                        IFNAME           => 'ge-0/0/47',
                        IFDESCR          => 'ge-0/0/47',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '586',
                        IFNAME           => 'ge-0/0/0.0',
                        IFDESCR          => 'ge-0/0/0.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '587',
                        IFNAME           => 'ge-0/0/5',
                        IFDESCR          => 'ge-0/0/5',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '588',
                        IFNAME           => 'ge-0/0/5.0',
                        IFDESCR          => 'ge-0/0/5.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '589',
                        IFNAME           => 'ge-0/0/6',
                        IFDESCR          => 'ge-0/0/6',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '590',
                        IFNAME           => 'ge-0/0/6.0',
                        IFDESCR          => 'ge-0/0/6.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '591',
                        IFNAME           => 'ge-0/0/7',
                        IFDESCR          => 'ge-0/0/7',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '592',
                        IFNAME           => 'ge-0/0/7.0',
                        IFDESCR          => 'ge-0/0/7.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '593',
                        IFNAME           => 'ge-0/0/8',
                        IFDESCR          => 'ge-0/0/8',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '594',
                        IFNAME           => 'ge-0/0/8.0',
                        IFDESCR          => 'ge-0/0/8.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '595',
                        IFNAME           => 'ge-0/0/9',
                        IFDESCR          => 'ge-0/0/9',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '596',
                        IFNAME           => 'ge-0/0/9.0',
                        IFDESCR          => 'ge-0/0/9.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '599',
                        IFNAME           => 'vlan',
                        IFDESCR          => 'vlan',
                        IFTYPE           => '6',
                        IFMTU            => '1518',
                    },
                    {
                        IFNUMBER         => '600',
                        IFNAME           => 'vlan.0',
                        IFDESCR          => 'vlan.0',
                        IFTYPE           => '53',
                        IFMTU            => '1500',
                    },
                    {
                        IFNUMBER         => '609',
                        IFNAME           => 'ae0',
                        IFDESCR          => 'ae0',
                        IFTYPE           => '161',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '610',
                        IFNAME           => 'ae1',
                        IFDESCR          => 'ae1',
                        IFTYPE           => '161',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '611',
                        IFNAME           => 'ae2',
                        IFDESCR          => 'ae2',
                        IFTYPE           => '161',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '612',
                        IFNAME           => 'ae3',
                        IFDESCR          => 'ae3',
                        IFTYPE           => '161',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '613',
                        IFNAME           => 'ae4',
                        IFDESCR          => 'ae4',
                        IFTYPE           => '161',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '614',
                        IFNAME           => 'ae0.0',
                        IFDESCR          => 'ae0.0',
                        IFTYPE           => '161',
                        IFMTU            => '1514',
                    },
                ]
            },
        },
    ],
    'juniper/ex2200.07.walk' => [
        {
            MANUFACTURER => 'Juniper',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Juniper Networks, Inc. ex2200-48p-4g internet router, kernel JUNOS 11.4R5.5 #0: 2012-08-25 05:21:13 UTC     builder@evenath.juniper.net:/volume/build/junos/11.4/release/11.4R5.5/obj-arm/bsd/kernels/JUNIPER-EX-2200/kernel Build date: 2012-08-25 04:48:47 U',
            SNMPHOSTNAME => 'jtc13-03',
            MAC          => '78:fe:3d:35:14:41',
            MODEL        => 'EX2200',
        },
        {
            MANUFACTURER => 'Juniper',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Juniper Networks, Inc. ex2200-48p-4g internet router, kernel JUNOS 11.4R5.5 #0: 2012-08-25 05:21:13 UTC     builder@evenath.juniper.net:/volume/build/junos/11.4/release/11.4R5.5/obj-arm/bsd/kernels/JUNIPER-EX-2200/kernel Build date: 2012-08-25 04:48:47 U',
            SNMPHOSTNAME => 'jtc13-03',
            MAC          => '78:fe:3d:35:14:41',
            MODEL        => 'EX2200',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Juniper',
                TYPE         => 'NETWORKING',
                MODEL        => 'EX2200',
                COMMENTS     => 'Juniper Networks, Inc. ex2200-48p-4g internet router, kernel JUNOS 11.4R5.5 #0: 2012-08-25 05:21:13 UTC     builder@evenath.juniper.net:/volume/build/junos/11.4/release/11.4R5.5/obj-arm/bsd/kernels/JUNIPER-EX-2200/kernel Build date: 2012-08-25 04:48:47 U',
                NAME         => 'jtc13-03',
                MEMORY       => '0',
                LOCATION     => 'PMF 13eme',
                IPS          => {
                    IP => [
                        '128.0.0.1',
                        '128.0.0.16',
                        '128.0.0.32',
                        '192.168.100.140',
                    ],
                },
                MAC          => '78:fe:3d:35:14:41',
                UPTIME       => '(499476755) 57 days, 19:26:07.55',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '4',
                        IFNAME           => 'lsi',
                        IFDESCR          => 'lsi',
                        IFTYPE           => '150',
                        IFSPEED          => '0',
                        IFMTU            => '1496',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '5',
                        IFNAME           => 'dsc',
                        IFDESCR          => 'dsc',
                        IFTYPE           => '1',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2310) 0:00:23.10',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '6',
                        IFNAME           => 'lo0',
                        IFDESCR          => 'lo0',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2330) 0:00:23.30',
                        IFINOCTETS       => '2891947405',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2892532185',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '7',
                        IFNAME           => 'tap',
                        IFDESCR          => 'tap',
                        IFTYPE           => '1',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2337) 0:00:23.37',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '8',
                        IFNAME           => 'gre',
                        IFDESCR          => 'gre',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2317) 0:00:23.17',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '9',
                        IFNAME           => 'ipip',
                        IFDESCR          => 'ipip',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2324) 0:00:23.24',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10',
                        IFNAME           => 'pime',
                        IFDESCR          => 'pime',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2343) 0:00:23.43',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '11',
                        IFNAME           => 'pimd',
                        IFDESCR          => 'pimd',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2346) 0:00:23.46',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '12',
                        IFNAME           => 'mtun',
                        IFDESCR          => 'mtun',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2391) 0:00:23.91',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '33',
                        IFNAME           => 'me0',
                        IFDESCR          => 'me0',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:7f',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2357) 0:00:23.57',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '34',
                        IFNAME           => 'me0.0',
                        IFDESCR          => 'me0.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '78:fe:3d:35:14:7f',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2373) 0:00:23.73',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '37',
                        IFNAME           => 'bme0',
                        IFDESCR          => 'bme0',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1576',
                        MAC              => '00:0b:ca:fe:00:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2302) 0:00:23.02',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2324005029',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '38',
                        IFNAME           => 'bme0.32768',
                        IFDESCR          => 'bme0.32768',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1562',
                        IP               => '128.0.0.32',
                        MAC              => '00:0b:ca:fe:00:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2394) 0:00:23.94',
                        IFINOCTETS       => '112538765',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '126',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '501',
                        IFNAME           => 'ge-0/0/0',
                        IFDESCR          => 'ge-0/0/0',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:43',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(83323040) 9 days, 15:27:10.40',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1744384224',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '338781511',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '502',
                        IFNAME           => 'ge-0/0/0.0',
                        IFDESCR          => 'ge-0/0/0.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:43',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(83323040) 9 days, 15:27:10.40',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2557466',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '56896598',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '503',
                        IFNAME           => 'ge-0/0/1',
                        IFDESCR          => 'ge-0/0/1',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:44',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(490874463) 56 days, 19:32:24.63',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '81139766',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '650360168',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '504',
                        IFNAME           => 'ge-0/0/1.0',
                        IFDESCR          => 'ge-0/0/1.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:44',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(490874463) 56 days, 19:32:24.63',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '212731',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '287926476',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '505',
                        IFNAME           => 'ge-0/0/10',
                        IFDESCR          => 'ge-0/0/10',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:4d',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(472291924) 54 days, 15:55:19.24',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '35529',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '39114',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '506',
                        IFNAME           => 'ge-0/0/10.0',
                        IFDESCR          => 'ge-0/0/10.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:4d',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(472291924) 54 days, 15:55:19.24',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '6838',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '22750',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '507',
                        IFNAME           => 'ge-0/0/11',
                        IFDESCR          => 'ge-0/0/11',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:4e',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(492159839) 56 days, 23:06:38.39',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '674968419',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1597370852',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '508',
                        IFNAME           => 'ge-0/0/11.0',
                        IFDESCR          => 'ge-0/0/11.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:4e',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(492159839) 56 days, 23:06:38.39',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2239067',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '12578934',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '509',
                        IFNAME           => 'ge-0/0/12',
                        IFDESCR          => 'ge-0/0/12',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:4f',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2728) 0:00:27.28',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '510',
                        IFNAME           => 'ge-0/0/12.0',
                        IFDESCR          => 'ge-0/0/12.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:4f',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2733) 0:00:27.33',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '511',
                        IFNAME           => 'ge-0/0/13',
                        IFDESCR          => 'ge-0/0/13',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:50',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(474504079) 54 days, 22:04:00.79',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '305790865',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '335531496',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '512',
                        IFNAME           => 'ge-0/0/13.0',
                        IFDESCR          => 'ge-0/0/13.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:50',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(474504079) 54 days, 22:04:00.79',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '814511',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '6868262',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '513',
                        IFNAME           => 'ge-0/0/14',
                        IFDESCR          => 'ge-0/0/14',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:51',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(472607150) 54 days, 16:47:51.50',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '706240582',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1981564306',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '514',
                        IFNAME           => 'ge-0/0/14.0',
                        IFDESCR          => 'ge-0/0/14.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:51',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(472607150) 54 days, 16:47:51.50',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2684663',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '305745401',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '515',
                        IFNAME           => 'ge-0/0/15',
                        IFDESCR          => 'ge-0/0/15',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:52',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(58579375) 6 days, 18:43:13.75',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '7474192',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '28526957',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '516',
                        IFNAME           => 'ge-0/0/15.0',
                        IFDESCR          => 'ge-0/0/15.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:52',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(58579375) 6 days, 18:43:13.75',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '58650',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '296261',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '517',
                        IFNAME           => 'ge-0/0/16',
                        IFDESCR          => 'ge-0/0/16',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:53',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(58586022) 6 days, 18:44:20.22',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2444780',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '50242056',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '518',
                        IFNAME           => 'ge-0/0/16.0',
                        IFDESCR          => 'ge-0/0/16.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:53',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(58586022) 6 days, 18:44:20.22',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '9576',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '38422452',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '519',
                        IFNAME           => 'ge-0/0/17',
                        IFDESCR          => 'ge-0/0/17',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:54',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2776) 0:00:27.76',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '520',
                        IFNAME           => 'ge-0/0/17.0',
                        IFDESCR          => 'ge-0/0/17.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:54',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2780) 0:00:27.80',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '521',
                        IFNAME           => 'ge-0/0/18',
                        IFDESCR          => 'ge-0/0/18',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:55',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(491424998) 56 days, 21:04:09.98',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '738137413',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '34484781',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '522',
                        IFNAME           => 'ge-0/0/18.0',
                        IFDESCR          => 'ge-0/0/18.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:55',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(491424998) 56 days, 21:04:09.98',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '227863',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '17397782',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '523',
                        IFNAME           => 'ge-0/0/19',
                        IFDESCR          => 'ge-0/0/19',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:56',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(474866627) 54 days, 23:04:26.27',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1235150564',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '854199719',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '524',
                        IFNAME           => 'ge-0/0/19.0',
                        IFDESCR          => 'ge-0/0/19.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:56',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(474866627) 54 days, 23:04:26.27',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1689222',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '40410472',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '525',
                        IFNAME           => 'ge-0/0/2',
                        IFDESCR          => 'ge-0/0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:45',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5910) 0:00:59.10',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1286810852',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '625722619',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '526',
                        IFNAME           => 'ge-0/0/2.0',
                        IFDESCR          => 'ge-0/0/2.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:45',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5910) 0:00:59.10',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2927955',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '327508850',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '527',
                        IFNAME           => 'ge-0/0/20',
                        IFDESCR          => 'ge-0/0/20',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:57',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2803) 0:00:28.03',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '528',
                        IFNAME           => 'ge-0/0/20.0',
                        IFDESCR          => 'ge-0/0/20.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:57',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2814) 0:00:28.14',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '529',
                        IFNAME           => 'ge-0/0/21',
                        IFDESCR          => 'ge-0/0/21',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:58',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2810) 0:00:28.10',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '530',
                        IFNAME           => 'ge-0/0/21.0',
                        IFDESCR          => 'ge-0/0/21.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:58',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2819) 0:00:28.19',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '531',
                        IFNAME           => 'ge-0/0/22',
                        IFDESCR          => 'ge-0/0/22',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:59',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(482826811) 55 days, 21:11:08.11',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '931159501',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2326041633',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '532',
                        IFNAME           => 'ge-0/0/22.0',
                        IFDESCR          => 'ge-0/0/22.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:59',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(482826811) 55 days, 21:11:08.11',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1428463',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '6920069',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '533',
                        IFNAME           => 'ge-0/0/23',
                        IFDESCR          => 'ge-0/0/23',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:5a',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2825) 0:00:28.25',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '534',
                        IFNAME           => 'ge-0/0/23.0',
                        IFDESCR          => 'ge-0/0/23.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:5a',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2849) 0:00:28.49',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '535',
                        IFNAME           => 'ge-0/0/24',
                        IFDESCR          => 'ge-0/0/24',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:5b',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(410512310) 47 days, 12:18:43.10',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3299641',
                        IFINERRORS       => '21',
                        IFOUTOCTETS      => '558181286',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '536',
                        IFNAME           => 'ge-0/0/24.0',
                        IFDESCR          => 'ge-0/0/24.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:5b',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(410512310) 47 days, 12:18:43.10',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2047',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '327656344',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '537',
                        IFNAME           => 'ge-0/0/25',
                        IFDESCR          => 'ge-0/0/25',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:5c',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(482930025) 55 days, 21:28:20.25',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '282999027',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3232568305',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '538',
                        IFNAME           => 'ge-0/0/25.0',
                        IFDESCR          => 'ge-0/0/25.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:5c',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(482930025) 55 days, 21:28:20.25',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '421384',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '19049883',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '539',
                        IFNAME           => 'ge-0/0/26',
                        IFDESCR          => 'ge-0/0/26',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:5d',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(480571640) 55 days, 14:55:16.40',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '433766676',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1449823136',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '540',
                        IFNAME           => 'ge-0/0/26.0',
                        IFDESCR          => 'ge-0/0/26.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:5d',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(480571640) 55 days, 14:55:16.40',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '553601',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '12043513',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '541',
                        IFNAME           => 'ge-0/0/27',
                        IFDESCR          => 'ge-0/0/27',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:5e',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(498384383) 57 days, 16:24:03.83',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '709592546',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2039323682',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '542',
                        IFNAME           => 'ge-0/0/27.0',
                        IFDESCR          => 'ge-0/0/27.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:5e',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(498384383) 57 days, 16:24:03.83',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '536134',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '284310206',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '543',
                        IFNAME           => 'ge-0/0/28',
                        IFDESCR          => 'ge-0/0/28',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:5f',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2853) 0:00:28.53',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '544',
                        IFNAME           => 'ge-0/0/28.0',
                        IFDESCR          => 'ge-0/0/28.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:5f',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2926) 0:00:29.26',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '545',
                        IFNAME           => 'ge-0/0/29',
                        IFDESCR          => 'ge-0/0/29',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:60',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(481571980) 55 days, 17:41:59.80',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '5303509',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '476264161',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '546',
                        IFNAME           => 'ge-0/0/29.0',
                        IFDESCR          => 'ge-0/0/29.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:60',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(481571980) 55 days, 17:41:59.80',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '5400',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '327586683',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '547',
                        IFNAME           => 'ge-0/0/3',
                        IFDESCR          => 'ge-0/0/3',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:46',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2560) 0:00:25.60',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '548',
                        IFNAME           => 'ge-0/0/3.0',
                        IFDESCR          => 'ge-0/0/3.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:46',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2574) 0:00:25.74',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '549',
                        IFNAME           => 'ge-0/0/30',
                        IFDESCR          => 'ge-0/0/30',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(498168960) 57 days, 15:48:09.60',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3168553434',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1575972079',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '550',
                        IFNAME           => 'ge-0/0/30.0',
                        IFDESCR          => 'ge-0/0/30.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(498168960) 57 days, 15:48:09.60',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '357238',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '330356904',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '551',
                        IFNAME           => 'ge-0/0/31',
                        IFDESCR          => 'ge-0/0/31',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:62',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5820) 0:00:58.20',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2168289414',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2998024565',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '552',
                        IFNAME           => 'ge-0/0/31.0',
                        IFDESCR          => 'ge-0/0/31.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:62',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5820) 0:00:58.20',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '276480',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '328409671',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '553',
                        IFNAME           => 'ge-0/0/32',
                        IFDESCR          => 'ge-0/0/32',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:63',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(498885870) 57 days, 17:47:38.70',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '227158483',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1931125831',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '554',
                        IFNAME           => 'ge-0/0/32.0',
                        IFDESCR          => 'ge-0/0/32.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:63',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(498885870) 57 days, 17:47:38.70',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '827296',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '13180849',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '555',
                        IFNAME           => 'ge-0/0/33',
                        IFDESCR          => 'ge-0/0/33',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:64',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(496811760) 57 days, 12:01:57.60',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1446896777',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '135042718',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '556',
                        IFNAME           => 'ge-0/0/33.0',
                        IFDESCR          => 'ge-0/0/33.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:64',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(496811760) 57 days, 12:01:57.60',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '5714913',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '32163624',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '557',
                        IFNAME           => 'ge-0/0/34',
                        IFDESCR          => 'ge-0/0/34',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:65',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(482370940) 55 days, 19:55:09.40',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '26151636',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1568180907',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '558',
                        IFNAME           => 'ge-0/0/34.0',
                        IFDESCR          => 'ge-0/0/34.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:65',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(482370940) 55 days, 19:55:09.40',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '177506',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1151895',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '559',
                        IFNAME           => 'ge-0/0/35',
                        IFDESCR          => 'ge-0/0/35',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:66',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(497161860) 57 days, 13:00:18.60',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '197802341',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1067397285',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '560',
                        IFNAME           => 'ge-0/0/35.0',
                        IFDESCR          => 'ge-0/0/35.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:66',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(497161860) 57 days, 13:00:18.60',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '55838',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '260824305',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '561',
                        IFNAME           => 'ge-0/0/36',
                        IFDESCR          => 'ge-0/0/36',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:67',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(472444770) 54 days, 16:20:47.70',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '58569',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '322841413',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '562',
                        IFNAME           => 'ge-0/0/36.0',
                        IFDESCR          => 'ge-0/0/36.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:67',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(472444770) 54 days, 16:20:47.70',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '4369',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '226777070',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '563',
                        IFNAME           => 'ge-0/0/37',
                        IFDESCR          => 'ge-0/0/37',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:68',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(483202680) 55 days, 22:13:46.80',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '664',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '57194403',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '564',
                        IFNAME           => 'ge-0/0/37.0',
                        IFDESCR          => 'ge-0/0/37.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:68',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(483202680) 55 days, 22:13:46.80',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '42744530',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '565',
                        IFNAME           => 'ge-0/0/38',
                        IFDESCR          => 'ge-0/0/38',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:69',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(481989430) 55 days, 18:51:34.30',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '37857253',
                        IFINERRORS       => '16',
                        IFOUTOCTETS      => '1175000865',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '566',
                        IFNAME           => 'ge-0/0/38.0',
                        IFDESCR          => 'ge-0/0/38.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:69',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(481989430) 55 days, 18:51:34.30',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '107050',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '327690167',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '567',
                        IFNAME           => 'ge-0/0/39',
                        IFDESCR          => 'ge-0/0/39',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:6a',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(83675374) 9 days, 16:25:53.74',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '52422417',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '568',
                        IFNAME           => 'ge-0/0/39.0',
                        IFDESCR          => 'ge-0/0/39.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:6a',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(83675374) 9 days, 16:25:53.74',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '54789340',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '569',
                        IFNAME           => 'ge-0/0/4',
                        IFDESCR          => 'ge-0/0/4',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:47',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(185623970) 21 days, 11:37:19.70',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '429906244',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '570',
                        IFNAME           => 'ge-0/0/4.0',
                        IFDESCR          => 'ge-0/0/4.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:47',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(185623970) 21 days, 11:37:19.70',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '327367176',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '571',
                        IFNAME           => 'ge-0/0/40',
                        IFDESCR          => 'ge-0/0/40',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:6b',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(488988670) 56 days, 14:18:06.70',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '56742623',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '675050738',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '572',
                        IFNAME           => 'ge-0/0/40.0',
                        IFDESCR          => 'ge-0/0/40.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:6b',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(488988670) 56 days, 14:18:06.70',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '59814',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '15085956',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '573',
                        IFNAME           => 'ge-0/0/41',
                        IFDESCR          => 'ge-0/0/41',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:6c',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5873) 0:00:58.73',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2126678145',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2508127997',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '574',
                        IFNAME           => 'ge-0/0/41.0',
                        IFDESCR          => 'ge-0/0/41.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:6c',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5873) 0:00:58.73',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '343650',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '329796027',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '575',
                        IFNAME           => 'ge-0/0/42',
                        IFDESCR          => 'ge-0/0/42',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:6d',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(496841100) 57 days, 12:06:51.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '136854405',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2940766281',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '576',
                        IFNAME           => 'ge-0/0/42.0',
                        IFDESCR          => 'ge-0/0/42.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:6d',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(496841100) 57 days, 12:06:51.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '438278',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '327882746',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '577',
                        IFNAME           => 'ge-0/0/43',
                        IFDESCR          => 'ge-0/0/43',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:6e',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2937) 0:00:29.37',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '578',
                        IFNAME           => 'ge-0/0/43.0',
                        IFDESCR          => 'ge-0/0/43.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:6e',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3054) 0:00:30.54',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '579',
                        IFNAME           => 'ge-0/0/44',
                        IFDESCR          => 'ge-0/0/44',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:6f',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(249013790) 28 days, 19:42:17.90',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '424387114',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '651547347',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '580',
                        IFNAME           => 'ge-0/0/44.0',
                        IFDESCR          => 'ge-0/0/44.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:6f',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(249013790) 28 days, 19:42:17.90',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '318728',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '328402257',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '581',
                        IFNAME           => 'ge-0/0/45',
                        IFDESCR          => 'ge-0/0/45',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:70',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(430521590) 49 days, 19:53:35.90',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '140623101',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '383297325',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '582',
                        IFNAME           => 'ge-0/0/45.0',
                        IFDESCR          => 'ge-0/0/45.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:70',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(430521590) 49 days, 19:53:35.90',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '379324',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '328414005',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '583',
                        IFNAME           => 'ge-0/0/46',
                        IFDESCR          => 'ge-0/0/46',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:71',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(481266820) 55 days, 16:51:08.20',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '88355',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '56337',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '584',
                        IFNAME           => 'ge-0/0/46.0',
                        IFDESCR          => 'ge-0/0/46.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:71',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(481266820) 55 days, 16:51:08.20',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '21424',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '29827',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '585',
                        IFNAME           => 'ge-0/0/47',
                        IFDESCR          => 'ge-0/0/47',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:72',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(482462235) 55 days, 20:10:22.35',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '522060',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '338107',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '586',
                        IFNAME           => 'ge-0/0/47.0',
                        IFDESCR          => 'ge-0/0/47.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:72',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(482462235) 55 days, 20:10:22.35',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '90347',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '142213',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '587',
                        IFNAME           => 'ge-0/0/5',
                        IFDESCR          => 'ge-0/0/5',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:48',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2623) 0:00:26.23',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '588',
                        IFNAME           => 'ge-0/0/5.0',
                        IFDESCR          => 'ge-0/0/5.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:48',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2629) 0:00:26.29',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '589',
                        IFNAME           => 'ge-0/0/6',
                        IFDESCR          => 'ge-0/0/6',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:49',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(481761753) 55 days, 18:13:37.53',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '486790886',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '362600196',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '590',
                        IFNAME           => 'ge-0/0/6.0',
                        IFDESCR          => 'ge-0/0/6.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:49',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(481761753) 55 days, 18:13:37.53',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '144582',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '208995379',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '591',
                        IFNAME           => 'ge-0/0/7',
                        IFDESCR          => 'ge-0/0/7',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:4a',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(489621221) 56 days, 16:03:32.21',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '719813169',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1043360413',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '592',
                        IFNAME           => 'ge-0/0/7.0',
                        IFDESCR          => 'ge-0/0/7.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:4a',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(489621221) 56 days, 16:03:32.21',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '488108',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '14646662',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '593',
                        IFNAME           => 'ge-0/0/8',
                        IFDESCR          => 'ge-0/0/8',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:4b',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2663) 0:00:26.63',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '594',
                        IFNAME           => 'ge-0/0/8.0',
                        IFDESCR          => 'ge-0/0/8.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:4b',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2671) 0:00:26.71',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '595',
                        IFNAME           => 'ge-0/0/9',
                        IFDESCR          => 'ge-0/0/9',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:4c',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(488302009) 56 days, 12:23:40.09',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3268629629',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1002264684',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '596',
                        IFNAME           => 'ge-0/0/9.0',
                        IFDESCR          => 'ge-0/0/9.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:4c',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(488302009) 56 days, 12:23:40.09',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3844613',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '338671560',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '599',
                        IFNAME           => 'vlan',
                        IFDESCR          => 'vlan',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1518',
                        MAC              => '78:fe:3d:35:14:41',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2443) 0:00:24.43',
                        IFINOCTETS       => '1417841504',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '60361330',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '600',
                        IFNAME           => 'ge-0/1/0',
                        IFDESCR          => 'ge-0/1/0',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:73',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5680) 0:00:56.80',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3462021619',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '763621010',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '601',
                        IFNAME           => 'ge-0/1/1',
                        IFDESCR          => 'ge-0/1/1',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:74',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5981) 0:00:59.81',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1756608694',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '188016786',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '604',
                        IFNAME           => 'vlan.0',
                        IFDESCR          => 'vlan.0',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '78:fe:3d:35:14:41',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2451) 0:00:24.51',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '605',
                        IFNAME           => 'ge-0/1/0.0',
                        IFDESCR          => 'ge-0/1/0.0',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:73',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5680) 0:00:56.80',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2462905321',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '117830992',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFNUMBER => '651',
                                IFDESCR  => 'ge-1/0/6.0',
                                SYSNAME  => 'jte4-00',
                                SYSDESCR => 'Juniper Networks, Inc. ex4500-40f , version 11.4R2.14 Build date: 2012-03-17 17:46:53 UTC ',
                                SYSMAC   => '78:fe:3d:df:c1:80',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '606',
                        IFNAME           => 'ge-0/1/1.0',
                        IFDESCR          => 'ge-0/1/1.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:74',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5981) 0:00:59.81',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '152003984',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '335449643',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFNUMBER => '602',
                                IFDESCR  => 'ge-0/1/0.0',
                                SYSNAME  => 'jtc13-04',
                                SYSDESCR => 'Juniper Networks, Inc. ex2200-48p-4g , version 11.4R5.7 Build date: 2013-01-05 12:28:58 UTC ',
                                SYSMAC   => 'b0:a8:6e:9a:55:c0',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '609',
                        IFNAME           => 'vlan.1',
                        IFDESCR          => 'vlan.1',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        IP               => '192.168.100.140',
                        MAC              => '78:fe:3d:35:14:41',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5696) 0:00:56.96',
                        IFINOCTETS       => '1417842056',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '55958584',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '610',
                        IFNAME           => 'ae0',
                        IFDESCR          => 'ae0',
                        IFTYPE           => '161',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:43',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2417) 0:00:24.17',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '611',
                        IFNAME           => 'ae1',
                        IFDESCR          => 'ae1',
                        IFTYPE           => '161',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:44',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2421) 0:00:24.21',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '612',
                        IFNAME           => 'ae2',
                        IFDESCR          => 'ae2',
                        IFTYPE           => '161',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:45',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2425) 0:00:24.25',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '613',
                        IFNAME           => 'ae3',
                        IFDESCR          => 'ae3',
                        IFTYPE           => '161',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:46',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2430) 0:00:24.30',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '614',
                        IFNAME           => 'ae4',
                        IFDESCR          => 'ae4',
                        IFTYPE           => '161',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:47',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2438) 0:00:24.38',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Juniper',
                TYPE         => 'NETWORKING',
                MODEL        => 'EX2200',
                COMMENTS     => 'Juniper Networks, Inc. ex2200-48p-4g internet router, kernel JUNOS 11.4R5.5 #0: 2012-08-25 05:21:13 UTC     builder@evenath.juniper.net:/volume/build/junos/11.4/release/11.4R5.5/obj-arm/bsd/kernels/JUNIPER-EX-2200/kernel Build date: 2012-08-25 04:48:47 U',
                NAME         => 'jtc13-03',
                MEMORY       => '0',
                LOCATION     => 'PMF 13eme',
                IPS          => {
                    IP => [
                        '128.0.0.1',
                        '128.0.0.16',
                        '128.0.0.32',
                        '192.168.100.140',
                    ],
                },
                MAC          => '78:fe:3d:35:14:41',
                UPTIME       => '(499476755) 57 days, 19:26:07.55',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '4',
                        IFNAME           => 'lsi',
                        IFDESCR          => 'lsi',
                        IFTYPE           => '150',
                        IFSPEED          => '0',
                        IFMTU            => '1496',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '5',
                        IFNAME           => 'dsc',
                        IFDESCR          => 'dsc',
                        IFTYPE           => '1',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2310) 0:00:23.10',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '6',
                        IFNAME           => 'lo0',
                        IFDESCR          => 'lo0',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2330) 0:00:23.30',
                        IFINOCTETS       => '2891947405',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2892532185',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '7',
                        IFNAME           => 'tap',
                        IFDESCR          => 'tap',
                        IFTYPE           => '1',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2337) 0:00:23.37',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '8',
                        IFNAME           => 'gre',
                        IFDESCR          => 'gre',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2317) 0:00:23.17',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '9',
                        IFNAME           => 'ipip',
                        IFDESCR          => 'ipip',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2324) 0:00:23.24',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10',
                        IFNAME           => 'pime',
                        IFDESCR          => 'pime',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2343) 0:00:23.43',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '11',
                        IFNAME           => 'pimd',
                        IFDESCR          => 'pimd',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2346) 0:00:23.46',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '12',
                        IFNAME           => 'mtun',
                        IFDESCR          => 'mtun',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2391) 0:00:23.91',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '33',
                        IFNAME           => 'me0',
                        IFDESCR          => 'me0',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:7f',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2357) 0:00:23.57',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '34',
                        IFNAME           => 'me0.0',
                        IFDESCR          => 'me0.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '78:fe:3d:35:14:7f',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2373) 0:00:23.73',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '37',
                        IFNAME           => 'bme0',
                        IFDESCR          => 'bme0',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1576',
                        MAC              => '00:0b:ca:fe:00:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2302) 0:00:23.02',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2324005029',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '38',
                        IFNAME           => 'bme0.32768',
                        IFDESCR          => 'bme0.32768',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1562',
                        IP               => '128.0.0.32',
                        MAC              => '00:0b:ca:fe:00:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2394) 0:00:23.94',
                        IFINOCTETS       => '112538765',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '126',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '501',
                        IFNAME           => 'ge-0/0/0',
                        IFDESCR          => 'ge-0/0/0',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:43',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(83323040) 9 days, 15:27:10.40',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1744384224',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '338781511',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '502',
                        IFNAME           => 'ge-0/0/0.0',
                        IFDESCR          => 'ge-0/0/0.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:43',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(83323040) 9 days, 15:27:10.40',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2557466',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '56896598',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '503',
                        IFNAME           => 'ge-0/0/1',
                        IFDESCR          => 'ge-0/0/1',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:44',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(490874463) 56 days, 19:32:24.63',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '81139766',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '650360168',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '504',
                        IFNAME           => 'ge-0/0/1.0',
                        IFDESCR          => 'ge-0/0/1.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:44',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(490874463) 56 days, 19:32:24.63',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '212731',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '287926476',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '505',
                        IFNAME           => 'ge-0/0/10',
                        IFDESCR          => 'ge-0/0/10',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:4d',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(472291924) 54 days, 15:55:19.24',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '35529',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '39114',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '506',
                        IFNAME           => 'ge-0/0/10.0',
                        IFDESCR          => 'ge-0/0/10.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:4d',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(472291924) 54 days, 15:55:19.24',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '6838',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '22750',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '507',
                        IFNAME           => 'ge-0/0/11',
                        IFDESCR          => 'ge-0/0/11',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:4e',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(492159839) 56 days, 23:06:38.39',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '674968419',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1597370852',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '508',
                        IFNAME           => 'ge-0/0/11.0',
                        IFDESCR          => 'ge-0/0/11.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:4e',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(492159839) 56 days, 23:06:38.39',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2239067',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '12578934',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '509',
                        IFNAME           => 'ge-0/0/12',
                        IFDESCR          => 'ge-0/0/12',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:4f',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2728) 0:00:27.28',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '510',
                        IFNAME           => 'ge-0/0/12.0',
                        IFDESCR          => 'ge-0/0/12.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:4f',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2733) 0:00:27.33',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '511',
                        IFNAME           => 'ge-0/0/13',
                        IFDESCR          => 'ge-0/0/13',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:50',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(474504079) 54 days, 22:04:00.79',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '305790865',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '335531496',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '512',
                        IFNAME           => 'ge-0/0/13.0',
                        IFDESCR          => 'ge-0/0/13.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:50',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(474504079) 54 days, 22:04:00.79',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '814511',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '6868262',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '513',
                        IFNAME           => 'ge-0/0/14',
                        IFDESCR          => 'ge-0/0/14',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:51',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(472607150) 54 days, 16:47:51.50',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '706240582',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1981564306',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '514',
                        IFNAME           => 'ge-0/0/14.0',
                        IFDESCR          => 'ge-0/0/14.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:51',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(472607150) 54 days, 16:47:51.50',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2684663',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '305745401',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '515',
                        IFNAME           => 'ge-0/0/15',
                        IFDESCR          => 'ge-0/0/15',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:52',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(58579375) 6 days, 18:43:13.75',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '7474192',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '28526957',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '516',
                        IFNAME           => 'ge-0/0/15.0',
                        IFDESCR          => 'ge-0/0/15.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:52',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(58579375) 6 days, 18:43:13.75',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '58650',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '296261',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '517',
                        IFNAME           => 'ge-0/0/16',
                        IFDESCR          => 'ge-0/0/16',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:53',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(58586022) 6 days, 18:44:20.22',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2444780',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '50242056',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '518',
                        IFNAME           => 'ge-0/0/16.0',
                        IFDESCR          => 'ge-0/0/16.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:53',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(58586022) 6 days, 18:44:20.22',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '9576',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '38422452',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '519',
                        IFNAME           => 'ge-0/0/17',
                        IFDESCR          => 'ge-0/0/17',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:54',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2776) 0:00:27.76',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '520',
                        IFNAME           => 'ge-0/0/17.0',
                        IFDESCR          => 'ge-0/0/17.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:54',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2780) 0:00:27.80',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '521',
                        IFNAME           => 'ge-0/0/18',
                        IFDESCR          => 'ge-0/0/18',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:55',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(491424998) 56 days, 21:04:09.98',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '738137413',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '34484781',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '522',
                        IFNAME           => 'ge-0/0/18.0',
                        IFDESCR          => 'ge-0/0/18.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:55',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(491424998) 56 days, 21:04:09.98',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '227863',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '17397782',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '523',
                        IFNAME           => 'ge-0/0/19',
                        IFDESCR          => 'ge-0/0/19',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:56',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(474866627) 54 days, 23:04:26.27',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1235150564',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '854199719',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '524',
                        IFNAME           => 'ge-0/0/19.0',
                        IFDESCR          => 'ge-0/0/19.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:56',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(474866627) 54 days, 23:04:26.27',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1689222',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '40410472',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '525',
                        IFNAME           => 'ge-0/0/2',
                        IFDESCR          => 'ge-0/0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:45',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5910) 0:00:59.10',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1286810852',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '625722619',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '526',
                        IFNAME           => 'ge-0/0/2.0',
                        IFDESCR          => 'ge-0/0/2.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:45',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5910) 0:00:59.10',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2927955',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '327508850',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '527',
                        IFNAME           => 'ge-0/0/20',
                        IFDESCR          => 'ge-0/0/20',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:57',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2803) 0:00:28.03',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '528',
                        IFNAME           => 'ge-0/0/20.0',
                        IFDESCR          => 'ge-0/0/20.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:57',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2814) 0:00:28.14',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '529',
                        IFNAME           => 'ge-0/0/21',
                        IFDESCR          => 'ge-0/0/21',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:58',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2810) 0:00:28.10',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '530',
                        IFNAME           => 'ge-0/0/21.0',
                        IFDESCR          => 'ge-0/0/21.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:58',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2819) 0:00:28.19',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '531',
                        IFNAME           => 'ge-0/0/22',
                        IFDESCR          => 'ge-0/0/22',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:59',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(482826811) 55 days, 21:11:08.11',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '931159501',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2326041633',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '532',
                        IFNAME           => 'ge-0/0/22.0',
                        IFDESCR          => 'ge-0/0/22.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:59',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(482826811) 55 days, 21:11:08.11',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1428463',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '6920069',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '533',
                        IFNAME           => 'ge-0/0/23',
                        IFDESCR          => 'ge-0/0/23',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:5a',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2825) 0:00:28.25',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '534',
                        IFNAME           => 'ge-0/0/23.0',
                        IFDESCR          => 'ge-0/0/23.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:5a',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2849) 0:00:28.49',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '535',
                        IFNAME           => 'ge-0/0/24',
                        IFDESCR          => 'ge-0/0/24',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:5b',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(410512310) 47 days, 12:18:43.10',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3299641',
                        IFINERRORS       => '21',
                        IFOUTOCTETS      => '558181286',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '536',
                        IFNAME           => 'ge-0/0/24.0',
                        IFDESCR          => 'ge-0/0/24.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:5b',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(410512310) 47 days, 12:18:43.10',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2047',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '327656344',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '537',
                        IFNAME           => 'ge-0/0/25',
                        IFDESCR          => 'ge-0/0/25',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:5c',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(482930025) 55 days, 21:28:20.25',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '282999027',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3232568305',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '538',
                        IFNAME           => 'ge-0/0/25.0',
                        IFDESCR          => 'ge-0/0/25.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:5c',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(482930025) 55 days, 21:28:20.25',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '421384',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '19049883',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '539',
                        IFNAME           => 'ge-0/0/26',
                        IFDESCR          => 'ge-0/0/26',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:5d',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(480571640) 55 days, 14:55:16.40',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '433766676',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1449823136',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '540',
                        IFNAME           => 'ge-0/0/26.0',
                        IFDESCR          => 'ge-0/0/26.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:5d',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(480571640) 55 days, 14:55:16.40',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '553601',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '12043513',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '541',
                        IFNAME           => 'ge-0/0/27',
                        IFDESCR          => 'ge-0/0/27',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:5e',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(498384383) 57 days, 16:24:03.83',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '709592546',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2039323682',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '542',
                        IFNAME           => 'ge-0/0/27.0',
                        IFDESCR          => 'ge-0/0/27.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:5e',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(498384383) 57 days, 16:24:03.83',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '536134',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '284310206',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '543',
                        IFNAME           => 'ge-0/0/28',
                        IFDESCR          => 'ge-0/0/28',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:5f',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2853) 0:00:28.53',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '544',
                        IFNAME           => 'ge-0/0/28.0',
                        IFDESCR          => 'ge-0/0/28.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:5f',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2926) 0:00:29.26',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '545',
                        IFNAME           => 'ge-0/0/29',
                        IFDESCR          => 'ge-0/0/29',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:60',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(481571980) 55 days, 17:41:59.80',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '5303509',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '476264161',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '546',
                        IFNAME           => 'ge-0/0/29.0',
                        IFDESCR          => 'ge-0/0/29.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:60',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(481571980) 55 days, 17:41:59.80',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '5400',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '327586683',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '547',
                        IFNAME           => 'ge-0/0/3',
                        IFDESCR          => 'ge-0/0/3',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:46',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2560) 0:00:25.60',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '548',
                        IFNAME           => 'ge-0/0/3.0',
                        IFDESCR          => 'ge-0/0/3.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:46',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2574) 0:00:25.74',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '549',
                        IFNAME           => 'ge-0/0/30',
                        IFDESCR          => 'ge-0/0/30',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(498168960) 57 days, 15:48:09.60',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3168553434',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1575972079',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '550',
                        IFNAME           => 'ge-0/0/30.0',
                        IFDESCR          => 'ge-0/0/30.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(498168960) 57 days, 15:48:09.60',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '357238',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '330356904',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '551',
                        IFNAME           => 'ge-0/0/31',
                        IFDESCR          => 'ge-0/0/31',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:62',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5820) 0:00:58.20',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2168289414',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2998024565',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '552',
                        IFNAME           => 'ge-0/0/31.0',
                        IFDESCR          => 'ge-0/0/31.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:62',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5820) 0:00:58.20',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '276480',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '328409671',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '553',
                        IFNAME           => 'ge-0/0/32',
                        IFDESCR          => 'ge-0/0/32',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:63',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(498885870) 57 days, 17:47:38.70',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '227158483',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1931125831',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '554',
                        IFNAME           => 'ge-0/0/32.0',
                        IFDESCR          => 'ge-0/0/32.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:63',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(498885870) 57 days, 17:47:38.70',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '827296',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '13180849',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '555',
                        IFNAME           => 'ge-0/0/33',
                        IFDESCR          => 'ge-0/0/33',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:64',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(496811760) 57 days, 12:01:57.60',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1446896777',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '135042718',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '556',
                        IFNAME           => 'ge-0/0/33.0',
                        IFDESCR          => 'ge-0/0/33.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:64',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(496811760) 57 days, 12:01:57.60',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '5714913',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '32163624',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '557',
                        IFNAME           => 'ge-0/0/34',
                        IFDESCR          => 'ge-0/0/34',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:65',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(482370940) 55 days, 19:55:09.40',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '26151636',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1568180907',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '558',
                        IFNAME           => 'ge-0/0/34.0',
                        IFDESCR          => 'ge-0/0/34.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:65',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(482370940) 55 days, 19:55:09.40',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '177506',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1151895',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '559',
                        IFNAME           => 'ge-0/0/35',
                        IFDESCR          => 'ge-0/0/35',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:66',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(497161860) 57 days, 13:00:18.60',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '197802341',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1067397285',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '560',
                        IFNAME           => 'ge-0/0/35.0',
                        IFDESCR          => 'ge-0/0/35.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:66',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(497161860) 57 days, 13:00:18.60',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '55838',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '260824305',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '561',
                        IFNAME           => 'ge-0/0/36',
                        IFDESCR          => 'ge-0/0/36',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:67',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(472444770) 54 days, 16:20:47.70',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '58569',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '322841413',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '562',
                        IFNAME           => 'ge-0/0/36.0',
                        IFDESCR          => 'ge-0/0/36.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:67',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(472444770) 54 days, 16:20:47.70',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '4369',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '226777070',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '563',
                        IFNAME           => 'ge-0/0/37',
                        IFDESCR          => 'ge-0/0/37',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:68',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(483202680) 55 days, 22:13:46.80',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '664',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '57194403',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '564',
                        IFNAME           => 'ge-0/0/37.0',
                        IFDESCR          => 'ge-0/0/37.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:68',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(483202680) 55 days, 22:13:46.80',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '42744530',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '565',
                        IFNAME           => 'ge-0/0/38',
                        IFDESCR          => 'ge-0/0/38',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:69',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(481989430) 55 days, 18:51:34.30',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '37857253',
                        IFINERRORS       => '16',
                        IFOUTOCTETS      => '1175000865',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '566',
                        IFNAME           => 'ge-0/0/38.0',
                        IFDESCR          => 'ge-0/0/38.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:69',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(481989430) 55 days, 18:51:34.30',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '107050',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '327690167',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '567',
                        IFNAME           => 'ge-0/0/39',
                        IFDESCR          => 'ge-0/0/39',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:6a',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(83675374) 9 days, 16:25:53.74',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '52422417',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '568',
                        IFNAME           => 'ge-0/0/39.0',
                        IFDESCR          => 'ge-0/0/39.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:6a',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(83675374) 9 days, 16:25:53.74',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '54789340',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '569',
                        IFNAME           => 'ge-0/0/4',
                        IFDESCR          => 'ge-0/0/4',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:47',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(185623970) 21 days, 11:37:19.70',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '429906244',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '570',
                        IFNAME           => 'ge-0/0/4.0',
                        IFDESCR          => 'ge-0/0/4.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:47',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(185623970) 21 days, 11:37:19.70',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '327367176',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '571',
                        IFNAME           => 'ge-0/0/40',
                        IFDESCR          => 'ge-0/0/40',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:6b',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(488988670) 56 days, 14:18:06.70',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '56742623',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '675050738',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '572',
                        IFNAME           => 'ge-0/0/40.0',
                        IFDESCR          => 'ge-0/0/40.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:6b',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(488988670) 56 days, 14:18:06.70',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '59814',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '15085956',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '573',
                        IFNAME           => 'ge-0/0/41',
                        IFDESCR          => 'ge-0/0/41',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:6c',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5873) 0:00:58.73',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2126678145',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2508127997',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '574',
                        IFNAME           => 'ge-0/0/41.0',
                        IFDESCR          => 'ge-0/0/41.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:6c',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5873) 0:00:58.73',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '343650',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '329796027',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '575',
                        IFNAME           => 'ge-0/0/42',
                        IFDESCR          => 'ge-0/0/42',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:6d',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(496841100) 57 days, 12:06:51.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '136854405',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2940766281',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '576',
                        IFNAME           => 'ge-0/0/42.0',
                        IFDESCR          => 'ge-0/0/42.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:6d',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(496841100) 57 days, 12:06:51.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '438278',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '327882746',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '577',
                        IFNAME           => 'ge-0/0/43',
                        IFDESCR          => 'ge-0/0/43',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:6e',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2937) 0:00:29.37',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '578',
                        IFNAME           => 'ge-0/0/43.0',
                        IFDESCR          => 'ge-0/0/43.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:6e',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3054) 0:00:30.54',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
     