package Daje::Document::Templates::Tools::Generate::Perl;
use Mojo::Base 'Daje::Document::Templates::Base', -base;
use v5.42;

# NAME
# ====
#
# Daje::Templates::Tools::Generate::Perl; - It creates perl code
#
# SYNOPSIS
# ========
#
#     use Daje::Templates::Tools::Generate::Perl;
#
#     Provides a method for the template to be loaded into the data structure
#
#     sub length_default_calc($self) returns a sub for setting details in template.
#
#
# DESCRIPTION
# ===========
#
# Daje::Templates::Tools::Generate::Perl; is a module that retrieves data from a View
#
# LICENSE
# =======
#
# Copyright (C) janeskil1525.
#
# This library is free software; you can redistribute it and/or modify
# it under the same terms as Perl itself.
#
# AUTHOR
# ======
#
# janeskil1525 E<lt>janeskil1525@gmail.comE<gt>
#

sub set_subs($self) {
    $self->subs('');
}

1;

__DATA__
@@ tests_controller

use v5.42;
use strict;
use Test::More 0.98;

# <!-- Autogenerated file [%- date_time %] -->

use_ok $_ for qw(
    Daje::Controller::[% class_name %]
);

done_testing;
1;

@@ tests_database_model

use v5.42;
use strict;
use Test::More 0.98;

# <!-- Autogenerated file [%- date_time %] -->

use_ok $_ for qw(
    Daje::Database::Model::[% class_name %]
);

done_testing;
1;

@@ controller

package Daje::Controller::[%- class_name %];
use Mojo::Base 'Daje::Controller::Super::[%- class_name -%]', -base, -signatures;
use v5.42;

# NAME
# ====
#
# Daje::Controller::[%- class_name -%] - Model class
#
# SYNOPSIS
# ========
#
#       use Daje::Controller::[%- class_name %]
#
#
#
# DESCRIPTION
# ===========
#
# Daje::Controller::[%- class_name -%] is a standard controller
#
# METHODS
# =======
#
#
# LICENSE
# =======
#
# Copyright (C) janeskil1525.
#
# This library is free software; you can redistribute it and/or modify
# it under the same terms as Perl itself.
#
# AUTHOR
# ======
#
# janeskil1525 E<lt>janeskil1525@gmail.com
#

# This file is generated automatically by Daje Tools [% date_time %].
# It will not be re-generated by Daje Tools again.
# <!-- Autogenerated file [%- date_time %] -->

our $VERSION = '0.01';

1;

@@ super_controller

package Daje::Controller::Super::[%- class_name %];
use Mojo::Base 'Mojolicious::Controller', -base, -signatures;
use v5.42;

# NAME
# ====
#
# Daje::Controller::Super::[%- class_name -%] - Model class
#
# SYNOPSIS
# ========
#
#       use Daje::Controller::Super::[%- class_name -%]
#
       [%- FOREACH table IN tables %]
#       $r->get('/[%- project_name -%]/api/v1/[%- table.table_name -%]/:[%- project_name -%]_[%- table.table_name %]_pkey');
       [%- FOREACH field IN table.fields %]
       [%- IF field.foreign_key %]
#       $r->get('/[%- project_name -%]/api/v1/[%- table.table_name -%]_[%- field.fieldname -%]/:[%- project_name -%]_[%- field.fieldname %]_fkey');

       [% END %]
       [%- END -%]
       [%- END -%]
#
#
# DESCRIPTION
# ===========
#
# Daje::Controller::Super::[%- class_name -%] is a standard controller
#
# METHODS
# =======
#
#
# LICENSE
# =======
#
# Copyright (C) janeskil1525.
#
# This library is free software; you can redistribute it and/or modify
# it under the same terms as Perl itself.
#
# AUTHOR
# ======
#
# janeskil1525 E<lt>janeskil1525@gmail.com
#
# This file is generated automatically by Daje Tools [% date_time %].
# It will be re-generated by Daje Tools again.
# <!-- Autogenerated file [%- date_time %] -->

our $VERSION = '0.01';

sub load_[%- project_name -%]_[%- table.table_name -%]_pkey($self) {
    $self->app->log->debug('Daje::Controller::Super::[%- class_name -%]::load_[%- project_name -%]_[%- field.fieldname -%]_fkey ');
    $self->render_later;
    my ($companies_pkey, $users_pkey) = $self->jwt->companies_users_pkey(
         $self->req->headers->header('X-Token-Check')
    );
    my $pkey = $self->param('[%- project_name -%]_[%- table.table_name -%]_pkey');

    $self->app->log->debug($self->req->headers->header('X-Token-Check'));
    # my $setting = $self->param('setting');
    $self->[%- project_name -%]_[% table.table_name %]->load_[%- project_name -%]_[%- table.table_name -%]_pkey_p($pkey)->then(sub($result) {
        $self->render(json => $result->{data});
    })->catch(sub($err) {
        $self->app->log->error('Daje::Controller::Super::[%- class_name -%]::load_[%- project_name -%]_[%- table.table_name -%]_pkey ' . $err);
        $self->render
    });
}

[%- FOREACH field IN fields -%]
[%- IF field.foreign_key -%]
sub load_[%- project_name -%]_[%- field.fieldname -%]_fkey($self) {
    $self->app->log->debug('Daje::Controller::Super::[%- class_name -%]::load_[%- project_name -%]_[%- field.fieldname -%]_fkey ');
    $self->render_later;
    my ($companies_pkey, $users_pkey) = $self->jwt->companies_users_pkey(
         $self->req->headers->header('X-Token-Check')
    );
    my $fkey = $self->param('[%- project_name -%]_[%- field.fieldname -%]_fkey');

    $self->app->log->debug($self->req->headers->header('X-Token-Check'));
    # my $setting = $self->param('setting');
    $self->[%- project_name -%]_[% tablename %]->[%- project_name -%]_[%- field.fieldname -%]_fkey_p($fkey)->then(sub($result) {
        $self->render(json => $result->{data});
    })->catch(sub($err) {
        $self->app->log->error('Daje::Controller::Super::[%- class_name -%]::load_[%- project_name -%]_[%- field.fieldname -%]_fkey ' . $err);
        $self->render
    });
}
[%- END -%]
[%- END -%]

1;

@@ helpers

package Daje::Plugin::[%- class_name -%]::Helpers;
use Mojo::Base -base, -signatures;
use v5.42;

# NAME
# ====
#
# Daje::Plugin::[%- class_name -%]::Helpers - Model class
#
# SYNOPSIS
# ========
#
#       use Daje::Plugin::[%- class_name -%]::Helpers;
#
#       my $class = Daje::Plugin::[%- class_name -%]::Helpers->new();
[%- FOREACH table IN tables %]
#       $app->helper(
#           [% project_name %]_[% table.table_name %] => sub {
#               state  $[% project_name %]_[% table.table_name %] = Daje::Database::Model::[%- table.class_name -%]->new(db => shift->pg->db)
#        });
[%- END -%]
#
#
# DESCRIPTION
# ===========
#
# Daje::Plugin::[%- class_name -%]::Routes is the standard routes
#
# METHODS
# =======
#
#
# LICENSE
# =======
#
# Copyright (C) janeskil1525.
#
# This library is free software; you can redistribute it and/or modify
# it under the same terms as Perl itself.
#
# AUTHOR
# ======
#
# janeskil1525 E<lt>janeskil1525@gmail.com
#

# This file is generated automatically by Daje Tools [% date_time %].
# It will be re-generated by Daje Tools again.
# <!-- Autogenerated file [%- date_time %] -->

our $VERSION = '0.01';

sub helpers($self, $app, $config) {

    [%- FOREACH table IN tables %]
    $app->helper(
        [% project_name %]_[% table.table_name %] => sub {
            state  $[% project_name %]_[% table.table_name %] = Daje::Database::Model::[%- table.class_name -%]->new(db => shift->pg->db)
        });
    [%- END -%]

}

1;
@@ routes

package Daje::Plugin::[%- class_name -%]::Routes;
use Mojo::Base -base, -signatures;
use v5.42;

# NAME
# ====
#
# Daje::Plugin::[%- class_name -%]::Routes - Model class
#
# SYNOPSIS
# ========
#
#       use Daje::Plugin::[%- class_name -%]::Routes;
#
#       my $class = Daje::Plugin::[%- class_name -%]::Routes->new();
       [%- FOREACH table IN tables %]
#       $r->get('/[%- project_name -%]/api/v1/[%- table.table_name -%]/:[%- project_name -%]_[%- table.table_name %]_pkey');
       [%- FOREACH field IN table.fields %]
       [%- IF field.foreign_key %]
#       $r->get('/[%- project_name -%]/api/v1/[%- table.table_name -%]_[%- field.fieldname -%]/:[%- project_name -%]_[%- field.fieldname %]_fkey');

       [% END %]
       [%- END -%]
       [%- END -%]
#
#
# DESCRIPTION
# ===========
#
# Daje::Plugin::[%- class_name -%]::Routes is the standard routes
#
# METHODS
# =======
#
#
# LICENSE
# =======
#
# Copyright (C) janeskil1525.
#
# This library is free software; you can redistribute it and/or modify
# it under the same terms as Perl itself.
#
# AUTHOR
# ======
#
# janeskil1525 E<lt>janeskil1525@gmail.com
#

# This file is generated automatically by Daje Tools [% date_time %].
# It will be generated by Daje Tools again.
# <!-- Autogenerated file [%- date_time %] -->

our $VERSION = '0.01';

sub routes($self, $app, $config) {
    my $r = $app->routes;
    [%- FOREACH table IN tables %]
    $r->get('/[%- project_name -%]/api/v1/[%- table.table_name -%]/:[%- project_name -%]_[%- table.table_name -%]_pkey')->to('[%- table.class_name -%]#[%- project_name -%]_[%- table.table_name -%]_pkey');
    [%- FOREACH field IN table.fields %]
    [%- IF field.foreign_key %]
    $r->get('/[%- project_name -%]/api/v1/[%- table.table_name -%]_[%- field.fieldname -%]/:[%- project_name -%]_[%- field.fieldname -%]_fkey')->to('[%- table.class_name -%]#load_[%- project_name -%]_[%- field.fieldname -%]_fkey');
    [%- END -%]
    [%- END -%]
    [%- END %]
}

@@ db_model

package Daje::Database::Model::[%- class_name -%];
use Mojo::Base 'Daje::Database::Model::Super::[%- class_name -%]', -base, -async_await, -signatures;
use v5.42;

# NAME
# ====
#
# Daje::Database::Model::[%- class_name -%] - Model class
#
# SYNOPSIS
# ========
#
#       use Daje::Database::Model::[%- class_name %];
#
#       my $class = Daje::Database::Model::[%- class_name -%]->new(db => $db);
#
# DESCRIPTION
# ===========
#
# Daje::Database::Model::[%- class_name -%] is the model
#
# class that's only generated once. It inherits all
#
# methods from Daje::Database::Model::Super::[%- class_name -%]
#
# This class is meant for non standard methods.
#
# METHODS
# =======
#
#
# LICENSE
# =======
#
# Copyright (C) janeskil1525.
#
# This library is free software; you can redistribute it and/or modify
# it under the same terms as Perl itself.
#
# AUTHOR
# ======
#
# janeskil1525 E<lt>janeskil1525@gmail.com
#

# This file is generated once automatically by Daje Tools [% date_time %].
# It will not be touched by Daje Tools again.
# <!-- Autogenerated file [%- date_time %] -->


our $VERSION = '0.01';

1;
@@ db_model_super

package Daje::Database::Model::Super::[%- class_name -%];
use Mojo::Base 'Daje::Database::Model::Super::Common::Base', -base, -signatures, -async_await;
use v5.42;

# NAME
# ====
#
# Daje::Database::Model::Super::[%- class_name -%] - Daje db model
#
# SYNOPSIS
# ========
#
#
#       use Daje::Database::Model::Super::[%- class_name -%];
#
#       my $table = Daje::Database::Model::Super::[%- class_name -%]->new(db => $db);
#
#       my $result = $table->load_[%- project_name -%]_[%- table.table_name -%]_pkey($self, $[%- project_name -%]_[%- table.table_name -%]_pkey);
#
[%- FOREACH field IN fields -%]
[%- IF field.foreign_key %]
#       my $result = $table->load_[%- project_name -%]_[%- field.fieldname -%]_fkey($self, $[%- project_name -%]_[%- field.fieldname -%]_fkey);
#
[%- END -%]
[%- END -%]
#
#       my $result = $table->insert($self, $data);
#
#       $table->update($self, $data) ;
#
#
# DESCRIPTION
# ===========
#
# Daje::Database::Model::Super::[%- class_name -%] is a Model super class
#
# METHODS
# =======
#
#
# LICENSE
# =======
#
# Copyright (C) janeskil1525.
#
# This library is free software; you can redistribute it and/or modify
# it under the same terms as Perl itself.
#
# AUTHOR
# ======
#
# janeskil1525 E<lt>janeskil1525@gmail.com
#

# This file is generated automatically by Daje Tools [% date_time %].
# It will be re-created by Daje Tools again and any changes
# will be over written.
#
# <!-- Autogenerated file [%- date_time %] -->

our $VERSION = '0.01';

has 'fields' => '"[%- project_name -%]_[%- table.table_name -%]_pkey", "editnum", "insby", "insdatetime", "modby", "moddatetime",
[%- FOREACH field IN fields -%]
[%- IF field.foreign_key %]
"[%- project_name -%]_[%- field.fieldname %]_fkey"[% "," IF loop.last() == 0 %]
[%- ELSE -%]
"[%- field.fieldname %]"[% "," IF loop.last() == 0 %]
[%- END -%]
[%- END -%]';
has 'primary_key_name' => "[%- project_name -%]_[%- table.table_name -%]_pkey";
has 'table_name' => "[%- project_name -%]_[%- table.table_name -%]";
has 'mandatory' => '[%- FOREACH field IN fields -%]
[%- IF field.foreign_key && field.mandatory -%]
"[%- project_name -%]_[%- field.fieldname -%]_fkey",
[%- ELSIF field.mandatory -%]
"[%- field.fieldname -%]",
[%- END -%]
[%- END -%]';

[%- FOREACH field IN fields -%]
[%- IF field.foreign_key %]
async sub load_[%- project_name -%]_[%- field.fieldname -%]_fkey_p($self, $[%- project_name -%]_[%- field.fieldname -%]_fkey) {
    return $self->load_[%- project_name -%]_[%- field.fieldname -%]_fkey($[%- project_name -%]_[%- field.fieldname -%]_fkey);
}

sub load_[%- project_name -%]_[%- field.fieldname -%]_fkey($self, $[%- project_name -%]_[%- field.fieldname -%]_fkey) {
    return $self->load_fkey(
        $self->table_name, $self->fields(), "[%- project_name -%]_[%- field.fieldname -%]_fkey", $[%- project_name -%]_[%- field.fieldname -%]_fkey
    );
}
[%- END -%]
[%- END -%]

async sub load_[%- project_name -%]_[%- table.table_name -%]_pkey_p($self, $[%- project_name -%]_[%- table.table_name -%]_pkey) {
    return $self->load_[%- project_name -%]_[%- table.table_name -%]_pkey($[%- project_name -%]_[%- table.table_name -%]_pkey);
}

sub load_[%- project_name -%]_[%- table.table_name -%]_pkey($self, $[%- project_name -%]_[%- table.table_name -%]_pkey) {
    return $self->load_pk(
        $self->table_name, $self->fields(), $self->primary_key_name(), $[%- project_name -%]_[%- table.table_name -%]_pkey
    );
}

sub insert($self, $data) {
    my $result = $self->SUPER::insert(
        $self->table_name, $data, $self->primary_key_name
    );
    return $result;
}

sub update($self, $data) {
    return $self->SUPER::update
    (
        $self->table_name, $data,
            {
                $self->primary_key_name() => $data->{$self->primary_key_name()}
            }
    );
}

sub delete($self, $data) {
    return $self->SUPER::delete(
        $self->table_name,
            {
                $self->primary_key_name() => $data->{$self->primary_key_name()}
            }
     );
}
1;

@@ plugin

package Daje::Plugin::[% plugin_name %];
use Mojo::Base 'Mojolicious::Plugin', -base, -signatures;
use v5.42;

# NAME
# ====
#
# Daje::Plugin::[% plugin_name %] - Mojolicious Plugin
#
# SYNOPSIS
# ========
#
# Mojolicious
# ===========
#
#      $self->plugin('[% plugin_name %]');
#
# Mojolicious::Lite
# =================
#
#      plugin '[% plugin_name %]';
#
# DESCRIPTION
# ===========
#
# Daje::Plugin::[% plugin_name %] is a Mojolicious plugin.
#
# METHODS
# =======
#
# Daje::Plugin::[% plugin_name %] inherits all methods from
# Mojolicious::Plugin and implements the following new ones.
#
# register
# ========
#  $plugin->register(Mojolicious->new);
#
# Register plugin in L<Mojolicious> application.
#
# SEE ALSO
# ========
#
# Mojolicious, Mojolicious::Guides, https://mojolicious.org.
#
# LICENSE
# =======
#
# Copyright (C) janeskil1525.
#
# This library is free software; you can redistribute it and/or modify
# it under the same terms as Perl itself.
#
# AUTHOR
# ======
#
# janeskil1525 E<lt>janeskil1525@gmail.com
#

# This file is generated once automatically by Daje Tools [% date_time %].
# It will not be touched by Daje Tools again.

# <!-- Autogenerated file [%- date_time %] -->

use Daje::Plugin::[% plugin_name %]::Routes;
use Daje::Plugin::[% plugin_name %]::Helpers;

our $VERSION = '0.01';

sub register ($self, $app, $config) {
    $app->log->debug("Daje::Plugin::[% plugin_name %]::register start");

    Daje::Plugin::[% plugin_name %]::Routes->new()->routes($app, $config);
    Daje::Plugin::[% plugin_name %]::Helpers->new()->helpers($app, $config);


    $app->log->debug("Daje::Plugin::[% plugin_name %]::register ends");
}

1;


