package IO::K8s::Api::Discovery::V1::EndpointSlice;
# ABSTRACT: EndpointSlice represents a subset of the endpoints that implement a service. For a given service there may be multiple EndpointSlice objects, selected by labels, which must be joined to produce the full set of endpoints.
our $VERSION = '1.000';
use IO::K8s::APIObject;
with 'IO::K8s::Role::Namespaced';


k8s addressType => Str, 'required';


k8s endpoints => ['Discovery::V1::Endpoint'], 'required';


k8s ports => ['Discovery::V1::EndpointPort'];

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

IO::K8s::Api::Discovery::V1::EndpointSlice - EndpointSlice represents a subset of the endpoints that implement a service. For a given service there may be multiple EndpointSlice objects, selected by labels, which must be joined to produce the full set of endpoints.

=head1 VERSION

version 1.000

=head1 DESCRIPTION

EndpointSlice represents a subset of the endpoints that implement a service. For a given service there may be multiple EndpointSlice objects, selected by labels, which must be joined to produce the full set of endpoints.

This is a Kubernetes API object. See L<IO::K8s::Role::APIObject> for
C<metadata>, C<api_version()>, and C<kind()>.

=head2 addressType

addressType specifies the type of address carried by this EndpointSlice. All addresses in this slice must be the same type. This field is immutable after creation. The following address types are currently supported: * IPv4: Represents an IPv4 Address. * IPv6: Represents an IPv6 Address. * FQDN: Represents a Fully Qualified Domain Name.

=head2 endpoints

endpoints is a list of unique endpoints in this slice. Each slice may include a maximum of 1000 endpoints.

=head2 ports

ports specifies the list of network ports exposed by each endpoint in this slice. Each port must have a unique name. When ports is empty, it indicates that there are no defined ports. When a port is defined with a nil port value, it indicates "all ports". Each slice may include a maximum of 100 ports.

=head1 SEE ALSO

L<https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.31/#endpointslice-v1-discovery.k8s.io>

=head1 SUPPORT

=head2 Issues

Please report bugs and feature requests on GitHub at
L<https://github.com/pplu/io-k8s-p5/issues>.

=head2 IRC

Join C<#kubernetes> on C<irc.perl.org> or message Getty directly.

=head1 CONTRIBUTING

Contributions are welcome! Please fork the repository and submit a pull request.

=head1 AUTHORS

=over 4

=item *

Torsten Raudssus <torsten@raudssus.de>

=item *

Jose Luis Martinez <jlmartinez@capside.com> (original author, inactive)

=back

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2018 by CAPSiDE.

This is free software, licensed under:

  The Apache License, Version 2.0, January 2004

=cut
