# This Makefile.PL for Perl-Critic-PJCJ was generated by
# Dist::Zilla::Plugin::MakeMaker::Awesome 0.49.
# Don't edit it but the dist.ini and plugins used to construct it.

use strict;
use warnings;

use ExtUtils::MakeMaker;

my %WriteMakefileArgs = (
  "ABSTRACT" => "Perl::Critic policies for code style consistency",
  "AUTHOR" => "Paul Johnson <paul\@pjcj.net>",
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => 0
  },
  "DISTNAME" => "Perl-Critic-PJCJ",
  "LICENSE" => "perl",
  "NAME" => "Perl::Critic::PJCJ",
  "PREREQ_PM" => {
    "PPI" => 0,
    "Perl::Critic" => 0
  },
  "TEST_REQUIRES" => {
    "ExtUtils::MakeMaker" => 0,
    "File::Spec" => 0,
    "IO::Handle" => 0,
    "IPC::Open3" => 0,
    "Test2::V0" => 0,
    "Test::More" => 0
  },
  "VERSION" => "v0.1.2",
  "test" => {
    "TESTS" => "t/*.t t/CodeLayout/ProhibitLongLines/*.t t/Utils/SourceLocation/*.t t/ValuesAndExpressions/RequireConsistentQuoting/*.t"
  }
);

my %FallbackPrereqs = (
  "ExtUtils::MakeMaker" => 0,
  "File::Spec" => 0,
  "IO::Handle" => 0,
  "IPC::Open3" => 0,
  "PPI" => 0,
  "Perl::Critic" => 0,
  "Test2::V0" => 0,
  "Test::More" => 0
);

unless ( eval { ExtUtils::MakeMaker->VERSION('6.63_03') } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };


sub MY::postamble {
    return <<'END_MAKEFILE';

.PHONY: show-authordeps install-authordeps reinstall-authordeps \
	show-deps install-deps reinstall-deps \
	t xt format lint build \
	cover cover-html cover-compilation cover-nvim

show-authordeps:
	@dzil authordeps

install-authordeps:
	dzil authordeps --missing | cpm install -g -

reinstall-authordeps:
	dzil authordeps | cpm install -g --reinstall --no-prebuilt -

show-deps:
	@dzil listdeps --develop

install-deps:
	dzil listdeps --develop --missing | cpm install -g -

reinstall-deps:
	dzil listdeps --develop | cpm install -g --reinstall --no-prebuilt -

t:
	yath test -j20 --qvf --no-color -T --term-width=$(tput cols)

zt: clean
	dzil test -j20


format:
	@mkdir -p tmp/perltidy
	@git ls-files "*.pl" "*.pm" "*.t" | while read file; do \
		cp "$$file" "$$file.tdybak"; \
		perlimports --inplace-edit --no-preserve-unused \
			"$$file" 2>/dev/null || true; \
		perltidy -b "$$file" >/dev/null 2>&1; \
		if ! diff -q "$$file.tdybak" "$$file" >/dev/null 2>&1; then \
			echo "Formatted $$file"; \
		fi; \
		mv "$$file.tdybak" tmp/perltidy/; \
	done

lint:
	pre-commit run --all-files


build: clean
	dzil build


cover: build
	cover --delete
	HARNESS_PERL_SWITCHES=-MDevel::Cover=+ignore,^t/ make t

cover-html: cover
	cover --report=html_basic --launch

cover-compilation: cover
	cover --report=compilation

cover-nvim: cover
	cover --report=nvim

cover-all: cover
	cover --report=nvim
	cover --report=compilation

END_MAKEFILE
}

WriteMakefile(%WriteMakefileArgs);
