#!/usr/local/bin/perl -w
#
use Graphics::VTK;



use Tk;
use Graphics::VTK::Tk;
$MW = Tk::MainWindow->new;

$VTK_DATA = 0;
$VTK_DATA = $ENV{VTK_DATA};
# get the interactor ui
use Graphics::VTK::Tk::vtkInt;
# Simple volume rendering example.
$reader = Graphics::VTK::SLCReader->new;
$reader->SetFileName("$VTK_DATA/poship.slc");
$reader->Update;
# Create transfer functions for opacity and color
$opacityTransferFunction = Graphics::VTK::PiecewiseFunction->new;
$opacityTransferFunction->AddPoint(20,0.0);
$opacityTransferFunction->AddPoint(255,0.5);
$colorTransferFunction = Graphics::VTK::ColorTransferFunction->new;
$colorTransferFunction->AddRGBPoint(0.0,0.0,0.0,0.0);
$colorTransferFunction->AddRGBPoint(64.0,1.0,0.0,0.0);
$colorTransferFunction->AddRGBPoint(128.0,0.0,0.0,1.0);
$colorTransferFunction->AddRGBPoint(192.0,0.0,1.0,0.0);
$colorTransferFunction->AddRGBPoint(255.0,0.0,0.2,0.0);
# Create properties, mappers, volume actors, and ray cast function
$volumeProperty = Graphics::VTK::VolumeProperty->new;
$volumeProperty->SetColor(@Graphics::VTK::Colors::colorTransferFunction);
$volumeProperty->SetScalarOpacity($opacityTransferFunction);
$volumeProperty->ShadeOff;
$volumeMapper = Graphics::VTK::VolumeProMapper->new;
$volumeMapper->SetInput($reader->GetOutput);
$volume = Graphics::VTK::Volume->new;
$volume->SetMapper($volumeMapper);
$volume->SetProperty($volumeProperty);
# Okay now the graphics stuff
$ren1 = Graphics::VTK::Renderer->new;
$ren1->SetBackground(0.1,0.2,0.4);
$renWin = Graphics::VTK::RenderWindow->new;
$renWin->AddRenderer($ren1);
$renWin->SetSize(256,256);
$iren = Graphics::VTK::RenderWindowInteractor->new;
$iren->SetRenderWindow($renWin);
$ren1->AddVolume($volume);
$ren1->GetActiveCamera->ParallelProjectionOn;
$ren1->GetActiveCamera->SetParallelScale(40);
$iren->SetUserMethod(
 sub
  {
   $MW->{'.vtkInteract'}->deiconify;
  }
);
$renWin->Render;
$MW->withdraw;
Graphics::VTK::Tk::vtkInt::vtkInteract($MW);

Tk->MainLoop;
