package Malware::Win32;
use base 'Malware';

use 5.008007;
use strict;
use warnings;
our $VERSION = '1.02';

=head1 OBJECT METHODS

=head2 registry()

Sets and returns an array of strings that decribes registry behavior

Accepts: string

Returns: a ref to an array of strings

=cut

sub registry {
	my ($self,$v) = @_;
	push(@{$self->{_registry}},$v) if(defined($v));
	return $self->{_registry};
}

=head2 _blurb()

Returns a hashref for the registery strings for inclusion in the $m->blurb()

=cut

sub _blurb {
	my $self = shift;

	my $hr = {};
	$hr->{Registry} = $self->registry();
	return $hr;
}

1;
__END__
=head1 AUTHOR

Wes Young, E<lt>saxguard9-cpan@yahoo.comE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2006 by Wes Young

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.8.7 or,
at your option, any later version of Perl 5 you may have available.

=cut
