/*
   This file was generated by

   ./tools/make-c-file.pl
*/
#include <limits.h>
#include <locale.h>
#include "tidy-html5.h"
#ifndef __FORWARD_H__
#define __FORWARD_H__

/* forward.h -- Forward declarations for major Tidy structures

  (c) 1998-2007 (W3C) MIT, ERCIM, Keio University
  See tidy.h for the copyright notice.

  Avoids many include file circular dependencies.

  Try to keep this file down to the minimum to avoid
  cross-talk between modules.

  Header files include this file.  C files include tidy-int.h.

*/

/* #include "tidyplatform.h" */
/* #include "tidy.h" */

/* Internal symbols are prefixed to avoid clashes with other libraries */
#define TYDYAPPEND(str1,str2) str1##str2
#define TY_(str) TYDYAPPEND(prvTidy,str)

struct _StreamIn;
typedef struct _StreamIn StreamIn;

struct _StreamOut;
typedef struct _StreamOut StreamOut;

struct _TidyDocImpl;
typedef struct _TidyDocImpl TidyDocImpl;

struct _TidyMessageImpl;
typedef struct _TidyMessageImpl TidyMessageImpl;

/* @todo: this name isn't very instructive! */
struct _Dict;
typedef struct _Dict Dict;

struct _Attribute;
typedef struct _Attribute Attribute;

struct _AttVal;
typedef struct _AttVal AttVal;

struct _Node;
typedef struct _Node Node;

struct _IStack;
typedef struct _IStack IStack;

struct _Lexer;
typedef struct _Lexer Lexer;

extern TidyAllocator TY_(g_default_allocator);

/** Wrappers for easy memory allocation using an allocator */
#define TidyAlloc(allocator, size) ((allocator)->vtbl->alloc((allocator), (size)))
#define TidyRealloc(allocator, block, size) ((allocator)->vtbl->realloc((allocator), (block), (size)))
#define TidyFree(allocator, block) ((allocator)->vtbl->free((allocator), (block)))
#define TidyPanic(allocator, msg) ((allocator)->vtbl->panic((allocator), (msg)))
#define TidyClearMemory(block, size) memset((block), 0, (size))
 

#endif /* __FORWARD_H__ */
#ifndef __ACCESS_H__
#define __ACCESS_H__

/*********************************************************************
 * carry out accessibility checks
 *
 * This module carries out processes for all accessibility checks. It
 * traverses through all the content within the tree and evaluates the
 * tags for accessibility.
 *
 * To perform the following checks, 'AccessibilityChecks' must be
 * called AFTER the tree structure has been formed.
 *
 * If, in the command prompt or configuration file, there is no
 * specification of which accessibility priorities to check, then no
 * accessibility checks will be performed.
 *
 * The accessibility checks to perform depending on user's desire:
 *   1. priority 1
 *   2. priority 1 & 2
 *   3. priority 1, 2, & 3
 *
 * Reference document: http://www.w3.org/TR/WAI-WEBCONTENT/
 *
 * Copyright University of Toronto
 * Portions (c) 1998-2006 (W3C) MIT, ERCIM, Keio University
 * See `tidy.h` for the copyright notice.
 * Programmed by: Mike Lam and Chris Ridpath
 * Modifications by: Terry Teague (TRT)
 * Further modifications: consult git log.
 *********************************************************************/

/* #include "forward.h" */


enum {
  TEXTBUF_SIZE=128u
};

struct _TidyAccessImpl;
typedef struct _TidyAccessImpl TidyAccessImpl;

struct _TidyAccessImpl
{
    /* gets set from Tidy variable AccessibilityCheckLevel */
    int PRIORITYCHK; /**< */

    /* Number of characters that are found within the concatenated text */
    int counter;

    /* list of characters in the text nodes found within a container element */
    tmbchar textNode[ TEXTBUF_SIZE ]; 

    /* The list of characters found within one text node */
    tmbchar text[ TEXTBUF_SIZE ]; 

    /* Number of frame elements found within a frameset */
    int numFrames; 

    /* Number of 'longdesc' attributes found within a frameset */
    int HasCheckedLongDesc; 

    int  CheckedHeaders;
    int  ListElements;
    int  OtherListElements;

    /* For 'USEMAP' identifier */
    Bool HasUseMap; 
    Bool HasName; 
    Bool HasMap;

    /* For tracking nodes that are deleted from the original parse tree - TRT */
    /* Node *access_tree; */

    Bool HasTH;
    Bool HasValidFor;
    Bool HasValidId;
    Bool HasValidRowHeaders;
    Bool HasValidColumnHeaders;
    Bool HasInvalidRowHeader;
    Bool HasInvalidColumnHeader;
    int  ForID;

};


void TY_(AccessibilityChecks)( TidyDocImpl* doc );


#endif /* __ACCESS_H__ */
#ifndef __ATTRDICT_H__
#define __ATTRDICT_H__

/* attrdict.h -- extended attribute information

   (c) 1998-2006 (W3C) MIT, ERCIM, Keio University
   See tidy.h for the copyright notice.

*/

/* #include "tidy.h" */

typedef struct _AttrVersion
{
    TidyAttrId attribute;
    unsigned int versions;
} AttrVersion;

extern const AttrVersion TY_(W3CAttrsFor_A)[];
extern const AttrVersion TY_(W3CAttrsFor_ABBR)[];
extern const AttrVersion TY_(W3CAttrsFor_ACRONYM)[];
extern const AttrVersion TY_(W3CAttrsFor_ADDRESS)[];
extern const AttrVersion TY_(W3CAttrsFor_APPLET)[];
extern const AttrVersion TY_(W3CAttrsFor_AREA)[];
extern const AttrVersion TY_(W3CAttrsFor_B)[];
extern const AttrVersion TY_(W3CAttrsFor_BASE)[];
extern const AttrVersion TY_(W3CAttrsFor_BASEFONT)[];
extern const AttrVersion TY_(W3CAttrsFor_BDO)[];
extern const AttrVersion TY_(W3CAttrsFor_BIG)[];
extern const AttrVersion TY_(W3CAttrsFor_BLOCKQUOTE)[];
extern const AttrVersion TY_(W3CAttrsFor_BODY)[];
extern const AttrVersion TY_(W3CAttrsFor_BR)[];
extern const AttrVersion TY_(W3CAttrsFor_BUTTON)[];
extern const AttrVersion TY_(W3CAttrsFor_CAPTION)[];
extern const AttrVersion TY_(W3CAttrsFor_CENTER)[];
extern const AttrVersion TY_(W3CAttrsFor_CITE)[];
extern const AttrVersion TY_(W3CAttrsFor_CODE)[];
extern const AttrVersion TY_(W3CAttrsFor_COL)[];
extern const AttrVersion TY_(W3CAttrsFor_COLGROUP)[];
extern const AttrVersion TY_(W3CAttrsFor_DD)[];
extern const AttrVersion TY_(W3CAttrsFor_DEL)[];
extern const AttrVersion TY_(W3CAttrsFor_DFN)[];
extern const AttrVersion TY_(W3CAttrsFor_DIR)[];
extern const AttrVersion TY_(W3CAttrsFor_DIV)[];
extern const AttrVersion TY_(W3CAttrsFor_DL)[];
extern const AttrVersion TY_(W3CAttrsFor_DT)[];
extern const AttrVersion TY_(W3CAttrsFor_EM)[];
extern const AttrVersion TY_(W3CAttrsFor_FIELDSET)[];
extern const AttrVersion TY_(W3CAttrsFor_FONT)[];
extern const AttrVersion TY_(W3CAttrsFor_FORM)[];
extern const AttrVersion TY_(W3CAttrsFor_FRAME)[];
extern const AttrVersion TY_(W3CAttrsFor_FRAMESET)[];
extern const AttrVersion TY_(W3CAttrsFor_H1)[];
extern const AttrVersion TY_(W3CAttrsFor_H2)[];
extern const AttrVersion TY_(W3CAttrsFor_H3)[];
extern const AttrVersion TY_(W3CAttrsFor_H4)[];
extern const AttrVersion TY_(W3CAttrsFor_H5)[];
extern const AttrVersion TY_(W3CAttrsFor_H6)[];
extern const AttrVersion TY_(W3CAttrsFor_HEAD)[];
extern const AttrVersion TY_(W3CAttrsFor_HR)[];
extern const AttrVersion TY_(W3CAttrsFor_HTML)[];
extern const AttrVersion TY_(W3CAttrsFor_I)[];
extern const AttrVersion TY_(W3CAttrsFor_IFRAME)[];
extern const AttrVersion TY_(W3CAttrsFor_IMG)[];
extern const AttrVersion TY_(W3CAttrsFor_INPUT)[];
extern const AttrVersion TY_(W3CAttrsFor_INS)[];
extern const AttrVersion TY_(W3CAttrsFor_ISINDEX)[];
extern const AttrVersion TY_(W3CAttrsFor_KBD)[];
extern const AttrVersion TY_(W3CAttrsFor_LABEL)[];
extern const AttrVersion TY_(W3CAttrsFor_LEGEND)[];
extern const AttrVersion TY_(W3CAttrsFor_LI)[];
extern const AttrVersion TY_(W3CAttrsFor_LINK)[];
extern const AttrVersion TY_(W3CAttrsFor_LISTING)[];
extern const AttrVersion TY_(W3CAttrsFor_MAP)[];
extern const AttrVersion TY_(W3CAttrsFor_MATHML)[]; /* [i_a]2 */
extern const AttrVersion TY_(W3CAttrsFor_MENU)[];
extern const AttrVersion TY_(W3CAttrsFor_META)[];
extern const AttrVersion TY_(W3CAttrsFor_NEXTID)[];
extern const AttrVersion TY_(W3CAttrsFor_NOFRAMES)[];
extern const AttrVersion TY_(W3CAttrsFor_NOSCRIPT)[];
extern const AttrVersion TY_(W3CAttrsFor_OBJECT)[];
extern const AttrVersion TY_(W3CAttrsFor_OL)[];
extern const AttrVersion TY_(W3CAttrsFor_OPTGROUP)[];
extern const AttrVersion TY_(W3CAttrsFor_OPTION)[];
extern const AttrVersion TY_(W3CAttrsFor_P)[];
extern const AttrVersion TY_(W3CAttrsFor_PARAM)[];
extern const AttrVersion TY_(W3CAttrsFor_PICTURE)[]; /* Issue #151 - html5 */
extern const AttrVersion TY_(W3CAttrsFor_PLAINTEXT)[];
extern const AttrVersion TY_(W3CAttrsFor_PRE)[];
extern const AttrVersion TY_(W3CAttrsFor_Q)[];
extern const AttrVersion TY_(W3CAttrsFor_RB)[];
extern const AttrVersion TY_(W3CAttrsFor_RBC)[];
extern const AttrVersion TY_(W3CAttrsFor_RP)[];
extern const AttrVersion TY_(W3CAttrsFor_RT)[];
extern const AttrVersion TY_(W3CAttrsFor_RTC)[];
extern const AttrVersion TY_(W3CAttrsFor_RUBY)[];
extern const AttrVersion TY_(W3CAttrsFor_S)[];
extern const AttrVersion TY_(W3CAttrsFor_SAMP)[];
extern const AttrVersion TY_(W3CAttrsFor_SCRIPT)[];
extern const AttrVersion TY_(W3CAttrsFor_SELECT)[];
extern const AttrVersion TY_(W3CAttrsFor_SMALL)[];
extern const AttrVersion TY_(W3CAttrsFor_SPAN)[];
extern const AttrVersion TY_(W3CAttrsFor_STRIKE)[];
extern const AttrVersion TY_(W3CAttrsFor_STRONG)[];
extern const AttrVersion TY_(W3CAttrsFor_STYLE)[];
extern const AttrVersion TY_(W3CAttrsFor_SUB)[];
extern const AttrVersion TY_(W3CAttrsFor_SUP)[];
extern const AttrVersion TY_(W3CAttrsFor_SVG)[];
extern const AttrVersion TY_(W3CAttrsFor_TABLE)[];
extern const AttrVersion TY_(W3CAttrsFor_TBODY)[];
extern const AttrVersion TY_(W3CAttrsFor_TD)[];
extern const AttrVersion TY_(W3CAttrsFor_TEXTAREA)[];
extern const AttrVersion TY_(W3CAttrsFor_TFOOT)[];
extern const AttrVersion TY_(W3CAttrsFor_TH)[];
extern const AttrVersion TY_(W3CAttrsFor_THEAD)[];
extern const AttrVersion TY_(W3CAttrsFor_TITLE)[];
extern const AttrVersion TY_(W3CAttrsFor_TR)[];
extern const AttrVersion TY_(W3CAttrsFor_TT)[];
extern const AttrVersion TY_(W3CAttrsFor_U)[];
extern const AttrVersion TY_(W3CAttrsFor_UL)[];
extern const AttrVersion TY_(W3CAttrsFor_VAR)[];
extern const AttrVersion TY_(W3CAttrsFor_XMP)[];

extern const AttrVersion TY_(W3CAttrsFor_TRACK)[];
extern const AttrVersion TY_(W3CAttrsFor_SUMMARY)[];
extern const AttrVersion TY_(W3CAttrsFor_FIGCAPTION)[];
extern const AttrVersion TY_(W3CAttrsFor_HGROUP)[];
extern const AttrVersion TY_(W3CAttrsFor_FIGURE)[];
extern const AttrVersion TY_(W3CAttrsFor_ARTICLE)[];
extern const AttrVersion TY_(W3CAttrsFor_ASIDE)[];
extern const AttrVersion TY_(W3CAttrsFor_BDI)[];
extern const AttrVersion TY_(W3CAttrsFor_NAV)[];
extern const AttrVersion TY_(W3CAttrsFor_SECTION)[];
extern const AttrVersion TY_(W3CAttrsFor_FOOTER)[];
extern const AttrVersion TY_(W3CAttrsFor_HEADER)[];
extern const AttrVersion TY_(W3CAttrsFor_DETAILS)[];
extern const AttrVersion TY_(W3CAttrsFor_DIALOG)[];
extern const AttrVersion TY_(W3CAttrsFor_COMMAND)[];
extern const AttrVersion TY_(W3CAttrsFor_MAIN)[];
extern const AttrVersion TY_(W3CAttrsFor_MARK)[];
extern const AttrVersion TY_(W3CAttrsFor_OUTPUT)[];
extern const AttrVersion TY_(W3CAttrsFor_MENUITEM)[];
extern const AttrVersion TY_(W3CAttrsFor_METER)[];
extern const AttrVersion TY_(W3CAttrsFor_PROGRESS)[];
extern const AttrVersion TY_(W3CAttrsFor_TEMPLATE)[];
extern const AttrVersion TY_(W3CAttrsFor_TIME)[];
extern const AttrVersion TY_(W3CAttrsFor_DATA)[];
extern const AttrVersion TY_(W3CAttrsFor_DATALIST)[];
extern const AttrVersion TY_(W3CAttrsFor_AUDIO)[];
extern const AttrVersion TY_(W3CAttrsFor_VIDEO)[];
extern const AttrVersion TY_(W3CAttrsFor_CANVAS)[];
extern const AttrVersion TY_(W3CAttrsFor_SOURCE)[];
extern const AttrVersion TY_(W3CAttrsFor_EMBED)[];
extern const AttrVersion TY_(W3CAttrsFor_KEYGEN)[];
extern const AttrVersion TY_(W3CAttrsFor_WBR)[];

#endif /* __ATTRDICT_H__ */
#ifndef __ATTRS_H__
#define __ATTRS_H__

/* attrs.h -- recognize HTML attributes

  (c) 1998-2007 (W3C) MIT, ERCIM, Keio University
  See tidy.h for the copyright notice.

*/

/* #include "forward.h" */

/* declaration for methods that check attribute values */
typedef void (AttrCheck)(TidyDocImpl* doc, Node *node, AttVal *attval);

struct _Attribute
{
    TidyAttrId  id;
    tmbstr      name;
    AttrCheck*  attrchk;

    struct _Attribute* next;
};


/*
 Anchor/Node linked list
*/

struct _Anchor
{
    struct _Anchor *next;
    Node *node;
    char *name;
};

typedef struct _Anchor Anchor;

enum
{
    ATTRIBUTE_HASH_SIZE=178u
};

struct _AttrHash
{
    Attribute const*  attr;
    struct _AttrHash* next;
};

typedef struct _AttrHash AttrHash;

enum
{
    ANCHOR_HASH_SIZE=1021u
};

/* Keeps a list of attributes that are sorted ahead of the others. */
typedef struct _priorityAttribs {
    tmbstr* list;
    unsigned int count;
    unsigned int capacity;
} PriorityAttribs;

struct _TidyAttribImpl
{
    /* anchor/node lookup */
    Anchor*    anchor_hash[ANCHOR_HASH_SIZE];

    /* Declared literal attributes */
    Attribute* declared_attr_list;

    /* Prioritized list of attributes to write */
    PriorityAttribs priorityAttribs;

    AttrHash*  hashtab[ATTRIBUTE_HASH_SIZE];
};

typedef struct _TidyAttribImpl TidyAttribImpl;

#define XHTML_NAMESPACE "http://www.w3.org/1999/xhtml"

AttrCheck TY_(CheckUrl);

/* public method for finding attribute definition by name */
const Attribute* TY_(CheckAttribute)( TidyDocImpl* doc, Node *node, AttVal *attval );

const Attribute* TY_(FindAttribute)( TidyDocImpl* doc, AttVal *attval );

AttVal* TY_(GetAttrByName)( Node *node, ctmbstr name );

void TY_(DropAttrByName)( TidyDocImpl* doc, Node *node, ctmbstr name );

AttVal* TY_(AddAttribute)( TidyDocImpl* doc,
                           Node *node, ctmbstr name, ctmbstr value );

AttVal* TY_(RepairAttrValue)(TidyDocImpl* doc, Node* node, ctmbstr name, ctmbstr value);

/* Add an item to the list of priority attributes to write first. */
void TY_(DefinePriorityAttribute)(TidyDocImpl* doc, ctmbstr name);

/* Start an iterator for priority attributes. */
TidyIterator TY_(getPriorityAttrList)( TidyDocImpl* doc );

/* Get the next priority attribute. */
ctmbstr TY_(getNextPriorityAttr)( TidyDocImpl* doc, TidyIterator* iter );

Bool TY_(IsUrl)( TidyDocImpl* doc, ctmbstr attrname );

/* Bool IsBool( TidyDocImpl* doc, ctmbstr attrname ); */

Bool TY_(IsScript)( TidyDocImpl* doc, ctmbstr attrname );

/* may id or name serve as anchor? */
Bool TY_(IsAnchorElement)( TidyDocImpl* doc, Node* node );

/*
  In CSS1, selectors can contain only the characters A-Z, 0-9, and
  Unicode characters 161-255, plus dash (-); they cannot start with
  a dash or a digit; they can also contain escaped characters and any
  Unicode character as a numeric code (see next item).

  The backslash followed by at most four hexadecimal digits (0..9A..F)
  stands for the Unicode character with that number.

  Any character except a hexadecimal digit can be escaped to remove its
  special meaning, by putting a backslash in front.

  #508936 - CSS class naming for -clean option
*/
Bool TY_(IsCSS1Selector)( ctmbstr buf );

Bool TY_(IsValidHTMLID)(ctmbstr id);
Bool TY_(IsValidXMLID)(ctmbstr id);

/* removes anchor for specific node */
void TY_(RemoveAnchorByNode)( TidyDocImpl* doc, ctmbstr name, Node *node );

/* free all anchors */
void TY_(FreeAnchors)( TidyDocImpl* doc );


/* public methods for inititializing/freeing attribute dictionary */
void TY_(InitAttrs)( TidyDocImpl* doc );
void TY_(FreeAttrTable)( TidyDocImpl* doc );

void TY_(FreeAttrPriorityList)( TidyDocImpl* doc );

void TY_(AppendToClassAttr)( TidyDocImpl* doc, AttVal *classattr, ctmbstr classname );
/*
 the same attribute name can't be used
 more than once in each element
*/
void TY_(RepairDuplicateAttributes)( TidyDocImpl* doc, Node* node, Bool isXml );
void TY_(SortAttributes)(TidyDocImpl* doc, Node* node, TidyAttrSortStrategy strat);

Bool TY_(IsBoolAttribute)( AttVal* attval );
Bool TY_(attrIsEvent)( AttVal* attval );

AttVal* TY_(AttrGetById)( Node* node, TidyAttrId id );

unsigned int TY_(NodeAttributeVersions)( Node* node, TidyAttrId id );

Bool TY_(AttributeIsProprietary)(Node* node, AttVal* attval);
Bool TY_(AttributeIsMismatched)(Node* node, AttVal* attval, TidyDocImpl* doc);


/* 0 == TidyAttr_UNKNOWN  */
#define AttrId(av) ((av) && (av)->dict ? (av)->dict->id : TidyAttr_UNKNOWN)
#define AttrIsId(av, atid) ((av) && (av)->dict && ((av)->dict->id == atid))

#define AttrHasValue(attr)      ((attr) && (attr)->value)
#define AttrValueIs(attr, val)  (AttrHasValue(attr) && \
                                 TY_(tmbstrcasecmp)((attr)->value, val) == 0)
#define AttrContains(attr, val) (AttrHasValue(attr) && \
                                 TY_(tmbsubstr)((attr)->value, val) != NULL)
#define AttrVersions(attr)      ((attr) && (attr)->dict ? (attr)->dict->versions : VERS_PROPRIETARY)

#define AttrsHaveSameId(a, b) (a && b && a->dict && b->dict && a->dict->id && \
                               b->dict->id && a->dict->id == b->dict->id)

#define attrIsABBR(av)              AttrIsId( av, TidyAttr_ABBR  )
#define attrIsACCEPT(av)            AttrIsId( av, TidyAttr_ACCEPT  )
#define attrIsACCEPT_CHARSET(av)    AttrIsId( av, TidyAttr_ACCEPT_CHARSET  )
#define attrIsACCESSKEY(av)         AttrIsId( av, TidyAttr_ACCESSKEY  )
#define attrIsACTION(av)            AttrIsId( av, TidyAttr_ACTION  )
#define attrIsADD_DATE(av)          AttrIsId( av, TidyAttr_ADD_DATE  )
#define attrIsALIGN(av)             AttrIsId( av, TidyAttr_ALIGN  )
#define attrIsALINK(av)             AttrIsId( av, TidyAttr_ALINK  )
#define attrIsALT(av)               AttrIsId( av, TidyAttr_ALT  )
#define attrIsARCHIVE(av)           AttrIsId( av, TidyAttr_ARCHIVE  )
#define attrIsAXIS(av)              AttrIsId( av, TidyAttr_AXIS  )
#define attrIsBACKGROUND(av)        AttrIsId( av, TidyAttr_BACKGROUND  )
#define attrIsBGCOLOR(av)           AttrIsId( av, TidyAttr_BGCOLOR  )
#define attrIsBGPROPERTIES(av)      AttrIsId( av, TidyAttr_BGPROPERTIES  )
#define attrIsBORDER(av)            AttrIsId( av, TidyAttr_BORDER  )
#define attrIsBORDERCOLOR(av)       AttrIsId( av, TidyAttr_BORDERCOLOR  )
#define attrIsBOTTOMMARGIN(av)      AttrIsId( av, TidyAttr_BOTTOMMARGIN  )
#define attrIsCELLPADDING(av)       AttrIsId( av, TidyAttr_CELLPADDING  )
#define attrIsCELLSPACING(av)       AttrIsId( av, TidyAttr_CELLSPACING  )
#define attrIsCHARSET(av)           AttrIsId( av, TidyAttr_CHARSET  )
#define attrIsCHAR(av)              AttrIsId( av, TidyAttr_CHAR  )
#define attrIsCHAROFF(av)           AttrIsId( av, TidyAttr_CHAROFF  )
#define attrIsCHARSET(av)           AttrIsId( av, TidyAttr_CHARSET  )
#define attrIsCHECKED(av)           AttrIsId( av, TidyAttr_CHECKED  )
#define attrIsCITE(av)              AttrIsId( av, TidyAttr_CITE  )
#define attrIsCLASS(av)             AttrIsId( av, TidyAttr_CLASS  )
#define attrIsCLASSID(av)           AttrIsId( av, TidyAttr_CLASSID  )
#define attrIsCLEAR(av)             AttrIsId( av, TidyAttr_CLEAR  )
#define attrIsCODE(av)              AttrIsId( av, TidyAttr_CODE  )
#define attrIsCODEBASE(av)          AttrIsId( av, TidyAttr_CODEBASE  )
#define attrIsCODETYPE(av)          AttrIsId( av, TidyAttr_CODETYPE  )
#define attrIsCOLOR(av)             AttrIsId( av, TidyAttr_COLOR  )
#define attrIsCOLS(av)              AttrIsId( av, TidyAttr_COLS  )
#define attrIsCOLSPAN(av)           AttrIsId( av, TidyAttr_COLSPAN  )
#define attrIsCOMPACT(av)           AttrIsId( av, TidyAttr_COMPACT  )
#define attrIsCONTENT(av)           AttrIsId( av, TidyAttr_CONTENT  )
#define attrIsCOORDS(av)            AttrIsId( av, TidyAttr_COORDS  )
#define attrIsDATA(av)              AttrIsId( av, TidyAttr_DATA  )
#define attrIsDATAFLD(av)           AttrIsId( av, TidyAttr_DATAFLD  )
#define attrIsDATAFORMATAS(av)      AttrIsId( av, TidyAttr_DATAFORMATAS  )
#define attrIsDATAPAGESIZE(av)      AttrIsId( av, TidyAttr_DATAPAGESIZE  )
#define attrIsDATASRC(av)           AttrIsId( av, TidyAttr_DATASRC  )
#define attrIsDATETIME(av)          AttrIsId( av, TidyAttr_DATETIME  )
#define attrIsDECLARE(av)           AttrIsId( av, TidyAttr_DECLARE  )
#define attrIsDEFER(av)             AttrIsId( av, TidyAttr_DEFER  )
#define attrIsDIR(av)               AttrIsId( av, TidyAttr_DIR  )
#define attrIsDISABLED(av)          AttrIsId( av, TidyAttr_DISABLED  )
#define attrIsENCODING(av)          AttrIsId( av, TidyAttr_ENCODING  )
#define attrIsENCTYPE(av)           AttrIsId( av, TidyAttr_ENCTYPE  )
#define attrIsFACE(av)              AttrIsId( av, TidyAttr_FACE  )
#define attrIsFOR(av)               AttrIsId( av, TidyAttr_FOR  )
#define attrIsFRAME(av)             AttrIsId( av, TidyAttr_FRAME  )
#define attrIsFRAMEBORDER(av)       AttrIsId( av, TidyAttr_FRAMEBORDER  )
#define attrIsFRAMESPACING(av)      AttrIsId( av, TidyAttr_FRAMESPACING  )
#define attrIsGRIDX(av)             AttrIsId( av, TidyAttr_GRIDX  )
#define attrIsGRIDY(av)             AttrIsId( av, TidyAttr_GRIDY  )
#define attrIsHEADERS(av)           AttrIsId( av, TidyAttr_HEADERS  )
#define attrIsHEIGHT(av)            AttrIsId( av, TidyAttr_HEIGHT  )
#define attrIsHREF(av)              AttrIsId( av, TidyAttr_HREF  )
#define attrIsHREFLANG(av)          AttrIsId( av, TidyAttr_HREFLANG  )
#define attrIsHSPACE(av)            AttrIsId( av, TidyAttr_HSPACE  )
#define attrIsHTTP_EQUIV(av)        AttrIsId( av, TidyAttr_HTTP_EQUIV  )
#define attrIsID(av)                AttrIsId( av, TidyAttr_ID  )
#define attrIsISMAP(av)             AttrIsId( av, TidyAttr_ISMAP  )
#define attrIsITEMID(av)            AttrIsId( av, TidyAttr_ITEMID  )
#define attrIsITEMPROP(av)          AttrIsId( av, TidyAttr_ITEMPROP  )
#define attrIsITEMREF(av)           AttrIsId( av, TidyAttr_ITEMREF  )
#define attrIsITEMSCOPE(av)         AttrIsId( av, TidyAttr_ITEMSCOPE  )
#define attrIsITEMTYPE(av)          AttrIsId( av, TidyAttr_ITEMTYPE  )
#define attrIsLABEL(av)             AttrIsId( av, TidyAttr_LABEL  )
#define attrIsLANG(av)              AttrIsId( av, TidyAttr_LANG  )
#define attrIsLANGUAGE(av)          AttrIsId( av, TidyAttr_LANGUAGE  )
#define attrIsLAST_MODIFIED(av)     AttrIsId( av, TidyAttr_LAST_MODIFIED  )
#define attrIsLAST_VISIT(av)        AttrIsId( av, TidyAttr_LAST_VISIT  )
#define attrIsLEFTMARGIN(av)        AttrIsId( av, TidyAttr_LEFTMARGIN  )
#define attrIsLINK(av)              AttrIsId( av, TidyAttr_LINK  )
#define attrIsLONGDESC(av)          AttrIsId( av, TidyAttr_LONGDESC  )
#define attrIsLOWSRC(av)            AttrIsId( av, TidyAttr_LOWSRC  )
#define attrIsMARGINHEIGHT(av)      AttrIsId( av, TidyAttr_MARGINHEIGHT  )
#define attrIsMARGINWIDTH(av)       AttrIsId( av, TidyAttr_MARGINWIDTH  )
#define attrIsMAXLENGTH(av)         AttrIsId( av, TidyAttr_MAXLENGTH  )
#define attrIsMEDIA(av)             AttrIsId( av, TidyAttr_MEDIA  )
#define attrIsMETHOD(av)            AttrIsId( av, TidyAttr_METHOD  )
#define attrIsMULTIPLE(av)          AttrIsId( av, TidyAttr_MULTIPLE  )
#define attrIsNAME(av)              AttrIsId( av, TidyAttr_NAME  )
#define attrIsNOHREF(av)            AttrIsId( av, TidyAttr_NOHREF  )
#define attrIsNORESIZE(av)          AttrIsId( av, TidyAttr_NORESIZE  )
#define attrIsNOSHADE(av)           AttrIsId( av, TidyAttr_NOSHADE  )
#define attrIsNOWRAP(av)            AttrIsId( av, TidyAttr_NOWRAP  )
#define attrIsOBJECT(av)            AttrIsId( av, TidyAttr_OBJECT  )
#define attrIsOnAFTERUPDATE(av)     AttrIsId( av, TidyAttr_OnAFTERUPDATE  )
#define attrIsOnBEFOREUNLOAD(av)    AttrIsId( av, TidyAttr_OnBEFOREUNLOAD  )
#define attrIsOnBEFOREUPDATE(av)    AttrIsId( av, TidyAttr_OnBEFOREUPDATE  )
#define attrIsOnBLUR(av)            AttrIsId( av, TidyAttr_OnBLUR  )
#define attrIsOnCHANGE(av)          AttrIsId( av, TidyAttr_OnCHANGE  )
#define attrIsOnCLICK(av)           AttrIsId( av, TidyAttr_OnCLICK  )
#define attrIsOnDATAAVAILABLE(av)   AttrIsId( av, TidyAttr_OnDATAAVAILABLE  )
#define attrIsOnDATASETCHANGED(av)  AttrIsId( av, TidyAttr_OnDATASETCHANGED  )
#define attrIsOnDATASETCOMPLETE(av) AttrIsId( av, TidyAttr_OnDATASETCOMPLETE  )
#define attrIsOnDBLCLICK(av)        AttrIsId( av, TidyAttr_OnDBLCLICK  )
#define attrIsOnERRORUPDATE(av)     AttrIsId( av, TidyAttr_OnERRORUPDATE  )
#define attrIsOnFOCUS(av)           AttrIsId( av, TidyAttr_OnFOCUS  )
#define attrIsOnKEYDOWN(av)         AttrIsId( av, TidyAttr_OnKEYDOWN  )
#define attrIsOnKEYPRESS(av)        AttrIsId( av, TidyAttr_OnKEYPRESS  )
#define attrIsOnKEYUP(av)           AttrIsId( av, TidyAttr_OnKEYUP  )
#define attrIsOnLOAD(av)            AttrIsId( av, TidyAttr_OnLOAD  )
#define attrIsOnMOUSEDOWN(av)       AttrIsId( av, TidyAttr_OnMOUSEDOWN  )
#define attrIsOnMOUSEMOVE(av)       AttrIsId( av, TidyAttr_OnMOUSEMOVE  )
#define attrIsOnMOUSEOUT(av)        AttrIsId( av, TidyAttr_OnMOUSEOUT  )
#define attrIsOnMOUSEOVER(av)       AttrIsId( av, TidyAttr_OnMOUSEOVER  )
#define attrIsOnMOUSEUP(av)         AttrIsId( av, TidyAttr_OnMOUSEUP  )
#define attrIsOnRESET(av)           AttrIsId( av, TidyAttr_OnRESET  )
#define attrIsOnROWENTER(av)        AttrIsId( av, TidyAttr_OnROWENTER  )
#define attrIsOnROWEXIT(av)         AttrIsId( av, TidyAttr_OnROWEXIT  )
#define attrIsOnSELECT(av)          AttrIsId( av, TidyAttr_OnSELECT  )
#define attrIsOnSUBMIT(av)          AttrIsId( av, TidyAttr_OnSUBMIT  )
#define attrIsOnUNLOAD(av)          AttrIsId( av, TidyAttr_OnUNLOAD  )
#define attrIsPROFILE(av)           AttrIsId( av, TidyAttr_PROFILE  )
#define attrIsPROMPT(av)            AttrIsId( av, TidyAttr_PROMPT  )
#define attrIsRBSPAN(av)            AttrIsId( av, TidyAttr_RBSPAN  )
#define attrIsREADONLY(av)          AttrIsId( av, TidyAttr_READONLY  )
#define attrIsREL(av)               AttrIsId( av, TidyAttr_REL  )
#define attrIsREV(av)               AttrIsId( av, TidyAttr_REV  )
#define attrIsRIGHTMARGIN(av)       AttrIsId( av, TidyAttr_RIGHTMARGIN  )
#define attrIsROLE(av)              AttrIsId( av, TidyAttr_ROLE  )
#define attrIsROWS(av)              AttrIsId( av, TidyAttr_ROWS  )
#define attrIsROWSPAN(av)           AttrIsId( av, TidyAttr_ROWSPAN  )
#define attrIsRULES(av)             AttrIsId( av, TidyAttr_RULES  )
#define attrIsSCHEME(av)            AttrIsId( av, TidyAttr_SCHEME  )
#define attrIsSCOPE(av)             AttrIsId( av, TidyAttr_SCOPE  )
#define attrIsSCROLLING(av)         AttrIsId( av, TidyAttr_SCROLLING  )
#define attrIsSELECTED(av)          AttrIsId( av, TidyAttr_SELECTED  )
#define attrIsSHAPE(av)             AttrIsId( av, TidyAttr_SHAPE  )
#define attrIsSHOWGRID(av)          AttrIsId( av, TidyAttr_SHOWGRID  )
#define attrIsSHOWGRIDX(av)         AttrIsId( av, TidyAttr_SHOWGRIDX  )
#define attrIsSHOWGRIDY(av)         AttrIsId( av, TidyAttr_SHOWGRIDY  )
#define attrIsSIZE(av)              AttrIsId( av, TidyAttr_SIZE  )
#define attrIsSPAN(av)              AttrIsId( av, TidyAttr_SPAN  )
#define attrIsSRC(av)               AttrIsId( av, TidyAttr_SRC  )
#define attrIsSTANDBY(av)           AttrIsId( av, TidyAttr_STANDBY  )
#define attrIsSTART(av)             AttrIsId( av, TidyAttr_START  )
#define attrIsSTYLE(av)             AttrIsId( av, TidyAttr_STYLE  )
#define attrIsSUMMARY(av)           AttrIsId( av, TidyAttr_SUMMARY  )
#define attrIsTABINDEX(av)          AttrIsId( av, TidyAttr_TABINDEX  )
#define attrIsTARGET(av)            AttrIsId( av, TidyAttr_TARGET  )
#define attrIsTEXT(av)              AttrIsId( av, TidyAttr_TEXT  )
#define attrIsTITLE(av)             AttrIsId( av, TidyAttr_TITLE  )
#define attrIsTOPMARGIN(av)         AttrIsId( av, TidyAttr_TOPMARGIN  )
#define attrIsTYPE(av)              AttrIsId( av, TidyAttr_TYPE  )
#define attrIsUSEMAP(av)            AttrIsId( av, TidyAttr_USEMAP  )
#define attrIsVALIGN(av)            AttrIsId( av, TidyAttr_VALIGN  )
#define attrIsVALUE(av)             AttrIsId( av, TidyAttr_VALUE  )
#define attrIsVALUETYPE(av)         AttrIsId( av, TidyAttr_VALUETYPE  )
#define attrIsVERSION(av)           AttrIsId( av, TidyAttr_VERSION  )
#define attrIsVLINK(av)             AttrIsId( av, TidyAttr_VLINK  )
#define attrIsVSPACE(av)            AttrIsId( av, TidyAttr_VSPACE  )
#define attrIsWIDTH(av)             AttrIsId( av, TidyAttr_WIDTH  )
#define attrIsWRAP(av)              AttrIsId( av, TidyAttr_WRAP  )
#define attrIsXMLNS(av)             AttrIsId( av, TidyAttr_XMLNS  )
#define attrIsXML_LANG(av)          AttrIsId( av, TidyAttr_XML_LANG  )
#define attrIsXML_SPACE(av)         AttrIsId( av, TidyAttr_XML_SPACE  )
#define attrIsARIA_ACTIVEDESCENDANT(av) AttrIsId( av,  TidyAttr_ARIA_ACTIVEDESCENDANT  )
#define attrIsARIA_ATOMIC(av)           AttrIsId( av,  TidyAttr_ARIA_ATOMIC  )
#define attrIsARIA_AUTOCOMPLETE(av)     AttrIsId( av,  TidyAttr_ARIA_AUTOCOMPLETE  )
#define attrIsARIA_BUSY(av)             AttrIsId( av,  TidyAttr_ARIA_BUSY  )
#define attrIsARIA_CHECKED(av)          AttrIsId( av,  TidyAttr_ARIA_CHECKED  )
#define attrIsARIA_CONTROLS(av)         AttrIsId( av,  TidyAttr_ARIA_CONTROLS  )
#define attrIsARIA_DESCRIBEDBY(av)      AttrIsId( av,  TidyAttr_ARIA_DESCRIBEDBY  )
#define attrIsARIA_DISABLED(av)         AttrIsId( av,  TidyAttr_ARIA_DISABLED  )
#define attrIsARIA_DROPEFFECT(av)       AttrIsId( av,  TidyAttr_ARIA_DROPEFFECT  )
#define attrIsARIA_EXPANDED(av)         AttrIsId( av,  TidyAttr_ARIA_EXPANDED  )
#define attrIsARIA_FLOWTO(av)           AttrIsId( av,  TidyAttr_ARIA_FLOWTO  )
#define attrIsARIA_GRABBED(av)          AttrIsId( av,  TidyAttr_ARIA_GRABBED  )
#define attrIsARIA_HASPOPUP(av)         AttrIsId( av,  TidyAttr_ARIA_HASPOPUP  )
#define attrIsARIA_HIDDEN(av)           AttrIsId( av,  TidyAttr_ARIA_HIDDEN  )
#define attrIsARIA_INVALID(av)          AttrIsId( av,  TidyAttr_ARIA_INVALID  )
#define attrIsARIA_LABEL(av)            AttrIsId( av,  TidyAttr_ARIA_LABEL  )
#define attrIsARIA_LABELLEDBY(av)       AttrIsId( av,  TidyAttr_ARIA_LABELLEDBY  )
#define attrIsARIA_LEVEL(av)            AttrIsId( av,  TidyAttr_ARIA_LEVEL  )
#define attrIsARIA_LIVE(av)             AttrIsId( av,  TidyAttr_ARIA_LIVE  )
#define attrIsARIA_MULTILINE(av)        AttrIsId( av,  TidyAttr_ARIA_MULTILINE  )
#define attrIsARIA_MULTISELECTABLE(av)  AttrIsId( av,  TidyAttr_ARIA_MULTISELECTABLE  )
#define attrIsARIA_ORIENTATION(av)      AttrIsId( av,  TidyAttr_ARIA_ORIENTATION  )
#define attrIsARIA_OWNS(av)             AttrIsId( av,  TidyAttr_ARIA_OWNS  )
#define attrIsARIA_POSINSET(av)         AttrIsId( av,  TidyAttr_ARIA_POSINSET  )
#define attrIsARIA_PRESSED(av)          AttrIsId( av,  TidyAttr_ARIA_PRESSED  )
#define attrIsARIA_READONLY(av)         AttrIsId( av,  TidyAttr_ARIA_READONLY  )
#define attrIsARIA_RELEVANT(av)         AttrIsId( av,  TidyAttr_ARIA_RELEVANT  )
#define attrIsARIA_REQUIRED(av)         AttrIsId( av,  TidyAttr_ARIA_REQUIRED  )
#define attrIsARIA_SELECTED(av)         AttrIsId( av,  TidyAttr_ARIA_SELECTED  )
#define attrIsARIA_SETSIZE(av)          AttrIsId( av,  TidyAttr_ARIA_SETSIZE  )
#define attrIsARIA_SORT(av)             AttrIsId( av,  TidyAttr_ARIA_SORT  )
#define attrIsARIA_VALUEMAX(av)         AttrIsId( av,  TidyAttr_ARIA_VALUEMAX  )
#define attrIsARIA_VALUEMIN(av)         AttrIsId( av,  TidyAttr_ARIA_VALUEMIN  )
#define attrIsARIA_VALUENOW(av)         AttrIsId( av,  TidyAttr_ARIA_VALUENOW  )
#define attrIsARIA_VALUETEXT(av)        AttrIsId( av,  TidyAttr_ARIA_VALUETEXT  )



/* Attribute Retrieval macros
*/
#define attrGetHREF( nod )        TY_(AttrGetById)( nod, TidyAttr_HREF  )
#define attrGetSRC( nod )         TY_(AttrGetById)( nod, TidyAttr_SRC  )
#define attrGetID( nod )          TY_(AttrGetById)( nod, TidyAttr_ID  )
#define attrGetNAME( nod )        TY_(AttrGetById)( nod, TidyAttr_NAME  )
#define attrGetSUMMARY( nod )     TY_(AttrGetById)( nod, TidyAttr_SUMMARY  )
#define attrGetALT( nod )         TY_(AttrGetById)( nod, TidyAttr_ALT  )
#define attrGetLONGDESC( nod )    TY_(AttrGetById)( nod, TidyAttr_LONGDESC  )
#define attrGetUSEMAP( nod )      TY_(AttrGetById)( nod, TidyAttr_USEMAP  )
#define attrGetISMAP( nod )       TY_(AttrGetById)( nod, TidyAttr_ISMAP  )
#define attrGetLANGUAGE( nod )    TY_(AttrGetById)( nod, TidyAttr_LANGUAGE  )
#define attrGetTYPE( nod )        TY_(AttrGetById)( nod, TidyAttr_TYPE  )
#define attrGetVALUE( nod )       TY_(AttrGetById)( nod, TidyAttr_VALUE  )
#define attrGetCONTENT( nod )     TY_(AttrGetById)( nod, TidyAttr_CONTENT  )
#define attrGetTITLE( nod )       TY_(AttrGetById)( nod, TidyAttr_TITLE  )
#define attrGetXMLNS( nod )       TY_(AttrGetById)( nod, TidyAttr_XMLNS  )
#define attrGetDATAFLD( nod )     TY_(AttrGetById)( nod, TidyAttr_DATAFLD  )
#define attrGetWIDTH( nod )       TY_(AttrGetById)( nod, TidyAttr_WIDTH  )
#define attrGetHEIGHT( nod )      TY_(AttrGetById)( nod, TidyAttr_HEIGHT  )
#define attrGetFOR( nod )         TY_(AttrGetById)( nod, TidyAttr_FOR  )
#define attrGetSELECTED( nod )    TY_(AttrGetById)( nod, TidyAttr_SELECTED  )
#define attrGetCHARSET( nod )     TY_(AttrGetById)( nod, TidyAttr_CHARSET  )
#define attrGetCHECKED( nod )     TY_(AttrGetById)( nod, TidyAttr_CHECKED  )
#define attrGetLANG( nod )        TY_(AttrGetById)( nod, TidyAttr_LANG  )
#define attrGetTARGET( nod )      TY_(AttrGetById)( nod, TidyAttr_TARGET  )
#define attrGetHTTP_EQUIV( nod )  TY_(AttrGetById)( nod, TidyAttr_HTTP_EQUIV  )
#define attrGetREL( nod )         TY_(AttrGetById)( nod, TidyAttr_REL  )

#define attrGetOnMOUSEMOVE( nod ) TY_(AttrGetById)( nod, TidyAttr_OnMOUSEMOVE  )
#define attrGetOnMOUSEDOWN( nod ) TY_(AttrGetById)( nod, TidyAttr_OnMOUSEDOWN  )
#define attrGetOnMOUSEUP( nod )   TY_(AttrGetById)( nod, TidyAttr_OnMOUSEUP  )
#define attrGetOnCLICK( nod )     TY_(AttrGetById)( nod, TidyAttr_OnCLICK  )
#define attrGetOnMOUSEOVER( nod ) TY_(AttrGetById)( nod, TidyAttr_OnMOUSEOVER  )
#define attrGetOnMOUSEOUT( nod )  TY_(AttrGetById)( nod, TidyAttr_OnMOUSEOUT  )
#define attrGetOnKEYDOWN( nod )   TY_(AttrGetById)( nod, TidyAttr_OnKEYDOWN  )
#define attrGetOnKEYUP( nod )     TY_(AttrGetById)( nod, TidyAttr_OnKEYUP  )
#define attrGetOnKEYPRESS( nod )  TY_(AttrGetById)( nod, TidyAttr_OnKEYPRESS  )
#define attrGetOnFOCUS( nod )     TY_(AttrGetById)( nod, TidyAttr_OnFOCUS  )
#define attrGetOnBLUR( nod )      TY_(AttrGetById)( nod, TidyAttr_OnBLUR  )

#define attrGetBGCOLOR( nod )     TY_(AttrGetById)( nod, TidyAttr_BGCOLOR  )

#define attrGetLINK( nod )        TY_(AttrGetById)( nod, TidyAttr_LINK  )
#define attrGetALINK( nod )       TY_(AttrGetById)( nod, TidyAttr_ALINK  )
#define attrGetVLINK( nod )       TY_(AttrGetById)( nod, TidyAttr_VLINK  )

#define attrGetTEXT( nod )        TY_(AttrGetById)( nod, TidyAttr_TEXT  )
#define attrGetSTYLE( nod )       TY_(AttrGetById)( nod, TidyAttr_STYLE  )
#define attrGetABBR( nod )        TY_(AttrGetById)( nod, TidyAttr_ABBR  )
#define attrGetCOLSPAN( nod )     TY_(AttrGetById)( nod, TidyAttr_COLSPAN  )
#define attrGetFONT( nod )        TY_(AttrGetById)( nod, TidyAttr_FONT  )
#define attrGetBASEFONT( nod )    TY_(AttrGetById)( nod, TidyAttr_BASEFONT  )
#define attrGetROWSPAN( nod )     TY_(AttrGetById)( nod, TidyAttr_ROWSPAN  )

#define attrGetROLE( nod )        TY_(AttrGetById)( nod, TidyAttr_ROLE  )

#define attrGetARIA_ACTIVEDESCENDANT( nod ) TY_(AttrGetById)( nod,  TidyAttr_ARIA_ACTIVEDESCENDANT  )
#define attrGetARIA_ATOMIC( nod )           TY_(AttrGetById)( nod,  TidyAttr_ARIA_ATOMIC  )
#define attrGetARIA_AUTOCOMPLETE( nod )     TY_(AttrGetById)( nod,  TidyAttr_ARIA_AUTOCOMPLETE  )
#define attrGetARIA_BUSY( nod )             TY_(AttrGetById)( nod,  TidyAttr_ARIA_BUSY  )
#define attrGetARIA_CHECKED( nod )          TY_(AttrGetById)( nod,  TidyAttr_ARIA_CHECKED  )
#define attrGetARIA_CONTROLS( nod )         TY_(AttrGetById)( nod,  TidyAttr_ARIA_CONTROLS  )
#define attrGetARIA_DESCRIBEDBY( nod )      TY_(AttrGetById)( nod,  TidyAttr_ARIA_DESCRIBEDBY  )
#define attrGetARIA_DISABLED( nod )         TY_(AttrGetById)( nod,  TidyAttr_ARIA_DISABLED  )
#define attrGetARIA_DROPEFFECT( nod )       TY_(AttrGetById)( nod,  TidyAttr_ARIA_DROPEFFECT  )
#define attrGetARIA_EXPANDED( nod )         TY_(AttrGetById)( nod,  TidyAttr_ARIA_EXPANDED  )
#define attrGetARIA_FLOWTO( nod )           TY_(AttrGetById)( nod,  TidyAttr_ARIA_FLOWTO  )
#define attrGetARIA_GRABBED( nod )          TY_(AttrGetById)( nod,  TidyAttr_ARIA_GRABBED  )
#define attrGetARIA_HASPOPUP( nod )         TY_(AttrGetById)( nod,  TidyAttr_ARIA_HASPOPUP  )
#define attrGetARIA_HIDDEN( nod )           TY_(AttrGetById)( nod,  TidyAttr_ARIA_HIDDEN  )
#define attrGetARIA_INVALID( nod )          TY_(AttrGetById)( nod,  TidyAttr_ARIA_INVALID  )
#define attrGetARIA_LABEL( nod )            TY_(AttrGetById)( nod,  TidyAttr_ARIA_LABEL  )
#define attrGetARIA_LABELLEDBY( nod )       TY_(AttrGetById)( nod,  TidyAttr_ARIA_LABELLEDBY  )
#define attrGetARIA_LEVEL( nod )            TY_(AttrGetById)( nod,  TidyAttr_ARIA_LEVEL  )
#define attrGetARIA_LIVE( nod )             TY_(AttrGetById)( nod,  TidyAttr_ARIA_LIVE  )
#define attrGetARIA_MULTILINE( nod )        TY_(AttrGetById)( nod,  TidyAttr_ARIA_MULTILINE  )
#define attrGetARIA_MULTISELECTABLE( nod )  TY_(AttrGetById)( nod,  TidyAttr_ARIA_MULTISELECTABLE  )
#define attrGetARIA_ORIENTATION( nod )      TY_(AttrGetById)( nod,  TidyAttr_ARIA_ORIENTATION  )
#define attrGetARIA_OWNS( nod )             TY_(AttrGetById)( nod,  TidyAttr_ARIA_OWNS  )
#define attrGetARIA_POSINSET( nod )         TY_(AttrGetById)( nod,  TidyAttr_ARIA_POSINSET  )
#define attrGetARIA_PRESSED( nod )          TY_(AttrGetById)( nod,  TidyAttr_ARIA_PRESSED  )
#define attrGetARIA_READONLY( nod )         TY_(AttrGetById)( nod,  TidyAttr_ARIA_READONLY  )
#define attrGetARIA_RELEVANT( nod )         TY_(AttrGetById)( nod,  TidyAttr_ARIA_RELEVANT  )
#define attrGetARIA_REQUIRED( nod )         TY_(AttrGetById)( nod,  TidyAttr_ARIA_REQUIRED  )
#define attrGetARIA_SELECTED( nod )         TY_(AttrGetById)( nod,  TidyAttr_ARIA_SELECTED  )
#define attrGetARIA_SETSIZE( nod )          TY_(AttrGetById)( nod,  TidyAttr_ARIA_SETSIZE  )
#define attrGetARIA_SORT( nod )             TY_(AttrGetById)( nod,  TidyAttr_ARIA_SORT  )
#define attrGetARIA_VALUEMAX( nod )         TY_(AttrGetById)( nod,  TidyAttr_ARIA_VALUEMAX  )
#define attrGetARIA_VALUEMIN( nod )         TY_(AttrGetById)( nod,  TidyAttr_ARIA_VALUEMIN  )
#define attrGetARIA_VALUENOW( nod )         TY_(AttrGetById)( nod,  TidyAttr_ARIA_VALUENOW  )
#define attrGetARIA_VALUETEXT( nod )        TY_(AttrGetById)( nod,  TidyAttr_ARIA_VALUETEXT  )

#endif /* __ATTRS_H__ */
/* charsets.h -- character set information and mappings

  (c) 1998-2006 (W3C) MIT, ERCIM, Keio University
  See tidy.h for the copyright notice.

*/

unsigned int TY_(GetEncodingIdFromName)(ctmbstr name);
unsigned int TY_(GetEncodingIdFromCodePage)(unsigned int cp);
unsigned int TY_(GetEncodingCodePageFromName)(ctmbstr name);
unsigned int TY_(GetEncodingCodePageFromId)(unsigned int id);
ctmbstr TY_(GetEncodingNameFromId)(unsigned int id);
ctmbstr TY_(GetEncodingNameFromCodePage)(unsigned int cp);
#ifndef __CLEAN_H__
#define __CLEAN_H__

/* clean.h -- clean up misuse of presentation markup

  (c) 1998-2006 (W3C) MIT, ERCIM, Keio University
  See tidy.h for the copyright notice.

*/

void TY_(FixNodeLinks)(Node *node);

void TY_(FreeStyles)( TidyDocImpl* doc );

/* Add class="foo" to node
*/
void TY_(AddStyleAsClass)( TidyDocImpl* doc, Node *node, ctmbstr stylevalue );
void TY_(AddStyleProperty)(TidyDocImpl* doc, Node *node, ctmbstr property );

void TY_(CleanDocument)( TidyDocImpl* doc );

/* simplifies <b><b> ... </b> ...</b> etc. */
void TY_(NestedEmphasis)( TidyDocImpl* doc, Node* node );

/* replace i by em and b by strong */
void TY_(EmFromI)( TidyDocImpl* doc, Node* node );

/*
 Some people use dir or ul without an li
 to indent the content. The pattern to
 look for is a list with a single implicit
 li. This is recursively replaced by an
 implicit blockquote.
*/
void TY_(List2BQ)( TidyDocImpl* doc, Node* node );

/*
 Replace implicit blockquote by div with an indent
 taking care to reduce nested blockquotes to a single
 div with the indent set to match the nesting depth
*/
void TY_(BQ2Div)( TidyDocImpl* doc, Node* node );


void TY_(DropSections)( TidyDocImpl* doc, Node* node );


/*
 This is a major clean up to strip out all the extra stuff you get
 when you save as web page from Word 2000. It doesn't yet know what
 to do with VML tags, but these will appear as errors unless you
 declare them as new tags, such as o:p which needs to be declared
 as inline.
*/
void TY_(CleanWord2000)( TidyDocImpl* doc, Node *node);

Bool TY_(IsWord2000)( TidyDocImpl* doc );

/* where appropriate move object elements from head to body */
void TY_(BumpObject)( TidyDocImpl* doc, Node *html );

Bool TY_(TidyMetaCharset)(TidyDocImpl* doc);

void TY_(DropComments)(TidyDocImpl* doc, Node* node);
void TY_(DropFontElements)(TidyDocImpl* doc, Node* node, Node **pnode);
void TY_(WbrToSpace)(TidyDocImpl* doc, Node* node);
void TY_(DowngradeTypography)(TidyDocImpl* doc, Node* node);
void TY_(ReplacePreformattedSpaces)(TidyDocImpl* doc, Node* node);
void TY_(NormalizeSpaces)(Lexer *lexer, Node *node);
void TY_(ConvertCDATANodes)(TidyDocImpl* doc, Node* node);

void TY_(FixAnchors)(TidyDocImpl* doc, Node *node, Bool wantName, Bool wantId);
void TY_(FixXhtmlNamespace)(TidyDocImpl* doc, Bool wantXmlns);
void TY_(FixLanguageInformation)(TidyDocImpl* doc, Node* node, Bool wantXmlLang, Bool wantLang);

/* Issue #567 - move style elements from body to head */
void TY_(CleanStyle)(TidyDocImpl* doc, Node *html);

#endif /* __CLEAN_H__ */
#ifndef __FILEIO_H__
#define __FILEIO_H__

/** @file fileio.h - does standard C I/O

  Implementation of a FILE* based TidyInputSource and 
  TidyOutputSink.

  (c) 1998-2007 (W3C) MIT, ERCIM, Keio University
  See tidy.h for the copyright notice.

*/

/* #include "tidybuffio.h" */
#ifdef __cplusplus
extern "C" {
#endif

/** Allocate and initialize file input source */
int TY_(initFileSource)( TidyAllocator *allocator, TidyInputSource* source, FILE* fp );

/** Free file input source */
void TY_(freeFileSource)( TidyInputSource* source, Bool closeIt );

#if SUPPORT_POSIX_MAPPED_FILES
/** Allocate and initialize file input source using Standard C I/O */
int TY_(initStdIOFileSource)( TidyAllocator *allocator, TidyInputSource* source, FILE* fp );

/** Free file input source using Standard C I/O */
void TY_(freeStdIOFileSource)( TidyInputSource* source, Bool closeIt );
#endif

/** Initialize file output sink */
void TY_(initFileSink)( TidyOutputSink* sink, FILE* fp );

/* Needed for internal declarations */
void TIDY_CALL TY_(filesink_putByte)( void* sinkData, byte bv );

#ifdef __cplusplus
}
#endif
#endif /* __FILEIO_H__ */
#ifndef __STREAMIO_H__
#define __STREAMIO_H__

/* streamio.h -- handles character stream I/O

  (c) 1998-2007 (W3C) MIT, ERCIM, Keio University
  See tidy.h for the copyright notice.

  Wrapper around Tidy input source and output sink
  that calls appropriate interfaces, and applies 
  necessary char encoding transformations: to/from
  ISO-10646 and/or UTF-8.

*/

/* #include "forward.h" */
/* #include "tidybuffio.h" */
/* #include "fileio.h" */

#ifdef __cplusplus
extern "C"
{
#endif
typedef enum
{
  FileIO,
  BufferIO,
  UserIO
} IOType;

/* states for ISO 2022

 A document in ISO-2022 based encoding uses some ESC sequences called
 "designator" to switch character sets. The designators defined and
 used in ISO-2022-JP are:

    "ESC" + "(" + ?     for ISO646 variants

    "ESC" + "$" + ?     and
    "ESC" + "$" + "(" + ?   for multibyte character sets
*/
typedef enum
{
  FSM_ASCII,
  FSM_ESC,
  FSM_ESCD,
  FSM_ESCDP,
  FSM_ESCP,
  FSM_NONASCII
} ISO2022State;

/************************
** Source
************************/

enum
{
    CHARBUF_SIZE=5,
    LASTPOS_SIZE=64
};

/* non-raw input is cleaned up*/
struct _StreamIn
{
    ISO2022State    state;     /* FSM for ISO2022 */
    Bool   pushed;
    TidyAllocator *allocator;
    tchar* charbuf;
    unsigned int   bufpos;
    unsigned int   bufsize;
    int    tabs;
    int    lastcols[LASTPOS_SIZE];
    unsigned short curlastpos; /* current last position in lastcols */ 
    unsigned short firstlastpos; /* first valid last position in lastcols */ 
    int    curcol;
    int    curline;
    int    encoding;
    IOType iotype;

    TidyInputSource source;

    /* Pointer back to document for error reporting */
    TidyDocImpl* doc;
};

StreamIn* TY_(initStreamIn)( TidyDocImpl* doc, int encoding );
void TY_(freeStreamIn)(StreamIn* in);

StreamIn* TY_(FileInput)( TidyDocImpl* doc, FILE* fp, int encoding );
StreamIn* TY_(BufferInput)( TidyDocImpl* doc, TidyBuffer* content, int encoding );
StreamIn* TY_(UserInput)( TidyDocImpl* doc, TidyInputSource* source, int encoding );

int       TY_(ReadBOMEncoding)(StreamIn *in);
unsigned int      TY_(ReadChar)( StreamIn* in );
void      TY_(UngetChar)( unsigned int c, StreamIn* in );
Bool      TY_(IsEOF)( StreamIn* in );


/************************
** Sink
************************/

struct _StreamOut
{
    int   encoding;
    ISO2022State   state;     /* for ISO 2022 */
    unsigned int  nl;
    IOType iotype;
    TidyOutputSink sink;
};

StreamOut* TY_(FileOutput)( TidyDocImpl *doc, FILE* fp, int encoding, unsigned int newln );
StreamOut* TY_(BufferOutput)( TidyDocImpl *doc, TidyBuffer* buf, int encoding, unsigned int newln );
StreamOut* TY_(UserOutput)( TidyDocImpl *doc, TidyOutputSink* sink, int encoding, unsigned int newln );

StreamOut* TY_(StdErrOutput)(void);
/* StreamOut* StdOutOutput(void); */
void       TY_(ReleaseStreamOut)( TidyDocImpl *doc, StreamOut* out );

void TY_(WriteChar)( unsigned int c, StreamOut* out );
void TY_(outBOM)( StreamOut *out );

ctmbstr TY_(GetEncodingNameFromTidyId)(unsigned int id);
ctmbstr TY_(GetEncodingOptNameFromTidyId)(unsigned int id);
int TY_(GetCharEncodingFromOptName)(ctmbstr charenc);

/************************
** Misc
************************/

/* character encodings
*/
#define RAW         0
#define ASCII       1
#define LATIN0      2
#define LATIN1      3
#define UTF8        4
#define ISO2022     5
#define MACROMAN    6
#define WIN1252     7
#define IBM858      8
#define UTF16LE     9
#define UTF16BE     10
#define UTF16       11
#define BIG5        12
#define SHIFTJIS    13

/* Function for conversion from Windows-1252 to Unicode */
unsigned int TY_(DecodeWin1252)(unsigned int c);

/* Function to convert from MacRoman to Unicode */
unsigned int TY_(DecodeMacRoman)(unsigned int c);

#ifdef __cplusplus
}
#endif


/* Use numeric constants as opposed to escape chars (\r, \n)
** to avoid conflict Mac compilers that may re-define these.
*/
/* #define '\r'    0xD */
/* #define '\n'    0xA */

#if defined(MAC_OS_CLASSIC)
#  define DEFAULT_NL_CONFIG TidyCR
#elif defined(_WIN32) || defined(OS2_OS)
#  define DEFAULT_NL_CONFIG TidyCRLF
#else
#  define DEFAULT_NL_CONFIG TidyLF
#endif


#endif /* __STREAMIO_H__ */
#ifndef __CONFIG_H__
#define __CONFIG_H__

/**************************************************************************//**
 * @file
 * Read configuration files and manage configuration properties.
 *
 * Config files associate a property name with a value.
 *
 * // comments can start at the beginning of a line
 * # comments can start at the beginning of a line
 * name: short values fit onto one line
 * name: a really long value that
 *  continues on the next line
 *
 * Property names are case insensitive and should be less than 60 characters
 * in length, and must start at the begining of the line, as whitespace at
 * the start of a line signifies a line continuation.
 *
 * @author  HTACG, et al (consult git log)
 * 
 * @copyright
 *     Copyright (c) 1998-2017 World Wide Web Consortium (Massachusetts
 *     Institute of Technology, European Research Consortium for Informatics
 *     and Mathematics, Keio University) and HTACG.
 * @par
 *     All Rights Reserved.
 * @par
 *     See `tidy.h` for the complete license.
 *
 * @date Additional updates: consult git log
 *
 ******************************************************************************/

/* #include "forward.h" */
/* #include "tidy.h" */
/* #include "streamio.h" */

/** @addtogroup internal_api */
/** @{ */


/***************************************************************************//**
 ** @defgroup configuration_options Configuration Options
 **
 ** This module organizes all of Tidy's configuration options, including
 ** picklist management, option setting and retrieval, option file utilities,
 ** and so on.
 **
 ** @{
 ******************************************************************************/


/** Determines the maximum number of items in an option's picklist. PickLists
 ** may have up to 16 items. For some reason, this limit has been hard-coded
 ** into Tidy for some time. Feel free to increase this as needed.
 */
#define TIDY_PL_SIZE 16


/** Structs of this type contain information needed in order to present
 ** picklists, relate picklist entries to public enum values, and parse
 ** strings that are accepted in order to assign the value.
 */
typedef struct PickListItem {
    ctmbstr label;      /**< PickList label for this item. */
    const int value;    /**< The option value represented by this label. */
    ctmbstr inputs[10]; /**< String values that can select this value. */
} PickListItem;


/** An array of PickListItems, fixed in size for in-code declarations. 
 ** Arrays must be populated in 0 to 10 order, as the option value is assigned
 ** based on this index and *not* on the structures' value field. It remains
 ** a best practice, however, to assign a public enum value with the proper
 ** index value.
 */
typedef const PickListItem PickListItems[TIDY_PL_SIZE];


struct _tidy_option; /* forward */

/** The TidyOptionImpl type implements the `_tidy_option` structure.
 */
typedef struct _tidy_option TidyOptionImpl;


/** This typedef describes a function that is used for parsing the input
 ** given for a particular Tidy option.
 */
typedef Bool (ParseProperty)( TidyDocImpl* doc, const TidyOptionImpl* opt );


/** This structure defines the internal representation of a Tidy option.
 */
struct _tidy_option
{
    TidyOptionId        id;              /**< The unique identifier for this option. */
    TidyConfigCategory  category;        /**< The category of the option. */
    ctmbstr             name;            /**< The name of the option. */
    TidyOptionType      type;            /**< The date type for the option. */
    unsigned int               dflt;            /**< Default value for TidyInteger and TidyBoolean */
    ParseProperty*      parser;          /**< Function to parse input; read-only if NULL. */
    PickListItems*      pickList;        /**< The picklist of possible values for this option. */
    ctmbstr             pdflt;           /**< Default value for TidyString. */
};


/** Stored option values can be one of two internal types.
 */
typedef union
{
  unsigned int v;  /**< Value for TidyInteger and TidyBoolean */
  char *p;  /**< Value for TidyString */
} TidyOptionValue;


/** This type is used to define a structure for keeping track of the values
 ** for each option.
 */
typedef struct _tidy_config
{
    TidyOptionValue value[ N_TIDY_OPTIONS + 1 ];     /**< Current config values. */
    TidyOptionValue snapshot[ N_TIDY_OPTIONS + 1 ];  /**< Snapshot of values to be restored later. */
    unsigned int  defined_tags;                              /**< Tracks user-defined tags. */
    unsigned int c;                                          /**< Current char in input stream for reading options. */
    StreamIn* cfgIn;                                 /**< Current input source for reading options.*/
} TidyConfigImpl;


/** Used to build a table of documentation cross-references.
 */
typedef struct {
  TidyOptionId opt;          /**< Identifier. */
  TidyOptionId const *links; /**< Cross references. Last element must be 'TidyUnknownOption'. */
} TidyOptionDoc;


/** Given an option name, return an instance of an option.
 ** @param optnam The option name to retrieve.
 ** @returns The instance of the requested option.
 */
const TidyOptionImpl* TY_(lookupOption)( ctmbstr optnam );


/** Given an option ID, return an instance of an option.
 ** @param optId The option ID to retrieve.
 ** @returns The instance of the requested option.
 */
const TidyOptionImpl* TY_(getOption)( TidyOptionId optId );

/** Given an option ID, indicates whether or not the option is a list.
 ** @param optId The option ID to check.
 ** @returns Returns yes if the option value is a list.
 */
const Bool TY_(getOptionIsList)( TidyOptionId optId );

/** Initiates an iterator to cycle through all of the available options.
 ** @param doc The Tidy document to get options.
 ** @returns An iterator token to be used with TY_(getNextOption)().
 */
TidyIterator TY_(getOptionList)( TidyDocImpl* doc );


/** Gets the next option provided by the iterator.
 ** @param doc The Tidy document to get options.
 ** @param iter The iterator token initialized by TY_(getOptionList)().
 ** @returns The instance of the next option.
 */
const TidyOptionImpl* TY_(getNextOption)( TidyDocImpl* doc, TidyIterator* iter );


/** Initiates an iterator to cycle through all of the available picklist
 ** possibilities.
 ** @param option An instance of an option for which to iterate a picklist.
 ** @returns An interator token to be used with TY_(getNextOptionPick)().
 */
TidyIterator TY_(getOptionPickList)( const TidyOptionImpl* option );


/** Gets the next picklist possibility provided by the iterator.
 ** @param option The instance of the option for which to iterate a picklist.
 ** @param iter The iterator token initialized by TY_(getOptionPickList)().
 ** @returns The next picklist entry.
 */
ctmbstr TY_(getNextOptionPick)( const TidyOptionImpl* option, TidyIterator* iter );


#if SUPPORT_CONSOLE_APP
/** Returns the cross-reference information structure for optID, which is
 ** used for generating documentation.
 ** @param optId The option ID to get cross-reference information for.
 ** @returns Cross reference information.
 */
const TidyOptionDoc* TY_(OptGetDocDesc)( TidyOptionId optId );
#endif /* SUPPORT_CONSOLE_APP */


/** Initialize the configuration for the given Tidy document.
 ** @param doc The Tidy document.
 */
void TY_(InitConfig)( TidyDocImpl* doc );


/** Frees the configuration memory for the given Tidy document.
 ** @param doc The Tidy document.
 */
void TY_(FreeConfig)( TidyDocImpl* doc );


/** Gets the picklist label for a given value.
 ** @param optId the option id having a picklist to check.
 ** @param pick the picklist item to retrieve.
 ** @returns The label for the pick.
 */
ctmbstr TY_(GetPickListLabelForPick)( TidyOptionId optId, unsigned int pick );


/** Sets the integer value for the given option Id.
 ** @param doc The Tidy document.
 ** @param optId The option ID to set.
 ** @param val The value to set.
 ** @returns Success or failure.
 */
Bool TY_(SetOptionInt)( TidyDocImpl* doc, TidyOptionId optId, unsigned int val );


/** Sets the bool value for the given option Id.
 ** @param doc The Tidy document.
 ** @param optId The option ID to set.
 ** @param val The value to set.
 ** @returns Success or failure.
 */
Bool TY_(SetOptionBool)( TidyDocImpl* doc, TidyOptionId optId, Bool val );


/** Resets the given option to its default value.
 ** @param doc The Tidy document.
 ** @param optId The option ID to set.
 ** @returns Success or failure.
 */
Bool TY_(ResetOptionToDefault)( TidyDocImpl* doc, TidyOptionId optId );


/** Resets all options in the document to their default values.
 ** @param doc The Tidy document.
 */
void TY_(ResetConfigToDefault)( TidyDocImpl* doc );


/** Stores a snapshot of all of the configuration values that can be
 ** restored later.
 ** @param doc The Tidy document.
 */
void TY_(TakeConfigSnapshot)( TidyDocImpl* doc );


/** Restores all of the configuration values to their snapshotted values.
 ** @param doc The Tidy document.
 */
void TY_(ResetConfigToSnapshot)( TidyDocImpl* doc );


/** Copies the configuration from one document to another.
 ** @param docTo The destination Tidy document.
 ** @param docFrom The source Tidy document.
 */
void TY_(CopyConfig)( TidyDocImpl* docTo, TidyDocImpl* docFrom );


/** Attempts to parse the given config file into the document.
 ** @param doc The Tidy document.
 ** @param cfgfil The file to load.
 ** @returns a file system error code.
 */
int  TY_(ParseConfigFile)( TidyDocImpl* doc, ctmbstr cfgfil );


/** Attempts to parse the given config file into the document, using
 ** the provided encoding.
 ** @param doc The Tidy document.
 ** @param cfgfil The file to load.
 ** @param charenc The name of the encoding to use for reading the file.
 ** @returns a file system error code.
 */
int  TY_(ParseConfigFileEnc)( TidyDocImpl* doc,
                              ctmbstr cfgfil, ctmbstr charenc );


/** Saves the current configuration for options not having default values
 ** into the specified file.
 ** @param doc The Tidy document.
 ** @param cfgfil The file to save.
 ** @returns a file system error code.
 */
int  TY_(SaveConfigFile)( TidyDocImpl* doc, ctmbstr cfgfil );


/** Writes the current configuration for options not having default values
 ** into the specified sink.
 ** @param doc The Tidy document.
 ** @param sink The sink to save into.
 ** @returns a file system error code.
 */
int  TY_(SaveConfigSink)( TidyDocImpl* doc, TidyOutputSink* sink );


/** Attempts to parse the provided value for the given option name. Returns
 ** false if unknown option, missing parameter, or the option doesn't
 ** use the parameter.
 ** @param doc The Tidy document.
 ** @param optnam The name of the option to be set.
 ** @param optVal The string value to attempt to parse.
 ** @returns Success or failure.
 */
Bool  TY_(ParseConfigOption)( TidyDocImpl* doc, ctmbstr optnam, ctmbstr optVal );


/** Attempts to parse the provided value for the given option id. Returns
 ** false if unknown option, missing parameter, or the option doesn't
 ** use the parameter.
 ** @param doc The Tidy document.
 ** @param optId The ID of the option to be set.
 ** @param optVal The string value to attempt to parse.
 ** @returns Success or failure.
 */
Bool  TY_(ParseConfigValue)( TidyDocImpl* doc, TidyOptionId optId, ctmbstr optVal );


/** Ensure that char encodings are self consistent.
 ** @param doc The Tidy document to adjust.
 ** @param encoding The encoding being applied.
 ** @returns A bool indicating success or failure.
 */
Bool  TY_(AdjustCharEncoding)( TidyDocImpl* doc, int encoding );


/** Indicates whether or not the current configuration is completely default.
 ** @param doc The Tidy document.
 ** @returns The result.
 */
Bool  TY_(ConfigDiffThanDefault)( TidyDocImpl* doc );


/** Indicates whether or not the current configuration is different from the
 ** stored snapshot.
 ** @param doc The Tidy document.
 ** @returns The result.
 */
Bool  TY_(ConfigDiffThanSnapshot)( TidyDocImpl* doc );


/** Returns the character encoding ID for the given character encoding
 ** string.
 ** @param doc The Tidy document.
 ** @param charenc The name of the character encoding.
 ** @returns The Id of the character encoding.
 */
int TY_(CharEncodingId)( TidyDocImpl* doc, ctmbstr charenc );


/** Returns the full name of the encoding for the given ID.
 ** @param encoding The Id of the encoding.
 ** @returns The name of the character encoding.
 */
ctmbstr TY_(CharEncodingName)( int encoding );


/** Returns the Tidy command line option name of the encoding for the given ID.
 ** @param encoding The Id of the encoding.
 ** @returns The Tidy command line option representing the encoding.
 */
ctmbstr TY_(CharEncodingOptName)( int encoding );


/** Coordinates Config update and list data.
 ** @param doc The Tidy document.
 ** @param opt The option the list item is intended for.
 ** @param name The name of the new list item.
 */
void TY_(DeclareListItem)( TidyDocImpl* doc, const TidyOptionImpl* opt, ctmbstr name );

#ifdef _DEBUG

/* Debug lookup functions will be type-safe and assert option type match */
unsigned int   TY_(_cfgGet)( TidyDocImpl* doc, TidyOptionId optId );
Bool    TY_(_cfgGetBool)( TidyDocImpl* doc, TidyOptionId optId );
TidyTriState TY_(_cfgGetAutoBool)( TidyDocImpl* doc, TidyOptionId optId );
ctmbstr TY_(_cfgGetString)( TidyDocImpl* doc, TidyOptionId optId );

#define cfg(doc, id)            TY_(_cfgGet)( (doc), (id) )
#define cfgBool(doc, id)        TY_(_cfgGetBool)( (doc), (id) )
#define cfgAutoBool(doc, id)    TY_(_cfgGetAutoBool)( (doc), (id) )
#define cfgStr(doc, id)         TY_(_cfgGetString)( (doc), (id) )

#else

/* Release build macros for speed */

/** Access the raw, non-string unsigned int value of the given option ID. */
#define cfg(doc, id)            ((doc)->config.value[ (id) ].v)

/** Access the Bool value of the given option ID. */
#define cfgBool(doc, id)        ((Bool) cfg(doc, id))

/** Access the TidyTriState value of the given option ID. */
#define cfgAutoBool(doc, id)    ((TidyTriState) cfg(doc, id))

/** Access the string value of the given option ID. */
#define cfgStr(doc, id)         ((ctmbstr) (doc)->config.value[ (id) ].p)

#endif /* _DEBUG */


/** @} configuration_options group */
/** @} internal_api addtogroup */


#endif /* __CONFIG_H__ */
#ifndef __ENTITIES_H__
#define __ENTITIES_H__

/* entities.h -- recognize character entities

  (c) 1998-2006 (W3C) MIT, ERCIM, Keio University
  See tidy.h for the copyright notice.

*/

/* #include "forward.h" */

/* entity starting with "&" returns zero on error */
/* unsigned int    EntityCode( ctmbstr name, unsigned int versions ); */
ctmbstr TY_(EntityName)( unsigned int charCode, unsigned int versions );
Bool    TY_(EntityInfo)( ctmbstr name, Bool isXml, unsigned int* code, unsigned int* versions );

#endif /* __ENTITIES_H__ */
#ifndef __GDOC_H__
#define __GDOC_H__

/* gdoc.h -- clean up html exported by Google Docs

  (c) 2012 (W3C) MIT, ERCIM, Keio University
  See tidy.h for the copyright notice.

  - strip the script element, as the style sheet is a mess
  - strip class attributes
  - strip span elements, leaving their content in place
  - replace <a name=...></a> by id on parent element
  - strip empty <p> elements

*/

void TY_(CleanGoogleDocument)( TidyDocImpl* doc );

#endif /* __GDOC_H__ */
#ifndef language_h
#define language_h

/*********************************************************************
 * Localization support for HTML Tidy.
 *
 * This header provides the public (within libtidy) interface to
 * basic localization support. To add your own localization, create
 * a new `language_xx.h` file and add it to the struct in 
 * `language.c`.
 *
 * (c) 2015 HTACG
 * See `tidy.h` for the copyright notice.
 *********************************************************************/

/* #include "forward.h" */


/** @name Exposed Data Structures */
/** @{ */


/**
 *  These enumerations are used within instances of `languageDefinition`
 *  structures to provide additional metadata, and are localizable
 *  therein.
 */
typedef enum {
    
    /* Specifies the language code for a particular language. */
    TIDY_LANGUAGE = 400,
    
    /* Marker for the last key in the structure. */
    TIDY_MESSAGE_TYPE_LAST
    
} tidyLanguage;


/**
 *  Describes a record for a localization string.
 *  - key must correspond with one of Tidy's enums (see `tidyMessageTypes`
 *    below)
 *  - pluralForm corresponds to gettext plural forms case (not singularity).
 *    Most entries should be case 0, representing the single case.:
 *    https://www.gnu.org/software/gettext/manual/html_node/Plural-forms.html
 */
typedef struct languageDictionaryEntry {
    unsigned int key;
    unsigned int pluralForm;
    ctmbstr value;
} languageDictionaryEntry;


/**
 *  For now we'll just use an array to hold all of the dictionary
 *  entries. In the future we can convert this to a hash structure
 *  which will make looking up strings faster.
 */
typedef languageDictionaryEntry const languageDictionary[600];


/**
 *  Finally, a complete language definition. The item `pluralForm`
 *  is a function pointer that will provide the correct plural
 *  form given the value `n`. The actual function is present in
 *  each language header and is language dependent.
 */
typedef struct languageDefinition {
    unsigned int (*whichPluralForm)(unsigned int n);
    languageDictionary messages;
} languageDefinition;


/**
 *  The function getNextWindowsLanguage() returns pointers to this type;
 *  it gives LibTidy implementors the ability to determine how Windows
 *  locale names are mapped to POSIX language codes.
 */
typedef struct tidyLocaleMapItemImpl {
    ctmbstr winName;
    ctmbstr POSIXName;
} tidyLocaleMapItemImpl;


/** @} */
/** @name Localization Related Functions */
/** @{ */


/**
 **  Determines the current locale without affecting the C locale.
 **  Tidy has always used the default C locale, and at this point
 **  in its development we're not going to tamper with that.
 **  @param  result The buffer to use to return the string.
 **          Returns NULL on failure.
 **  @return The same buffer for convenience.
 */
tmbstr TY_(tidySystemLocale)(tmbstr result);

/**
 *  Tells Tidy to use a different language for output.
 *  @param  languageCode A Windows or POSIX language code, and must match
 *          a TIDY_LANGUAGE for an installed language.
 *  @result Indicates that a setting was applied, but not necessarily the
 *          specific request, i.e., true indicates a language and/or region
 *          was applied. If es_mx is requested but not installed, and es is
 *          installed, then es will be selected and this function will return
 *          true. However the opposite is not true; if es is requested but
 *          not present, Tidy will not try to select from the es_XX variants.
 */
Bool TY_(tidySetLanguage)( ctmbstr languageCode );

/**
 *  Gets the current language used by Tidy.
 */
ctmbstr TY_(tidyGetLanguage)(void);


/**
 *  Indicates whether or not the current language was set by a
 *  LibTidy user or internally by the library. This flag prevents
 *  subsequently created instances of TidyDocument from changing the
 *  user's language.
 *  @returns Returns yes to indicate that the current language was
 *    specified by an API user.
 */
Bool TY_(tidyGetLanguageSetByUser)(void);


/**
 *  Specifies to LibTidy that the user (rather than the library)
 *  selected the current language. This flag prevents subsequently
 *  created instances of TidyDocument from changing the user's language.
 */
void TY_(tidySetLanguageSetByUser)( void );


/**
 *  Provides a string given `messageType` in the current
 *  localization for `quantity`.
 */
ctmbstr TY_(tidyLocalizedStringN)( unsigned int messageType, unsigned int quantity );

/**
 *  Provides a string given `messageType` in the current
 *  localization for the single case.
 */
ctmbstr TY_(tidyLocalizedString)( unsigned int messageType );


/** @} */
/** @name Documentation Generation */
/** @{ */


/**
 *  Provides a string given `messageType` in the default
 *  localization (which is `en`).
 */
ctmbstr TY_(tidyDefaultString)( unsigned int messageType );

/*
 *  Initializes the TidyIterator to point to the first item
 *  in Tidy's list of localization string keys. Note that
 *  these are provided for documentation generation purposes
 *  and probably aren't useful for LibTidy implementors.
 */
TidyIterator TY_(getStringKeyList)(void);

/*
 *  Provides the next key value in Tidy's list of localized
 *  strings. Note that these are provided for documentation
 *  generation purposes and probably aren't useful to
 *  libtidy implementors.
 */
unsigned int TY_(getNextStringKey)( TidyIterator* iter );

/**
 *  Initializes the TidyIterator to point to the first item
 *  in Tidy's structure of Windows<->POSIX local mapping.
 *  Items can be retrieved with getNextWindowsLanguage();
 */
TidyIterator TY_(getWindowsLanguageList)(void);

/**
 *  Returns the next record of type `localeMapItem` in
 *  Tidy's structure of Windows<->POSIX local mapping.
 */
const tidyLocaleMapItemImpl *TY_(getNextWindowsLanguage)( TidyIterator* iter );

/**
 *  Given a `tidyLocaleMapItemImpl, return the Windows name.
 */
ctmbstr TY_(TidyLangWindowsName)( const tidyLocaleMapItemImpl *item );

/**
 *  Given a `tidyLocaleMapItemImpl, return the POSIX name.
 */
ctmbstr TY_(TidyLangPosixName)( const tidyLocaleMapItemImpl *item );

/**
 *  Initializes the TidyIterator to point to the first item
 *  in Tidy's list of installed language codes.
 *  Items can be retrieved with getNextInstalledLanguage();
 */
TidyIterator TY_(getInstalledLanguageList)(void);

/**
 *  Returns the next installed language.
 */
ctmbstr TY_(getNextInstalledLanguage)( TidyIterator* iter );


/** @} */

#endif /* language_h */
#ifndef language_en_h
#define language_en_h
/*
 * language_en.h
 * Localization support for HTML Tidy.
 *
 * This file consists of the strings for Tidy's base language and is a
 * required localization for Tidy to compile and work. Unlike the other
 * localization files this file is NOT machine-generated.
 *
 * This file also serves as the master template for generating additional
 * language localizations. As such do not edit PO files for this language;
 * modify this file directly.
 *
 * (c) 2015-2017 HTACG
 * See tidy.h and access.h for the copyright notice.
 *
 * Created by Jim Derry on 11/28/15.
 */

#ifdef _MSC_VER
#pragma execution_character_set("utf-8")
#endif


/**
 *  This language-specific function returns the correct pluralForm
 *  to use given n items, and is used as a member of each language
 *  definition.
 */
static unsigned int whichPluralForm_en(unsigned int n) {
    /* Plural-Forms: nplurals=2; */
    return n != 1;
}


/**
 *  This structure specifies all of the strings needed by Tidy for a
 *  single language. Static definition in a header file makes it
 *  easy to include and exclude languages without tinkering with
 *  the build system.
 *
 *  This file serves as the master template for generating `gettext`
 *  PO and POT files using our `potool.rb` script. Certain comments
 *  entered below will be included in the PO/POT files as developer
 *  comments. To enable this, use only standard C-style comments that
 *  begin immediately after the opening brace without whitespace.
 */

static languageDefinition language_en = { whichPluralForm_en, {
    /***************************************
     ** This MUST be present and first.
     ** Specify the code for this language.
     ***************************************/
    {/* Specify the ll or ll_cc language code here. */
      TIDY_LANGUAGE,                0,   "en"
    },

    /*********************************************************************
     ** Options Documentation
     **  As of 2016-January these descriptions are used uniquely by the
     **  console application but are made available for LibTidy users as
     **  well. Because we generate documentation from these descriptions
     **  it's important to use ONLY the following tags:
     **    <code>, <em>, <strong>, <br/>, <p>
     **  Note that the xslt processor requires <br/> to be self closing!
     ** @remark enum source is TidyOptionId
     *********************************************************************/
    {/* Important notes for translators:
        - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
          <br/>.
        - Entities, tags, attributes, etc., should be enclosed in <code></code>.
        - Option values should be enclosed in <var></var>.
        - It's very important that <br/> be self-closing!
        - The strings "Tidy" and "HTML Tidy" are the program name and must not
          be translated. */
      TidyAccessibilityCheckLevel,  0,
        "This option specifies what level of accessibility checking, if any, "
        "that Tidy should perform. "
        "<br/>"
        "Level <var>0 (Tidy Classic)</var> is equivalent to Tidy Classic's accessibility "
        "checking. "
        "<br/>"
        "For more information on Tidy's accessibility checking, visit "
        "<a href=\"http://www.html-tidy.org/accessibility/\"> Tidy's Accessibility Page</a>. "
    },
    {/* Important notes for translators:
        - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
          <br/>.
        - Entities, tags, attributes, etc., should be enclosed in <code></code>.
        - Option values should be enclosed in <var></var>.
        - It's very important that <br/> be self-closing!
        - The strings "Tidy" and "HTML Tidy" are the program name and must not
          be translated. */
      TidyAltText,                  0,
        "This option specifies the default <code>alt=</code> text Tidy uses for "
        "<code>&lt;img&gt;</code> attributes when the <code>alt=</code> attribute "
        "is missing. "
        "<br/>"
        "Use with care, as it is your responsibility to make your documents accessible "
        "to people who cannot see the images. "
    },
    {/* Important notes for translators:
        - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
          <br/>.
        - Entities, tags, attributes, etc., should be enclosed in <code></code>.
        - Option values should be enclosed in <var></var>.
        - It's very important that <br/> be self-closing!
        - The strings "Tidy" and "HTML Tidy" are the program name and must not
          be translated. */
      TidyAnchorAsName,             0,
        "This option controls the deletion or addition of the <code>name</code> "
        "attribute in elements where it can serve as anchor. "
        "<br/>"
        "If set to <var>yes</var> a <code>name</code> attribute, if not already "
        "existing, is added along an existing <code>id</code> attribute if the DTD "
        "allows it. "
        "<br/>"
        "If set to <var>no</var> any existing name attribute is removed if an "
        "<code>id</code> attribute exists or has been added. "
    },
    {/* Important notes for translators:
        - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
          <br/>.
        - Entities, tags, attributes, etc., should be enclosed in <code></code>.
        - Option values should be enclosed in <var></var>.
        - It's very important that <br/> be self-closing!
        - The strings "Tidy" and "HTML Tidy" are the program name and must not
          be translated. */
      TidyAsciiChars,               0,
        "Can be used to modify behavior of the <code>clean</code> option when set "
        "to <var>yes</var>. "
        "<br/>"
        "If set to <var>yes</var> when using <code>clean</code>, "
        "<code>&amp;emdash;</code>, <code>&amp;rdquo;</code>, and other named "
        "character entities are downgraded to their closest ASCII equivalents. "
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidyBlockTags,                0,
        "This option specifies new block-level tags. This option takes a space or "
        "comma separated list of tag names. "
        "<br/>"
        "Unless you declare new tags, Tidy will refuse to generate a tidied file if "
        "the input includes previously unknown tags. "
        "<br/>"
        "Note you can't change the content model for elements such as "
        "<code>&lt;table&gt;</code>, <code>&lt;ul&gt;</code>, "
        "<code>&lt;ol&gt;</code> and <code>&lt;dl&gt;</code>. "
        "<br/>"
        "This option is ignored in XML mode. "
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidyBodyOnly,                 0,
        "This option specifies if Tidy should print only the contents of the "
        "body tag as an HTML fragment. "
        "<br/>"
        "If set to <var>auto</var>, this is performed only if the body tag has "
        "been inferred. "
        "<br/>"
        "Useful for incorporating existing whole pages as a portion of another "
        "page. "
        "<br/>"
        "This option has no effect if XML output is requested. "
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidyBreakBeforeBR,            0,
        "This option specifies if Tidy should output a line break before each "
        "<code>&lt;br&gt;</code> element. "
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidyCharEncoding,             0,
        "This option specifies the character encoding Tidy uses for input, and "
        "when set, automatically chooses an appropriate character encoding to "
        "be used for output. The output encoding Tidy chooses may be different "
        "from the input encoding. "
        "<br/>"
        "For <var>ascii</var>, <var>latin0</var>, <var>ibm858</var>, "
        "<var>mac</var>, and <var>win1252</var> input encodings, the "
        "<code>output-encoding</code> option will automatically be set to "
        "<var>ascii</var>. You can set <code>output-encoding</code> manually "
        "to override this. "
        "<br/>"
        "For other input encodings, the <code>output-encoding</code> option "
        "will automatically be set to the the same value. "
        "<br/>"
        "Regardless of the preset value, you can set "
        "<code>output-encoding</code> manually to override this. "
        "<br/>"
        "Tidy is not an encoding converter. Although the Latin and UTF "
        "encodings can be mixed freely, it is not possible to convert Asian "
        "encodings to Latin encodings with Tidy. "
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidyCoerceEndTags,            0,
        "This option specifies if Tidy should coerce a start tag into an end tag "
        "in cases where it looks like an end tag was probably intended; "
        "for example, given "
        "<br/>"
        "<code>&lt;span&gt;foo &lt;b&gt;bar&lt;b&gt; baz&lt;/span&gt;</code> "
        "<br/>"
        "Tidy will output "
        "<br/>"
        "<code>&lt;span&gt;foo &lt;b&gt;bar&lt;/b&gt; baz&lt;/span&gt;</code> "
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidyCSSPrefix,                0,
        "This option specifies the prefix that Tidy uses for styles rules. "
        "<br/>"
        "By default, <var>c</var> will be used. "
    },
    {/* Important notes for translators:
        - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
          <br/>.
        - Entities, tags, attributes, etc., should be enclosed in <code></code>.
        - Option values should be enclosed in <var></var>.
        - It's very important that <br/> be self-closing!
        - The strings "Tidy" and "HTML Tidy" are the program name and must not
          be translated. */
      TidyDecorateInferredUL,       0,
        "This option specifies if Tidy should decorate inferred "
        "<code>&lt;ul&gt;</code> elements with some CSS markup to avoid indentation "
        "to the right. "
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidyDoctype,                  0,
        "This option specifies the DOCTYPE declaration generated by Tidy. "
        "<br/>"
        "If set to <var>omit</var> the output won't contain a DOCTYPE "
        "declaration. Note this this also implies <code>numeric-entities</code> is "
        "set to <var>yes</var>."
        "<br/>"
        "If set to <var>html5</var> the DOCTYPE is set to "
        "<code>&lt;!DOCTYPE html&gt;</code>."
        "<br/>"
        "If set to <var>auto</var> (the default) Tidy will use an educated guess "
        "based upon the contents of the document. Note that selecting this option "
        "will <em>not</em> change the current document's DOCTYPE on output. "
        "<br/>"
        "If set to <var>strict</var>, Tidy will set the DOCTYPE to the HTML4 or "
        "XHTML1 strict DTD."
        "<br/>"
        "If set to <var>loose</var>, the DOCTYPE is set to the HTML4 or XHTML1 "
        "loose (transitional) DTD."
        "<br/>"
        "Alternatively, you can supply a string for the formal public identifier "
        "(FPI)."
        "<br/>"
        "For example: "
        "<br/>"
        "<code>doctype: \"-//ACME//DTD HTML 3.14159//EN\"</code>"
        "<br/>"
        "If you specify the FPI for an XHTML document, Tidy will set the "
        "system identifier to an empty string. For an HTML document, Tidy adds a "
        "system identifier only if one was already present in order to preserve "
        "the processing mode of some browsers. Tidy leaves the DOCTYPE for "
        "generic XML documents unchanged. "
        "<br/>"
        "This option does not offer a validation of document conformance. "
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidyDropEmptyElems,           0,
        "This option specifies if Tidy should discard empty elements. "
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidyDropEmptyParas,           0,
        "This option specifies if Tidy should discard empty paragraphs. "
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidyDropPropAttrs,            0,
        "This option specifies if Tidy should strip out proprietary attributes, "
        "such as Microsoft data binding attributes. Additionally attributes "
        "that aren't permitted in the output version of HTML will be dropped "
        "if used with <code>strict-tags-attributes</code>. "
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidyDuplicateAttrs,           0,
        "This option specifies if Tidy should keep the first or last attribute, if "
        "an attribute is repeated, e.g. has two <code>align</code> attributes. "
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidyEmacs,                    0,
        "This option specifies that Tidy should change the format for reporting "
        "errors and warnings to a format that is more easily parsed by GNU Emacs "
        "or some other program.  It changes them from the default "
        "<br/>"
        "  line &lt;line number&gt; column &lt;column number&gt; - (Error|Warning): &lt;message&gt; "
        "<br/>"
        "to a form which includes the input filename: "
        "<br/>"
        "  &lt;filename&gt;:&lt;line number&gt;:&lt;column number&gt;: (Error|Warning): &lt;message&gt; "
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidyEmptyTags,                0,
        "This option specifies new empty inline tags. This option takes a space "
        "or comma separated list of tag names. "
        "<br/>"
        "Unless you declare new tags, Tidy will refuse to generate a tidied file if "
        "the input includes previously unknown tags. "
        "<br/>"
        "Remember to also declare empty tags as either inline or blocklevel. "
        "<br/>"
        "This option is ignored in XML mode. "
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidyEncloseBlockText,         0,
        "This option specifies if Tidy should insert a <code>&lt;p&gt;</code> "
        "element to enclose any text it finds in any element that allows mixed "
        "content for HTML transitional but not HTML strict. "
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidyEncloseBodyText,          0,
        "This option specifies if Tidy should enclose any text it finds in the "
        "body element within a <code>&lt;p&gt;</code> element."
        "<br/>"
        "This is useful when you want to take existing HTML and use it with a "
        "style sheet. "
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidyErrFile,                  0,
        "This option specifies the error file Tidy uses for errors and warnings. "
        "Normally errors and warnings are output to <code>stderr</code>. "
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidyEscapeCdata,              0,
        "This option specifies if Tidy should convert "
        "<code>&lt;![CDATA[]]&gt;</code> sections to normal text. "
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidyEscapeScripts,          0,
        "This option causes items that look like closing tags, like "
        "<code>&lt;/g</code> to be escaped to <code>&lt;\\/g</code>. Set "
        "this option to <var>no</var> if you do not want this."
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidyFixBackslash,             0,
        "This option specifies if Tidy should replace backslash characters "
        "<code>\\</code> in URLs with forward slashes <code>/</code>. "
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidyFixComments,              0,
        "This option specifies if Tidy should replace unexpected hyphens with "
        "<code>=</code> characters when it comes across adjacent hyphens. "
        "<br/>"
        "The default is <var>auto</var> will which will act as <var>no</var> "
        "for HTML5 document types, and <var>yes</var> for all other document "
        "types. "
        "<br/>"
        "HTML has abandonded SGML comment syntax, and allows adjacent hypens "
        "for all versions of HTML, although XML and XHTML do not. If you plan "
        "to support older browsers that require SGML comment syntax, then "
        "consider setting this value to <var>yes</var>."
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidyFixUri,                   0,
        "This option specifies if Tidy should check attribute values that carry "
        "URIs for illegal characters and if such are found, escape them as HTML4 "
        "recommends. "
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidyForceOutput,              0,
        "This option specifies if Tidy should produce output even if errors are "
        "encountered. "
        "<br/>"
        "Use this option with care; if Tidy reports an error, this "
        "means Tidy was not able to (or is not sure how to) fix the error, so the "
        "resulting output may not reflect your intention. "
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidyGDocClean,                0,
        "This option specifies if Tidy should enable specific behavior for "
        "cleaning up HTML exported from Google Docs. "
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidyHideComments,             0,
        "This option specifies if Tidy should not print out comments. "
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidyHtmlOut,                  0,
        "This option specifies if Tidy should generate pretty printed output, "
        "writing it as HTML. "
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidyInCharEncoding,           0,
        "This option specifies the character encoding Tidy uses for input. "
        "Tidy makes certain assumptions about some of the input encodings. "
        "<br/>"
        "For <var>ascii</var>, Tidy will accept Latin-1 (ISO-8859-1) character "
        "values and convert them to entities as necessary. "
        "<br/>"
        "For <var>raw</var>, Tidy will make no assumptions about the character "
        "values and will pass them unchanged to output. "
        "<br/>"
        "For <var>mac</var> and <var>win1252</var>, vendor specific characters "
        "values will be accepted and converted to entities as necessary. "
        "<br/>"
        "Asian encodings such as <var>iso2022</var> will be handled "
        "appropriately assuming the corresponding <code>output-encoding</code> "
        "is also specified. "
        "<br/>"
        "Tidy is not an encoding converter. Although the Latin and UTF "
        "encodings can be mixed freely, it is not possible to convert Asian "
        "encodings to Latin encodings with Tidy. "
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidyIndentAttributes,         0,
        "This option specifies if Tidy should begin each attribute on a new line. "
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidyIndentCdata,              0,
        "This option specifies if Tidy should indent "
        "<code>&lt;![CDATA[]]&gt;</code> sections. "
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidyIndentContent,            0,
        "This option specifies if Tidy should indent block-level tags. "
        "<br/>"
        "If set to <var>auto</var> Tidy will decide whether or not to indent the "
        "content of tags such as <code>&lt;title&gt;</code>, "
        "<code>&lt;h1&gt;</code>-<code>&lt;h6&gt;</code>, <code>&lt;li&gt;</code>, "
        "<code>&lt;td&gt;</code>, or <code>&lt;p&gt;</code> "
        "based on the content including a block-level element. "
        "<br/>"
        "Setting <code>indent</code> to <var>yes</var> can expose layout bugs in "
        "some browsers. "
        "<br/>"
        "Use the option <code>indent-spaces</code> to control the number of spaces "
        "or tabs output per level of indent, and <code>indent-with-tabs</code> to "
        "specify whether spaces or tabs are used. "
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidyIndentSpaces,             0,
        "This option specifies the number of spaces or tabs that Tidy uses to "
        "indent content when <code>indent</code> is enabled. "
        "<br/>"
        "Note that the default value for this option is dependent upon the value of "
        "<code>indent-with-tabs</code> (see also). "
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidyInlineTags,               0,
        "This option specifies new non-empty inline tags. This option takes a "
        "space or comma separated list of tag names. "
        "<br/>"
        "Unless you declare new tags, Tidy will refuse to generate a tidied file if "
        "the input includes previously unknown tags. "
        "<br/>"
        "This option is ignored in XML mode. "
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidyJoinClasses,              0,
        "This option specifies if Tidy should combine class names to generate "
        "a single, new class name if multiple class assignments are detected on "
        "an element. "
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidyJoinStyles,               0,
        "This option specifies if Tidy should combine styles to generate a single, "
        "new style if multiple style values are detected on an element. "
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidyKeepFileTimes,            0,
        "This option specifies if Tidy should keep the original modification time "
        "of files that Tidy modifies in place. "
        "<br/>"
        "Setting the option to <var>yes</var> allows you to tidy files without "
        "changing the file modification date, which may be useful with certain "
        "tools that use the modification date for things such as automatic server "
        "deployment."
        "<br/>"
        "Note this feature is not supported on some platforms. "
    },
    {/* Important notes for translators:
     - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
     <br/>.
     - Entities, tags, attributes, etc., should be enclosed in <code></code>.
     - Option values should be enclosed in <var></var>.
     - It's very important that <br/> be self-closing!
     - The strings "Tidy" and "HTML Tidy" are the program name and must not
     be translated. */
        TidyKeepTabs,            0,
        "With the default <var>no</var> Tidy will replace all source tabs with spaces, "
        "controlled by the option <code>tab-size</code>, and the current line offset. "
        "Of course, except in the special blocks/elements enumerated below, this will later "
        "be reduced to just one space. "
        "<br/>"
        "If set <var>yes</var> this option specifies Tidy should keep certain tabs "
        "found in the source, but only "
        "in preformatted blocks like <code>&lt;pre&gt;</code>, and other CDATA elements like "
        "<code>&lt;script&gt;</code>, <code>&lt;style&gt;</code>, and other pseudo elements like "
        "<code>&lt;?php ... ?&gt;</code>. As always, all other tabs, or sequences of tabs, in "
        "the source will continue to be replaced with a space. "
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidyLiteralAttribs,           0,
        "This option specifies how Tidy deals with whitespace characters within "
        "attribute values. "
        "<br/>"
        "If the value is <var>no</var> Tidy normalizes attribute values by "
        "replacing any newline or tab with a single space, and further by replacing "
        "any contiguous whitespace with a single space. "
        "<br/>"
        "To force Tidy to preserve the original, literal values of all attributes "
        "and ensure that whitespace within attribute values is passed "
        "through unchanged, set this option to <var>yes</var>. "
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidyLogicalEmphasis,          0,
        "This option specifies if Tidy should replace any occurrence of "
        "<code>&lt;i&gt;</code> with <code>&lt;em&gt;</code> and any occurrence of "
        "<code>&lt;b&gt;</code> with <code>&lt;strong&gt;</code>. Any attributes "
        "are preserved unchanged. "
        "<br/>"
        "This option can be set independently of the <code>clean</code> option. "
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidyLowerLiterals,            0,
        "This option specifies if Tidy should convert the value of an attribute "
        "that takes a list of predefined values to lower case. "
        "<br/>"
        "This is required for XHTML documents. "
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidyMakeBare,                 0,
        "This option specifies if Tidy should strip Microsoft specific HTML "
        "from Word 2000 documents, and output spaces rather than non-breaking "
        "spaces where they exist in the input. "
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidyMakeClean,                0,
        "This option specifies if Tidy should perform cleaning of some legacy "
        "presentational tags (currently <code>&lt;i&gt;</code>, "
        "<code>&lt;b&gt;</code>, <code>&lt;center&gt;</code> when enclosed "
        "within appropriate inline tags, and <code>&lt;font&gt;</code>). If "
        "set to <var>yes</var>, then the legacy tags will be replaced with CSS "
        "<code>&lt;style&gt;</code> tags and structural markup as appropriate. "
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidyMark,                     0,
        "This option specifies if Tidy should add a <code>meta</code> element to "
        "the document head to indicate that the document has been tidied. "
        "<br/>"
        "Tidy won't add a meta element if one is already present. "
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidyMergeDivs,                0,
        "This option can be used to modify the behavior of <code>clean</code> when "
        "set to <var>yes</var>."
        "<br/>"
        "This option specifies if Tidy should merge nested <code>&lt;div&gt;</code> "
        "such as <code>&lt;div&gt;&lt;div&gt;...&lt;/div&gt;&lt;/div&gt;</code>. "
        "<br/>"
        "If set to <var>auto</var> the attributes of the inner "
        "<code>&lt;div&gt;</code> are moved to the outer one. Nested "
        "<code>&lt;div&gt;</code> with <code>id</code> attributes are <em>not</em> "
        "merged. "
        "<br/>"
        "If set to <var>yes</var> the attributes of the inner "
        "<code>&lt;div&gt;</code> are discarded with the exception of "
        "<code>class</code> and <code>style</code>. "
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidyMergeEmphasis,            0,
        "This option specifies if Tidy should merge nested <code>&lt;b&gt;</code> "
        "and <code>&lt;i&gt;</code> elements; for example, for the case "
        "<br/>"
        "<code>&lt;b class=\"rtop-2\"&gt;foo &lt;b class=\"r2-2\"&gt;bar&lt;/b&gt; baz&lt;/b&gt;</code>, "
        "<br/>"
        "Tidy will output <code>&lt;b class=\"rtop-2\"&gt;foo bar baz&lt;/b&gt;</code>. "
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidyMergeSpans,               0,
        "This option can be used to modify the behavior of <code>clean</code> when "
        "set to <var>yes</var>."
        "<br/>"
        "This option specifies if Tidy should merge nested <code>&lt;span&gt;</code> "
        "such as <code>&lt;span&gt;&lt;span&gt;...&lt;/span&gt;&lt;/span&gt;</code>. "
        "<br/>"
        "The algorithm is identical to the one used by <code>merge-divs</code>. "
    },
    {/* Important notes for translators:
        - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
          <br/>.
        - Entities, tags, attributes, etc., should be enclosed in <code></code>.
        - Option values should be enclosed in <var></var>.
        - It's very important that <br/> be self-closing!
        - The strings "Tidy" and "HTML Tidy" are the program name and must not
          be translated. */
      TidyNCR,                      0,
        "This option specifies if Tidy should allow numeric character references. "
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidyNewline,                  0,
        "The default is appropriate to the current platform. "
        "<br/>"
        "Genrally <var>CRLF</var> on PC-DOS, Windows and OS/2; <var>'\r'</var> "
        "on Classic Mac OS; and <var>'\n'</var> everywhere else (Linux, macOS, "
        "and Unix). "
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidyNumEntities,              0,
        "This option specifies if Tidy should output entities other than the "
        "built-in HTML entities (<code>&amp;amp;</code>, <code>&amp;lt;</code>, "
        "<code>&amp;gt;</code>, and <code>&amp;quot;</code>) in the numeric rather "
        "than the named entity form. "
        "<br/>"
        "Only entities compatible with the DOCTYPE declaration generated are used. "
        "<br/>"
        "Entities that can be represented in the output encoding are translated "
        "correspondingly. "
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidyOmitOptionalTags,         0,
        "This option specifies if Tidy should omit optional start tags and end tags "
        "when generating output. "
        "<br/>"
        "Setting this option causes all tags for the <code>&lt;html&gt;</code>, "
        "<code>&lt;head&gt;</code>, and <code>&lt;body&gt;</code> elements to be "
        "omitted from output, as well as such end tags as <code>&lt;/p&gt;</code>, "
        "<code>&lt;/li&gt;</code>, <code>&lt;/dt&gt;</code>, "
        "<code>&lt;/dd&gt;</code>, <code>&lt;/option&gt;</code>, "
        "<code>&lt;/tr&gt;</code>, <code>&lt;/td&gt;</code>, and "
        "<code>&lt;/th&gt;</code>. "
        "<br/>"
        "This option is ignored for XML output. "
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidyOutCharEncoding,          0,
        "This option specifies the character encoding Tidy uses for "
        "output. Some of the output encodings affect whether or not "
        "some characters are translated to entities, although in all "
        "cases, some entities will be written according to other Tidy "
        "configuration options. "
        "<br/>"
        "For <var>ascii</var>, <var>mac</var>, and <var>win1252</var> "
        "output encodings, entities will be used for all characters "
        "with values over 127. "
        "<br/>"
        "For <var>raw</var> output, Tidy will write values above 127 "
        "without translating them to entities. "
        "<br/>"
        "Output using <var>latin1</var> will cause Tidy to write "
        "character values higher than 255 as entities. "
        "<br/>"
        "The UTF family such as <var>utf8</var> will write output "
        "in the respective UTF encoding. "
        "<br/>"
        "Asian output encodings such as <var>iso2022</var> will write "
        "output in the specified encoding, assuming a corresponding "
        "<code>input-encoding</code> was specified. "
        "<br/>"
        "Tidy is not an encoding converter. Although the Latin and UTF "
        "encodings can be mixed freely, it is not possible to convert Asian "
        "encodings to Latin encodings with Tidy. "
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidyOutFile,                  0,
        "This option specifies the output file Tidy uses for markup. Normally "
        "markup is written to <code>stdout</code>. "
    },
    {/* Important notes for translators:
        - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
          <br/>.
        - Entities, tags, attributes, etc., should be enclosed in <code></code>.
        - Option values should be enclosed in <var></var>.
        - It's very important that <br/> be self-closing!
        - The strings "Tidy" and "HTML Tidy" are the program name and must not
          be translated. */
      TidyOutputBOM,                0,
        "This option specifies if Tidy should write a Unicode Byte Order Mark "
        "character (BOM; also known as Zero Width No-Break Space; has value of "
        "U+FEFF) to the beginning of the output, and only applies to UTF-8 and "
        "UTF-16 output encodings. "
        "<br/>"
        "If set to <var>auto</var> this option causes Tidy to write a BOM to "
        "the output only if a BOM was present at the beginning of the input. "
        "<br/>"
        "A BOM is always written for XML/XHTML output using UTF-16 output "
        "encodings. "
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidyPPrintTabs,               0,
        "This option specifies if Tidy should indent with tabs instead of spaces, "
        "assuming <code>indent</code> is <var>yes</var>. "
        "<br/>"
        "Set it to <var>yes</var> to indent using tabs instead of the default "
        "spaces. "
        "<br/>"
        "Use the option <code>indent-spaces</code> to control the number of tabs "
        "output per level of indent. Note that when <code>indent-with-tabs</code> "
        "is enabled the default value of <code>indent-spaces</code> is reset to "
        "<var>1</var>. "
        "<br/>"
        "Note <code>tab-size</code> controls converting input tabs to spaces. Set "
        "it to zero to retain input tabs. "
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidyPreserveEntities,         0,
        "This option specifies if Tidy should preserve well-formed entities "
        "as found in the input. "
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidyPreTags,                  0,
        "This option specifies new tags that are to be processed in exactly the "
        "same way as HTML's <code>&lt;pre&gt;</code> element. This option takes a "
        "space or comma separated list of tag names. "
        "<br/>"
        "Unless you declare new tags, Tidy will refuse to generate a tidied file if "
        "the input includes previously unknown tags. "
        "<br/>"
        "Note you cannot as yet add new CDATA elements. "
        "<br/>"
        "This option is ignored in XML mode. "
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidyPriorityAttributes,       0,
        "This option allows prioritizing the writing of attributes in tidied "
        "documents, allowing them to written before the other attributes of an "
        "element. For example, you might specify that <strong>id</strong> and "
        "<strong>name</strong> are written before every other attribute. "
        "<br/>"
        "This option takes a space or comma separated list of attribute names. "
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidyPunctWrap,                0,
        "This option specifies if Tidy should line wrap after some Unicode or "
        "Chinese punctuation characters. "
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidyQuiet,                    0,
        "When enabled, this option limits Tidy's non-document output to report "
        "only document warnings and errors. "
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidyQuoteAmpersand,           0,
        "This option specifies if Tidy should output unadorned <code>&amp;</code> "
        "characters as <code>&amp;amp;</code>. "
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidyQuoteMarks,               0,
        "This option specifies if Tidy should output <code>&quot;</code> characters "
        "as <code>&amp;quot;</code> as is preferred by some editing environments. "
        "<br/>"
        "The apostrophe character <code>'</code> is written out as "
        "<code>&amp;#39;</code> since many web browsers don't yet support "
        "<code>&amp;apos;</code>. "
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidyQuoteNbsp,                0,
        "This option specifies if Tidy should output non-breaking space characters "
        "as entities, rather than as the Unicode character value 160 (decimal). "
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidyReplaceColor,             0,
        "This option specifies if Tidy should replace numeric values in color "
        "attributes with HTML/XHTML color names where defined, e.g. replace "
        "<code>#ffffff</code> with <code>white</code>. "
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidyShowErrors,               0,
        "This option specifies the number Tidy uses to determine if further errors "
        "should be shown. If set to <var>0</var>, then no errors are shown. "
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidyShowFilename,             0,
        "This option specifies if Tidy should show the filename in messages. eg: "
        "<br/>"
        " tidy -q -e --show-filename yes index.html<br/>"
        " index.html: line 43 column 3 - Warning: replacing invalid UTF-8 bytes (char. code U+00A9) "
    },

    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidyShowInfo,                 0,
        "This option specifies if Tidy should display info-level messages. "
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidyShowMarkup,               0,
        "This option specifies if Tidy should generate a pretty printed version "
        "of the markup. Note that Tidy won't generate a pretty printed version if "
        "it finds significant errors (see <code>force-output</code>). "
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidyShowWarnings,             0,
        "This option specifies if Tidy should suppress warnings. This can be "
        "useful when a few errors are hidden in a flurry of warnings. "
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidySkipNested,               0,
        "This option specifies that Tidy should skip nested tags when parsing "
        "script and style data. "
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidySortAttributes,           0,
        "This option specifies that Tidy should sort attributes within an element "
        "using the specified sort algorithm. If set to <var>alpha</var>, the "
        "algorithm is an ascending alphabetic sort. "
        "<br/>"
        "When used while sorting with <code>priority-attributes</code>, any "
        "attribute sorting will take place after the priority attributes have "
        "been output. "
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidyMuteReports,           0,
        "Use this option to prevent Tidy from displaying certain types of "
        "report output, for example, for conditions that you wish to ignore. "
        "<br/>"
        "This option takes a list of one or more keys indicating the message "
        "type to mute. You can discover these message keys by using the "
        "<code>mute-id</code> configuration option and examining Tidy's "
        "output. " 
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidyMuteShow,              0,
        "This option indicates whether or not Tidy should display message ID's "
        "with each of its error reports. This could be useful if you wanted to "
        "use the <code>mute</code> configuration option in order to filter "
        "out certain report messages. "
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidyStrictTagsAttr,           0,
        "This options ensures that tags and attributes are applicable for the "
        "version of HTML that Tidy outputs. When set to <var>yes</var> and the "
        "output document type is a strict doctype, then Tidy will report "
        "errors. If the output document type is a loose or transitional "
        "doctype, then Tidy will report warnings. "
        "<br/>"
        "Additionally if <code>drop-proprietary-attributes</code> is enabled, "
        "then not applicable attributes will be dropped, too. "
        "<br/>"
        "When set to <var>no</var>, these checks are not performed. "
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidyTabSize,                  0,
        "This option specifies the number of columns that Tidy uses between "
        "successive tab stops. It is used to map tabs to spaces when reading the "
        "input. "
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidyUpperCaseAttrs,           0,
        "This option specifies if Tidy should output attribute names in upper "
        "case. "
        "<br/>"
        "When set to <var>no</var>, attribute names will be written in lower "
        "case. Specifying <var>yes</var> will output attribute names in upper "
        "case, and <var>preserve</var> can used to leave attribute names "
        "untouched. "
        "<br/>"
        "When using XML input, the original case is always preserved. "
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidyUpperCaseTags,            0,
        "This option specifies if Tidy should output tag names in upper case. "
        "<br/>"
        "The default is <var>no</var> which results in lower case tag names, "
        "except for XML input where the original case is preserved. "
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidyUseCustomTags,          0,
        "This option enables the use of tags for autonomous custom elements, "
        "e.g. <code>&lt;flag-icon&gt;</code> with Tidy. Custom tags are "
        "disabled if this value is <var>no</var>. Other settings - "
        "<var>blocklevel</var>, <var>empty</var>, <var>inline</var>, and "
        "<var>pre</var> will treat <em>all</em> detected custom tags "
        "accordingly. "
        "<br/>"
        "The use of <code>new-blocklevel-tags</code>, "
        "<code>new-empty-tags</code>, <code>new-inline-tags</code>, or "
        "<code>new-pre-tags</code> will override the treatment of custom tags "
        "by this configuration option. This may be useful if you have "
        "different types of custom tags."
        "<br/>"
        "When enabled these tags are determined during the processing of your "
        "document using opening tags; matching closing tags will be recognized "
        "accordingly, and unknown closing tags will be discarded. "
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidyVertSpace,                0,
        "This option specifies if Tidy should add some extra empty lines for "
        "readability. "
        "<br/>"
        "The default is <var>no</var>. "
        "<br/>"
        "If set to <var>auto</var> Tidy will eliminate nearly all newline "
        "characters."
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidyWarnPropAttrs,            0,
        "This option specifies if Tidy should warn on proprietary attributes."
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidyWord2000,                 0,
        "This option specifies if Tidy should go to great pains to strip out "
        "all the surplus stuff Microsoft Word 2000 inserts when you save Word "
        "documents as \"Web pages\". It doesn't handle embedded images or VML. "
        "<br/>"
        "You should consider saving using Word's <strong>Save As...</strong>, "
        "and choosing <strong>Web Page, Filtered</strong>. "
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidyWrapAsp,                  0,
        "This option specifies if Tidy should line wrap text contained within ASP "
        "pseudo elements, which look like: <code>&lt;% ... %&gt;</code>. "
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidyWrapAttVals,              0,
        "This option specifies if Tidy should line-wrap attribute values, meaning "
        "that if the value of an attribute causes a line to exceed the width "
        "specified by <code>wrap</code>, Tidy will add one or more line breaks to "
        "the value, causing it to be wrapped into multiple lines. "
        "<br/>"
        "Note that this option can be set independently of "
        "<code>wrap-script-literals</code>. "
        "By default Tidy replaces any newline or tab with a single space and "
        "replaces any sequences of whitespace with a single space. "
        "<br/>"
        "To force Tidy to preserve the original, literal values of all attributes, "
        "and ensure that whitespace characters within attribute values are passed "
        "through unchanged, set <code>literal-attributes</code> to "
        "<var>yes</var>. "
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidyWrapJste,                 0,
        "This option specifies if Tidy should line wrap text contained within "
        "JSTE pseudo elements, which look like: <code>&lt;# ... #&gt;</code>. "
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidyWrapLen,                  0,
        "This option specifies the right margin Tidy uses for line wrapping. "
        "<br/>"
        "Tidy tries to wrap lines so that they do not exceed this length. "
        "<br/>"
        "Set <code>wrap</code> to <var>0</var> (zero) if you want to disable "
        "line wrapping. "
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidyWrapPhp,                  0,
        "This option specifies if Tidy should line wrap text contained within PHP "
        "pseudo elements, which look like: <code>&lt;?php ... ?&gt;</code>. "
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidyWrapScriptlets,           0,
        "This option specifies if Tidy should line wrap string literals that "
        "appear in script attributes. "
        "<br/>"
        "Tidy wraps long script string literals by inserting a backslash character "
        "before the line break. "
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidyWrapSection,              0,
        "This option specifies if Tidy should line wrap text contained within "
        "<code>&lt;![ ... ]&gt;</code> section tags. "
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidyWriteBack,                0,
        "This option specifies if Tidy should write back the tidied markup to the "
        "same file it read from. "
        "<br/>"
        "You are advised to keep copies of important files before tidying them, as "
        "on rare occasions the result may not be what you expect. "
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidyXhtmlOut,                 0,
        "This option specifies if Tidy should generate pretty printed output, "
        "writing it as extensible HTML. "
        "<br/>"
        "This option causes Tidy to set the DOCTYPE and default namespace as "
        "appropriate to XHTML, and will use the corrected value in output "
        "regardless of other sources. "
        "<br/>"
        "For XHTML, entities can be written as named or numeric entities according "
        "to the setting of <code>numeric-entities</code>. "
        "<br/>"
        "The original case of tags and attributes will be preserved, regardless of "
        "other options. "
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidyXmlDecl,                  0,
        "This option specifies if Tidy should add the XML declaration when "
        "outputting XML or XHTML. "
        "<br/>"
        "Note that if the input already includes an <code>&lt;?xml ... ?&gt;</code> "
        "declaration then this option will be ignored. "
        "<br/>"
        "If the encoding for the output is different from <var>ascii</var>, one "
        "of the <var>utf*</var> encodings, or <var>raw</var>, then the "
        "declaration is always added as required by the XML standard. "
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidyXmlOut,                   0,
        "This option specifies if Tidy should pretty print output, writing it as "
        "well-formed XML. "
        "<br/>"
        "Any entities not defined in XML 1.0 will be written as numeric entities to "
        "allow them to be parsed by an XML parser. "
        "<br/>"
        "The original case of tags and attributes will be preserved, regardless of "
        "other options. "
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidyXmlPIs,                   0,
        "This option specifies if Tidy should change the parsing of processing "
        "instructions to require <code>?&gt;</code> as the terminator rather than "
        "<code>&gt;</code>. "
        "<br/>"
        "This option is automatically set if the input is in XML. "
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
      be translated. */
        TidyXmlSpace,                 0,
        "This option specifies if Tidy should add "
        "<code>xml:space=\"preserve\"</code> to elements such as "
        "<code>&lt;pre&gt;</code>, <code>&lt;style&gt;</code> and "
        "<code>&lt;script&gt;</code> when generating XML. "
        "<br/>"
        "This is needed if the whitespace in such elements is to "
        "be parsed appropriately without having access to the DTD. "
    },
    {/* Important notes for translators:
        - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
          <br/>.
        - Entities, tags, attributes, etc., should be enclosed in <code></code>.
        - Option values should be enclosed in <var></var>.
        - It's very important that <br/> be self-closing!
        - The strings "Tidy" and "HTML Tidy" are the program name and must not
          be translated. */
      TidyXmlTags,                  0,
        "This option specifies if Tidy should use the XML parser rather than the "
        "error correcting HTML parser. "
    },
    {/* Important notes for translators:
        - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
          <br/>.
        - Entities, tags, attributes, etc., should be enclosed in <code></code>.
        - Option values should be enclosed in <var></var>.
        - It's very important that <br/> be self-closing!
        - The strings "Tidy" and "HTML Tidy" are the program name and must not
          be translated. */
      TidyMetaCharset,             0,
        "This option, when enabled, adds a <code>&lt;meta&gt;</code> element "
        "and sets the <code>charset</code> attribute to the encoding of the "
        "document. Set this option to <var>yes</var> to enable it. "
    },
    {/* Important notes for translators:
      - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
      <br/>.
      - Entities, tags, attributes, etc., should be enclosed in <code></code>.
      - Option values should be enclosed in <var></var>.
      - It's very important that <br/> be self-closing!
      - The strings "Tidy" and "HTML Tidy" are the program name and must not
        be translated. */
      TidyShowMetaChange,             0,
        "This option enables a message whenever Tidy changes the "
        "<code>content</code> attribute of a meta charset declaration to match "
        "the encoding of the document. Set this option to <var>yes</var> to "
        "enable it. "
    },
    {/* Important notes for translators:
     - Use only <code></code>, <var></var>, <em></em>, <strong></strong>, and
     <br/>.
     - Entities, tags, attributes, etc., should be enclosed in <code></code>.
     - Option values should be enclosed in <var></var>.
     - It's very important that <br/> be self-closing!
     - The strings "Tidy" and "HTML Tidy" are the program name and must not
       be translated. */
      TidyStyleTags,                  0,
        "This option specifies if Tidy should move all style tags to the "
        "head of the document. "
    },


    /********************************************
     ** Message Severity Level
     ** @remark enum source TidyConfigCategory
     ********************************************/
    { TidyInfo,               0,   "Info: "          },
    { TidyWarning,            0,   "Warning: "       },
    { TidyConfig,             0,   "Config: "        },
    { TidyAccess,             0,   "Access: "        },
    { TidyError,              0,   "Error: "         },
    { TidyBadDocument,        0,   "Document: "      },
    { TidyFatal,              0,   "Panic: "         },
    { TidyDialogueSummary,    0,   "Summary: "       },
    { TidyDialogueInfo,       0,   "Information: "   },
    { TidyDialogueFootnote,   0,   "Footnote: "      },
    
    
    /********************************************
     ** Miscellaneous Strings
     ** @remark enum source TidyStrings
     ** @remark enum generator FOREACH_MSG_MISC
     ********************************************/
    { LINE_COLUMN_STRING,           0,   "line %d column %d - "                                                    },
    { FN_LINE_COLUMN_STRING,        0,   "%s: line %d column %d - "                                                },
    {/* For example, "discarding invalid UTF-16 surrogate pair" */
      STRING_DISCARDING,            0,   "discarding"
    },
    { STRING_ERROR_COUNT_ERROR,     0,   "error"                                                                   },
    { STRING_ERROR_COUNT_ERROR,     1,   "errors"                                                                  },
    { STRING_ERROR_COUNT_WARNING,   0,   "warning"                                                                 },
    { STRING_ERROR_COUNT_WARNING,   1,   "warnings"                                                                },
    { STRING_HELLO_ACCESS,          0,   "\nAccessibility Checks:\n"                                               },
    {/* This is not a formal name and can be translated. */
      STRING_HTML_PROPRIETARY,      0,   "HTML Proprietary"
    },
    { STRING_XML_DECLARATION,       0,   "XML declaration"                                                         },
    { STRING_PLAIN_TEXT,            0,   "plain text"                                                              },
    {/* For example, "replacing invalid UTF-8 bytes" */
      STRING_REPLACING,             0,   "replacing"
    },
    {/* For example, "you should avoid using the specified encoding." */
      STRING_SPECIFIED,             0,   "specified"
    },
    { TIDYCUSTOMNO_STRING,          0,   "no"                                                                      },
    { TIDYCUSTOMBLOCKLEVEL_STRING,  0,   "block level"                                                             },
    { TIDYCUSTOMEMPTY_STRING,       0,   "empty"                                                                   },
    { TIDYCUSTOMINLINE_STRING,      0,   "inline"                                                                  },
    { TIDYCUSTOMPRE_STRING,         0,   "pre"                                                                     },
  
    
    /********************************************
     ** Footnote Strings
     ** @remark enum source TidyStrings
     ** @rename enum generator FOREACH_FOOTNOTE_MSG
     ********************************************/
    {/* This console output should be limited to 78 characters per line. */
      TEXT_HTML_T_ALGORITHM,        0,
        "\n"
        "      - First, search left from the cell's position to find row header cells.\n"
        "      - Then search upwards to find column header cells.\n"
        "      - The search in a given direction stops when the edge of the table is\n"
        "        reached or when a data cell is found after a header cell.\n"
        "      - Row headers are inserted into the list in the order they appear in\n"
        "        the table. \n"
        "      - For left-to-right tables, headers are inserted from left to right.\n"
        "      - Column headers are inserted after row headers, in \n"
        "        the order they appear in the table, from top to bottom. \n"
        "      - If a header cell has the headers attribute set, then the headers \n"
        "        referenced by this attribute are inserted into the list and the \n"
        "        search stops for the current direction.\n"
        "        TD cells that set the axis attribute are also treated as header cells.\n"
    },
    {/* This console output should be limited to 78 characters per line.
        - %s represents a string-encoding name which may be localized in your language. */
      TEXT_VENDOR_CHARS,            0,
        "It is unlikely that vendor-specific, system-dependent encodings\n"
        "work widely enough on the World Wide Web; you should avoid using the \n"
        "%s character encoding, instead you are recommended to\n"
        "use named entities, e.g. &trade;.\n"
    },
    {/* This console output should be limited to 78 characters per line.
        - %s represents a string-encoding name which may be localized in your language.
        - The strings "Tidy" and "HTML Tidy" are the program name and must not be translated. */
      TEXT_SGML_CHARS,              0,
        "Character codes 128 to 159 (U+0080 to U+009F) are not allowed in HTML;\n"
        "even if they were, they would likely be unprintable control characters.\n"
        "Tidy assumed you wanted to refer to a character with the same byte value in the \n"
        "%s encoding and replaced that reference with the Unicode \n"
        "equivalent.\n"
    },
    {/* This console output should be limited to 78 characters per line. */
      TEXT_INVALID_UTF8,            0,
        "Character codes for UTF-8 must be in the range: U+0000 to U+10FFFF.\n"
        "The definition of UTF-8 in Annex D of ISO/IEC 10646-1:2000 also\n"
        "allows for the use of five- and six-byte sequences to encode\n"
        "characters that are outside the range of the Unicode character set;\n"
        "those five- and six-byte sequences are illegal for the use of\n"
        "UTF-8 as a transformation of Unicode characters. ISO/IEC 10646\n"
        "does not allow mapping of unpaired surrogates, nor U+FFFE and U+FFFF\n"
        "(but it does allow other noncharacters). For more information please refer to\n"
        "http://www.unicode.org/ and http://www.cl.cam.ac.uk/~mgk25/unicode.html\n"
    },
    {/* This console output should be limited to 78 characters per line. */
      TEXT_INVALID_UTF16,           0,
        "Character codes for UTF-16 must be in the range: U+0000 to U+10FFFF.\n"
        "The definition of UTF-16 in Annex C of ISO/IEC 10646-1:2000 does not allow the\n"
        "mapping of unpaired surrogates. For more information please refer to\n"
        "http://www.unicode.org/ and http://www.cl.cam.ac.uk/~mgk25/unicode.html\n"
    },
    {/* This console output should be limited to 78 characters per line.
        - The strings "Tidy" and "HTML Tidy" are the program name and must not be translated. */
      TEXT_INVALID_URI,             0,
        "URIs must be properly escaped, they must not contain unescaped\n"
        "characters below U+0021 including the space character and not\n"
        "above U+007E. Tidy escapes the URI for you as recommended by\n"
        "HTML 4.01 section B.2.1 and XML 1.0 section 4.2.2. Some user agents\n"
        "use another algorithm to escape such URIs and some server-sided\n"
        "scripts depend on that. If you want to depend on that, you must\n"
        "escape the URI on your own. For more information please refer to\n"
        "http://www.w3.org/International/O-URL-and-ident.html\n"
    },
    {/* This console output should be limited to 78 characters per line. */
      TEXT_BAD_FORM,                0,
        "You may need to move one or both of the <form> and </form>\n"
        "tags. HTML elements should be properly nested and form elements\n"
        "are no exception. For instance you should not place the <form>\n"
        "in one table cell and the </form> in another. If the <form> is\n"
        "placed before a table, the </form> cannot be placed inside the\n"
        "table! Note that one form can't be nested inside another!\n"
    },
    {/* This console output should be limited to 78 characters per line. */
      TEXT_BAD_MAIN,                0,
        "Only one <main> element is allowed in a document.\n"
        "Subsequent <main> elements have been discarded, which may\n"
        "render the document invalid.\n"
    },
    {/* This console output should be limited to 78 characters per line. */
      TEXT_M_SUMMARY,               0,
        "The table summary attribute should be used to describe\n"
        "the table structure. It is very helpful for people using\n"
        "non-visual browsers. The scope and headers attributes for\n"
        "table cells are useful for specifying which headers apply\n"
        "to each table cell, enabling non-visual browsers to provide\n"
        "a meaningful context for each cell.\n"
    },
    {/* This console output should be limited to 78 characters per line. */
      TEXT_M_IMAGE_ALT,             0,
        "The alt attribute should be used to give a short description\n"
        "of an image; longer descriptions should be given with the\n"
        "longdesc attribute which takes a URL linked to the description.\n"
        "These measures are needed for people using non-graphical browsers.\n"
    },
    {/* This console output should be limited to 78 characters per line. */
      TEXT_M_IMAGE_MAP,             0,
        "Use client-side image maps in preference to server-side image\n"
        "maps as the latter are inaccessible to people using non-\n"
        "graphical browsers. In addition, client-side maps are easier\n"
        "to set up and provide immediate feedback to users.\n"
    },
    {/* This console output should be limited to 78 characters per line. */
      TEXT_M_LINK_ALT,              0,
        "For hypertext links defined using a client-side image map, you\n"
        "need to use the alt attribute to provide a textual description\n"
        "of the link for people using non-graphical browsers.\n"
    },
    {/* This console output should be limited to 78 characters per line. */
      TEXT_USING_FRAMES,            0,
        "Pages designed using frames present problems for\n"
        "people who are either blind or using a browser that\n"
        "doesn't support frames. A frames-based page should always\n"
        "include an alternative layout inside a NOFRAMES element.\n"
    },
    {/* This console output should be limited to 78 characters per line. */
      FOOTNOTE_TRIM_EMPTY_ELEMENT,  0,
        "One or more empty elements were present in the source document but\n"
        "dropped on output. If these elements are necessary or you don't want\n"
        "this behavior, then consider setting the option \"drop-empty-elements\"\n"
        "to no.\n"
    },
    {/* This console output should be limited to 78 characters per line.
        - The URL should not be translated unless you find a matching URL in your language. */
      TEXT_ACCESS_ADVICE1,          0,
        "For further advice on how to make your pages accessible\n"
        "see http://www.w3.org/WAI/GL."
    },
    {/* This console output should be limited to 78 characters per line.
        - The URL should not be translated unless you find a matching URL in your language. */
      TEXT_ACCESS_ADVICE2,          0,
        "For further advice on how to make your pages accessible\n"
        "see http://www.w3.org/WAI/GL and http://www.html-tidy.org/accessibility/."
    },
    {/* This console output should be limited to 78 characters per line. */
      TEXT_USING_LAYER,             0,
        "The Cascading Style Sheets (CSS) Positioning mechanism\n"
        "is recommended in preference to the proprietary <LAYER>\n"
        "element due to limited vendor support for LAYER.\n"
    },
    {/* This console output should be limited to 78 characters per line. */
      TEXT_USING_SPACER,            0,
        "You are recommended to use CSS for controlling white\n"
        "space (e.g. for indentation, margins and line spacing).\n"
        "The proprietary <SPACER> element has limited vendor support.\n"
    },
    {/* This console output should be limited to 78 characters per line. */
      TEXT_USING_FONT,              0,
        "You are recommended to use CSS to specify the font and\n"
        "properties such as its size and color. This will reduce\n"
        "the size of HTML files and make them easier to maintain\n"
        "compared with using <FONT> elements.\n"
    },
    {/* This console output should be limited to 78 characters per line. */
      TEXT_USING_NOBR,              0,
        "You are recommended to use CSS to control line wrapping.\n"
        "Use \"white-space: nowrap\" to inhibit wrapping in place\n"
        "of inserting <NOBR>...</NOBR> into the markup.\n"
    },
    {/* This console output should be limited to 78 characters per line. */
      TEXT_USING_BODY,              0,
        "You are recommended to use CSS to specify page and link colors"
    },
    
    /********************************************
     ** Miscellaneous Dialogue Strings
     ** @remark enum source TidyStrings
     ** @rename enum generator FOREACH_DIALOG_MSG
     ********************************************/
    { STRING_CONTENT_LOOKS,         0,   "Document content looks like %s"                                          },
    { STRING_DOCTYPE_GIVEN,         0,   "Doctype given is \"%s\""                                                 },
    {/* The strings "Tidy" and "HTML Tidy" are the program name and must not be translated. */
      STRING_ERROR_COUNT,           0,   "Tidy found %u %s and %u %s!\n"
    },
    {/* This console output should be limited to 78 characters per line.
      - The strings "Tidy" and "HTML Tidy" are the program name and must not be translated. */
      STRING_NEEDS_INTERVENTION,    0,
        "This document has errors that must be fixed before\n"
        "using HTML Tidy to generate a tidied up version.\n"
    },
    { STRING_NO_ERRORS,             0,   "No warnings or errors were found.\n"                                     },
    { STRING_NO_SYSID,              0,   "No system identifier in emitted doctype"                                 },
    { STRING_NOT_ALL_SHOWN,         0,   "Tidy found %u %s and %u %s! Not all warnings/errors were shown.\n"       },
    {/* This console output should be limited to 78 characters per line.
      - The strings "Tidy" and "HTML Tidy" are the program name and must not be translated. */
      TEXT_GENERAL_INFO,            0,
        "About HTML Tidy: https://github.com/htacg/tidy-html5\n"
        "Bug reports and comments: https://github.com/htacg/tidy-html5/issues\n"
        "Official mailing list: https://lists.w3.org/Archives/Public/public-htacg/\n"
        "Latest HTML specification: http://dev.w3.org/html5/spec-author-view/\n"
        "Validate your HTML documents: http://validator.w3.org/nu/\n"
        "Lobby your company to join the W3C: http://www.w3.org/Consortium\n"
    },
    {/* This console output should be limited to 78 characters per line. 
      - The strings "Tidy" and "HTML Tidy" are the program name and must not be translated.
      - Don't terminate the last line with a newline. */
      TEXT_GENERAL_INFO_PLEA,       0,
        "Do you speak a language other than English, or a different variant of \n"
        "English? Consider helping us to localize HTML Tidy. For details please see \n"
        "https://github.com/htacg/tidy-html5/blob/master/README/LOCALIZE.md"
    },
    

    /********************************************
     ** Report Output
     ** @remark enum source TidyStrings
     ** @rename enum generator FOREACH_REPORT_MSG
     ********************************************/    
    { ADDED_MISSING_CHARSET,        0,   "Added appropriate missing <meta charset=...> to %s"                      },
    { ANCHOR_NOT_UNIQUE,            0,   "%s anchor \"%s\" already defined"                                        },
    { ANCHOR_DUPLICATED,            0,   "Implicit %s anchor \"%s\" duplicated by Tidy."                           },
    { APOS_UNDEFINED,               0,   "named entity &apos; only defined in XML/XHTML"                           },
    { ATTR_VALUE_NOT_LCASE,         0,   "%s attribute value \"%s\" must be lower case for XHTML"                  },
    { ATTRIBUTE_IS_NOT_ALLOWED,     0,   "%s attribute \"is\" not allowed for autonomous custom tags."             },
    { ATTRIBUTE_VALUE_REPLACED,     0,   "%s attribute \"%s\", incorrect value \"%s\" replaced"                    },
    { BACKSLASH_IN_URI,             0,   "%s URI reference contains backslash. Typo?"                              },
    { BAD_ATTRIBUTE_VALUE_REPLACED, 0,   "%s attribute \"%s\" had invalid value \"%s\" and has been replaced"      },
    { BAD_ATTRIBUTE_VALUE,          0,   "%s attribute \"%s\" has invalid value \"%s\""                            },
    { BAD_CDATA_CONTENT,            0,   "'<' + '/' + letter not allowed here"                                     },
    { BAD_SUMMARY_HTML5,            0,   "The summary attribute on the %s element is obsolete in HTML5"            },
    { BAD_SURROGATE_LEAD,           0,   "Trailing (Low) surrogate pair U+%04X, with no leading (High) entity, replaced with U+FFFD." },
    { BAD_SURROGATE_PAIR,           0,   "Have out-of-range surrogate pair U+%04X:U+%04X, replaced with U+FFFD value."                },
    { BAD_SURROGATE_TAIL,           0,   "Leading (High) surrogate pair U+%04X, with no trailing (Low) entity, replaced with U+FFFD." },
    { CANT_BE_NESTED,               0,   "%s can't be nested"                                                      },
    { COERCE_TO_ENDTAG,             0,   "<%s> is probably intended as </%s>"                                      },
    { CONTENT_AFTER_BODY,           0,   "content occurs after end of body"                                        },
    { CUSTOM_TAG_DETECTED,          0,   "detected autonomous custom tag %s; will treat as %s"                     },
    { DISCARDING_UNEXPECTED,        0,   "discarding unexpected %s"                                                },
    { DOCTYPE_AFTER_TAGS,           0,   "<!DOCTYPE> isn't allowed after elements"                                 },
    { DUPLICATE_FRAMESET,           0,   "repeated FRAMESET element"                                               },
    { ELEMENT_NOT_EMPTY,            0,   "%s element not empty or not closed"                                      },
    { ELEMENT_VERS_MISMATCH_ERROR,  0,   "%s element not available in %s"                                          },
    { ELEMENT_VERS_MISMATCH_WARN,   0,   "%s element not available in %s"                                          },
    { ENCODING_MISMATCH,            0,   "specified input encoding (%s) does not match actual input encoding (%s)" },
    { ESCAPED_ILLEGAL_URI,          0,   "%s escaping malformed URI reference"                                     },
    { FILE_CANT_OPEN,               0,   "Can't open \"%s\"\n"                                                     },
    { FILE_CANT_OPEN_CFG,           0,   "Can't open configuration file \"%s\"\n"                                  },
    { FILE_NOT_FILE,                0,   "\"%s\" is not a file!\n"                                                 },
    { FIXED_BACKSLASH,              0,   "%s converting backslash in URI to slash"                                 },
    { FOUND_STYLE_IN_BODY,          0,   "found <style> tag in <body>! fix-style-tags: yes to move."               },
    { ID_NAME_MISMATCH,             0,   "%s id and name attribute value mismatch"                                 },
    { ILLEGAL_NESTING,              0,   "%s shouldn't be nested"                                                  },
    { ILLEGAL_URI_CODEPOINT,        0,   "%s illegal characters found in URI"                                      },
    { ILLEGAL_URI_REFERENCE,        0,   "%s improperly escaped URI reference"                                     },
    { INSERTING_AUTO_ATTRIBUTE,     0,   "%s inserting \"%s\" attribute using value \"%s\""                        },
    { INSERTING_TAG,                0,   "inserting implicit <%s>"                                                 },
    { INVALID_ATTRIBUTE,            0,   "%s attribute name \"%s\" (value=\"%s\") is invalid"                      },
    { INVALID_NCR,                  0,   "%s invalid numeric character reference %s"                               },
    { INVALID_SGML_CHARS,           0,   "%s invalid character code %s"                                            },
    { INVALID_UTF8,                 0,   "%s invalid UTF-8 bytes (char. code %s)"                                  },
    { INVALID_UTF16,                0,   "%s invalid UTF-16 surrogate pair (char. code %s)"                        },
    { INVALID_XML_ID,               0,   "%s cannot copy name attribute to id"                                     },
    { JOINING_ATTRIBUTE,            0,   "%s joining values of repeated attribute \"%s\""                          },
    { MALFORMED_COMMENT,            0,   "tidy replaced adjacent \"-\" with \"=\""                                 },
    { MALFORMED_COMMENT_DROPPING,   0,   "dropping a possible comment due to a missing hyphen"                     },
    { MALFORMED_COMMENT_EOS,        0,   "the end of the document was reached before the end of the comment"       },
    { MALFORMED_COMMENT_WARN,       0,   "detected adjacent hyphens within the comment; consider fix-bad-comments" },
    { MALFORMED_DOCTYPE,            0,   "discarding malformed <!DOCTYPE>"                                         },
    { MISMATCHED_ATTRIBUTE_ERROR,   0,   "%s attribute \"%s\" not allowed for %s"                                  },
    { MISMATCHED_ATTRIBUTE_WARN,    0,   "%s attribute \"%s\" not allowed for %s"                                  },
    { MISSING_ATTR_VALUE,           0,   "%s attribute \"%s\" lacks value"                                         },
    { MISSING_ATTRIBUTE,            0,   "%s lacks \"%s\" attribute"                                               },
    { MISSING_DOCTYPE,              0,   "missing <!DOCTYPE> declaration"                                          },
    { MISSING_ENDTAG_BEFORE,        0,   "missing </%s> before %s"                                                 },
    { MISSING_ENDTAG_FOR,           0,   "missing </%s>"                                                           },
    { MISSING_ENDTAG_OPTIONAL,      0,   "missing optional end tag </%s>"                                          },
    { MISSING_IMAGEMAP,             0,   "%s should use client-side image map"                                     },
    { MISSING_QUOTEMARK,            0,   "%s attribute with missing trailing quote mark"                           },
    { MISSING_QUOTEMARK_OPEN,       0,   "value for attribute \"%s\" missing quote marks"                          },
    { MISSING_SEMICOLON_NCR,        0,   "numeric character reference \"%s\" doesn't end in ';'"                   },
    { MISSING_SEMICOLON,            0,   "entity \"%s\" doesn't end in ';'"                                        },
    { MISSING_STARTTAG,             0,   "missing <%s>"                                                            },
    { MISSING_TITLE_ELEMENT,        0,   "inserting missing 'title' element"                                       },
    { MOVED_STYLE_TO_HEAD,          0,   "moved <style> tag to <head>! fix-style-tags: no to avoid."               },
    { NESTED_EMPHASIS,              0,   "nested emphasis %s"                                                      },
    { NESTED_QUOTATION,             0,   "nested q elements, possible typo."                                       },
    { NEWLINE_IN_URI,               0,   "%s discarding newline in URI reference"                                  },
    { NOFRAMES_CONTENT,             0,   "%s not inside 'noframes' element"                                        },
    { NON_MATCHING_ENDTAG,          0,   "replacing unexpected %s with </%s>"                                      },
    { OBSOLETE_ELEMENT,             0,   "replacing obsolete element %s with %s"                                   },
    { OPTION_REMOVED,               0,   "option \"%s\" no longer exists, and no replacement could be found."      },
    { OPTION_REMOVED_APPLIED,       0,   "option \"%s\" replaced with \"%s\", which Tidy has set to \"%s\"."       },
    { OPTION_REMOVED_UNAPPLIED,     0,   "option \"%s\" replaced with \"%s\", but Tidy could not set it for you."  },
    { PREVIOUS_LOCATION,            0,   "<%s> previously mentioned"                                               },
    { PROPRIETARY_ATTR_VALUE,       0,   "%s proprietary attribute value \"%s\""                                   },
    { PROPRIETARY_ATTRIBUTE,        0,   "%s proprietary attribute \"%s\""                                         },
    { PROPRIETARY_ELEMENT,          0,   "%s is not approved by W3C"                                               },
    { REMOVED_HTML5,                0,   "%s element removed from HTML5"                                           },
    { REPEATED_ATTRIBUTE,           0,   "%s dropping value \"%s\" for repeated attribute \"%s\""                  },
    { REPLACING_ELEMENT,            0,   "replacing %s with %s"                                                    },
    { REPLACING_UNEX_ELEMENT,       0,   "replacing unexpected %s with %s"                                         },
    { SPACE_PRECEDING_XMLDECL,      0,   "removing whitespace preceding XML Declaration"                           },
    { STRING_ARGUMENT_BAD,          0,   "option \"%s\" given bad argument \"%s\""                                 },
    { STRING_MISSING_MALFORMED,     0,   "missing or malformed argument for option: %s"                            },
    { STRING_MUTING_TYPE,           0,   "messages of type \"%s\" will not be output"                              },
    { STRING_UNKNOWN_OPTION,        0,   "unknown option: %s"                                                      },
    { SUSPECTED_MISSING_QUOTE,      0,   "suspected missing quote mark for attribute value"                        },
    { TAG_NOT_ALLOWED_IN,           0,   "%s isn't allowed in <%s> elements"                                       },
    { TOO_MANY_ELEMENTS_IN,         0,   "too many %s elements in <%s>"                                            },
    { TOO_MANY_ELEMENTS,            0,   "too many %s elements"                                                    },
    { TRIM_EMPTY_ELEMENT,           0,   "trimming empty %s"                                                       },
    { UNESCAPED_AMPERSAND,          0,   "unescaped & which should be written as &amp;"                            },
    { UNEXPECTED_END_OF_FILE_ATTR,  0,   "%s end of file while parsing attributes"                                 },
    { UNEXPECTED_END_OF_FILE,       0,   "unexpected end of file %s"                                               },
    { UNEXPECTED_ENDTAG_ERR,        0,   "unexpected </%s>"                                                        },
    { UNEXPECTED_ENDTAG_IN,         0,   "unexpected </%s> in <%s>"                                                },
    { UNEXPECTED_ENDTAG,            0,   "unexpected </%s>"                                                        },
    { UNEXPECTED_EQUALSIGN,         0,   "%s unexpected '=', expected attribute name"                              },
    { UNEXPECTED_GT,                0,   "%s missing '>' for end of tag"                                           },
    { UNEXPECTED_QUOTEMARK,         0,   "%s unexpected or duplicate quote mark"                                   },
    { UNKNOWN_ELEMENT_LOOKS_CUSTOM, 0,   "%s is not recognized! Did you mean to enable the custom-tags option?"    },
    { UNKNOWN_ELEMENT,              0,   "%s is not recognized!"                                                   },
    { UNKNOWN_ENTITY,               0,   "unescaped & or unknown entity \"%s\""                                    },
    { USING_BR_INPLACE_OF,          0,   "using <br> in place of %s"                                               },
    { VENDOR_SPECIFIC_CHARS,        0,   "%s invalid character code %s"                                            },
    { WHITE_IN_URI,                 0,   "%s discarding whitespace in URI reference"                               },
    { XML_DECLARATION_DETECTED,     0,   "An XML declaration was detected. Did you mean to use input-xml?"         },
    { XML_ID_SYNTAX,                0,   "%s ID \"%s\" uses XML ID syntax"                                         },


    /***************************************
     ** Report Output -- Accessibility
     ***************************************/
    { IMG_MISSING_ALT,                               0,   "[1.1.1.1]: <img> missing 'alt' text."                                     },
    { IMG_ALT_SUSPICIOUS_FILENAME,                   0,   "[1.1.1.2]: suspicious 'alt' text (filename)."                             },
    { IMG_ALT_SUSPICIOUS_FILE_SIZE,                  0,   "[1.1.1.3]: suspicious 'alt' text (file size)."                            },
    { IMG_ALT_SUSPICIOUS_PLACEHOLDER,                0,   "[1.1.1.4]: suspicious 'alt' text (placeholder)."                          },
    { IMG_ALT_SUSPICIOUS_TOO_LONG,                   0,   "[1.1.1.10]: suspicious 'alt' text (too long)."                            },
    { IMG_MISSING_LONGDESC_DLINK,                    0,   "[1.1.2.1]: <img> missing 'longdesc' and d-link."                          },
    { IMG_MISSING_DLINK,                             0,   "[1.1.2.2]: <img> missing d-link."                                         },
    { IMG_MISSING_LONGDESC,                          0,   "[1.1.2.3]: <img> missing 'longdesc'."                                     },
    { IMG_BUTTON_MISSING_ALT,                        0,   "[1.1.3.1]: <img> (button) missing 'alt' text."                            },
    { APPLET_MISSING_ALT,                            0,   "[1.1.4.1]: <applet> missing alternate content."                           },
    { OBJECT_MISSING_ALT,                            0,   "[1.1.5.1]: <object> missing alternate content."                           },
    { AUDIO_MISSING_TEXT_WAV,                        0,   "[1.1.6.1]: audio missing text transcript (wav)."                          },
    { AUDIO_MISSING_TEXT_AU,                         0,   "[1.1.6.2]: audio missing text transcript (au)."                           },
    { AUDIO_MISSING_TEXT_AIFF,                       0,   "[1.1.6.3]: audio missing text transcript (aiff)."                         },
    { AUDIO_MISSING_TEXT_SND,                        0,   "[1.1.6.4]: audio missing text transcript (snd)."                          },
    { AUDIO_MISSING_TEXT_RA,                         0,   "[1.1.6.5]: audio missing text transcript (ra)."                           },
    { AUDIO_MISSING_TEXT_RM,                         0,   "[1.1.6.6]: audio missing text transcript (rm)."                           },
    { FRAME_MISSING_LONGDESC,                        0,   "[1.1.8.1]: <frame> may require 'longdesc'."                               },
    { AREA_MISSING_ALT,                              0,   "[1.1.9.1]: <area> missing 'alt' text."                                    },
    { SCRIPT_MISSING_NOSCRIPT,                       0,   "[1.1.10.1]: <script> missing <noscript> section."                         },
    { ASCII_REQUIRES_DESCRIPTION,                    0,   "[1.1.12.1]: ascii art requires description."                              },
    { IMG_MAP_SERVER_REQUIRES_TEXT_LINKS,            0,   "[1.2.1.1]: image map (server-side) requires text links."                  },
    { MULTIMEDIA_REQUIRES_TEXT,                      0,   "[1.4.1.1]: multimedia requires synchronized text equivalents."            },
    { IMG_MAP_CLIENT_MISSING_TEXT_LINKS,             0,   "[1.5.1.1]: image map (client-side) missing text links."                   },
    { INFORMATION_NOT_CONVEYED_IMAGE,                0,   "[2.1.1.1]: ensure information not conveyed through color alone (image)."  },
    { INFORMATION_NOT_CONVEYED_APPLET,               0,   "[2.1.1.2]: ensure information not conveyed through color alone (applet)." },
    { INFORMATION_NOT_CONVEYED_OBJECT,               0,   "[2.1.1.3]: ensure information not conveyed through color alone (object)." },
    { INFORMATION_NOT_CONVEYED_SCRIPT,               0,   "[2.1.1.4]: ensure information not conveyed through color alone (script)." },
    { INFORMATION_NOT_CONVEYED_INPUT,                0,   "[2.1.1.5]: ensure information not conveyed through color alone (input)."  },
    { COLOR_CONTRAST_TEXT,                           0,   "[2.2.1.1]: poor color contrast (text)."                                   },
    { COLOR_CONTRAST_LINK,                           0,   "[2.2.1.2]: poor color contrast (link)."                                   },
    { COLOR_CONTRAST_ACTIVE_LINK,                    0,   "[2.2.1.3]: poor color contrast (active link)."                            },
    { COLOR_CONTRAST_VISITED_LINK,                   0,   "[2.2.1.4]: poor color contrast (visited link)."                           },
    { DOCTYPE_MISSING,                               0,   "[3.2.1.1]: <doctype> missing."                                            },
    { STYLE_SHEET_CONTROL_PRESENTATION,              0,   "[3.3.1.1]: use style sheets to control presentation."                     },
    { HEADERS_IMPROPERLY_NESTED,                     0,   "[3.5.1.1]: headers improperly nested."                                    },
    { POTENTIAL_HEADER_BOLD,                         0,   "[3.5.2.1]: potential header (bold)."                                      },
    { POTENTIAL_HEADER_ITALICS,                      0,   "[3.5.2.2]: potential header (italics)."                                   },
    { POTENTIAL_HEADER_UNDERLINE,                    0,   "[3.5.2.3]: potential header (underline)."                                 },
    { HEADER_USED_FORMAT_TEXT,                       0,   "[3.5.3.1]: header used to format text."                                   },
    { LIST_USAGE_INVALID_UL,                         0,   "[3.6.1.1]: list usage invalid <ul>."                                      },
    { LIST_USAGE_INVALID_OL,                         0,   "[3.6.1.2]: list usage invalid <ol>."                                      },
    { LIST_USAGE_INVALID_LI,                         0,   "[3.6.1.4]: list usage invalid <li>."                                      },
    { LANGUAGE_NOT_IDENTIFIED,                       0,   "[4.3.1.1]: language not identified."                                      },
    { LANGUAGE_INVALID,                              0,   "[4.3.1.2]: language attribute invalid."                                   },
    { DATA_TABLE_MISSING_HEADERS,                    0,   "[5.1.2.1]: data <table> missing row/column headers (all)."                },
    { DATA_TABLE_MISSING_HEADERS_COLUMN,             0,   "[5.1.2.2]: data <table> missing row/column headers (1 col)."              },
    { DATA_TABLE_MISSING_HEADERS_ROW,                0,   "[5.1.2.3]: data <table> missing row/column headers (1 row)."              },
    { DATA_TABLE_REQUIRE_MARKUP_COLUMN_HEADERS,      0,   "[5.2.1.1]: data <table> may require markup (column headers)."             },
    { DATA_TABLE_REQUIRE_MARKUP_ROW_HEADERS,         0,   "[5.2.1.2]: data <table> may require markup (row headers)."                },
    { LAYOUT_TABLES_LINEARIZE_PROPERLY,              0,   "[5.3.1.1]: verify layout tables linearize properly."                      },
    { LAYOUT_TABLE_INVALID_MARKUP,                   0,   "[5.4.1.1]: invalid markup used in layout <table>."                        },
    { TABLE_MISSING_SUMMARY,                         0,   "[5.5.1.1]: <table> missing summary."                                      },
    { TABLE_SUMMARY_INVALID_NULL,                    0,   "[5.5.1.2]: <table> summary invalid (null)."                               },
    { TABLE_SUMMARY_INVALID_SPACES,                  0,   "[5.5.1.3]: <table> summary invalid (spaces)."                             },
    { TABLE_SUMMARY_INVALID_PLACEHOLDER,             0,   "[5.5.1.6]: <table> summary invalid (placeholder text)."                   },
    { TABLE_MISSING_CAPTION,                         0,   "[5.5.2.1]: <table> missing <caption>."                                    },
    { TABLE_MAY_REQUIRE_HEADER_ABBR,                 0,   "[5.6.1.1]: <table> may require header abbreviations."                     },
    { TABLE_MAY_REQUIRE_HEADER_ABBR_NULL,            0,   "[5.6.1.2]: <table> header abbreviations invalid (null)."                  },
    { TABLE_MAY_REQUIRE_HEADER_ABBR_SPACES,          0,   "[5.6.1.3]: <table> header abbreviations invalid (spaces)."                },
    { STYLESHEETS_REQUIRE_TESTING_LINK,              0,   "[6.1.1.1]: style sheets require testing (link)."                          },
    { STYLESHEETS_REQUIRE_TESTING_STYLE_ELEMENT,     0,   "[6.1.1.2]: style sheets require testing (style element)."                 },
    { STYLESHEETS_REQUIRE_TESTING_STYLE_ATTR,        0,   "[6.1.1.3]: style sheets require testing (style attribute)."               },
    { FRAME_SRC_INVALID,                             0,   "[6.2.1.1]: <frame> source invalid."                                       },
    { TEXT_EQUIVALENTS_REQUIRE_UPDATING_APPLET,      0,   "[6.2.2.1]: text equivalents require updating (applet)."                   },
    { TEXT_EQUIVALENTS_REQUIRE_UPDATING_SCRIPT,      0,   "[6.2.2.2]: text equivalents require updating (script)."                   },
    { TEXT_EQUIVALENTS_REQUIRE_UPDATING_OBJECT,      0,   "[6.2.2.3]: text equivalents require updating (object)."                   },
    { PROGRAMMATIC_OBJECTS_REQUIRE_TESTING_SCRIPT,   0,   "[6.3.1.1]: programmatic objects require testing (script)."                },
    { PROGRAMMATIC_OBJECTS_REQUIRE_TESTING_OBJECT,   0,   "[6.3.1.2]: programmatic objects require testing (object)."                },
    { PROGRAMMATIC_OBJECTS_REQUIRE_TESTING_EMBED,    0,   "[6.3.1.3]: programmatic objects require testing (embed)."                 },
    { PROGRAMMATIC_OBJECTS_REQUIRE_TESTING_APPLET,   0,   "[6.3.1.4]: programmatic objects require testing (applet)."                },
    { FRAME_MISSING_NOFRAMES,                        0,   "[6.5.1.1]: <frameset> missing <noframes> section."                        },
    { NOFRAMES_INVALID_NO_VALUE,                     0,   "[6.5.1.2]: <noframes> section invalid (no value)."                        },
    { NOFRAMES_INVALID_CONTENT,                      0,   "[6.5.1.3]: <noframes> section invalid (content)."                         },
    { NOFRAMES_INVALID_LINK,                         0,   "[6.5.1.4]: <noframes> section invalid (link)."                            },
    { REMOVE_FLICKER_SCRIPT,                         0,   "[7.1.1.1]: remove flicker (script)."                                      },
    { REMOVE_FLICKER_OBJECT,                         0,   "[7.1.1.2]: remove flicker (object)."                                      },
    { REMOVE_FLICKER_EMBED,                          0,   "[7.1.1.3]: remove flicker (embed)."                                       },
    { REMOVE_FLICKER_APPLET,                         0,   "[7.1.1.4]: remove flicker (applet)."                                      },
    { REMOVE_FLICKER_ANIMATED_GIF,                   0,   "[7.1.1.5]: remove flicker (animated gif)."                                },
    { REMOVE_BLINK_MARQUEE,                          0,   "[7.2.1.1]: remove blink/marquee."                                         },
    { REMOVE_AUTO_REFRESH,                           0,   "[7.4.1.1]: remove auto-refresh."                                          },
    { REMOVE_AUTO_REDIRECT,                          0,   "[7.5.1.1]: remove auto-redirect."                                         },
    { ENSURE_PROGRAMMATIC_OBJECTS_ACCESSIBLE_SCRIPT, 0,   "[8.1.1.1]: ensure programmatic objects are accessible (script)."          },
    { ENSURE_PROGRAMMATIC_OBJECTS_ACCESSIBLE_OBJECT, 0,   "[8.1.1.2]: ensure programmatic objects are accessible (object)."          },
    { ENSURE_PROGRAMMATIC_OBJECTS_ACCESSIBLE_APPLET, 0,   "[8.1.1.3]: ensure programmatic objects are accessible (applet)."          },
    { ENSURE_PROGRAMMATIC_OBJECTS_ACCESSIBLE_EMBED,  0,   "[8.1.1.4]: ensure programmatic objects are accessible (embed)."           },
    { IMAGE_MAP_SERVER_SIDE_REQUIRES_CONVERSION,     0,   "[9.1.1.1]: image map (server-side) requires conversion."                  },
    { SCRIPT_NOT_KEYBOARD_ACCESSIBLE_ON_MOUSE_DOWN,  0,   "[9.3.1.1]: <script> not keyboard accessible (onMouseDown)."               },
    { SCRIPT_NOT_KEYBOARD_ACCESSIBLE_ON_MOUSE_UP,    0,   "[9.3.1.2]: <script> not keyboard accessible (onMouseUp)."                 },
    { SCRIPT_NOT_KEYBOARD_ACCESSIBLE_ON_CLICK,       0,   "[9.3.1.3]: <script> not keyboard accessible (onClick)."                   },
    { SCRIPT_NOT_KEYBOARD_ACCESSIBLE_ON_MOUSE_OVER,  0,   "[9.3.1.4]: <script> not keyboard accessible (onMouseOver)."               },
    { SCRIPT_NOT_KEYBOARD_ACCESSIBLE_ON_MOUSE_OUT,   0,   "[9.3.1.5]: <script> not keyboard accessible (onMouseOut)."                },
    { SCRIPT_NOT_KEYBOARD_ACCESSIBLE_ON_MOUSE_MOVE,  0,   "[9.3.1.6]: <script> not keyboard accessible (onMouseMove)."               },
    { NEW_WINDOWS_REQUIRE_WARNING_NEW,               0,   "[10.1.1.1]: new windows require warning (_new)."                          },
    { NEW_WINDOWS_REQUIRE_WARNING_BLANK,             0,   "[10.1.1.2]: new windows require warning (_blank)."                        },
    { REPLACE_DEPRECATED_HTML_APPLET,                0,   "[11.2.1.1]: replace deprecated html <applet>."                            },
    { REPLACE_DEPRECATED_HTML_BASEFONT,              0,   "[11.2.1.2]: replace deprecated html <basefont>."                          },
    { REPLACE_DEPRECATED_HTML_CENTER,                0,   "[11.2.1.3]: replace deprecated html <center>."                            },
    { REPLACE_DEPRECATED_HTML_DIR,                   0,   "[11.2.1.4]: replace deprecated html <dir>."                               },
    { REPLACE_DEPRECATED_HTML_FONT,                  0,   "[11.2.1.5]: replace deprecated html <font>."                              },
    { REPLACE_DEPRECATED_HTML_ISINDEX,               0,   "[11.2.1.6]: replace deprecated html <isindex>."                           },
    { REPLACE_DEPRECATED_HTML_MENU,                  0,   "[11.2.1.7]: replace deprecated html <menu>."                              },
    { REPLACE_DEPRECATED_HTML_S,                     0,   "[11.2.1.8]: replace deprecated html <s>."                                 },
    { REPLACE_DEPRECATED_HTML_STRIKE,                0,   "[11.2.1.9]: replace deprecated html <strike>."                            },
    { REPLACE_DEPRECATED_HTML_U,                     0,   "[11.2.1.10]: replace deprecated html <u>."                                },
    { FRAME_MISSING_TITLE,                           0,   "[12.1.1.1]: <frame> missing title."                                       },
    { FRAME_TITLE_INVALID_NULL,                      0,   "[12.1.1.2]: <frame> title invalid (null)."                                },
    { FRAME_TITLE_INVALID_SPACES,                    0,   "[12.1.1.3]: <frame> title invalid (spaces)."                              },
    { ASSOCIATE_LABELS_EXPLICITLY,                   0,   "[12.4.1.1]: associate labels explicitly with form controls."              },
    { ASSOCIATE_LABELS_EXPLICITLY_FOR,               0,   "[12.4.1.2]: associate labels explicitly with form controls (for)."        },
    { ASSOCIATE_LABELS_EXPLICITLY_ID,                0,   "[12.4.1.3]: associate labels explicitly with form controls (id)."         },
    { LINK_TEXT_NOT_MEANINGFUL,                      0,   "[13.1.1.1]: link text not meaningful."                                    },
    { LINK_TEXT_MISSING,                             0,   "[13.1.1.2]: link text missing."                                           },
    { LINK_TEXT_TOO_LONG,                            0,   "[13.1.1.3]: link text too long."                                          },
    { LINK_TEXT_NOT_MEANINGFUL_CLICK_HERE,           0,   "[13.1.1.4]: link text not meaningful (click here)."                       },
    { METADATA_MISSING,                              0,   "[13.2.1.1]: Metadata missing."                                            },
    { METADATA_MISSING_REDIRECT_AUTOREFRESH,         0,   "[13.2.1.3]: Metadata missing (redirect/auto-refresh)."                    },
    { SKIPOVER_ASCII_ART,                            0,   "[13.10.1.1]: skip over ascii art."                                        },
    
    
#if SUPPORT_CONSOLE_APP
    /********************************************************
     ** Console Application
     **  Although these strings are not used within LibTidy
     **  and only for the console application, they are
     **  provided as part of LibTidy for convenience to
     **  developers.
     ********************************************************/
    { TC_LABEL_COL,                 0,   "column"                                                                  },
    { TC_LABEL_FILE,                0,   "file"                                                                    },
    { TC_LABEL_LANG,                0,   "lang"                                                                    },
    { TC_LABEL_LEVL,                0,   "level"                                                                   },
    { TC_LABEL_OPT,                 0,   "option"                                                                  },
    { TC_MAIN_ERROR_LOAD_CONFIG,    0,   "Loading config file \"%s\" problems, err = %d"                             },
    { TC_OPT_ACCESS,                0,
        "do additional accessibility checks (<level> = 0, 1, 2, 3). 0 is "
        "assumed if <level> is missing."
    },
    { TC_OPT_ASCII,                 0,   "use ISO-8859-1 for input, US-ASCII for output"                           },
    { TC_OPT_ASHTML,                0,   "force XHTML to well formed HTML"                                         },
    { TC_OPT_ASXML,                 0,   "convert HTML to well formed XHTML"                                       },
    { TC_OPT_BARE,                  0,   "strip out smart quotes and em dashes, etc."                              },
    { TC_OPT_BIG5,                  0,   "use Big5 for both input and output"                                      },
    { TC_OPT_CLEAN,                 0,   "replace FONT, NOBR and CENTER tags with CSS"                             },
    { TC_OPT_CONFIG,                0,   "set configuration options from the specified <file>"                     },
    { TC_OPT_ERRORS,                0,   "show only errors and warnings"                                           },
    { TC_OPT_FILE,                  0,   "write errors and warnings to the specified <file>"                       },
    { TC_OPT_GDOC,                  0,   "produce clean version of html exported by Google Docs"                   },
    { TC_OPT_HELP,                  0,   "list the command line options"                                           },
    { TC_OPT_HELPCFG,               0,   "list all configuration options"                                          },
    { TC_OPT_HELPENV,               0,   "show information about the environment and runtime configuration"        },
    { TC_OPT_HELPOPT,               0,   "show a description of the <option>"                                      },
    { TC_OPT_IBM858,                0,   "use IBM-858 (CP850+Euro) for input, US-ASCII for output"                 },
    { TC_OPT_INDENT,                0,   "indent element content"                                                  },
    { TC_OPT_ISO2022,               0,   "use ISO-2022 for both input and output"                                  },

    {/* The strings "Tidy" and "HTML Tidy" are the program name and must not be translated. */
      TC_OPT_LANGUAGE,              0,
        "set Tidy's output language to <lang>. Specify '-language help' for more help. "
        "Use before output-causing arguments to ensure the language takes effect, e.g.,"
        "`tidy -lang es -lang help`."
    },

    { TC_OPT_LATIN0,                0,   "use ISO-8859-15 for input, US-ASCII for output"                          },
    { TC_OPT_LATIN1,                0,   "use ISO-8859-1 for both input and output"                                },
    { TC_OPT_MAC,                   0,   "use MacRoman for input, US-ASCII for output"                             },
    { TC_OPT_MODIFY,                0,   "modify the original input files"                                         },
    { TC_OPT_NUMERIC,               0,   "output numeric rather than named entities"                               },
    { TC_OPT_OMIT,                  0,   "omit optional start tags and end tags"                                   },
    { TC_OPT_OUTPUT,                0,   "write output to the specified <file>"                                    },
    { TC_OPT_QUIET,                 0,   "suppress nonessential output"                                            },
    { TC_OPT_RAW,                   0,   "output values above 127 without conversion to entities"                  },
    { TC_OPT_SHIFTJIS,              0,   "use Shift_JIS for both input and output"                                 },
    { TC_OPT_SHOWCFG,               0,   "list the current configuration settings"                                 },
    { TC_OPT_EXP_CFG,               0,   "list the current configuration settings, suitable for a config file"     },
    { TC_OPT_EXP_DEF,               0,   "list the default configuration settings, suitable for a config file"     },
    { TC_OPT_UPPER,                 0,   "force tags to upper case"                                                },
    { TC_OPT_UTF16,                 0,   "use UTF-16 for both input and output"                                    },
    { TC_OPT_UTF16BE,               0,   "use UTF-16BE for both input and output"                                  },
    { TC_OPT_UTF16LE,               0,   "use UTF-16LE for both input and output"                                  },
    { TC_OPT_UTF8,                  0,   "use UTF-8 for both input and output"                                     },

    {/* The strings "Tidy" and "HTML Tidy" are the program name and must not be translated. */
      TC_OPT_VERSION,               0,   "show the version of Tidy"
    },

    { TC_OPT_WIN1252,               0,   "use Windows-1252 for input, US-ASCII for output"                         },
    { TC_OPT_WRAP,                  0,
        "wrap text at the specified <column>. 0 is assumed if <column> is "
        "missing. When this option is omitted, the default of the "
        "configuration option 'wrap' applies."
    },
    { TC_OPT_XML,                   0,   "specify the input is well formed XML"                                    },
    { TC_OPT_XMLCFG,                0,   "list all configuration options in XML format"                            },
    { TC_OPT_XMLHELP,               0,   "list the command line options in XML format"                             },

    {/* The strings "Tidy" and "HTML Tidy" are the program name and must not be translated. */
      TC_OPT_XMLSTRG,               0,   "output all of Tidy's strings in XML format"
    },

    { TC_OPT_XMLERRS,               0,   "output error constants and strings in XML format"                        },

    { TC_OPT_XMLOPTS,               0,   "output option descriptions in XML format"                                },
    
    { TC_STRING_CONF_HEADER,        0,   "Configuration File Settings:"                                            },

    {/* Must be 27 characters or fewer. */
      TC_STRING_CONF_NAME,          0,   "Name"
    },
    {/* Must be 9 characters or fewer. */
      TC_STRING_CONF_TYPE,          0,   "Type"
    },
    {/* Must be 40 characters or fewer. */
      TC_STRING_CONF_VALUE,         0,   "Current Value"
    },

    { TC_STRING_OPT_NOT_DOCUMENTED, 0,   "Warning: option `%s' is not documented."                                 },
    { TC_STRING_OUT_OF_MEMORY,      0,   "Out of memory. Bailing out."                                             },
    { TC_STRING_FATAL_ERROR,        0,   "Fatal error: impossible value for id='%d'."                              },
    { TC_STRING_FILE_MANIP,         0,   "File manipulation"                                                       },
    { TC_STRING_PROCESS_DIRECTIVES, 0,   "Processing directives"                                                   },
    { TC_STRING_CHAR_ENCODING,      0,   "Character encodings"                                                     },
    { TC_STRING_LANG_MUST_SPECIFY,  0,   "A POSIX or Windows locale must be specified."                            },

    {/* The strings "Tidy" and "HTML Tidy" are the program name and must not be translated. */
      TC_STRING_LANG_NOT_FOUND,     0,   "Tidy doesn't have language '%s,' will use '%s' instead."
    },

    { TC_STRING_MISC,               0,   "Miscellaneous"                                                           },
    { TC_STRING_XML,                0,   "XML"                                                                     },
    { TC_STRING_MUST_SPECIFY,       0,   "A Tidy option name must be specified."                                   },

    {/* The strings "Tidy" and "HTML Tidy" are the program name and must not be translated. */
      TC_STRING_UNKNOWN_OPTION,     0,   "HTML Tidy: unknown option: %c"
    },
    {/* The strings "Tidy" and "HTML Tidy" are the program name and must not be translated. */
      TC_STRING_UNKNOWN_OPTION_B,   0,   "HTML Tidy: unknown option."
    },
    {/* The strings "Tidy" and "HTML Tidy" are the program name and must not be translated. */
      TC_STRING_VERS_A,             0,   "HTML Tidy for %s version %s"
    },
    {/* The strings "Tidy" and "HTML Tidy" are the program name and must not be translated. */
      TC_STRING_VERS_B,             0,   "HTML Tidy version %s"
    },

    {/* This console output should be limited to 78 characters per line.
        - First %s represents the name of the executable from the file system, and is mostly like going to be "tidy".
        - Second %s represents a version number, typically x.x.xx.
        - The strings "Tidy" and "HTML Tidy" are the program name and must not be translated. */
      TC_TXT_HELP_1,                0,
        "%s [options...] [file...] [options...] [file...]\n"
        "Utility to clean up and pretty print HTML/XHTML/XML.\n"
        "\n"
        "This is modern HTML Tidy version %s.\n"
        "\n"
    },
    {/* The strings "Tidy" and "HTML Tidy" are the program name and must not be translated.
        - %s represents the platform, for example, "Mac OS X" or "Windows". */
      TC_TXT_HELP_2A,               0,
        "Command Line Arguments for HTML Tidy for %s:"
    },
    {/* The strings "Tidy" and "HTML Tidy" are the program name and must not be translated. */
      TC_TXT_HELP_2B,               0,
        "Command Line Arguments for HTML Tidy:"
    },
    {/* This console output should be limited to 78 characters per line. 
        - The strings "Tidy" and "HTML Tidy" are the program name and must not be translated.
        - %s represents either a blank line, or TC_TXT_HELP_3A explaining environment options. */
      TC_TXT_HELP_3,                0,
        "\n"
        "Tidy Configuration Options\n"
        "==========================\n"
        " Use Tidy's configuration options as command line arguments in the form\n"
        " of \"--some-option <value>\", for example, \"--indent-with-tabs yes\".\n"
        "\n"
        " You can also specify a file containing configuration options with the \n"
        " -options <file> directive, or in one or more files specific to your \n"
        " environment (see next section). \n"
        "\n"
        " For a list of all configuration options, use \"-help-config\" or refer\n"
        " to the man page (if your OS has one).\n"
        "\n"
        "Configuration Files\n"
        "===================\n"
        " If your environment has an $HTML_TIDY variable set to point to a Tidy \n"
        " configuration file, then Tidy will attempt to use it. \n"
        "%s"
        " Use \"-help-env\" for more information about how you can use the environment. \n"
        " to specify Tidy options. \n"
        "\n"
        "Other\n"
        "=====\n"
        " Input/Output default to stdin/stdout respectively.\n"
        "\n"
        " Single letter options apart from -f may be combined\n"
        " as in:  tidy -f errs.txt -imu foo.html\n"
        "\n"
        "Information\n"
        "===========\n"
        " For more information about HTML Tidy, see\n"
        "  http://www.html-tidy.org/\n"
        "\n"
        " For more information on HTML, see the following:\n"
        "\n"
        "   HTML: Edition for Web Authors (the latest HTML specification)\n"
        "   http://dev.w3.org/html5/spec-author-view\n"
        "\n"
        "   HTML: The Markup Language (an HTML language reference)\n"
        "   http://dev.w3.org/html5/markup/\n"
        "\n"
        " File bug reports at https://github.com/htacg/tidy-html5/issues/\n"
        " or send questions and comments to public-htacg@w3.org.\n"
        "\n"
        " Validate your HTML documents using the W3C Nu Markup Validator:\n"
        "   http://validator.w3.org/nu/\n"
        "\n"
    },
    {/* This console output should be limited to 78 characters per line.
        - The strings "Tidy" and "HTML Tidy" are the program name and must not be translated.
        - Both parameters %s reflect file paths and names. */
      TC_TXT_HELP_3A,               0,
        "\n"
        " Additionally, Tidy will automatically attempt to use configuration specified \n"
        " in these files, if present: \n"
        "\n"
        "  %s \n"
        "  %s \n"
        "\n"
    },
    {/* This console output should be limited to 78 characters per line.
        - The strings "Tidy" and "HTML Tidy" are the program name and must not be translated. */
      TC_TXT_HELP_CONFIG,           0,
        "\n"
        "HTML Tidy Configuration Settings\n"
        "\n"
        "Within a file, use the form:\n"
        "\n"
        "wrap: 72\n"
        "indent: no\n"
        "\n"
        "When specified on the command line, use the form:\n"
        "\n"
        "--wrap 72 --indent no\n"
        "\n"
    },
    { TC_TXT_HELP_CONFIG_NAME,      0,   "Name"                                                                    },
    { TC_TXT_HELP_CONFIG_TYPE,      0,   "Type"                                                                    },
    { TC_TXT_HELP_CONFIG_ALLW,      0,   "Allowable values"                                                        },
    {/* This console output should be limited to 78 characters per line.
        - The strings "Tidy" and "HTML Tidy" are the program name and must not be translated.
        - The first %s indicates two more list items, or an empty string.
        - The second %s indicates a file name, or a message indicating no file name. */
      TC_TXT_HELP_ENV_1,           0,
        "\n"
        "Tidy can configure its option values from multiple sources, in the \n"
        "order below. Subsequent use of the same option overrides previous \n"
        "option settings. \n"
        "\n"
        " - Tidy's built-in default values. \n"
        "%s" /* rc files */
        " - The file specified in the $HTML_TIDY environment variable: \n"
        "     %s \n"
        " - Options in a file specified on the command line. \n"
        " - Options set directly on the command line. \n"
    },
    {/* This console output should be limited to 78 characters per line.
        - The strings "Tidy" and "HTML Tidy" are the program name and must not be translated. */
      TC_TXT_HELP_ENV_1A,          0,
        " - The system runtime configuration file: \n"
        "     %s \n"
        " - The user runtime configuration file: \n"
        "     %s \n"
    },
    {/* This console output should be limited to 78 characters per line.
        - The strings "Tidy" and "HTML Tidy" are the program name and must not be translated.
        - This message indicates that a file name is not currently set. */
      TC_TXT_HELP_ENV_1B,          0,
        "(not currently set)"
    },
    {/* This console output should be limited to 78 characters per line.
        - The strings "Tidy" and "HTML Tidy" are the program name and must not be translated. */
      TC_TXT_HELP_ENV_1C,          0,
        "\n"
        "Note that because $HTML_TIDY is set, the user runtime configuration file \n"
        "%s will not be used. \n"
    },
    {/* This console output should be limited to 78 characters per line.
        - The strings "Tidy" and "HTML Tidy" are the program name and must not be translated. */
      TC_TXT_HELP_LANG_1,           0,
        "\n"
        "The -language (or -lang) option indicates which language Tidy \n"
        "should use to communicate its output. Please note that this is not \n"
        "a document translation service, and only affects the messages that \n"
        "Tidy communicates to you. \n"
        "\n"
        "When used from the command line the -language argument must \n"
        "be used before any arguments that result in output, otherwise Tidy \n"
        "will produce output before it knows which language to use. \n"
        "\n"
        "In addition to standard POSIX language codes, Tidy is capable of \n"
        "understanding legacy Windows language codes. Please note that this \n"
        "list indicates codes Tidy understands, and does not indicate that \n"
        "the language is currently installed. \n"
        "\n"
        "The rightmost column indicates how Tidy will understand the \n"
        "legacy Windows name.\n"
        "\n"
    },
    {/* This console output should be limited to 78 characters per line.
        - The strings "Tidy" and "HTML Tidy" are the program name and must not be translated. */
      TC_TXT_HELP_LANG_2,           0,
        "\n"
        "The following languages are currently installed in Tidy. Please \n"
        "note that there's no guarantee that they are complete; only that \n"
        "one developer or another started to add the language indicated. \n"
        "\n"
        "Incomplete localizations will default to \"en\" when necessary. \n"
        "Please report instances of incorrect strings to the Tidy team. \n"
        "\n"
    },
    {/* This console output should be limited to 78 characters per line.
        - The strings "Tidy" and "HTML Tidy" are the program name and must not be translated.
        - The parameter %s is likely to be two to five characters, e.g., en or en_US. */
      TC_TXT_HELP_LANG_3,           0,
        "\n"
        "If Tidy is able to determine your locale then Tidy will use the \n"
        "locale's language automatically. For example Unix-like systems use a \n"
        "$LANG and/or $LC_ALL environment variable. Consult your operating \n"
        "system documentation for more information. \n"
        "\n"
        "Tidy is currently using locale %s. \n"
        "\n"
    },
#endif /* SUPPORT_CONSOLE_APP */
    
    {/* This MUST be present and last. */
      TIDY_MESSAGE_TYPE_LAST,      0,   NULL
    }
}};


#endif /* language_en_h */
#ifndef language_en_gb_h
#define language_en_gb_h
/*
 * language_en_gb.h
 * Localization support for HTML Tidy.
 *
 *
 * This file is a localization file for HTML Tidy. It will have been machine
 * generated or created and/or edited by hand. Both are valid options, but
 * please help keep our localization efforts simple to maintain by maintaining
 * the structure of this file, and changing the check box below if you make
 * changes (so others know the file origin):
 *
 * [X] THIS FILE IS MACHINE GENERATED. It is a localization file for the
 *     language (and maybe region) "en_gb". The source of
 *     these strings is a gettext PO file in Tidy's source, probably called 
 *     "language_en_gb.po".
 *
 * [ ] THIS FILE WAS HAND MODIFIED. Translators, please feel to edit this file
 *     directly (and check this box). If you prefer to edit PO files then use
 *     `poconvert.rb msgunfmt language_en_gb.h` (our own
 *     conversion tool) to generate a fresh PO from this file first!
 *
 * (c) 2015-2017 HTACG
 * See tidy.h and access.h for the copyright notice.
 *
 * Template Created by Jim Derry on 01/14/2016.
 *
 * Orginating PO file metadata:
 *   PO_LAST_TRANSLATOR=jderry
 *   PO_REVISION_DATE=2017-10-03 12:44:37
 */

#ifdef _MSC_VER
#pragma execution_character_set("utf-8")
#endif


/**
 *  This language-specific function returns the correct pluralForm
 *  to use given n items, and is used as a member of each language
 *  definition.
 */
static unsigned int whichPluralForm_en_gb(unsigned int n) {
    /* Plural-Forms: nplurals=2; */
    return n != 1;
}


/**
 *  This structure specifies all of the strings needed by Tidy for a
 *  single language. Static definition in a header file makes it
 *  easy to include and exclude languages without tinkering with
 *  the build system.
 */
static languageDefinition language_en_gb = { whichPluralForm_en_gb, {
    /***************************************
     ** This MUST be present and first. 
     ** Specify the code for this language.
     ***************************************/
    {/* Specify the ll or ll_cc language code here. */
      TIDY_LANGUAGE,                    0, "en_gb"
    },
    { TidyAsciiChars,                   0,        
        "Can be used to modify behaviour of the <code>clean</code> option when set "
        "to <var>yes</var>. "
        "<br/>"
        "If set to <var>yes</var> when using <code>clean</code>, "
        "<code>&amp;emdash;</code>, <code>&amp;rdquo;</code>, and other named "
        "character entities are downgraded to their closest ASCII equivalents. "
    },
    { TidyGDocClean,                    0,        
        "This option specifies if Tidy should enable specific behaviour for "
        "cleaning up HTML exported from Google Docs. "
    },
    { TidyLiteralAttribs,               0,        
        "This option specifies how Tidy deals with whitespace characters within "
        "attribute values. "
        "<br/>"
        "If the value is <var>no</var> Tidy normalises attribute values by "
        "replacing any newline or tab with a single space, and further by replacing "
        "any contiguous whitespace with a single space. "
        "<br/>"
        "To force Tidy to preserve the original, literal values of all attributes "
        "and ensure that whitespace within attribute values is passed "
        "through unchanged, set this option to <var>yes</var>. "
    },
    { TidyMergeDivs,                    0,        
        "This option can be used to modify the behaviour of <code>clean</code> when "
        "set to <code>yes</code>."
        "<br/>"
        "This option specifies if Tidy should merge nested <code>&lt;div&gt;</code> "
        "such as <code>&lt;div&gt;&lt;div&gt;...&lt;/div&gt;&lt;/div&gt;</code>. "
        "<br/>"
        "If set to <code>auto</code> the attributes of the inner "
        "<code>&lt;div&gt;</code> are moved to the outer one. Nested "
        "<code>&lt;div&gt;</code> with <code>id</code> attributes are <em>not</em> "
        "merged. "
        "<br/>"
        "If set to <code>yes</code> the attributes of the inner "
        "<code>&lt;div&gt;</code> are discarded with the exception of "
        "<code>class</code> and <code>style</code>. "
    },
    { TidyMergeSpans,                   0,        
        "This option can be used to modify the behaviour of <code>clean</code> when "
        "set to <code>yes</code>."
        "<br/>"
        "This option specifies if Tidy should merge nested <code>&lt;span&gt;</code> "
        "such as <code>&lt;span&gt;&lt;span&gt;...&lt;/span&gt;&lt;/span&gt;</code>. "
        "<br/>"
        "The algorithm is identical to the one used by <code>merge-divs</code>. "
    },
    { TidyReplaceColor,                 0,        
        "This option specifies if Tidy should replace numeric values in colour "
        "attributes with HTML/XHTML colour names where defined, e.g. replace "
        "<code>#ffffff</code> with <code>white</code>. "
    },
    { TidyUseCustomTags,                0,        
        "This option enables the use of tags for autonomous custom elements, "
        "e.g. &lt;flag-icon&gt; with Tidy. Custom tags are disabled if this "
        "value is <var>no</var>. Other settings - <var>blocklevel</var>, "
        "<var>empty</var>, <var>inline</var>, and <var>pre</var> will treat "
        "<em>all</em> detected custom tags accordingly. "
        "<br/>"
        "The use of <code>new-blocklevel-tags</code>, "
        "<code>new-empty-tags</code>, <code>new-inline-tags</code>, or "
        "<code>new-pre-tags</code> will override the treatment of custom tags "
        "by this configuration option. This may be useful if you have "
        "different types of custom tags."
        "<br/>"
        "When enabled these tags are determined during the processing of your "
        "document using opening tags; matching closing tags will be recognised "
        "accordingly, and unknown closing tags will be discarded. "
    },
    { TEXT_USING_FONT,                  0,        
        "You are recommended to use CSS to specify the font and\n"
        "properties such as its size and colour. This will reduce\n"
        "the size of HTML files and make them easier to maintain\n"
        "compared with using <FONT> elements.\n\n"
    },
    { TEXT_USING_BODY,                  0, "You are recommended to use CSS to specify page and link colours\n"           },
    { TEXT_GENERAL_INFO_PLEA,           0,        
        "\n"
        "Would you like to see Tidy in proper, British English? Please consider \n"
        "helping us to localise HTML Tidy. For details please see \n"
        "https://github.com/htacg/tidy-html5/blob/master/README/LOCALIZE.md\n"
    },
    { UNKNOWN_ELEMENT_LOOKS_CUSTOM,     0, "%s is not recognised! Did you mean to enable the custom-tags option?"        },
    { UNKNOWN_ELEMENT,                  0, "%s is not recognised!"                                                       },
    { MULTIMEDIA_REQUIRES_TEXT,         0, "[1.4.1.1]: multimedia requires synchronised text equivalents."               },
    { INFORMATION_NOT_CONVEYED_IMAGE,   0, "[2.1.1.1]: ensure information not conveyed through colour alone (image)."    },
    { INFORMATION_NOT_CONVEYED_APPLET,  0, "[2.1.1.2]: ensure information not conveyed through colour alone (applet)."   },
    { INFORMATION_NOT_CONVEYED_OBJECT,  0, "[2.1.1.3]: ensure information not conveyed through colour alone (object)."   },
    { INFORMATION_NOT_CONVEYED_SCRIPT,  0, "[2.1.1.4]: ensure information not conveyed through colour alone (script)."   },
    { INFORMATION_NOT_CONVEYED_INPUT,   0, "[2.1.1.5]: ensure information not conveyed through colour alone (input)."    },
    { COLOR_CONTRAST_TEXT,              0, "[2.2.1.1]: poor colour contrast (text)."                                     },
    { COLOR_CONTRAST_LINK,              0, "[2.2.1.2]: poor colour contrast (link)."                                     },
    { COLOR_CONTRAST_ACTIVE_LINK,       0, "[2.2.1.3]: poor colour contrast (active link)."                              },
    { COLOR_CONTRAST_VISITED_LINK,      0, "[2.2.1.4]: poor colour contrast (visited link)."                             },
    { LAYOUT_TABLES_LINEARIZE_PROPERLY, 0, "[5.3.1.1]: verify layout tables linearise properly."                         },

#if SUPPORT_CONSOLE_APP
    { TC_TXT_HELP_LANG_2,               0,        
        "\n"
        "The following languages are currently installed in Tidy. Please \n"
        "note that there's no guarantee that they are complete; only that \n"
        "one developer or another started to add the language indicated. \n"
        "\n"
        "Incomplete localisations will default to \"en\" when necessary. \n"
        "Please report instances of incorrect strings to the Tidy team. \n"
        "\n"
    },
#endif /* SUPPORT_CONSOLE_APP */

    {/* This MUST be present and last. */
      TIDY_MESSAGE_TYPE_LAST,           0, NULL
    }

}};


#endif /* language_en_gb_h */

#ifndef language_es_h
#define language_es_h
/*
 * language_es.h
 * Localization support for HTML Tidy.
 *
 *
 * This file is a localization file for HTML Tidy. It will have been machine
 * generated or created and/or edited by hand. Both are valid options, but
 * please help keep our localization efforts simple to maintain by maintaining
 * the structure of this file, and changing the check box below if you make
 * changes (so others know the file origin):
 *
 * [X] THIS FILE IS MACHINE GENERATED. It is a localization file for the
 *     language (and maybe region) "es". The source of
 *     these strings is a gettext PO file in Tidy's source, probably called 
 *     "language_es.po".
 *
 * [ ] THIS FILE WAS HAND MODIFIED. Translators, please feel to edit this file
 *     directly (and check this box). If you prefer to edit PO files then use
 *     `poconvert.rb msgunfmt language_es.h` (our own
 *     conversion tool) to generate a fresh PO from this file first!
 *
 * (c) 2015-2017 HTACG
 * See tidy.h and access.h for the copyright notice.
 *
 * Template Created by Jim Derry on 01/14/2016.
 *
 * Orginating PO file metadata:
 *   PO_LAST_TRANSLATOR=jderry
 *   PO_REVISION_DATE=2017-10-03 12:44:37
 */

#ifdef _MSC_VER
#pragma execution_character_set("utf-8")
#endif


/**
 *  This language-specific function returns the correct pluralForm
 *  to use given n items, and is used as a member of each language
 *  definition.
 */
static unsigned int whichPluralForm_es(unsigned int n) {
    /* Plural-Forms: nplurals=2; */
    return n != 1;
}


/**
 *  This structure specifies all of the strings needed by Tidy for a
 *  single language. Static definition in a header file makes it
 *  easy to include and exclude languages without tinkering with
 *  the build system.
 */
static languageDefinition language_es = { whichPluralForm_es, {
    /***************************************
     ** This MUST be present and first. 
     ** Specify the code for this language.
     ***************************************/
    {/* Specify the ll or ll_cc language code here. */
      TIDY_LANGUAGE,          0, "es"
    },
    { TidyMakeClean,          0,        
        "Esta opción especifica si Tidy debe realizar la limpieza de algún legado etiquetas de "
        "presentación (actualmente <code>&lt;i&gt;</code>, <code>&lt;b&gt;</code>, <code>&lt;center&gt;</"
        "code> cuando encerrados dentro de las etiquetas apropiadas en línea y <code>&lt;font&gt;</"
        "code>). Si se establece en <code>yes</code>, entonces etiquetas existentes serán reemplazados "
        "con CSS <code>&lt;style&gt;</code> y estructural markup según corresponda. "
    },
    { TidyNCR,                0, "Esta opción especifica si Tidy debe permitir referencias de caracteres numéricos. "   },
    { TEXT_GENERAL_INFO_PLEA, 0,        
        "\n"
        "¿Le gustaría ver Tidy en un español correcto? Por favor considere \n"
        "ayudarnos a localizar HTML Tidy. Para más detalles consulte \n"
        "https://github.com/htacg/tidy-html5/blob/master/README/LOCALIZE.md \n"
    },

#if SUPPORT_CONSOLE_APP
    { TC_TXT_HELP_LANG_1,     0,        
        "\n"
        "La opción -language (o -lang) indica el lenguaje Tidy debe \n"
        "utilizar para comunicar su salida. Tenga en cuenta que esto no es \n"
        "un servicio de traducción de documentos, y sólo afecta a los mensajes \n"
        "que Tidy comunica a usted. \n"
        "\n"
        "Cuando se utiliza la línea de comandos el argumento -language debe \n"
        "utilizarse antes de cualquier argumento que dan lugar a la producción, \n"
        "de lo contrario Tidy producirá la salida antes de que se conozca el \n"
        "idioma a utilizar. \n"
        "\n"
        "Además de los códigos de idioma estándar POSIX, Tidy es capaz de \n"
        "entender códigos de idioma legados de Windows. Tenga en cuenta que \n"
        "este lista indica los códigos Tidy entiende, y no indica que \n"
        "actualmente el idioma está instalado. \n"
        "\n"
        "La columna más a la derecha indica cómo Tidy comprenderá el \n"
        "legado nombre de Windows.\n"
        "\n"
        "Tidy está utilizando la configuración regional %s. \n"
        "\n"
    },
    { TC_TXT_HELP_LANG_2,     0,        
        "\n"
        "Los siguientes idiomas están instalados actualmente en Tidy. Tenga \n"
        "en cuenta que no hay garantía de que están completos; sólo quiere decir \n"
        "que un desarrollador u otro comenzaron a añadir el idioma indicado. \n"
        "\n"
        "Localizaciones incompletas por defecto se usan \"en\" cuando sea \n"
        "necesario. ¡Favor de informar los desarrolladores de estes casos! \n"
        "\n"
    },
    { TC_TXT_HELP_LANG_3,     0,        
        "\n"
        "Si Tidy es capaz de determinar la configuración regional entonces \n"
        "Tidy utilizará el lenguaje de forma automática de la configuración \n"
        "regional. Por ejemplo los sistemas de tipo Unix utilizan los variables \n"
        "$LANG y/o $LC_ALL. Consulte a su documentación del sistema para \n"
        "obtener más información.\n"
        "\n"
        "Tidy está utilizando la configuración regional %s. \n"
        "\n"
    },
#endif /* SUPPORT_CONSOLE_APP */

    {/* This MUST be present and last. */
      TIDY_MESSAGE_TYPE_LAST, 0, NULL
    }

}};


#endif /* language_es_h */

#ifndef language_es_mx_h
#define language_es_mx_h
/*
 * language_es_mx.h
 * Localization support for HTML Tidy.
 *
 *
 * This file is a localization file for HTML Tidy. It will have been machine
 * generated or created and/or edited by hand. Both are valid options, but
 * please help keep our localization efforts simple to maintain by maintaining
 * the structure of this file, and changing the check box below if you make
 * changes (so others know the file origin):
 *
 * [X] THIS FILE IS MACHINE GENERATED. It is a localization file for the
 *     language (and maybe region) "es_mx". The source of
 *     these strings is a gettext PO file in Tidy's source, probably called 
 *     "language_es_mx.po".
 *
 * [ ] THIS FILE WAS HAND MODIFIED. Translators, please feel to edit this file
 *     directly (and check this box). If you prefer to edit PO files then use
 *     `poconvert.rb msgunfmt language_es_mx.h` (our own
 *     conversion tool) to generate a fresh PO from this file first!
 *
 * (c) 2015-2017 HTACG
 * See tidy.h and access.h for the copyright notice.
 *
 * Template Created by Jim Derry on 01/14/2016.
 *
 * Orginating PO file metadata:
 *   PO_LAST_TRANSLATOR=jderry
 *   PO_REVISION_DATE=2017-10-03 12:44:37
 */

#ifdef _MSC_VER
#pragma execution_character_set("utf-8")
#endif


/**
 *  This language-specific function returns the correct pluralForm
 *  to use given n items, and is used as a member of each language
 *  definition.
 */
static unsigned int whichPluralForm_es_mx(unsigned int n) {
    /* Plural-Forms: nplurals=2; */
    return n != 1;
}


/**
 *  This structure specifies all of the strings needed by Tidy for a
 *  single language. Static definition in a header file makes it
 *  easy to include and exclude languages without tinkering with
 *  the build system.
 */
static languageDefinition language_es_mx = { whichPluralForm_es_mx, {
    /***************************************
     ** This MUST be present and first. 
     ** Specify the code for this language.
     ***************************************/
    {/* Specify the ll or ll_cc language code here. */
      TIDY_LANGUAGE,          0, "es_mx"
    },
    { TEXT_GENERAL_INFO_PLEA, 0,        
        "\n"
        "¿Le gustaría ver Tidy en adecuada, español mexicano? Por favor considere \n"
        "ayudarnos a localizar HTML Tidy. Para más detalles consulte \n"
        "https://github.com/htacg/tidy-html5/blob/master/README/LOCALIZE.md \n"
    },

    {/* This MUST be present and last. */
      TIDY_MESSAGE_TYPE_LAST, 0, NULL
    }

}};


#endif /* language_es_mx_h */

#ifndef language_fr_h
#define language_fr_h
/*
 * language_fr.h
 * Localization support for HTML Tidy.
 *
 *
 * This file is a localization file for HTML Tidy. It will have been machine
 * generated or created and/or edited by hand. Both are valid options, but
 * please help keep our localization efforts simple to maintain by maintaining
 * the structure of this file, and changing the check box below if you make
 * changes (so others know the file origin):
 *
 * [X] THIS FILE IS MACHINE GENERATED. It is a localization file for the
 *     language (and maybe region) "fr". The source of
 *     these strings is a gettext PO file in Tidy's source, probably called 
 *     "language_fr.po".
 *
 * [ ] THIS FILE WAS HAND MODIFIED. Translators, please feel to edit this file
 *     directly (and check this box). If you prefer to edit PO files then use
 *     `poconvert.rb msgunfmt language_fr.h` (our own
 *     conversion tool) to generate a fresh PO from this file first!
 *
 * (c) 2015-2017 HTACG
 * See tidy.h and access.h for the copyright notice.
 *
 * Template Created by Jim Derry on 01/14/2016.
 *
 * Orginating PO file metadata:
 *   PO_LAST_TRANSLATOR=jderry
 *   PO_REVISION_DATE=2017-10-05 15:13:40
 */

#ifdef _MSC_VER
#pragma execution_character_set("utf-8")
#endif


/**
 *  This language-specific function returns the correct pluralForm
 *  to use given n items, and is used as a member of each language
 *  definition.
 */
static unsigned int whichPluralForm_fr(unsigned int n) {
    /* Plural-Forms: nplurals=2; */
    return (n > 1);
}


/**
 *  This structure specifies all of the strings needed by Tidy for a
 *  single language. Static definition in a header file makes it
 *  easy to include and exclude languages without tinkering with
 *  the build system.
 */
static languageDefinition language_fr = { whichPluralForm_fr, {
    /***************************************
     ** This MUST be present and first. 
     ** Specify the code for this language.
     ***************************************/
    {/* Specify the ll or ll_cc language code here. */
      TIDY_LANGUAGE,                                 0, "fr"
    },
    { TidyAccessibilityCheckLevel,                   0,        
        "Cette option précise le niveau de contrôle d'accessibilité que Tidy doit éventuellement exécuter. "
        "Le <br/>niveau <var>0 (Tidy Classic)</var> est équivalent au contrôle d'accessibilité de Tidy "
        "Classic. <br/>Pour plus d'informations sur le contrôle d'accessibilité de Tidy, consultez <a href="
        "\"http://www.html-tidy.org/accessibility/\"> la page d'accessibilité de Tidy</a>. "
    },
    { TidyAltText,                                   0,        
        "Cette option précise la valeur par défaut du texte <code>alt=</code> qu'utilise Tidy pour les "
        "attributs <code>&lt;img&gt;</code> lorsque l'attribut <code>alt=</code> est absent. <br/> Utiliser "
        "avec toute l'attention nécessaire, il est en effet de votre responsabilité de rendre vos documents "
        "accessibles aux personnes qui ne peuvent pas voir les images."
    },
    { TidyAnchorAsName,                              0,        
        "Cette option contrôle la suppression ou l'ajout de l'attribut <code>name</code> pour les éléments "
        "qui peuvent servir d'ancre. <br/>Si la valeur de l'attribut <code>name</code> est <var>yes</var>, "
        "et qu'il n'existe pas déjà, il est ajouté à la suite d'un attribut <code>id</code> existant, si la "
        "DTD le permet. <br/>Si sa valeur est <var>no</var>, tout attribut <code>name</code> existant est "
        "supprimé, si un attribut <code>id</code> existe ou a été ajouté. "
    },
    { TidyAsciiChars,                                0,        
        "Peut être utilisé pour modifier le comportement de l'option <code>clean</code> si sa valeur est "
        "<var>yes</var>. <br/> Lorsque la valeur de <code>clean</code> vaut <var>yes</var>, <code>&amp;"
        "emdash;</code>, <code>&amp;rdquo;</code>, et d'autres entités nommées sont déclassées vers leurs "
        "plus proches équivalents ASCII."
    },
    { TidyBlockTags,                                 0,        
        "Cette option définit de nouvelles balises de type bloc. Elle prend une liste de noms de balises "
        "séparés par un espace ou une virgule. <br/>À moins que vous ne déclariez de nouvelles balises, Tidy "
        "refusera de produire une sortie si l'entrée introduit préalablement des balises inconnues. <br/"
        ">Notez qu'il est impossible de modifier le modèle de contenu pour des éléments comme <code>&lt;"
        "table&gt;</code>, <code>&lt;ul&gt;</code>, <code>&lt;ol&gt;</code> et <code>&lt;dl&gt;</code>. <br/"
        ">Cette option est ignorée avec le mode XML. "
    },
    { TidyBodyOnly,                                  0,        
        "Cette option précise si Tidy doit seulement afficher les contenus de la balise <code>&lt;body&gt;</"
        "code> en tant que fragment HTML. <br/>Si sa valeur est <var>auto</var>, ceci est effectué seulement "
        "si la balise <code>&lt;body&gt;</code> a été déduite. <br/>L'intérêt est de pouvoir incorporer "
        "entièrement des pages existantes en tant que partie d'une autre page. <br/>Cette option n'a pas "
        "d'effet si la sortie XML a été demandée. "
    },
    { TidyBreakBeforeBR,                             0,        
        "Cette option précise si Tidy doit ajouter un saut de ligne avant chaque élément <code>&lt;br&gt;</"
        "code>."
    },
    { TidyCharEncoding,                              0,        
        "Cette option permet de préciser l'encodage des caractères qui sera utilisé par Tidy pour l'entrée "
        "et la sortie. <br/>Pour l'<var>ascii</var> Tidy acceptera les valeurs de caractère Latin-1 "
        "(ISO-8859-1), mais utilisera les entités pour tous les caractères de valeur &gt;127. <br/>Pour la "
        "valeur <var>raw</var>, Tidy produira des valeurs au dessus de 127, sans les traduires en entités. "
        "<br/>Pour <var>latin1</var>, les caractères au dessus de 255 seront écrits en entités. <br/>Pour "
        "<var>utf8</var>, Tidy suppose qu'aussi bien l'entrée que la sortie sont encodés en UTF-8. <br/>Vous "
        "pouvez utiliser <var>iso2022</var> pour les fichiers utilisant la famille d'encodage ISO-2022, par "
        "exemple ISO-2022-JP. <br/>Pour <var>mac</var> et <var>win1252</var>, Tidy acceptera les valeurs de "
        "caractères spécifiques de l'éditeur, mais utilisera les entités pour tous les caractères de valeur "
        "&gt;127. <br/>Pour les encodages non supportés, utilisez un utilitaire tiers pour convertir depuis "
        "et vers l'UTF-8. "
    },
    { TidyCoerceEndTags,                             0,        
        "Cette option précise si Tidy doit forcer la fermeture d'une balise d'ouverture, dans les cas où il "
        "semble qu'une balise de fin soit attendue; Dans cet exemple,<br/><code>&lt;span&gt;foo &lt;b&gt;"
        "bar&lt;b&gt; baz&lt;/span&gt;</code> <br/>Tidy va produire <br/><code>&lt;span&gt;foo &lt;b&gt;"
        "bar&lt;/b&gt; baz&lt;/span&gt;</code> "
    },
    { TidyCSSPrefix,                                 0,        
        "Cette option précise le préfixe que Tidy utilise pour les règles de styles. <br/> Par défaut, "
        "<var>c</var> sera utilisé."
    },
    { TidyDecorateInferredUL,                        0,        
        "Cette option précise si Tidy doit décorer le code déduit des éléments <code>&lt;ul&gt;</code> avec "
        "du balisage CSS pour éviter un décalage d'indentation vers la droite. "
    },
    { TidyDoctype,                                   0,        
        "Cette option spécifie la déclaration DOCTYPE générée par Tidy. <br/> Si <var>omit</var>, la sortie "
        "ne contiendra pas de déclaration DOCTYPE. Notez que cela implique aussi que <code>numeric-entities</"
        "code> soit réglé sur <var>yes</var>. <br/> Si <code>html5</code>, la déclaration DOCTYPE est réglée "
        "sur <code>&lt;! DOCTYPE html&gt;</code>. <br/> Si <var>auto</var> (par défaut), Tidy tentera de "
        "déduire la déclaration DOCTYPE à partir du contenu du document. <br/> Si elle est définie "
        "<var>strict</var>, Tidy utilisera la déclaration DOCTYPE HTML4 ou XHTML 1 DTD strict. <br/> Si "
        "<var>loose</var>, la déclaration DOCTYPE est réglée sur HTML4 ou XHTML1 loose (transitional) DTD. "
        "<br/> En alternative, vous pouvez fournir une chaîne pour l'identificateur public formel (FPI).<br/"
        "> Par exemple: <br/> <code>doctype: \"- // ACME // DTD HTML. 3,14159 //EN\"</code> <br/> Si vous "
        "spécifiez le FPI pour un document XHTML, Tidy établira l'identifiant système à une chaîne vide. "
        "Pour un document HTML, Tidy ajoute un identifiant système seulement s'il était déjà présent, dans "
        "le but de préserver le mode de rendu de certains navigateurs. Tidy ne tient pas compte de la "
        "déclaration DOCTYPE pour les documents XML génériques inchangés. <br/> Cette option ne permet pas "
        "une validation de la conformité du document."
    },
    { TidyDropEmptyElems,                            0, "Cette option précise si Tidy doit rejeter les éléments vides."                                          },
    { TidyDropEmptyParas,                            0, "Cette option précise si Tidy doit rejeter les paragraphes vides."                                       },
    { TidyDropPropAttrs,                             0,        
        "Cette option précise si Tidy doit enlever les attributs propriétaires, comme les attributs de "
        "liaison de données Microsoft. Les attributs supplémentaires qui ne sont pas autorisés dans la "
        "version HTML en sortie, seront supprimés avec l'utilisation conjointe de l'option <code>strict-tags-"
        "attributes</code>."
    },
    { TidyDuplicateAttrs,                            0,        
        "Cette option précise quel attribut, du premier ou du dernier, Tidy doit garder s'il est répété, par "
        "exemple dans le cas de deux attributs <code>align</code>."
    },
    { TidyEmacs,                                     0,        
        "Cette option précise si Tidy doit adopter un format de rapports d'erreurs et d'avertissements plus "
        "facilement exploitable par GNU Emacs."
    },
    { TidyEmptyTags,                                 0,        
        "Cette option précise les nouvelles balises inline. Cette option prend une liste de noms de balises "
        "séparés par un espace ou une virgule. <br/>Tant que vous n'avez pas déclaré de nouvelles balises, "
        "Tidy refusera de générer un fichier nettoyé si l'entrée contient des balises inconnues. <br/> "
        "pensez aussi à déclarer les balises vides, soit inline, soit bloc. <br/>Cette option est ignorée "
        "par le mode XML."
    },
    { TidyEncloseBlockText,                          0,        
        "Cette option précise si Tidy doit insérer un élément <code>&lt;p&gt;</code> pour encadrer un "
        "quelconque texte trouvé, dans n'importe quel élément qui permet de mélanger du contenu pour "
        "<var>HTML transitional</var> mais pas HTML strict. "
    },
    { TidyEncloseBodyText,                           0,        
        "Cette option précise si Tidy doit encadrer les textes trouvés dans l'élément <code>body</code>, par "
        "un élément <code>&lt;p&gt;</code>. <br/>Elle peut être utile lorsque vous voulez modifier du HTML "
        "existant au moyen d'une feuille de style. "
    },
    { TidyErrFile,                                   0,        
        "Cette option précise le fichier d'erreur que Tidy utilise pour les erreurs et avertissements. En "
        "principe les erreurs et avertissements sont envoyés vers la sortie <code>stderr</code>."
    },
    { TidyEscapeCdata,                               0,        
        "Cette option précise si Tidy doit convertir les sections <code>&lt;![CDATA[]]&gt;</code> en texte "
        "normal. "
    },
    { TidyEscapeScripts,                             0,        
        "Cette option entraîne l'échappement des items qui semblent être des balises de fermeture, ainsi "
        "<code>&lt;/g</code> sera échappée en <code>&lt;\\/g</code>. Positionner cette option à <var>no</"
        "var> si vous ne voulez pas cette fonctionnalité."
    },
    { TidyFixBackslash,                              0,        
        "Cette option précise si Tidy doit remplacer les caractères de barre oblique inversée (anti-slash, "
        "<code>\\</code>) dans les URLs avec des barres obliques (slash, <code>/</code>). "
    },
    { TidyFixComments,                               0,        
        "Cette option précise si Tidy doit remplacer les traits d'unions par le caractère <code>=</code> "
        "s'il rencontre des traits-d'unions adjacents. <br/>La valeur par défaut est <var>yes</var>. <br/"
        ">Cette option est fourni pour les utilisateurs de ColdFusion qui utilisent la syntaxe de "
        "commentaire: <code>&lt;!--- ---&gt;</code>. "
    },
    { TidyFixUri,                                    0,        
        "Cette option précise si Tidy doit vérifier les valeurs d'attributs qui comportent des caractères "
        "interdits pour les URI, et auquel cas les échapper selon les recommandations HTML 4."
    },
    { TidyForceOutput,                               0,        
        "Cette option précise si Tidy doit produire une sortie, même si des erreurs ont été rencontrées. <br/"
        ">Utilisez cette option avec attention; si Tidy affiche une erreur, cela implique que Tidy n'a pas "
        "été en mesure (ou n'est pas sûr) de pouvoir corriger cette erreur; en conséquence le résultat en "
        "sortie pourrait ne pas être conforme à vos attentes. "
    },
    { TidyGDocClean,                                 0,        
        "Cette option précise si Tidy doit activer un comportement spécifique pour le nettoyage du HTML "
        "exporté à partir de Google Docs."
    },
    { TidyHideComments,                              0, "Cette option précise si Tidy doit afficher en sortie les commentaires."                                 },
    { TidyHtmlOut,                                   0, "Cette option précise si Tidy doit embellir les sorties, lorsqu'il produit du HTML."                     },
    { TidyInCharEncoding,                            0,        
        "Cette option précise l'encodage de caractère que Tidy utilise pour l'entrée. Voir <code>char-"
        "encoding</code> pour plus d'informations."
    },
    { TidyIndentAttributes,                          0, "Cette option précise si Tidy doit placer chaque attribut sur une nouvelle ligne."                       },
    { TidyIndentCdata,                               0, "Cette option précise si Tidy doit indenter les sections <code>&lt;![CDATA[]]&gt;</code>."               },
    { TidyIndentContent,                             0,        
        "Cette option précise si Tidy doit indenter les balises de portée bloc. <br/>Si la valeur est "
        "<var>auto</var> Tidy décidera d'indenter ou pas le contenu des balises comme <code>&lt;title&gt;</"
        "code>, <code>&lt;h1&gt;</code>-<code>&lt;h6&gt;</code>, <code>&lt;li&gt;</code>, <code>&lt;td&gt;</"
        "code>, or <code>&lt;p&gt;</code> en s'appuyant sur le contenu incluant un élément de bloc. <br/"
        ">Positionner <code>indent</code> à <var>yes</var> peut engendrer des bugs de structure pour "
        "certains navigateurs. <br/>Utiliser l'option <code>indent-spaces</code> pour contrôler le nombre "
        "d'espaces ou de tabulations en sortie par niveau d'indentation, et <code>indent-with-tabs</code> "
        "pour préciser si les espaces ou tabulations sont utilisées. "
    },
    { TidyIndentSpaces,                              0,        
        "Cette option précise le nombre d'espaces ou de tabulations que Tidy utilise pour indenter le "
        "contenu lorsque <code>indent</code> est activé. <br/>Notez que la valeur par défaut pour cette "
        "option dépend de la valeur de <code>indent-with-tabs</code> (voir aussi cette option). "
    },
    { TidyInlineTags,                                0,        
        "Cette option porte sur les nouvelles balises inline non vides. Elle prend en valeur une liste de "
        "noms de balises, séparés par un espace ou une virgule. <br/>Sans déclaration de nouvelles balises, "
        "Tidy refusera de générer un fichier de sortie, si l'entrée comporte des balises inconnues. <br/"
        ">Cette option est ignorée avec le mode XML. "
    },
    { TidyJoinClasses,                               0,        
        "Cette option précise si Tidy doit combiner les noms de classe pour produire un nouveau nom de "
        "classe unique, lorsque plusieurs affectations de classes sont détectées sur un élément."
    },
    { TidyJoinStyles,                                0,        
        "Cette option indique si Tidy doit combiner les styles pour produire un nouveau style unique, "
        "lorsque plusieurs styles sont détectés sur un élément."
    },
    { TidyKeepFileTimes,                             0,        
        "Cette option précise si Tidy doit préserver la date de modification des fichiers sur lesquels il "
        "travaille directement. <br/>Mettre cette option à <var>yes</var> vous autorise à nettoyer les "
        "fichiers sans changer la date de modification, ce qui peut avoir une utilité avec certains outils "
        "qui utilisent la date de modification pour des traitements comme le déploiement automatique.<br/"
        ">Notez que cette fonctionnalité n'est pas supportée par toutes les plateformes. "
    },
    { TidyLiteralAttribs,                            0,        
        "Cette option précise le comportement de Tidy avec les caractères d'espacement pour les valeurs "
        "d'attributs. <br/>Si la valeur de l'option est <var>no</var>, Tidy normalise les valeurs "
        "d'attributs en remplaçant n'importe quel nouveau saut de ligne ou tabulation par un espace unique, "
        "et ensuite en remplaçant n'importe quel espace contigu par un espace unique. <br/>Pour forcer Tidy "
        "à préserver les valeurs initiales, les valeurs littérales de tous les attributs, et assurer que les "
        "espacements dans les valeurs d'attributs soient inchangés, passer cette option à <var>yes</var>. "
    },
    { TidyLogicalEmphasis,                           0,        
        "Cette option précise si Tidy doit remplacer les occurrences de <code>&lt;i&gt;</code> par <code>&lt;"
        "em&gt;</code> et les occurrences de <code>&lt;b&gt;</code> par <code>&lt;strong&gt;</code>. Les "
        "attributs sont préservés et inchangés. <br/>Cette option peut être indiquée indépendamment de "
        "l'option <code>clean</code>. "
    },
    { TidyLowerLiterals,                             0,        
        "Cette option précise si Tidy doit convertir en minuscules la valeur d'un attribut qui prend une "
        "liste de valeur prédéfinies. <br/>Ceci est requis pour les documents XHTML. "
    },
    { TidyMakeBare,                                  0,        
        "Cette option précise si Tidy doit supprimer des documents Word 2000, le HTML spécifique de "
        "Microsoft, et afficher des espaces en sortie plutôt que des espaces insécables, lorsque ceux-ci "
        "sont présents en entrée."
    },
    { TidyMakeClean,                                 0,        
        "Cette option précise si Tidy doit effectuer le nettoyage de certaines balises historiques de "
        "présentation (actuellement <code>&lt; i&gt;</code>, <code>&lt;b&gt;</code>, <code>&lt;center&gt;</"
        "code> lorsque placé entre les balises inline appropriées, ainsi que <code>&lt; font&gt;</code>). Si "
        "la valeur est <var>yes</var>, les balises historiques seront remplacées par des balises CSS "
        "<code>&lt;style&gt;</code> et par une structure de balisage appropriée."
    },
    { TidyMark,                                      0,        
        "Cette option précise si Tidy doit ajouter un élément <code>meta</code> dans l'entête de document, "
        "pour indiquer que le document a été nettoyé par Tidy. <br/>Tidy n'ajoutera pas cet élément "
        "<code>meta</code> s'il existe déjà. "
    },
    { TidyMergeDivs,                                 0,        
        "Cette option peut être utilisée pour modifier le comportement de l'option <code>clean</code>, "
        "lorsqu'elle vaut <var>yes</var>. <br/>Cette option précise si Tidy doit concaténer les éléments "
        "<code>&lt;div&gt;</code> imbriqués, comme <code>&lt;div&gt;&lt;div&gt;...&lt;/div&gt;&lt;/div&gt;</"
        "code>. <br/>Si la valeur vaut <var>auto</var>, les attributs internes du <code>&lt;div&gt;</code> "
        "sont déplacés vers son div externe. Les <code>&lt;div&gt;</code> imbriqués avec des attributs "
        "<code>id</code> ne sont <em>pas</em> concaténés. <br/>Si la valeur vaut <var>yes</var>, les "
        "attributs du <code>&lt;div&gt;</code> interne ne sont pas pris en compte, à l'exception de "
        "<code>class</code> et de <code>style</code>. "
    },
    { TidyMergeEmphasis,                             0,        
        "Cette option précise si Tidy doit concaténer les éléments <code>&lt;b&gt;</code> et <code>&lt;i&gt;"
        "</code>; par exemple, pour le cas <br/><code>&lt;b class=\"rtop-2\"&gt;foo &lt;b class=\"r2-2\"&gt;"
        "bar&lt;/b&gt; baz&lt;/b&gt;</code>, <br/>Tidy produira la sortie <code>&lt;b class=\"rtop-2\"&gt;"
        "foo bar baz&lt;/b&gt;</code>. "
    },
    { TidyMergeSpans,                                0,        
        "Cette option peut être utlisée pour modifier le comportement de <code>clean</code>, si elle vaut "
        "<var>yes</var>.<br/>Cette option précise si Tidy doit concaténer les <code>&lt;span&gt;</code> "
        "imbriqués, comme suit : <code>&lt;span&gt;&lt;span&gt;...&lt;/span&gt;&lt;/span&gt;</code>. <br/"
        ">L'algorithme est le même que celui de <code>merge-divs</code>. "
    },
    { TidyNCR,                                       0, "Cette option précise si Tidy doit autoriser les références numériques de caractères. "                  },
    { TidyNewline,                                   0,        
        "La valeur par défaut est appropriée à la plateforme d'exécution de Tidy. <br/>Généralement "
        "<var>CRLF</var> sur PC-DOS, Windows et OS/2; <var>'\r'</var> sur Classic Mac OS; et <var>'\n'</var> "
        "partout ailleurs (Linux, Mac OS X, et Unix). "
    },
    { TidyNumEntities,                               0,        
        "Cette option précise si Tidy doit afficher les entités autres que les entités HTML intégrées "
        "(<code>&amp;amp;</code>, <code>&amp;lt;</code>, <code>&amp;gt;</code>, et <code>&amp;quot;</code>) "
        "dans la forme numérique plutôt que dans la forme nommée. <br/>Seules les entités compatibles avec "
        "la déclaration DOCTYPE générée sont utilisées. <br/>Les entités qui peuvent être représentées dans "
        "l'encodage de sortie sont traduites avec leur correspondance. "
    },
    { TidyOmitOptionalTags,                          0,        
        "Cette option précise si Tidy doit omettre les balises optionnelles ouvrantes et fermantes, "
        "lorsqu'il produit une sortie. <br/>Activer cette option entraîne l'omission en sortie de toutes les "
        "balises correspondantes aux éléments <code>&lt;html&gt;</code>, <code>&lt;head&gt;</code>, and "
        "<code>&lt;body&gt;</code>, de même que les balises de fermeture comme <code>&lt;/p&gt;</code>, "
        "<code>&lt;/li&gt;</code>, <code>&lt;/dt&gt;</code>, <code>&lt;/dd&gt;</code>, <code>&lt;/option&gt;"
        "</code>, <code>&lt;/tr&gt;</code>, <code>&lt;/td&gt;</code>, et <code>&lt;/th&gt;</code>. <br/"
        ">Cette option est ignorée pour la sortie XML. "
    },
    { TidyOutCharEncoding,                           0,        
        "Cette option précise l'encodage de caractère utilisé par Tidy pour la sortie. <br/>Notez que cela "
        "peut être différent de <code>input-encoding</code> seulement pour les encodages latins (<var>ascii</"
        "var>, <var>latin0</var>, <var>latin1</var>, <var>mac</var>, <var>win1252</var>, <var>ibm858</var>)."
        "<br/>Voir <code>char-encoding</code> pour plus d'informations."
    },
    { TidyOutFile,                                   0,        
        "Cette option précise le fichier de sortie que Tidy utilise pour la structure de balises. En "
        "principe la structure est écrite vers <code>stdout</code>. "
    },
    { TidyOutputBOM,                                 0,        
        "Cette option précise si Tidy doit écrire un caractère indicateur d'ordre des octets (Unicode Byte "
        "Order Mark ou BOM; connu aussi sous Zero Width No-Break Space; a la valeur de U+FEFF) au début de "
        "la sortie, ce qui ne s'applique qu'aux sorties encodées en UTF-8 et UTF-16. <br/>Si l'option vaut "
        "<var>auto</var>, Tidy écrira un BOM vers la sortie seulement si un BOM était présent au début de "
        "l'entrée. <br/>Un BOM est toujours écrit pour la sortie XML/XHTML des sorties encodées en UTF-16. "
    },
    { TidyPPrintTabs,                                0,        
        "Cette option précise si tidy doit indenter avec des tabulations plutôt que des espaces, en "
        "supposant que <code>indent</code> vaut <var>yes</var>. <br/>Définir cette option à <var>yes</var> "
        "indente avec des tabulations plutôt que des espaces, valeur par défaut. <br />Utilisez l'option "
        "<code>indent-spaces</code> pour redéfinir le nombre de tabulations en sortie par niveau "
        "d'indentation. Notez que lorsque <code>indent-with-tabs</code> est activé, la valeur par défaut de "
        "<code>indent-spaces</code> est réinitialisée à <var>1</var>. <br/>Notez que <code>tab-size</code> "
        "contrôle la conversion des tabulations d'entrée en des espaces de sortie. Définissez-la à zéro pour "
        "conserver les tabulations en entrée."
    },
    { TidyPreserveEntities,                          0, "Cette option précise si Tidy doit préserver les entités bien formées telles que trouvées en entrée. "   },
    { TidyPreTags,                                   0,        
        "Cette option précise les nouvelles balises qui doivent être traitées exactement de la même façon "
        "que l'élément HTML <code>&lt;pre&gt;</code>. Cette option prend une liste de nom de balises "
        "séparées par un espace ou une virgule. <br/>Sauf si vous déclarez de nouvelles balises, Tidy "
        "refusera de générer un fichier Tidy en sortie si l'entrée inclut préalablement des balises "
        "inconnues. <br/>Notez que vous ne pouvez encore ajouter de nouveaux éléments CDATA. <br/>Cette "
        "option est ignorée avec le mode XML. "
    },
    { TidyPunctWrap,                                 0,        
        "Cette option précise si Tidy doit passer à la ligne après certains caractères de ponctuation "
        "Unicode ou chinois."
    },
    { TidyQuiet,                                     0,        
        "Cette option précise si Tidy doit afficher le résumé du nombre des erreurs et avertissements, ou "
        "les messages de bienvenue et d'information."
    },
    { TidyQuoteAmpersand,                            0,        
        "Cette option précise si Tidy doit afficher en sortie les caractères <code>&amp;</code> en les "
        "écrivant <code>&amp;amp;</code>. "
    },
    { TidyQuoteMarks,                                0,        
        "Cette option précise si Tidy doit afficher les caractères <code>&quot;</code> comme <code>&amp;quot;"
        "</code> comme préféré par certains environnements d'édition. <br/>Le caractère apostrophe <code>'</"
        "code> est écrit <code>&amp;#39;</code> car de nombreux navigateurs webs ne supportent pas encore "
        "l'écriture <code>&amp;apos;</code>. "
    },
    { TidyQuoteNbsp,                                 0,        
        "Cette option précise si Tidy doit afficher les espaces insécables en tant qu'entités, plutôt qu'en "
        "utilisant la valeur de caractère unicode 160 (décimale). "
    },
    { TidyReplaceColor,                              0,        
        "Cette option précise si Tidy doit remplacer les valeurs numériques dans les attributs de couleur "
        "par les noms de couleurs HTML/XHTML lorsque définies, par exemple en remplaçant <code>#ffffff</"
        "code> par <code>white</code>. "
    },
    { TidyShowErrors,                                0,        
        "Cette option précise le nombre utilisé par Tidy pour déterminer si les erreurs suivantes doivent "
        "être montrées. Si la valeur est <var>0</var>, aucune erreur n'est affichée. "
    },
    { TidyShowInfo,                                  0, "Cette option précise si Tidy doit afficher les messages de niveau info-level."                          },
    { TidyShowMarkup,                                0,        
        "Cette option précise si Tidy doit générer un affichage embelli de la structure de balises. Notez "
        "que Tidy ne générera pas un affichage embelli s'il trouve des erreurs significatives (voir "
        "<code>force-output</code>). "
    },
    { TidyShowWarnings,                              0,        
        "Cette option précise si Tidy doit supprimer les avertissements. Cela peut être utile lorsque "
        "quelques erreurs sont cachées dans une masse d'avertissements. "
    },
    { TidySkipNested,                                0,        
        "Cette option précise que Tidy doit ignorer les balises imbriquées lors de l'analyse des données de "
        "script et de style."
    },
    { TidySortAttributes,                            0,        
        "Cette option précise que Tidy doit classer les attributs d'un élément en utilisant un algorithme de "
        "classement. Si la valeur est <var>alpha</var>, l'algorithme est un classement alphabétique "
        "ascendant. "
    },
    { TidyStrictTagsAttr,                            0,        
        "Ces options garantissent que les balises et attributs sont valides pour la version HTML en sortie "
        "de Tidy. Si la valeur est <var>yes</var> (par défaut) et que le type de document en sortie est une "
        "déclaration doctype stricte, alors Tidy rapportera les erreurs. Si le type de document en sortie "
        "est une déclaration doctype loose ou transitional, alors Tidy rapportera les avertissements. <br/"
        ">En complément, si l'option <code>drop-proprietary-attributes</code> est activée, alors les "
        "attributs non valables seront aussi supprimés. <br/>Si la valeur est <var>no</var>, ces contrôles "
        "ne sont pas effectués. "
    },
    { TidyTabSize,                                   0,        
        "Cette option précise le nombre de colonnes que Tidy utilise entre deux tabulations successives. "
        "Ceci est utilisé pour lier les tabulations aux espaces pendant la lecture de l'entrée."
    },
    { TidyUpperCaseAttrs,                            0,        
        "Cette option précise si Tidy doit afficher les noms d'attributs en majuscules. <br/>La valeur par "
        "défaut est <var>no</var>, ce qui produit un affichage des attributs en minuscules, excepté pour une "
        "entrée XML, pour laquelle la casse originale est préservée. "
    },
    { TidyUpperCaseTags,                             0,        
        "Cette option précise si Tidy doit afficher les noms de balises en majuscules. <br/>La valeur par "
        "défaut est <var>no</var>, ce qui produit un affichage des balises en minuscules, excepté pour une "
        "entrée XML, pour laquelle la casse originale est préservée. "
    },
    { TidyUseCustomTags,                             0,        
        "Cette option active dans Tidy l'utilisation de balises pour les éléments personnalisés autonomes, "
        "par exemple &lt;flag-icon&gt;. Les balises personnalisées sont désactivées si cette valeur est "
        "<var>no</var>. Autres configurations - <var>blocklevel</var>, <var>empty</var>, <var>inline</var>, "
        "et <var>pre</var> seront <em>all</em> traités en conséquence comme des balises personnalisées "
        "détectées. <br/>L'usage de <code>new-blocklevel-tags</code>, <code>new-empty-tags</code>, <code>new-"
        "inline-tags</code>, ou <code>new-pre-tags</code> surchargera le traitement des balises "
        "personnalisées par cette option de configuration. Ceci peut être utile si vous avez différents "
        "types de balises personnalisées. <br/>Lorsque l'option est activée, ces balises sont déterminées "
        "pendant la phase de traitement de votre document, par la balise d'ouverture; les balises de "
        "fermeture correspondantes seront reconnues en conséquence, et les balises de fermeture inconnues "
        "seront ignorées. "
    },
    { TidyVertSpace,                                 0,        
        "Cette option précise si Tidy doit ajouter quelques lignes vides supplémentaires pour la lisibilité. "
        "<br/>La valeur par défaut est <var>no</var>. <br/>Si la valeur est <var>auto</var> Tidy éliminera "
        "presque tous les caractères de nouvelle ligne."
    },
    { TidyWarnPropAttrs,                             0, "Cette option précise si Tidy doit avertir des attributs propriétaires."                                 },
    { TidyWord2000,                                  0,        
        "Cette option précise si Tidy doit se donner du mal pour supprimer tous les surplus que Microsoft "
        "Word 2000 ajoute lorsque vous enregistrez des documents Word comme des \"pages Web\". Il ne prend "
        "pas en charge les images embarquées ou le VML. <br/>Vous devriez songer à utiliser la "
        "fonctionnalité de Word \"Enregistrer Sous: Page Web, Filtrée\". "
    },
    { TidyWrapAsp,                                   0,        
        "Cette option précise si Tidy doit ajouter un saut de ligne au texte contenu dans les pseudos-"
        "éléments ASP, qui ressemblent à <code>&lt;% ... %&gt;</code>. "
    },
    { TidyWrapAttVals,                               0,        
        "Cette option précise si Tidy doit ajouter des sauts de ligne aux valeurs d'attributs, ce qui "
        "signifie que si la valeur d'un attribut entraîne le dépassement de la largeur précisée par "
        "<code>wrap</code>, Tidy ajoutera un ou plusieurs sauts de lignes à la valeur, ce qui implique son "
        "découpage en plusieurs lignes. <br/>Notez que cette option peut être précisée indépendamment de "
        "<code>wrap-script-literals</code>. Par défaut, Tidy remplace n'importe quelle nouvelle ligne ou "
        "tabulation par un espace simple et remplace n'importe quelle séquence d'espacement par un espace "
        "simple. <br/>Pour forcer Tidy à préserver les valeurs littérales initiales de tous les attributs, "
        "et garantir que les caractères d'espacement dans les valeurs d'attributs sont maintenus inchangés, "
        "préciser la valeur de <code>literal-attributes</code> à <var>yes</var>. "
    },
    { TidyWrapJste,                                  0,        
        "Cette option précise si Tidy doit ajouter un saut de ligne au texte contenu dans les pseudos-"
        "éléments JSTE, qui ressemblent à <code>&lt;# ... #&gt;</code>. "
    },
    { TidyWrapLen,                                   0,        
        "Cette option précise à Tidy la marge de droite à utiliser pour le saut de ligne. <br/> Tidy tente "
        "de couper les lignes de façon à ce qu'elles ne dépassent pas cette longueur. <br/>Passer la valeur "
        "de <code>wrap</code> à <var>0</var>(zéro) désactive l'ajout de saut de ligne. "
    },
    { TidyWrapPhp,                                   0,        
        "Cette option précise si Tidy doit ajouter un saut de ligne au texte contenu dans les pseudos-"
        "éléments PHP, qui ressemblent à: <code>&lt;?php ... ?&gt;</code>. "
    },
    { TidyWrapScriptlets,                            0,        
        "Cette option précise si Tidy doit ajouter des sauts de lignes aux chaînes littérales dans les "
        "attributs de script. <br/>Tidy prend en charge la césure des longues chaînes littérales de scripts "
        "en ajoutant un caractère de barre oblique arrière (backslash) avant le saut de ligne. "
    },
    { TidyWrapSection,                               0,        
        "Cette option précise si Tidy doit ajouter des sauts de ligne pour le texte compris dans des balises "
        "de section <code>&lt;![ ... ]&gt;</code> section tags. "
    },
    { TidyWriteBack,                                 0,        
        "Cette option précise si Tidy doit réécrire la structure de balise qu'il a produit vers le même "
        "fichier à partir duquel il l'a lu. <br/> Il est conseillé de garder une copie des fichiers "
        "importants avant de les faire modifier par Tidy, car dans de rares occasions le résultat peut être "
        "inattendu. "
    },
    { TidyXhtmlOut,                                  0,        
        "Cette option précise si Tidy doit afficher une sortie embellie, en l'écrivant avec HTML étendu. <br/"
        "> Avec cette option activée, Tidy définit la déclaration DOCTYPE et l'espace de nom par défaut "
        "approprié pour du XHTML, et utilisera la valeur corrigée en sortie indépendamment des autres "
        "sources. <br/>Pour le XHTML, les entités seront écrites en entités nommées ou numériques "
        "conformément à la valeur de configuration de <code>numeric-entities</code>. <br/>La casse originale "
        "des balises et attributs sera préservée, indépendamment des autres options. "
    },
    { TidyXmlDecl,                                   0,        
        "Cette option précise si Tidy doit ajouter la déclaration XML lors de la sortie XML ou XHTML. <br/> "
        "Notez que si l'entrée comprend déjà une déclaration <code>&lt;?xml ... ?&gt;</code>, alors cette "
        "option sera ignorée. <br/>Si l'encodage pour la sortie est différent de <var>ascii</var>, de l'un "
        "des encodages <var>utf*</var> ou <var>raw</var>, alors la déclaration est toujours ajoutée, comme "
        "indiqué dans le standard XML."
    },
    { TidyXmlOut,                                    0,        
        "Cette option précise si Tidy doit afficher une sortie embellie, en l'écrivant avec du XML bien "
        "structuré. <br/> Toutes les entités non définies en XML 1.0 seront réécrites en entités numériques "
        "pour leur permettre d'être parcourues par un analyseur XML. <br/>La casse originale des balises et "
        "attributs sera préservée, indépendamment des autres options. "
    },
    { TidyXmlPIs,                                    0,        
        "Cette option précise si Tidy doit modifier l'analyse syntaxique des instructions de traitement pour "
        "exiger <code>?&gt;</code> comme terminaison plutôt que <code>&gt;</code>. <br/> Cette option est "
        "automatiquement activée si l'entrée est en XML."
    },
    { TidyXmlSpace,                                  0,        
        "Cette option précise si tidy doit ajouter <code>xml:space=\"preserve\"</code> pour des éléments "
        "tels que <code>&lt;pre&gt;</code>, <code>&lt;style&gt;</code> and <code>&lt;script&gt;</code> lors "
        "de la production de XML. <br />Ceci est nécessaire si l'espace blanc dans de tels éléments doit "
        "être analysé convenablement sans avoir accès à la DTD."
    },
    { TidyXmlTags,                                   0,        
        "Cette option précise si Tidy doit utiliser l'analyseur XML plutôt que l'analyseur de correction "
        "d'erreur HTML."
    },
    { TidyInfo,                                      0, "Info:"                                                                                                  },
    { TidyWarning,                                   0, "Avertissement:"                                                                                         },
    { TidyConfig,                                    0, "Config:"                                                                                                },
    { TidyAccess,                                    0, "Accès:"                                                                                                 },
    { TidyError,                                     0, "Erreur:"                                                                                                },
    { TidyBadDocument,                               0, "Document:"                                                                                              },
    { TidyFatal,                                     0, "Panique:"                                                                                               },
    { TidyDialogueSummary,                           0, "Résumé:"                                                                                                },
    { TidyDialogueInfo,                              0, "Informations: "                                                                                         },
    { TidyDialogueFootnote,                          0, "Remarque:"                                                                                              },
    { LINE_COLUMN_STRING,                            0, "Ligne: %d Col: %d - "                                                                                   },
    { STRING_DISCARDING,                             0, "rejet"                                                                                                  },
    { STRING_ERROR_COUNT_ERROR,                      0, "erreur"                                                                                                 },
    { STRING_ERROR_COUNT_ERROR,                      1, "erreurs"                                                                                                },
    { STRING_ERROR_COUNT_WARNING,                    0, "avertissement"                                                                                          },
    { STRING_ERROR_COUNT_WARNING,                    1, "avertissements"                                                                                         },
    { STRING_HELLO_ACCESS,                           0,        
        "\n"
        "Contrôles d'accessibilité:\n"
    },
    { STRING_HTML_PROPRIETARY,                       0, "HTML Propriétaire"                                                                                      },
    { STRING_XML_DECLARATION,                        0, "déclaration XML"                                                                                        },
    { STRING_PLAIN_TEXT,                             0, "texte brut"                                                                                             },
    { STRING_REPLACING,                              0, "remplacement"                                                                                           },
    { STRING_SPECIFIED,                              0, "précisé"                                                                                                },
    { TIDYCUSTOMNO_STRING,                           0, "aucune"                                                                                                 },
    { TIDYCUSTOMBLOCKLEVEL_STRING,                   0, "élément de bloc"                                                                                        },
    { TIDYCUSTOMEMPTY_STRING,                        0, "vide"                                                                                                   },
    { TEXT_HTML_T_ALGORITHM,                         0,        
        "\n"
        "       - D'abord, cherchez depuis la gauche de la position de la cellule \n"
        "         pour trouver la rangée des cellules d'entête de lignes. \n"
        "       - Puis rechercher vers le haut pour trouver les cellules d'entête \n"
        "         de colonne.\n"
        "       - La recherche dans une direction donnée s'arrête lorsque le bout \n"
        "         du tableau est atteint ou lorsque la cellule de données est \n"
        "         trouvée après une cellule d'en-tête.\n"
        "       - Les entêtes de ligne sont insérés dans la liste, dans l'ordre dans \n"
        "         lequel ils apparaissent dans le tableau.\n"
        "       - Pour les tableaux de gauche à droite, les entêtes sont insérés de \n"
        "         gauche à droite.\n"
        "       - Les entêtes de colonnes sont insérés après les entêtes de ligne,\n"
        "         dans l'ordre dans lequel ils apparaissent dans le tableau, de haut \n"
        "         en bas.\n"
        "       - Si une cellule d'entête a ses entêtes d'attributs complétés, alors \n"
        "         les entêtes référencés par cet attribut sont insérés dans la \n"
        "         liste et la recherche s'arrête pour la direction courante.\n"
        "         Les cellules TD qui fixent l'attribut de l'axe sont également \n"
        "         traitées comme des cellules d'entête.\n"
    },
    { TEXT_VENDOR_CHARS,                             0,        
        "Il est peu probable que des encodages spécifiques à un éditeur,\n"
        "dépendants d'un système, fonctionnent suffisamment largement\n"
        "pour le World Wide Web; vous devriez éviter d'utiliser l'encodage\n"
        "de caractère %s, et utiliser plutôt des entités nommées,\n"
        "par exemple &trade;.\n"
    },
    { TEXT_SGML_CHARS,                               0,        
        "Les codes de caractères 128 à 159 (U + 0080 à U + 009F) ne sont pas \n"
        "autorisés en HTML; même si ils l'étaient, il seraient probablement non \n"
        "imprimables comme des caractères de contrôle .\n"
        "Tidy a supposé que vous vouliez faire référence à un caractère avec la \n"
        "même valeur d'encodage d'octet %s et a remplacé cette référence par \n"
        "son équivalent Unicode.\n"
    },
    { TEXT_INVALID_UTF8,                             0,        
        "Les codes de caractères UTF-8 doivent être dans l'intervalle : U+0000 à U+10FFFF.\n"
        "La définition de l'UTF-8 à l'annexe D de la norme ISO/CEI 10646-1: 2000 permet \n"
        "également l'utilisation de séquences de cinq et six octets pour coder des caractères \n"
        "qui sont en dehors de l'intervalle des caractères Unicode;\n"
        "ces séquences de cinq et six octets sont inappropriées pour l'utilisation de l'UTF-8 \n"
        "dans l'objectif de transformation de caractères Unicode. ISO/IEC 10646 \n"
        "ne permet pas la liaison des substituts non appairés, ni U+FFFE ni U+FFFF \n"
        "(mais il permet d'autres non-caractères). Pour plus d'informations veuillez-vous\n"
        "référer à http://www.unicode.org/ et http://www.cl.cam.ac.uk/~mgk25/unicode.html\n"
    },
    { TEXT_INVALID_UTF16,                            0,        
        "Les codes de caractères pour UTF-16 doivent être dans l'intervalle: U+0000 à U+10FFFF.\n"
        "La définition de UTF-16 dans l'annexe C de l'ISO/IEC 10646-1:2000 n'autorise pas la \n"
        "liaison de substituts non appairés. Pour plus d'informations, veuillez vous référer\n"
        "à http://www.unicode.org/ et http://www.cl.cam.ac.uk/~mgk25/unicode.html\n"
    },
    { TEXT_INVALID_URI,                              0,        
        "Les URIs doivent être correctement protégés, ils ne doivent pas contenir \n"
        "les caractères non-échappés ci-après U+0021, y-compris le caractère \n"
        "d'espacement et non plus le U+007E. Tidy échappe l'URI pour vous \n"
        "comme recommandé par HTML 4.01 section B.2.1 et XML 1.0 \n"
        "section 4.2.2. Certains user-agents utilisent un autre algorithme pour \n"
        "échapper ces URI et quelques scripts côté serveur dépendent de ceci. \n"
        "Si vous voulez dépendre de ceci, vous devez échapper l'URI de votre \n"
        "côté. Pour plus d'informations, veuillez vous référer à\n"
        "http://www.w3.org/International/O-URL-and-ident.html\n"
    },
    { TEXT_BAD_FORM,                                 0,        
        "Vous devrez peut-être déplacer une, ou les deux, balises <form>et</form>. \n"
        "Les éléments HTML doivent être correctement imbriquées et les éléments \n"
        "de formulaire ne font pas exception. Par exemple, vous ne devez pas placer \n"
        "<form>dans une cellule et </form>dans une autre. Si <form>est placé devant \n"
        "un tableau, </form> ne peut pas être placé à l'intérieur du tableau !\n"
        "Notez qu'un form ne peut pas être imbriqué dans un autre !\n"
    },
    { TEXT_BAD_MAIN,                                 0,        
        "Un seul élément <main> est permis dans un document.\n"
        "Les éléments <main> suivants ont été rejetés, ce qui peut rendre \n"
        "le document non valide.\n"
    },
    { TEXT_M_SUMMARY,                                0,        
        "L'attribut summary du tableau devrait servir à décrire la structure\n"
        "du tableau. Il est très utile pour les personnes utilisant des \n"
        "navigateurs non visuels. Les attributs de portée et entêtes \n"
        "pour les cellules d'un tableau sont utiles pour préciser les entêtes \n"
        "s'appliquant à chaque cellule du tableau, permettant aux navigateurs \n"
        "non visuels de fournir un contexte significatif pour chaque cellule.\n"
        "\n"
    },
    { TEXT_M_IMAGE_ALT,                              0,        
        "L'attribut alt devrait servir à donner une brève description d'une\n"
        "image ; Il faudrait aussi des descriptions plus longues avec l'attribut\n"
        "longdesc qui prend une URL liée à la description. Ces mesures sont\n"
        "nécessaires pour les personnes utilisant des navigateurs textuels.\n"
        "\n"
    },
    { TEXT_M_IMAGE_MAP,                              0,        
        "Utiliser des images interactives côté client est préférable à celles côté \n"
        "serveur, ces dernières sont inaccessibles aux personnes utilisant des \n"
        "navigateurs non-graphiques. En outre, les cartes côté client sont plus \n"
        "faciles à mettre en place et fournissent une interactivité immédiate \n"
        "aux utilisateurs.\n"
        "\n"
    },
    { TEXT_M_LINK_ALT,                               0,        
        "Pour les liens hypertextes définis à l'aide d'une image interactive \n"
        "côté client, vous devez utiliser l'attribut alt pour fournir une \n"
        "description textuelle du lien, pour les personnes utilisant des \n"
        "\n"
    },
    { TEXT_USING_FRAMES,                             0,        
        "Les pages conçues à l'aide de cadres posent des problèmes aux \n"
        "personnes malvoyantes ou à celles qui utilisent un navigateur ne \n"
        "supportant pas les frames. Une structure de page basée sur des \n"
        "cadres doit toujours inclure une structure alternative à l'intérieur \n"
        "d'un élément NOFRAMES.\n"
        "\n"
    },
    { TEXT_ACCESS_ADVICE1,                           0,        
        "Pour plus d'informations sur la façon de rendre vos pages\n"
        "accessibles, voir http://www.w3.org/WAI/GL"
    },
    { TEXT_ACCESS_ADVICE2,                           0,        
        "Pour plus d'informations sur la façon de rendre vos pages \n"
        "accessibles, voir http://www.w3.org/WAI/GL et \n"
        "http://www.html-tidy.org/Accessibility/"
    },
    { TEXT_USING_LAYER,                              0,        
        "Le mécanisme de positionnement au moyen des feuilles de style \n"
        "en cascade (CSS) est préférable à l'élément propriétaire <LAYER>, \n"
        "en raison du support limité des éditeurs pour LAYER.\n"
    },
    { TEXT_USING_SPACER,                             0,        
        "Il est recommandé d'utiliser les CSS pour contrôler les espacements \n"
        "(par exemple pour le retrait, les marges et les interlignes).\n"
        "L'élément propriétaire <SPACER> a un soutien limité des éditeurs.\n"
        "\n"
    },
    { TEXT_USING_FONT,                               0,        
        "Il est recommandé d'utiliser les CSS pour préciser la police et les \n"
        "propriétés telles que la taille et la couleur. Cela permettra de réduire \n"
        "la taille des fichiers HTML et de les rendre plus faciles à entretenir \n"
        "\n"
    },
    { TEXT_USING_NOBR,                               0,        
        "Il est recommandé d'utiliser les CSS pour contrôler les sauts de ligne.\n"
        "Utilisez \"white-space: nowrap\" pour inhiber les sauts de ligne plutôt que \n"
        "d'insérer <NOBR> ... </ NOBR> dans la structure de balises.\n"
        "\n"
    },
    { TEXT_USING_BODY,                               0,        
        "Il est recommandé d'utiliser les CSS pour préciser les couleurs \n"
        "de la page et des liens"
    },
    { STRING_CONTENT_LOOKS,                          0, "Le contenu du document ressemble à %s"                                                                  },
    { STRING_DOCTYPE_GIVEN,                          0, "DOCTYPE donnée est «%s»"                                                                                },
    { STRING_ERROR_COUNT,                            0, "Tidy a trouvé %u %s et %u %s!\n"                                                                        },
    { STRING_NEEDS_INTERVENTION,                     0,        
        "Ce document contient des erreurs qui doivent d'abord être résolues\n"
        "en utilisant HTML Tidy pour produire une version nettoyée.\n"
    },
    { STRING_NO_ERRORS,                              0, "Aucun avertissement ou erreur trouvée.\n"                                                               },
    { STRING_NO_SYSID,                               0, "Aucun identifiant système dans le doctype soumis"                                                       },
    { STRING_NOT_ALL_SHOWN,                          0, "Tidy a trouvé %u %s et %u %s! Tous les avertissements et erreurs n'ont pas été affichés.\n"             },
    { TEXT_GENERAL_INFO,                             0,        
        "À propos de HTML Tidy: https://github.com/htacg/tidy-html5\n"
        "Rapports de bugs et commentaires: https://github.com/htacg/tidy-html5/issues\n"
        "Liste officielle de diffusion: https://lists.w3.org/Archives/Public/public-htacg/\n"
        "Dernière spécification HTML: http://dev.w3.org/html5/spec-author-view/\n"
        "Validez vos documents HTML: http://validator.w3.org/nu/\n"
        "Encouragez votre entreprise à rejoindre le W3C: http://www.w3.org/Consortium\n"
        "\n"
    },
    { TEXT_GENERAL_INFO_PLEA,                        0,        
        "Parlez-vous une autre langue que le français, ou une variante du français?\n"
        "Merci de nous aider à traduire HTML Tidy. Pour plus d'informations, consultez \n"
        "https://github.com/htacg/tidy-html5/blob/master/README/LOCALIZE.md"
    },
    { ANCHOR_NOT_UNIQUE,                             0, "%s ancre \"%s\" déjà défini"                                                                            },
    { APOS_UNDEFINED,                                0, "l'entité nommée &apos; est défini seulement en XML/XHTML"                                               },
    { ATTR_VALUE_NOT_LCASE,                          0, "valeur d'attribut de %s « %s » doit être en minuscule pour XHTML"                                       },
    { ATTRIBUTE_IS_NOT_ALLOWED,                      0, "L'attribut %s n'\"est\" pas autorisé pour les balises personnalisées autonomes."                        },
    { BACKSLASH_IN_URI,                              0, "La référence d'URI %s contient des anti-slash. Faute de frappe ?"                                       },
    { BAD_ATTRIBUTE_VALUE_REPLACED,                  0, "%s l'attribut « %s » a une valeur non valide « %s » et a été remplacé"                                  },
    { BAD_ATTRIBUTE_VALUE,                           0, "%s l'attribut \"%s\" a une valeur non valide \"%s\""                                                    },
    { BAD_CDATA_CONTENT,                             0, "'<' + '/' + lettres non permises ici"                                                                   },
    { BAD_SUMMARY_HTML5,                             0, "L'attribut summary sur l'élément %s est obsolète avec HTML5"                                            },
    { BAD_SURROGATE_LEAD,                            0,        
        "Paire de substitution U+%04X de terminaison (Bas), sans entité principale (Haut), remplacée par U"
        "+FFFD."
    },
    { BAD_SURROGATE_PAIR,                            0, "Présence d'une paire de substitution hors intervalle U+%04X:U+%04X, remplacée par la valeur U+FFFD."    },
    { BAD_SURROGATE_TAIL,                            0,        
        "Paire de substitution principale (Haute) U+%04X, sans entité de terminaison (Haut), remplacée par U"
        "+FFFD."
    },
    { CANT_BE_NESTED,                                0, "%s ne peut pas être imbriqué"                                                                           },
    { COERCE_TO_ENDTAG,                              0, "<%s> est probablement souhaité pour </%s>"                                                              },
    { CONTENT_AFTER_BODY,                            0, "contenu trouvé après la fin de body"                                                                    },
    { CUSTOM_TAG_DETECTED,                           0, "balise personnalisée autonome détectée %s; sera traitée comme %s"                                       },
    { DISCARDING_UNEXPECTED,                         0, "inhibition de valeur inattendue %s"                                                                     },
    { DOCTYPE_AFTER_TAGS,                            0, "<!DOCTYPE> n'est pas autorisée après les éléments"                                                      },
    { DUPLICATE_FRAMESET,                            0, "élément répété FRAMESET"                                                                                },
    { ELEMENT_NOT_EMPTY,                             0, "%s élément non vide ou non fermé"                                                                       },
    { ELEMENT_VERS_MISMATCH_ERROR,                   0, "%s élément non disponible dans %s"                                                                      },
    { ELEMENT_VERS_MISMATCH_WARN,                    0, "%s élément non disponible dans %s"                                                                      },
    { ENCODING_MISMATCH,                             0, "l'encodage de caractère précisé en entrée (%s) ne correspond pas à l'encodage réellement entré (%s)"    },
    { ESCAPED_ILLEGAL_URI,                           0, "%s échappement de la référence d''URI mal formée"                                                       },
    { FILE_CANT_OPEN,                                0, "Impossible d'ouvrir « %s »\n"                                                                           },
    { FILE_NOT_FILE,                                 0, "\"%s\" n'est pas un fichier!\n"                                                                         },
    { FIXED_BACKSLASH,                               0, "%s conversion des antislash vers slash dans l'URI "                                                     },
    { ID_NAME_MISMATCH,                              0, "%s discordance entre id et valeur de nom d'attribut"                                                    },
    { ILLEGAL_NESTING,                               0, "%s ne doit pas être imbriqué"                                                                           },
    { ILLEGAL_URI_CODEPOINT,                         0, "%s caractères interdits trouvés dans l'URI"                                                             },
    { ILLEGAL_URI_REFERENCE,                         0, "%s mal échappé dans la référence d'URI"                                                                 },
    { INSERTING_AUTO_ATTRIBUTE,                      0, "%s insertion de l'attribut « %s », en utilisant la valeur « %s »"                                       },
    { INSERTING_TAG,                                 0, "insertion implicite de <%s>"                                                                            },
    { INVALID_ATTRIBUTE,                             0, "%s nom d'attribut « %s » (valeur=« %s ») n'est pas valide"                                              },
    { INVALID_NCR,                                   0, "%s référence de caractère numérique non valide %s"                                                      },
    { INVALID_SGML_CHARS,                            0, "%s code de caractère non valide %s"                                                                     },
    { INVALID_UTF8,                                  0, "%s octets UTF-8 non valides (code de caract. %s)"                                                       },
    { INVALID_UTF16,                                 0, "%s paire de substitution UFT-16 non valide (code de caract. %s)"                                        },
    { INVALID_XML_ID,                                0, "%s impossible de copier le nom attribut vers id"                                                        },
    { JOINING_ATTRIBUTE,                             0, "%s regroupement des valeurs répétées de l'attribut « %s »"                                              },
    { MALFORMED_COMMENT,                             0, "tirets adjacents dans un commentaire"                                                                   },
    { MALFORMED_DOCTYPE,                             0, "inhibition de la <!DOCTYPE> mal formée"                                                                 },
    { MISMATCHED_ATTRIBUTE_ERROR,                    0, "%s attribut \"%s\" non permis pour %s"                                                                  },
    { MISMATCHED_ATTRIBUTE_WARN,                     0, "%s attribut \"%s\" non permis pour %s"                                                                  },
    { MISSING_ATTR_VALUE,                            0, "%s attribut \"%s\" n'a pas de valeur"                                                                   },
    { MISSING_ATTRIBUTE,                             0, "%s absence d'attribut \"%s\""                                                                           },
    { MISSING_DOCTYPE,                               0, "déclaration <!DOCTYPE> manquante"                                                                       },
    { MISSING_ENDTAG_BEFORE,                         0, "absence de </%s> avant %s"                                                                              },
    { MISSING_ENDTAG_FOR,                            0, "absence de </%s>"                                                                                       },
    { MISSING_IMAGEMAP,                              0, "%s doivent utiliser une image-map côté client"                                                          },
    { MISSING_QUOTEMARK,                             0, "%s attribut avec apostrophe de fin manquante"                                                           },
    { MISSING_SEMICOLON_NCR,                         0, "La référence de caractère numérique « %s » ne se termine pas par « ; »"                                 },
    { MISSING_SEMICOLON,                             0, "l'entité « %s » ne se termine pas par « ; »"                                                            },
    { MISSING_STARTTAG,                              0, "absence de <%s>"                                                                                        },
    { MISSING_TITLE_ELEMENT,                         0, "ajout d'un élément 'title' manquant"                                                                    },
    { NESTED_EMPHASIS,                               0, "accentuation imbriquée %s"                                                                              },
    { NESTED_QUOTATION,                              0, "éléments \"q\" imbriqués, erreur typographique possible"                                                },
    { NEWLINE_IN_URI,                                0, "%s inhibition des nouvelles lignes dans la référence d'URI"                                             },
    { NOFRAMES_CONTENT,                              0, "%s non positionné dans l'élément 'noframes'"                                                            },
    { NON_MATCHING_ENDTAG,                           0, "remplacement des %s inattendus par </%s>"                                                               },
    { OBSOLETE_ELEMENT,                              0, "remplacement de l'élément obsolète %s par %s"                                                           },
    { PREVIOUS_LOCATION,                             0, "<%s> précédemment mentionnés"                                                                           },
    { PROPRIETARY_ATTR_VALUE,                        0, "%s valeur d'attribut propriétaire « %s »"                                                               },
    { PROPRIETARY_ATTRIBUTE,                         0, "%s attribut propriétaire \"%s\""                                                                        },
    { PROPRIETARY_ELEMENT,                           0, "%s n'est pas approuvé par le W3C"                                                                       },
    { REMOVED_HTML5,                                 0, "élément %s retiré de HTML5"                                                                             },
    { REPEATED_ATTRIBUTE,                            0, "%s abandon de la valeur « %s » pour l'attribut répété « %s »"                                           },
    { REPLACING_ELEMENT,                             0, "remplacement de %s par %s"                                                                              },
    { REPLACING_UNEX_ELEMENT,                        0, "remplacement des %s inattendus par %s"                                                                  },
    { SPACE_PRECEDING_XMLDECL,                       0, "suppression de l'espace précédant la déclaration XML"                                                   },
    { STRING_MISSING_MALFORMED,                      0, "argument manquant ou incorrect pour l'option: %s"                                                       },
    { STRING_UNKNOWN_OPTION,                         0, "option inconnue: %s"                                                                                    },
    { SUSPECTED_MISSING_QUOTE,                       0, "absence de guillemet pour la valeur d'attribut"                                                         },
    { TAG_NOT_ALLOWED_IN,                            0, "%s n'est pas permis dans les éléments <%s>"                                                             },
    { TOO_MANY_ELEMENTS_IN,                          0, "trop d'éléments %s dans <%s>"                                                                           },
    { TOO_MANY_ELEMENTS,                             0, "trop d'éléments %s"                                                                                     },
    { TRIM_EMPTY_ELEMENT,                            0, "réduction des %s vides"                                                                                 },
    { UNESCAPED_AMPERSAND,                           0, "symbole & non échappé qui devrait être écrit &amp;"                                                     },
    { UNEXPECTED_END_OF_FILE_ATTR,                   0, "%s fin de fichier lors de l'analyse des attributs"                                                      },
    { UNEXPECTED_END_OF_FILE,                        0, "fin de fichier inattendue %s"                                                                           },
    { UNEXPECTED_ENDTAG_ERR,                         0, "</%s> inattendu"                                                                                        },
    { UNEXPECTED_ENDTAG_IN,                          0, "</%s> inattendu dans <%s>"                                                                              },
    { UNEXPECTED_ENDTAG,                             0, "</%s> inattendu"                                                                                        },
    { UNEXPECTED_EQUALSIGN,                          0, "%s symbole imprévu '=', nom d'attribut attendu"                                                         },
    { UNEXPECTED_GT,                                 0, "%s symbole '>' manquant pour la fin de balise"                                                          },
    { UNEXPECTED_QUOTEMARK,                          0, "%s guillemet double inattendu ou dupliqué"                                                              },
    { UNKNOWN_ELEMENT_LOOKS_CUSTOM,                  0, "%s n'est pas reconnue! Vouliez-vous activer l'option custom-tags?"                                      },
    { UNKNOWN_ELEMENT,                               0, "%s n'est pas reconnue!"                                                                                 },
    { UNKNOWN_ENTITY,                                0, "symbole & non échappé ou entité inconnue « %s »"                                                        },
    { USING_BR_INPLACE_OF,                           0, "utilisation de <br> à la place de %s"                                                                   },
    { VENDOR_SPECIFIC_CHARS,                         0, "%s code de caractère non valide %s"                                                                     },
    { WHITE_IN_URI,                                  0, "%s rejet des espaces dans la référence URI"                                                             },
    { XML_DECLARATION_DETECTED,                      0, "Une déclaration XML a été détectée. Voulez-vous utiliser l'option input-xml?"                           },
    { XML_ID_SYNTAX,                                 0, "%s ID « %s » utilise la syntaxe XML ID"                                                                 },
    { IMG_MISSING_ALT,                               0, "[1.1.1.1]: <img> texte manquant 'alt'."                                                                 },
    { IMG_ALT_SUSPICIOUS_FILENAME,                   0, "[1.1.1.2]: texte 'alt' suspect (nom de fichier)."                                                       },
    { IMG_ALT_SUSPICIOUS_FILE_SIZE,                  0, "[1.1.1.3]: texte 'alt' suspect (taille de fichier)."                                                    },
    { IMG_ALT_SUSPICIOUS_PLACEHOLDER,                0, "[1.1.1.4]: texte 'alt' suspect (espace réservé)."                                                       },
    { IMG_ALT_SUSPICIOUS_TOO_LONG,                   0, "[1.1.1.10]: texte 'alt' suspect (trop long)."                                                           },
    { IMG_MISSING_LONGDESC_DLINK,                    0, "[1.1.2.1]: <img> absence de 'longdesc' et d-link."                                                      },
    { IMG_MISSING_DLINK,                             0, "[1.1.2.2]: <img> absence de d-link."                                                                    },
    { IMG_MISSING_LONGDESC,                          0, "[1.1.2.3]: <img> absence de 'longdesc'."                                                                },
    { IMG_BUTTON_MISSING_ALT,                        0, "[1.1.3.1]: <img> (bouton) absence de texte 'alt'."                                                      },
    { APPLET_MISSING_ALT,                            0, "[1.1.4.1]: <applet> absence de contenu alternatif."                                                     },
    { OBJECT_MISSING_ALT,                            0, "[1.1.5.1]: <object> absence de contenu alternatif."                                                     },
    { AUDIO_MISSING_TEXT_WAV,                        0, "[1.1.6.1]: texte de transcription audio manquant (wav)."                                                },
    { AUDIO_MISSING_TEXT_AU,                         0, "[1.1.6.2]: texte de transcription audio manquant (au)."                                                 },
    { AUDIO_MISSING_TEXT_AIFF,                       0, "[1.1.6.3]: texte de transcription audio manquant (aiff)."                                               },
    { AUDIO_MISSING_TEXT_SND,                        0, "[1.1.6.4]: texte de transcription audio manquant (snd)."                                                },
    { AUDIO_MISSING_TEXT_RA,                         0, "[1.1.6.5]: texte de transcription audio manquant (ra)."                                                 },
    { AUDIO_MISSING_TEXT_RM,                         0, "[1.1.6.6]: texte de transcription audio manquant (rm)."                                                 },
    { FRAME_MISSING_LONGDESC,                        0, "[1.1.8.1]: <frame> peut nécessiter 'longdesc'."                                                         },
    { AREA_MISSING_ALT,                              0, "[1.1.9.1]: <area> absence de texte 'alt'."                                                              },
    { SCRIPT_MISSING_NOSCRIPT,                       0, "[1.1.10.1]: <script> section <noscript> manquante."                                                     },
    { ASCII_REQUIRES_DESCRIPTION,                    0, "[1.1.12.1]: ascii art nécessite une description."                                                       },
    { IMG_MAP_SERVER_REQUIRES_TEXT_LINKS,            0, "[1.2.1.1]: image map (côté serveur) nécessite des liens textes."                                        },
    { MULTIMEDIA_REQUIRES_TEXT,                      0, "[1.4.1.1]: le multimédia nécessite une équivalence de textes correspondants."                           },
    { IMG_MAP_CLIENT_MISSING_TEXT_LINKS,             0, "[1.5.1.1]: image map (côté client) liens textes manquants."                                             },
    { INFORMATION_NOT_CONVEYED_IMAGE,                0, "[2.1.1.1]: Vérifiez que l'information n'est pas transmise uniquement par la couleur (image)."           },
    { INFORMATION_NOT_CONVEYED_APPLET,               0, "[2.1.1.2]: Vérifiez que l'information n'est pas transmise uniquement par la couleur (applet)."          },
    { INFORMATION_NOT_CONVEYED_OBJECT,               0, "[2.1.1.3]: Vérifiez que l'information n'est pas transmise uniquement par la couleur (object)."          },
    { INFORMATION_NOT_CONVEYED_SCRIPT,               0, "[2.1.1.4]: Vérifiez que l'information n'est pas transmise uniquement par la couleur (script)."          },
    { INFORMATION_NOT_CONVEYED_INPUT,                0,        
        "[2.1.1.5]: Vérifiez que l'information n'est pas transmise uniquement par la couleur (champs de "
        "formulaire)."
    },
    { COLOR_CONTRAST_TEXT,                           0, "[2.2.1.1]: contraste couleur faible (texte)."                                                           },
    { COLOR_CONTRAST_LINK,                           0, "2.2.1.2]: contraste couleur faible (lien)."                                                             },
    { COLOR_CONTRAST_ACTIVE_LINK,                    0, "2.2.1.3]: contraste couleur faible (lien actif)."                                                       },
    { COLOR_CONTRAST_VISITED_LINK,                   0, "2.2.1.4]: contraste couleur faible (lien visité)."                                                      },
    { DOCTYPE_MISSING,                               0, "[3.2.1.1]: déclaration <doctype> manquante."                                                            },
    { STYLE_SHEET_CONTROL_PRESENTATION,              0, "[3.3.1.1]: Utiliser les feuilles de style pour contrôler la présentation."                              },
    { HEADERS_IMPROPERLY_NESTED,                     0, "[3.5.1.1]: entêtes imbriqués incorrectement."                                                           },
    { POTENTIAL_HEADER_BOLD,                         0, "[3.5.2.1]: entête potentiel (gras)."                                                                    },
    { POTENTIAL_HEADER_ITALICS,                      0, "[3.5.2.2]: entête potentiel (italique)."                                                                },
    { POTENTIAL_HEADER_UNDERLINE,                    0, "[3.5.2.3]: entête potentiel (soulignement)."                                                            },
    { HEADER_USED_FORMAT_TEXT,                       0, "[3.5.3.1]: entête utilisé pour formater du texte."                                                      },
    { LIST_USAGE_INVALID_UL,                         0, "[3.6.1.1]: Usage non valide de liste <ul>."                                                             },
    { LIST_USAGE_INVALID_OL,                         0, "[3.6.1.2]: usage non valide de liste <ol>."                                                             },
    { LIST_USAGE_INVALID_LI,                         0, "[3.6.1.4]: usage non valide de liste <li>."                                                             },
    { LANGUAGE_NOT_IDENTIFIED,                       0, "[4.3.1.1]: langage non identifié."                                                                      },
    { LANGUAGE_INVALID,                              0, "[4.3.1.2]: attribut de langage non valide."                                                             },
    { DATA_TABLE_MISSING_HEADERS,                    0, "[5.1.2.1]: data <table> absence d'entêtes rangée/colonne (tous)."                                       },
    { DATA_TABLE_MISSING_HEADERS_COLUMN,             0, "[5.1.2.2]: data <table> absence d'entêtes rang/colonne (1 col)."                                        },
    { DATA_TABLE_MISSING_HEADERS_ROW,                0, "[5.1.2.3]: data <table> absence d'entêtes rang/colonne (1 rang)."                                       },
    { DATA_TABLE_REQUIRE_MARKUP_COLUMN_HEADERS,      0, "[5.2.1.1]: data <table> peut nécessiter une structure de balises (entêtes de colonne)."                 },
    { DATA_TABLE_REQUIRE_MARKUP_ROW_HEADERS,         0, "[5.2.1.1]: data <table> peut nécessiter une structure de balises (entêtes de rangée)."                  },
    { LAYOUT_TABLES_LINEARIZE_PROPERLY,              0, "[5.3.1.1]: vérifie que la structure des tableaux est correctement sérialisée."                          },
    { LAYOUT_TABLE_INVALID_MARKUP,                   0, "[5.4.1.1]: structure de balises incorrecte dans l'agencement de <table>."                               },
    { TABLE_MISSING_SUMMARY,                         0, "[5.5.1.1]: <table> absence de résumé."                                                                  },
    { TABLE_SUMMARY_INVALID_NULL,                    0, "[5.5.1.2]: <table> résumé non valide (null)."                                                           },
    { TABLE_SUMMARY_INVALID_SPACES,                  0, "[5.5.1.3]: <table> résumé non valide (espaces)."                                                        },
    { TABLE_SUMMARY_INVALID_PLACEHOLDER,             0, "[5.5.1.6]: <table> résumé non valide (texte de l'emplacement réservé)."                                 },
    { TABLE_MISSING_CAPTION,                         0, "[5.5.2.1]: <table> absence de légende (<caption>)."                                                     },
    { TABLE_MAY_REQUIRE_HEADER_ABBR,                 0, "[5.6.1.1]: <table> peut nécessiter des abréviations d'entête."                                          },
    { TABLE_MAY_REQUIRE_HEADER_ABBR_NULL,            0, "[5.6.1.2]: <table> abréviations d'entête non valide (null)."                                            },
    { TABLE_MAY_REQUIRE_HEADER_ABBR_SPACES,          0, "[5.6.1.3]: <table> abréviations d'entête non valide (espaces)."                                         },
    { STYLESHEETS_REQUIRE_TESTING_LINK,              0, "[6.1.1.1]: les feuilles de style nécessitent un examen (link)."                                         },
    { STYLESHEETS_REQUIRE_TESTING_STYLE_ELEMENT,     0, "[6.1.1.2]: les feuilles de style nécessitent un examen (élément style)."                                },
    { STYLESHEETS_REQUIRE_TESTING_STYLE_ATTR,        0, "[6.1.1.3]: les feuilles de style nécessitent un examen (attribut style)."                               },
    { FRAME_SRC_INVALID,                             0, "[6.2.1.1]: <frame> source non valide."                                                                  },
    { TEXT_EQUIVALENTS_REQUIRE_UPDATING_APPLET,      0, "[6.2.2.1]: les équivalences de texte nécessitent une mise à jour (applet)."                             },
    { TEXT_EQUIVALENTS_REQUIRE_UPDATING_SCRIPT,      0, "[6.2.2.2]: les équivalences de texte nécessitent une mise à jour (script)."                             },
    { TEXT_EQUIVALENTS_REQUIRE_UPDATING_OBJECT,      0, "[6.2.2.3]: les équivalences de texte nécessitent une mise à jour (object)."                             },
    { PROGRAMMATIC_OBJECTS_REQUIRE_TESTING_SCRIPT,   0, "[6.3.1.1]: les objets programmatiques nécessitent un examen (script)."                                  },
    { PROGRAMMATIC_OBJECTS_REQUIRE_TESTING_OBJECT,   0, "[6.3.1.2]: les objets programmatiques nécessitent un examen (object)."                                  },
    { PROGRAMMATIC_OBJECTS_REQUIRE_TESTING_EMBED,    0, "[6.3.1.3]: les objets programmatiques nécessitent un examen (embed)."                                   },
    { PROGRAMMATIC_OBJECTS_REQUIRE_TESTING_APPLET,   0, "[6.3.1.4]: les objets programmatiques nécessitent un examen (applet)."                                  },
    { FRAME_MISSING_NOFRAMES,                        0, "[6.5.1.1]: <frameset> section <noframes> manquante."                                                    },
    { NOFRAMES_INVALID_NO_VALUE,                     0, "[6.5.1.2]: <noframes> section non valide (pas de valeur)."                                              },
    { NOFRAMES_INVALID_CONTENT,                      0, "[6.5.1.3]: <noframes> section non valide (contenu)."                                                    },
    { NOFRAMES_INVALID_LINK,                         0, "[6.5.1.4]: <noframes> section non valide (lien)."                                                       },
    { REMOVE_FLICKER_SCRIPT,                         0, "[7.1.1.1]: suppression de scintillement (script)."                                                      },
    { REMOVE_FLICKER_OBJECT,                         0, "[7.1.1.2]: suppression de scintillement (object)."                                                      },
    { REMOVE_FLICKER_EMBED,                          0, "[7.1.1.1]: suppression de scintillement (embed)."                                                       },
    { REMOVE_FLICKER_APPLET,                         0, "[7.1.1.1]: suppression de scintillement (applet)."                                                      },
    { REMOVE_FLICKER_ANIMATED_GIF,                   0, "[7.1.1.1]: suppression de scintillement (gif animé)."                                                   },
    { REMOVE_BLINK_MARQUEE,                          0, "[7.2.1.1]: suppression de blink/marquee."                                                               },
    { REMOVE_AUTO_REFRESH,                           0, "[7.4.1.1]: suppression de auto-refresh."                                                                },
    { REMOVE_AUTO_REDIRECT,                          0, "[7.5.1.1]: suppression de auto-redirect."                                                               },
    { ENSURE_PROGRAMMATIC_OBJECTS_ACCESSIBLE_SCRIPT, 0, "[8.1.1.1]: garantir que les objets programmatiques sont accessibles (script)."                          },
    { ENSURE_PROGRAMMATIC_OBJECTS_ACCESSIBLE_OBJECT, 0, "[8.1.1.2]: garantir que les objets programmatiques sont accessibles (object)."                          },
    { ENSURE_PROGRAMMATIC_OBJECTS_ACCESSIBLE_APPLET, 0, "[8.1.1.3]: garantir que les objets programmatiques sont accessibles (applet)."                          },
    { ENSURE_PROGRAMMATIC_OBJECTS_ACCESSIBLE_EMBED,  0, "[8.1.1.4]: garantir que les objets programmatiques sont accessibles (embed)."                           },
    { IMAGE_MAP_SERVER_SIDE_REQUIRES_CONVERSION,     0, "[9.1.1.1]: image map (côté serveur) nécessite une conversion."                                          },
    { SCRIPT_NOT_KEYBOARD_ACCESSIBLE_ON_MOUSE_DOWN,  0, "[9.3.1.1]: <script> non accessible par le clavier (onMouseDown)."                                       },
    { SCRIPT_NOT_KEYBOARD_ACCESSIBLE_ON_MOUSE_UP,    0, "[9.3.1.2]: <script> non accessible par le clavier (onMouseUp)."                                         },
    { SCRIPT_NOT_KEYBOARD_ACCESSIBLE_ON_CLICK,       0, "[9.3.1.3]: <script> non accessible par le clavier (onClick)."                                           },
    { SCRIPT_NOT_KEYBOARD_ACCESSIBLE_ON_MOUSE_OVER,  0, "[9.3.1.4]: <script> non accessible par le clavier (onMouseOver)."                                       },
    { SCRIPT_NOT_KEYBOARD_ACCESSIBLE_ON_MOUSE_OUT,   0, "[9.3.1.5]: <script> non accessible par le clavier (onMouseOut)."                                        },
    { SCRIPT_NOT_KEYBOARD_ACCESSIBLE_ON_MOUSE_MOVE,  0, "[9.3.1.6]: <script> non accessible par le clavier (onMouseMove)."                                       },
    { NEW_WINDOWS_REQUIRE_WARNING_NEW,               0, "[10.1.1.1]: les nouvelles fenêtres nécessitent un avertissement (_new)."                                },
    { NEW_WINDOWS_REQUIRE_WARNING_BLANK,             0, "[10.1.1.2]: les nouvelles fenêtres nécessitent un avertissement (_blank)."                              },
    { REPLACE_DEPRECATED_HTML_APPLET,                0, "[11.2.1.1]: remplacer l'élément HTML déprécié <applet>."                                                },
    { REPLACE_DEPRECATED_HTML_BASEFONT,              0, "[11.2.1.2]: remplacer l'élément HTML déprécié <basefont>."                                              },
    { REPLACE_DEPRECATED_HTML_CENTER,                0, "[11.2.1.3]: remplacer l'élément HTML déprécié <center>."                                                },
    { REPLACE_DEPRECATED_HTML_DIR,                   0, "[11.2.1.4]: remplacer l'élément HTML déprécié <dir>."                                                   },
    { REPLACE_DEPRECATED_HTML_FONT,                  0, "[11.2.1.5]: remplacer l'élément HTML déprécié <font>."                                                  },
    { REPLACE_DEPRECATED_HTML_ISINDEX,               0, "[11.2.1.6]: remplacer l'élément HTML déprécié <isindex>."                                               },
    { REPLACE_DEPRECATED_HTML_MENU,                  0, "[11.2.1.7]: remplacer l'élément HTML déprécié <menu>."                                                  },
    { REPLACE_DEPRECATED_HTML_S,                     0, "[11.2.1.8]: remplacer l'élément HTML déprécié <s>."                                                     },
    { REPLACE_DEPRECATED_HTML_STRIKE,                0, "[11.2.1.9]: remplacer l'élément HTML déprécié <strike>."                                                },
    { REPLACE_DEPRECATED_HTML_U,                     0, "[11.2.1.10]: remplacer l'élément HTML déprécié <u>."                                                    },
    { FRAME_MISSING_TITLE,                           0, "[12.1.1.1]: <frame> absence de titre."                                                                  },
    { FRAME_TITLE_INVALID_NULL,                      0, "[12.1.1.2]: <frame> titre non valide (null)."                                                           },
    { FRAME_TITLE_INVALID_SPACES,                    0, "[12.1.1.3]: <frame> titre non valide (espaces)."                                                        },
    { ASSOCIATE_LABELS_EXPLICITLY,                   0, "[12.4.1.1]: associer explicitement les étiquettes avec les contrôles de formulaire."                    },
    { ASSOCIATE_LABELS_EXPLICITLY_FOR,               0, "[12.4.1.2]: associer explicitement les étiquettes avec les contrôles de formulaire (for)."              },
    { ASSOCIATE_LABELS_EXPLICITLY_ID,                0, "[12.4.1.3]: associer explicitement les étiquettes avec les contrôles de formulaire (id)."               },
    { LINK_TEXT_NOT_MEANINGFUL,                      0, "[13.1.1.1]: texte du lien peu significatif."                                                            },
    { LINK_TEXT_MISSING,                             0, "[13.1.1.2]: texte du lien manquant."                                                                    },
    { LINK_TEXT_TOO_LONG,                            0, "[13.1.1.3]: texte du lien trop long."                                                                   },
    { LINK_TEXT_NOT_MEANINGFUL_CLICK_HERE,           0, "[13.1.1.4]: texte du lien peu significatif (click here)."                                               },
    { METADATA_MISSING,                              0, "[13.2.1.1]: Métadonnées manquantes."                                                                    },
    { METADATA_MISSING_REDIRECT_AUTOREFRESH,         0, "[13.2.1.3]: Métadonnées manquantes (redirect/auto-refresh)."                                            },
    { SKIPOVER_ASCII_ART,                            0, "[13.10.1.1]: ignore l'ascii art."                                                                       },

#if SUPPORT_CONSOLE_APP
    { TC_LABEL_COL,                                  0, "colonne"                                                                                                },
    { TC_LABEL_FILE,                                 0, "fichier"                                                                                                },
    { TC_LABEL_LANG,                                 0, "langue"                                                                                                 },
    { TC_LABEL_LEVL,                                 0, "niveau"                                                                                                 },
    { TC_LABEL_OPT,                                  0, "option"                                                                                                 },
    { TC_MAIN_ERROR_LOAD_CONFIG,                     0, "Le chargement du fichier de configuration \"%s\" a échoué, err = %d"                                    },
    { TC_OPT_ACCESS,                                 0,        
        "faire des vérifications d'accessibilité supplémentaires (<niveau> = 0, 1, 2, 3). implicitement 0 si "
        "<niveau> est manquant."
    },
    { TC_OPT_ASCII,                                  0, "utilise ISO-8859-1 pour l'entrée, US-ASCII pour la sortie"                                              },
    { TC_OPT_ASHTML,                                 0, "force le XHTML en HTML bien structuré"                                                                  },
    { TC_OPT_ASXML,                                  0, "converti le HTML en XHTML bien structuré"                                                               },
    { TC_OPT_BARE,                                   0, "enlève les guillemets à double chevron et les tirets longs."                                            },
    { TC_OPT_BIG5,                                   0, "utilise Big5 pour l'entrée et la sortie"                                                                },
    { TC_OPT_CLEAN,                                  0, "remplace les balises FONT, NOBR et CENTER par du CSS"                                                   },
    { TC_OPT_CONFIG,                                 0, "détermine les options de configuration à partir du <fichier> spécifié "                                 },
    { TC_OPT_ERRORS,                                 0, "affiche seulement les erreurs et avertissements"                                                        },
    { TC_OPT_FILE,                                   0, "écrit les erreurs et avertissements vers le <fichier> précisé "                                         },
    { TC_OPT_GDOC,                                   0, "produit une version nettoyée du html exporté par Google Docs"                                           },
    { TC_OPT_HELP,                                   0, "liste toutes les options de ligne de commande"                                                          },
    { TC_OPT_HELPCFG,                                0, "liste toutes les options de configuration"                                                              },
    { TC_OPT_HELPOPT,                                0, "Affiche une description de l'<option>"                                                                  },
    { TC_OPT_IBM858,                                 0, "utilise IBM-858 (CP850+Euro) pour l'entrée, US-ASCII pour la sortie"                                    },
    { TC_OPT_INDENT,                                 0, "indente le contenu d'un élément"                                                                        },
    { TC_OPT_ISO2022,                                0, "utilise ISO-2022 pour l'entrée et la sortie"                                                            },
    { TC_OPT_LANGUAGE,                               0,        
        "Précise le langage de sortie de Tidy pour <lang>. Ajouter '-language help' pour plus d'aide. "
        "Utiliser avant les arguments produisant des sorties pour garantir que le langage sera pris en "
        "compte, par exemple `tidy -lang fr -lang help`."
    },
    { TC_OPT_LATIN0,                                 0, "utilise ISO-8859-15 pour l'entrée, US-ASCII pour la sortie"                                             },
    { TC_OPT_LATIN1,                                 0, "utilise ISO-8859-1 pour l'entrée et la sortie"                                                          },
    { TC_OPT_MAC,                                    0, "utilise MacRoman pour l'entrée, US-ASCII pour la sortie"                                                },
    { TC_OPT_MODIFY,                                 0, "modifie le fichier original en entrée"                                                                  },
    { TC_OPT_NUMERIC,                                0, "sortie numérique plutôt qu'entités nommées"                                                             },
    { TC_OPT_OMIT,                                   0, "Omettre les tags optionnels d'ouverture et de fermeture"                                                },
    { TC_OPT_OUTPUT,                                 0, "écrit la sortie vers le fichier <file>"                                                                 },
    { TC_OPT_QUIET,                                  0, "supprime les sorties non-essentielles"                                                                  },
    { TC_OPT_RAW,                                    0, "Valeurs de sortie supérieures à 127 sans conversion en entités"                                         },
    { TC_OPT_SHIFTJIS,                               0, "utilise Shift_JIS à la fois pour l'entrée et la sortie"                                                 },
    { TC_OPT_SHOWCFG,                                0, "liste les options de configuration"                                                                     },
    { TC_OPT_UPPER,                                  0, "force les balises en lettres majuscules"                                                                },
    { TC_OPT_UTF16,                                  0, "utilise UTF-16 à la fois pour l'entrée et la sortie"                                                    },
    { TC_OPT_UTF16BE,                                0, "utilise UTF-16BE à la fois pour l'entrée et la sortie"                                                  },
    { TC_OPT_UTF16LE,                                0, "utilise UTF-16LE à la fois pour l'entrée et la sortie"                                                  },
    { TC_OPT_UTF8,                                   0, "utilise UTF-8 à la fois pour l'entrée et la sortie"                                                     },
    { TC_OPT_VERSION,                                0, "affiche la version de Tidy"                                                                             },
    { TC_OPT_WIN1252,                                0, "utilise Windows-1252 pour l'entrée, US-ASCII pour la sortie"                                            },
    { TC_OPT_WRAP,                                   0,        
        "coupe le texte à la colonne <column>. 0 est supposé si <column> est manquante. Si cette option "
        "n'est pas précisée, la valeur par défaut de l'option 'wrap' s'applique."
    },
    { TC_OPT_XML,                                    0, "précise que l'entrée est un XML bien structuré"                                                         },
    { TC_OPT_XMLCFG,                                 0, "liste toutes les options de configuration au format XML"                                                },
    { TC_OPT_XMLHELP,                                0, "liste les options de ligne de commande au format XML"                                                   },
    { TC_OPT_XMLSTRG,                                0, "sortie de toutes les chaînes Tidy au format XML"                                                        },
    { TC_OPT_XMLERRS,                                0, "constantes et chaînes de sortie d'erreur au format XML"                                                 },
    { TC_OPT_XMLOPTS,                                0, "descriptions des options de sortie au format XML"                                                       },
    { TC_STRING_CONF_HEADER,                         0, "Fichier de configuration:"                                                                              },
    { TC_STRING_CONF_NAME,                           0, "Nom"                                                                                                    },
    { TC_STRING_CONF_TYPE,                           0, "Type"                                                                                                   },
    { TC_STRING_CONF_VALUE,                          0, "Valeur courante"                                                                                        },
    { TC_STRING_OPT_NOT_DOCUMENTED,                  0, "Attention: l'option `%s' n'est pas documentée."                                                         },
    { TC_STRING_OUT_OF_MEMORY,                       0, "Mémoire insuffisante. Abandon."                                                                         },
    { TC_STRING_FATAL_ERROR,                         0, "Erreur fatale: valeur impossible pour id='%d'."                                                         },
    { TC_STRING_FILE_MANIP,                          0, "Manipulation de fichier"                                                                                },
    { TC_STRING_PROCESS_DIRECTIVES,                  0, "Directives de traitement"                                                                               },
    { TC_STRING_CHAR_ENCODING,                       0, "Encodages de caractère"                                                                                 },
    { TC_STRING_LANG_MUST_SPECIFY,                   0, "Une locale POSIX ou Windows doit être précisée."                                                        },
    { TC_STRING_LANG_NOT_FOUND,                      0, "Tidy n'a pas la langue '%s', '%s' sera utilisé à la place."                                             },
    { TC_STRING_MISC,                                0, "Divers"                                                                                                 },
    { TC_STRING_XML,                                 0, "XML"                                                                                                    },
    { TC_STRING_MUST_SPECIFY,                        0, "Un nom d'option doit être précisé."                                                                     },
    { TC_STRING_UNKNOWN_OPTION,                      0, "HTML Tidy: option inconnue: %c"                                                                         },
    { TC_STRING_UNKNOWN_OPTION_B,                    0, "HTML Tidy: option inconnue."                                                                            },
    { TC_STRING_VERS_A,                              0, "HTML Tidy pour %s version %s"                                                                           },
    { TC_STRING_VERS_B,                              0, "HTML Tidy version %s"                                                                                   },
    { TC_TXT_HELP_1,                                 0,        
        "\n"
        "%s [options...] [fichier...] [options...] [fichier...]\n"
        "Utilitaire pour nettoyer et embellir le HTML/XHTML/XML.\n"
        "\n"
        "Ceci est le HTML Tidy modernisé version %s.\n"
        "\n"
    },
    { TC_TXT_HELP_2A,                                0, "Arguments en ligne de commande de HTML Tidy pour %s:"                                                   },
    { TC_TXT_HELP_2B,                                0, "Arguments en ligne de commande de HTML Tidy:"                                                           },
    { TC_TXT_HELP_3,                                 0,        
        "\n"
        "Options de configuration de Tidy\n"
        "==========================\n"
        "Utilisez les options de configuration de Tidy comme arguments de \n"
        "ligne de commande, sous la forme «--option <valeur>\", par exemple \n"
        "\"--indent-with-tabs yes\"\n"
        "\n"
        "Pour une liste de toutes les options de configuration, utilisez \n"
        "\"-help-config\" ou consultez la page de manuel (si votre OS a la \n"
        "commande man).\n"
        "\n"
        "Si votre environnement a déclaré une variable $HTML_TIDY qui pointe \n"
        "vers un fichier de configuration, alors Tidy tentera de l'utiliser.\n"
        "\n"
        "Sur certaines plateformes, Tidy essaiera également d'utiliser une \n"
        "configuration décrite dans /etc/tidy.conf ou ~/.tidy.conf.\n"
        "\n"
        "Autre\n"
        "=====\n"
        "Pour l'entrée/sortie par défaut, utilisez stdin/stdout respectivement. \n"
        "\n"
        "Les options en lettre simple, en dehors de -f, peuvent être combinées \n"
        "comme dans: tidy -f errs.txt -imu foo.html\n"
        "\n"
        "Renseignements\n"
        "===========\n"
        "Pour plus d'informations à propos de HTML Tidy, voir\n"
        "  http://www.html-tidy.org/\n"
        "\n"
        "Pour plus d'informations sur le langage HTML, consultez les rubriques suivantes:\n"
        "\n"
        "  HTML: Édition pour les auteurs Web (de la dernière spécification HTML)\n"
        "  http://dev.w3.org/html5/spec-author-view\n"
        "\n"
    },
    { TC_TXT_HELP_CONFIG,                            0,        
        "\n"
        "Paramètres de configuration de HTML Tidy\n"
        "\n"
        "Dans un fichier, utilisez la forme:\n"
        "\n"
        "wrap: 72\n"
        "indent: no\n"
        "\n"
        "Quand il sont précisés en ligne de commande, utilisez la forme:\n"
        "\n"
        "--wrap 72 --indent no\n"
        "\n"
    },
    { TC_TXT_HELP_CONFIG_NAME,                       0, "Nom"                                                                                                    },
    { TC_TXT_HELP_CONFIG_TYPE,                       0, "Type"                                                                                                   },
    { TC_TXT_HELP_CONFIG_ALLW,                       0, "Valeurs possibles"                                                                                      },
    { TC_TXT_HELP_LANG_1,                            0,        
        "\n"
        "L'option -language (ou -lang) indique la langue que Tidy doit utiliser \n"
        "en sortie. Veuillez noter que ce n'est pas un service de traduction de \n"
        "documents, et que cela affecte uniquement les messages que Tidy \n"
        "renvoie.\n"
        "\n"
        "Lorsqu'il est utilisé depuis la ligne de commande, l'argument -language \n"
        "doit être utilisé avant des arguments qui ont un impact sur la sortie, \n"
        "sinon Tidy va produire une sortie avant de connaître la langue à utiliser.\n"
        "\n"
        "En plus des codes de langue du standard POSIX, Tidy est capable de\n"
        "comprendre les codes de langue historiques de Windows. \n"
        "Veuillez noter que cette liste indique les codes que Tidy comprend, et \n"
        "ne signifie pas que la langue est pour autant installée.\n"
        "\n"
        "La colonne de droite indique comment Tidy comprendra le nom \n"
        "Windows historique.\n"
        "\n"
    },
    { TC_TXT_HELP_LANG_2,                            0,        
        "\n"
        "Les langages suivants sont installés pour le moment dans Tidy.\n"
        "Veuillez noter qu'il n'y a pas de garantie qu'ils soient complets ; \n"
        "Seul un développeur (ou plusieurs) a commencé à ajouter le \n"
        "langage indiqué.\n"
        "\n"
    },
    { TC_TXT_HELP_LANG_3,                            0,        
        "\n"
        "Si Tidy est capable de déterminer votre locale, Tidy utilisera alors la langue \n"
        "locale automatiquement. Par exemple, les systèmes basés sur Unix utilisent \n"
        "une variable d'environnement $LANG et/ou $LC_ALL.\n"
        "Consultez la documentation de votre système d'exploitation pour plus \n"
        "d'informations. \n"
        "\n"
        "Tidy utilise pour l'instant la locale %s. \n"
        "\n"
    },
#endif /* SUPPORT_CONSOLE_APP */

    {/* This MUST be present and last. */
      TIDY_MESSAGE_TYPE_LAST,                        0, NULL
    }

}};


#endif /* language_fr_h */

#ifndef language_pt_br_h
#define language_pt_br_h
/*
 * language_pt_br.h
 * Localization support for HTML Tidy.
 *
 *
 * This file is a localization file for HTML Tidy. It will have been machine
 * generated or created and/or edited by hand. Both are valid options, but
 * please help keep our localization efforts simple to maintain by maintaining
 * the structure of this file, and changing the check box below if you make
 * changes (so others know the file origin):
 *
 * [X] THIS FILE IS MACHINE GENERATED. It is a localization file for the
 *     language (and maybe region) "pt_br". The source of
 *     these strings is a gettext PO file in Tidy's source, probably called 
 *     "language_pt_br.po".
 *
 * [ ] THIS FILE WAS HAND MODIFIED. Translators, please feel to edit this file
 *     directly (and check this box). If you prefer to edit PO files then use
 *     `poconvert.rb msgunfmt language_pt_br.h` (our own
 *     conversion tool) to generate a fresh PO from this file first!
 *
 * (c) 2015-2017 HTACG
 * See tidy.h and access.h for the copyright notice.
 *
 * Template Created by Jim Derry on 01/14/2016.
 *
 * Orginating PO file metadata:
 *   PO_LAST_TRANSLATOR=jderry
 *   PO_REVISION_DATE=2017-10-05 15:13:40
 */

#ifdef _MSC_VER
#pragma execution_character_set("utf-8")
#endif


/**
 *  This language-specific function returns the correct pluralForm
 *  to use given n items, and is used as a member of each language
 *  definition.
 */
static unsigned int whichPluralForm_pt_br(unsigned int n) {
    /* Plural-Forms: nplurals=2; */
    return (n > 1);
}


/**
 *  This structure specifies all of the strings needed by Tidy for a
 *  single language. Static definition in a header file makes it
 *  easy to include and exclude languages without tinkering with
 *  the build system.
 */
static languageDefinition language_pt_br = { whichPluralForm_pt_br, {
    /***************************************
     ** This MUST be present and first. 
     ** Specify the code for this language.
     ***************************************/
    {/* Specify the ll or ll_cc language code here. */
      TIDY_LANGUAGE,                                 0, "pt_br"
    },
    { TidyAccessibilityCheckLevel,                   0,        
        "Esta opção especifica o nível de verificação de acessibilidade, se houver, "
        "que Tidy deve executar. <br/>Nível <var>0 (Tidy Classic)</var> é equivalente "
        "à verificação de acessibilidade do Tidy Classic.<br/> Para obter mais "
        "informações sobre a verificação de acessibilidade do Tidy, visite <a href=\""
        "http://www.html-tidy.org/accessibility/\"> Página de acessibilidade do "
        "Tidy</a>. "
    },
    { TidyAltText,                                   0,        
        "Esta opção especifica o texto padrão <code>alt=</code> que o Tidy usa para "
        "atributos <code>&lt;img&gt;</code> quando o atributo <code>alt=</code> está "
        "faltando. <br/>Use com cuidado, pois é sua responsabilidade tornar seus "
        "documentos acessíveis para pessoas que não conseguem ver as imagens. "
    },
    { TidyAnchorAsName,                              0,        
        "Esta opção controla a exclusão ou adição do atributo <code>name</code> em "
        "elementos onde ele pode servir como âncora. <br/>Se configurado para "
        "<var>yes</var>, um atributo <code>name</code>, se não já existir, é "
        "adicionado ao longo de um atributo <code>id</code> existente se o DTD o "
        "permitir. <br/>Se configurado para <var>no</var> qualquer atributo de nome "
        "existente é removido se um atributo <code>id</code> existir ou tenha sido "
        "adicionado. "
    },
    { TidyAsciiChars,                                0,        
        "Pode ser usado para modificar o comportamento da opção <code>clean</code> "
        "quando configurado para <var>yes</var>. <br/>Se configurado para "
        "<var>yes</var> ao usar <code>clean</code>, <code>&amp;emdash;</code>, "
        "<code>&amp;rdquo;</code>, e outras entidades de caracteres nomeadas são "
        "rebaixadas para os equivalentes ASCII mais próximos. "
    },
    { TidyBlockTags,                                 0,        
        "Esta opção especifica novas tags de nível de bloco. Esta opção possui uma "
        "lista separada por vírgulas ou espaço de nomes de tags. <br/>A menos que "
        "você declare novas tags, o Tidy se recusará a gerar um arquivo arrumado se a "
        "entrada incluir tags anteriormente desconhecidas. <br/>Note que você não "
        "pode alterar o modelo de conteúdo para elementos como "
        "<code>&lt;table&gt;</code>, <code>&lt;ul&gt;</code>, <code>&lt;ol&gt;</code> "
        "e <code>&lt;dl&gt;</code>. <br/>Esta opção é ignorada no modo XML. "
    },
    { TidyBodyOnly,                                  0,        
        "Esta opção especifica se o Tidy deve imprimir apenas o conteúdo da tag body "
        "como um fragmento HTML. <br/>Se configurado para <var>auto</var>, isso é "
        "realizado somente se a tag body tiver sido inferida. <br/>Útil para "
        "incorporar páginas inteiras existentes como uma porção de outra página. <br/>"
        "Esta opção não tem efeito se a saída XML for solicitada. "
    },
    { TidyBreakBeforeBR,                             0,        
        "Esta opção especifica se o Tidy deve emitir uma quebra de linha antes de "
        "cada elemento <code>&lt;br&gt;</code>. "
    },
    { TidyCharEncoding,                              0,        
        "Esta opção especifica a codificação de caracteres que o Tidy usa tanto para "
        "a entrada como para a saída. <br/>Para <var>ascii</var>, o Tidy aceitará "
        "valores de caracteres Latin-1 (ISO-8859-1), mas usará entidades para todos "
        "os caracteres cujo valor seja &gt;127. <br/>Para <var>raw</var>, o Tidy "
        "emitirá valores acima de 127 sem traduzi-los em entidades. <br/>Para "
        "<var>latin1</var>, os caracteres acima de 255 serão escritos como entidades. "
        "<br/>Para <var>utf8</var>, Tidy presume que tanto a entrada como a saída são "
        "codificadas como UTF-8. <br/>Você pode usar <var>iso2022</var> para arquivos "
        "codificados usando a família de codificações ISO-2022, p.ex. ISO-2022-JP. "
        "<br/> Para <var>mac</var> e <var>win1252</var>, o Tidy aceitará valores de "
        "caracteres específicos do fornecedor, mas usará entidades para todos os "
        "caracteres cujo valor seja &gt;127. <br/>Para codificações sem suporte, use "
        "um utilitário externo para converter de e para UTF-8. "
    },
    { TidyCoerceEndTags,                             0,        
        "Esta opção especifica se o Tidy deve coagir uma tag de início em uma tag de "
        "fim nos casos em que parece que uma tag de fim provavelmente foi projetada; "
        "por exemplo, dado <br/><code>&lt;span&gt;foo &lt;b&gt;bar&lt;b&gt; "
        "baz&lt;/span&gt;</code>, <br/>Tidy vai emitir <br/><code>&lt;span&gt;foo "
        "&lt;b&gt;bar&lt;/b&gt; baz&lt;/span&gt;</code> "
    },
    { TidyCSSPrefix,                                 0,        
        "Esta opção especifica o prefixo que o Tidy usa para regras de estilo. <br/>Por padrão, <var>c</"
        "var> será usado. "
    },
    { TidyDecorateInferredUL,                        0,        
        "Esta opção especifica se o Tidy deve decorar elementos inferidos "
        "<code>&lt;ul&gt;</code> com algumas marcações CSS para evitar recuo para a "
        "direita. "
    },
    { TidyDoctype,                                   0,        
        "Esta opção especifica a declaração DOCTYPE gerada pelo Tidy. <br/>Se "
        "configurado para <var>omit</var>, a saída não conterá uma declaração "
        "DOCTYPE. Note que isso também implica que <code>numeric-entity</code> esteja "
        "definido para <var>yes</var>. <br/>Se configurado para <var>html5</var>, o "
        "DOCTYPE é configurado para <code>&lt;!DOCTYPE html&gt;</code>. <br/>Se "
        "configurado para <var>auto</var> (o padrão), Tidy usará um palpite educado "
        "com base no conteúdo do documento. <br/>Se configurado para <var>strict</var>"
        ", o Tidy configurará o DOCTYPE para o DTD estrito HTML4 ou XHTML1. <br/>Se "
        "configurado para <var>loose</var>, o DOCTYPE é definido como o DTD loose "
        "(transicional) HTML4 ou XHTML1. <br/>Alternativamente, você pode fornecer "
        "uma string para o identificador público formal (FPI). <br/>Por exemplo: "
        "<br/><code>doctype: \"-//ACME//DTD HTML 3.14159//EN\"</code><br/>Se você "
        "especificar o FPI para um documento XHTML, o Tidy irá definir o "
        "identificador do sistema em uma string vazia. Para um documento HTML, a Tidy "
        "adiciona um identificador de sistema somente se um já estivesse presente "
        "para preservar o modo de processamento de alguns navegadores. Tidy deixa o "
        "DOCTYPE para documentos genéricos XML inalterados. <br/>Esta opção não "
        "oferece uma validação da conformidade do documento. "
    },
    { TidyDropEmptyElems,                            0, "Esta opção especifica se Tidy deve descartar elementos vazios. "                                 },
    { TidyDropEmptyParas,                            0, "Esta opção especifica se Tidy deve descartar parágrafos vazios. "                                },
    { TidyDropPropAttrs,                             0,        
        "Esta opção especifica se o Tidy deve remover os atributos de propriedade, "
        "como os atributos de ligação de dados da Microsoft. Além disso, os atributos "
        "que não são permitidos na versão de saída do HTML serão descartados se "
        "usados com <code>strict-tags-attributes</code>. "
    },
    { TidyDuplicateAttrs,                            0,        
        "Esta opção especifica se o Tidy deve manter o primeiro ou último atributo, "
        "se um atributo estiver repetido, p.ex. possui dois atributos "
        "<code>align</code>. "
    },
    { TidyEmacs,                                     0,        
        "Esta opção especifica se o Tidy deve alterar o formato para relatar erros e "
        "avisos para um formato que é analisado mais facilmente pelo GNU Emacs. "
    },
    { TidyEmptyTags,                                 0,        
        "Esta opção especifica novas tags em-linha vazias. Esta opção possui uma "
        "lista separada por espaço ou vírgulas de nomes de tags. <br/>A menos que "
        "você declare novas tags, o Tidy se recusará a gerar um arquivo arrumado se a "
        "entrada incluir tags anteriormente desconhecidas. <br/>Lembre-se de declarar "
        "tags vazias como em linha ou bloqueio. <br/>Esta opção é ignorada no modo "
        "XML. "
    },
    { TidyEncloseBlockText,                          0,        
        "Esta opção especifica se Tidy deve inserir um elemento <code>&lt;p&gt;</code>"
        " para incluir qualquer texto que encontre em qualquer elemento que permita o "
        "conteúdo misto para HTML transicional mas não HTML estrito. "
    },
    { TidyEncloseBodyText,                           0,        
        "Esta opção especifica se o Tidy deve incluir qualquer texto encontrado no "
        "elemento do corpo dentro de um elemento <code>&lt;p&gt;</code>. <br/>Isso é "
        "útil quando você deseja usar o HTML existente e usá-lo com uma folha de "
        "estilo. "
    },
    { TidyErrFile,                                   0,        
        "Esta opção especifica o arquivo de erro que o Tidy usa para erros e avisos. "
        "Normalmente, erros e avisos são emitidos para <code>stderr</code>. "
    },
    { TidyEscapeCdata,                               0,        
        "Esta opção especifica se o Tidy deve converter seções "
        "<code>&lt;![CDATA[]]&gt;</code> em texto normal. "
    },
    { TidyEscapeScripts,                             0,        
        "Esta opção faz com que itens que se parecem com tags de fechamento, como <code>&lt;/g</code> "
        "sejam escapadas para <code>&lt;\\/g</code>. Defina esta opção para <var>no</var> se você não "
        "deseja isso."
    },
    { TidyFixBackslash,                              0,        
        "Esta opção especifica se o Tidy deve substituir caracteres de barra "
        "invertida <code>\\</code> em URLs com barras <code>/</code>. "
    },
    { TidyFixComments,                               0,        
        "Esta opção especifica se Tidy deve substituir hífenes inesperados com "
        "caracteres <code>=</code> quando se trata de hífenes adjacentes. <br/>O "
        "padrão é <var>yes</var>. <br/>Esta opção é fornecida para usuários do Cold "
        "Fusion que usam a sintaxe do comentário: <code>&lt;!--- ---&gt;</code>. "
    },
    { TidyFixUri,                                    0,        
        "Esta opção especifica se o Tidy deve verificar valores de atributos que "
        "carregam URIs para caracteres ilegais e, se tal for encontrado, escapa-os "
        "conforme o HTML4 recomenda. "
    },
    { TidyForceOutput,                               0,        
        "Esta opção especifica se o Tidy deve produzir saída, mesmo se forem "
        "encontrados erros. <br/>Use esta opção com cuidado; Se o Tidy relatar um "
        "erro, significa que o Tidy não conseguiu corrigir o erro (ou não sabe como), "
        "então a saída resultante pode não refletir sua intenção. "
    },
    { TidyGDocClean,                                 0,        
        "Esta opção especifica se o Tidy deve habilitar comportamento específico para "
        "limpeza de HTML exportado do Google Docs. "
    },
    { TidyHideComments,                              0, "Esta opção especifica se Tidy deve imprimir os comentários. "                                    },
    { TidyHtmlOut,                                   0,        
        "Esta opção especifica se o Tidy deve gerar uma impressão amigável, "
        "escrevendo como HTML. "
    },
    { TidyInCharEncoding,                            0,        
        "Esta opção especifica a codificação de caracteres que o Tidy usa para a "
        "entrada. Veja <code>char-encoding</code> para mais informações. "
    },
    { TidyIndentAttributes,                          0,        
        "Esta opção especifica se o Tidy deve começar cada atributo em uma nova "
        "linha. "
    },
    { TidyIndentCdata,                               0,        
        "Esta opção especifica se o Tidy deve aplicar recuo nas seções "
        "<code>&lt;![CDATA[]]&gt;</code>. "
    },
    { TidyIndentContent,                             0,        
        "Esta opção especifica se Tidy deve aplicar recuo nas tags de nível de bloco. "
        "<br/>Se configurado para <var>auto</var>, Tidy decidirá se aplica ou não "
        "recuo no conteúdo das tags, como <code>&lt;title&gt;</code>, "
        "<code>&lt;h1&gt;</code>-<code>&lt;h6&gt;</code>, <code>&lt;li&gt;</code>, "
        "<code>&lt;td&gt;</code> ou <code>&lt;p&gt;</code> com base no conteúdo, "
        "incluindo um elemento de nível de bloco. <br/>Configurar <code>indent</code> "
        "para <var>yes</var> pode expor erros de layout em alguns navegadores. <br/>"
        "Use a opção <code>indent-spaces</code> para controlar o número de espaços ou "
        "tabulações de saída por nível de recuo e <code>indent-with-tabs</code> para "
        "especificar se espaços ou tabulações são usados. "
    },
    { TidyIndentSpaces,                              0,        
        "Esta opção especifica o número de espaços ou guias que o Tidy usa para "
        "recuar o conteúdo quando <code>indent</code> está habilitado. <br/>Note que "
        "o valor padrão para esta opção depende do valor de <code>indent-with-"
        "tabs</code> (veja também). "
    },
    { TidyInlineTags,                                0,        
        "Esta opção especifica novas tags em-linha não vazias. Esta opção possui uma "
        "lista separada por espaço ou vírgulas de nomes de tags. <br/>A menos que "
        "você declare novas tags, o Tidy se recusará a gerar um arquivo arrumado se a "
        "entrada incluir tags anteriormente desconhecidas. <br/>Esta opção é ignorada "
        "no modo XML. "
    },
    { TidyJoinClasses,                               0,        
        "Esta opção especifica se o Tidy deve combinar os nomes das classes para "
        "gerar um nome de classe único e novo se várias atribuições de classe forem "
        "detectadas em um elemento. "
    },
    { TidyJoinStyles,                                0,        
        "Esta opção especifica se o Tidy deve combinar os estilos para gerar um "
        "estilo único e novo se vários valores de estilo forem detectados em um "
        "elemento. "
    },
    { TidyKeepFileTimes,                             0,        
        "Esta opção especifica se o Tidy deve manter o tempo de modificação original "
        "dos arquivos que o Tidy modifica no local. <br/>Configurar a opção para "
        "<var>yes</var> permite arrumar arquivos sem alterar a data de modificação do "
        "arquivo, o que pode ser útil com determinadas ferramentas que usam a data de "
        "modificação para coisas como a implantação automática do servidor. <br/>Note "
        "que não há suporte a este recurso em algumas plataformas. "
    },
    { TidyLiteralAttribs,                            0,        
        "Esta opção especifica como o Tidy lida com caracteres de espaço em branco "
        "dentro de valores de atributos. <br/>Se o valor for <var>no</var>, Tidy "
        "normaliza os valores dos atributos substituindo qualquer nova linha ou "
        "tabulação por um único espaço, além de substituir qualquer espaço contíguo "
        "em espaço único. <br/>Para forçar o Tidy a preservar os valores literais "
        "originais de todos os atributos e garantir que os espaços em branco dentro "
        "dos valores de atributo sejam passados inalterados através, defina esta "
        "opção como <var>yes</var>. "
    },
    { TidyLogicalEmphasis,                           0,        
        "Esta opção especifica se o Tidy deve substitui qualquer ocorrência de "
        "<code>&lt;i&gt;</code> com <code>&lt;em&gt;</code> e qualquer ocorrência de "
        "<code>&lt;b&gt;</code> com <code>&lt;strong&gt;</code>. Quaisquer atributos "
        "são preservados inalterados. <br/>Esta opção pode ser definida "
        "independentemente da opção <code>clean</code>. "
    },
    { TidyLowerLiterals,                             0,        
        "Esta opção especifica se o Tidy deve converter o valor de um atributo que "
        "leva uma lista de valores predefinidos para minúsculas. <br/>Isto é "
        "necessário para documentos XHTML. "
    },
    { TidyMakeBare,                                  0,        
        "Esta opção especifica se o Tidy deve retirar o HTML específico da Microsoft "
        "de documentos do Word 2000 e exibir espaços em vez de espaços rígidos (nbsp) "
        "nos quais eles existam na entrada. "
    },
    { TidyMakeClean,                                 0,        
        "Esta opção especifica se o Tidy deve executar a limpeza de algumas tags de "
        "apresentação legadas (atualmente <code>&lt;i&gt;</code>, "
        "<code>&lt;b&gt;</code>, <code>&lt;center&gt;</code> quando incluídas nas "
        "tags em-linha apropriadas e <code>&lt;font&gt;</code>). Se configurado para "
        "<var>yes</var>, as tags legadas serão substituídas por tags CSS "
        "<code>&lt;style&gt;</code> e marcação estrutural conforme apropriado. "
    },
    { TidyMark,                                      0,        
        "Esta opção especifica se o Tidy deve adicionar um elemento <code>meta</code> "
        "ao cabeçalho do documento para indicar que o documento foi arrumado. <br/>"
        "Tidy não adicionará um elemento meta se um já estiver presente. "
    },
    { TidyMergeDivs,                                 0,        
        "Esta opção pode ser usada para modificar o comportamento de "
        "<code>clean</code> quando configurado para <var>yes</var>. <br/>Esta opção "
        "especifica se o Tidy deve mesclar <code>&lt;div&gt;</code> aninhados, como "
        "<code>&lt;div&gt;&lt;div&gt;...&lt;/div&gt;&lt;/div&gt;</code>. <br/>Se "
        "configurado para <var>auto</var>, os atributos do <code>&lt;div&gt;</code> "
        "internos são movidos para o externo. <code>&lt;div&gt;</code> aninhados com "
        "os atributos <code>id</code> <em>não</em> são mesclados. <br/>Se configurado "
        "para <var>yes</var>, os atributos de <code>&lt;div&gt;</code> interno são "
        "descartados com a exceção de <code>class</code> e <code>style</code>. "
    },
    { TidyMergeEmphasis,                             0,        
        "Esta opção especifica se o Tidy deve mesclar elementos <code>&lt;b&gt;</code>"
        " e <code>&lt;i&gt;</code> aninhados; por exemplo, para o caso de "
        "<br/><code>&lt;b class=\"rtop-2\"&gt;foo &lt;b class=\"r2-2\""
        "&gt;bar&lt;/b&gt; baz&lt;/b&gt;</code>, <br/>Tidy vai emitir <code>&lt;b "
        "class=\"rtop-2\"&gt;foo bar baz&lt;/b&gt;</code>. "
    },
    { TidyMergeSpans,                                0,        
        "Esta opção pode ser usada para modificar o comportamento de "
        "<code>clean</code> quando configurado para <var>yes</var>. <br/>Esta opção "
        "especifica se o Tidy deve mesclar <code>&lt;span&gt;</code> aninhados como "
        "<code>&lt;span&gt;&lt;span&gt;...&lt;/span&gt;&lt;/span&gt;</code>. <br/>O "
        "algoritmo é idêntico àquele usado por <code>merge-divs</code>. "
    },
    { TidyNCR,                                       0,        
        "Esta opção especifica se o Tidy deve permitir referências de caracteres "
        "numéricos. "
    },
    { TidyNewline,                                   0,        
        "O padrão é apropriado para a plataforma atual. <br/>Geralmente, CRLF no PC-"
        "DOS, Windows e OS/2; '\r' no Mac OS Clássico; e '\n' nos demais (Linux, Mac OS X "
        "e Unix). "
    },
    { TidyNumEntities,                               0,        
        "Esta opção especifica se o Tidy deve produzir entidades diferentes das "
        "entidades HTML integradas (<code>&amp;amp;</code>, <code>&amp;lt;</code>, "
        "<code>&amp;gt;</code> e <code>&amp;quot;</code>) no formulário numérico em "
        "vez do formulário nomeado. <br/>Somente são usadas entidades compatíveis com "
        "a declaração DOCTYPE gerada. <br/>As entidades que podem ser representadas "
        "na codificação de saída são traduzidas correspondentemente. "
    },
    { TidyOmitOptionalTags,                          0,        
        "Esta opção especifica se o Tidy deve omitir tags de início e de fim "
        "opcionais ao gerar saída. <br/>Configurar essa opção causa todas as tags "
        "para os elementos <code>&lt;html&gt;</code>, <code>&lt;head&gt;</code> e "
        "<code>&lt;body&gt;</code> serem omitidos da saída, assim como tags de saída "
        "como <code>&lt;/p&gt;</code>, <code>&lt;/li&gt;</code>, "
        "<code>&lt;/dt&gt;</code>, <code>&lt;/dd&gt;</code>, "
        "<code>&lt;/option&gt;</code>, <code>&lt;/tr&gt;</code>, "
        "<code>&lt;/td&gt;</code> e <code>&lt;/th&gt;</code>. <br/>Essa opção é "
        "ignorada para saída XML. "
    },
    { TidyOutCharEncoding,                           0,        
        "Esta opção especifica a codificação de caracteres que o Tidy usa para a saída. <br/>Note que "
        "isso só pode ser diferente de <code>input-encoding</code> para codificações latinas "
        "(<var>ascii</var>, <var>latin0</var>, <var>latin1</var>, <var>mac</var>, <var>win1252</var>, "
        "<var>ibm858</var>). <br/>Veja <code>char-encoding</code> para mais informações"
    },
    { TidyOutFile,                                   0,        
        "Essa opção especifica o arquivo de saída que o Tidy usa para marcação. "
        "Normalmente, a marcação é escrita para <code>stdout</code>. "
    },
    { TidyOutputBOM,                                 0,        
        "Esta opção especifica se o Tidy deve escrever um caractere Unicode de marca "
        "de ordem de byte (BOM, também conhecido como Zero Width No Break Break, tem "
        "valor de U+FEFF) no início da saída, e aplica-se apenas a codificações de "
        "saída UTF-8 e UTF-16. <br/>Se configurado para <var>auto</var>, esta opção "
        "faz com que Tidy escreva um BOM para a saída somente se um BOM estiver "
        "presente no início da entrada. <br/>Um BOM está sempre escrita para saída "
        "XML/XHTML usando codificações de saída UTF-16. "
    },
    { TidyPPrintTabs,                                0,        
        "Esta opção especifica se o Tidy deve aplicar recuo com tabulações em vez de "
        "espaços, presumindo que <code>indent</code> seja <var>yes</var>. <br/>Defina-"
        "o para <var>yes</var> para recuar usando tabulações em vez dos espaços "
        "padrão. <br/>Use a opção <code>indent-spaces</code> para controlar o número "
        "de saídas de tabulação por nível de recuo. Note que quando <code>indent-with-"
        "tabs</code> está habilitado, o valor padrão de <code>indent-spaces</code> é "
        "reiniciado para <var>1</var>. <br/>Note que <code>tab-size</code> controla a "
        "conversão de tabulações de entrada em espaços. Coloque-o em zero para reter "
        "as tabulações de entrada. "
    },
    { TidyPreserveEntities,                          0,        
        "Esta opção especifica se o Tidy deve preservar entidades bem-formadas como "
        "localizado na entrada. "
    },
    { TidyPreTags,                                   0,        
        "Esta opção especifica novas tags que devem ser processadas exatamente da "
        "mesma forma que o elemento <code>&lt;pre&gt;</code> de HTML. Esta opção "
        "possui uma lista separada por vírgulas ou espaços de nomes de tag. <br/>A "
        "menos que você declare novas tags, o Tidy se recusará a gerar um arquivo "
        "arrumado se a entrada incluir tags anteriormente desconhecidas. <br/>Note "
        "que você ainda não pode adicionar novos elementos CDATA. <br/>Esta opção é "
        "ignorada no modo XML. "
    },
    { TidyPunctWrap,                                 0,        
        "Essa opção especifica se o Tidy deve quebrar linha após alguns Unicode ou "
        "caracteres de pontuação chineses. "
    },
    { TidyQuiet,                                     0,        
        "Essa opção especifica se o Tidy deve emitir o resumo dos números de erros e "
        "avisos, ou as mensagens de boas-vidas ou informacionais. "
    },
    { TidyQuoteAmpersand,                            0,        
        "Essa opção especifica se o Tidy deve emitir caracteres <code>&amp;</code> "
        "sem adornos como <code>&amp;amp;</code>. "
    },
    { TidyQuoteMarks,                                0,        
        "Esta opção especifica se o Tidy deve enviar caracteres <code>&quot;</code> "
        "como <code>&quot;</code> como é preferido por alguns ambientes de edição. "
        "<br/>O caractere do apóstrofe <code>'</code> é escrito como "
        "<code>&amp;#39;</code> porque muitos navegadores web ainda não oferecem "
        "suporte a <code>&amp;apos;</code>. "
    },
    { TidyQuoteNbsp,                                 0,        
        "Esta opção especifica se o Tidy deve produzir caracteres de espaço rígido "
        "como entidades, em vez de como o caractere Unicode de valor 160 (decimal). "
    },
    { TidyReplaceColor,                              0,        
        "Esta opção especifica se o Tidy deve substituir os valores numéricos nos atributos de cor com "
        "nomes de cor HTML/XHTML onde definido, p.ex. substituir <code>#ffffff</code> com <code>white</"
        "code>. "
    },
    { TidyShowErrors,                                0,        
        "Esta opção especifica o número que o Tidy usa para determinar se outros "
        "erros devem ser exibidos. Se configurado para <var>0</var>, nenhum erro será "
        "mostrado. "
    },
    { TidyShowInfo,                                  0,        
        "Esta opção especifica se o Tidy deve exibir mensagens de nível "
        "informacional. "
    },
    { TidyShowMarkup,                                0,        
        "Esta opção especifica se o Tidy deve gerar uma versão de impressão amigável "
        "da marcação. Note que o Tidy não gerará uma versão de impressão amigável se "
        "encontrar erros significativos (veja <code>force-output</code>). "
    },
    { TidyShowWarnings,                              0,        
        "Esta opção especifica se o Tidy deve suprimir avisos. Isso pode ser útil "
        "quando alguns erros estão ocultos em uma agitação de avisos. "
    },
    { TidySkipNested,                                0,        
        "Esta opção especifica que o Tidy deve pular tags aninhadas ao analisar "
        "script e dados de estilo. "
    },
    { TidySortAttributes,                            0,        
        "Esta opção especifica que o Tidy deve ordenar atributos dentro de um "
        "elemento usando o algoritmo de ordenação especificado. Se configurado para "
        "<var>alpha</var>, o algoritmo é uma ordenação alfabética ascendente. "
    },
    { TidyStrictTagsAttr,                            0,        
        "Esta opção garante que tags e atributos sejam aplicáveis à versão do HTML "
        "que o Tidy emite. Quando definido para <var>yes</var> e o tipo de documento "
        "de saída é um doctype estrito, então o Tidy informará os erros. Se o tipo de "
        "documento de saída for um tipo de documento loose ou transicional, o Tidy "
        "informará os avisos. <br/>Além disso, se <code>drop-proprietary-"
        "attributes</code> estiver habilitado, os atributos não aplicáveis também "
        "serão descartados. <br/>Quando configurado para <var>no</var>, essas "
        "verificações não são executadas. "
    },
    { TidyTabSize,                                   0,        
        "Esta opção especifica o número de colunas que o Tidy usa entre paradas de "
        "tabulação sucessivas. Ela é usada para mapear tabulações para espaços ao ler "
        "a entrada. "
    },
    { TidyUpperCaseAttrs,                            0,        
        "Esta opção especifica se o Tidy deve produzir nomes de atributo em "
        "maiúsculo. <br/>Quando configurado para <var>no</var>, os nomes dos "
        "atributos serão escritos em minúsculas. Especificar <var>yes</var> exibirá "
        "nomes de atributos em maiúsculas e <var>preserve</var> pode ser usado para "
        "deixar nomes de atributos intactos. <br/>Ao usar a entrada XML, o "
        "maiusculização original é sempre preservada. "
    },
    { TidyUpperCaseTags,                             0,        
        "Esta opção especifica se o Tidy deve emitir nomes de tags em maiúsculo. <br/>"
        "O padrão é <var>no</var>, o que resulta em nomes de tags minúsculos, exceto "
        "para entrada XML na qual a maiusculização original é preservada. "
    },
    { TidyUseCustomTags,                             0,        
        "Esta opção permite o uso de tags para elementos personalizados autônomos, "
        "p.ex. &lt;flag-icon&gt; com Tidy. As tags personalizadas são desativadas se "
        "esse valor for <var>no</var>. Outras configurações - <var>blocklevel</var>, "
        "<var>empty</var>, <var>inline</var> e <var>pre</var> tratarão <em>todas</em> "
        "as tags personalizadas detectadas em conformidade. <br/>O uso de <code>new-"
        "blocklevel-tags</code>, <code>new-empty-tags</code>, <code>new-inline-"
        "tags</code> ou <code>new-pre-tags</code> substituirá o tratamento de tags "
        "personalizadas por esta opção de configuração. Isso pode ser útil se você "
        "tiver diferentes tipos de tags personalizadas. <br/>Quando habilitado, essas "
        "tags são determinadas durante o processamento do documento usando tags de "
        "abertura; As tags de fechamento de correspondência serão reconhecidas de "
        "acordo, e as tags de fechamento desconhecidas serão descartadas. "
    },
    { TidyVertSpace,                                 0,        
        "Esta opção especifica se o Tidy deve adicionar algumas linhas vazias extras para legibilidade. "
        "<br/>O padrão é <var>no</var>. <br/>Se configurado para <var>auto</var>, Tidy vai eliminar "
        "quase todos os caracteres de nova linha."
    },
    { TidyWarnPropAttrs,                             0, "Essa opção especifica se o Tidy deve avisar sobre atributos proprietários."                      },
    { TidyWord2000,                                  0,        
        "Esta opção especifica se o Tidy deve se esforçar duro para tirar todas as "
        "coisas excedentes que o Microsoft Word 2000 insere quando você salva os "
        "documentos do Word como \"páginas web\". Não manipula imagens embutidas ou "
        "VML. <br/>Você deve considerar usar o Word \"Salvar Como: Página da Web, "
        "Filtrada\". "
    },
    { TidyWrapAsp,                                   0,        
        "Essa opção especifica se o Tidy deve quebrar linha de textos contidos em "
        "pseudoelementos do ASP, que se parecem com: <code>&lt;% ... %&gt;</code>. "
    },
    { TidyWrapAttVals,                               0,        
        "Esta opção especifica se Tidy deve incluir valores de atributos de linha, o "
        "que significa que, se o valor de um atributo faz com que uma linha exceda a "
        "largura especificada por <code>wrap</code>, Tidy irá adicionar uma ou mais "
        "quebras de linha ao valor, fazendo com que ele seja embrulhado em várias "
        "linhas. <br/>Note que esta opção pode ser definida independentemente de <code"
        ">wrap-script-literals</code>. Por padrão, o Tidy substitui qualquer nova "
        "linha ou tabulação com um único espaço e substitui qualquer sequência de "
        "espaços em branco com um único espaço. <br/>Para forçar a Tidy a preservar "
        "os valores literais originais de todos os atributos e garantir que os "
        "caracteres de espaço em branco nos valores de atributos sejam passados "
        "através de alterações, configure <code>literal-attributes</code> para "
        "<var>yes</var>. "
    },
    { TidyWrapJste,                                  0,        
        "Essa opção especifica se o Tidy deve quebrar linha de textos contidos em "
        "pseudoelementos do JSTE, que se parecem com: <code>&lt;# ... #&gt;</code>. "
    },
    { TidyWrapLen,                                   0,        
        "Esta opção especifica a margem direita que o Tidy usa para quebra de linha. "
        "<br/>Tidy tenta quebrar linhas para que não excedam esse comprimento. <br/>"
        "Defina <code>wrap</code> para <var>0</var> (zero) se desejar desativar a "
        "quebra de linha. "
    },
    { TidyWrapPhp,                                   0,        
        "Essa opção especifica se o Tidy deve quebrar linha de textos contidos em "
        "pseudoelementos do PHP, que se parecem com: <code>&lt;?php ... ?&gt;</code>. "
    },
    { TidyWrapScriptlets,                            0,        
        "Esta opção especifica se Tidy deve efetuar quebra de linha em string "
        "literais que aparecem em atributos de script. <br/>Tidy efetua essa quebra "
        "em string literais de scripts longos inserindo um caractere de barra "
        "invertida antes da quebra de linha. "
    },
    { TidyWrapSection,                               0,        
        "Essa opção especifica se o Tidy deve efetuar quebra de linha de textos "
        "contidos em tags de seção <code>&lt;![ ... ]&gt;</code>. "
    },
    { TidyWriteBack,                                 0,        
        "Esta opção especifica se o Tidy deve escrever novamente a marcação arrumada "
        "para o mesmo arquivo que lê. <br/> É aconselhável manter cópias de arquivos "
        "importantes antes de ordená-los, como em ocasiões raras, o resultado pode "
        "não ser o que você espera. "
    },
    { TidyXhtmlOut,                                  0,        
        "Esta opção especifica se o Tidy deve gerar uma impressão amigável, "
        "escrevendo como HTML extensível. <br/>Esta opção faz com que o Tidy "
        "configure o DOCTYPE e o espaço de nomes padrão conforme apropriado para "
        "XHTML e use o valor corrigido no resultado, independentemente de outras "
        "fontes. <br/> Para XHTML, as entidades podem ser escritas como entidades "
        "nomeadas ou numéricas de acordo com a configuração de <code>numeric-"
        "entities</code>. <br/>A maiusculização original de tags e atributos será "
        "preservada, independentemente de outras opções. "
    },
    { TidyXmlDecl,                                   0,        
        "Esta opção especifica se o Tidy deve adicionar a declaração XML ao enviar "
        "XML ou XHTML. <br/>Note que, se a entrada já incluir uma declaração "
        "<code>&lt;?xml ... ?&gt;</code>, esta opção será ignorada. <br/>Se a "
        "codificação para a saída for diferente de <var>ascii</var>, uma das "
        "codificações <var>utf*</var> ou de <var>raw</var>, então a declaração é "
        "sempre adicionado conforme exigido pelo padrão XML. "
    },
    { TidyXmlOut,                                    0,        
        "Esta opção especifica se o Tidy deve emitir impressão amigável, escrevendo-o "
        "como XML bem formado. <br/>Todas as entidades não definidas no XML 1.0 serão "
        "escritas como entidades numéricas para permitir que elas sejam analisadas "
        "por um analisador XML. <br/>A maiusculização original de tags e atributos "
        "será preservada, independentemente de outras opções. "
    },
    { TidyXmlPIs,                                    0,        
        "Esta opção especifica se o Tidy deve alterar a análise das instruções de "
        "processamento para exigir <code>?&gt;</code> como o terminador, em vez de "
        "<code>&gt;</code>. <br/>Esta opção é configurada automaticamente se a "
        "entrada for um XML. "
    },
    { TidyXmlSpace,                                  0,        
        "Esta opção especifica se o Tidy deve adicionar <code>xml:space=\"preserve\"</code> para "
        "elementos tais como <code>&lt;pre&gt;</code>, <code>&lt;style&gt;</code> e <code>&lt;script&gt;"
        "</code> ao gerar o XML. <br/>Isso é necessário se o espaço em branco em tais elementos deve ser "
        "analisado apropriadamente sem ter acesso ao DTD. "
    },
    { TidyXmlTags,                                   0,        
        "Esta opção especifica se o Tidy deve usar o analisador XML em vez do "
        "analisador HTML de correção de erro. "
    },
    { TidyMetaCharset,                               0,        
        "Esta opção, quando ativada, adiciona um elemento <code>&lt;meta&gt;</code> e "
        "define o atributo <code>charset</code> para a codificação do documento. "
        "Configure esta opção para <var>yes</var> para habilitá-lo. "
    },
    { TidyShowMetaChange,                            0,        
        "Esta opção habilita uma mensagem sempre que o Tidy alterar o atributo "
        "<code>content</code> de uma declaração de meta conjunto de caracteres para "
        "coincidir com a codificação do documento. Defina esta opção para "
        "<var>yes</var> para habilitá-lo. "
    },
    { TidyStyleTags,                                 0,        
        "Esta opção especifica se o Tidy deve mover todas as tags de estilo para o "
        "cabeçalho do documento. "
    },
    { TidyWarning,                                   0, "Acesso: "                                                                                        },
    { TidyAccess,                                    0, "Acesso: "                                                                                        },
    { TidyError,                                     0, "Erro: "                                                                                          },
    { TidyBadDocument,                               0, "Documento: "                                                                                     },
    { TidyFatal,                                     0, "Pânico: "                                                                                        },
    { TidyDialogueSummary,                           0, "Resumo: "                                                                                        },
    { TidyDialogueInfo,                              0, "Informação: "                                                                                    },
    { TidyDialogueFootnote,                          0, "Nota de rodapé: "                                                                                },
    { LINE_COLUMN_STRING,                            0, "linha %d coluna %d - "                                                                           },
    { STRING_DISCARDING,                             0, "descartando"                                                                                     },
    { STRING_ERROR_COUNT_ERROR,                      0, "erro"                                                                                            },
    { STRING_ERROR_COUNT_ERROR,                      1, "erros"                                                                                           },
    { STRING_ERROR_COUNT_WARNING,                    0, "aviso"                                                                                           },
    { STRING_ERROR_COUNT_WARNING,                    1, "avisos"                                                                                          },
    { STRING_HELLO_ACCESS,                           0,        
        "\n"
        "Verificações de acessibilidade:\n"
    },
    { STRING_HTML_PROPRIETARY,                       0, "Proprietário HTML"                                                                               },
    { STRING_XML_DECLARATION,                        0, "declaração XML"                                                                                  },
    { STRING_PLAIN_TEXT,                             0, "texto simples"                                                                                   },
    { STRING_REPLACING,                              0, "substituindo"                                                                                    },
    { STRING_SPECIFIED,                              0, "especificada"                                                                                    },
    { TIDYCUSTOMNO_STRING,                           0, "não"                                                                                             },
    { TIDYCUSTOMBLOCKLEVEL_STRING,                   0, "nível de bloco"                                                                                  },
    { TIDYCUSTOMEMPTY_STRING,                        0, "vazio"                                                                                           },
    { TIDYCUSTOMINLINE_STRING,                       0, "em-linha"                                                                                        },
    { TIDYCUSTOMPRE_STRING,                          0, "pré"                                                                                             },
    { TEXT_HTML_T_ALGORITHM,                         0,        
        "\n"
        "      - Primeiro, pesquisa à esquerda da posição da célula para\n"
        "        localizar células de cabeçalho de linha.\n"
        "      - Então, pesquisa para cima para localizar células de cabeçalho\n"
        "        de coluna.\n"
        "      - A pesquisa em uma direção dada interrompe quando a borda da\n"
        "        tabela é atingida ou quando uma célula de dados é localizada\n"
        "        após uma célula de cabeçalho.\n"
        "      - Cabeçalhos de linha são inseridas em uma linha na ordem que\n"
        "        elas aparecem na tabela.\n"
        "      - Para tabelas esquerda-para-direita, cabeçalhos são inseridas\n"
        "        da esquerda para direita.\n"
        "      - Cabeçalhos de coluna são inseridas após cabeçalhos de linha,\n"
        "        na ordem que elas aparecem na tabela, de cima para baixo.\n"
        "      - Se uma célula de cabeçalho tem atributo de cabeçalhos configurado,\n"
        "        então os cabeçalhos referenciados por este atributo são inseridos\n"
        "        na lisa e a pesquisa interrompe para a direção atual.\n"
        "        células TD que configuram o atributo de eixo também são tratadas\n"
        "        com células de cabeçalho.\n"
    },
    { TEXT_VENDOR_CHARS,                             0,        
        "É improvável que as codificações dependentes do sistema específicas\n"
        "do fornecedor funcionem amplamente na World Wide Web; você deve\n"
        "evitar o uso da codificação de caracteres %s; em vez disso,\n"
        "recomenda-se que você use entidades nomeadas, p.ex. &trade;.\n"
    },
    { TEXT_SGML_CHARS,                               0,        
        "Os códigos de caracteres 128 a 159 (U+0080 a U+009F)\n"
        "não são aceitos no HTML; mesmo se eles fossem, eles\n"
        "provavelmente seriam caracteres de controle não imprimíveis.\n"
        "Tidy presumiu que você queria se referir a um caractere\n"
        "com o mesmo valor de bytes na codificação %s e substituiu\n"
        "aquela referência com o equivalente Unicode.\n"
    },
    { TEXT_INVALID_UTF8,                             0,        
        "Os códigos de caracteres para UTF-8 devem estar dentro\n"
        "do intervalo: U+0000 a U+10FFFF. A definição de UTF-8\n"
        "no Anexo D do ISO/IEC 10646-1:2000 também permite para\n"
        "o uso de sequências de cinco e seis bytes para codificar\n"
        "caracteres que estão fora do intervalo do conjunto de\n"
        "caracteres do Unicode; aquelas sequências de cinco e\n"
        "seis bytes são ilegais para o uso de UTF-8 como uma\n"
        "transformação de caracteres Unicode. ISO/IEC 10646 não\n"
        "permite mapeamento de substitutos não pareados, nem\n"
        "U+FFFE e U+FFFF (mas permite outros não caracteres).\n"
        "Para mais informações, veja http://www.unicode.org/ e\n"
        "http://www.cl.cam.ac.uk/~mgk25/unicode.html\n"
    },
    { TEXT_INVALID_UTF16,                            0,        
        "Os códigos de caracteres para UTF-16 devem estar dentro\n"
        "do intervalo: U+0000 a U+10FFFF. A definição de UTF-16\n"
        "no Anexo C da ISO/IEC 10646-1:2000 não permite o mapeamento\n"
        "de substitutos não pareados. Para mais informações,\n"
        "por favor veja http://www.unicode.org/ e\n"
        "http://www.cl.cam.ac.uk/~mgk25/unicode.html\n"
    },
    { TEXT_INVALID_URI,                              0,        
        "URIs devem ser devidamente escapadas, elas não devem\n"
        "conter caracteres não elaborados abaixo de U+0021,\n"
        "incluindo o caractere de espaço e não acima de U+007E.\n"
        "Tidy escapa a URI para você conforme recomendado pelo\n"
        "HTML 4.01 seção B.2.1 e XML 1.0 seção 4.2.2. Alguns\n"
        "agentes de usuários usam outro algoritmo para escapar\n"
        "tais URIs e alguns scripts de servidor dependem disso.\n"
        "Se você quiser depender disso, você deve escapar a URI\n"
        "por conta própria. Para mais informações, consulte\n"
        "http://www.w3.org/International/O-URL-and-ident.html\n"
    },
    { TEXT_BAD_FORM,                                 0,        
        "Talvez seja necessário mover uma ou ambas as tags <form>\n"
        "e </form>. Os elementos HTML devem estar adequadamente\n"
        "aninhados e os elementos de formulário não são uma exceção.\n"
        "Por exemplo, você não deve colocar o <form> em uma célula\n"
        "de tabela e </form> em outra. Se o <form> for colocado\n"
        "antes de uma tabela, o </form> não pode ser colocado dentro\n"
        "da tabela! Note que um formulário não pode ser aninhado\n"
        "dentro de outro!\n"
    },
    { TEXT_BAD_MAIN,                                 0,        
        "Apenas um elemento <main> é permitido em um documento.\n"
        "Elementos <main> subsequentes foram descartados, o que\n"
        "pode tornar o documento inválido.\n"
    },
    { TEXT_M_SUMMARY,                                0,        
        "O atributo de resumo da tabela deve ser usado para\n"
        "descrever a estrutura da tabela. É muito útil para\n"
        "pessoas que usam navegadores não visuais. Os atributos\n"
        "de escopo e cabeçalho para células de tabela são\n"
        "úteis para especificar quais cabeçalhos se aplicam\n"
        "a cada célula de tabela, permitindo que navegadores\n"
        "não visuais forneçam um contexto significativo para\n"
        "cada célula.\n"
    },
    { TEXT_M_IMAGE_ALT,                              0,        
        "O atributo alt deve ser usado para dar uma breve descrição\n"
        "de uma imagem; descrições mais longas devem ser fornecidas\n"
        "com o atributo longdesc que leva uma URL vinculada à\n"
        "descrição. Essas medidas são necessárias para pessoas que\n"
        "usam navegadores não-gráficos.\n"
    },
    { TEXT_M_IMAGE_MAP,                              0,        
        "Use os mapas de imagens do lado do cliente de preferência\n"
        "aos mapas de imagens do lado do servidor, pois estes são\n"
        "inacessíveis para pessoas que usam navegadores não gráficos.\n"
        "Além disso, os mapas do lado do cliente são mais fáceis\n"
        "de configurar e fornecer feedback imediato aos usuários.\n"
    },
    { TEXT_M_LINK_ALT,                               0,        
        "Para links de hipertexto definidos usando um mapa de imagem\n"
        "do lado do cliente, você precisa usar o atributo alt para\n"
        "fornecer uma descrição textual do link para pessoas que usam\n"
        "navegadores não gráficos.\n"
    },
    { TEXT_USING_FRAMES,                             0,        
        "Páginas desenhadas usando quadros apresentam problemas\n"
        "para pessoas que são cegas ou que usam um navegador que\n"
        "não oferece suporte a quadros. Uma página baseada em\n"
        "quadros deve sempre incluir um layout alternativo dentro\n"
        "de um elemento NOFRAMES.\n"
    },
    { TEXT_ACCESS_ADVICE1,                           0,        
        "Para mais conselhos sobre como tornar suas páginas\n"
        "acessíveis, veja http://www.w3.org/WAI/GL."
    },
    { TEXT_ACCESS_ADVICE2,                           0,        
        "Para mais conselhos sobre como tornar suas páginas\n"
        "acessíveis, veja http://www.w3.org/WAI/GL e\n"
        "http://www.html-tidy.org/accessibility/."
    },
    { TEXT_USING_LAYER,                              0,        
        "O mecanismo de posicionamento do Cascading Style\n"
        "Sheets (CSS) é recomendado em preferência ao\n"
        "elemento proprietário <LAYER> devido ao suporte\n"
        "de fornecedor limitado a LAYER.\n"
    },
    { TEXT_USING_SPACER,                             0,        
        "É recomendável usar CSS para controlar o espaço em\n"
        "branco (p.ex., para recuo, margens e espaçamento\n"
        "entre linhas). O elemento proprietário <SPACER>\n"
        "possui suporte limitado para fornecedores.\n"
    },
    { TEXT_USING_FONT,                               0,        
        "É recomendável usar o CSS para especificar a fonte e\n"
        "as propriedades, como seu tamanho e cor. Isso reduzirá\n"
        "o tamanho dos arquivos HTML e facilitando a manutenção\n"
        "em comparação com o uso de elementos <FONT>.\n"
    },
    { TEXT_USING_NOBR,                               0,        
        "É recomendável usar CSS para controlar a quebra de linha.\n"
        "Use \"white-space: nowrap\" para inibir a quebra em vez\n"
        "de inserir <NOBR>...</NOBR> na marcação.\n"
    },
    { TEXT_USING_BODY,                               0, "É recomendável usar CSS para especificar cores de página e link"                                 },
    { STRING_CONTENT_LOOKS,                          0, "O conteúdo do documento se parece com %s"                                                        },
    { STRING_DOCTYPE_GIVEN,                          0, "Doctype dado é \"%s\""                                                                           },
    { STRING_ERROR_COUNT,                            0, "Tidy encontrou %u %s e %u %s!\n"                                                                 },
    { STRING_NEEDS_INTERVENTION,                     0,        
        "Esse documento possui erros que devem ser corrigidos\n"
        "antes de usar HTML Tidy para gerar uma versão arrumada.\n"
    },
    { STRING_NO_ERRORS,                              0, "Nenhum aviso ou erro foi localizado.\n"                                                          },
    { STRING_NO_SYSID,                               0, "Nenhum identificado de sistema no doctype emitido"                                               },
    { STRING_NOT_ALL_SHOWN,                          0, "Tidy encontrou %u %s e %u %s! Nem todos avisos/erros foram mostrados.\n"                         },
    { TEXT_GENERAL_INFO,                             0,        
        "Sobre o HTML Tidy: https://github.com/htacg/tidy-html5\n"
        "Relatórios de erro e comentários: https://github.com/htacg/tidy-html5/"
        "issues\n"
        "Lista de discussão: https://lists.w3.org/Archives/Public/public-htacg/\n"
        "Especificação HTML mais recente: http://dev.w3.org/html5/spec-author-view/\n"
        "Valide seus documentos HTML: http://validator.w3.org/nu/\n"
        "Incentive sua empresa a se juntar à W3C: http://www.w3.org/Consortium\n"
    },
    { TEXT_GENERAL_INFO_PLEA,                        0,        
        "Você fala um idioma diferente do português brasileiro, ou uma variante \n"
        "diferente do português? Considere em ajudar a traduzir o HTML Tidy. \n"
        "Para mais detalhes, por favor veja: \n"
        "https://github.com/htacg/tidy-html5/blob/master/README/LOCALIZE.md"
    },
    { ADDED_MISSING_CHARSET,                         0, "Adicionado o <meta charset=...> apropriado em falta ao %s"                                       },
    { ANCHOR_NOT_UNIQUE,                             0, "âncora de %s \"%s\" já está definido"                                                            },
    { APOS_UNDEFINED,                                0, "a entidade declarada &apos; só definida em XML/XHTML"                                            },
    { ATTR_VALUE_NOT_LCASE,                          0, "valor do atributo de %s \"%s\" deve ser minúsculo para XHTML"                                    },
    { ATTRIBUTE_IS_NOT_ALLOWED,                      0, "atributo de %s \"is\" não permitido para tags personalizadas autônomas."                         },
    { ATTRIBUTE_VALUE_REPLACED,                      0, "atributo %s \"%s\", valor incorreto \"%s\" substituído"                                          },
    { BACKSLASH_IN_URI,                              0, "referência da URI %s contém barra invertida. Erro de escrita?"                                   },
    { BAD_ATTRIBUTE_VALUE_REPLACED,                  0, "atributo %s \"%s\" tinha valor inválido \"%s\" e foi substituído"                                },
    { BAD_ATTRIBUTE_VALUE,                           0, "atributo %s \"%s\" possui valor inválido \"%s\""                                                 },
    { BAD_CDATA_CONTENT,                             0, "'<' + '/' + letra não permitido aqui"                                                            },
    { BAD_SUMMARY_HTML5,                             0, "O atributo de resumo no elemento %s é obsoleto no HTML5"                                         },
    { BAD_SURROGATE_LEAD,                            0,        
        "Par substituto ao final (baixo) U+%04X, com nenhuma entidade precedente "
        "(Alta), substituído por U+FFFD."
    },
    { BAD_SURROGATE_PAIR,                            0,        
        "Possui par substituto U+%04X:U+%04X fora do intervalo, substituído pelo "
        "valor U+FFFD."
    },
    { BAD_SURROGATE_TAIL,                            0,        
        "Par substituto precedente (alto) U+%04X, com nenhuma entidade ao final "
        "(Baixo), substituído por U+FFFD."
    },
    { CANT_BE_NESTED,                                0, "%s não pode ser aninhado"                                                                        },
    { COERCE_TO_ENDTAG,                              0, "<%s> provavelmente deveria ser </%s>"                                                            },
    { CONTENT_AFTER_BODY,                            0, "o conteúdo ocorre após o fim do corpo"                                                           },
    { CUSTOM_TAG_DETECTED,                           0, "tag personalizada autônoma %s detectada; será tratada como %s"                                   },
    { DISCARDING_UNEXPECTED,                         0, "descartando %s inesperado"                                                                       },
    { DOCTYPE_AFTER_TAGS,                            0, "<!DOCTYPE> não é permitido após elementos"                                                       },
    { DUPLICATE_FRAMESET,                            0, "elemento FRAMESET repetido"                                                                      },
    { ELEMENT_NOT_EMPTY,                             0, "%s elemento não vazio ou não fechado"                                                            },
    { ELEMENT_VERS_MISMATCH_ERROR,                   0, "%s elemento não disponível na %s"                                                                },
    { ELEMENT_VERS_MISMATCH_WARN,                    0, "%s elemento não disponível na %s"                                                                },
    { ENCODING_MISMATCH,                             0,        
        "a codificação de entrada especificada (%s) não corresponde à codificação de "
        "entrada atual (%s)"
    },
    { ESCAPED_ILLEGAL_URI,                           0, "%s escapando referência de URI malformada"                                                       },
    { FILE_CANT_OPEN,                                0, "Não foi possível abrir \"%s\"\n"                                                                 },
    { FILE_CANT_OPEN_CFG,                            0, "Não foi possível abrir o arquivo de configuração \"%s\"\n"                                       },
    { FILE_NOT_FILE,                                 0, "\"%s\" não é um arquivo!\n"                                                                      },
    { FIXED_BACKSLASH,                               0, "%s convertendo barra invertida em URI para barra"                                                },
    { FOUND_STYLE_IN_BODY,                           0, "encontrada tag <style> em <body>! fix-style-tags: yes para mover."                               },
    { ID_NAME_MISMATCH,                              0, "%s valores dos atributos id e name incompatíveis"                                                },
    { ILLEGAL_NESTING,                               0, "%s não devem ser aninhados"                                                                      },
    { ILLEGAL_URI_CODEPOINT,                         0, "%s caracteres ilegais localizados na URI"                                                        },
    { ILLEGAL_URI_REFERENCE,                         0, "referência de URI %s inadequadamente escapada"                                                   },
    { INSERTING_AUTO_ATTRIBUTE,                      0, "%s inserindo atributo \"%s\" usando valor \"%s\""                                                },
    { INSERTING_TAG,                                 0, "inserindo <%s> implícita"                                                                        },
    { INVALID_ATTRIBUTE,                             0, "nome do atributo de %s \"%s\" (valor=\"%s\") é inválido"                                         },
    { INVALID_NCR,                                   0, "%s referência de caractere numérico %s"                                                          },
    { INVALID_SGML_CHARS,                            0, "%s código de caracteres inválido %s"                                                             },
    { INVALID_UTF8,                                  0, "%s bytes de UTF-8 inválido (código de caracteres %s)"                                            },
    { INVALID_UTF16,                                 0, "%s par de substituto de UTF-16 inválido (código de caracteres %s)"                               },
    { INVALID_XML_ID,                                0, "%s não pôde copiar atributo de nome para id"                                                     },
    { JOINING_ATTRIBUTE,                             0, "%s juntando valores de atributo repetido \"%s\""                                                 },
    { MALFORMED_COMMENT,                             0, "hífenes adjacentes dentro de comentário"                                                         },
    { MALFORMED_DOCTYPE,                             0, "descartando <!DOCTYPE> malformado"                                                               },
    { MISMATCHED_ATTRIBUTE_ERROR,                    0, "atributo de %s \"%s\" não permitido para %s"                                                     },
    { MISMATCHED_ATTRIBUTE_WARN,                     0, "atributo de %s \"%s\" não permitido para %s"                                                     },
    { MISSING_ATTR_VALUE,                            0, "atributo de %s \"%s\" carece de valor"                                                           },
    { MISSING_ATTRIBUTE,                             0, "%s carece de atributo \"%s\""                                                                    },
    { MISSING_DOCTYPE,                               0, "faltando declaração <!DOCTYPE>"                                                                  },
    { MISSING_ENDTAG_BEFORE,                         0, "faltando </%s> antes de %s"                                                                      },
    { MISSING_ENDTAG_FOR,                            0, "faltando </%s>"                                                                                  },
    { MISSING_IMAGEMAP,                              0, "%s deve usar mapa de imagem no lado de cliente"                                                  },
    { MISSING_QUOTEMARK,                             0, "atributo de %s faltando aspas ao final"                                                          },
    { MISSING_SEMICOLON_NCR,                         0, "referência de caractere numérico \"%s\" não termina em ';'"                                      },
    { MISSING_SEMICOLON,                             0, "entidade \"%s\" não termina em ';'"                                                              },
    { MISSING_STARTTAG,                              0, "faltando <%s>"                                                                                   },
    { MISSING_TITLE_ELEMENT,                         0, "inserindo elemento faltante 'title'"                                                             },
    { MOVED_STYLE_TO_HEAD,                           0, "tag <style> movida para <head>! fix-style-tags: no para evitar."                                 },
    { NESTED_EMPHASIS,                               0, "ênfase aninhada %s"                                                                              },
    { NESTED_QUOTATION,                              0, "elementos q aninhados, possível erro de escrita."                                                },
    { NEWLINE_IN_URI,                                0, "%s descartando nova linha na referência de URI"                                                  },
    { NOFRAMES_CONTENT,                              0, "%s não dentre de elemento 'noframes'"                                                            },
    { NON_MATCHING_ENDTAG,                           0, "substituindo %s inesperada por </%s>"                                                            },
    { OBSOLETE_ELEMENT,                              0, "substituindo elemento obsoleto %s por %s"                                                        },
    { PREVIOUS_LOCATION,                             0, "<%s> anteriormente mencionada"                                                                   },
    { PROPRIETARY_ATTR_VALUE,                        0, "atributo proprietário %s com valor \"%s\""                                                       },
    { PROPRIETARY_ATTRIBUTE,                         0, "atributo proprietário %s \"%s\""                                                                 },
    { PROPRIETARY_ELEMENT,                           0, "%s não é aprovado pela W3C"                                                                      },
    { REMOVED_HTML5,                                 0, "elemento %s removido do HTML5"                                                                   },
    { REPEATED_ATTRIBUTE,                            0, "%s descartando valor \"%s\" para atributo repetido \"%s\""                                       },
    { REPLACING_ELEMENT,                             0, "substituindo %s por %s"                                                                          },
    { REPLACING_UNEX_ELEMENT,                        0, "substituindo %s inesperada por %s"                                                               },
    { SPACE_PRECEDING_XMLDECL,                       0, "removendo espaço em branco precedendo a declaração XML"                                          },
    { STRING_MISSING_MALFORMED,                      0, "argumento faltando ou malformado para opção: %s"                                                 },
    { STRING_UNKNOWN_OPTION,                         0, "opção desconhecida: %s"                                                                          },
    { SUSPECTED_MISSING_QUOTE,                       0, "faltando aspas para o valor de atributo"                                                         },
    { TAG_NOT_ALLOWED_IN,                            0, "%s não é permitido em elementos <%s>"                                                            },
    { TOO_MANY_ELEMENTS_IN,                          0, "número excessivo de elementos %s em <%s>"                                                        },
    { TOO_MANY_ELEMENTS,                             0, "número excessivo de elementos %s"                                                                },
    { TRIM_EMPTY_ELEMENT,                            0, "aparando %s vazio"                                                                               },
    { UNESCAPED_AMPERSAND,                           0, "& não escapado que deve ser escrito como &amp;"                                                  },
    { UNEXPECTED_END_OF_FILE_ATTR,                   0, "%s fim de arquivo enquanto analisava atributos"                                                  },
    { UNEXPECTED_END_OF_FILE,                        0, "fim do arquivo %s inesperado"                                                                    },
    { UNEXPECTED_ENDTAG_ERR,                         0, "</%s> inesperada"                                                                                },
    { UNEXPECTED_ENDTAG_IN,                          0, "</%s> inesperada em <%s>"                                                                        },
    { UNEXPECTED_ENDTAG,                             0, "</%s> inesperada"                                                                                },
    { UNEXPECTED_EQUALSIGN,                          0, "%s inesperado '=', esperava nome de atributo"                                                    },
    { UNEXPECTED_GT,                                 0, "%s carece de '>' para o fim da tag"                                                              },
    { UNEXPECTED_QUOTEMARK,                          0, "%s aspas inesperadas ou duplicadas"                                                              },
    { UNKNOWN_ELEMENT_LOOKS_CUSTOM,                  0, "%s não é reconhecido! Você queria habilitar a opção custom-tags?"                                },
    { UNKNOWN_ELEMENT,                               0, "%s não é reconhecido!"                                                                           },
    { UNKNOWN_ENTITY,                                0, "& não escapado ou entidade desconhecida \"%s\""                                                  },
    { USING_BR_INPLACE_OF,                           0, "usando <br> no lugar de %s"                                                                      },
    { VENDOR_SPECIFIC_CHARS,                         0, "%s código de caractere inválido %s"                                                              },
    { WHITE_IN_URI,                                  0, "%s descartando espaço em branco na referência de URI"                                            },
    { XML_DECLARATION_DETECTED,                      0, "Uma declaração XML foi detectada. Você queria usar input-xml?"                                   },
    { XML_ID_SYNTAX,                                 0, "%s ID \"%s\" usa sintaxe de ID de XML"                                                           },
    { IMG_MISSING_ALT,                               0, "[1.1.1.1]: <img> carece de texto 'alt'."                                                         },
    { IMG_ALT_SUSPICIOUS_FILENAME,                   0, "[1.1.1.2]: texto 'alt' suspeito (nome de arquivo)."                                              },
    { IMG_ALT_SUSPICIOUS_FILE_SIZE,                  0, "[1.1.1.3]: texto 'alt' suspeito (tamanho de arquivo)."                                           },
    { IMG_ALT_SUSPICIOUS_PLACEHOLDER,                0, "[1.1.1.4]: texto 'alt' suspeito (espaço reservado)."                                             },
    { IMG_ALT_SUSPICIOUS_TOO_LONG,                   0, "[1.1.1.10]: texto 'alt' suspeito (longo demais)."                                                },
    { IMG_MISSING_LONGDESC_DLINK,                    0, "[1.1.2.1]: <img> carece de 'longdesc' e d-link."                                                 },
    { IMG_MISSING_DLINK,                             0, "[1.1.2.2]: <img> carece de d-link."                                                              },
    { IMG_MISSING_LONGDESC,                          0, "[1.1.2.3]: <img> carece de 'longdesc'."                                                          },
    { IMG_BUTTON_MISSING_ALT,                        0, "[1.1.3.1]: <img> (botão) carece de texto 'alt'."                                                 },
    { APPLET_MISSING_ALT,                            0, "[1.1.4.1]: <applet> carece de conteúdo alternativo."                                             },
    { OBJECT_MISSING_ALT,                            0, "[1.1.5.1]: <object> carece de conteúdo alternativo."                                             },
    { AUDIO_MISSING_TEXT_WAV,                        0, "[1.1.6.1]: áudio carece de transcrição de texto (wav)."                                          },
    { AUDIO_MISSING_TEXT_AU,                         0, "[1.1.6.2]: áudio carece de transcrição de texto (au)."                                           },
    { AUDIO_MISSING_TEXT_AIFF,                       0, "[1.1.6.3]: áudio carece de transcrição de texto (aiff)."                                         },
    { AUDIO_MISSING_TEXT_SND,                        0, "[1.1.6.4]: áudio carece de transcrição de texto (snd)."                                          },
    { AUDIO_MISSING_TEXT_RA,                         0, "[1.1.6.5]: áudio carece de transcrição de texto (ra)."                                           },
    { AUDIO_MISSING_TEXT_RM,                         0, "[1.1.6.6]: áudio carece de transcrição de texto (rm)."                                           },
    { FRAME_MISSING_LONGDESC,                        0, "[1.1.8.1]: <frame> pode exigir 'longdesc'."                                                      },
    { AREA_MISSING_ALT,                              0, "[1.1.9.1]: <area> carece de texto 'alt'."                                                        },
    { SCRIPT_MISSING_NOSCRIPT,                       0, "[1.1.10.1]: <script> carece de seção <noscript>."                                                },
    { ASCII_REQUIRES_DESCRIPTION,                    0, "[1.1.12.1]: arte em ascii exige descrição."                                                      },
    { IMG_MAP_SERVER_REQUIRES_TEXT_LINKS,            0, "[1.2.1.1]: mapa de imagem (lado do servidor) exige links de texto."                              },
    { MULTIMEDIA_REQUIRES_TEXT,                      0, "[1.4.1.1]: multimídia exibe equivalentes de texto sincronizado."                                 },
    { IMG_MAP_CLIENT_MISSING_TEXT_LINKS,             0, "[1.5.1.1]: mapa da imagem (lado do cliente) carece de links de texto."                           },
    { INFORMATION_NOT_CONVEYED_IMAGE,                0, "[2.1.1.1]: certificar de que as informações não sejam transmitidas apenas por cores (imagem)."   },
    { INFORMATION_NOT_CONVEYED_APPLET,               0, "[2.1.1.2]: certificar de que as informações não sejam transmitidas apenas por cores (applet)."   },
    { INFORMATION_NOT_CONVEYED_OBJECT,               0, "[2.1.1.3]: certificar de que as informações não sejam transmitidas apenas por cores (objeto)."   },
    { INFORMATION_NOT_CONVEYED_SCRIPT,               0, "[2.1.1.4]: certificar de que as informações não sejam transmitidas apenas por cores (script)."   },
    { INFORMATION_NOT_CONVEYED_INPUT,                0,        
        "[2.1.1.5]: certificar de que as informações não sejam transmitidas apenas por cores "
        "(entrada)."
    },
    { COLOR_CONTRAST_TEXT,                           0, "[2.2.1.1]: contraste de cores ruim (texto)."                                                     },
    { COLOR_CONTRAST_LINK,                           0, "[2.2.1.2]: contraste de cores ruim (link)."                                                      },
    { COLOR_CONTRAST_ACTIVE_LINK,                    0, "[2.2.1.3]: contraste de cores ruim (link ativo)."                                                },
    { COLOR_CONTRAST_VISITED_LINK,                   0, "[2.2.1.4]: contraste de cores ruim (link visitado)."                                             },
    { DOCTYPE_MISSING,                               0, "[3.2.1.1]: faltando <doctype>."                                                                  },
    { STYLE_SHEET_CONTROL_PRESENTATION,              0, "[3.3.1.1]: use folhas de estilo para controlar apresentação."                                    },
    { HEADERS_IMPROPERLY_NESTED,                     0, "[3.5.1.1]: cabeçalhos aninhados incorretamente."                                                 },
    { POTENTIAL_HEADER_BOLD,                         0, "[3.5.2.1]: cabeçalho potencial (negrito)."                                                       },
    { POTENTIAL_HEADER_ITALICS,                      0, "[3.5.2.2]: cabeçalho potencial (itálico)."                                                       },
    { POTENTIAL_HEADER_UNDERLINE,                    0, "[3.5.2.3]: cabeçalho potencial (sublinhado)."                                                    },
    { HEADER_USED_FORMAT_TEXT,                       0, "[3.5.3.1]: cabeçalho usado para formatar o texto."                                               },
    { LIST_USAGE_INVALID_UL,                         0, "[3.6.1.1]: uso de lista inválido <ul>."                                                          },
    { LIST_USAGE_INVALID_OL,                         0, "[3.6.1.2]: uso de lista inválido <ol>."                                                          },
    { LIST_USAGE_INVALID_LI,                         0, "[3.6.1.4]: uso de lista inválido <li>."                                                          },
    { LANGUAGE_NOT_IDENTIFIED,                       0, "[4.3.1.1]: idioma não identificado."                                                             },
    { LANGUAGE_INVALID,                              0, "[4.3.1.2]: atributo de idioma inválido."                                                         },
    { DATA_TABLE_MISSING_HEADERS,                    0, "[5.1.2.1]: <table> de dados carece de cabeçalhos de linha/coluna (todos)."                       },
    { DATA_TABLE_MISSING_HEADERS_COLUMN,             0, "[5.1.2.2]: <table> de dados carece de cabeçalhos de linha/coluna (1 col)."                       },
    { DATA_TABLE_MISSING_HEADERS_ROW,                0, "[5.1.2.3]: <table> de dados carece de cabeçalhos de linha/coluna (1 lin)."                       },
    { DATA_TABLE_REQUIRE_MARKUP_COLUMN_HEADERS,      0, "[5.2.1.1]: <table> pode exigir marcação (cabeçalhos de coluna)."                                 },
    { DATA_TABLE_REQUIRE_MARKUP_ROW_HEADERS,         0, "[5.2.1.2]: <table> pode exigir marcação (cabeçalhos de linha)."                                  },
    { LAYOUT_TABLES_LINEARIZE_PROPERLY,              0, "[5.3.1.1]: verifique se tabelas de layout linearizaram corretamente."                            },
    { LAYOUT_TABLE_INVALID_MARKUP,                   0, "[5.4.1.1]: marcação inválida usada em <table> de layout."                                        },
    { TABLE_MISSING_SUMMARY,                         0, "[5.5.1.1]: <table> carece de sumário."                                                           },
    { TABLE_SUMMARY_INVALID_NULL,                    0, "[5.5.1.2]: resumo da <table> inválido (nulo)."                                                   },
    { TABLE_SUMMARY_INVALID_SPACES,                  0, "[5.5.1.3]: resumo da <table> inválido (espaços)."                                                },
    { TABLE_SUMMARY_INVALID_PLACEHOLDER,             0, "[5.5.1.6]: resumo da <table> inválido (texto de espaço reservado)."                              },
    { TABLE_MISSING_CAPTION,                         0, "[5.5.2.1]: <table> carece de <caption>."                                                         },
    { TABLE_MAY_REQUIRE_HEADER_ABBR,                 0, "[5.6.1.1]: <table> pode exigir abreviações de cabeçalho."                                        },
    { TABLE_MAY_REQUIRE_HEADER_ABBR_NULL,            0, "[5.6.1.2]: abreviações de cabeçalho de <table> inválidas (nula)."                                },
    { TABLE_MAY_REQUIRE_HEADER_ABBR_SPACES,          0, "[5.6.1.3]: abreviações de cabeçalho de <table> inválidas (espaços)."                             },
    { STYLESHEETS_REQUIRE_TESTING_LINK,              0, "[6.1.1.1]: folhas de estilo exigem teste (link)."                                                },
    { STYLESHEETS_REQUIRE_TESTING_STYLE_ELEMENT,     0, "[6.1.1.2]: folhas de estilo exigem teste (elemento de estilo)."                                  },
    { STYLESHEETS_REQUIRE_TESTING_STYLE_ATTR,        0, "[6.1.1.3]: folhas de estilo exigem teste (atributo de estilo)."                                  },
    { FRAME_SRC_INVALID,                             0, "[6.2.1.1]: fonte de <frame> inválida."                                                           },
    { TEXT_EQUIVALENTS_REQUIRE_UPDATING_APPLET,      0, "[6.2.2.1]: equivalentes de texto exigem atualização (applet)."                                   },
    { TEXT_EQUIVALENTS_REQUIRE_UPDATING_SCRIPT,      0, "[6.2.2.2]: equivalentes de texto exigem atualização (script)."                                   },
    { TEXT_EQUIVALENTS_REQUIRE_UPDATING_OBJECT,      0, "[6.2.2.3]: equivalentes de texto exigem atualização (object)."                                   },
    { PROGRAMMATIC_OBJECTS_REQUIRE_TESTING_SCRIPT,   0, "[6.3.1.1]: objetos programáticos exigem teste (script)."                                         },
    { PROGRAMMATIC_OBJECTS_REQUIRE_TESTING_OBJECT,   0, "[6.3.1.2]: objetos programáticos exigem teste (object)."                                         },
    { PROGRAMMATIC_OBJECTS_REQUIRE_TESTING_EMBED,    0, "[6.3.1.3]: objetos programáticos exigem teste (embed)."                                          },
    { PROGRAMMATIC_OBJECTS_REQUIRE_TESTING_APPLET,   0, "[6.3.1.4]: objetos programáticos exigem teste (applet)."                                         },
    { FRAME_MISSING_NOFRAMES,                        0, "[6.5.1.1]: <frameset> carece de seção <noframes>."                                               },
    { NOFRAMES_INVALID_NO_VALUE,                     0, "[6.5.1.2]: seção <noframes> inválida (sem valor)."                                               },
    { NOFRAMES_INVALID_CONTENT,                      0, "[6.5.1.3]: seção <noframes> inválida (conteúdo)."                                                },
    { NOFRAMES_INVALID_LINK,                         0, "[6.5.1.4]: seção <noframes> inválida (link)."                                                    },
    { REMOVE_FLICKER_SCRIPT,                         0, "[7.1.1.1]: remoção de cintilação (script)."                                                      },
    { REMOVE_FLICKER_OBJECT,                         0, "[7.1.1.2]: remoção de cintilação (object)."                                                      },
    { REMOVE_FLICKER_EMBED,                          0, "[7.1.1.3]: remoção de cintilação (embed)."                                                       },
    { REMOVE_FLICKER_APPLET,                         0, "[7.1.1.4]: remoção de cintilação (applet)."                                                      },
    { REMOVE_FLICKER_ANIMATED_GIF,                   0, "[7.1.1.5]: remoção de cintilação (gif animado)."                                                 },
    { REMOVE_BLINK_MARQUEE,                          0, "[7.2.1.1]: remoção de blink/marquee."                                                            },
    { REMOVE_AUTO_REFRESH,                           0, "[7.4.1.1]: remoção de autorrenovação."                                                           },
    { REMOVE_AUTO_REDIRECT,                          0, "[7.5.1.1]: remoção de autorredirecionamento."                                                    },
    { ENSURE_PROGRAMMATIC_OBJECTS_ACCESSIBLE_SCRIPT, 0, "[8.1.1.1]: certifique-se que objetos programáticos sejam acessíveis (script)."                   },
    { ENSURE_PROGRAMMATIC_OBJECTS_ACCESSIBLE_OBJECT, 0, "[8.1.1.2]: certifique-se que objetos programáticos sejam acessíveis (object)."                   },
    { ENSURE_PROGRAMMATIC_OBJECTS_ACCESSIBLE_APPLET, 0, "[8.1.1.3]: certifique-se que objetos programáticos sejam acessíveis (applet)."                   },
    { ENSURE_PROGRAMMATIC_OBJECTS_ACCESSIBLE_EMBED,  0, "[8.1.1.43]: certifique-se que objetos programáticos sejam acessíveis (embed)."                   },
    { IMAGE_MAP_SERVER_SIDE_REQUIRES_CONVERSION,     0, "[9.1.1.1]: mapa de imagem (lado do servidor) exige conversão."                                   },
    { SCRIPT_NOT_KEYBOARD_ACCESSIBLE_ON_MOUSE_DOWN,  0, "[9.3.1.1]: <script> não é acessível por teclado (onMouseDown)."                                  },
    { SCRIPT_NOT_KEYBOARD_ACCESSIBLE_ON_MOUSE_UP,    0, "[9.3.1.2]: <script> não é acessível por teclado (onMouseUp)."                                    },
    { SCRIPT_NOT_KEYBOARD_ACCESSIBLE_ON_CLICK,       0, "[9.3.1.3]: <script> não é acessível por teclado (onClick)."                                      },
    { SCRIPT_NOT_KEYBOARD_ACCESSIBLE_ON_MOUSE_OVER,  0, "[9.3.1.4]: <script> não é acessível por teclado (onMouseOver)."                                  },
    { SCRIPT_NOT_KEYBOARD_ACCESSIBLE_ON_MOUSE_OUT,   0, "[9.3.1.5]: <script> não é acessível por teclado (onMouseOut)."                                   },
    { SCRIPT_NOT_KEYBOARD_ACCESSIBLE_ON_MOUSE_MOVE,  0, "[9.3.1.6]: <script> não é acessível por teclado (onMouseMove)."                                  },
    { NEW_WINDOWS_REQUIRE_WARNING_NEW,               0, "[10.1.1.1]: novas janelas exigem aviso (_new)."                                                  },
    { NEW_WINDOWS_REQUIRE_WARNING_BLANK,             0, "[10.1.1.2]: novas janelas exigem aviso (_blank)."                                                },
    { REPLACE_DEPRECATED_HTML_APPLET,                0, "[11.2.1.1]: substituir o elemento html obsoleto <applet>."                                       },
    { REPLACE_DEPRECATED_HTML_BASEFONT,              0, "[11.2.1.2]: substituir o elemento html obsoleto <basefont>."                                     },
    { REPLACE_DEPRECATED_HTML_CENTER,                0, "[11.2.1.3]: substituir o elemento html obsoleto <center>."                                       },
    { REPLACE_DEPRECATED_HTML_DIR,                   0, "[11.2.1.4]: substituir o elemento html obsoleto <dir>."                                          },
    { REPLACE_DEPRECATED_HTML_FONT,                  0, "[11.2.1.5]: substituir o elemento html obsoleto <font>."                                         },
    { REPLACE_DEPRECATED_HTML_ISINDEX,               0, "[11.2.1.6]: substituir o elemento html obsoleto <isindex>."                                      },
    { REPLACE_DEPRECATED_HTML_MENU,                  0, "[11.2.1.7]: substituir o elemento html obsoleto <menu>."                                         },
    { REPLACE_DEPRECATED_HTML_S,                     0, "[11.2.1.8]: substituir o elemento html obsoleto <s>."                                            },
    { REPLACE_DEPRECATED_HTML_STRIKE,                0, "[11.2.1.9]: substituir o elemento html obsoleto <strike>."                                       },
    { REPLACE_DEPRECATED_HTML_U,                     0, "[11.2.1.10]: substituir o elemento html obsoleto <u>."                                           },
    { FRAME_MISSING_TITLE,                           0, "[12.1.1.1]: <frame> carece de título."                                                           },
    { FRAME_TITLE_INVALID_NULL,                      0, "[12.1.1.2]: título de <frame> inválido (nulo)."                                                  },
    { FRAME_TITLE_INVALID_SPACES,                    0, "[12.1.1.3]: título de <frame> inválido (espaços)."                                               },
    { ASSOCIATE_LABELS_EXPLICITLY,                   0, "[12.4.1.1]: associar rótulos explicitamente com controles de formulário."                        },
    { ASSOCIATE_LABELS_EXPLICITLY_FOR,               0,        
        "[12.4.1.2]: associar rótulos explicitamente com controles de formulário "
        "(for)."
    },
    { ASSOCIATE_LABELS_EXPLICITLY_ID,                0, "[12.4.1.3]: associar rótulos explicitamente com controles de formulário (id)."                   },
    { LINK_TEXT_NOT_MEANINGFUL,                      0, "[13.1.1.1]: texto de link não significativo."                                                    },
    { LINK_TEXT_MISSING,                             0, "[13.1.1.2]: faltando texto de link."                                                             },
    { LINK_TEXT_TOO_LONG,                            0, "[13.1.1.3]: texto de link longo demais."                                                         },
    { LINK_TEXT_NOT_MEANINGFUL_CLICK_HERE,           0, "[13.1.1.4]: texto de link não significativo (clique aqui)."                                      },
    { METADATA_MISSING,                              0, "[13.2.1.1]: faltando metadados."                                                                 },
    { METADATA_MISSING_REDIRECT_AUTOREFRESH,         0, "[13.2.1.3]: faltando metadados (redirecionamento/autorrenovação)."                               },
    { SKIPOVER_ASCII_ART,                            0, "[13.10.1.1]: pular arte em ascii."                                                               },

#if SUPPORT_CONSOLE_APP
    { TC_LABEL_COL,                                  0, "coluna"                                                                                          },
    { TC_LABEL_FILE,                                 0, "arquivo"                                                                                         },
    { TC_LABEL_LANG,                                 0, "idioma"                                                                                          },
    { TC_LABEL_LEVL,                                 0, "nível"                                                                                           },
    { TC_LABEL_OPT,                                  0, "opção"                                                                                           },
    { TC_MAIN_ERROR_LOAD_CONFIG,                     0, "Falha ao carregar o arquivo de config \"%s\", err = %d"                                          },
    { TC_OPT_ACCESS,                                 0,        
        " faz verificações adicionais de acessibilidade (<nível> = 0, 1, 2, 3). 0 é "
        "presumido se <nível> estiver faltando."
    },
    { TC_OPT_ASCII,                                  0, "usa ISO-8859-1 para entrada, US-ASCII para saída"                                                },
    { TC_OPT_ASHTML,                                 0, "força XHTML para HTML bem formatado"                                                             },
    { TC_OPT_ASXML,                                  0, "converte HTML para XHTML bem formatado"                                                          },
    { TC_OPT_BARE,                                   0, "retira aspas inteligentes, travessões etc."                                                      },
    { TC_OPT_BIG5,                                   0, "usa Big5 para tanto entrada quanto saída"                                                        },
    { TC_OPT_CLEAN,                                  0, "substitui tags FONT, NOBR e CENTER com CSS"                                                      },
    { TC_OPT_CONFIG,                                 0, "define opções de configuração a partir do <arquivo> especificado"                                },
    { TC_OPT_ERRORS,                                 0, "mostra apenas erros e avisos"                                                                    },
    { TC_OPT_FILE,                                   0, "escreve erros e avisos para o <arquivo> especificado"                                            },
    { TC_OPT_GDOC,                                   0, "produz versão limpa do html exportado pelo Google Docs"                                          },
    { TC_OPT_HELP,                                   0, "lista as opções de linha de comando"                                                             },
    { TC_OPT_HELPCFG,                                0, "lista todas as opções de configuração"                                                           },
    { TC_OPT_HELPOPT,                                0, "  mostra uma descrição da <opção>"                                                               },
    { TC_OPT_IBM858,                                 0, "usa IBM-858 (CP850+Euro) para entrada, US-ASCII para saída"                                      },
    { TC_OPT_INDENT,                                 0, "recua o conteúdo do elemento"                                                                    },
    { TC_OPT_ISO2022,                                0, "usa ISO-2022 para tanto entrada quanto saída"                                                    },
    { TC_OPT_LANGUAGE,                               0,        
        "define o idioma de saída do Tidy para <idioma>. Especifique '-language help' "
        "para mais ajuda. Use antes de argumentos que gerem saída para garantir que o "
        "idioma surta efeitos, p.ex.:\n"
        "`tidy -lang es -lang help`."
    },
    { TC_OPT_LATIN0,                                 0, "usa ISO-8859-15 para entrada, US-ASCII para saída"                                               },
    { TC_OPT_LATIN1,                                 0, "usa ISO-8859-1 para tanto entrada quanto saída"                                                  },
    { TC_OPT_MAC,                                    0, "usa MacRoman para entrada, US-ASCII para saída"                                                  },
    { TC_OPT_MODIFY,                                 0, "modifica os arquivos de entrada originais"                                                       },
    { TC_OPT_NUMERIC,                                0, "emite entidades numéricas em vez de nomeadas"                                                    },
    { TC_OPT_OMIT,                                   0, "omite tags opcionais de início e de fim"                                                         },
    { TC_OPT_OUTPUT,                                 0, "escreve a saída para o <arquivo> especificado"                                                   },
    { TC_OPT_QUIET,                                  0, "suprime saída não essencial"                                                                     },
    { TC_OPT_RAW,                                    0, "emite valores acima de 127 sem conversão para entidades"                                         },
    { TC_OPT_SHIFTJIS,                               0, "usa Shift_JIS para tanto entrada quanto saída"                                                   },
    { TC_OPT_SHOWCFG,                                0, "lista as definições da configuração atual"                                                       },
    { TC_OPT_UPPER,                                  0, "força tags para maiúsculo"                                                                       },
    { TC_OPT_UTF16,                                  0, "usa UTF-16 para tanto entrada quanto saída"                                                      },
    { TC_OPT_UTF16BE,                                0, "usa UTF-16BE para tanto entrada quanto saída"                                                    },
    { TC_OPT_UTF16LE,                                0, "usa UTF-16LE para tanto entrada quanto saída"                                                    },
    { TC_OPT_UTF8,                                   0, "usa UTF-8 para tanto entrada quanto saída"                                                       },
    { TC_OPT_VERSION,                                0, "mostra a versão do Tidy"                                                                         },
    { TC_OPT_WIN1252,                                0, "usa Windows--1252 para entrada, US-ASCII para saída"                                             },
    { TC_OPT_WRAP,                                   0,        
        "efetua quebra de texto na <coluna> especificada, 0 é presumido se <coluna> "
        "estiver faltando. Quando esta opção é omitida, o padrão da opção da "
        "configuração 'wrap' é aplicado."
    },
    { TC_OPT_XML,                                    0, "especifica a entrada é XML bem formatado"                                                        },
    { TC_OPT_XMLCFG,                                 0, "lista todas as opções de configuração no formato XML"                                            },
    { TC_OPT_XMLHELP,                                0, "lista as opções de linha de comando no formato XML"                                              },
    { TC_OPT_XMLSTRG,                                0, "emite todas as strings do Tidy no formato XML"                                                   },
    { TC_OPT_XMLERRS,                                0, "emite constantes de erro e strings no formato XML"                                               },
    { TC_OPT_XMLOPTS,                                0, "emite descrições de opção no formato XML"                                                        },
    { TC_STRING_CONF_HEADER,                         0, "Definições do arquivo de configuração:"                                                          },
    { TC_STRING_CONF_NAME,                           0, "Nome"                                                                                            },
    { TC_STRING_CONF_TYPE,                           0, "Tipo"                                                                                            },
    { TC_STRING_CONF_VALUE,                          0, "Valor atual"                                                                                     },
    { TC_STRING_OPT_NOT_DOCUMENTED,                  0, "Aviso: a opção '%s' não está documentada."                                                       },
    { TC_STRING_OUT_OF_MEMORY,                       0, "Memória insuficiente. Saindo."                                                                   },
    { TC_STRING_FATAL_ERROR,                         0, "Erro fatal: valor impossível para id='%d'."                                                      },
    { TC_STRING_FILE_MANIP,                          0, "Manipulação de arquivo"                                                                          },
    { TC_STRING_PROCESS_DIRECTIVES,                  0, "Diretivas de processamento"                                                                      },
    { TC_STRING_CHAR_ENCODING,                       0, "Codificações de caracteres"                                                                      },
    { TC_STRING_LANG_MUST_SPECIFY,                   0, "Uma localidade POSIX ou Windows deve ser especificada."                                          },
    { TC_STRING_LANG_NOT_FOUND,                      0, "Tidy não possui o idioma '%s'; em vez desta, usará '%s'."                                        },
    { TC_STRING_MISC,                                0, "Diversos"                                                                                        },
    { TC_STRING_XML,                                 0, "XML"                                                                                             },
    { TC_STRING_MUST_SPECIFY,                        0, "Um nome de opção Tidy deve ser especificado."                                                    },
    { TC_STRING_UNKNOWN_OPTION,                      0, "HTML Tidy: opção desconhecida: %c"                                                               },
    { TC_STRING_UNKNOWN_OPTION_B,                    0, "HTML Tidy: opção desconhecida."                                                                  },
    { TC_STRING_VERS_A,                              0, "HTML Tidy para %s versão %s"                                                                     },
    { TC_STRING_VERS_B,                              0, "HTML Tidy versão %s"                                                                             },
    { TC_TXT_HELP_1,                                 0,        
        "\n"
        "%s [opções...] [arquivo...] [opções...] [arquivo...]\n"
        "Utilitário para limpar e melhor imprimir HTML/XHTML/XML.\n"
        "\n"
        "Essa é o HTML Tidy moderno versão %s.\n"
        "\n"
    },
    { TC_TXT_HELP_2A,                                0, "Os argumentos de linha de comando para HTML Tidy para %s:"                                       },
    { TC_TXT_HELP_2B,                                0, "Os argumentos de linha de comando para HTML Tidy:"                                               },
    { TC_TXT_HELP_3,                                 0,        
        "\n"
        "Opções de configuração do Tidy\n"
        "==========================\n"
        "Use as opções de configuração do Tidy como argumentos de linha de comando\n"
        "no forma de \"--alguma-opcao <valor>\", por exemplo \"--indent-with-tabs "
        "yes\".\n"
        "\n"
        "Para uma lista de todas as opções de configuração, use \"-help-config\" ou\n"
        "veja a página man (se seu SO tiver uma).\n"
        "\n"
        "Se seu ambiente tem uma variável $HTML_TIDY definida, aponte para um "
        "arquivo\n"
        "de configuração Tidy e, então, Tidy vai tentar usá-la.\n"
        "\n"
        "Em algumas plataformas, Tidy também vai tentar usar uma configuração\n"
        "especificada no /etc/tidy.conf ou ~/.tidy.conf.\n"
        "\n"
        "Outro\n"
        "=====\n"
        "Entrada/Saída usa, por padrão, stdin/stdout respectivamente.\n"
        "\n"
        "Opções de uma só letra, com exceção de -f, podem ser combinadas\n"
        "como em: tidy -f errs.txt -imu foo.html\n"
        "\n"
        "Informação\n"
        "===========\n"
        "Para mais informações sobre HTML Tidy, veja\n"
        "  http://www.html-tidy.org/\n"
        "\n"
        "Para mais informações sobre HTML, veja o seguinte:\n"
        "\n"
        "  HTML: Edition for Web Authors (the latest HTML specification)\n"
        "  http://dev.w3.org/html5/spec-author-view\n"
        "\n"
        "  HTML: The Markup Language (an HTML language reference)\n"
        "  http://dev.w3.org/html5/markup/\n"
        "\n"
        "Preencha relatórios de erros em https://github.com/htacg/tidy-html5/issues/\n"
        "ou envie perguntas e comentários para public-htacg@w3.org.\n"
        "\n"
        "Valide seus documentos HTML usando Nu, o validador de marcação da W3C:\n"
        "  http://validator.w3.org/nu/\n"
        "\n"
    },
    { TC_TXT_HELP_CONFIG,                            0,        
        "\n"
        "Definições de configuração do HTML Tidy\n"
        "\n"
        "Dentro de um arquivo, use a forma:\n"
        "\n"
        "wrap: 72\n"
        "indent: no\n"
        "\n"
        "Quando especificado na linha de comando, use a forma:\n"
        "\n"
        "--wrap 72 --indent no\n"
        "\n"
    },
    { TC_TXT_HELP_CONFIG_NAME,                       0, "Nome"                                                                                            },
    { TC_TXT_HELP_CONFIG_TYPE,                       0, "Tipo"                                                                                            },
    { TC_TXT_HELP_CONFIG_ALLW,                       0, "Valores permitidos"                                                                              },
    { TC_TXT_HELP_LANG_1,                            0,        
        "\n"
        "A opção -language (ou -lang) indica qual idioma o Tidy deve usar\n"
        "para comunicar sua saída. Por favor, note que este não é um serviço\n"
        "de tradução de documentos e afeta apenas as mensagens com as quais\n"
        "o Tidy se comunica com você.\n"
        "\n"
        "Quando usado a partir da linha de comando, o argumento -language\n"
        "deve ser usado antes de qualquer argumento que resulte em saída; do\n"
        "contrário, o Tidy produzirá saída antes de saber qual idioma usar.\n"
        "\n"
        "Além dos códigos de idioma POSIX padrão, o Tidy é capaz de entender\n"
        "os códigos legados de idioma do Windows. Por favor, note que esta\n"
        "lista indica códigos Tidy entende e não indica que o idioma esteja\n"
        "instalado no momento.\n"
        "\n"
        "A coluna mais à direita indica como o Tidy vai entender o nome do\n"
        "Windows legado.\n"
        "\n"
    },
    { TC_TXT_HELP_LANG_2,                            0,        
        "\n"
        "Os seguintes idiomas estão atualmente instalados em Tidy. Por favor, \n"
        "note que não há garantia de que eles estejam completos; apenas que \n"
        "esse desenvolvedor ou outro começou a adicionar o idioma indicado. \n"
        "\n"
        "As localizações incompletas serão padrão para \"en\" quando necessário. \n"
        "Informe as instâncias de strings incorretas para a equipe do Tidy. \n"
        "\n"
    },
    { TC_TXT_HELP_LANG_3,                            0,        
        "\n"
        "Se o Tidy for capaz de determinar sua localidade, o Tidy usará \n"
        "o idioma da localidade automaticamente. Por exemplo, os sistemas \n"
        "tipo Unix usam uma variável de ambiente $LANG e/ou $LC_ALL. \n"
        "Consulte a documentação de seu sistema operacional para obter \n"
        "mais informações. \n"
        "\n"
        "Tidy está usando a localidade %s. \n"
        "\n"
    },
#endif /* SUPPORT_CONSOLE_APP */

    {/* This MUST be present and last. */
      TIDY_MESSAGE_TYPE_LAST,                        0, NULL
    }

}};


#endif /* language_pt_br_h */

#ifndef language_zh_cn_h
#define language_zh_cn_h
/*
 * language_zh_cn.h
 * Localization support for HTML Tidy.
 *
 *
 * This file is a localization file for HTML Tidy. It will have been machine
 * generated or created and/or edited by hand. Both are valid options, but
 * please help keep our localization efforts simple to maintain by maintaining
 * the structure of this file, and changing the check box below if you make
 * changes (so others know the file origin):
 *
 * [X] THIS FILE IS MACHINE GENERATED. It is a localization file for the
 *     language (and maybe region) "zh_cn". The source of
 *     these strings is a gettext PO file in Tidy's source, probably called 
 *     "language_zh_cn.po".
 *
 * [ ] THIS FILE WAS HAND MODIFIED. Translators, please feel to edit this file
 *     directly (and check this box). If you prefer to edit PO files then use
 *     `poconvert.rb msgunfmt language_zh_cn.h` (our own
 *     conversion tool) to generate a fresh PO from this file first!
 *
 * (c) 2015-2017 HTACG
 * See tidy.h and access.h for the copyright notice.
 *
 * Template Created by Jim Derry on 01/14/2016.
 *
 * Orginating PO file metadata:
 *   PO_LAST_TRANSLATOR=jderry
 *   PO_REVISION_DATE=2017-10-03 12:44:37
 */

#ifdef _MSC_VER
#pragma execution_character_set("utf-8")
#endif


/**
 *  This language-specific function returns the correct pluralForm
 *  to use given n items, and is used as a member of each language
 *  definition.
 */
static unsigned int whichPluralForm_zh_cn(unsigned int n) {
    /* Plural-Forms: nplurals=1; */
    return 0;
}


/**
 *  This structure specifies all of the strings needed by Tidy for a
 *  single language. Static definition in a header file makes it
 *  easy to include and exclude languages without tinkering with
 *  the build system.
 */
static languageDefinition language_zh_cn = { whichPluralForm_zh_cn, {
    /***************************************
     ** This MUST be present and first. 
     ** Specify the code for this language.
     ***************************************/
    {/* Specify the ll or ll_cc language code here. */
      TIDY_LANGUAGE,          0, "zh_cn"
    },
    { LINE_COLUMN_STRING,     0, "行 %d 列 %d - "            },
    { STRING_CONTENT_LOOKS,   0, "文档内容看起来像 %s"             },
    { FILE_CANT_OPEN,         0, "无法打开”%s”\n"              },

#if SUPPORT_CONSOLE_APP
    { TC_STRING_VERS_A,       0, "HTML Tidy 用于 %s 版本 %s"   },
    { TC_STRING_VERS_B,       0, "HTML Tidy 版本 %s"         },
#endif /* SUPPORT_CONSOLE_APP */

    {/* This MUST be present and last. */
      TIDY_MESSAGE_TYPE_LAST, 0, NULL
    }

}};


#endif /* language_zh_cn_h */

#ifndef __LEXER_H__
#define __LEXER_H__

/* lexer.h -- Lexer for html parser
  
   (c) 1998-2008 (W3C) MIT, ERCIM, Keio University
   See tidy.h for the copyright notice.

  Given an input source, it returns a sequence of tokens.

     GetToken(source) gets the next token
     UngetToken(source) provides one level undo

  The tags include an attribute list:

    - linked list of attribute/value nodes
    - each node has 2 NULL-terminated strings.
    - entities are replaced in attribute values

  white space is compacted if not in preformatted mode
  If not in preformatted mode then leading white space
  is discarded and subsequent white space sequences
  compacted to single space characters.

  If XmlTags is no then Tag names are folded to upper
  case and attribute names to lower case.

 Not yet done:
    -   Doctype subset and marked sections
*/

#ifdef __cplusplus
extern "C" {
#endif

/* #include "forward.h" */

/* lexer character types
*/
#define digit       1u
#define letter      2u
#define namechar    4u
#define white       8u
#define newline     16u
#define lowercase   32u
#define uppercase   64u
#define digithex    128u


/* node->type is one of these values
*/
typedef enum
{
  RootNode,
  DocTypeTag,
  CommentTag,
  ProcInsTag,
  TextNode,
  StartTag,
  EndTag,
  StartEndTag,
  CDATATag,
  SectionTag,
  AspTag,
  JsteTag,
  PhpTag,
  XmlDecl
} NodeType;



/* lexer GetToken states
*/
typedef enum
{
  LEX_CONTENT,
  LEX_GT,
  LEX_ENDTAG,
  LEX_STARTTAG,
  LEX_COMMENT,
  LEX_DOCTYPE,
  LEX_PROCINSTR,
  LEX_CDATA,
  LEX_SECTION,
  LEX_ASP,
  LEX_JSTE,
  LEX_PHP,
  LEX_XMLDECL
} LexerState;

/* ParseDocTypeDecl state constants */
typedef enum
{
  DT_INTERMEDIATE,
  DT_DOCTYPENAME,
  DT_PUBLICSYSTEM,
  DT_QUOTEDSTRING,
  DT_INTSUBSET
} ParseDocTypeDeclState;

/* content model shortcut encoding

   Descriptions are tentative.
*/
#define CM_UNKNOWN      0
/* Elements with no content. Map to HTML specification. */
#define CM_EMPTY        (1 << 0)
/* Elements that appear outside of "BODY". */
#define CM_HTML         (1 << 1)
/* Elements that can appear within HEAD. */
#define CM_HEAD         (1 << 2)
/* HTML "block" elements. */
#define CM_BLOCK        (1 << 3)
/* HTML "inline" elements. */
#define CM_INLINE       (1 << 4)
/* Elements that mark list item ("LI"). */
#define CM_LIST         (1 << 5)
/* Elements that mark definition list item ("DL", "DT"). */
#define CM_DEFLIST      (1 << 6)
/* Elements that can appear inside TABLE. */
#define CM_TABLE        (1 << 7)
/* Used for "THEAD", "TFOOT" or "TBODY". */
#define CM_ROWGRP       (1 << 8)
/* Used for "TD", "TH" */
#define CM_ROW          (1 << 9)
/* Elements whose content must be protected against white space movement.
   Includes some elements that can found in forms. */
#define CM_FIELD        (1 << 10)
/* Used to avoid propagating inline emphasis inside some elements
   such as OBJECT or APPLET. */
#define CM_OBJECT       (1 << 11)
/* Elements that allows "PARAM". */
#define CM_PARAM        (1 << 12)
/* "FRAME", "FRAMESET", "NOFRAMES". Used in ParseFrameSet. */
#define CM_FRAMES       (1 << 13)
/* Heading elements (h1, h2, ...). */
#define CM_HEADING      (1 << 14)
/* Elements with an optional end tag. */
#define CM_OPT          (1 << 15)
/* Elements that use "align" attribute for vertical position. */
#define CM_IMG          (1 << 16)
/* Elements with inline and block model. Used to avoid calling InlineDup. */
#define CM_MIXED        (1 << 17)
/* Elements whose content needs to be indented only if containing one 
   CM_BLOCK element. */
#define CM_NO_INDENT    (1 << 18)
/* Elements that are obsolete (such as "dir", "menu"). */
#define CM_OBSOLETE     (1 << 19)
/* User defined elements. Used to determine how attributes wihout value
   should be printed. */
#define CM_NEW          (1 << 20)
/* Elements that cannot be omitted. */
#define CM_OMITST       (1 << 21)

/* If the document uses just HTML 2.0 tags and attributes described
** it as HTML 2.0 Similarly for HTML 3.2 and the 3 flavors of HTML 4.0.
** If there are proprietary tags and attributes then describe it as
** HTML Proprietary. If it includes the xml-lang or xmlns attributes
** but is otherwise HTML 2.0, 3.2 or 4.0 then describe it as one of the
** flavors of Voyager (strict, loose or frameset).
*/

/* unknown */
#define xxxx                   0u

/* W3C defined HTML/XHTML family document types */
#define HT20                   1u
#define HT32                   2u
#define H40S                   4u
#define H40T                   8u
#define H40F                  16u
#define H41S                  32u
#define H41T                  64u
#define H41F                 128u
#define X10S                 256u
#define X10T                 512u
#define X10F                1024u
#define XH11                2048u
#define XB10                4096u

/* proprietary stuff */
#define VERS_SUN            8192u
#define VERS_NETSCAPE      16384u
#define VERS_MICROSOFT     32768u

/* special flag */
#define VERS_XML           65536u

/* HTML5 */
#define HT50              131072u
#define XH50              262144u

/* compatibility symbols */
#define VERS_UNKNOWN       (xxxx)
#define VERS_HTML20        (HT20)
#define VERS_HTML32        (HT32)
#define VERS_HTML40_STRICT (H40S|H41S|X10S)
#define VERS_HTML40_LOOSE  (H40T|H41T|X10T)
#define VERS_FRAMESET      (H40F|H41F|X10F)
#define VERS_XHTML11       (XH11)
#define VERS_BASIC         (XB10)
/* HTML5 */
#define VERS_HTML5         (HT50|XH50)

/* meta symbols */
#define VERS_HTML40        (VERS_HTML40_STRICT|VERS_HTML40_LOOSE|VERS_FRAMESET)
#define VERS_IFRAME        (VERS_HTML40_LOOSE|VERS_FRAMESET)
#define VERS_LOOSE         (VERS_HTML20|VERS_HTML32|VERS_IFRAME)
#define VERS_EVENTS        (VERS_HTML40|VERS_XHTML11)
#define VERS_FROM32        (VERS_HTML32|VERS_HTML40|HT50)
#define VERS_FROM40        (VERS_HTML40|VERS_XHTML11|VERS_BASIC|VERS_HTML5)
#define VERS_XHTML         (X10S|X10T|X10F|XH11|XB10|XH50)

/* strict */
#define VERS_STRICT        (VERS_HTML5|VERS_HTML40_STRICT)

/* all W3C defined document types */
#define VERS_ALL           (VERS_HTML20|VERS_HTML32|VERS_FROM40|XH50|HT50)

/* all proprietary types */
#define VERS_PROPRIETARY   (VERS_NETSCAPE|VERS_MICROSOFT|VERS_SUN)

/* Linked list of class names and styles
*/
struct _Style;
typedef struct _Style TagStyle;

struct _Style
{
    tmbstr tag;
    tmbstr tag_class;
    tmbstr properties;
    TagStyle *next;
};


/* Linked list of style properties
*/
struct _StyleProp;
typedef struct _StyleProp StyleProp;

struct _StyleProp
{
    tmbstr name;
    tmbstr value;
    StyleProp *next;
};




/* Attribute/Value linked list node
*/

struct _AttVal
{
    AttVal*           next;
    const Attribute*  dict;
    Node*             asp;
    Node*             php;
    int               delim;
    tmbstr            attribute;
    tmbstr            value;
};



/*
  Mosaic handles inlines via a separate stack from other elements
  We duplicate this to recover from inline markup errors such as:

     <i>italic text
     <p>more italic text</b> normal text

  which for compatibility with Mosaic is mapped to:

     <i>italic text</i>
     <p><i>more italic text</i> normal text

  Note that any inline end tag pop's the effect of the current
  inline start tag, so that </b> pop's <i> in the above example.
*/
struct _IStack
{
    IStack*     next;
    const Dict* tag;        /* tag's dictionary definition */
    tmbstr      element;    /* name (NULL for text nodes) */
    AttVal*     attributes;
};


/* HTML/XHTML/XML Element, Comment, PI, DOCTYPE, XML Decl,
** etc. etc.
*/

struct _Node
{
    Node*       parent;         /* tree structure */
    Node*       prev;
    Node*       next;
    Node*       content;
    Node*       last;

    AttVal*     attributes;
    const Dict* was;            /* old tag when it was changed */
    const Dict* tag;            /* tag's dictionary definition */

    tmbstr      element;        /* name (NULL for text nodes) */

    unsigned int        start;          /* start of span onto text array */
    unsigned int        end;            /* end of span onto text array */
    NodeType    type;           /* TextNode, StartTag, EndTag etc. */

    unsigned int        line;           /* current line of document */
    unsigned int        column;         /* current column of document */

    Bool        closed;         /* true if closed by explicit end tag */
    Bool        implicit;       /* true if inferred */
    Bool        linebreak;      /* true if followed by a line break */
};


/*
  The following are private to the lexer
  Use NewLexer() to create a lexer, and
  FreeLexer() to free it.
*/

struct _Lexer
{
    unsigned int lines;             /* lines seen */
    unsigned int columns;           /* at start of current token */
    Bool waswhite;          /* used to collapse contiguous white space */
    Bool pushed;            /* true after token has been pushed back */
    Bool insertspace;       /* when space is moved after end tag */
    Bool excludeBlocks;     /* Netscape compatibility */
    Bool exiled;            /* true if moved out of table */
    Bool isvoyager;         /* true if xmlns attribute on html element */
    unsigned int versions;          /* bit vector of HTML versions */
    unsigned int doctype;           /* version as given by doctype (if any) */
    unsigned int versionEmitted;    /* version of doctype emitted */
    Bool bad_doctype;       /* e.g. if html or PUBLIC is missing */
    unsigned int txtstart;          /* start of current node */
    unsigned int txtend;            /* end of current node */
    LexerState state;       /* state of lexer's finite state machine */

    Node* token;            /* last token returned by GetToken() */
    Node* itoken;           /* last duplicate inline returned by GetToken() */
    Node* root;             /* remember root node of the document */
    Node* parent;           /* remember parent node for CDATA elements */
    
    Bool seenEndBody;       /* true if a </body> tag has been encountered */
    Bool seenEndHtml;       /* true if a </html> tag has been encountered */

    /*
      Lexer character buffer

      Parse tree nodes span onto this buffer
      which contains the concatenated text
      contents of all of the elements.

      lexsize must be reset for each file.
    */
    tmbstr lexbuf;          /* MB character buffer */
    unsigned int lexlength;         /* allocated */
    unsigned int lexsize;           /* used */

    /* Inline stack for compatibility with Mosaic */
    Node* inode;            /* for deferring text node */
    IStack* insert;         /* for inferring inline tags */
    IStack* istack;
    unsigned int istacklength;      /* allocated */
    unsigned int istacksize;        /* used */
    unsigned int istackbase;        /* start of frame */

    TagStyle *styles;          /* used for cleaning up presentation markup */

    TidyAllocator* allocator; /* allocator */
};


/* Lexer Functions
*/

/* choose what version to use for new doctype */
int TY_(HTMLVersion)( TidyDocImpl* doc );

/* everything is allowed in proprietary version of HTML */
/* this is handled here rather than in the tag/attr dicts */

void TY_(ConstrainVersion)( TidyDocImpl* doc, unsigned int vers );

Bool TY_(IsWhite)(unsigned int c);
Bool TY_(IsDigit)(unsigned int c);
Bool TY_(IsLetter)(unsigned int c);
Bool TY_(IsHTMLSpace)(unsigned int c);
Bool TY_(IsNewline)(unsigned int c);
Bool TY_(IsNamechar)(unsigned int c);
Bool TY_(IsXMLLetter)(unsigned int c);
Bool TY_(IsXMLNamechar)(unsigned int c);

/* Bool IsLower(unsigned int c); */
Bool TY_(IsUpper)(unsigned int c);
unsigned int TY_(ToLower)(unsigned int c);
unsigned int TY_(ToUpper)(unsigned int c);

Lexer* TY_(NewLexer)( TidyDocImpl* doc );
void TY_(FreeLexer)( TidyDocImpl* doc );

/* store character c as UTF-8 encoded byte stream */
void TY_(AddCharToLexer)( Lexer *lexer, unsigned int c );

/*
  Used for elements and text nodes
  element name is NULL for text nodes
  start and end are offsets into lexbuf
  which contains the textual content of
  all elements in the parse tree.

  parent and content allow traversal
  of the parse tree in any direction.
  attributes are represented as a linked
  list of AttVal nodes which hold the
  strings for attribute/value pairs.
*/
Node* TY_(NewNode)( TidyAllocator* allocator, Lexer* lexer );


/* used to clone heading nodes when split by an <HR> */
Node* TY_(CloneNode)( TidyDocImpl* doc, Node *element );

/* free node's attributes */
void TY_(FreeAttrs)( TidyDocImpl* doc, Node *node );

/* doesn't repair attribute list linkage */
void TY_(FreeAttribute)( TidyDocImpl* doc, AttVal *av );

/* detach attribute from node */
void TY_(DetachAttribute)( Node *node, AttVal *attr );

/* detach attribute from node then free it
*/
void TY_(RemoveAttribute)( TidyDocImpl* doc, Node *node, AttVal *attr );

/*
  Free document nodes by iterating through peers and recursing
  through children. Set next to NULL before calling FreeNode()
  to avoid freeing peer nodes. Doesn't patch up prev/next links.
 */
void TY_(FreeNode)( TidyDocImpl* doc, Node *node );

Node* TY_(TextToken)( Lexer *lexer );

/* used for creating preformatted text from Word2000 */
Node* TY_(NewLineNode)( Lexer *lexer );

/* used for adding a &nbsp; for Word2000 */
Node* TY_(NewLiteralTextNode)(Lexer *lexer, ctmbstr txt );

void TY_(AddStringLiteral)( Lexer* lexer, ctmbstr str );
/* void AddStringLiteralLen( Lexer* lexer, ctmbstr str, int len ); */

/* find element */
Node* TY_(FindDocType)( TidyDocImpl* doc );
Node* TY_(FindHTML)( TidyDocImpl* doc );
Node* TY_(FindHEAD)( TidyDocImpl* doc );
Node* TY_(FindTITLE)(TidyDocImpl* doc);
Node* TY_(FindBody)( TidyDocImpl* doc );
Node* TY_(FindXmlDecl)(TidyDocImpl* doc);

/* Returns containing block element, if any */
Node* TY_(FindContainer)( Node* node );

/* add meta element for Tidy */
Bool TY_(AddGenerator)( TidyDocImpl* doc );

unsigned int TY_(ApparentVersion)( TidyDocImpl* doc );

ctmbstr TY_(HTMLVersionNameFromCode)( unsigned int vers, Bool isXhtml );

unsigned int TY_(HTMLVersionNumberFromCode)( unsigned int vers );

Bool TY_(WarnMissingSIInEmittedDocType)( TidyDocImpl* doc );

Bool TY_(SetXHTMLDocType)( TidyDocImpl* doc );


/* fixup doctype if missing */
Bool TY_(FixDocType)( TidyDocImpl* doc );

/* ensure XML document starts with <?xml version="1.0"?> */
/* add encoding attribute if not using ASCII or UTF-8 output */
Bool TY_(FixXmlDecl)( TidyDocImpl* doc );

Node* TY_(InferredTag)(TidyDocImpl* doc, TidyTagId id);

void TY_(UngetToken)( TidyDocImpl* doc );


/*
  modes for GetToken()

  MixedContent   -- for elements which don't accept PCDATA
  Preformatted   -- white space preserved as is
  IgnoreMarkup   -- for CDATA elements such as script, style
*/
typedef enum
{
  IgnoreWhitespace,
  MixedContent,
  Preformatted,
  IgnoreMarkup,
  OtherNamespace,
  CdataContent
} GetTokenMode;

Node* TY_(GetToken)( TidyDocImpl* doc, GetTokenMode mode );

void TY_(InitMap)(void);


/* create a new attribute */
AttVal* TY_(NewAttribute)( TidyDocImpl* doc );

/* create a new attribute with given name and value */
AttVal* TY_(NewAttributeEx)( TidyDocImpl* doc, ctmbstr name, ctmbstr value,
                             int delim );

/* insert attribute at the end of attribute list of a node */
void TY_(InsertAttributeAtEnd)( Node *node, AttVal *av );

/* insert attribute at the start of attribute list of a node */
void TY_(InsertAttributeAtStart)( Node *node, AttVal *av );

/*************************************
  In-line Stack functions
*************************************/


/* duplicate attributes */
AttVal* TY_(DupAttrs)( TidyDocImpl* doc, AttVal* attrs );

/*
  push a copy of an inline node onto stack
  but don't push if implicit or OBJECT or APPLET
  (implicit tags are ones generated from the istack)

  One issue arises with pushing inlines when
  the tag is already pushed. For instance:

      <p><em>text
      <p><em>more text

  Shouldn't be mapped to

      <p><em>text</em></p>
      <p><em><em>more text</em></em>
*/
void TY_(PushInline)( TidyDocImpl* doc, Node* node );

/* pop inline stack */
void TY_(PopInline)( TidyDocImpl* doc, Node* node );

Bool TY_(IsPushed)( TidyDocImpl* doc, Node* node );
Bool TY_(IsPushedLast)( TidyDocImpl* doc, Node *element, Node *node );

/*
  This has the effect of inserting "missing" inline
  elements around the contents of blocklevel elements
  such as P, TD, TH, DIV, PRE etc. This procedure is
  called at the start of ParseBlock. when the inline
  stack is not empty, as will be the case in:

    <i><h1>italic heading</h1></i>

  which is then treated as equivalent to

    <h1><i>italic heading</i></h1>

  This is implemented by setting the lexer into a mode
  where it gets tokens from the inline stack rather than
  from the input stream.
*/
int TY_(InlineDup)( TidyDocImpl* doc, Node *node );

/*
 defer duplicates when entering a table or other
 element where the inlines shouldn't be duplicated
*/
void TY_(DeferDup)( TidyDocImpl* doc );
Node* TY_(InsertedToken)( TidyDocImpl* doc );

/* stack manipulation for inline elements */
Bool TY_(SwitchInline)( TidyDocImpl* doc, Node* element, Node* node );
Bool TY_(InlineDup1)( TidyDocImpl* doc, Node* node, Node* element );

#ifdef __cplusplus
}
#endif


#endif /* __LEXER_H__ */
#ifndef __TIDY_MAPPED_IO_H__
#define __TIDY_MAPPED_IO_H__

/* Interface to mmap style I/O

   (c) 2006 (W3C) MIT, ERCIM, Keio University
   See tidy.h for the copyright notice.

*/

#if defined(_WIN32)
int TY_(DocParseFileWithMappedFile)( TidyDocImpl* doc, ctmbstr filnam );
#endif

#endif /* __TIDY_MAPPED_IO_H__ */
#ifndef __MESSAGE_H__
#define __MESSAGE_H__

/******************************************************************************
 * @file
 * Provides General Message Writing Routines
 *
 * This module handles LibTidy's high level output routines, as well as
 * provides lookup functions and management for keys used for retrieval
 * of these messages.
 *
 * LibTidy emits two general types of output:
 *
 *  - Reports, which contain data relating to what Tidy discovered in your
 *    source file, and/or what Tidy did to your source file. In some cases
 *    general information about your source file is emitted as well. Reports
 *    are emitted in the current output buffer, but LibTidy users will probably
 *    prefer to hook into a callback in order to take advantage of the data
 *    that are available in a more flexible way.
 *
 *  - Dialogue, consisting of footnotes related to your source file, and of
 *    general information that's not related to your source file in particular.
 *    This is also written to the current output buffer when appropriate, and
 *    available via callbacks.
 *
 * Report information typically takes the form of a warning, an error, info,
 * etc., and the output routines keep track of the count of these.
 *
 * The preferred way of handling Tidy diagnostics output is either
 *   - define a new output sink, or
 *   - use a message filter callback routine.
 *
 * @author  HTACG, et al (consult git log)
 * 
 * @copyright
 *     Copyright (c) 1998-2017 World Wide Web Consortium (Massachusetts
 *     Institute of Technology, European Research Consortium for Informatics
 *     and Mathematics, Keio University) and HTACG.
 * @par
 *     All Rights Reserved.
 * @par
 *     See `tidy.h` for the complete license.
 *
 * @date Additional updates: consult git log
 *
 ******************************************************************************/

/* #include "forward.h" */
/* #include "config.h" */

/** @addtogroup internal_api */
/** @{ */


/***************************************************************************//**
 ** @defgroup message_releaseinfo Tidy Release Information
 **
 ** These functions return information about the current release version date
 ** and version number. Note that the latest release date or the highest
 ** version number alone do not guarantee the latest Tidy release, as we may
 ** backport important fixes to older releases of Tidy.
 **
 ** @{
 ******************************************************************************/

/**
 *  Returns the release date of this instance of HTML Tidy.
 */
ctmbstr TY_(ReleaseDate)(void);

/** 
 *  Returns the release version of this instance of HTML Tidy.
 */
ctmbstr TY_(tidyLibraryVersion)(void);


/** @} message_releaseinfo group */


/***************************************************************************//**
 ** @defgroup message_reporting Report and Dialogue Writing Functions
 **
 ** These simple functions perform the vast majority of Tidy's output, and
 ** one these should be your first choice when adding your own output.
 **
 ** A report is typically diagnostic output that is generated each time Tidy
 ** detects an issue in your document or makes a change. A dialogue is a piece
 ** of information such as a summary, a footnote, or other non-tabular data.
 ** Some of these functions emit multiple reports or dialogue in order to
 ** effect a summary.
 **
 ** @{
 ******************************************************************************/

/** @name General Report Writing 
 ** If one of the convenience reporting functions does not fit your required
 ** message signature, then this designated reporting function will fit the
 ** bill. Be sure to see if a message formatter exists that can handle the
 ** variable arguments.
 */
/** @{ */


/**
 *  The designated report writing function. When a proper formatter exists,
 *  this one function can hanle all report output.
 */
void TY_(Report)(TidyDocImpl* doc, Node *element, Node *node, unsigned int code, ...);


/** @} */
/** @name Convenience Reporting Functions
 ** These convenience reporting functions are able to handle the bulk of Tidy's
 ** necessary reporting, and avoid the danger of using a variadic if you are
 ** unfamiliar with Tidy.
 */
/** @{ */


void TY_(ReportAccessError)( TidyDocImpl* doc, Node* node, unsigned int code );
void TY_(ReportAttrError)(TidyDocImpl* doc, Node *node, AttVal *av, unsigned int code);
void TY_(ReportBadArgument)( TidyDocImpl* doc, ctmbstr option );
void TY_(ReportEntityError)( TidyDocImpl* doc, unsigned int code, ctmbstr entity, int c );
void TY_(ReportFileError)( TidyDocImpl* doc, ctmbstr file, unsigned int code );
void TY_(ReportEncodingError)(TidyDocImpl* doc, unsigned int code, unsigned int c, Bool discarded);
void TY_(ReportEncodingWarning)(TidyDocImpl* doc, unsigned int code, unsigned int encoding);
void TY_(ReportMissingAttr)( TidyDocImpl* doc, Node* node, ctmbstr name );
void TY_(ReportSurrogateError)(TidyDocImpl* doc, unsigned int code, unsigned int c1, unsigned int c2);
void TY_(ReportUnknownOption)( TidyDocImpl* doc, ctmbstr option );


/** @} */
/** @name General Dialogue Writing
 ** These functions produce dialogue output such as individual messages, or
 ** several messages in summary form.
 */
/** @{ */


/**
 *  Emits a single dialogue message, and is capable of accepting a variadic
 *  that is passed to the correct message formatter as needed.
 */
void TY_(Dialogue)( TidyDocImpl* doc, unsigned int code, ... );


/** @} */
/** @name Output Dialogue Information */
/** @{ */


/** 
 *  Outputs the footnotes and other dialogue information after document cleanup
 *  is complete. LibTidy users might consider capturing these individually in
 *  the message callback rather than capturing this entire buffer.
 *  Called by `tidyErrorSummary()`, in console.
 *  @todo: This name is a bit misleading and should probably be renamed to
 *  indicate its focus on printing footnotes.
 */
void TY_(ErrorSummary)( TidyDocImpl* doc );


/** 
 *  Outputs document HTML version and version-related information as the final
 *  report(s) in the report table.
 *  Called by `tidyRunDiagnostics()`, from console.
 *  Called by `tidyDocReportDoctype()`, currently unused.
 */
void TY_(ReportMarkupVersion)( TidyDocImpl* doc );


/**
 *  Reports the number of warnings and errors found in the document as dialogue
 *  inforation.
 *  Called by `tidyRunDiagnostics()`, from console.
 */
void TY_(ReportNumWarnings)( TidyDocImpl* doc );


/** @} */
/** @} message_reporting group */


/***************************************************************************//**
 ** @defgroup message_mutinging Message Muting
 **
 ** Message types included in the `mute` option will be be printed in
 ** messageOut().
 **
 ** @{
 ******************************************************************************/

/** Maintains a list of messages not to display. */
typedef struct _mutedMessages {
    tidyStrings* list; /**< A list of messages that won't be output. */
    unsigned int count;        /**< Current count of the list. */
    unsigned int capacity;     /**< Current capacity of the list. */
} TidyMutedMessages;


/** Frees the list of muted messages.
 ** @param doc The Tidy document.
 */
void TY_(FreeMutedMessageList)( TidyDocImpl* doc );

/** Adds a new message ID to the list of muted messages.
 ** @param doc The Tidy document.
 ** @param opt The option that is defining the muted message.
 ** @param name The message code as a string.
 */
void TY_(DefineMutedMessage)( TidyDocImpl* doc, const TidyOptionImpl* opt, ctmbstr name );

/** Start an iterator for muted messages.
 ** @param doc The Tidy document.
 ** @returns Returns an iterator token.
 */
TidyIterator TY_(getMutedMessageList)( TidyDocImpl* doc );

/** Get the next priority attribute.
 ** @param doc The Tidy document.
 ** @param iter The iterator token.
 ** @returns The next priority attribute.
 */
ctmbstr TY_(getNextMutedMessage)( TidyDocImpl* doc, TidyIterator* iter );


/** @} message_muting group */


/***************************************************************************//**
 ** @defgroup message_keydiscovery Key Discovery
 **
 ** LibTidy users may want to use `TidyReportCallback` to enable their own
 ** localization lookup features. Because Tidy's report codes are enums the
 ** specific values can change over time. Using these functions provides the
 ** ability for LibTidy users to use LibTidy's enum values as strings for
 ** lookup purposes.
 **
 ** @{
 ******************************************************************************/

/**
 *  This function returns a string representing the enum value name that can
 *  be used as a lookup key independent of changing string values. 
 *  `TidyReportCallback` will return this general string as the report 
 *  message key.
 */
ctmbstr TY_(tidyErrorCodeAsKey)(unsigned int code);

/**
 *  Given an error code string, return the integer value of it, or UINT_MAX
 *  as an error flag.
 */
unsigned int TY_(tidyErrorCodeFromKey)(ctmbstr code);


/**
 *  Initializes the TidyIterator to point to the first item
 *  in Tidy's list of error codes that can be return with
 *  `TidyReportFilter3`.
 *  Items can be retrieved with getNextErrorCode();
 */
TidyIterator TY_(getErrorCodeList)(void);

/**
 *  Returns the next error code having initialized the iterator
 *  with `getErrorCodeList()`. You can use tidyErrorCodeAsKey
 *  to determine the key for this value.
 */
unsigned int TY_(getNextErrorCode)( TidyIterator* iter );


/** @} message_keydiscovery group */
/** @} internal_api addtogroup */



/* accessibility flaws */

#define BA_MISSING_IMAGE_ALT       1
#define BA_MISSING_LINK_ALT        2
#define BA_MISSING_SUMMARY         4
#define BA_MISSING_IMAGE_MAP       8
#define BA_USING_FRAMES            16
#define BA_USING_NOFRAMES          32
#define BA_INVALID_LINK_NOFRAMES   64  /* WAI [6.5.1.4] */  
#define BA_WAI                     (1 << 31)

/* presentation flaws */

#define USING_SPACER            1
#define USING_LAYER             2
#define USING_NOBR              4
#define USING_FONT              8
#define USING_BODY              16

/* badchar bit field */

#define BC_VENDOR_SPECIFIC_CHARS   1
#define BC_INVALID_SGML_CHARS      2
#define BC_INVALID_UTF8            4
#define BC_INVALID_UTF16           8
#define BC_ENCODING_MISMATCH       16 /* fatal error */
#define BC_INVALID_URI             32
#define BC_INVALID_NCR             64

/* other footnote bit field (temporary until formalized) */

#define FN_TRIM_EMPTY_ELEMENT     1

/* Lexer and I/O Macros */

#define REPLACED_CHAR           0
#define DISCARDED_CHAR          1


#endif /* __MESSAGE_H__ */
#ifndef messageobj_h
#define messageobj_h

/**************************************************************************//**
 * @file
 * Provides an external, extensible API for message reporting.
 *
 * This module implements the `_TidyMessageImpl` structure (declared in
 * `tidy-int.h`) in order to abstract the reporting of reports and dialogue
 * from the rest of Tidy, and to enable a robust and extensible API for
 * message interrogation by LibTidy users.
 *
 * @author    Jim Derry
 * @copyright Copyright (c) 2017 HTACG. See tidy.h for license.
 * @date      Created 2017-March-10
 *
 ******************************************************************************/

/* #include "forward.h" */

/** @addtogroup internal_api */
/** @{ */


/** @defgroup messageobj_instantiation Message Creation and Releasing */
/** @{ */


/** Creates a TidyMessageImpl, but without line numbers, such as used for
 ** information report output.
 */
TidyMessageImpl *TY_(tidyMessageCreate)( TidyDocImpl *doc,
                                         unsigned int code,
                                         TidyReportLevel level,
                                         ... );

/** Creates a TidyMessageImpl, using the line and column from the provided
 ** Node as the message position source.
 */
TidyMessageImpl *TY_(tidyMessageCreateWithNode)( TidyDocImpl *doc,
                                                 Node *node,
                                                 unsigned int code,
                                                 TidyReportLevel level,
                                                 ... );

/** Creates a TidyMessageImpl, using the line and column from the provided
 ** document's Lexer as the message position source.
 */
TidyMessageImpl *TY_(tidyMessageCreateWithLexer)( TidyDocImpl *doc,
                                                  unsigned int code,
                                                  TidyReportLevel level,
                                                  ... );

/** Deallocates a TidyMessageImpl in order to free up its allocated memory
 ** when you're done using it.
 */
void TY_(tidyMessageRelease)( TidyMessageImpl *message );


/** @} end messageobj_instantiation group */
/** @defgroup messageobj_message_api Report and Dialogue API */
/** @{ */


/** get the document the message came from. */
TidyDocImpl* TY_(getMessageDoc)( TidyMessageImpl message );

/** get the message key code. */
unsigned int TY_(getMessageCode)( TidyMessageImpl message );

/** get the message key string. */
ctmbstr TY_(getMessageKey)( TidyMessageImpl message );

/** get the line number the message applies to. */
int TY_(getMessageLine)( TidyMessageImpl message );

/** get the column the message applies to. */
int TY_(getMessageColumn)( TidyMessageImpl message );

/** get the TidyReportLevel of the message. */
TidyReportLevel TY_(getMessageLevel)( TidyMessageImpl message );

/** get whether or not the message was muted by the configuration. */
Bool TY_(getMessageIsMuted)( TidyMessageImpl message );

/** the built-in format string */
ctmbstr TY_(getMessageFormatDefault)( TidyMessageImpl message );

/** the localized format string */
ctmbstr TY_(getMessageFormat)( TidyMessageImpl message );

/** the message, formatted, default language */
ctmbstr TY_(getMessageDefault)( TidyMessageImpl message );

/** the message, formatted, localized */
ctmbstr TY_(getMessage)( TidyMessageImpl message );

/** the position part, default language */
ctmbstr TY_(getMessagePosDefault)( TidyMessageImpl message );

/** the position part, localized */
ctmbstr TY_(getMessagePos)( TidyMessageImpl message );

/** the prefix part, default language */
ctmbstr TY_(getMessagePrefixDefault)( TidyMessageImpl message );

/** the prefix part, localized */
ctmbstr TY_(getMessagePrefix)( TidyMessageImpl message );

/** the complete message, as would be output in the CLI */
ctmbstr TY_(getMessageOutputDefault)( TidyMessageImpl message );

/* the complete message, as would be output in the CLI, localized */
ctmbstr TY_(getMessageOutput)( TidyMessageImpl message );


/** @} end messageobj_message_api group */
/** @defgroup messageobj_args_api Report Arguments Interrogation API */
/** @{ */

/**
 *  Initializes the TidyIterator to point to the first item in the message's
 *  argument. Use `TY_(getNextMEssageArgument)` to get an opaque instance of
 *  `TidyMessageArgument` for which the subsequent interrogators will be of use.
 */
TidyIterator TY_(getMessageArguments)( TidyMessageImpl message );

/**
 *  Returns the next `TidyMessageArgument`, for the given message, which can
 *  then be interrogated with the API, and advances the iterator.
 */
TidyMessageArgument TY_(getNextMessageArgument)( TidyMessageImpl message, TidyIterator* iter );


/**
 *  Returns the `TidyFormatParameterType` of the given message argument.
 */
TidyFormatParameterType TY_(getArgType)( TidyMessageImpl message, TidyMessageArgument* arg );


/**
 *  Returns the format specifier of the given message argument. The memory for
 *  this string is cleared upon termination of the callback, so do be sure to
 *  make your own copy.
 */
ctmbstr TY_(getArgFormat)( TidyMessageImpl message, TidyMessageArgument* arg );


/**
 *  Returns the string value of the given message argument. An assertion
 *  will be generated if the argument type is not a string.
 */
ctmbstr TY_(getArgValueString)( TidyMessageImpl message, TidyMessageArgument* arg );


/**
 *  Returns the unsigned integer value of the given message argument. An
 *  assertion will be generated if the argument type is not an unsigned
 *  integer.
 */
unsigned int TY_(getArgValueUInt)( TidyMessageImpl message, TidyMessageArgument* arg );


/**
 *  Returns the integer value of the given message argument. An assertion
 *  will be generated if the argument type is not an integer.
 */
int TY_(getArgValueInt)( TidyMessageImpl message, TidyMessageArgument* arg );


/**
 *  Returns the double value of the given message argument. An assertion
 *  will be generated if the argument type is not a double.
 */
double TY_(getArgValueDouble)( TidyMessageImpl message, TidyMessageArgument* arg );


/** @} end messageobj_args_api group */
/** @} end internal_api group */

#endif /* messageobj_h */
#ifndef __PARSER_H__
#define __PARSER_H__

/**************************************************************************//**
 * @file
 * HTML and XML Parsers.
 *
 * Tidy's HTML parser corrects many conditions and enforces certain user
 * preferences during the parsing process. The XML parser produces a tree
 * of nodes useful to Tidy but also suitable for use in other XML processing
 * applications.
 *
 * @author  HTACG, et al (consult git log)
 *
 * @copyright
 *     Copyright (c) 1998-2017 World Wide Web Consortium (Massachusetts
 *     Institute of Technology, European Research Consortium for Informatics
 *     and Mathematics, Keio University) and HTACG.
 * @par
 *     All Rights Reserved.
 * @par
 *     See `tidy.h` for the complete license.
 *
 * @date Additional updates: consult git log
 *
 ******************************************************************************/

/* #include "forward.h" */

/** @addtogroup internal_api */
/** @{ */


/***************************************************************************//**
 ** @defgroup parser_h HTML and XML Parsing
 **
 ** These functions and structures form the internal API for document
 ** parsing.
 **
 ** @{
 ******************************************************************************/


/**
 *  Is used to perform a node integrity check recursively after parsing
 *  an HTML or XML document.
 *  @note Actual performance of this check can be disabled by defining the
 *  macro NO_NODE_INTEGRITY_CHECK.
 *  @param node The root node for the integrity check.
 *  @returns Returns yes or no indicating integrity of the node structure.
 */
Bool TY_(CheckNodeIntegrity)(Node *node);


/**
 *  Indicates whether or not a text node ends with a space or newline.
 *  @note Implementation of this method is found in `pprint.c` for
 *  some reason.
 *  @param lexer A reference to the lexer used to lex the document.
 *  @param node The node to check.
 *  @returns The result of the check.
 */
Bool TY_(TextNodeEndWithSpace)( Lexer *lexer, Node *node );


/**
 *  Used to check if a node uses CM_NEW, which determines how attributes
 *  without values should be printed. This was introduced to deal with
 *  user-defined tags e.g. ColdFusion.
 *  @param node The node to check.
 *  @returns The result of the check.
 */
Bool TY_(IsNewNode)(Node *node);


/**
 *  Transforms a given node to another element, for example, from a `p`
 *  to a `br`.
 *  @param doc The document which the node belongs to.
 *  @param node The node to coerce.
 *  @param tid The tag type to coerce the node into.
 *  @param obsolete If the old node was obsolete, a report will be generated.
 *  @param expected If the old node was not expected to be found in this
 *    particular location, a report will be generated.
 */
void TY_(CoerceNode)(TidyDocImpl* doc, Node *node, TidyTagId tid, Bool obsolete, Bool expected);


/**
 *  Extract a node and its children from a markup tree.
 *  @param node The node to remove.
 *  @returns Returns the removed node.
 */
Node *TY_(RemoveNode)(Node *node);


/**
 *  Remove node from markup tree and discard it.
 *  @param doc The Tidy document from which to discarb the node.
 *  @param element The node to discard.
 *  @returns Returns the next node.
 */
Node *TY_(DiscardElement)( TidyDocImpl* doc, Node *element);


/**
 *  Insert node into markup tree as the firt element of content of element.
 *  @param element The new destination node.
 *  @param node The node to insert.
 */
void TY_(InsertNodeAtStart)(Node *element, Node *node);


/**
 *  Insert node into markup tree as the last element of content of element.
 *  @param element The new destination node.
 *  @param node The node to insert.
 */
void TY_(InsertNodeAtEnd)(Node *element, Node *node);


/**
 *  Insert node into markup tree before element.
 *  @param element The node before which the node is inserted.
 *  @param node The node to insert.
 */
void TY_(InsertNodeBeforeElement)(Node *element, Node *node);


/**
 *  Insert node into markup tree after element.
 *  @param element The node after which the node is inserted.
 *  @param node The node to insert.
 */
void TY_(InsertNodeAfterElement)(Node *element, Node *node);


/**
 *  Trims a single, empty element, returning the next node.
 *  @param doc The Tidy document.
 *  @param element The element to trim.
 *  @returns Returns the next node.
 */
Node *TY_(TrimEmptyElement)( TidyDocImpl* doc, Node *element );


/**
 *  Trims a tree of empty elements recursively, returning the next node.
 *  @param doc The Tidy document.
 *  @param node The element to trim.
 *  @returns Returns the next node.
 */
Node* TY_(DropEmptyElements)(TidyDocImpl* doc, Node* node);


/**
 *  Indicates whether or not a text node is blank, meaning that it consists
 *  of nothing, or a single space.
 *  @param lexer The lexer used to lex the document.
 *  @param node The node to test.
 *  @returns Returns the result of the test.
 */
Bool TY_(IsBlank)(Lexer *lexer, Node *node);


/**
 *  Indicates whether or not a node is declared as containing javascript
 *  code.
 *  @param node The node to test.
 *  @returns Returns the result of the test.
 */
Bool TY_(IsJavaScript)(Node *node);


/**
 *  Parses a document after lexing using the HTML parser. It begins by properly
 *  configuring the overall HTML structure, and subsequently processes all
 *  remaining nodes. HTML is the root node.
 *  @param doc The Tidy document.
 */
void TY_(ParseDocument)( TidyDocImpl* doc );


/**
 *  Indicates whether or not whitespace is to be preserved in XHTML/XML
 *  documents.
 *  @param doc The Tidy document.
 *  @param element The node to test.
 *  @returns Returns the result of the test.
 */
Bool TY_(XMLPreserveWhiteSpace)( TidyDocImpl* doc, Node *element );


/**
 *  Parses a document after lexing using the XML parser.
 *  @param doc The Tidy document.
 */
void TY_(ParseXMLDocument)( TidyDocImpl* doc );


/** @} end parser_h group */
/** @} end internal_api group */

#endif /* __PARSER_H__ */

#ifndef __PPRINT_H__
#define __PPRINT_H__

/* pprint.h -- pretty print parse tree  
  
   (c) 1998-2007 (W3C) MIT, ERCIM, Keio University
   See tidy.h for the copyright notice.
  
*/

/* #include "forward.h" */

/*
  Block-level and unknown elements are printed on
  new lines and their contents indented 2 spaces

  Inline elements are printed inline.

  Inline content is wrapped on spaces (except in
  attribute values or preformatted text, after
  start tags and before end tags
*/

#define NORMAL        0u
#define PREFORMATTED  1u
#define COMMENT       2u
#define ATTRIBVALUE   4u
#define NOWRAP        8u
#define CDATA         16u


/* The pretty printer keeps at most two lines of text in the
** buffer before flushing output.  We need to capture the
** indent state (indent level) at the _beginning_ of _each_
** line, not the end of just the second line.
**
** We must also keep track "In Attribute" and "In String"
** states at the _end_ of each line, 
*/

typedef struct _TidyIndent
{
    int spaces;
    int attrValStart;
    int attrStringStart;
} TidyIndent;

typedef struct _TidyPrintImpl
{
    TidyAllocator *allocator; /* Allocator */

    unsigned int *linebuf;
    unsigned int lbufsize;
    unsigned int linelen;
    unsigned int wraphere;
    unsigned int line;
  
    unsigned int ixInd;
    TidyIndent indent[2];  /* Two lines worth of indent state */
} TidyPrintImpl;


void TY_(InitPrintBuf)( TidyDocImpl* doc );
void TY_(FreePrintBuf)( TidyDocImpl* doc );

void TY_(PFlushLine)( TidyDocImpl* doc, unsigned int indent );


/* print just the content of the body element.
** useful when you want to reuse material from
** other documents.
** 
** -- Sebastiano Vigna <vigna@dsi.unimi.it>
*/

void TY_(PrintBody)( TidyDocImpl* doc );       /* you can print an entire document */
                                          /* node as body using PPrintTree() */

void TY_(PPrintTree)( TidyDocImpl* doc, unsigned int mode, unsigned int indent, Node *node );

void TY_(PPrintXMLTree)( TidyDocImpl* doc, unsigned int mode, unsigned int indent, Node *node );

/*\
 * 20150515 - support using tabs instead of spaces
\*/
void TY_(PPrintTabs)(void);
void TY_(PPrintSpaces)(void);

#endif /* __PPRINT_H__ */
#ifndef _SPRTF_HXX_
#define _SPRTF_HXX_

/**************************************************************************//**
 * @file
 * Log output utility - part of the HTML Tidy project
 *
 * @author  Geoff R. McLane [reports _at_ geoffair _dot_ info]
 *
 * @copyright
 *     Copyright (c) 1998-2017 Geoff R. McLane and HTACG.
 * @par
 *     All Rights Reserved.
 * @par
 *     See `tidy.h` for the complete license.
 *
 * @date 2017/02/12 17:06:02 Revision 1.0.2  geoff - correct license and coding style
 * @date 2012/11/06 13:01:25 Revision 1.0.1  geoff
 * @date 2012/10/17 00:00:00 Revision 1.0.0  geoff
 * @date Additional updates: consult git log
 *
 ******************************************************************************/

/* #include "tidyplatform.h" */

#ifdef   __cplusplus
extern "C" {
#endif
#ifdef ENABLE_DEBUG_LOG
    /*=============================================================================
    * EXTRA Debugging, and information aid.
    *
    *  When building and defining the ENABLE_DEBUG_LOG macro, Tidy will output
    *  extensive debug information. In addition to this macro, you can supply
    *  cmake build flags for additional diagnostic information:
    *    - -DENABLE_ALLOC_DEBUG:BOOL=ON   - DEBUG_ALLOCATION
    *    - -DENABLE_MEMORY_DEBUG:BOOL=ON  - DEBUG_MEMORY
    *    - -DENABLE_CRTDBG_MEMORY:BOOL=ON - _CRTDBG_MAP_ALLOC (WIN32 only)
    *
    *  _MSC_VER Only - ENABLE_DEBUG_LOG is automatically enabled in the Debug
    *  build, unless DISABLE_DEBUG_LOG is defined. See 'tidyplatform.h'
    *
    *  You can use DEBUG_LOG( SPRTF() ) to avoid #ifdef ENABLE_DEBUG_LOG for
    *  one-liners.
    *
    *  This EXTRA Debug information is also written to a 'temptidy.txt' log
    *  file, for review, and analysis.
    *
    *===========================================================================*/

#ifndef SPRTF
#  define SPRTF sprtf
#endif

#ifdef _MSC_VER
#  define MCDECL _cdecl
#else
#  define MCDECL
#endif

TIDY_EXPORT int add_std_out( int val );
TIDY_EXPORT int add_sys_time( int val );
TIDY_EXPORT int add_sys_date( int val );

TIDY_EXPORT int add_screen_out( int val );
TIDY_EXPORT int add_list_out( int val );
TIDY_EXPORT int add_append_log( int val );

TIDY_EXPORT int open_log_file( void );
TIDY_EXPORT void close_log_file( void );
TIDY_EXPORT void set_log_file( char * nf, int open );
TIDY_EXPORT char * get_log_file( void );

TIDY_EXPORT int MCDECL sprtf( const char *pf, ... );
#define M_MAX_SPRTF 2048
TIDY_EXPORT int direct_out_it( char *cp );

TIDY_EXPORT char *GetNxtBuf(void);

#define EndBuf(a)   ( a + strlen(a) )

TIDY_EXPORT char *get_date_stg(void);
TIDY_EXPORT char *get_time_stg(void);
TIDY_EXPORT char *get_date_time_stg(void);

#ifdef _MSC_VER
TIDY_EXPORT int gettimeofday(struct timeval *tp, void *tzp);
#endif

#  define DEBUG_LOG(ARG) do { ARG; } while(0)

#else
#  define DEBUG_LOG(ARG)
#endif

#ifdef   __cplusplus
}
#endif
#endif /* #ifndef _SPRTF_HXX_*/
/* eof - sprtf.h */
#ifndef __TAGS_H__
#define __TAGS_H__

/**************************************************************************//**
 * @file
 * Recognize HTML Tags.
 *
 * The HTML tags are stored as 8 bit ASCII strings.
 * Use lookupw() to find a tag given a wide char string.
 *
 * @author  HTACG, et al (consult git log)
 *
 * @copyright
 *     Copyright (c) 1998-2017 World Wide Web Consortium (Massachusetts
 *     Institute of Technology, European Research Consortium for Informatics
 *     and Mathematics, Keio University) and HTACG.
 * @par
 *     All Rights Reserved.
 * @par
 *     See `tidy.h` for the complete license.
 *
 * @date Additional updates: consult git log
 *
 ******************************************************************************/

/* #include "forward.h" */
/* #include "attrdict.h" */

/** @addtogroup internal_api */
/** @{ */


/***************************************************************************//**
 ** @defgroup tags_h HTML Tags
 **
 ** This module organizes all of Tidy's HTML tag operations, such as parsing
 ** tags, defining tags, and user-defined tags.
 **
 ** @{
 ******************************************************************************/


/** @name Basic Structures and Tag Operations.
 ** These structures form the backbone of Tidy tag processing, and the
 ** functions in this group provide basic operations with tags and nodes.
 */
/** @{ */


/** This enumeration defines the types of user-defined tags that can be
 ** created.
 */
typedef enum
{
    tagtype_null = 0,   /**< First item marker. */
    tagtype_empty = 1,  /**< Tag is an empty element. */
    tagtype_inline = 2, /**< Tag is an inline element. */
    tagtype_block = 4,  /**< Tag is a block level element. */
    tagtype_pre = 8     /**< Tag is a preformatted tag. */
} UserTagType;


/** This typedef describes a function to be used to parse HTML of a Tidy tag.
 */
typedef void (Parser)( TidyDocImpl* doc, Node *node, GetTokenMode mode );


/** This typedef describes a function be be used to check the attributes
 ** of a Tidy tag.
 */
typedef void (CheckAttribs)( TidyDocImpl* doc, Node *node );


/** Defines a dictionary entry for a single Tidy tag, including all of the
 ** relevant information that it requires.
 */
struct _Dict
{
    TidyTagId           id;       /**< Identifier for this tag. */
    tmbstr              name;     /**< The tag name. */
    unsigned int                versions; /**< Accumulates potential HTML versions. See TY_(ConstrainVersion). */
    AttrVersion const * attrvers; /**< Accumulates potential HTML versions for attributes. */
    unsigned int                model;    /**< Indicates the relevant content models for the tag. See lexer.h; there is no enum. */
    Parser*             parser;   /**< Specifies the parser to use for this tag. */
    CheckAttribs*       chkattrs; /**< Specifies the function to check this tag's attributes. */
    Dict*               next;     /**< Link to next tag. */
};


/** This enum indicates the maximum size of the has table for tag hash lookup.
 */
enum
{
    ELEMENT_HASH_SIZE=178u  /**< Maximum number of tags in the hash table. */
};


/** This structure provide hash lookup for Tidy tags.
 */
typedef struct _DictHash
{
    Dict const*         tag;   /**< The current tag. */
    struct _DictHash*   next;  /**< The next tag. */
} DictHash;


/** This structure consists of the lists of all tags known to Tidy.
 */
typedef struct _TidyTagImpl
{
    Dict* xml_tags;                        /**< Placeholder for all xml tags. */
    Dict* declared_tag_list;               /**< User-declared tags. */
    DictHash* hashtab[ELEMENT_HASH_SIZE];  /**< All of Tidy's built-in tags. */
} TidyTagImpl;


/** Coordinates Config update and Tags data.
 ** @param doc The Tidy document.
 ** @param opt The option the tag is intended for.
 ** @param name The name of the new tag.
 */
void TY_(DeclareUserTag)( TidyDocImpl* doc, const TidyOptionImpl* opt, ctmbstr name );


/** Interface for finding a tag by TidyTagId.
 ** @param tid The TidyTagId to search for.
 ** @returns An instance of a Tidy tag.
 */
const Dict* TY_(LookupTagDef)( TidyTagId tid );

/** Assigns the node's tag.
 ** @param doc The Tidy document.
 ** @param node The node to assign the tag to.
 ** @returns Returns a bool indicating whether or not the tag was assigned.
 */
Bool    TY_(FindTag)( TidyDocImpl* doc, Node *node );


/** Finds the parser function for a given node.
 ** @param doc The Tidy document.
 ** @param node The node to lookup.
 ** @returns The parser for the given node.
 */
Parser* TY_(FindParser)( TidyDocImpl* doc, Node *node );


/** Defines a new user-defined tag.
 ** @param doc The Tidy document.
 ** @param tagType The type of user-defined tag to define.
 ** @param name The name of the new tag.
 */
void    TY_(DefineTag)( TidyDocImpl* doc, UserTagType tagType, ctmbstr name );


/** Frees user-defined tags of the given type, or all user tags in given
 ** `tagtype_null`.
 ** @param doc The Tidy document.
 ** @param tagType The type of tag to free, or `tagtype_null` to free all
 **        user-defined tags.
 */
void    TY_(FreeDeclaredTags)( TidyDocImpl* doc, UserTagType tagType );


/** Initiates an iterator for a list of user-declared tags, including autonomous
 ** custom tags detected in the document if @ref TidyUseCustomTags is not set to
 ** **no**.
 ** @param doc An instance of a TidyDocImp to query.
 ** @result Returns a TidyIterator, which is a token used to represent the
 **         current position in a list within LibTidy.
 */
TidyIterator   TY_(GetDeclaredTagList)( TidyDocImpl* doc );


/** Given a valid TidyIterator initiated with TY_(GetDeclaredTagList)(),
 ** returns a string representing a user-declared or autonomous custom tag.
 ** @remark Specifying tagType limits the scope of the tags to one of
 **         @ref UserTagType types. Note that autonomous custom tags (if used)
 **         are added to one of these option types, depending on the value of
 **         @ref TidyUseCustomTags.
 ** @param doc The Tidy document.
 ** @param tagType The type of tag to iterate through.
 ** @param iter The iterator token provided initially by
 **        TY_(GetDeclaredTagList)().
 ** @result A string containing the next tag.
 */
ctmbstr        TY_(GetNextDeclaredTag)( TidyDocImpl* doc, UserTagType tagType,
                                        TidyIterator* iter );


/** Initializes tags and tag structures for the given Tidy document.
 ** @param doc The Tidy document.
 */
void TY_(InitTags)( TidyDocImpl* doc );


/** Frees the tags and structures used by Tidy for tags.
 ** @param doc The Tidy document.
 */
void TY_(FreeTags)( TidyDocImpl* doc );


/** Tidy defaults to HTML5 mode. If the <!DOCTYPE ...> is found to NOT be
 ** HTML5, then adjust the tags table to HTML4 mode.
 ** @param doc The Tidy document.
 */
void TY_(AdjustTags)( TidyDocImpl *doc );


/** Reset the tags table back to default HTML5 mode.
 ** @param doc The Tidy document.
 */
void TY_(ResetTags)( TidyDocImpl *doc );


/** Indicates whether or not the Tidy is procesing in HTML5 mode.
 ** @param doc The Tidy document.
 ** @returns Returns `yes` if processing in HTML5 mode.
 */
Bool TY_(IsHTML5Mode)( TidyDocImpl *doc );


/** @} */
/** @name Parser Methods And Attribute Checker Functions for Tags
 ** These functions define the parsers and attribute checking functions for
 ** each of Tidy's tags.
 */
/** @{ */


Parser TY_(ParseHTML);
Parser TY_(ParseHead);
Parser TY_(ParseTitle);
Parser TY_(ParseScript);
Parser TY_(ParseFrameSet);
Parser TY_(ParseNoFrames);
Parser TY_(ParseBody);
Parser TY_(ParsePre);
Parser TY_(ParseList);
Parser TY_(ParseDefList);
Parser TY_(ParseBlock);
Parser TY_(ParseInline);
Parser TY_(ParseEmpty);
Parser TY_(ParseTableTag);
Parser TY_(ParseColGroup);
Parser TY_(ParseRowGroup);
Parser TY_(ParseRow);
Parser TY_(ParseSelect);
Parser TY_(ParseOptGroup);
Parser TY_(ParseText);
Parser TY_(ParseDatalist);
Parser TY_(ParseNamespace);

CheckAttribs TY_(CheckAttributes);


/** @} */
/** @name Other Tag and Node Lookup Functions
 ** These functions perform additional lookup on tags and nodes.
 */
/** @{ */


/** Gets the TidyTagId of the given node. 0 == TidyTag_UNKNOWN.
 */
#define TagId(node)        ((node) && (node)->tag ? (node)->tag->id : TidyTag_UNKNOWN)


/** Determines if the given node is of the given tag id type.
 */
#define TagIsId(node, tid) ((node) && (node)->tag && (node)->tag->id == tid)


/** Inquires whether or not the given node is a text node.
 ** @param node The node being interrogated.
 ** @returns The status of the inquiry.
 */
Bool TY_(nodeIsText)( Node* node );


/** Inquires whether or not the given node is an element node.
 ** @param node The node being interrogated.
 ** @returns The status of the inquiry.
 */
Bool TY_(nodeIsElement)( Node* node );


/** Inquires whether or not the given node has any text.
 ** @param doc The Tidy document.
 ** @param node The node being interrogated.
 ** @returns The status of the inquiry.
 */
Bool TY_(nodeHasText)( TidyDocImpl* doc, Node* node );


/** Inquires whether the given element looks like it's an autonomous custom
 ** element tag.
 ** @param element A string to be checked.
 ** @returns The status of the inquiry.
 */
Bool TY_(elementIsAutonomousCustomFormat)( ctmbstr element );


/** Inquires whether the given node looks like it's an autonomous custom
 ** element tag.
 ** @param node The node being interrogated.
 ** @returns The status of the inquiry.
 */
Bool TY_(nodeIsAutonomousCustomFormat)( Node* node );


/** True if the node looks like it's an autonomous custom element tag, and
 ** TidyCustomTags is not disabled, and we're in HTML5 mode, which are all
 ** requirements for valid autonomous custom tags.
 ** @param doc The Tidy document.
 ** @param node The node being interrogated.
 ** @returns The status of the inquiry.
 */
Bool TY_(nodeIsAutonomousCustomTag)( TidyDocImpl* doc, Node* node );


/** Does the node have the indicated content model? True if any of the bits
 ** requested are set.
 ** @param node The node being interrogated.
 ** @param contentModel The content model to check against.
 ** @returns The status of the inquiry.
 */
Bool TY_(nodeHasCM)( Node* node, unsigned int contentModel );


/** Does the content model of the node include block?
 ** @param node The node being interrogated.
 ** @returns The status of the inquiry.
 */
Bool TY_(nodeCMIsBlock)( Node* node );


/** Does the content model of the node include inline?
 ** @param node The node being interrogated.
 ** @returns The status of the inquiry.
 */
Bool TY_(nodeCMIsInline)( Node* node );


/** Does the content model of the node include empty?
 ** @param node The node being interrogated.
 ** @returns The status of the inquiry.
 */
Bool TY_(nodeCMIsEmpty)( Node* node );


/** Is the node a header, such as H1, H2, ..., H6?
 ** @param node The node being interrogated.
 ** @returns The status of the inquiry.
 */
Bool TY_(nodeIsHeader)( Node* node );


/** Inquires as to the header level of the given node: 1, 2, ..., 6.
 ** @param node The node being interrogated.
 ** @returns The header level.
 */
unsigned int TY_(nodeHeaderLevel)( Node* node );


#define nodeIsHTML( node )       TagIsId( node, TidyTag_HTML )
#define nodeIsHEAD( node )       TagIsId( node, TidyTag_HEAD )
#define nodeIsTITLE( node )      TagIsId( node, TidyTag_TITLE )
#define nodeIsBASE( node )       TagIsId( node, TidyTag_BASE )
#define nodeIsMETA( node )       TagIsId( node, TidyTag_META )
#define nodeIsBODY( node )       TagIsId( node, TidyTag_BODY )
#define nodeIsFRAMESET( node )   TagIsId( node, TidyTag_FRAMESET )
#define nodeIsFRAME( node )      TagIsId( node, TidyTag_FRAME )
#define nodeIsIFRAME( node )     TagIsId( node, TidyTag_IFRAME )
#define nodeIsNOFRAMES( node )   TagIsId( node, TidyTag_NOFRAMES )
#define nodeIsHR( node )         TagIsId( node, TidyTag_HR )
#define nodeIsH1( node )         TagIsId( node, TidyTag_H1 )
#define nodeIsH2( node )         TagIsId( node, TidyTag_H2 )
#define nodeIsPRE( node )        TagIsId( node, TidyTag_PRE )
#define nodeIsLISTING( node )    TagIsId( node, TidyTag_LISTING )
#define nodeIsP( node )          TagIsId( node, TidyTag_P )
#define nodeIsUL( node )         TagIsId( node, TidyTag_UL )
#define nodeIsOL( node )         TagIsId( node, TidyTag_OL )
#define nodeIsDL( node )         TagIsId( node, TidyTag_DL )
#define nodeIsDIR( node )        TagIsId( node, TidyTag_DIR )
#define nodeIsLI( node )         TagIsId( node, TidyTag_LI )
#define nodeIsDT( node )         TagIsId( node, TidyTag_DT )
#define nodeIsDD( node )         TagIsId( node, TidyTag_DD )
#define nodeIsTABLE( node )      TagIsId( node, TidyTag_TABLE )
#define nodeIsCAPTION( node )    TagIsId( node, TidyTag_CAPTION )
#define nodeIsTD( node )         TagIsId( node, TidyTag_TD )
#define nodeIsTH( node )         TagIsId( node, TidyTag_TH )
#define nodeIsTR( node )         TagIsId( node, TidyTag_TR )
#define nodeIsCOL( node )        TagIsId( node, TidyTag_COL )
#define nodeIsCOLGROUP( node )   TagIsId( node, TidyTag_COLGROUP )
#define nodeIsBR( node )         TagIsId( node, TidyTag_BR )
#define nodeIsA( node )          TagIsId( node, TidyTag_A )
#define nodeIsLINK( node )       TagIsId( node, TidyTag_LINK )
#define nodeIsB( node )          TagIsId( node, TidyTag_B )
#define nodeIsI( node )          TagIsId( node, TidyTag_I )
#define nodeIsSTRONG( node )     TagIsId( node, TidyTag_STRONG )
#define nodeIsEM( node )         TagIsId( node, TidyTag_EM )
#define nodeIsBIG( node )        TagIsId( node, TidyTag_BIG )
#define nodeIsSMALL( node )      TagIsId( node, TidyTag_SMALL )
#define nodeIsPARAM( node )      TagIsId( node, TidyTag_PARAM )
#define nodeIsOPTION( node )     TagIsId( node, TidyTag_OPTION )
#define nodeIsOPTGROUP( node )   TagIsId( node, TidyTag_OPTGROUP )
#define nodeIsIMG( node )        TagIsId( node, TidyTag_IMG )
#define nodeIsMAP( node )        TagIsId( node, TidyTag_MAP )
#define nodeIsAREA( node )       TagIsId( node, TidyTag_AREA )
#define nodeIsNOBR( node )       TagIsId( node, TidyTag_NOBR )
#define nodeIsWBR( node )        TagIsId( node, TidyTag_WBR )
#define nodeIsFONT( node )       TagIsId( node, TidyTag_FONT )
#define nodeIsLAYER( node )      TagIsId( node, TidyTag_LAYER )
#define nodeIsSPACER( node )     TagIsId( node, TidyTag_SPACER )
#define nodeIsCENTER( node )     TagIsId( node, TidyTag_CENTER )
#define nodeIsSTYLE( node )      TagIsId( node, TidyTag_STYLE )
#define nodeIsSCRIPT( node )     TagIsId( node, TidyTag_SCRIPT )
#define nodeIsNOSCRIPT( node )   TagIsId( node, TidyTag_NOSCRIPT )
#define nodeIsFORM( node )       TagIsId( node, TidyTag_FORM )
#define nodeIsTEXTAREA( node )   TagIsId( node, TidyTag_TEXTAREA )
#define nodeIsBLOCKQUOTE( node ) TagIsId( node, TidyTag_BLOCKQUOTE )
#define nodeIsAPPLET( node )     TagIsId( node, TidyTag_APPLET )
#define nodeIsOBJECT( node )     TagIsId( node, TidyTag_OBJECT )
#define nodeIsDIV( node )        TagIsId( node, TidyTag_DIV )
#define nodeIsSPAN( node )       TagIsId( node, TidyTag_SPAN )
#define nodeIsINPUT( node )      TagIsId( node, TidyTag_INPUT )
#define nodeIsQ( node )          TagIsId( node, TidyTag_Q )
#define nodeIsLABEL( node )      TagIsId( node, TidyTag_LABEL )
#define nodeIsH3( node )         TagIsId( node, TidyTag_H3 )
#define nodeIsH4( node )         TagIsId( node, TidyTag_H4 )
#define nodeIsH5( node )         TagIsId( node, TidyTag_H5 )
#define nodeIsH6( node )         TagIsId( node, TidyTag_H6 )
#define nodeIsADDRESS( node )    TagIsId( node, TidyTag_ADDRESS )
#define nodeIsXMP( node )        TagIsId( node, TidyTag_XMP )
#define nodeIsSELECT( node )     TagIsId( node, TidyTag_SELECT )
#define nodeIsBLINK( node )      TagIsId( node, TidyTag_BLINK )
#define nodeIsMARQUEE( node )    TagIsId( node, TidyTag_MARQUEE )
#define nodeIsEMBED( node )      TagIsId( node, TidyTag_EMBED )
#define nodeIsBASEFONT( node )   TagIsId( node, TidyTag_BASEFONT )
#define nodeIsISINDEX( node )    TagIsId( node, TidyTag_ISINDEX )
#define nodeIsS( node )          TagIsId( node, TidyTag_S )
#define nodeIsSTRIKE( node )     TagIsId( node, TidyTag_STRIKE )
#define nodeIsSUB( node )        TagIsId( node, TidyTag_SUB )
#define nodeIsSUP( node )        TagIsId( node, TidyTag_SUP )
#define nodeIsU( node )          TagIsId( node, TidyTag_U )
#define nodeIsMENU( node )       TagIsId( node, TidyTag_MENU )
#define nodeIsMAIN( node )       TagIsId( node, TidyTag_MAIN )
#define nodeIsBUTTON( node )     TagIsId( node, TidyTag_BUTTON )
#define nodeIsCANVAS( node )     TagIsId( node, TidyTag_CANVAS )
#define nodeIsPROGRESS( node )   TagIsId( node, TidyTag_PROGRESS )

#define nodeIsINS( node )        TagIsId( node, TidyTag_INS )
#define nodeIsDEL( node )        TagIsId( node, TidyTag_DEL )

/* HTML5 */
#define nodeIsDATALIST( node )   TagIsId( node, TidyTag_DATALIST )
#define nodeIsDATA( node )       TagIsId( node, TidyTag_DATA )
#define nodeIsMATHML( node )     TagIsId( node, TidyTag_MATHML ) /* #130 MathML attr and entity fix! */

/* NOT in HTML 5 */
#define nodeIsACRONYM( node )    TagIsId( node, TidyTag_ACRONYM )
#define nodesIsFRAME( node )     TagIsId( node, TidyTag_FRAME )
#define nodeIsTT( node )         TagIsId( node, TidyTag_TT )


/** @} name */
/** @} tags_h group */
/** @} internal_api addtogroup */


#endif /* __TAGS_H__ */
#ifndef __TIDY_INT_H__
#define __TIDY_INT_H__

/* tidy-int.h -- internal library declarations

  (c) 1998-2007 (W3C) MIT, ERCIM, Keio University
  See tidy.h for the copyright notice.

*/

/* #include "tidy.h" */
/* #include "config.h" */
/* #include "lexer.h" */
/* #include "tags.h" */
/* #include "attrs.h" */
/* #include "pprint.h" */
/* #include "access.h" */
/* #include "message.h" */

#ifndef MAX
#define MAX(a,b) (((a) > (b))?(a):(b))
#endif
#ifndef MIN
#define MIN(a,b) (((a) < (b))?(a):(b))
#endif

/*\
 *  Issue #166 - repeated <main> element
 *  Change the previous on/off unsigned int flag badForm
 *  to a BIT flag to support other than <form>
 *  errors. This could be extended more...
\*/
#define flg_BadForm     0x00000001
#define flg_BadMain     0x00000002

struct _TidyDocImpl
{
    /* The Document Tree (and backing store buffer) */
    Node                root;       /* This MUST remain the first declared 
                                       variable in this structure */
    Lexer*              lexer;

    /* Config + Markup Declarations */
    TidyConfigImpl          config;
    TidyTagImpl             tags;
    TidyAttribImpl          attribs;
    TidyAccessImpl          access;
    TidyMutedMessages       muted;

    /* The Pretty Print buffer */
    TidyPrintImpl       pprint;

    /* I/O */
    StreamIn*                docIn;
    StreamOut*               docOut;
    StreamOut*               errout;
    TidyReportFilter         reportFilter;
    TidyReportCallback       reportCallback;
    TidyMessageCallback      messageCallback;
    TidyOptCallback          pOptCallback;
    TidyConfigCallback       pConfigCallback;
    TidyConfigChangeCallback pConfigChangeCallback;
    TidyPPProgress           progressCallback;

    /* Parse + Repair Results */
    unsigned int                optionErrors;
    unsigned int                errors;
    unsigned int                warnings;
    unsigned int                accessErrors;
    unsigned int                infoMessages;
    unsigned int                docErrors;
    int                 parseStatus;

    unsigned int                badAccess;   /* for accessibility errors */
    unsigned int                badLayout;   /* for bad style errors */
    unsigned int                badChars;    /* for bad char encodings */
    unsigned int                badForm;     /* bit field, for badly placed form tags, or other format errors */
    unsigned int                footnotes;   /* bit field, for other footnotes, until formalized */

    Bool                HTML5Mode;   /* current mode is html5 */
    Bool                xmlDetected; /* true if XML was used/detected */

    /* Memory allocator */
    TidyAllocator*      allocator;

    /* Miscellaneous */
    void*               appData;
    unsigned int                nClassId;
    Bool                inputHadBOM;

#if PRESERVE_FILE_TIMES
    struct utimbuf      filetimes;
#endif
    tmbstr              givenDoctype;
};

/** The basic struct for communicating a message within LibTidy. All of the
**  relevant information pertaining to a message can be retrieved with the
**  accessor functions and one of these records.
*/
struct _TidyMessageImpl
{
    TidyDocImpl         *tidyDoc;     /* document instance this message is attributed to */
    Node                *tidyNode;    /* the node reporting the message, if applicable */
    unsigned int                code;         /* the message code */
    int                 line;         /* the line message applies to */
    int                 column;       /* the column the message applies to */
    TidyReportLevel     level;        /* the severity level of the message */
    Bool                allowMessage; /* indicates whether or not a filter rejected a message */
    Bool                muted;        /* indicates whether or not a configuration mutes this message */
    
    int                 argcount;    /* the number of arguments */
    struct printfArg*   arguments;   /* the arguments' values and types */

    ctmbstr             messageKey;             /* the message code as a key string */

    ctmbstr             messageFormatDefault;   /* the built-in format string */
    ctmbstr             messageFormat;          /* the localized format string */

    tmbstr              messageDefault;         /* the message, formatted, default language */
    tmbstr              message;                /* the message, formatted, localized */

    tmbstr              messagePosDefault;      /* the position part, default language */
    tmbstr              messagePos;             /* the position part, localized */

    ctmbstr             messagePrefixDefault;   /* the prefix part, default language */
    ctmbstr             messagePrefix;          /* the prefix part, localized */
    
    tmbstr              messageOutputDefault;   /* the complete string Tidy would output */
    tmbstr              messageOutput;          /* the complete string, localized */
};


#define tidyDocToImpl( tdoc )           ((TidyDocImpl*)(tdoc))
#define tidyImplToDoc( doc )            ((TidyDoc)(doc))

#define tidyMessageToImpl( tmessage )   ((TidyMessageImpl*)(tmessage))
#define tidyImplToMessage( message )    ((TidyMessage)(message))

#define tidyNodeToImpl( tnod )          ((Node*)(tnod))
#define tidyImplToNode( node )          ((TidyNode)(node))

#define tidyAttrToImpl( tattr )         ((AttVal*)(tattr))
#define tidyImplToAttr( attval )        ((TidyAttr)(attval))

#define tidyOptionToImpl( topt )        ((const TidyOptionImpl*)(topt))
#define tidyImplToOption( option )      ((TidyOption)(option))


/** Wrappers for easy memory allocation using the document's allocator */
#define TidyDocAlloc(doc, size) TidyAlloc((doc)->allocator, size)
#define TidyDocRealloc(doc, block, size) TidyRealloc((doc)->allocator, block, size)
#define TidyDocFree(doc, block) TidyFree((doc)->allocator, block)
#define TidyDocPanic(doc, msg) TidyPanic((doc)->allocator, msg)

int          TY_(DocParseStream)( TidyDocImpl* impl, StreamIn* in );

/*
   [i_a] generic node tree traversal code; used in several spots.

   Define your own callback, which returns one of the NodeTraversalSignal values
   to instruct the tree traversal routine TraverseNodeTree() what to do.

   Pass custom data to/from the callback using the 'propagate' reference.
 */
typedef enum
{
    ContinueTraversal,       /* visit siblings and children */
    SkipChildren,            /* visit siblings of this node; ignore its children */
    SkipSiblings,            /* ignore subsequent siblings of this node; ignore their children; traverse  */
    SkipChildrenAndSiblings, /* visit siblings of this node; ignore its children */
    VisitParent,             /* REVERSE traversal: visit the parent of the current node */
    ExitTraversal            /* terminate traversal on the spot */
} NodeTraversalSignal;

typedef NodeTraversalSignal NodeTraversalCallBack(TidyDocImpl* doc, Node* node, void *propagate);

NodeTraversalSignal TY_(TraverseNodeTree)(TidyDocImpl* doc, Node* node, NodeTraversalCallBack *cb, void *propagate);

#endif /* __TIDY_INT_H__ */
#ifndef __TMBSTR_H__
#define __TMBSTR_H__

/* tmbstr.h - Tidy string utility functions

  (c) 1998-2006 (W3C) MIT, ERCIM, Keio University
  See tidy.h for the copyright notice.

*/

/* #include "tidyplatform.h" */

#ifdef __cplusplus
extern "C"
{
#endif

/* like strdup but using an allocator */
tmbstr TY_(tmbstrdup)( TidyAllocator *allocator, ctmbstr str );

/* like strndup but using an allocator */
tmbstr TY_(tmbstrndup)( TidyAllocator *allocator, ctmbstr str, unsigned int len);

/* exactly same as strncpy */
unsigned int TY_(tmbstrncpy)( tmbstr s1, ctmbstr s2, unsigned int size );

unsigned int TY_(tmbstrcpy)( tmbstr s1, ctmbstr s2 );

unsigned int TY_(tmbstrcat)( tmbstr s1, ctmbstr s2 );

/* exactly same as strcmp */
int TY_(tmbstrcmp)( ctmbstr s1, ctmbstr s2 );

/* returns byte count, not char count */
unsigned int TY_(tmbstrlen)( ctmbstr str );

/*
  MS C 4.2 doesn't include strcasecmp.
  Note that tolower and toupper won't
  work on chars > 127.

  Neither do Lexer.ToLower() or Lexer.ToUpper()!

  We get away with this because, except for XML tags,
  we are always comparing to ascii element and
  attribute names defined by HTML specs.
*/
int TY_(tmbstrcasecmp)( ctmbstr s1, ctmbstr s2 );

int TY_(tmbstrncmp)( ctmbstr s1, ctmbstr s2, unsigned int n );

int TY_(tmbstrncasecmp)( ctmbstr s1, ctmbstr s2, unsigned int n );

/* return offset of cc from beginning of s1,
** -1 if not found.
*/
/* int TY_(tmbstrnchr)( ctmbstr s1, unsigned int len1, tmbchar cc ); */

ctmbstr TY_(tmbsubstrn)( ctmbstr s1, unsigned int len1, ctmbstr s2 );
/* ctmbstr TY_(tmbsubstrncase)( ctmbstr s1, unsigned int len1, ctmbstr s2 ); */
ctmbstr TY_(tmbsubstr)( ctmbstr s1, ctmbstr s2 );

/* transform string to lower case */
tmbstr TY_(tmbstrtolower)( tmbstr s );

/* Transform ASCII chars in string to upper case */
tmbstr TY_(tmbstrtoupper)( tmbstr s );

/* Bool TY_(tmbsamefile)( ctmbstr filename1, ctmbstr filename2 ); */

int TY_(tmbvsnprintf)(tmbstr buffer, size_t count, ctmbstr format, va_list args)
#ifdef __GNUC__
__attribute__((format(printf, 3, 0)))
#endif
;
int TY_(tmbsnprintf)(tmbstr buffer, size_t count, ctmbstr format, ...)
#ifdef __GNUC__
__attribute__((format(printf, 3, 4)))
#endif
;

#ifdef __cplusplus
}  /* extern "C" */
#endif

#endif /* __TMBSTR_H__ */
#ifndef __UTF8_H__
#define __UTF8_H__

/* utf8.h -- convert characters to/from UTF-8

  (c) 1998-2006 (W3C) MIT, ERCIM, Keio University
  See tidy.h for the copyright notice.

*/

/* #include "tidyplatform.h" */
/* #include "tidybuffio.h" */

/* UTF-8 encoding/decoding support
** Does not convert character "codepoints", i.e. to/from 10646.
*/

int TY_(DecodeUTF8BytesToChar)( unsigned int* c, unsigned int firstByte, ctmbstr successorBytes,
                                TidyInputSource* inp, int* count );

int TY_(EncodeCharToUTF8Bytes)( unsigned int c, tmbstr encodebuf,
                                TidyOutputSink* outp, int* count );


unsigned int  TY_(GetUTF8)( ctmbstr str, unsigned int *ch );
tmbstr TY_(PutUTF8)( tmbstr buf, unsigned int c );

#define UNICODE_BOM_BE   0xFEFF   /* big-endian (default) UNICODE BOM */
#define UNICODE_BOM      UNICODE_BOM_BE
#define UNICODE_BOM_LE   0xFFFE   /* little-endian UNICODE BOM */
#define UNICODE_BOM_UTF8 0xEFBBBF /* UTF-8 UNICODE BOM */


Bool    TY_(IsValidUTF16FromUCS4)( tchar ucs4 );
Bool    TY_(IsHighSurrogate)( tchar ch );
Bool    TY_(IsLowSurrogate)( tchar ch );

Bool    TY_(IsCombinedChar)( tchar ch );
Bool    TY_(IsValidCombinedChar)( tchar ch );

tchar   TY_(CombineSurrogatePair)( tchar high, tchar low );
Bool    TY_(SplitSurrogatePair)( tchar utf16, tchar* high, tchar* low );



#endif /* __UTF8_H__ */
/* version information

  (c) 2007-2015 (W3C) MIT, ERCIM, Keio University
  See tidy.h for the copyright notice.

*/

#ifdef RELEASE_DATE
static const char TY_(release_date)[] = RELEASE_DATE;
#else
static const char TY_(release_date)[] = "2015/01/22";
#endif
#ifdef LIBTIDY_VERSION
#ifdef RC_NUMBER
static const char TY_(library_version)[] = LIBTIDY_VERSION "." RC_NUMBER;
#else
static const char TY_(library_version)[] = LIBTIDY_VERSION;
#endif
#else
static const char TY_(library_version)[] = "5.0.0";
#endif

/* eof */
/* access.c -- carry out accessibility checks

  Copyright University of Toronto
  Portions (c) 1998-2009 (W3C) MIT, ERCIM, Keio University
  See tidy.h for the copyright notice.
  
*/


/* #include "tidy-int.h" */
/* #include "access.h" */
/* #include "message.h" */
/* #include "tags.h" */
/* #include "attrs.h" */
/* #include "tmbstr.h" */


/* 
    The accessibility checks to perform depending on user's desire.

    1. priority 1
    2. priority 1 & 2
    3. priority 1, 2, & 3
*/

/* List of possible image types */
static const ctmbstr imageExtensions[] =
{".jpg", ".gif", ".tif", ".pct", ".pic", ".iff", ".dib",
 ".tga", ".pcx", ".png", ".jpeg", ".tiff", ".bmp"};

#define N_IMAGE_EXTS (sizeof(imageExtensions)/sizeof(ctmbstr))

/* List of possible sound file types */
static const ctmbstr soundExtensions[] =
{".wav", ".au", ".aiff", ".snd", ".ra", ".rm"};

static const int soundExtErrCodes[] = 
{
    AUDIO_MISSING_TEXT_WAV,
    AUDIO_MISSING_TEXT_AU,
    AUDIO_MISSING_TEXT_AIFF,
    AUDIO_MISSING_TEXT_SND,
    AUDIO_MISSING_TEXT_RA,
    AUDIO_MISSING_TEXT_RM
};

#define N_AUDIO_EXTS (sizeof(soundExtensions)/sizeof(ctmbstr))

/* List of possible media extensions */
static const ctmbstr mediaExtensions[] = 
{".mpg", ".mov", ".asx", ".avi", ".ivf", ".m1v", ".mmm", ".mp2v",
 ".mpa", ".mpe", ".mpeg", ".ram", ".smi", ".smil", ".swf",
 ".wm", ".wma", ".wmv"};

#define N_MEDIA_EXTS (sizeof(mediaExtensions)/sizeof(ctmbstr))

/* List of possible frame sources */
static const ctmbstr frameExtensions[] =
{".htm", ".html", ".shtm", ".shtml", ".cfm", ".cfml",
".asp", ".cgi", ".pl", ".smil"};

#define N_FRAME_EXTS (sizeof(frameExtensions)/sizeof(ctmbstr))

/* List of possible colour values */
static const int colorValues[][3] =
{
  {  0,  0,  0},
  {128,128,128},
  {192,192,192},
  {255,255,255},
  {192,  0,  0},
  {255,  0,  0},
  {128,  0,128},
  {255,  0,255},
  {  0,128,  0},
  {  0,255,  0},
  {128,128,  0},
  {255,255,  0},  
  {  0,  0,128},
  {  0,  0,255},
  {  0,128,128},
  {  0,255,255}
};

#define N_COLOR_VALS (sizeof(colorValues)/(sizeof(int[3]))

/* These arrays are used to convert color names to their RGB values */
static const ctmbstr colorNames[] =
{
  "black",
  "silver",
  "grey",
  "white",
  "maroon",
  "red",
  "purple",
  "fuchsia",
  "green",
  "lime",
  "olive",
  "yellow", 
  "navy",
  "blue",
  "teal",
  "aqua"
};

#define N_COLOR_NAMES (sizeof(colorNames)/sizeof(ctmbstr))
#define N_COLORS N_COLOR_NAMES


/* function prototypes */
static void InitAccessibilityChecks( TidyDocImpl* doc, int level123 );
static void FreeAccessibilityChecks( TidyDocImpl* doc );

static Bool GetRgb( ctmbstr color, int rgb[3] );
static Bool CompareColors( const int rgbBG[3], const int rgbFG[3] );
static int  ctox( tmbchar ch );

/*
static void CheckMapAccess( TidyDocImpl* doc, Node* node, Node* front);
static void GetMapLinks( TidyDocImpl* doc, Node* node, Node* front);
static void CompareAnchorLinks( TidyDocImpl* doc, Node* front, int counter);
static void FindMissingLinks( TidyDocImpl* doc, Node* node, int counter);
*/
static void CheckFormControls( TidyDocImpl* doc, Node* node );
static void MetaDataPresent( TidyDocImpl* doc, Node* node );
static void CheckEmbed( TidyDocImpl* doc, Node* node );
static void CheckListUsage( TidyDocImpl* doc, Node* node );

/*
    IsFilePath attempts to determine whether or not the URI indicated
    by path is a file rather than a TLD. For example, sample.com.au might
    be confused with an audio file.
*/
static Bool IsFilePath( ctmbstr path )
{
    const char *p = path;
    char c;
    typedef enum states { initial, protocol_found, slash_found, file_found } states;
    states state = initial;

    while ( ( c = *p++ ) != 0 && state != file_found )
    {
        switch ( state )
        {
            case initial:
                if ( c == ':' )
                    state = protocol_found;
                break;

            case protocol_found:
                if ( c =='/' )
                    state = slash_found;
                break;

            case slash_found:
                if ( c =='/' )
                    state = protocol_found;
                else
                    state = file_found;
                break;
                
            default:
                break;
        }
        
    }
    
    return state == file_found || state == initial;
}


/*
    GetFileExtension takes a path and returns the extension
    portion of the path (if any).
*/

static void GetFileExtension( ctmbstr path, tmbchar *ext, unsigned int maxExt )
{
    int i = TY_(tmbstrlen)(path) - 1;
    
    ext[0] = '\0';
    
    do {
        if ( path[i] == '/' || path[i] == '\\' )
            break;
        else if ( path[i] == '.' )
        {
            TY_(tmbstrncpy)( ext, path+i, maxExt );
            break;
        }
    } while ( --i > 0 );
}

/************************************************************************
* IsImage
*
* Checks if the given filename is an image file.
* Returns 'yes' if it is, 'no' if it's not.
************************************************************************/

static Bool IsImage( ctmbstr iType )
{
    unsigned int i;
    tmbchar ext[20];

    if ( !IsFilePath(iType) ) return 0;

    GetFileExtension( iType, ext, sizeof(ext) );

    /* Compare it to the array of known image file extensions */
    for (i = 0; i < N_IMAGE_EXTS; i++)
    {
        if ( TY_(tmbstrcasecmp)(ext, imageExtensions[i]) == 0 )
            return yes;
    }
    
    return no;
}


/***********************************************************************
* IsSoundFile
*
* Checks if the given filename is a sound file.
* Returns 'yes' if it is, 'no' if it's not.
***********************************************************************/

static int IsSoundFile( ctmbstr sType )
{
    unsigned int i;
    tmbchar ext[ 20 ];

    if ( !IsFilePath(sType) ) return 0;
    
    GetFileExtension( sType, ext, sizeof(ext) );
    
    for (i = 0; i < N_AUDIO_EXTS; i++)
    {
        if ( TY_(tmbstrcasecmp)(ext, soundExtensions[i]) == 0 )
            return soundExtErrCodes[i];
    }
    return 0;
}


/***********************************************************************
* IsValidSrcExtension
*
* Checks if the 'SRC' value within the FRAME element is valid
* The 'SRC' extension must end in ".htm", ".html", ".shtm", ".shtml", 
* ".cfm", ".cfml", ".asp", ".cgi", ".pl", or ".smil"
*
* Returns yes if it is, returns no otherwise.
***********************************************************************/

static Bool IsValidSrcExtension( ctmbstr sType )
{
    unsigned int i;
    tmbchar ext[20];
    
    if ( !IsFilePath(sType) ) return 0;
    
    GetFileExtension( sType, ext, sizeof(ext) );

    for (i = 0; i < N_FRAME_EXTS; i++)
    {
        if ( TY_(tmbstrcasecmp)(ext, frameExtensions[i]) == 0 )
            return yes;
    }
    return no;
}


/*********************************************************************
* IsValidMediaExtension
*
* Checks to warn the user that syncronized text equivalents are 
* required if multimedia is used.
*********************************************************************/

static Bool IsValidMediaExtension( ctmbstr sType )
{
    unsigned int i;
    tmbchar ext[20];

    if ( !IsFilePath(sType) ) return 0;

    GetFileExtension( sType, ext, sizeof(ext) );

    for (i = 0; i < N_MEDIA_EXTS; i++)
    {
        if ( TY_(tmbstrcasecmp)(ext, mediaExtensions[i]) == 0 )
            return yes;
    }
    return no;
}


/************************************************************************
* IsWhitespace
*
* Checks if the given string is all whitespace.
* Returns 'yes' if it is, 'no' if it's not.
************************************************************************/

static Bool IsWhitespace( ctmbstr pString )
{
    Bool isWht = yes;
    ctmbstr cp;

    for ( cp = pString; isWht && cp && *cp; ++cp )
    {
        isWht = TY_(IsWhite)( *cp );
    }
    return isWht;
}

static Bool hasValue( AttVal* av )
{
    return ( av && ! IsWhitespace(av->value) );
}

/***********************************************************************
* IsPlaceholderAlt
*  
* Checks to see if there is an image and photo place holder contained
* in the ALT text.
*
* Returns 'yes' if there is, 'no' if not.
***********************************************************************/

static Bool IsPlaceholderAlt( ctmbstr txt )
{
    return ( strstr(txt, "image") != NULL || 
             strstr(txt, "photo") != NULL );
}


/***********************************************************************
* IsPlaceholderTitle
*  
* Checks to see if there is an TITLE place holder contained
* in the 'ALT' text.
*
* Returns 'yes' if there is, 'no' if not.

static Bool IsPlaceHolderTitle( ctmbstr txt )
{
    return ( strstr(txt, "title") != NULL );
}
***********************************************************************/


/***********************************************************************
* IsPlaceHolderObject
*  
* Checks to see if there is an OBJECT place holder contained
* in the 'ALT' text.
*
* Returns 'yes' if there is, 'no' if not.
***********************************************************************/

static Bool IsPlaceHolderObject( ctmbstr txt )
{
    return ( strstr(txt, "object") != NULL );
}


/**********************************************************
* EndsWithBytes
*
* Checks to see if the ALT text ends with 'bytes'
* Returns 'yes', if true, 'no' otherwise.
**********************************************************/

static Bool EndsWithBytes( ctmbstr txt )
{
    unsigned int len = TY_(tmbstrlen)( txt );
    return ( len >= 5 && TY_(tmbstrcmp)(txt+len-5, "bytes") == 0 );
}


/*******************************************************
* textFromOneNode
*
* Returns a list of characters contained within one
* text node.
*******************************************************/

static ctmbstr textFromOneNode( TidyDocImpl* doc, Node* node )
{
    unsigned int i;
    unsigned int x = 0;
    tmbstr txt = doc->access.text;
    
    if ( node )
    {
        /* Copy contents of a text node */
        for (i = node->start; i < node->end; ++i, ++x )
        {
            txt[x] = doc->lexer->lexbuf[i];

            /* Check buffer overflow */
            if ( x >= sizeof(doc->access.text)-1 )
                break;
        }
    }

    txt[x] = '\0';
    return txt;
}


/*********************************************************
* getTextNode
*
* Locates text nodes within a container element.
* Retrieves text that are found contained within 
* text nodes, and concatenates the text.
*********************************************************/
    
static void getTextNode( TidyDocImpl* doc, Node* node )
{
    tmbstr txtnod = doc->access.textNode;       
    
    /* 
       Continues to traverse through container element until it no
       longer contains any more contents 
    */

    /* If the tag of the node is NULL, then grab the text within the node */
    if ( TY_(nodeIsText)(node) )
    {
        unsigned int i;

        /* Retrieves each character found within the text node */
        for (i = node->start; i < node->end; i++)
        {
            /* The text must not exceed buffer */
            if ( doc->access.counter >= TEXTBUF_SIZE-1 )
                return;

            txtnod[ doc->access.counter++ ] = doc->lexer->lexbuf[i];
        }

        /* Traverses through the contents within a container element */
        for ( node = node->content; node != NULL; node = node->next )
            getTextNode( doc, node );
    }   
}


/**********************************************************
* getTextNodeClear
*
* Clears the current 'textNode' and reloads it with new
* text.  The textNode must be cleared before use.
**********************************************************/

static tmbstr getTextNodeClear( TidyDocImpl* doc, Node* node )
{
    /* Clears list */
    TidyClearMemory( doc->access.textNode, TEXTBUF_SIZE );
    doc->access.counter = 0;

    getTextNode( doc, node->content );
    return doc->access.textNode;
}

/**********************************************************
* LevelX_Enabled
*
* Tell whether access "X" is enabled.
**********************************************************/

static Bool Level1_Enabled( TidyDocImpl* doc )
{
   return doc->access.PRIORITYCHK == 1 ||
          doc->access.PRIORITYCHK == 2 ||
          doc->access.PRIORITYCHK == 3;
}
static Bool Level2_Enabled( TidyDocImpl* doc )
{
    return doc->access.PRIORITYCHK == 2 ||
           doc->access.PRIORITYCHK == 3;
}
static Bool Level3_Enabled( TidyDocImpl* doc )
{
    return doc->access.PRIORITYCHK == 3;
}

/********************************************************
* CheckColorAvailable
*
* Verify that information conveyed with color is 
* available without color.
********************************************************/

static void CheckColorAvailable( TidyDocImpl* doc, Node* node )
{
    if (Level1_Enabled( doc ))
    {
        if ( nodeIsIMG(node) )
            TY_(ReportAccessError)( doc, node, INFORMATION_NOT_CONVEYED_IMAGE );

        else if ( nodeIsAPPLET(node) )
            TY_(ReportAccessError)( doc, node, INFORMATION_NOT_CONVEYED_APPLET );

        else if ( nodeIsOBJECT(node) )
            TY_(ReportAccessError)( doc, node, INFORMATION_NOT_CONVEYED_OBJECT );

        else if ( nodeIsSCRIPT(node) )
            TY_(ReportAccessError)( doc, node, INFORMATION_NOT_CONVEYED_SCRIPT );

        else if ( nodeIsINPUT(node) )
            TY_(ReportAccessError)( doc, node, INFORMATION_NOT_CONVEYED_INPUT );
    }
}

/*********************************************************************
* CheckColorContrast
*
* Checks elements for color contrast.  Must have valid contrast for
* valid visibility.
*
* This logic is extremely fragile as it does not recognize
* the fact that color is inherited by many components and
* that BG and FG colors are often set separately.  E.g. the
* background color may be set by for the body or a table 
* or a cell.  The foreground color may be set by any text
* element (p, h1, h2, input, textarea), either explicitly
* or by style.  Ergo, this test will not handle most real
* world cases.  It's a start, however.
*********************************************************************/

static void CheckColorContrast( TidyDocImpl* doc, Node* node )
{
    int rgbBG[3] = {255,255,255};   /* Black text on white BG */

    if (Level3_Enabled( doc ))
    {
        Bool gotBG = yes;
        AttVal* av;

        /* Check for 'BGCOLOR' first to compare with other color attributes */
        for ( av = node->attributes; av; av = av->next )
        {            
            if ( attrIsBGCOLOR(av) )
            {
                if ( hasValue(av) )
                    gotBG = GetRgb( av->value, rgbBG );
            }
        }
        
        /* 
           Search for COLOR attributes to compare with background color
           Must have valid colour contrast
        */
        for ( av = node->attributes; gotBG && av != NULL; av = av->next )
        {
            unsigned int errcode = 0;
            if ( attrIsTEXT(av) )
                errcode = COLOR_CONTRAST_TEXT;
            else if ( attrIsLINK(av) )
                errcode = COLOR_CONTRAST_LINK;
            else if ( attrIsALINK(av) )
                errcode = COLOR_CONTRAST_ACTIVE_LINK;
            else if ( attrIsVLINK(av) )
                errcode = COLOR_CONTRAST_VISITED_LINK;

            if ( errcode && hasValue(av) )
            {
                int rgbFG[3] = {0, 0, 0};  /* Black text */

                if ( GetRgb(av->value, rgbFG) &&
                     !CompareColors(rgbBG, rgbFG) )
                {
                    TY_(ReportAccessError)( doc, node, errcode );
                }
            }
        }
    }
}


/**************************************************************
* CompareColors
*
* Compares two RGB colors for good contrast.
**************************************************************/
static int minmax( int i1, int i2 )
{
   return MAX(i1, i2) - MIN(i1,i2);
}
static int brightness( const int rgb[3] )
{
   return ((rgb[0]*299) + (rgb[1]*587) + (rgb[2]*114)) / 1000;
}

static Bool CompareColors( const int rgbBG[3], const int rgbFG[3] )
{
    int brightBG = brightness( rgbBG );
    int brightFG = brightness( rgbFG );

    int diffBright = minmax( brightBG, brightFG );

    int diffColor = minmax( rgbBG[0], rgbFG[0] )
                  + minmax( rgbBG[1], rgbFG[1] )
                  + minmax( rgbBG[2], rgbFG[2] );

    return ( diffBright > 180 &&
             diffColor > 500 );
}


/*********************************************************************
* GetRgb
*
* Gets the red, green and blue values for this attribute for the 
* background.
*
* Example: If attribute is BGCOLOR="#121005" then red = 18, green = 16,
* blue = 5.
*********************************************************************/

static Bool GetRgb( ctmbstr color, int rgb[] )
{
    unsigned int x;

    /* Check if we have a color name */
    for (x = 0; x < N_COLORS; x++)
    {
        if ( strstr(colorNames[x], color) != NULL )
        {
            rgb[0] = colorValues[x][0];
            rgb[1] = colorValues[x][1];
            rgb[2] = colorValues[x][2];
            return yes;
        }
    }

    /*
       No color name so must be hex values 
       Is this a number in hexadecimal format?
    */
    
    /* Must be 7 characters in the RGB value (including '#') */
    if ( TY_(tmbstrlen)(color) == 7 && color[0] == '#' )
    {
        rgb[0] = (ctox(color[1]) * 16) + ctox(color[2]);
        rgb[1] = (ctox(color[3]) * 16) + ctox(color[4]);
        rgb[2] = (ctox(color[5]) * 16) + ctox(color[6]);
        return yes;
    }
    return no;
} 



/*******************************************************************
* ctox
*
* Converts a character to a number.
* Example: if given character is 'A' then returns 10.
*
* Returns the number that the character represents. Returns -1 if not a
* valid number.
*******************************************************************/

static int ctox( tmbchar ch )
{
    if ( ch >= '0' && ch <= '9' )
    {
         return ch - '0';
    }
    else if ( ch >= 'a' && ch <= 'f' )
    {
        return ch - 'a' + 10;
    }
    else if ( ch >= 'A' && ch <= 'F' )
    {
        return ch - 'A' + 10;
    }
    return -1;
}


/***********************************************************
* CheckImage
*
* Checks all image attributes for specific elements to
* check for validity of the values contained within
* the attributes.  An appropriate warning message is displayed
* to indicate the error.  
***********************************************************/

static void CheckImage( TidyDocImpl* doc, Node* node )
{
    Bool HasAlt = no;
    Bool HasIsMap = no;
    Bool HasLongDesc = no;
    Bool HasDLINK = no;
    Bool HasValidHeight = no;
    Bool HasValidWidthBullet = no;
    Bool HasValidWidthHR = no; 
    Bool HasTriggeredMissingLongDesc = no;

    AttVal* av;
                
    if (Level1_Enabled( doc ))
    {
        /* Checks all image attributes for invalid values within attributes */
        for (av = node->attributes; av != NULL; av = av->next)
        {
            /* 
               Checks for valid ALT attribute.
               The length of the alt text must be less than 150 characters 
               long.
            */
            if ( attrIsALT(av) )
            {
                if (av->value != NULL) 
                {
                    if ((TY_(tmbstrlen)(av->value) < 150) &&
                        (IsPlaceholderAlt (av->value) == no) &&
                        (IsPlaceHolderObject (av->value) == no) &&
                        (EndsWithBytes (av->value) == no) &&
                        (IsImage (av->value) == no))
                    {
                        HasAlt = yes;
                    }

                    else if (TY_(tmbstrlen)(av->value) > 150)
                    {
                        HasAlt = yes;
                        TY_(ReportAccessError)( doc, node, IMG_ALT_SUSPICIOUS_TOO_LONG );
                    }

                    else if (IsImage (av->value) == yes)
                    {
                        HasAlt = yes;
                        TY_(ReportAccessError)( doc, node, IMG_ALT_SUSPICIOUS_FILENAME);
                    }
            
                    else if (IsPlaceholderAlt (av->value) == yes)
                    {
                        HasAlt = yes;
                        TY_(ReportAccessError)( doc, node, IMG_ALT_SUSPICIOUS_PLACEHOLDER);
                    }

                    else if (EndsWithBytes (av->value) == yes)
                    {
                        HasAlt = yes;
                        TY_(ReportAccessError)( doc, node, IMG_ALT_SUSPICIOUS_FILE_SIZE);
                    }
                }
            }

            /* 
               Checks for width values of 'bullets' and 'horizontal
               rules' for validity.

               Valid pixel width for 'bullets' must be < 30, and > 150 for
               horizontal rules.
            */
            else if ( attrIsWIDTH(av) )
            {
                /* Longdesc attribute needed if width attribute is not present. */
                if ( hasValue(av) )
                {
                    int width = atoi( av->value );
                    if ( width < 30 )
                        HasValidWidthBullet = yes;

                    if ( width > 150 )
                        HasValidWidthHR = yes;
                }
            }

            /* 
               Checks for height values of 'bullets' and horizontal
               rules for validity.

               Valid pixel height for 'bullets' and horizontal rules 
               mustt be < 30.
            */
            else if ( attrIsHEIGHT(av) )
            {
                /* Longdesc attribute needed if height attribute not present. */
                if ( hasValue(av) && atoi(av->value) < 30 )
                    HasValidHeight = yes;
            }

            /* 
               Checks for longdesc and determines validity.  
               The length of the 'longdesc' must be > 1
            */
            else if ( attrIsLONGDESC(av) )
            {
                if ( hasValue(av) && TY_(tmbstrlen)(av->value) > 1 )
                    HasLongDesc = yes;
              }

            /* 
               Checks for 'USEMAP' attribute.  Ensures that
               text links are provided for client-side image maps
            */
            else if ( attrIsUSEMAP(av) )
            {
                if ( hasValue(av) )
                    doc->access.HasUseMap = yes;
            }    

            else if ( attrIsISMAP(av) )
            {
                HasIsMap = yes;
            }
        }    
        
        
        /* 
            Check to see if a dLINK is present.  The ANCHOR element must
            be present following the IMG element.  The text found between 
            the ANCHOR tags must be < 6 characters long, and must contain
            the letter 'd'.
        */
        if ( nodeIsA(node->next) )
        {
            node = node->next;
            
            /* 
                Node following the anchor must be a text node
                for dLINK to exist 
            */

            if (node->content != NULL && (node->content)->tag == NULL)
            {
                /* Number of characters found within the text node */
                ctmbstr word = textFromOneNode( doc, node->content);
                    
                if ((TY_(tmbstrcmp)(word,"d") == 0)||
                    (TY_(tmbstrcmp)(word,"D") == 0))
                {
                    HasDLINK = yes;
                }
            }
        }
                    
        /*
            Special case check for dLINK.  This will occur if there is 
            whitespace between the <img> and <a> elements.  Ignores 
            whitespace and continues check for dLINK.
        */
        
        if ( node->next && !node->next->tag )
        {
            node = node->next;

            if ( nodeIsA(node->next) )
            {
                node = node->next;

                /* 
                    Node following the ANCHOR must be a text node
                    for dLINK to exist 
                */
                if (node->content != NULL && node->content->tag == NULL)
                {
                    /* Number of characters found within the text node */
                    ctmbstr word = textFromOneNode( doc, node->content );

                    if ((TY_(tmbstrcmp)(word, "d") == 0)||
                        (TY_(tmbstrcmp)(word, "D") == 0))
                    {
                        HasDLINK = yes;
                    }
                }
            }
        }

        if ((HasAlt == no)&&
            (HasValidWidthBullet == yes)&&
            (HasValidHeight == yes))
        {
        }

        if ((HasAlt == no)&&
            (HasValidWidthHR == yes)&&
            (HasValidHeight == yes))
        {
        }

        if (HasAlt == no)
        {
            TY_(ReportAccessError)( doc, node, IMG_MISSING_ALT);
        }

        if ((HasLongDesc == no)&&
            (HasValidHeight ==yes)&&
            ((HasValidWidthHR == yes)||
             (HasValidWidthBullet == yes)))
        {
            HasTriggeredMissingLongDesc = yes;
        }

        if (HasTriggeredMissingLongDesc == no)
        {
            if ((HasDLINK == yes)&&
                (HasLongDesc == no))
            {
                TY_(ReportAccessError)( doc, node, IMG_MISSING_LONGDESC);
            }

            if ((HasLongDesc == yes)&&
                (HasDLINK == no))
            {
                TY_(ReportAccessError)( doc, node, IMG_MISSING_DLINK);
            }

            if ((HasLongDesc == no)&&
                (HasDLINK == no))
            {
                TY_(ReportAccessError)( doc, node, IMG_MISSING_LONGDESC_DLINK);
            }
        }

        if (HasIsMap == yes)
        {
            TY_(ReportAccessError)( doc, node, IMAGE_MAP_SERVER_SIDE_REQUIRES_CONVERSION);

            TY_(ReportAccessError)( doc, node, IMG_MAP_SERVER_REQUIRES_TEXT_LINKS);
        }
    }
}


/***********************************************************
* CheckApplet
*
* Checks APPLET element to check for validity pertaining 
* the 'ALT' attribute.  An appropriate warning message is 
* displayed  to indicate the error. An appropriate warning 
* message is displayed to indicate the error.  If no 'ALT'
* text is present, then there must be alternate content
* within the APPLET element.
***********************************************************/

static void CheckApplet( TidyDocImpl* doc, Node* node )
{
    Bool HasAlt = no;
    Bool HasDescription = no;

    AttVal* av;
        
    if (Level1_Enabled( doc ))
    {
        /* Checks for attributes within the APPLET element */
        for (av = node->attributes; av != NULL; av = av->next)
        {
            /*
               Checks for valid ALT attribute.
               The length of the alt text must be > 4 characters in length
               but must be < 150 characters long.
            */

            if ( attrIsALT(av) )
            {
                if (av->value != NULL)
                {
                    HasAlt = yes;
                }
            }
        }

        if (HasAlt == no)
        {
            /* Must have alternate text representation for that element */
            if (node->content != NULL) 
            {
                ctmbstr word = NULL;

                if ( node->content->tag == NULL )
                    word = textFromOneNode( doc, node->content);

                if ( node->content->content != NULL &&
                     node->content->content->tag == NULL )
                {
                    word = textFromOneNode( doc, node->content->content);
                }
                
                if ( word != NULL && !IsWhitespace(word) )
                    HasDescription = yes;
            }
        }

        if ( !HasDescription && !HasAlt )
        {
            TY_(ReportAccessError)( doc, node, APPLET_MISSING_ALT );
        }
    }
}


/*******************************************************************
* CheckObject
*
* Checks to verify whether the OBJECT element contains
* 'ALT' text, and to see that the sound file selected is 
* of a valid sound file type.  OBJECT must have an alternate text 
* representation.
*******************************************************************/

static void CheckObject( TidyDocImpl* doc, Node* node )
{
    Bool HasAlt = no;
    Bool HasDescription = no;

    if (Level1_Enabled( doc ))
    {
        if ( node->content != NULL)
        {
            if ( node->content->type != TextNode )
            {
                Node* tnode = node->content;
                AttVal* av;

                for ( av=tnode->attributes; av; av = av->next )
                {
                    if ( attrIsALT(av) )
                    {
                        HasAlt = yes;
                        break;
                    }
                }
            }

            /* Must have alternate text representation for that element */
            if ( !HasAlt )
            {
                ctmbstr word = NULL;

                if ( TY_(nodeIsText)(node->content) )
                    word = textFromOneNode( doc, node->content );

                if ( word == NULL &&
                     TY_(nodeIsText)(node->content->content) )
                {
                    word = textFromOneNode( doc, node->content->content );
                }
                    
                if ( word != NULL && !IsWhitespace(word) )
                    HasDescription = yes;
            }
        }

        if ( !HasAlt && !HasDescription )
        {
            TY_(ReportAccessError)( doc, node, OBJECT_MISSING_ALT );
        }
    }
}


/***************************************************************
* CheckMissingStyleSheets
*
* Ensures that stylesheets are used to control the presentation.
***************************************************************/

static Bool CheckMissingStyleSheets( TidyDocImpl* doc, Node* node )
{
    AttVal* av;
    Node* content;
    Bool sspresent = no;

    for ( content = node->content;
          !sspresent && content != NULL;
          content = content->next )
    {
        sspresent = ( nodeIsLINK(content)  ||
                      nodeIsSTYLE(content) ||
                      nodeIsFONT(content)  ||
                      nodeIsBASEFONT(content) );

        for ( av = content->attributes;
              !sspresent && av != NULL;
              av = av->next )
        {
            sspresent = ( attrIsSTYLE(av) || attrIsTEXT(av)  ||
                          attrIsVLINK(av) || attrIsALINK(av) ||
                          attrIsLINK(av) );

            if ( !sspresent && attrIsREL(av) )
            {
                sspresent = AttrValueIs(av, "stylesheet");
            }
        }

        if ( ! sspresent )
            sspresent = CheckMissingStyleSheets( doc, content );
    }
    return sspresent;
}


/*******************************************************************
* CheckFrame
*
* Checks if the URL is valid and to check if a 'LONGDESC' is needed
* within the FRAME element.  If a 'LONGDESC' is needed, the value must 
* be valid. The URL must end with the file extension, htm, or html. 
* Also, checks to ensure that the 'SRC' and 'TITLE' values are valid. 
*******************************************************************/

static void CheckFrame( TidyDocImpl* doc, Node* node )
{
    Bool HasTitle = no;
    AttVal* av;

    doc->access.numFrames++;

    if (Level1_Enabled( doc ))
    {
        /* Checks for attributes within the FRAME element */
        for (av = node->attributes; av != NULL; av = av->next)
        {
            /* Checks if 'LONGDESC' value is valid only if present */
            if ( attrIsLONGDESC(av) )
            {
                if ( hasValue(av) && TY_(tmbstrlen)(av->value) > 1 )
                {
                    doc->access.HasCheckedLongDesc++;
                }
            }

            /* Checks for valid 'SRC' value within the frame element */
            else if ( attrIsSRC(av) )
            {
                if ( hasValue(av) && !IsValidSrcExtension(av->value) )
                {
                    TY_(ReportAccessError)( doc, node, FRAME_SRC_INVALID );
                }
            }

            /* Checks for valid 'TITLE' value within frame element */
            else if ( attrIsTITLE(av) )
            {
                if ( hasValue(av) )
                    HasTitle = yes;

                if ( !HasTitle )
                {
                    if ( av->value == NULL || TY_(tmbstrlen)(av->value) == 0 )
                    {
                        HasTitle = yes;
                        TY_(ReportAccessError)( doc, node, FRAME_TITLE_INVALID_NULL);
                    }
                    else
                    {
                        if ( IsWhitespace(av->value) && TY_(tmbstrlen)(av->value) > 0 )
                        {
                            HasTitle = yes;
                            TY_(ReportAccessError)( doc, node, FRAME_TITLE_INVALID_SPACES );
                        }
                    }
                }
            }
        }

        if ( !HasTitle )
        {
            TY_(ReportAccessError)( doc, node, FRAME_MISSING_TITLE);
        }

        if ( doc->access.numFrames==3 && doc->access.HasCheckedLongDesc<3 )
        {
            doc->access.numFrames = 0;
            TY_(ReportAccessError)( doc, node, FRAME_MISSING_LONGDESC );
        }
    }
}


/****************************************************************
* CheckIFrame
*
* Checks if 'SRC' value is valid.  Must end in appropriate
* file extension.
****************************************************************/

static void CheckIFrame( TidyDocImpl* doc, Node* node )
{
    if (Level1_Enabled( doc ))
    {
        /* Checks for valid 'SRC' value within the IFRAME element */
        AttVal* av = attrGetSRC( node );
        if ( hasValue(av) )
        {
            if ( !IsValidSrcExtension(av->value) )
                TY_(ReportAccessError)( doc, node, FRAME_SRC_INVALID );
        }
    }
}


/**********************************************************************
* CheckAnchorAccess
*
* Checks that the sound file is valid, and to ensure that
* text transcript is present describing the 'HREF' within the 
* ANCHOR element.  Also checks to see ensure that the 'TARGET' attribute
* (if it exists) is not NULL and does not contain '_new' or '_blank'.
**********************************************************************/

static void CheckAnchorAccess( TidyDocImpl* doc, Node* node )
{
    AttVal* av;
    Bool HasDescription = no;
    Bool HasTriggeredLink = no;

    /* Checks for attributes within the ANCHOR element */
    for ( av = node->attributes; av != NULL; av = av->next )
    {
        if (Level1_Enabled( doc ))
        {
            /* Must be of valid sound file type */
            if ( attrIsHREF(av) )
            {
                if ( hasValue(av) )
                {
                    tmbchar ext[ 20 ];
                    GetFileExtension (av->value, ext, sizeof(ext) );

                    /* Checks to see if multimedia is used */
                    if ( IsValidMediaExtension(av->value) )
                    {
                        TY_(ReportAccessError)( doc, node, MULTIMEDIA_REQUIRES_TEXT );
                    }
            
                    /* 
                        Checks for validity of sound file, and checks to see if 
                        the file is described within the document, or by a link
                        that is present which gives the description.
                    */
                    if ( TY_(tmbstrlen)(ext) < 6 && TY_(tmbstrlen)(ext) > 0 )
                    {
                        int errcode = IsSoundFile( av->value );
                        if ( errcode )
                        {
                            if (node->next != NULL)
                            {
                                if (node->next->tag == NULL)
                                {
                                    ctmbstr word = textFromOneNode( doc, node->next);
                                
                                    /* Must contain at least one letter in the text */
                                    if (IsWhitespace (word) == no)
                                    {
                                        HasDescription = yes;
                                    }
                                }
                            }

                            /* Must contain text description of sound file */
                            if ( !HasDescription )
                            {
                                TY_(ReportAccessError)( doc, node, errcode );
                            }
                        }
                    }
                }
            }
        }

        if (Level2_Enabled( doc ))
        {
            /* Checks 'TARGET' attribute for validity if it exists */
            if ( attrIsTARGET(av) )
            {
                if (AttrValueIs(av, "_new"))
                {
                    TY_(ReportAccessError)( doc, node, NEW_WINDOWS_REQUIRE_WARNING_NEW);
                }
                else if (AttrValueIs(av, "_blank"))
                {
                    TY_(ReportAccessError)( doc, node, NEW_WINDOWS_REQUIRE_WARNING_BLANK);
                }
            }
        }
    }
    
    if (Level2_Enabled( doc ))
    {
        if ((node->content != NULL)&&
            (node->content->tag == NULL))
        {
            ctmbstr word = textFromOneNode( doc, node->content);

            if ((word != NULL)&&
                (IsWhitespace (word) == no))
            {
                if (TY_(tmbstrcmp) (word, "more") == 0)
                {
                    HasTriggeredLink = yes;
                }

                if (TY_(tmbstrcmp) (word, "click here") == 0)
                {
                    TY_(ReportAccessError)( doc, node, LINK_TEXT_NOT_MEANINGFUL_CLICK_HERE);
                }

                if (HasTriggeredLink == no)
                {
                    if (TY_(tmbstrlen)(word) < 6)
                    {
                        TY_(ReportAccessError)( doc, node, LINK_TEXT_NOT_MEANINGFUL);
                    }
                }

                if (TY_(tmbstrlen)(word) > 60)
                {
                    TY_(ReportAccessError)( doc, node, LINK_TEXT_TOO_LONG);
                }

            }
        }
        
        if (node->content == NULL)
        {
            TY_(ReportAccessError)( doc, node, LINK_TEXT_MISSING);
        }
    }
}


/************************************************************
* CheckArea
*
* Checks attributes within the AREA element to 
* determine if the 'ALT' text and 'HREF' values are valid.
* Also checks to see ensure that the 'TARGET' attribute
* (if it exists) is not NULL and does not contain '_new' 
* or '_blank'.
************************************************************/

static void CheckArea( TidyDocImpl* doc, Node* node )
{
    Bool HasAlt = no;
    AttVal* av;

    /* Checks all attributes within the AREA element */
    for (av = node->attributes; av != NULL; av = av->next)
    {
        if (Level1_Enabled( doc ))
        {
            /*
              Checks for valid ALT attribute.
              The length of the alt text must be > 4 characters long
              but must be less than 150 characters long.
            */
                
            if ( attrIsALT(av) )
            {
                /* The check for validity */
                if (av->value != NULL) 
                {
                    HasAlt = yes;
                }
            }
        }

        if (Level2_Enabled( doc ))
        {
            if ( attrIsTARGET(av) )
            {
                if (AttrValueIs(av, "_new"))
                {
                    TY_(ReportAccessError)( doc, node, NEW_WINDOWS_REQUIRE_WARNING_NEW);
                }
                else if (AttrValueIs(av, "_blank"))
                {
                    TY_(ReportAccessError)( doc, node, NEW_WINDOWS_REQUIRE_WARNING_BLANK);
                }
            }
        }
    }

    if (Level1_Enabled( doc ))
    {
        /* AREA must contain alt text */
        if (HasAlt == no)
        {
            TY_(ReportAccessError)( doc, node, AREA_MISSING_ALT);
        }    
    }
}


/***************************************************
* CheckScript
*
* Checks the SCRIPT element to ensure that a
* NOSCRIPT section follows the SCRIPT.  
***************************************************/

static void CheckScriptAcc( TidyDocImpl* doc, Node* node )
{
    if (Level1_Enabled( doc ))
    {
        /* NOSCRIPT element must appear immediately following SCRIPT element */
        if ( node->next == NULL || !nodeIsNOSCRIPT(node->next) )
        {
            TY_(ReportAccessError)( doc, node, SCRIPT_MISSING_NOSCRIPT);
        }
    }
}


/**********************************************************
* CheckRows
*
* Check to see that each table has a row of headers if
* a column of columns doesn't exist. 
**********************************************************/

static void CheckRows( TidyDocImpl* doc, Node* node )
{
    int numTR = 0;
    int numValidTH = 0;
    
    doc->access.CheckedHeaders++;

    for (; node != NULL; node = node->next )
    {
        numTR++;
        if ( nodeIsTH(node->content) )
        {
            doc->access.HasTH = yes;            
            if ( TY_(nodeIsText)(node->content->content) )
            {
                ctmbstr word = textFromOneNode( doc, node->content->content);
                if ( !IsWhitespace(word) )
                    numValidTH++;
            }
        }
    }

    if (numTR == numValidTH)
        doc->access.HasValidRowHeaders = yes;

    if ( numTR >= 2 &&
         numTR > numValidTH &&
         numValidTH >= 2 &&
         doc->access.HasTH == yes )
        doc->access.HasInvalidRowHeader = yes;
}


/**********************************************************
* CheckColumns
*
* Check to see that each table has a column of headers if
* a row of columns doesn't exist.  
**********************************************************/

static void CheckColumns( TidyDocImpl* doc, Node* node )
{
    Node* tnode;
    int numTH = 0;
    Bool isMissingHeader = no;

    doc->access.CheckedHeaders++;

    /* Table must have row of headers if headers for columns don't exist */
    if ( nodeIsTH(node->content) )
    {
        doc->access.HasTH = yes;

        for ( tnode = node->content; tnode; tnode = tnode->next )
        {
            if ( nodeIsTH(tnode) )
            {
                if ( TY_(nodeIsText)(tnode->content) )
                {
                    ctmbstr word = textFromOneNode( doc, tnode->content);
                    if ( !IsWhitespace(word) )
                        numTH++;
                }
            }
            else
            {
                isMissingHeader = yes;
            }
        }
    }

    if ( !isMissingHeader && numTH > 0 )
        doc->access.HasValidColumnHeaders = yes;

    if ( isMissingHeader && numTH >= 2 )
        doc->access.HasInvalidColumnHeader = yes;
}


/*****************************************************
* CheckTH
*
* Checks to see if the header provided for a table
* requires an abbreviation. (only required if the 
* length of the header is greater than 15 characters)
*****************************************************/

static void CheckTH( TidyDocImpl* doc, Node* node )
{
    Bool HasAbbr = no;
    ctmbstr word = NULL;
    AttVal* av;

    if (Level3_Enabled( doc ))
    {
        /* Checks TH element for 'ABBR' attribute */
        for (av = node->attributes; av != NULL; av = av->next)
        {
            if ( attrIsABBR(av) )
            {
                /* Value must not be NULL and must be less than 15 characters */
                if ((av->value != NULL)&&
                    (IsWhitespace (av->value) == no))
                {
                    HasAbbr = yes;
                }

                if ((av->value == NULL)||
                    (TY_(tmbstrlen)(av->value) == 0))
                {
                    HasAbbr = yes;
                    TY_(ReportAccessError)( doc, node, TABLE_MAY_REQUIRE_HEADER_ABBR_NULL);
                }
                
                if ((IsWhitespace (av->value) == yes)&&
                    (TY_(tmbstrlen)(av->value) > 0))
                {
                    HasAbbr = yes;
                    TY_(ReportAccessError)( doc, node, TABLE_MAY_REQUIRE_HEADER_ABBR_SPACES);
                }
            }
        }

        /* If the header is greater than 15 characters, an abbreviation is needed */
        word = textFromOneNode( doc, node->content);

        if ((word != NULL)&&
            (IsWhitespace (word) == no))
        {
            /* Must have 'ABBR' attribute if header is > 15 characters */
            if ((TY_(tmbstrlen)(word) > 15)&&
                (HasAbbr == no))
            {
                TY_(ReportAccessError)( doc, node, TABLE_MAY_REQUIRE_HEADER_ABBR);
            }
        }
    }
}


/*****************************************************************
* CheckMultiHeaders
*
* Layout tables should make sense when linearized.
* TABLE must contain at least one TH element.
* This technique applies only to tables used for layout purposes, 
* not to data tables. Checks for column of multiple headers.
*****************************************************************/

static void CheckMultiHeaders( TidyDocImpl* doc, Node* node )
{
    Node* TNode;
    Node* temp;
    
    Bool validColSpanRows = yes;
    Bool validColSpanColumns = yes;

    int flag = 0;

    if (Level1_Enabled( doc ))
    {
        if (node->content != NULL)
        {
            TNode = node->content;

            /* 
               Checks for column of multiple headers found 
               within a data table. 
            */
            while (TNode != NULL)
            {
                if ( nodeIsTR(TNode) )
                {
                    flag = 0; /* Issue #168 - access test 5-2-1-2 */
                    if (TNode->content != NULL)
                    {
                        temp = TNode->content;

                        /* The number of TH elements found within TR element */
                        if (flag == 0)
                        {
                            while (temp != NULL)
                            {
                                /* 
                                   Must contain at least one TH element 
                                   within in the TR element 
                                */
                                if ( nodeIsTH(temp) )
                                {
                                    AttVal* av;
                                    for (av = temp->attributes; av != NULL; av = av->next)
                                    {
                                        if ( attrIsCOLSPAN(av)
                                             && (atoi(av->value) > 1) )
                                            validColSpanColumns = no;

                                        if ( attrIsROWSPAN(av)
                                             && (atoi(av->value) > 1) )
                                            validColSpanRows = no;
                                    }
                                }

                                temp = temp->next;
                            }    

                            flag = 1;
                        }
                    }
                }
            
                TNode = TNode->next;
            }

            /* Displays HTML 4 Table Algorithm when multiple column of headers used */
            if (validColSpanRows == no)
            {
                TY_(ReportAccessError)( doc, node, DATA_TABLE_REQUIRE_MARKUP_ROW_HEADERS );
                TY_(Dialogue)( doc, TEXT_HTML_T_ALGORITHM );
            }

            if (validColSpanColumns == no)
            {
                TY_(ReportAccessError)( doc, node, DATA_TABLE_REQUIRE_MARKUP_COLUMN_HEADERS );
                TY_(Dialogue)( doc, TEXT_HTML_T_ALGORITHM );
            }
        }
    }
}


/****************************************************
* CheckTable
*
* Checks the TABLE element to ensure that the
* table is not missing any headers.  Must have either
* a row or column of headers.  
****************************************************/

static void CheckTable( TidyDocImpl* doc, Node* node )
{
    Node* TNode;
    Node* temp;

    tmbstr word = NULL;

    int numTR = 0;

    Bool HasSummary = no;
    Bool HasCaption = no;

    if (Level3_Enabled( doc ))
    {
        AttVal* av;
        /* Table must have a 'SUMMARY' describing the purpose of the table */
        for (av = node->attributes; av != NULL; av = av->next)
        {
            if ( attrIsSUMMARY(av) )
            {
                if ( hasValue(av) )
                {
                    HasSummary = yes;

                    if (AttrContains(av, "summary") && 
                        AttrContains(av, "table"))
                    {
                        TY_(ReportAccessError)( doc, node, TABLE_SUMMARY_INVALID_PLACEHOLDER );
                    }
                }

                if ( av->value == NULL || TY_(tmbstrlen)(av->value) == 0 )
                {
                    HasSummary = yes;
                    TY_(ReportAccessError)( doc, node, TABLE_SUMMARY_INVALID_NULL );
                }
                else if ( IsWhitespace(av->value) && TY_(tmbstrlen)(av->value) > 0 )
                {
                    HasSummary = yes;
                    TY_(ReportAccessError)( doc, node, TABLE_SUMMARY_INVALID_SPACES );
                }
            }
        }

        /* TABLE must have content. */
        if (node->content == NULL)
        {
            TY_(ReportAccessError)( doc, node, DATA_TABLE_MISSING_HEADERS);
        
            return;
        }
    }

    if (Level1_Enabled( doc ))
    {
        /* Checks for multiple headers */
        CheckMultiHeaders( doc, node );
    }
    
    if (Level2_Enabled( doc ))
    {
        /* Table must have a CAPTION describing the purpose of the table */
        if ( nodeIsCAPTION(node->content) )
        {
            TNode = node->content;

            if (TNode->content && TNode->content->tag == NULL)
            {
                word = getTextNodeClear( doc, TNode);
            }

            if ( !IsWhitespace(word) )
            {
                HasCaption = yes;
            }
        }

        if (HasCaption == no)
        {
            TY_(ReportAccessError)( doc, node, TABLE_MISSING_CAPTION);
        }
    }

    
    if (node->content != NULL)
    {
        if ( nodeIsCAPTION(node->content) && nodeIsTR(node->content->next) )
        {
            CheckColumns( doc, node->content->next );
        }
        else if ( nodeIsTR(node->content) )
        {
            CheckColumns( doc, node->content );
        }
    }
    
    if ( ! doc->access.HasValidColumnHeaders )
    {
        if (node->content != NULL)
        {
            if ( nodeIsCAPTION(node->content) && nodeIsTR(node->content->next) )
            {
                CheckRows( doc, node->content->next);
            }
            else if ( nodeIsTR(node->content) )
            {
                CheckRows( doc, node->content);
            }
        }
    }
    
    
    if (Level3_Enabled( doc ))
    {
        /* Suppress warning for missing 'SUMMARY for HTML 2.0 and HTML 3.2 */
        if (HasSummary == no)
        {
            TY_(ReportAccessError)( doc, node, TABLE_MISSING_SUMMARY);
        }
    }

    if (Level2_Enabled( doc ))
    {
        if (node->content != NULL)
        {
            temp = node->content;

            while (temp != NULL)
            {
                if ( nodeIsTR(temp) )
                {
                    numTR++;
                }

                temp = temp->next;
            }

            if (numTR == 1)
            {
                TY_(ReportAccessError)( doc, node, LAYOUT_TABLES_LINEARIZE_PROPERLY);
            }
        }
    
        if ( doc->access.HasTH )
        {
            TY_(ReportAccessError)( doc, node, LAYOUT_TABLE_INVALID_MARKUP);
        }
    }

    if (Level1_Enabled( doc ))
    {
        if ( doc->access.CheckedHeaders == 2 )
        {
            if ( !doc->access.HasValidRowHeaders &&
                 !doc->access.HasValidColumnHeaders &&
                 !doc->access.HasInvalidRowHeader &&
                 !doc->access.HasInvalidColumnHeader  )
            {
                TY_(ReportAccessError)( doc, node, DATA_TABLE_MISSING_HEADERS);
            }

            if ( !doc->access.HasValidRowHeaders && 
                 doc->access.HasInvalidRowHeader )
            {
                TY_(ReportAccessError)( doc, node, DATA_TABLE_MISSING_HEADERS_ROW);
            }

            if ( !doc->access.HasValidColumnHeaders &&
                 doc->access.HasInvalidColumnHeader )
            {
                TY_(ReportAccessError)( doc, node, DATA_TABLE_MISSING_HEADERS_COLUMN);
            }
        }
    }
}


/***************************************************
* CheckASCII
* 
* Checks for valid text equivalents for XMP and PRE
* elements for ASCII art.  Ensures that there is
* a skip over link to skip multi-lined ASCII art.
***************************************************/

static void CheckASCII( TidyDocImpl* doc, Node* node )
{
    Node* temp1;
    Node* temp2;

    tmbstr skipOver = NULL;
    Bool IsAscii = no;
    int HasSkipOverLink = 0;
        
    unsigned int i, x;
    int newLines = -1;
    tmbchar compareLetter;
    int matchingCount = 0;
    AttVal* av;
    
    if (Level1_Enabled( doc ) && node->content)
    {
        /* 
           Checks the text within the PRE and XMP tags to see if ascii 
           art is present 
        */
        for (i = node->content->start + 1; i < node->content->end; i++)
        {
            matchingCount = 0;

            /* Counts the number of lines of text */
            if (doc->lexer->lexbuf[i] == '\n')
            {
                newLines++;
            }
            
            compareLetter = doc->lexer->lexbuf[i];

            /* Counts consecutive character matches */
            for (x = i; x < i + 5; x++)
            {
                if (doc->lexer->lexbuf[x] == compareLetter)
                {
                    matchingCount++;
                }

                else
                {
                    break;
                }
            }

            /* Must have at least 5 consecutive character matches */
            if (matchingCount >= 5)
            {
                break;
            }
        }

        /* 
           Must have more than 6 lines of text OR 5 or more consecutive 
           letters that are the same for there to be ascii art 
        */
        if (newLines >= 6 || matchingCount >= 5)
        {
            IsAscii = yes;
        }

        /* Checks for skip over link if ASCII art is present */
        if (IsAscii == yes)
        {
            if (node->prev != NULL && node->prev->prev != NULL)
            {
                temp1 = node->prev->prev;

                /* Checks for 'HREF' attribute */
                for (av = temp1->attributes; av != NULL; av = av->next)
                {
                    if ( attrIsHREF(av) && hasValue(av) )
                    {
                        skipOver = av->value;
                        HasSkipOverLink++;
                    }
                }
            }
        }
    }

    if (Level2_Enabled( doc ))
    {
        /* 
           Checks for A element following PRE to ensure proper skipover link
           only if there is an A element preceding PRE.
        */
        if (HasSkipOverLink == 1)
        {
            if ( nodeIsA(node->next) )
            {
                temp2 = node->next;
                
                /* Checks for 'NAME' attribute */
                for (av = temp2->attributes; av != NULL; av = av->next)
                {
                    if ( attrIsNAME(av) && hasValue(av) )
                    {
                        /* 
                           Value within the 'HREF' attribute must be the same
                           as the value within the 'NAME' attribute for valid
                           skipover.
                        */
                        if ( strstr(skipOver, av->value) != NULL )
                        {
                            HasSkipOverLink++;
                        }
                    }
                }
            }
        }

        if (IsAscii == yes)
        {
            TY_(ReportAccessError)( doc, node, ASCII_REQUIRES_DESCRIPTION);
            if (Level3_Enabled( doc ) && (HasSkipOverLink < 2))
                TY_(ReportAccessError)( doc, node, SKIPOVER_ASCII_ART);
        }

    }
}


/***********************************************************
* CheckFormControls
*
* <form> must have valid 'FOR' attribute, and <label> must
* have valid 'ID' attribute for valid form control.
***********************************************************/

static void CheckFormControls( TidyDocImpl* doc, Node* node )
{
    if ( !doc->access.HasValidFor &&
         doc->access.HasValidId )
    {
        TY_(ReportAccessError)( doc, node, ASSOCIATE_LABELS_EXPLICITLY_FOR);
    }    

    if ( !doc->access.HasValidId &&
         doc->access.HasValidFor )
    {
        TY_(ReportAccessError)( doc, node, ASSOCIATE_LABELS_EXPLICITLY_ID);
    }

    if ( !doc->access.HasValidId &&
         !doc->access.HasValidFor )
    {
        TY_(ReportAccessError)( doc, node, ASSOCIATE_LABELS_EXPLICITLY);
    }
}


/************************************************************
* CheckLabel
*
* Check for valid 'FOR' attribute within the LABEL element
************************************************************/

static void CheckLabel( TidyDocImpl* doc, Node* node )
{
    if (Level2_Enabled( doc ))
    {    
        /* Checks for valid 'FOR' attribute */
        AttVal* av = attrGetFOR( node );
        if ( hasValue(av) )
            doc->access.HasValidFor = yes;

        if ( ++doc->access.ForID == 2 )
        {
            doc->access.ForID = 0;
            CheckFormControls( doc, node );
        }
    }
}


/************************************************************
* CheckInputLabel
* 
* Checks for valid 'ID' attribute within the INPUT element.
* Checks to see if there is a LABEL directly before
* or after the INPUT element determined by the 'TYPE'.  
* Each INPUT element must have a LABEL describing the form.
************************************************************/

static void CheckInputLabel( TidyDocImpl* doc, Node* node )
{
    if (Level2_Enabled( doc ))
    {
        AttVal* av;

        /* Checks attributes within the INPUT element */
        for (av = node->attributes; av != NULL; av = av->next)
        {
            /* Must have valid 'ID' value */
            if ( attrIsID(av) && hasValue(av) )
                doc->access.HasValidId = yes;
        }

        if ( ++doc->access.ForID == 2 )
        {
            doc->access.ForID = 0;
            CheckFormControls( doc, node );
        }
    }
}


/***************************************************************
* CheckInputAttributes 
*
* INPUT element must have a valid 'ALT' attribute if the
* 'VALUE' attribute is present.
***************************************************************/

static void CheckInputAttributes( TidyDocImpl* doc, Node* node )
{
    Bool HasAlt = no;
    Bool MustHaveAlt = no;
    AttVal* av;

    /* Checks attributes within the INPUT element */
    for (av = node->attributes; av != NULL; av = av->next)
    {
        /* 'VALUE' must be found if the 'TYPE' is 'text' or 'checkbox' */
        if ( attrIsTYPE(av) && hasValue(av) )
        {
            if (Level1_Enabled( doc ))
            {
                if (AttrValueIs(av, "image"))
                {
                    MustHaveAlt = yes;
                }
            }

        }

        if ( attrIsALT(av) && hasValue(av) )
        {
            HasAlt = yes;
        }
    }

    if ( MustHaveAlt && !HasAlt )
    {
        TY_(ReportAccessError)( doc, node, IMG_BUTTON_MISSING_ALT );
    }

}


/***************************************************************
* CheckFrameSet
*
* Frameset must have valid NOFRAME section.  Must contain some 
* text but must not contain information telling user to update 
* browsers, 
***************************************************************/

static void CheckFrameSet( TidyDocImpl* doc, Node* node )
{
    Node* temp;
    Bool HasNoFrames = no;

    if (Level1_Enabled( doc ))
    {
        if ( doc->badAccess & BA_INVALID_LINK_NOFRAMES )
        {
           TY_(ReportAccessError)( doc, node, NOFRAMES_INVALID_LINK);
           doc->badAccess &= ~BA_INVALID_LINK_NOFRAMES; /* emit only once */
        }
        for ( temp = node->content; temp != NULL ; temp = temp->next )
        {
            if ( nodeIsNOFRAMES(temp) )
            {
                HasNoFrames = yes;

                if ( temp->content && nodeIsP(temp->content->content) )
                {
                    Node* para = temp->content->content;
                    if ( TY_(nodeIsText)(para->content) )
                    {
                        ctmbstr word = textFromOneNode( doc, para->content );
                        if ( word && strstr(word, "browser") != NULL )
                            TY_(ReportAccessError)( doc, para, NOFRAMES_INVALID_CONTENT );
                    }
                }
                else if (temp->content == NULL)
                    TY_(ReportAccessError)( doc, temp, NOFRAMES_INVALID_NO_VALUE);
                else if ( temp->content &&
                          IsWhitespace(textFromOneNode(doc, temp->content)) )
                    TY_(ReportAccessError)( doc, temp, NOFRAMES_INVALID_NO_VALUE);
            }
        }

        if (HasNoFrames == no)
            TY_(ReportAccessError)( doc, node, FRAME_MISSING_NOFRAMES);
    }
}


/***********************************************************
* CheckHeaderNesting
*
* Checks for heading increases and decreases.  Headings must
* not increase by more than one header level, but may
* decrease at from any level to any level.  Text within 
* headers must not be more than 20 words in length.  
***********************************************************/

static void CheckHeaderNesting( TidyDocImpl* doc, Node* node )
{
    Node* temp;
    unsigned int i;
    int numWords = 1;

    Bool IsValidIncrease = no;
    Bool NeedsDescription = no;

    if (Level2_Enabled( doc ))
    {
        /* 
           Text within header element cannot contain more than 20 words without
           a separate description
        */
        if (node->content != NULL && node->content->tag == NULL)
        {
            ctmbstr word = textFromOneNode( doc, node->content);

            for (i = 0; i < TY_(tmbstrlen)(word); i++)
            {
                if (word[i] == ' ')
                {
                    numWords++;
                }
            }

            if (numWords > 20)
            {
                NeedsDescription = yes;
            }
        }

        /* Header following must be same level or same plus 1 for
        ** valid heading increase size.  E.g. H1 -> H1, H2.  H3 -> H3, H4
        */
        if ( TY_(nodeIsHeader)(node) )
        {
            unsigned int level = TY_(nodeHeaderLevel)( node );
            IsValidIncrease = yes;

            for ( temp = node->next; temp != NULL; temp = temp->next )
            {
                unsigned int nested = TY_(nodeHeaderLevel)( temp );
                if ( nested >= level )
                {
                    IsValidIncrease = ( nested <= level + 1 );
                    break;
                }
            }
        }

        if ( !IsValidIncrease )
            TY_(ReportAccessError)( doc, node, HEADERS_IMPROPERLY_NESTED );
    
        if ( NeedsDescription )
            TY_(ReportAccessError)( doc, node, HEADER_USED_FORMAT_TEXT );    
    }
}


/*************************************************************
* CheckParagraphHeader
*
* Checks to ensure that P elements are not headings.  Must be
* greater than 10 words in length, and they must not be in bold,
* or italics, or underlined, etc.
*************************************************************/

static void CheckParagraphHeader( TidyDocImpl* doc, Node* node )
{
    Bool IsNotHeader = no;
    Node* temp;

    if (Level2_Enabled( doc ))
    {
        /* Cannot contain text formatting elements */
        if (node->content != NULL)   
        {                     
            if (node->content->tag != NULL)
            {
                temp = node->content;

                while (temp != NULL)
                {
                    if (temp->tag == NULL)
                    {
                        IsNotHeader = yes;
                        break;
                    }
                        
                    temp = temp->next;
                }
            }

            if ( !IsNotHeader )
            {
                if ( nodeIsSTRONG(node->content) )
                {
                    TY_(ReportAccessError)( doc, node, POTENTIAL_HEADER_BOLD);
                }

                if ( nodeIsU(node->content) )
                {
                    TY_(ReportAccessError)( doc, node, POTENTIAL_HEADER_UNDERLINE);
                }

                if ( nodeIsEM(node->content) )
                {
                    TY_(ReportAccessError)( doc, node, POTENTIAL_HEADER_ITALICS);
                }
            }
        }
    }
}


/****************************************************************
* CheckEmbed
*
* Checks to see if 'SRC' is a multimedia type.  Must have 
* syncronized captions if used.
****************************************************************/

static void CheckEmbed( TidyDocImpl* doc, Node* node )
{
    if (Level1_Enabled( doc ))
    {
        AttVal* av = attrGetSRC( node );
        if ( hasValue(av) && IsValidMediaExtension(av->value) )
        {
             TY_(ReportAccessError)( doc, node, MULTIMEDIA_REQUIRES_TEXT );
        }
    }
}


/*********************************************************************
* CheckHTMLAccess
*
* Checks HTML element for valid 'LANG' attribute.  Must be a valid
* language.  ie. 'fr' or 'en'
********************************************************************/

static void CheckHTMLAccess( TidyDocImpl* doc, Node* node )
{
    Bool ValidLang = no;

    if (Level3_Enabled( doc ))
    {
        AttVal* av = attrGetLANG( node );
        if ( av )
        {
            ValidLang = yes;
            if ( !hasValue(av) )
                TY_(ReportAccessError)( doc, node, LANGUAGE_INVALID );
        }
        if ( !ValidLang )
            TY_(ReportAccessError)( doc, node, LANGUAGE_NOT_IDENTIFIED );
    }
}


/********************************************************
* CheckBlink
*
* Document must not contain the BLINK element.  
* It is invalid HTML/XHTML.
*********************************************************/

static void CheckBlink( TidyDocImpl* doc, Node* node )
{
    
    if (Level2_Enabled( doc ))
    {
        /* Checks to see if text is found within the BLINK element. */
        if ( TY_(nodeIsText)(node->content) )
        {
            ctmbstr word = textFromOneNode( doc, node->content );
            if ( !IsWhitespace(word) )
            {
                TY_(ReportAccessError)( doc, node, REMOVE_BLINK_MARQUEE );
            }
        }
    }
}


/********************************************************
* CheckMarquee
*
* Document must not contain the MARQUEE element.
* It is invalid HTML/XHTML.
********************************************************/


static void CheckMarquee( TidyDocImpl* doc, Node* node )
{
    if (Level2_Enabled( doc ))
    {
        /* Checks to see if there is text in between the MARQUEE element */
        if ( TY_(nodeIsText)(node) )
        {
            ctmbstr word = textFromOneNode( doc, node->content);
            if ( !IsWhitespace(word) )
            {
                TY_(ReportAccessError)( doc, node, REMOVE_BLINK_MARQUEE );
            }
        }
    }
}


/**********************************************************
* CheckLink
*
* 'REL' attribute within the LINK element must not contain
* 'stylesheet'.  HTML/XHTML document is unreadable when
* style sheets are applied.  -- CPR huh?
**********************************************************/

static void CheckLink( TidyDocImpl* doc, Node* node )
{
    Bool HasRel = no;
    Bool HasType = no;

    if (Level1_Enabled( doc ))
    {
        AttVal* av;
        /* Check for valid 'REL' and 'TYPE' attribute */
        for (av = node->attributes; av != NULL; av = av->next)
        {
            if ( attrIsREL(av) && hasValue(av) )
            {
                if (AttrContains(av, "stylesheet"))
                    HasRel = yes;
            }

            if ( attrIsTYPE(av) && hasValue(av) )
            {
                HasType = yes;
            }
        }

        if (HasRel && HasType)
            TY_(ReportAccessError)( doc, node, STYLESHEETS_REQUIRE_TESTING_LINK );
    }
}


/*******************************************************
* CheckStyle
*
* Document must not contain STYLE element.  HTML/XHTML 
* document is unreadable when style sheets are applied.
*******************************************************/

static void CheckStyle( TidyDocImpl* doc, Node* node )
{
    if (Level1_Enabled( doc ))
    {
        TY_(ReportAccessError)( doc, node, STYLESHEETS_REQUIRE_TESTING_STYLE_ELEMENT );
    }
}


/*************************************************************
* DynamicContent
*
* Verify that equivalents of dynamic content are updated and 
* available as often as the dynamic content.
*************************************************************/


static void DynamicContent( TidyDocImpl* doc, Node* node )
{
    if (Level1_Enabled( doc ))
    {
        unsigned int msgcode = 0;
        if ( nodeIsAPPLET(node) )
            msgcode = TEXT_EQUIVALENTS_REQUIRE_UPDATING_APPLET;
        else if ( nodeIsSCRIPT(node) )
            msgcode = TEXT_EQUIVALENTS_REQUIRE_UPDATING_SCRIPT;
        else if ( nodeIsOBJECT(node) )
            msgcode = TEXT_EQUIVALENTS_REQUIRE_UPDATING_OBJECT;

        if ( msgcode )
            TY_(ReportAccessError)( doc, node, msgcode );
    }
}


/*************************************************************
* ProgrammaticObjects
*
* Verify that the page is usable when programmatic objects 
* are disabled.
*************************************************************/

static void ProgrammaticObjects( TidyDocImpl* doc, Node* node )
{
    if (Level1_Enabled( doc ))
    {
        int msgcode = 0;
        if ( nodeIsSCRIPT(node) )
            msgcode = PROGRAMMATIC_OBJECTS_REQUIRE_TESTING_SCRIPT;
        else if ( nodeIsOBJECT(node) )
            msgcode = PROGRAMMATIC_OBJECTS_REQUIRE_TESTING_OBJECT;
        else if ( nodeIsEMBED(node) )
            msgcode = PROGRAMMATIC_OBJECTS_REQUIRE_TESTING_EMBED;
        else if ( nodeIsAPPLET(node) )
            msgcode = PROGRAMMATIC_OBJECTS_REQUIRE_TESTING_APPLET;

        if ( msgcode )
            TY_(ReportAccessError)( doc, node, msgcode );
    }
}


/*************************************************************
* AccessibleCompatible
*
* Verify that programmatic objects are directly accessible.
*************************************************************/

static void AccessibleCompatible( TidyDocImpl* doc, Node* node )
{
    if (Level1_Enabled( doc ))
    {
        int msgcode = 0;
        if ( nodeIsSCRIPT(node) )
            msgcode = ENSURE_PROGRAMMATIC_OBJECTS_ACCESSIBLE_SCRIPT;
        else if ( nodeIsOBJECT(node) )
            msgcode = ENSURE_PROGRAMMATIC_OBJECTS_ACCESSIBLE_OBJECT;
        else if ( nodeIsEMBED(node) )
            msgcode = ENSURE_PROGRAMMATIC_OBJECTS_ACCESSIBLE_EMBED;
        else if ( nodeIsAPPLET(node) )
            msgcode = ENSURE_PROGRAMMATIC_OBJECTS_ACCESSIBLE_APPLET;

        if ( msgcode )
            TY_(ReportAccessError)( doc, node, msgcode );
    }
}


/**************************************************
* CheckFlicker
*
* Verify that the page does not cause flicker.
**************************************************/

static void CheckFlicker( TidyDocImpl* doc, Node* node )
{
    if (Level1_Enabled( doc ))
    {
        int msgcode = 0;
        if ( nodeIsSCRIPT(node) )
            msgcode = REMOVE_FLICKER_SCRIPT;
        else if ( nodeIsOBJECT(node) )
            msgcode = REMOVE_FLICKER_OBJECT;
        else if ( nodeIsEMBED(node) )
            msgcode = REMOVE_FLICKER_EMBED;
        else if ( nodeIsAPPLET(node) )
            msgcode = REMOVE_FLICKER_APPLET;

        /* Checks for animated gif within the <img> tag. */
        else if ( nodeIsIMG(node) )
        {
            AttVal* av = attrGetSRC( node );
            if ( hasValue(av) )
            {
                tmbchar ext[20];
                GetFileExtension( av->value, ext, sizeof(ext) );
                if ( TY_(tmbstrcasecmp)(ext, ".gif") == 0 )
                    msgcode = REMOVE_FLICKER_ANIMATED_GIF;
            }
        }            

        if ( msgcode )
            TY_(ReportAccessError)( doc, node, msgcode );
    }
}


/**********************************************************
* CheckDeprecated
*
* APPLET, BASEFONT, CENTER, FONT, ISINDEX, 
* S, STRIKE, and U should not be used.  Becomes deprecated
* HTML if any of the above are used.
**********************************************************/

static void CheckDeprecated( TidyDocImpl* doc, Node* node )
{
    if (Level2_Enabled( doc ))
    {
        int msgcode = 0;
        if ( nodeIsAPPLET(node) )
            msgcode = REPLACE_DEPRECATED_HTML_APPLET;
        else if ( nodeIsBASEFONT(node) )
            msgcode = REPLACE_DEPRECATED_HTML_BASEFONT;
        else if ( nodeIsCENTER(node) )
            msgcode = REPLACE_DEPRECATED_HTML_CENTER;
        else if ( nodeIsDIR(node) )
            msgcode = REPLACE_DEPRECATED_HTML_DIR;
        else if ( nodeIsFONT(node) )
            msgcode = REPLACE_DEPRECATED_HTML_FONT;
        else if ( nodeIsISINDEX(node) )
            msgcode = REPLACE_DEPRECATED_HTML_ISINDEX;
        else if ( nodeIsMENU(node) )
            msgcode = REPLACE_DEPRECATED_HTML_MENU;
        else if ( nodeIsS(node) )
            msgcode = REPLACE_DEPRECATED_HTML_S;
        else if ( nodeIsSTRIKE(node) )
            msgcode = REPLACE_DEPRECATED_HTML_STRIKE;
        else if ( nodeIsU(node) )
            msgcode = REPLACE_DEPRECATED_HTML_U;

        if ( msgcode )
            TY_(ReportAccessError)( doc, node, msgcode );
    }
}


/************************************************************
* CheckScriptKeyboardAccessible
*
* Elements must have a device independent event handler if 
* they have any of the following device dependent event 
* handlers. 
************************************************************/

static void CheckScriptKeyboardAccessible( TidyDocImpl* doc, Node* node )
{
    Node* content;
    int HasOnMouseDown = 0;
    int HasOnMouseUp = 0;
    int HasOnClick = 0;
    int HasOnMouseOut = 0;
    int HasOnMouseOver = 0;
    int HasOnMouseMove = 0;

    if (Level2_Enabled( doc ))
    {
        AttVal* av;
        /* Checks all elements for their attributes */
        for (av = node->attributes; av != NULL; av = av->next)
        {
            /* Must also have 'ONKEYDOWN' attribute with 'ONMOUSEDOWN' */
            if ( attrIsOnMOUSEDOWN(av) )
                HasOnMouseDown++;

            /* Must also have 'ONKEYUP' attribute with 'ONMOUSEUP' */
            if ( attrIsOnMOUSEUP(av) )
                HasOnMouseUp++;

            /* Must also have 'ONKEYPRESS' attribute with 'ONCLICK' */
            if ( attrIsOnCLICK(av) )
                HasOnClick++;

            /* Must also have 'ONBLUR' attribute with 'ONMOUSEOUT' */
            if ( attrIsOnMOUSEOUT(av) )
                HasOnMouseOut++;

            if ( attrIsOnMOUSEOVER(av) )
                HasOnMouseOver++;

            if ( attrIsOnMOUSEMOVE(av) )
                HasOnMouseMove++;

            if ( attrIsOnKEYDOWN(av) )
                HasOnMouseDown++;

            if ( attrIsOnKEYUP(av) )
                HasOnMouseUp++;

            if ( attrIsOnKEYPRESS(av) )
                HasOnClick++;

            if ( attrIsOnBLUR(av) )
                HasOnMouseOut++;
        }

        if ( HasOnMouseDown == 1 )
            TY_(ReportAccessError)( doc, node, SCRIPT_NOT_KEYBOARD_ACCESSIBLE_ON_MOUSE_DOWN);

        if ( HasOnMouseUp == 1 )
            TY_(ReportAccessError)( doc, node, SCRIPT_NOT_KEYBOARD_ACCESSIBLE_ON_MOUSE_UP);

        if ( HasOnClick == 1 )
            TY_(ReportAccessError)( doc, node, SCRIPT_NOT_KEYBOARD_ACCESSIBLE_ON_CLICK);
        if ( HasOnMouseOut == 1 )
            TY_(ReportAccessError)( doc, node, SCRIPT_NOT_KEYBOARD_ACCESSIBLE_ON_MOUSE_OUT);

        if ( HasOnMouseOver == 1 )
            TY_(ReportAccessError)( doc, node, SCRIPT_NOT_KEYBOARD_ACCESSIBLE_ON_MOUSE_OVER);

        if ( HasOnMouseMove == 1 )
            TY_(ReportAccessError)( doc, node, SCRIPT_NOT_KEYBOARD_ACCESSIBLE_ON_MOUSE_MOVE);

        /* Recursively check all child nodes.
         */
        for ( content = node->content; content != NULL; content = content->next )
            CheckScriptKeyboardAccessible( doc, content );
    }
}


/**********************************************************
* CheckMetaData
*
* Must have at least one of these elements in the document.
* META, LINK, TITLE or ADDRESS.  <meta> must contain 
* a "content" attribute that doesn't contain a URL, and
* an "http-Equiv" attribute that doesn't contain 'refresh'.
**********************************************************/


static Bool CheckMetaData( TidyDocImpl* doc, Node* node, Bool HasMetaData )
{
    Bool HasHttpEquiv = no;
    Bool HasContent = no;
    Bool ContainsAttr = no;

    if (Level2_Enabled( doc ))
    {
        if ( nodeIsMETA(node) )
        {
            AttVal* av;
            for (av = node->attributes; av != NULL; av = av->next)
            {
                if ( attrIsHTTP_EQUIV(av) && hasValue(av) )
                {
                    ContainsAttr = yes;

                    /* Must not have an auto-refresh */
                    if (AttrValueIs(av, "refresh"))
                    {
                        HasHttpEquiv = yes;
                        TY_(ReportAccessError)( doc, node, REMOVE_AUTO_REFRESH );
                    }
                }

                if ( attrIsCONTENT(av) && hasValue(av) )
                {
                    ContainsAttr = yes;

                    /* If the value is not an integer, then it must not be a URL */
                    if ( TY_(tmbstrncmp)(av->value, "http:", 5) == 0)
                    {
                        HasContent = yes;
                        TY_(ReportAccessError)( doc, node, REMOVE_AUTO_REDIRECT);
                    }
                }
                if (TY_(IsHTML5Mode)(doc) && attrIsCHARSET(av) && hasValue(av))
                {
                    ContainsAttr = yes;
                }
            }
        
            if ( HasContent || HasHttpEquiv )
            {
                HasMetaData = yes;
                TY_(ReportAccessError)( doc, node, METADATA_MISSING_REDIRECT_AUTOREFRESH);
            }
            else
            {
                if ( ContainsAttr && !HasContent && !HasHttpEquiv )
                    HasMetaData = yes;                    
            }
        }

        if ( !HasMetaData && 
             nodeIsADDRESS(node) &&
             nodeIsA(node->content) )
        {
            HasMetaData = yes;
        }
            
        if ( !HasMetaData &&
             !nodeIsTITLE(node) &&
             TY_(nodeIsText)(node->content) )
        {
            ctmbstr word = textFromOneNode( doc, node->content );
            if ( !IsWhitespace(word) )
                HasMetaData = yes;
        }

        if( !HasMetaData && nodeIsLINK(node) )
        {
            AttVal* av = attrGetREL(node);
            if( !AttrContains(av, "stylesheet") )
                HasMetaData = yes;
        }
            
        /* Check for MetaData */
        for ( node = node->content; node; node = node->next )
        {
            HasMetaData = CheckMetaData( doc, node, HasMetaData );
        }
    }
    return HasMetaData;
}


/*******************************************************
* MetaDataPresent
*
* Determines if MetaData is present in document
*******************************************************/

static void MetaDataPresent( TidyDocImpl* doc, Node* node )
{
    if (Level2_Enabled( doc ))
    {
        TY_(ReportAccessError)( doc, node, METADATA_MISSING );
    }
}


/*****************************************************
* CheckDocType
*
* Checks that every HTML/XHTML document contains a 
* '!DOCTYPE' before the root node. ie.  <HTML>
*****************************************************/

static void CheckDocType( TidyDocImpl* doc )
{
    if (Level2_Enabled( doc ))
    {
        Node* DTnode = TY_(FindDocType)(doc);

        /* If the doctype has been added by tidy, DTnode->end will be 0. */
        if (DTnode && DTnode->end != 0)
        {
            ctmbstr word = textFromOneNode( doc, DTnode);
            if (TY_(IsHTML5Mode)(doc))
            {
                if ((strstr(word, "HTML") == NULL) &&
                    (strstr(word, "html") == NULL))
                    DTnode = NULL;
            }
            else {
                if ((strstr(word, "HTML PUBLIC") == NULL) &&
                    (strstr(word, "html PUBLIC") == NULL))
                    DTnode = NULL;
            }
        }
        if (!DTnode)
           TY_(ReportAccessError)( doc, &doc->root, DOCTYPE_MISSING);
    }
}



/********************************************************
* CheckMapLinks
*
* Checks to see if an HREF for A element matches HREF
* for AREA element.  There must be an HREF attribute 
* of an A element for every HREF of an AREA element. 
********************************************************/

static Bool urlMatch( ctmbstr url1, ctmbstr url2 )
{
  /* TODO: Make host part case-insensitive and
  ** remainder case-sensitive.
  */
  return ( TY_(tmbstrcmp)( url1, url2 ) == 0 );
}

static Bool FindLinkA( TidyDocImpl* doc, Node* node, ctmbstr url )
{
  Bool found = no;
  for ( node = node->content; !found && node; node = node->next )
  {
    if ( nodeIsA(node) )
    {
      AttVal* href = attrGetHREF( node );
      found = ( hasValue(href) && urlMatch(url, href->value) );
    }
    else
        found = FindLinkA( doc, node, url );
  }
  return found;
}

static void CheckMapLinks( TidyDocImpl* doc, Node* node )
{
    Node* child;

    if (!Level3_Enabled( doc ))
        return;

    /* Stores the 'HREF' link of an AREA element within a MAP element */
    for ( child = node->content; child != NULL; child = child->next )
    {
        if ( nodeIsAREA(child) )
        {
            /* Checks for 'HREF' attribute */                
            AttVal* href = attrGetHREF( child );
            if ( hasValue(href) &&
                 !FindLinkA( doc, &doc->root, href->value ) )
            {
                TY_(ReportAccessError)( doc, node, IMG_MAP_CLIENT_MISSING_TEXT_LINKS );
            }
        }
    }
}


/****************************************************
* CheckForStyleAttribute
*
* Checks all elements within the document to check 
* for the use of 'STYLE' attribute.
****************************************************/

static void CheckForStyleAttribute( TidyDocImpl* doc, Node* node )
{
    Node* content;
    if (Level1_Enabled( doc ))
    {
        /* Must not contain 'STYLE' attribute */
        AttVal* style = attrGetSTYLE( node );
        if ( hasValue(style) )
        {
            TY_(ReportAccessError)( doc, node, STYLESHEETS_REQUIRE_TESTING_STYLE_ATTR );
        }
    }

    /* Recursively check all child nodes.
    */
    for ( content = node->content; content != NULL; content = content->next )
        CheckForStyleAttribute( doc, content );
}


/*****************************************************
* CheckForListElements
*
* Checks document for list elements (<ol>, <ul>, <li>)
*****************************************************/

static void CheckForListElements( TidyDocImpl* doc, Node* node )
{
    if ( nodeIsLI(node) )
    {
        doc->access.ListElements++;
    }
    else if ( nodeIsOL(node) || nodeIsUL(node) )
    {
        doc->access.OtherListElements++;
    }

    for ( node = node->content; node != NULL; node = node->next )
    {
        CheckForListElements( doc, node );
    }
}


/******************************************************
* CheckListUsage
*
* Ensures that lists are properly used.  <ol> and <ul>
* must contain <li> within itself, and <li> must not be
* by itself.
******************************************************/

static void CheckListUsage( TidyDocImpl* doc, Node* node )
{
    int msgcode = 0;

    if (!Level2_Enabled( doc ))
        return;

    if ( nodeIsOL(node) )
        msgcode = LIST_USAGE_INVALID_OL;
    else if ( nodeIsUL(node) )
        msgcode = LIST_USAGE_INVALID_UL;

    if ( msgcode )
    {
       /*
       ** Check that OL/UL
       ** a) has LI child,
       ** b) was not added by Tidy parser
       ** IFF OL/UL node is implicit
       */
       if ( !nodeIsLI(node->content) ) {
            TY_(ReportAccessError)( doc, node, msgcode );
       } else if ( node->implicit ) {  /* if a tidy added node */
            TY_(ReportAccessError)( doc, node, LIST_USAGE_INVALID_LI );
       }
    }
    else if ( nodeIsLI(node) )
    {
        /* Check that LI parent 
        ** a) exists,
        ** b) is either OL or UL
        ** IFF the LI parent was added by Tidy
        ** ie, if it is marked 'implicit', then
        ** emit warnings LIST_USAGE_INVALID_UL or 
        ** warning LIST_USAGE_INVALID_OL tests 
        */
        if ( node->parent == NULL ||
             ( !nodeIsOL(node->parent) && !nodeIsUL(node->parent) ) )
        {
            TY_(ReportAccessError)( doc, node, LIST_USAGE_INVALID_LI );
        } else if ( node->implicit && node->parent &&
                    ( nodeIsOL(node->parent) || nodeIsUL(node->parent) ) ) {
            /* if tidy added LI node, then */
            msgcode = nodeIsUL(node->parent) ?
                LIST_USAGE_INVALID_UL : LIST_USAGE_INVALID_OL;
            TY_(ReportAccessError)( doc, node, msgcode );
        }
    }
}

/************************************************************
* InitAccessibilityChecks
*
* Initializes the AccessibilityChecks variables as necessary
************************************************************/

static void InitAccessibilityChecks( TidyDocImpl* doc, int level123 )
{
    TidyClearMemory( &doc->access, sizeof(doc->access) );
    doc->access.PRIORITYCHK = level123;
}

/************************************************************
* CleanupAccessibilityChecks
*
* Cleans up the AccessibilityChecks variables as necessary
************************************************************/


static void FreeAccessibilityChecks( TidyDocImpl* ARG_UNUSED(doc) )
{
    /* free any memory allocated for the lists

    Linked List of Links not used.  Just search document as 
    AREA tags are encountered.  Same algorithm, but no
    data structures necessary.

    current = start;
    while (current)
    {
        void    *templink = (void *)current;
        
        current = current->next;
        TidyDocFree(doc, templink);
    }
    start = NULL;
    */
}

/************************************************************
* AccessibilityChecks
*
* Traverses through the individual nodes of the tree
* and checks attributes and elements for accessibility.
* after the tree structure has been formed.
************************************************************/

static void AccessibilityCheckNode( TidyDocImpl* doc, Node* node )
{
    Node* content;
    
    /* Check BODY for color contrast */
    if ( nodeIsBODY(node) )
    {
        CheckColorContrast( doc, node );
    }

    /* Checks document for MetaData */
    else if ( nodeIsHEAD(node) )
    {
        if ( !CheckMetaData( doc, node, no ) )
          MetaDataPresent( doc, node );
    }
    
    /* Check the ANCHOR tag */
    else if ( nodeIsA(node) )
    {
        CheckAnchorAccess( doc, node );
    }

    /* Check the IMAGE tag */
    else if ( nodeIsIMG(node) )
    {
        CheckFlicker( doc, node );
        CheckColorAvailable( doc, node );
        CheckImage( doc, node );
    }

        /* Checks MAP for client-side text links */
    else if ( nodeIsMAP(node) )
    {
        CheckMapLinks( doc, node );
    }

    /* Check the AREA tag */
    else if ( nodeIsAREA(node) )
    {
        CheckArea( doc, node );
    }

    /* Check the APPLET tag */
    else if ( nodeIsAPPLET(node) )
    {
        CheckDeprecated( doc, node );
        ProgrammaticObjects( doc, node );
        DynamicContent( doc, node );
        AccessibleCompatible( doc, node );
        CheckFlicker( doc, node );
        CheckColorAvailable( doc, node );
        CheckApplet(doc, node );
    }
    
    /* Check the OBJECT tag */
    else if ( nodeIsOBJECT(node) )
    {
        ProgrammaticObjects( doc, node );
        DynamicContent( doc, node );
        AccessibleCompatible( doc, node );
        CheckFlicker( doc, node );
        CheckColorAvailable( doc, node );
        CheckObject( doc, node );
    }
    
    /* Check the FRAME tag */
    else if ( nodeIsFRAME(node) )
    {
        CheckFrame( doc, node );
    }
    
    /* Check the IFRAME tag */
    else if ( nodeIsIFRAME(node) )
    {
        CheckIFrame( doc, node );
    }
    
    /* Check the SCRIPT tag */
    else if ( nodeIsSCRIPT(node) )
    {
        DynamicContent( doc, node );
        ProgrammaticObjects( doc, node );
        AccessibleCompatible( doc, node );
        CheckFlicker( doc, node );
        CheckColorAvailable( doc, node );
        CheckScriptAcc( doc, node );
    }

    /* Check the TABLE tag */
    else if ( nodeIsTABLE(node) )
    {
        CheckColorContrast( doc, node );
        CheckTable( doc, node );
    }

    /* Check the PRE for ASCII art */
    else if ( nodeIsPRE(node) || nodeIsXMP(node) )
    {
        CheckASCII( doc, node );
    }

    /* Check the LABEL tag */
    else if ( nodeIsLABEL(node) )
    {
        CheckLabel( doc, node );
    }

    /* Check INPUT tag for validity */
    else if ( nodeIsINPUT(node) )
    {
        CheckColorAvailable( doc, node );
        CheckInputLabel( doc, node );
        CheckInputAttributes( doc, node );
    }

    /* Checks FRAMESET element for NOFRAME section */
    else if ( nodeIsFRAMESET(node) )
    {
        CheckFrameSet( doc, node );
    }
    
    /* Checks for header elements for valid header increase */
    else if ( TY_(nodeIsHeader)(node) )
    {
        CheckHeaderNesting( doc, node );
    }

    /* Checks P element to ensure that it is not a header */
    else if ( nodeIsP(node) )
    {
        CheckParagraphHeader( doc, node );
    }

    /* Checks HTML elemnt for valid 'LANG' */
    else if ( nodeIsHTML(node) )
    {
        CheckHTMLAccess( doc, node );
    }

    /* Checks BLINK for any blinking text */
    else if ( nodeIsBLINK(node) )
    {
        CheckBlink( doc, node );
    }

    /* Checks MARQUEE for any MARQUEE text */
    else if ( nodeIsMARQUEE(node) )
    {
        CheckMarquee( doc, node );
    }

    /* Checks LINK for 'REL' attribute */
    else if ( nodeIsLINK(node) )
    {
        CheckLink( doc, node );
    }

    /* Checks to see if STYLE is used */
    else if ( nodeIsSTYLE(node) )
    {
        CheckColorContrast( doc, node );
        CheckStyle( doc, node );
    }

    /* Checks to see if EMBED is used */
    else if ( nodeIsEMBED(node) )
    {
        CheckEmbed( doc, node );
        ProgrammaticObjects( doc, node );
        AccessibleCompatible( doc, node );
        CheckFlicker( doc, node );
    }

    /* Deprecated HTML if the following tags are found in the document */
    else if ( nodeIsBASEFONT(node) ||
              nodeIsCENTER(node)   ||
              nodeIsISINDEX(node)  ||
              nodeIsU(node)        ||
              nodeIsFONT(node)     ||
              nodeIsDIR(node)      ||
              nodeIsS(node)        ||
              nodeIsSTRIKE(node)   ||
              nodeIsMENU(node) )
    {
        CheckDeprecated( doc, node );
    }

    /* Checks for 'ABBR' attribute if needed */
    else if ( nodeIsTH(node) )
    {
        CheckTH( doc, node );
    }

    /* Ensures that lists are properly used */
    else if ( nodeIsLI(node) || nodeIsOL(node) || nodeIsUL(node) )
    {
        CheckListUsage( doc, node );
    }

    /* Recursively check all child nodes.
    */
    for ( content = node->content; content != NULL; content = content->next )
    {
        AccessibilityCheckNode( doc, content );
    }
}


void TY_(AccessibilityChecks)( TidyDocImpl* doc )
{
    /* Initialize */
    InitAccessibilityChecks( doc, cfg(doc, TidyAccessibilityCheckLevel) );

    /* Hello there, ladies and gentlemen... */
    TY_(Dialogue)( doc, STRING_HELLO_ACCESS );

    /* Checks all elements for script accessibility */
    CheckScriptKeyboardAccessible( doc, &doc->root );

    /* Checks entire document for the use of 'STYLE' attribute */
    CheckForStyleAttribute( doc, &doc->root );

    /* Checks for '!DOCTYPE' */
    CheckDocType( doc );

    
    /* Checks to see if stylesheets are used to control the layout */
    if ( Level2_Enabled( doc )
         && ! CheckMissingStyleSheets( doc, &doc->root ) )
    {
        TY_(ReportAccessError)( doc, &doc->root, STYLE_SHEET_CONTROL_PRESENTATION );
    }

    /* Check to see if any list elements are found within the document */
    CheckForListElements( doc, &doc->root );

    /* Recursively apply all remaining checks to 
    ** each node in document.
    */
    AccessibilityCheckNode( doc, &doc->root );

    /* Cleanup */
    FreeAccessibilityChecks( doc );
}

/* alloc.c -- Default memory allocation routines.

  (c) 1998-2006 (W3C) MIT, ERCIM, Keio University
  See tidy.h for the copyright notice.

*/

/* #define DEBUG_MEMORY very NOISY extra DEBUG of memory allocation, reallocation and free */

/* #include "tidy.h" */
/* #include "forward.h" */
/* #include "sprtf.h" */

static TidyMalloc  g_malloc  = NULL;
static TidyRealloc g_realloc = NULL;
static TidyFree    g_free    = NULL;
static TidyPanic   g_panic   = NULL;

#if defined(ENABLE_DEBUG_LOG) && defined(DEBUG_MEMORY)
static int alloccnt = 0;
static int realloccnt = 0;
static int freecnt = 0;
#endif


Bool TIDY_CALL tidySetMallocCall( TidyMalloc fmalloc )
{
  g_malloc  = fmalloc;
  return yes;
}
Bool TIDY_CALL tidySetReallocCall( TidyRealloc frealloc )
{
  g_realloc = frealloc;
  return yes;
}
Bool TIDY_CALL tidySetFreeCall( TidyFree ffree )
{
  g_free    = ffree;
  return yes;
}
Bool TIDY_CALL tidySetPanicCall( TidyPanic fpanic )
{
  g_panic   = fpanic;
  return yes;
}

static void TIDY_CALL defaultPanic( TidyAllocator* ARG_UNUSED(allocator), ctmbstr msg )
{
  if ( g_panic )
    g_panic( msg );
  else
  {
    /* 2 signifies a serious error */
    fprintf( stderr, "Fatal error: %s\n", msg );
#ifdef _DEBUG
    assert(0);
#endif
    exit(2);
  }
}

static void* TIDY_CALL defaultAlloc( TidyAllocator* allocator, size_t size )
{
    void *p = ( g_malloc ? g_malloc(size) : malloc(size) );
    if ( !p )
        defaultPanic( allocator,"Out of memory!");
#if defined(ENABLE_DEBUG_LOG) && defined(DEBUG_MEMORY)
    alloccnt++;
    SPRTF("%d: alloc   MEM %p, size %d\n", alloccnt, p, (int)size );
    if (size == 0) {
        SPRTF("NOTE: An allocation of ZERO bytes!!!!!!\n");
    }
#endif
    return p;
}

static void* TIDY_CALL defaultRealloc( TidyAllocator* allocator, void* mem, size_t newsize )
{
    void *p;
    if ( mem == NULL )
        return defaultAlloc( allocator, newsize );

    p = ( g_realloc ? g_realloc(mem, newsize) : realloc(mem, newsize) );
    if (!p)
        defaultPanic( allocator, "Out of memory!");
#if defined(ENABLE_DEBUG_LOG) && defined(DEBUG_MEMORY)
    realloccnt++;
    SPRTF("%d: realloc MEM %p, size %d\n", realloccnt, p, (int)newsize );
#endif
    return p;
}

static void TIDY_CALL defaultFree( TidyAllocator* ARG_UNUSED(allocator), void* mem )
{
    if ( mem )
    {
#if defined(ENABLE_DEBUG_LOG) && defined(DEBUG_MEMORY)
        freecnt++;
        SPRTF("%d: free    MEM %p\n", freecnt, mem );
#endif
        if ( g_free )
            g_free( mem );
        else
            free( mem );
    }
}

static const TidyAllocatorVtbl defaultVtbl = {
    defaultAlloc,
    defaultRealloc,
    defaultFree,
    defaultPanic
};

TidyAllocator TY_(g_default_allocator) = {
    &defaultVtbl
};

/*
 * DISABLEDLOCALVARIABLES
 * mode: c
 * indent-tabs-mode: nil
 * c-basic-offset: 4
 * eval: (c-set-offset 'substatement-open 0)
 * end:
 */
/* attrdict.c -- extended attribute information

   (c) 1998-2006 (W3C) MIT, ERCIM, Keio University
   See tidy.h for the copyright notice.

*/

/* #include "forward.h" */
/* #include "attrdict.h" */
/* #include "lexer.h" */

/* These items are added to elements that support them. */
#define INCLUDE_ARIA \
  { TidyAttr_ARIA_ACTIVEDESCENDANT, xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_ARIA_ATOMIC,           xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_ARIA_AUTOCOMPLETE,     xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_ARIA_BUSY,             xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_ARIA_CHECKED,          xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_ARIA_CONTROLS,         xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_ARIA_DESCRIBEDBY,      xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_ARIA_DISABLED,         xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_ARIA_DROPEFFECT,       xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_ARIA_EXPANDED,         xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_ARIA_FLOWTO,           xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_ARIA_GRABBED,          xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_ARIA_HASPOPUP,         xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_ARIA_HIDDEN,           xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_ARIA_INVALID,          xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_ARIA_LABEL,            xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_ARIA_LABELLEDBY,       xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_ARIA_LEVEL,            xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_ARIA_LIVE,             xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_ARIA_MULTILINE,        xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_ARIA_MULTISELECTABLE,  xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_ARIA_ORIENTATION,      xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_ARIA_OWNS,             xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_ARIA_POSINSET,         xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_ARIA_PRESSED,          xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_ARIA_READONLY,         xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_ARIA_RELEVANT,         xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_ARIA_REQUIRED,         xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_ARIA_SELECTED,         xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_ARIA_SETSIZE,          xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_ARIA_SORT,             xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_ARIA_VALUEMAX,         xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_ARIA_VALUEMIN,         xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_ARIA_VALUENOW,         xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_ARIA_VALUETEXT,        xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \


/* These items are added to all elements below. */
#define INCLUDE_MICRODATA \
  { TidyAttr_ITEMID,                xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_ITEMPROP,              xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_ITEMREF,               xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_ITEMSCOPE,             xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_ITEMTYPE,              xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \


/* RDFa attributes. These were moved here from the hard code in attrs.c as-is. Note that RDFa allows the
   last three items in all versions of HTML. */
#define INCLUDE_RDFA \
  { TidyAttr_ABOUT,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_DATATYPE,              xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_INLIST,                xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_PREFIX,                xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_PROPERTY,              xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_RESOURCE,              xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_TYPEOF,                xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_VOCAB,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_CONTENT,               HT20|HT32|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, \
  { TidyAttr_REL,                   HT20|HT32|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, \
  { TidyAttr_REV,                   HT20|HT32|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, \


/* These are the core attributes that can apply to _any_ element starting with
   HTML5. In general they will be marked as not supported for previous versions
   of HTML, in which case please override the attribute in the specific item
   below. **This macro must be expanded at the END of each element. **
   Most of these attributes are defined as universal for HTML here:
     https://www.w3.org/TR/html-markup/global-attributes.html
   Attribute `role` is defined as universal for HTML5 here:
     https://www.w3.org/TR/html5/dom.html#wai-aria
 */
#define INCLUDE_CORE_ATTRIBS \
  { TidyAttr_ACCESSKEY,             xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_CLASS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_CONTENTEDITABLE,       xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_CONTEXTMENU,           xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_DIR,                   xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_DRAGGABLE,             xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_DROPZONE,              xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_HIDDEN,                xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_ID,                    xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_IS,                    xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_LANG,                  xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_ROLE,                  xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_SPELLCHECK,            xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_STYLE,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_TABINDEX,              xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_TITLE,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_TRANSLATE,             xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH50 }, \
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \


/* These are the core event-handler attributes that can apply to _any_ element
   starting with HTML5. In general they will be marked as not supported for
   previous versions of HTML, in which case please override the attribute in the
   specific item below. **This macro must be expanded at the END of each 
   element. **
   Most of these attributes are defined as universal for HTML5 here:
     https://www.w3.org/TR/html-markup/global-attributes.html
   Attribute `oncuechange` is defined as universal for HTML5 here:
     https://www.w3.org/TR/html5/webappapis.html
 */
#define INCLUDE_CORE_EVENTS \
  { TidyAttr_OnABORT,               xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_OnBLUR,                xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_OnCANPLAY,             xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_OnCANPLAYTHROUGH,      xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_OnCHANGE,              xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_OnCLICK,               xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_OnCONTEXTMENU,         xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_OnCUECHANGE,           xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_OnDBLCLICK,            xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_OnDRAG,                xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_OnDRAGEND,             xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_OnDRAGENTER,           xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_OnDRAGLEAVE,           xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_OnDRAGOVER,            xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_OnDRAGSTART,           xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_OnDROP,                xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_OnDURATIONCHANGE,      xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_OnEMPTIED,             xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_OnENDED,               xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_OnERROR,               xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_OnFOCUS,               xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_OnINPUT,               xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_OnINVALID,             xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_OnKEYDOWN,             xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_OnKEYPRESS,            xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_OnKEYUP,               xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_OnLOAD,                xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_OnLOADEDDATA,          xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_OnLOADEDMETADATA,      xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_OnLOADSTART,           xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_OnMOUSEDOWN,           xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_OnMOUSEMOVE,           xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_OnMOUSEOUT,            xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_OnMOUSEOVER,           xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_OnMOUSEUP,             xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_OnMOUSEWHEEL,          xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_OnPAUSE,               xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_OnPLAY,                xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_OnPLAYING,             xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_OnPROGRESS,            xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_OnRATECHANGE,          xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_OnREADYSTATECHANGE,    xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_OnRESET,               xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_OnSCROLL,              xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_OnSEEKED,              xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_OnSEEKING,             xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_OnSELECT,              xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_OnSHOW,                xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_OnSTALLED,             xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_OnSUBMIT,              xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_OnSUSPEND,             xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_OnTIMEUPDATE,          xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_OnVOLUMECHANGE,        xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \
  { TidyAttr_OnWAITING,             xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, \


const AttrVersion TY_(W3CAttrsFor_A)[] =
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_ACCESSKEY,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_CHARSET,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|xxxx|xxxx },
  { TidyAttr_CLASS,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_COORDS,                xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|xxxx|xxxx },
  { TidyAttr_DIR,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_DOWNLOAD,              xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_HREF,                  HT20|HT32|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 },
  { TidyAttr_HREFLANG,              xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 },
  { TidyAttr_ID,                    xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_LANG,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_MEDIA,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_METHODS,               HT20|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_NAME,                  HT20|HT32|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_OnBLUR,                xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnCLICK,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnDBLCLICK,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnFOCUS,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYDOWN,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYPRESS,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYUP,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEDOWN,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEMOVE,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOUT,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOVER,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEUP,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_REL,                   HT20|HT32|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 },
  { TidyAttr_REV,                   HT20|HT32|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|xxxx|xxxx },
  { TidyAttr_SDAPREF,               HT20|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_SHAPE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|xxxx|xxxx },
  { TidyAttr_STYLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_TABINDEX,              xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_TARGET,                xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_TITLE,                 HT20|HT32|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_TYPE,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 },
  { TidyAttr_URN,                   HT20|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|XH11|XB10|xxxx|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_ABBR)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_CLASS,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_DIR,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_ID,                    xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_LANG,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnCLICK,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnDBLCLICK,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYDOWN,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYPRESS,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYUP,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEDOWN,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEMOVE,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOUT,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOVER,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEUP,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_STYLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_TITLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|XH11|XB10|xxxx|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_ACRONYM)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_CLASS,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|xxxx|xxxx }, /* CORE override */
  { TidyAttr_DIR,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_ID,                    xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|xxxx|xxxx }, /* CORE override */
  { TidyAttr_LANG,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnCLICK,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnDBLCLICK,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnKEYDOWN,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnKEYPRESS,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnKEYUP,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnMOUSEDOWN,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnMOUSEMOVE,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnMOUSEOUT,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnMOUSEOVER,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnMOUSEUP,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_STYLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_TITLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|xxxx|xxxx }, /* CORE override */
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|XH11|XB10|xxxx|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_ADDRESS)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_CLASS,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_DIR,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_ID,                    xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_LANG,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnCLICK,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnDBLCLICK,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYDOWN,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYPRESS,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYUP,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEDOWN,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEMOVE,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOUT,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOVER,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEUP,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_SDAFORM,               HT20|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_SDAPREF,               HT20|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_STYLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_TITLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|XH11|XB10|xxxx|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_APPLET)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_ALIGN,                 xxxx|HT32|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_ALT,                   xxxx|HT32|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_ARCHIVE,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_CLASS,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_CODE,                  xxxx|HT32|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_CODEBASE,              xxxx|HT32|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_HEIGHT,                xxxx|HT32|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_HSPACE,                xxxx|HT32|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_ID,                    xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_NAME,                  xxxx|HT32|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_OBJECT,                xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_STYLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_TITLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_VSPACE,                xxxx|HT32|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_WIDTH,                 xxxx|HT32|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_AREA)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_ACCESSKEY,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_ALT,                   xxxx|HT32|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 },
  { TidyAttr_CLASS,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_COORDS,                xxxx|HT32|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 },
  { TidyAttr_DIR,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_HREF,                  xxxx|HT32|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 },
  { TidyAttr_HREFLANG,              xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_ID,                    xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_LANG,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_MEDIA,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_NOHREF,                xxxx|HT32|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|xxxx|xxxx },
  { TidyAttr_OnBLUR,                xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnCLICK,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnDBLCLICK,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnFOCUS,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYDOWN,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYPRESS,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYUP,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEDOWN,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEMOVE,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOUT,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOVER,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEUP,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_REL,                   xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_SHAPE,                 xxxx|HT32|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 },
  { TidyAttr_STYLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_TABINDEX,              xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_TARGET,                xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_TITLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_TYPE,                  xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|XH11|xxxx|xxxx|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_ARTICLE)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_ASIDE)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_AUDIO)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_AUTOPLAY,              xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_CONTROLS,              xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_CROSSORIGIN,           xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_LOOP,                  xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_MEDIAGROUP,            xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_PRELOAD,               xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_SRC,                   xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_B)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_CLASS,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_DIR,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_ID,                    xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_LANG,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnCLICK,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnDBLCLICK,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYDOWN,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYPRESS,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYUP,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEDOWN,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEMOVE,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOUT,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOVER,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEUP,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_SDAFORM,               HT20|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_STYLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_TITLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|XH11|xxxx|xxxx|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_BASE)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_HREF,                  HT20|HT32|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 },
  { TidyAttr_ID,                    xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_TARGET,                xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|XB10|HT50|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_BASEFONT)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_COLOR,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_FACE,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_ID,                    xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_SIZE,                  xxxx|HT32|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                          },
};

const AttrVersion TY_(W3CAttrsFor_BDI)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_BDO)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_CLASS,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_DIR,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_ID,                    xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_LANG,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnCLICK,               xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnDBLCLICK,            xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYDOWN,             xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYPRESS,            xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYUP,               xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEDOWN,           xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEMOVE,           xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOUT,            xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOVER,           xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEUP,             xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_STYLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_TITLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|XH11|xxxx|xxxx|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_BIG)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_CLASS,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_DIR,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_ID,                    xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_LANG,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnCLICK,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnDBLCLICK,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnKEYDOWN,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnKEYPRESS,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnKEYUP,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnMOUSEDOWN,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnMOUSEMOVE,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnMOUSEOUT,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnMOUSEOVER,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnMOUSEUP,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_STYLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_TITLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|XH11|xxxx|xxxx|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_BLOCKQUOTE)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_CITE,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 },
  { TidyAttr_CLASS,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_DIR,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_ID,                    xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_LANG,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnCLICK,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnDBLCLICK,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYDOWN,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYPRESS,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYUP,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEDOWN,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEMOVE,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOUT,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOVER,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEUP,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_SDAFORM,               HT20|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_STYLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_TITLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|XH11|XB10|xxxx|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_BODY)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_ALINK,                 xxxx|HT32|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_BACKGROUND,            xxxx|HT32|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_BGCOLOR,               xxxx|HT32|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_CLASS,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_DIR,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_ID,                    xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_LANG,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_LINK,                  xxxx|HT32|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_OnAFTERPRINT,          xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_OnBEFOREPRINT,         xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_OnBEFOREUNLOAD,        xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_OnCLICK,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnDBLCLICK,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnHASHCHANGE,          xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_OnKEYDOWN,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYPRESS,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYUP,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnLOAD,                xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMESSAGE,             xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_OnMOUSEDOWN,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEMOVE,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOUT,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOVER,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEUP,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnOFFLINE,             xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_OnONLINE,              xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_OnPAGEHIDE,            xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_OnPAGESHOW,            xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_OnPOPSTATE,            xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_OnREDO,                xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_OnRESIZE,              xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_OnSTORAGE,             xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_OnUNDO,                xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_OnUNLOAD,              xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 },
  { TidyAttr_STYLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_TEXT,                  xxxx|HT32|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_TITLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_VLINK,                 xxxx|HT32|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|XH11|XB10|xxxx|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_BR)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_CLASS,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_CLEAR,                 xxxx|HT32|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_ID,                    xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_SDAPREF,               HT20|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_STYLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_TITLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|XB10|HT50|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_BUTTON)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_ACCESSKEY,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_AUTOFOCUS,             xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_CLASS,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_DIR,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_DISABLED,              xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 },
  { TidyAttr_FORM,                  xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_FORMACTION,            xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_FORMENCTYPE,           xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_FORMMETHOD,            xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_FORMNOVALIDATE,        xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_FORMTARGET,            xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_ID,                    xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_LANG,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_NAME,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 },
  { TidyAttr_OnBLUR,                xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnCLICK,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnDBLCLICK,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnFOCUS,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYDOWN,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYPRESS,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYUP,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEDOWN,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEMOVE,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOUT,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOVER,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEUP,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_STYLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_TABINDEX,              xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_TITLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_TYPE,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 },
  { TidyAttr_VALUE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 },
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|XH11|xxxx|xxxx|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_CANVAS)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_HEIGHT,                xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_WIDTH,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_CAPTION)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_ALIGN,                 xxxx|HT32|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_CLASS,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_DIR,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_ID,                    xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_LANG,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnCLICK,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnDBLCLICK,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYDOWN,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYPRESS,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYUP,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEDOWN,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEMOVE,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOUT,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOVER,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEUP,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_STYLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_TITLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|XH11|XB10|xxxx|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_CENTER)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_CLASS,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_DIR,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_ID,                    xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_LANG,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnCLICK,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnDBLCLICK,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnKEYDOWN,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnKEYPRESS,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnKEYUP,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnMOUSEDOWN,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnMOUSEMOVE,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnMOUSEOUT,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnMOUSEOVER,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnMOUSEUP,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_STYLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_TITLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_CITE)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_CLASS,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_DIR,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_ID,                    xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_LANG,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnCLICK,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnDBLCLICK,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYDOWN,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYPRESS,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYUP,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEDOWN,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEMOVE,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOUT,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOVER,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEUP,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_SDAFORM,               HT20|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_STYLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_TITLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|XH11|XB10|xxxx|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_CODE)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_CLASS,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_DIR,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_ID,                    xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_LANG,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnCLICK,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnDBLCLICK,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYDOWN,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYPRESS,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYUP,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEDOWN,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEMOVE,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOUT,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOVER,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEUP,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_SDAFORM,               HT20|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_STYLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_TITLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|XH11|XB10|xxxx|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_COL)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_ALIGN,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|xxxx|xxxx },
  { TidyAttr_CHAR,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|xxxx|xxxx },
  { TidyAttr_CHAROFF,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|xxxx|xxxx },
  { TidyAttr_CLASS,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_DIR,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_ID,                    xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_LANG,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnCLICK,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnDBLCLICK,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYDOWN,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYPRESS,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYUP,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEDOWN,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEMOVE,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOUT,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOVER,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEUP,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_SPAN,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 },
  { TidyAttr_STYLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_TITLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_VALIGN,                xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|xxxx|xxxx },
  { TidyAttr_WIDTH,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|xxxx|xxxx },
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|XH11|xxxx|xxxx|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_COLGROUP)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_ALIGN,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|xxxx|xxxx },
  { TidyAttr_CHAR,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|xxxx|xxxx },
  { TidyAttr_CHAROFF,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|xxxx|xxxx },
  { TidyAttr_CLASS,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_DIR,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_ID,                    xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_LANG,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnCLICK,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnDBLCLICK,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYDOWN,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYPRESS,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYUP,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEDOWN,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEMOVE,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOUT,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOVER,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEUP,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_SPAN,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 },
  { TidyAttr_STYLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_TITLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_VALIGN,                xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|xxxx|xxxx },
  { TidyAttr_WIDTH,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|xxxx|xxxx },
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|XH11|xxxx|xxxx|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_COMMAND)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_CHECKED,               xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_DISABLED,              xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_ICON,                  xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_LABEL,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_RADIOGROUP,            xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_TYPE,                  xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_DATALIST)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_DD)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_CLASS,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_DIR,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_ID,                    xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_LANG,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnCLICK,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnDBLCLICK,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYDOWN,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYPRESS,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYUP,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEDOWN,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEMOVE,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOUT,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOVER,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEUP,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_SDAFORM,               HT20|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_STYLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_TITLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|XH11|XB10|xxxx|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_DEL)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_CITE,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 },
  { TidyAttr_CLASS,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_DATETIME,              xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 },
  { TidyAttr_DIR,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_ID,                    xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_LANG,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnCLICK,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnDBLCLICK,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYDOWN,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYPRESS,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYUP,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEDOWN,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEMOVE,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOUT,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOVER,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEUP,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_STYLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_TITLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|XH11|xxxx|xxxx|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_DETAILS)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_OPEN,                  xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_DFN)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_CLASS,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_DIR,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_ID,                    xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_LANG,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnCLICK,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnDBLCLICK,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYDOWN,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYPRESS,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYUP,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEDOWN,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEMOVE,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOUT,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOVER,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEUP,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_STYLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_TITLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|XH11|XB10|xxxx|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_DIALOG)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_OPEN,                  xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_DIR)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_CLASS,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_COMPACT,               HT20|HT32|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_DIR,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_ID,                    xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_LANG,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnCLICK,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnDBLCLICK,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnKEYDOWN,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnKEYPRESS,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnKEYUP,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnMOUSEDOWN,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnMOUSEMOVE,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnMOUSEOUT,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnMOUSEOVER,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnMOUSEUP,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_SDAFORM,               HT20|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_SDAPREF,               HT20|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_STYLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_TITLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_DIV)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_ALIGN,                 xxxx|HT32|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_CLASS,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_DIR,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_ID,                    xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_LANG,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnCLICK,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnDBLCLICK,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYDOWN,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYPRESS,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYUP,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEDOWN,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEMOVE,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOUT,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOVER,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEUP,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_STYLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_TITLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|XH11|XB10|xxxx|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_DL)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_CLASS,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_COMPACT,               HT20|HT32|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_DIR,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_ID,                    xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_LANG,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnCLICK,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnDBLCLICK,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYDOWN,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYPRESS,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYUP,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEDOWN,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEMOVE,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOUT,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOVER,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEUP,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_SDAFORM,               HT20|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_SDAPREF,               HT20|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_STYLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_TITLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|XH11|XB10|xxxx|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_DT)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_CLASS,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_DIR,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_ID,                    xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_LANG,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnCLICK,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnDBLCLICK,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYDOWN,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYPRESS,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYUP,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEDOWN,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEMOVE,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOUT,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOVER,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEUP,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_SDAFORM,               HT20|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_STYLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_TITLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|XH11|XB10|xxxx|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_EM)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_CLASS,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_DIR,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_ID,                    xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_LANG,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnCLICK,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnDBLCLICK,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYDOWN,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYPRESS,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYUP,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEDOWN,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEMOVE,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOUT,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOVER,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEUP,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_SDAFORM,               HT20|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_STYLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_TITLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|XH11|XB10|xxxx|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_EMBED)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_HEIGHT,                xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_SRC,                   xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_TYPE,                  xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_WIDTH,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_FIELDSET)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_CLASS,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_DIR,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_DISABLED,              xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_FORM,                  xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_ID,                    xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_LANG,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_NAME,                  xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_OnCLICK,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnDBLCLICK,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYDOWN,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYPRESS,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYUP,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEDOWN,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEMOVE,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOUT,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOVER,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEUP,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_STYLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_TITLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|XH11|xxxx|xxxx|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_FIGCAPTION)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_FIGURE)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_FONT)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_CLASS,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_COLOR,                 xxxx|HT32|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_DIR,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_FACE,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_ID,                    xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_LANG,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_SIZE,                  xxxx|HT32|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_STYLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_TITLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_FOOTER)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_FORM)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_ACCEPT,                xxxx|xxxx|xxxx|H41T|X10T|xxxx|H41F|X10F|xxxx|H41S|X10S|XH11|xxxx|xxxx|xxxx },
  { TidyAttr_ACCEPT_CHARSET,        xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 },
  { TidyAttr_ACTION,                HT20|HT32|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 },
  { TidyAttr_AUTOCOMPLETE,          xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_CLASS,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_DIR,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_ENCTYPE,               HT20|HT32|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 },
  { TidyAttr_ID,                    xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_LANG,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_METHOD,                HT20|HT32|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 },
  { TidyAttr_NAME,                  xxxx|xxxx|xxxx|H41T|X10T|xxxx|H41F|X10F|xxxx|H41S|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_NOVALIDATE,            xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_OnCLICK,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnDBLCLICK,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYDOWN,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYPRESS,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYUP,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEDOWN,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEMOVE,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOUT,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOVER,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEUP,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnRESET,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnSUBMIT,              xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_SDAPREF,               HT20|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_SDASUFF,               HT20|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_STYLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_TARGET,                xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_TITLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|XH11|XB10|xxxx|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_FRAME)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_CLASS,                 xxxx|xxxx|xxxx|xxxx|xxxx|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_FRAMEBORDER,           xxxx|xxxx|xxxx|xxxx|xxxx|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_ID,                    xxxx|xxxx|xxxx|xxxx|xxxx|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_LONGDESC,              xxxx|xxxx|xxxx|xxxx|xxxx|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_MARGINHEIGHT,          xxxx|xxxx|xxxx|xxxx|xxxx|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_MARGINWIDTH,           xxxx|xxxx|xxxx|xxxx|xxxx|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_NAME,                  xxxx|xxxx|xxxx|xxxx|xxxx|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_NORESIZE,              xxxx|xxxx|xxxx|xxxx|xxxx|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_SCROLLING,             xxxx|xxxx|xxxx|xxxx|xxxx|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_SRC,                   xxxx|xxxx|xxxx|xxxx|xxxx|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_STYLE,                 xxxx|xxxx|xxxx|xxxx|xxxx|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_TITLE,                 xxxx|xxxx|xxxx|xxxx|xxxx|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_FRAMESET)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_CLASS,                 xxxx|xxxx|xxxx|xxxx|xxxx|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_COLS,                  xxxx|xxxx|xxxx|xxxx|xxxx|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_ID,                    xxxx|xxxx|xxxx|xxxx|xxxx|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnLOAD,                xxxx|xxxx|xxxx|xxxx|xxxx|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnUNLOAD,              xxxx|xxxx|xxxx|xxxx|xxxx|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_ROWS,                  xxxx|xxxx|xxxx|xxxx|xxxx|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_STYLE,                 xxxx|xxxx|xxxx|xxxx|xxxx|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_TITLE,                 xxxx|xxxx|xxxx|xxxx|xxxx|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_H1)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_ALIGN,                 xxxx|HT32|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_CLASS,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_DIR,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_ID,                    xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_LANG,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnCLICK,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnDBLCLICK,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYDOWN,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYPRESS,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYUP,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEDOWN,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEMOVE,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOUT,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOVER,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEUP,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_SDAFORM,               HT20|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_STYLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_TITLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|XH11|XB10|xxxx|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_H2)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_ALIGN,                 xxxx|HT32|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_CLASS,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_DIR,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_ID,                    xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_LANG,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnCLICK,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnDBLCLICK,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYDOWN,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYPRESS,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYUP,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEDOWN,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEMOVE,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOUT,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOVER,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEUP,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_SDAFORM,               HT20|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_STYLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_TITLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|XH11|XB10|xxxx|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_H3)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_ALIGN,                 xxxx|HT32|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_CLASS,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_DIR,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_ID,                    xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_LANG,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnCLICK,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnDBLCLICK,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYDOWN,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYPRESS,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYUP,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEDOWN,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEMOVE,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOUT,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOVER,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEUP,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_SDAFORM,               HT20|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_STYLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_TITLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|XH11|XB10|xxxx|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_H4)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_ALIGN,                 xxxx|HT32|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_CLASS,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_DIR,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_ID,                    xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_LANG,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnCLICK,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnDBLCLICK,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYDOWN,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYPRESS,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYUP,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEDOWN,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEMOVE,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOUT,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOVER,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEUP,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_SDAFORM,               HT20|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_STYLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_TITLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|XH11|XB10|xxxx|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_H5)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_ALIGN,                 xxxx|HT32|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_CLASS,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_DIR,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_ID,                    xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_LANG,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnCLICK,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnDBLCLICK,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYDOWN,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYPRESS,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYUP,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEDOWN,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEMOVE,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOUT,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOVER,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEUP,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_SDAFORM,               HT20|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_STYLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_TITLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|XH11|XB10|xxxx|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_H6)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_ALIGN,                 xxxx|HT32|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_CLASS,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_DIR,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_ID,                    xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_LANG,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnCLICK,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnDBLCLICK,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYDOWN,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYPRESS,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYUP,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEDOWN,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEMOVE,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOUT,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOVER,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEUP,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_SDAFORM,               HT20|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_STYLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_TITLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|XH11|XB10|xxxx|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_HEAD)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_DIR,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_ID,                    xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_LANG,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_PROFILE,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|xxxx|xxxx },
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|XH11|XB10|xxxx|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_HEADER)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_HGROUP)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_HR)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_ALIGN,                 xxxx|HT32|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_CLASS,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_DIR,                   xxxx|xxxx|xxxx|H41T|X10T|xxxx|H41F|X10F|xxxx|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_ID,                    xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_LANG,                  xxxx|xxxx|xxxx|H41T|X10T|xxxx|H41F|X10F|xxxx|H41S|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_NOSHADE,               xxxx|HT32|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_OnCLICK,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnDBLCLICK,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYDOWN,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYPRESS,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYUP,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEDOWN,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEMOVE,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOUT,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOVER,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEUP,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_SDAPREF,               HT20|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_SIZE,                  xxxx|HT32|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_STYLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_TITLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_WIDTH,                 xxxx|HT32|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|XH11|xxxx|xxxx|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_HTML)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_DIR,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_ID,                    xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_LANG,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_MANIFEST,              xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_SDAFORM,               HT20|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_VERSION,               HT20|HT32|H40T|H41T|xxxx|H40F|H41F|xxxx|xxxx|xxxx|xxxx|XH11|XB10|xxxx|xxxx },
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|XH11|XB10|xxxx|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_I)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_CLASS,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_DIR,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_ID,                    xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_LANG,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnCLICK,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnDBLCLICK,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYDOWN,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYPRESS,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYUP,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEDOWN,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEMOVE,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOUT,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOVER,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEUP,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_SDAFORM,               HT20|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_STYLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_TITLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|XH11|xxxx|xxxx|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_IFRAME)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_ALIGN,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_ALLOWFULLSCREEN,       xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_CLASS,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_FRAMEBORDER,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_HEIGHT,                xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_ID,                    xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_LONGDESC,              xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_MARGINHEIGHT,          xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_MARGINWIDTH,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_NAME,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_SANDBOX,               xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_SCROLLING,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_SEAMLESS,              xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_SRC,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_SRCDOC,                xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_STYLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_TITLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_WIDTH,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_IMG)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_ALIGN,                 HT20|HT32|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_ALT,                   HT20|HT32|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 },
  { TidyAttr_BORDER,                xxxx|HT32|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_CLASS,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_CROSSORIGIN,           xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_DIR,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_HEIGHT,                xxxx|HT32|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 },
  { TidyAttr_HSPACE,                xxxx|HT32|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_ID,                    xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_ISMAP,                 HT20|HT32|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 },
  { TidyAttr_LANG,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_LONGDESC,              xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|xxxx|xxxx },
  { TidyAttr_NAME,                  xxxx|xxxx|xxxx|H41T|X10T|xxxx|H41F|X10F|xxxx|H41S|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_OnCLICK,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnDBLCLICK,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYDOWN,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYPRESS,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYUP,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEDOWN,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEMOVE,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOUT,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOVER,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEUP,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_SDAPREF,               HT20|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_SIZES,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_SRC,                   HT20|HT32|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 },
  { TidyAttr_SRCSET,                xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_STYLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_TITLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_USEMAP,                xxxx|HT32|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 },
  { TidyAttr_VSPACE,                xxxx|HT32|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_WIDTH,                 xxxx|HT32|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 },
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|XH11|XB10|xxxx|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_INPUT)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_ACCEPT,                xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 },
  { TidyAttr_ACCESSKEY,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_ALIGN,                 HT20|HT32|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_ALT,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 },
  { TidyAttr_AUTOCOMPLETE,          xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_AUTOFOCUS,             xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_CHECKED,               HT20|HT32|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 },
  { TidyAttr_CLASS,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_DIR,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_DIRNAME,               xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_DISABLED,              xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 },
  { TidyAttr_FORM,                  xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_FORMACTION,            xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_FORMENCTYPE,           xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_FORMMETHOD,            xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_FORMNOVALIDATE,        xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_FORMTARGET,            xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_HEIGHT,                xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_ID,                    xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_ISMAP,                 xxxx|xxxx|xxxx|H41T|xxxx|xxxx|H41F|xxxx|xxxx|H41S|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_LANG,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_LIST,                  xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_MAX,                   xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_MAXLENGTH,             HT20|HT32|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 },
  { TidyAttr_MIN,                   xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_MULTIPLE,              xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_NAME,                  HT20|HT32|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 },
  { TidyAttr_OnBLUR,                xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnCHANGE,              xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnCLICK,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnDBLCLICK,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnFOCUS,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYDOWN,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYPRESS,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYUP,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEDOWN,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEMOVE,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOUT,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOVER,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEUP,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnSELECT,              xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_PATTERN,               xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_PLACEHOLDER,           xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_READONLY,              xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 },
  { TidyAttr_REQUIRED,              xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_SDAPREF,               HT20|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_SIZE,                  HT20|HT32|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 },
  { TidyAttr_SRC,                   HT20|HT32|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 },
  { TidyAttr_STEP,                  xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_STYLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_TABINDEX,              xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_TITLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_TYPE,                  HT20|HT32|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 },
  { TidyAttr_USEMAP,                xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|xxxx|xxxx },
  { TidyAttr_VALUE,                 HT20|HT32|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 },
  { TidyAttr_WIDTH,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|XH11|XB10|xxxx|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_INS)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_CITE,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 },
  { TidyAttr_CLASS,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_DATETIME,              xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 },
  { TidyAttr_DIR,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_ID,                    xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_LANG,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnCLICK,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnDBLCLICK,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYDOWN,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYPRESS,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYUP,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEDOWN,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEMOVE,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOUT,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOVER,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEUP,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_STYLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_TITLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|XH11|xxxx|xxxx|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_ISINDEX)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_CLASS,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_DIR,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_ID,                    xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_LANG,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_PROMPT,                xxxx|HT32|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_SDAPREF,               HT20|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_STYLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_TITLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_KBD)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_CLASS,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_DIR,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_ID,                    xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_LANG,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnCLICK,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnDBLCLICK,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYDOWN,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYPRESS,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYUP,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEDOWN,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEMOVE,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOUT,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOVER,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEUP,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_SDAFORM,               HT20|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_STYLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_TITLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|XH11|XB10|xxxx|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_KEYGEN)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_AUTOFOCUS,             xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_CHALLENGE,             xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_DISABLED,              xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_FORM,                  xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_KEYTYPE,               xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_NAME,                  xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_LABEL)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_ACCESSKEY,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_CLASS,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_DIR,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_FOR,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 },
  { TidyAttr_FORM,                  xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_ID,                    xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_LANG,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnBLUR,                xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnCLICK,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnDBLCLICK,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnFOCUS,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYDOWN,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYPRESS,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYUP,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEDOWN,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEMOVE,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOUT,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOVER,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEUP,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_STYLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_TITLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|XH11|XB10|xxxx|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_LEGEND)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_ACCESSKEY,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_ALIGN,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_CLASS,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_DIR,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_ID,                    xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_LANG,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnCLICK,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnDBLCLICK,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYDOWN,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYPRESS,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYUP,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEDOWN,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEMOVE,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOUT,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOVER,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEUP,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_STYLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_TITLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|XH11|xxxx|xxxx|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_LI)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_CLASS,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_DIR,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_ID,                    xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_LANG,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnCLICK,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnDBLCLICK,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYDOWN,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYPRESS,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYUP,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEDOWN,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEMOVE,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOUT,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOVER,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEUP,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_SDAFORM,               HT20|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_STYLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_TITLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_TYPE,                  xxxx|HT32|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_VALUE,                 xxxx|HT32|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|XH11|XB10|xxxx|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_LINK)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_AS,                    xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_CHARSET,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|xxxx|xxxx },
  { TidyAttr_CLASS,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_COLOR,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, /* Is #686 */
  { TidyAttr_CROSSORIGIN,           xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_DIR,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_HREF,                  HT20|HT32|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 },
  { TidyAttr_HREFLANG,              xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 },
  { TidyAttr_ID,                    xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_INTEGRITY,             xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_LANG,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_MEDIA,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 },
  { TidyAttr_METHODS,               HT20|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_OnCLICK,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnDBLCLICK,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYDOWN,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYPRESS,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYUP,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEDOWN,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEMOVE,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOUT,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOVER,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEUP,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_REL,                   HT20|HT32|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 },
  { TidyAttr_REV,                   HT20|HT32|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|xxxx|xxxx },
  { TidyAttr_SDAPREF,               HT20|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_SIZES,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_STYLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_TARGET,                xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_TITLE,                 HT20|HT32|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_TYPE,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 },
  { TidyAttr_URN,                   HT20|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|XH11|XB10|xxxx|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_LISTING)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_SDAFORM,               HT20|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_SDAPREF,               HT20|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_MAIN)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_MAP)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_CLASS,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_DIR,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_ID,                    xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_LANG,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_NAME,                  xxxx|HT32|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_OnCLICK,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnDBLCLICK,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYDOWN,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYPRESS,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYUP,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEDOWN,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEMOVE,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOUT,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOVER,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEUP,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_STYLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_TITLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|XH11|xxxx|xxxx|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_MATHML)[] =  /* [i_a]2 */
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_ALIGN,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 },
  { TidyAttr_CLASS,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_DIR,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_DISPLAY,               xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_ID,                    xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_HEIGHT,                xxxx|HT32|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 },
  { TidyAttr_LANG,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnCLICK,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnDBLCLICK,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYDOWN,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYPRESS,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYUP,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEDOWN,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEMOVE,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOUT,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOVER,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEUP,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_STYLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_TITLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_WIDTH,                 xxxx|HT32|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 },
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|HT50|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_MARK)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_MENU)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_CLASS,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_COMPACT,               HT20|HT32|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_DIR,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_ID,                    xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_LABEL,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_LANG,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnCLICK,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnDBLCLICK,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYDOWN,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYPRESS,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYUP,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEDOWN,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEMOVE,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOUT,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOVER,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEUP,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_SDAFORM,               HT20|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_SDAPREF,               HT20|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_STYLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_TITLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_TYPE,                  xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_MENUITEM)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_AUTOFOCUS,             xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_CHALLENGE,             xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_DISABLED,              xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_FORM,                  xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_ICON,                  xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_KEYTYPE,               xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_LABEL,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_NAME,                  xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_META)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_CHARSET,               xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_CONTENT,               HT20|HT32|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 },
  { TidyAttr_DIR,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_HTTP_EQUIV,            HT20|HT32|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 },
  { TidyAttr_ID,                    xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_LANG,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_NAME,                  HT20|HT32|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 },
  { TidyAttr_SCHEME,                xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|xxxx|xxxx },
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|XH11|XB10|xxxx|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_METER)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_FORM,                  xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_HIGH,                  xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_LOW,                   xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_MAX,                   xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_MIN,                   xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_OPTIMUM,               xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_VALUE,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_NAV)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_NEXTID)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_N,                     HT20|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_NOFRAMES)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_CLASS,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_DIR,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_ID,                    xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_LANG,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnCLICK,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnDBLCLICK,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnKEYDOWN,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnKEYPRESS,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnKEYUP,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnMOUSEDOWN,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnMOUSEMOVE,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnMOUSEOUT,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnMOUSEOVER,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnMOUSEUP,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_STYLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_TITLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_NOSCRIPT)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_CLASS,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_DIR,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_ID,                    xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_LANG,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnCLICK,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnDBLCLICK,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYDOWN,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYPRESS,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYUP,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEDOWN,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEMOVE,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOUT,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOVER,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEUP,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_STYLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_TITLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|XH11|xxxx|xxxx|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_OBJECT)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_ALIGN,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_ARCHIVE,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|xxxx|xxxx },
  { TidyAttr_BORDER,                xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_CLASS,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_CLASSID,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|xxxx|xxxx },
  { TidyAttr_CODEBASE,              xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|xxxx|xxxx },
  { TidyAttr_CODETYPE,              xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|xxxx|xxxx },
  { TidyAttr_DATA,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 },
  { TidyAttr_DECLARE,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|xxxx|xxxx },
  { TidyAttr_DIR,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_FORM,                  xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_HEIGHT,                xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 },
  { TidyAttr_HSPACE,                xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_ID,                    xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_LANG,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_NAME,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 },
  { TidyAttr_OnCLICK,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnDBLCLICK,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYDOWN,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYPRESS,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYUP,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEDOWN,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEMOVE,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOUT,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOVER,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEUP,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_STANDBY,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|xxxx|xxxx },
  { TidyAttr_STYLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_TABINDEX,              xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_TITLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_TYPE,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 },
  { TidyAttr_USEMAP,                xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 },
  { TidyAttr_VSPACE,                xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_WIDTH,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 },
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|XH11|XB10|xxxx|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_OL)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_CLASS,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_COMPACT,               HT20|HT32|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_DIR,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_ID,                    xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_LANG,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnCLICK,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnDBLCLICK,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYDOWN,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYPRESS,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYUP,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEDOWN,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEMOVE,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOUT,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOVER,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEUP,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_REVERSED,              xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_SDAFORM,               HT20|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_START,                 xxxx|HT32|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_STYLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_TITLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_TYPE,                  xxxx|HT32|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|XH11|XB10|xxxx|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_OPTGROUP)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_CLASS,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_DIR,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_DISABLED,              xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 },
  { TidyAttr_ID,                    xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_LABEL,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 },
  { TidyAttr_LANG,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnCLICK,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnDBLCLICK,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYDOWN,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYPRESS,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYUP,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEDOWN,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEMOVE,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOUT,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOVER,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEUP,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_STYLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_TITLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|XH11|xxxx|xxxx|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_OPTION)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_CLASS,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_DIR,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_DISABLED,              xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 },
  { TidyAttr_ID,                    xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_LABEL,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 },
  { TidyAttr_LANG,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnCLICK,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnDBLCLICK,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYDOWN,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYPRESS,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYUP,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEDOWN,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEMOVE,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOUT,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOVER,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEUP,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_SDAFORM,               HT20|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_SDAPREF,               HT20|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_SELECTED,              HT20|HT32|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 },
  { TidyAttr_STYLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_TITLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_VALUE,                 HT20|HT32|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 },
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|XH11|XB10|xxxx|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_OUTPUT)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_FOR,                   xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_FORM,                  xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_NAME,                  xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_P)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_ALIGN,                 xxxx|HT32|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_CLASS,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_DIR,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_ID,                    xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_LANG,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnCLICK,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnDBLCLICK,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYDOWN,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYPRESS,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYUP,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEDOWN,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEMOVE,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOUT,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOVER,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEUP,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_SDAFORM,               HT20|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_STYLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_TITLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|XH11|XB10|xxxx|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_PARAM)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_ID,                    xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_NAME,                  xxxx|HT32|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 },
  { TidyAttr_TYPE,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|xxxx|xxxx },
  { TidyAttr_VALUE,                 xxxx|HT32|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 },
  { TidyAttr_VALUETYPE,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|xxxx|xxxx },
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|XB10|HT50|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};


const AttrVersion TY_(W3CAttrsFor_PICTURE)[] = /* Issue #151 - support for 'picture' tag - TODO: check list of attributes */
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_MEDIA,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_OnCLICK,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnDBLCLICK,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYDOWN,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYPRESS,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYUP,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEDOWN,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEMOVE,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOUT,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOVER,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEUP,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_SRCSET,                xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_TYPE,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 },
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|XB10|HT50|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_PLAINTEXT)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_SDAFORM,            HT20|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,            0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_PRE)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_CLASS,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_DIR,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_ID,                    xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_LANG,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnCLICK,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnDBLCLICK,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYDOWN,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYPRESS,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYUP,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEDOWN,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEMOVE,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOUT,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOVER,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEUP,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_SDAFORM,               HT20|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_STYLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_TITLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_WIDTH,                 HT20|HT32|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|XH11|XB10|xxxx|XH50 }, /* CORE override */
  { TidyAttr_XML_SPACE,             xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|XH11|XB10|xxxx|xxxx },
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_PROGRESS)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_FORM,                  xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_MAX,                   xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_VALUE,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_Q)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_CITE,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 },
  { TidyAttr_CLASS,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_DIR,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_ID,                    xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_LANG,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnCLICK,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnDBLCLICK,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYDOWN,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYPRESS,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYUP,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEDOWN,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEMOVE,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOUT,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOVER,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEUP,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_STYLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_TITLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|XH11|XB10|xxxx|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_RB)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_CLASS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_DIR,                   xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_ID,                    xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnCLICK,               xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnDBLCLICK,            xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnKEYDOWN,             xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnKEYPRESS,            xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnKEYUP,               xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnMOUSEDOWN,           xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnMOUSEMOVE,           xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnMOUSEOUT,            xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnMOUSEOVER,           xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnMOUSEUP,             xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_STYLE,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_TITLE,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|xxxx|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_RBC)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_CLASS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_DIR,                   xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_ID,                    xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnCLICK,               xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnDBLCLICK,            xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnKEYDOWN,             xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnKEYPRESS,            xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnKEYUP,               xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnMOUSEDOWN,           xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnMOUSEMOVE,           xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnMOUSEOUT,            xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnMOUSEOVER,           xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnMOUSEUP,             xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_STYLE,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_TITLE,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|xxxx|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_RP)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_CLASS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_DIR,                   xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_ID,                    xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnCLICK,               xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnDBLCLICK,            xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYDOWN,             xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYPRESS,            xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYUP,               xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEDOWN,           xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEMOVE,           xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOUT,            xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOVER,           xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEUP,             xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_STYLE,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_TITLE,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|xxxx|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_RT)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_CLASS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_DIR,                   xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_ID,                    xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnCLICK,               xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnDBLCLICK,            xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYDOWN,             xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYPRESS,            xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYUP,               xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEDOWN,           xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEMOVE,           xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOUT,            xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOVER,           xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEUP,             xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_RBSPAN,                xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|xxxx|xxxx },
  { TidyAttr_STYLE,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_TITLE,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|xxxx|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_RTC)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_CLASS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_DIR,                   xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_ID,                    xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnCLICK,               xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnDBLCLICK,            xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnKEYDOWN,             xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnKEYPRESS,            xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnKEYUP,               xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnMOUSEDOWN,           xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnMOUSEMOVE,           xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnMOUSEOUT,            xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnMOUSEOVER,           xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnMOUSEUP,             xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_STYLE,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_TITLE,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|xxxx|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_RUBY)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_CLASS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_DIR,                   xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_ID,                    xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnCLICK,               xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnDBLCLICK,            xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYDOWN,             xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYPRESS,            xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYUP,               xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEDOWN,           xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEMOVE,           xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOUT,            xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOVER,           xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEUP,             xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_STYLE,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_TITLE,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|xxxx|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_S)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_CLASS,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_DIR,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_ID,                    xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_LANG,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnCLICK,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnDBLCLICK,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYDOWN,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYPRESS,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYUP,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEDOWN,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEMOVE,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOUT,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOVER,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEUP,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_STYLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_TITLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_SAMP)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_CLASS,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_DIR,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_ID,                    xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_LANG,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnCLICK,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnDBLCLICK,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYDOWN,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYPRESS,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYUP,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEDOWN,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEMOVE,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOUT,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOVER,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEUP,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_SDAFORM,               HT20|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_STYLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_TITLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|XH11|XB10|xxxx|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_SCRIPT)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_ASYNC,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_CHARSET,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 },
  { TidyAttr_CROSSORIGIN,           xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_DEFER,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 },
  { TidyAttr_EVENT,                 xxxx|xxxx|H40T|H41T|xxxx|H40F|H41F|xxxx|H40S|H41S|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_FOR,                   xxxx|xxxx|H40T|H41T|xxxx|H40F|H41F|xxxx|H40S|H41S|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_ID,                    xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_INTEGRITY,             xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_LANGUAGE,              xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_SRC,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 },
  { TidyAttr_TYPE,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 },
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_XML_SPACE,             xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|XH11|xxxx|xxxx|xxxx },
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_SECTION)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_SELECT)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_AUTOFOCUS,             xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_CLASS,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_DIR,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_DISABLED,              xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 },
  { TidyAttr_FORM,                  xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_ID,                    xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_LANG,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_MULTIPLE,              HT20|HT32|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 },
  { TidyAttr_NAME,                  HT20|HT32|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 },
  { TidyAttr_OnBLUR,                xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnCHANGE,              xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnCLICK,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnDBLCLICK,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnFOCUS,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYDOWN,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYPRESS,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYUP,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEDOWN,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEMOVE,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOUT,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOVER,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEUP,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_REQUIRED,              xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_SDAFORM,               HT20|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_SDAPREF,               HT20|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_SIZE,                  HT20|HT32|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 },
  { TidyAttr_STYLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_TABINDEX,              xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_TITLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|XH11|XB10|xxxx|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_SMALL)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_CLASS,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_DIR,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_ID,                    xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_LANG,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnCLICK,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnDBLCLICK,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYDOWN,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYPRESS,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYUP,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEDOWN,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEMOVE,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOUT,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOVER,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEUP,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_STYLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_TITLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|XH11|xxxx|xxxx|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_SOURCE)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_MEDIA,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_SRC,                   xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_SRCSET,                xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_TYPE,                  xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_SPAN)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_CLASS,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_DIR,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_ID,                    xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_LANG,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnCLICK,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnDBLCLICK,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYDOWN,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYPRESS,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYUP,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEDOWN,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEMOVE,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOUT,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOVER,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEUP,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_STYLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_TITLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|XH11|XB10|xxxx|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_STRIKE)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_CLASS,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_DIR,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_ID,                    xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_LANG,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnCLICK,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnDBLCLICK,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnKEYDOWN,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnKEYPRESS,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnKEYUP,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnMOUSEDOWN,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnMOUSEMOVE,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnMOUSEOUT,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnMOUSEOVER,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnMOUSEUP,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_STYLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_TITLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_STRONG)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_CLASS,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_DIR,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_ID,                    xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_LANG,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnCLICK,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnDBLCLICK,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYDOWN,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYPRESS,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYUP,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEDOWN,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEMOVE,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOUT,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOVER,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEUP,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_SDAFORM,               HT20|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_STYLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_TITLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|XH11|XB10|xxxx|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_STYLE)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_DIR,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_ID,                    xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_LANG,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_MEDIA,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 },
  { TidyAttr_SCOPED,                xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_TITLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_TYPE,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 },
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|XH11|xxxx|xxxx|XH50 }, /* CORE override */
  { TidyAttr_XML_SPACE,             xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|XH11|xxxx|xxxx|xxxx },
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_SUB)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_CLASS,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_DIR,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_ID,                    xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_LANG,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnCLICK,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnDBLCLICK,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYDOWN,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYPRESS,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYUP,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEDOWN,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEMOVE,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOUT,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOVER,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEUP,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_STYLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_TITLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|XH11|xxxx|xxxx|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_SUMMARY)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_SUP)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_CLASS,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_DIR,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_ID,                    xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_LANG,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnCLICK,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnDBLCLICK,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYDOWN,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYPRESS,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYUP,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEDOWN,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEMOVE,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOUT,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOVER,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEUP,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_STYLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_TITLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|XH11|xxxx|xxxx|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_SVG)[] =
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_ALIGN,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 },
  { TidyAttr_CLASS,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_DIR,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_ID,                    xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_HEIGHT,                xxxx|HT32|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 },
  { TidyAttr_LANG,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnCLICK,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnDBLCLICK,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYDOWN,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYPRESS,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYUP,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEDOWN,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEMOVE,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOUT,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOVER,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEUP,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_STYLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_TITLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_WIDTH,                 xxxx|HT32|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 },
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|HT50|XH50 }, /* CORE override */

  /* svg xmln:xlink=uri */
  { TidyAttr_XMLNSXLINK,            xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|HT50|XH50 },

  { TidyAttr_X,                     xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|H41S|X10S|XH11|xxxx|HT50|XH50 },
  { TidyAttr_Y,                     xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|H41S|X10S|XH11|xxxx|HT50|XH50 },
  { TidyAttr_VIEWBOX,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|H41S|X10S|XH11|xxxx|HT50|XH50 },
  { TidyAttr_PRESERVEASPECTRATIO,   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|H41S|X10S|XH11|xxxx|HT50|XH50 },
  { TidyAttr_ZOOMANDPAN,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|H41S|X10S|XH11|xxxx|HT50|XH50 },
  { TidyAttr_VERSION,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|H41S|X10S|XH11|xxxx|HT50|XH50 },
  { TidyAttr_BASEPROFILE,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|H41S|X10S|XH11|xxxx|HT50|XH50 },
  { TidyAttr_CONTENTSCRIPTTYPE,     xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|H41S|X10S|XH11|xxxx|HT50|XH50 },
  { TidyAttr_CONTENTSTYLETYPE,      xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|H41S|X10S|XH11|xxxx|HT50|XH50 },
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_TABLE)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_ALIGN,                 xxxx|HT32|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_BGCOLOR,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_BORDER,                xxxx|HT32|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 },
  { TidyAttr_CELLPADDING,           xxxx|HT32|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|xxxx|xxxx },
  { TidyAttr_CELLSPACING,           xxxx|HT32|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|xxxx|xxxx },
  { TidyAttr_CLASS,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_DATAPAGESIZE,          xxxx|xxxx|H40T|H41T|xxxx|H40F|H41F|xxxx|H40S|H41S|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_DIR,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_FRAME,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|xxxx|xxxx },
  { TidyAttr_ID,                    xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_LANG,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnCLICK,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnDBLCLICK,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYDOWN,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYPRESS,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYUP,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEDOWN,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEMOVE,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOUT,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOVER,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEUP,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_RULES,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|xxxx|xxxx },
  { TidyAttr_STYLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_SUMMARY,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|xxxx|xxxx },
  { TidyAttr_TITLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_WIDTH,                 xxxx|HT32|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|xxxx|xxxx },
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|XH11|XB10|xxxx|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_TBODY)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_ALIGN,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|xxxx|xxxx },
  { TidyAttr_CHAR,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|xxxx|xxxx },
  { TidyAttr_CHAROFF,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|xxxx|xxxx },
  { TidyAttr_CLASS,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_DIR,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_ID,                    xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_LANG,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnCLICK,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnDBLCLICK,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYDOWN,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYPRESS,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYUP,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEDOWN,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEMOVE,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOUT,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOVER,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEUP,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_STYLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_TITLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_VALIGN,                xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|xxxx|xxxx },
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|XH11|xxxx|xxxx|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_TD)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_ABBR,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|xxxx|xxxx },
  { TidyAttr_ALIGN,                 xxxx|HT32|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|xxxx|xxxx },
  { TidyAttr_AXIS,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|xxxx|xxxx },
  { TidyAttr_BGCOLOR,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_CHAR,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|xxxx|xxxx },
  { TidyAttr_CHAROFF,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|xxxx|xxxx },
  { TidyAttr_CLASS,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_COLSPAN,               xxxx|HT32|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 },
  { TidyAttr_DIR,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_HEADERS,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 },
  { TidyAttr_HEIGHT,                xxxx|HT32|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_ID,                    xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_LANG,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_NOWRAP,                xxxx|HT32|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_OnCLICK,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnDBLCLICK,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYDOWN,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYPRESS,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYUP,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEDOWN,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEMOVE,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOUT,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOVER,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEUP,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_ROWSPAN,               xxxx|HT32|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 },
  { TidyAttr_SCOPE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|xxxx|xxxx },
  { TidyAttr_STYLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_TITLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_VALIGN,                xxxx|HT32|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|xxxx|xxxx },
  { TidyAttr_WIDTH,                 xxxx|HT32|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|XH11|XB10|xxxx|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_TEXTAREA)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_ACCESSKEY,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_AUTOFOCUS,             xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_CLASS,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_COLS,                  HT20|HT32|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 },
  { TidyAttr_DIR,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_DISABLED,              xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 },
  { TidyAttr_FORM,                  xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_ID,                    xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_LANG,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_MAXLENGTH,             xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_NAME,                  HT20|HT32|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 },
  { TidyAttr_OnBLUR,                xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnCHANGE,              xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnCLICK,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnDBLCLICK,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnFOCUS,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYDOWN,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYPRESS,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYUP,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEDOWN,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEMOVE,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOUT,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOVER,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEUP,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnSELECT,              xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_PLACEHOLDER,           xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_READONLY,              xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 },
  { TidyAttr_REQUIRED,              xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_ROWS,                  HT20|HT32|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 },
  { TidyAttr_SDAFORM,               HT20|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_SDAPREF,               HT20|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_STYLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_TABINDEX,              xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_TITLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_WRAP,                  xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|XH11|XB10|xxxx|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_TFOOT)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_ALIGN,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|xxxx|xxxx },
  { TidyAttr_CHAR,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|xxxx|xxxx },
  { TidyAttr_CHAROFF,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|xxxx|xxxx },
  { TidyAttr_CLASS,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_DIR,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_ID,                    xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_LANG,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnCLICK,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnDBLCLICK,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYDOWN,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYPRESS,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYUP,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEDOWN,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEMOVE,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOUT,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOVER,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEUP,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_STYLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_TITLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_VALIGN,                xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|xxxx|xxxx },
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|XH11|xxxx|xxxx|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_TH)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_ABBR,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|xxxx|xxxx },
  { TidyAttr_ALIGN,                 xxxx|HT32|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|xxxx|xxxx },
  { TidyAttr_AXIS,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|xxxx|xxxx },
  { TidyAttr_BGCOLOR,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_CHAR,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|xxxx|xxxx },
  { TidyAttr_CHAROFF,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|xxxx|xxxx },
  { TidyAttr_CLASS,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_COLSPAN,               xxxx|HT32|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 },
  { TidyAttr_DIR,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_HEADERS,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 },
  { TidyAttr_HEIGHT,                xxxx|HT32|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_ID,                    xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_LANG,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_NOWRAP,                xxxx|HT32|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_OnCLICK,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnDBLCLICK,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYDOWN,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYPRESS,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYUP,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEDOWN,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEMOVE,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOUT,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOVER,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEUP,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_ROWSPAN,               xxxx|HT32|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 },
  { TidyAttr_SCOPE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 },
  { TidyAttr_STYLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_TITLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_VALIGN,                xxxx|HT32|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|xxxx|xxxx },
  { TidyAttr_WIDTH,                 xxxx|HT32|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|XH11|XB10|xxxx|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_THEAD)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_ALIGN,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|xxxx|xxxx },
  { TidyAttr_CHAR,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|xxxx|xxxx },
  { TidyAttr_CHAROFF,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|xxxx|xxxx },
  { TidyAttr_CLASS,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_DIR,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_ID,                    xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_LANG,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnCLICK,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnDBLCLICK,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYDOWN,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYPRESS,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYUP,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEDOWN,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEMOVE,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOUT,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOVER,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEUP,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_STYLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_TITLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_VALIGN,                xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|xxxx|xxxx },
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|XH11|xxxx|xxxx|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_TEMPLATE)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_TIME)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_DATETIME,              xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_PUBDATE,               xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_DATA)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_VALUE,              xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_TITLE)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_DIR,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_ID,                    xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_LANG,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_SDAFORM,               HT20|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|XH11|XB10|xxxx|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_TR)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_ALIGN,                 xxxx|HT32|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|xxxx|xxxx },
  { TidyAttr_BGCOLOR,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_CHAR,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|xxxx|xxxx },
  { TidyAttr_CHAROFF,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|xxxx|xxxx },
  { TidyAttr_CLASS,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_DIR,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_ID,                    xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_LANG,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnCLICK,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnDBLCLICK,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYDOWN,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYPRESS,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYUP,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEDOWN,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEMOVE,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOUT,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOVER,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEUP,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_STYLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_TITLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_VALIGN,                xxxx|HT32|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|xxxx|xxxx },
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|XH11|XB10|xxxx|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_TRACK)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_DEFAULT,               xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_KIND,                  xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_LABEL,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_SRC,                   xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_SRCLANG,               xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_TT)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_CLASS,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_DIR,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_ID,                    xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_LANG,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|xxxx|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnCLICK,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnDBLCLICK,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnKEYDOWN,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnKEYPRESS,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnKEYUP,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnMOUSEDOWN,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnMOUSEMOVE,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnMOUSEOUT,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnMOUSEOVER,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_OnMOUSEUP,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_SDAFORM,               HT20|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_STYLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_TITLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|xxxx|xxxx }, /* CORE override */
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|XH11|xxxx|xxxx|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_U)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_CLASS,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_DIR,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_ID,                    xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_LANG,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnCLICK,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnDBLCLICK,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYDOWN,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYPRESS,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYUP,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEDOWN,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEMOVE,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOUT,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOVER,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEUP,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_STYLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_TITLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_UL)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_CLASS,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_COMPACT,               HT20|HT32|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_DIR,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_ID,                    xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_LANG,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnCLICK,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnDBLCLICK,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYDOWN,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYPRESS,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYUP,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEDOWN,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEMOVE,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOUT,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOVER,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEUP,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_SDAFORM,               HT20|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_STYLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_TITLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_TYPE,                  xxxx|HT32|H40T|H41T|X10T|H40F|H41F|X10F|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|XH11|XB10|xxxx|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_VAR)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_CLASS,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_DIR,                   xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_ID,                    xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_LANG,                  xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|xxxx|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnCLICK,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnDBLCLICK,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYDOWN,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYPRESS,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnKEYUP,               xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEDOWN,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEMOVE,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOUT,            xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEOVER,           xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_OnMOUSEUP,             xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_SDAFORM,               HT20|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_STYLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|xxxx|HT50|XH50 }, /* CORE override */
  { TidyAttr_TITLE,                 xxxx|xxxx|H40T|H41T|X10T|H40F|H41F|X10F|H40S|H41S|X10S|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_XMLNS,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|XH11|XB10|HT50|XH50 }, /* CORE override */
  { TidyAttr_XML_LANG,              xxxx|xxxx|xxxx|xxxx|X10T|xxxx|xxxx|X10F|xxxx|xxxx|X10S|XH11|XB10|xxxx|XH50 }, /* CORE override */
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_VIDEO)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_AUTOPLAY,              xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_CONTROLS,              xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_CROSSORIGIN,           xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_HEIGHT,                xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_LOOP,                  xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_MEDIAGROUP,            xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_POSTER,                xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_PRELOAD,               xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_SRC,                   xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  { TidyAttr_WIDTH,                 xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|HT50|XH50 },
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_WBR)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

const AttrVersion TY_(W3CAttrsFor_XMP)[] = 
{
  INCLUDE_ARIA
  INCLUDE_MICRODATA
  { TidyAttr_SDAFORM,               HT20|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  { TidyAttr_SDAPREF,               HT20|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx|xxxx },
  INCLUDE_CORE_ATTRIBS
  INCLUDE_CORE_EVENTS
  INCLUDE_RDFA
  { TidyAttr_UNKNOWN,               0                                                                          },
};

/*
 * DISABLEDLOCALVARIABLES
 * mode: c
 * indent-tabs-mode: nil
 * c-basic-offset: 4
 * eval: (c-set-offset 'substatement-open 0)
 * end:
 */
/* attrs.c -- recognize HTML attributes

  (c) 1998-2009 (W3C) MIT, ERCIM, Keio University
  See tidy.h for the copyright notice.

*/

/* #include "tidy-int.h" */
/* #include "attrs.h" */
/* #include "message.h" */
/* #include "tmbstr.h" */
/* #include "utf8.h" */

/*
 Bind attribute types to procedures to check values.
 You can add new procedures for better validation
 and each procedure has access to the node in which
 the attribute occurred as well as the attribute name
 and its value.

 By default, attributes are checked without regard
 to the element they are found on. You have the choice
 of making the procedure test which element is involved
 or in writing methods for each element which controls
 exactly how the attributes of that element are checked.
 This latter approach is best for detecting the absence
 of required attributes.
*/

static AttrCheck CheckAction;
static AttrCheck CheckScript;
static AttrCheck CheckName;
static AttrCheck CheckId;
static AttrCheck CheckIs;
static AttrCheck CheckAlign;
static AttrCheck CheckValign;
static AttrCheck CheckBool;
static AttrCheck CheckLength;
static AttrCheck CheckTarget;
static AttrCheck CheckFsubmit;
static AttrCheck CheckClear;
static AttrCheck CheckShape;
static AttrCheck CheckNumber;
static AttrCheck CheckScope;
static AttrCheck CheckColor;
static AttrCheck CheckVType;
static AttrCheck CheckScroll;
static AttrCheck CheckTextDir;
static AttrCheck CheckLang;
static AttrCheck CheckType;
static AttrCheck CheckRDFaSafeCURIE;
static AttrCheck CheckRDFaTerm;
static AttrCheck CheckRDFaPrefix;

#define CH_PCDATA      NULL
#define CH_CHARSET     NULL
#define CH_TYPE        CheckType
#define CH_XTYPE       NULL
#define CH_CHARACTER   NULL
#define CH_URLS        NULL
#define CH_URL         TY_(CheckUrl)
#define CH_SCRIPT      CheckScript
#define CH_ALIGN       CheckAlign
#define CH_VALIGN      CheckValign
#define CH_COLOR       CheckColor
#define CH_CLEAR       CheckClear
#define CH_BORDER      CheckBool     /* kludge */
#define CH_LANG        CheckLang
#define CH_BOOL        CheckBool
#define CH_COLS        NULL
#define CH_NUMBER      CheckNumber
#define CH_LENGTH      CheckLength
#define CH_COORDS      NULL
#define CH_DATE        NULL
#define CH_TEXTDIR     CheckTextDir
#define CH_IDREFS      NULL
#define CH_IDREF       NULL
#define CH_IDDEF       CheckId
#define CH_ISDEF       CheckIs
#define CH_NAME        CheckName
#define CH_TFRAME      NULL
#define CH_FBORDER     NULL
#define CH_MEDIA       NULL
#define CH_FSUBMIT     CheckFsubmit
#define CH_LINKTYPES   NULL
#define CH_TRULES      NULL
#define CH_SCOPE       CheckScope
#define CH_SHAPE       CheckShape
#define CH_SCROLL      CheckScroll
#define CH_TARGET      CheckTarget
#define CH_VTYPE       CheckVType
#define CH_ACTION      CheckAction
#define CH_RDFAPREFIX  CheckRDFaPrefix
#define CH_RDFASCURIE  CheckRDFaSafeCURIE
#define CH_RDFASCURIES CheckRDFaSafeCURIE
#define CH_RDFATERM    CheckRDFaTerm
#define CH_RDFATERMS   CheckRDFaTerm

static const Attribute attribute_defs [] =
{
  { TidyAttr_UNKNOWN,                 "unknown!",                NULL         }, 
  { TidyAttr_ABBR,                    "abbr",                    CH_PCDATA    }, 
  { TidyAttr_ACCEPT,                  "accept",                  CH_XTYPE     }, 
  { TidyAttr_ACCEPT_CHARSET,          "accept-charset",          CH_CHARSET   }, 
  { TidyAttr_ACCESSKEY,               "accesskey",               CH_CHARACTER }, 
  { TidyAttr_ACTION,                  "action",                  CH_ACTION    }, 
  { TidyAttr_ADD_DATE,                "add_date",                CH_PCDATA    }, /* A */
  { TidyAttr_ALIGN,                   "align",                   CH_ALIGN     }, /* varies by element */
  { TidyAttr_ALINK,                   "alink",                   CH_COLOR     }, 
  { TidyAttr_ALLOWFULLSCREEN,         "allowfullscreen",         CH_BOOL      },
  { TidyAttr_ALT,                     "alt",                     CH_PCDATA    }, /* nowrap */
  { TidyAttr_ARCHIVE,                 "archive",                 CH_URLS      }, /* space or comma separated list */
  { TidyAttr_AXIS,                    "axis",                    CH_PCDATA    }, 
  { TidyAttr_BACKGROUND,              "background",              CH_URL       }, 
  { TidyAttr_BGCOLOR,                 "bgcolor",                 CH_COLOR     }, 
  { TidyAttr_BGPROPERTIES,            "bgproperties",            CH_PCDATA    }, /* BODY "fixed" fixes background */
  { TidyAttr_BORDER,                  "border",                  CH_BORDER    }, /* like LENGTH + "border" */
  { TidyAttr_BORDERCOLOR,             "bordercolor",             CH_COLOR     }, /* used on TABLE */
  { TidyAttr_BOTTOMMARGIN,            "bottommargin",            CH_NUMBER    }, /* used on BODY */
  { TidyAttr_CELLPADDING,             "cellpadding",             CH_LENGTH    }, /* % or pixel values */
  { TidyAttr_CELLSPACING,             "cellspacing",             CH_LENGTH    }, 
  { TidyAttr_CHAR,                    "char",                    CH_CHARACTER }, 
  { TidyAttr_CHAROFF,                 "charoff",                 CH_LENGTH    }, 
  { TidyAttr_CHARSET,                 "charset",                 CH_CHARSET   }, 
  { TidyAttr_CHECKED,                 "checked",                 CH_BOOL      }, /* i.e. "checked" or absent */
  { TidyAttr_CITE,                    "cite",                    CH_URL       }, 
  { TidyAttr_CLASS,                   "class",                   CH_PCDATA    }, 
  { TidyAttr_CLASSID,                 "classid",                 CH_URL       }, 
  { TidyAttr_CLEAR,                   "clear",                   CH_CLEAR     }, /* BR: left, right, all */
  { TidyAttr_CODE,                    "code",                    CH_PCDATA    }, /* APPLET */
  { TidyAttr_CODEBASE,                "codebase",                CH_URL       }, /* OBJECT */
  { TidyAttr_CODETYPE,                "codetype",                CH_XTYPE     }, /* OBJECT */
  { TidyAttr_COLOR,                   "color",                   CH_COLOR     }, /* BASEFONT, FONT */
  { TidyAttr_COLS,                    "cols",                    CH_COLS      }, /* TABLE & FRAMESET */
  { TidyAttr_COLSPAN,                 "colspan",                 CH_NUMBER    }, 
  { TidyAttr_COMPACT,                 "compact",                 CH_BOOL      }, /* lists */
  { TidyAttr_CONTENT,                 "content",                 CH_PCDATA    }, 
  { TidyAttr_COORDS,                  "coords",                  CH_COORDS    }, /* AREA, A */
  { TidyAttr_DATA,                    "data",                    CH_URL       }, /* OBJECT */
  { TidyAttr_DATAFLD,                 "datafld",                 CH_PCDATA    }, /* used on DIV, IMG */
  { TidyAttr_DATAFORMATAS,            "dataformatas",            CH_PCDATA    }, /* used on DIV, IMG */
  { TidyAttr_DATAPAGESIZE,            "datapagesize",            CH_NUMBER    }, /* used on DIV, IMG */
  { TidyAttr_DATASRC,                 "datasrc",                 CH_URL       }, /* used on TABLE */
  { TidyAttr_DATETIME,                "datetime",                CH_DATE      }, /* INS, DEL */
  { TidyAttr_DECLARE,                 "declare",                 CH_BOOL      }, /* OBJECT */
  { TidyAttr_DEFER,                   "defer",                   CH_BOOL      }, /* SCRIPT */
  { TidyAttr_DIR,                     "dir",                     CH_TEXTDIR   }, /* ltr, rtl or auto */
  { TidyAttr_DISABLED,                "disabled",                CH_BOOL      }, /* form fields */
  { TidyAttr_DOWNLOAD,                "download",                CH_PCDATA    }, /* anchor */
  { TidyAttr_ENCODING,                "encoding",                CH_PCDATA    }, /* <?xml?> */
  { TidyAttr_ENCTYPE,                 "enctype",                 CH_XTYPE     }, /* FORM */
  { TidyAttr_FACE,                    "face",                    CH_PCDATA    }, /* BASEFONT, FONT */
  { TidyAttr_FOR,                     "for",                     CH_IDREF     }, /* LABEL */
  { TidyAttr_FRAME,                   "frame",                   CH_TFRAME    }, /* TABLE */
  { TidyAttr_FRAMEBORDER,             "frameborder",             CH_FBORDER   }, /* 0 or 1 */
  { TidyAttr_FRAMESPACING,            "framespacing",            CH_NUMBER    }, 
  { TidyAttr_GRIDX,                   "gridx",                   CH_NUMBER    }, /* TABLE Adobe golive*/
  { TidyAttr_GRIDY,                   "gridy",                   CH_NUMBER    }, /* TABLE Adobe golive */
  { TidyAttr_HEADERS,                 "headers",                 CH_IDREFS    }, /* table cells */
  { TidyAttr_HEIGHT,                  "height",                  CH_LENGTH    }, /* pixels only for TH/TD */
  { TidyAttr_HREF,                    "href",                    CH_URL       }, /* A, AREA, LINK and BASE */
  { TidyAttr_HREFLANG,                "hreflang",                CH_LANG      }, /* A, LINK */
  { TidyAttr_HSPACE,                  "hspace",                  CH_NUMBER    }, /* APPLET, IMG, OBJECT */
  { TidyAttr_HTTP_EQUIV,              "http-equiv",              CH_PCDATA    }, /* META */
  { TidyAttr_ID,                      "id",                      CH_IDDEF     }, 
  { TidyAttr_IS,                      "is",                      CH_ISDEF     },
  { TidyAttr_ISMAP,                   "ismap",                   CH_BOOL      }, /* IMG */
  { TidyAttr_ITEMID,                  "itemid",                  CH_PCDATA    },
  { TidyAttr_ITEMPROP,                "itemprop",                CH_PCDATA    },
  { TidyAttr_ITEMREF,                 "itemref",                 CH_PCDATA    },
  { TidyAttr_ITEMSCOPE,               "itemscope",               CH_BOOL      },
  { TidyAttr_ITEMTYPE,                "itemtype",                CH_URL       },
  { TidyAttr_LABEL,                   "label",                   CH_PCDATA    }, /* OPT, OPTGROUP */
  { TidyAttr_LANG,                    "lang",                    CH_LANG      }, 
  { TidyAttr_LANGUAGE,                "language",                CH_PCDATA    }, /* SCRIPT */
  { TidyAttr_LAST_MODIFIED,           "last_modified",           CH_PCDATA    }, /* A */
  { TidyAttr_LAST_VISIT,              "last_visit",              CH_PCDATA    }, /* A */
  { TidyAttr_LEFTMARGIN,              "leftmargin",              CH_NUMBER    }, /* used on BODY */
  { TidyAttr_LINK,                    "link",                    CH_COLOR     }, /* BODY */
  { TidyAttr_LONGDESC,                "longdesc",                CH_URL       }, /* IMG */
  { TidyAttr_LOWSRC,                  "lowsrc",                  CH_URL       }, /* IMG */
  { TidyAttr_MARGINHEIGHT,            "marginheight",            CH_NUMBER    }, /* FRAME, IFRAME, BODY */
  { TidyAttr_MARGINWIDTH,             "marginwidth",             CH_NUMBER    }, /* ditto */
  { TidyAttr_MAXLENGTH,               "maxlength",               CH_NUMBER    }, /* INPUT */
  { TidyAttr_MEDIA,                   "media",                   CH_MEDIA     }, /* STYLE, LINK */
  { TidyAttr_METHOD,                  "method",                  CH_FSUBMIT   }, /* FORM: get or post */
  { TidyAttr_MULTIPLE,                "multiple",                CH_BOOL      }, /* SELECT */
  { TidyAttr_NAME,                    "name",                    CH_NAME      }, 
  { TidyAttr_NOHREF,                  "nohref",                  CH_BOOL      }, /* AREA */
  { TidyAttr_NORESIZE,                "noresize",                CH_BOOL      }, /* FRAME */
  { TidyAttr_NOSHADE,                 "noshade",                 CH_BOOL      }, /* HR */
  { TidyAttr_NOWRAP,                  "nowrap",                  CH_BOOL      }, /* table cells */
  { TidyAttr_OBJECT,                  "object",                  CH_PCDATA    }, /* APPLET */
  { TidyAttr_OnAFTERUPDATE,           "onafterupdate",           CH_SCRIPT    }, 
  { TidyAttr_OnBEFOREUNLOAD,          "onbeforeunload",          CH_SCRIPT    }, 
  { TidyAttr_OnBEFOREUPDATE,          "onbeforeupdate",          CH_SCRIPT    }, 
  { TidyAttr_OnBLUR,                  "onblur",                  CH_SCRIPT    }, /* event */
  { TidyAttr_OnCHANGE,                "onchange",                CH_SCRIPT    }, /* event */
  { TidyAttr_OnCLICK,                 "onclick",                 CH_SCRIPT    }, /* event */
  { TidyAttr_OnDATAAVAILABLE,         "ondataavailable",         CH_SCRIPT    }, /* object, applet */
  { TidyAttr_OnDATASETCHANGED,        "ondatasetchanged",        CH_SCRIPT    }, /* object, applet */
  { TidyAttr_OnDATASETCOMPLETE,       "ondatasetcomplete",       CH_SCRIPT    }, 
  { TidyAttr_OnDBLCLICK,              "ondblclick",              CH_SCRIPT    }, /* event */
  { TidyAttr_OnERRORUPDATE,           "onerrorupdate",           CH_SCRIPT    }, /* form fields */
  { TidyAttr_OnFOCUS,                 "onfocus",                 CH_SCRIPT    }, /* event */
  { TidyAttr_OnKEYDOWN,               "onkeydown",               CH_SCRIPT    }, /* event */
  { TidyAttr_OnKEYPRESS,              "onkeypress",              CH_SCRIPT    }, /* event */
  { TidyAttr_OnKEYUP,                 "onkeyup",                 CH_SCRIPT    }, /* event */
  { TidyAttr_OnLOAD,                  "onload",                  CH_SCRIPT    }, /* event */
  { TidyAttr_OnMOUSEDOWN,             "onmousedown",             CH_SCRIPT    }, /* event */
  { TidyAttr_OnMOUSEMOVE,             "onmousemove",             CH_SCRIPT    }, /* event */
  { TidyAttr_OnMOUSEOUT,              "onmouseout",              CH_SCRIPT    }, /* event */
  { TidyAttr_OnMOUSEOVER,             "onmouseover",             CH_SCRIPT    }, /* event */
  { TidyAttr_OnMOUSEUP,               "onmouseup",               CH_SCRIPT    }, /* event */
  { TidyAttr_OnRESET,                 "onreset",                 CH_SCRIPT    }, /* event */
  { TidyAttr_OnROWENTER,              "onrowenter",              CH_SCRIPT    }, /* form fields */
  { TidyAttr_OnROWEXIT,               "onrowexit",               CH_SCRIPT    }, /* form fields */
  { TidyAttr_OnSELECT,                "onselect",                CH_SCRIPT    }, /* event */
  { TidyAttr_OnSUBMIT,                "onsubmit",                CH_SCRIPT    }, /* event */
  { TidyAttr_OnUNLOAD,                "onunload",                CH_SCRIPT    }, /* event */
  { TidyAttr_PROFILE,                 "profile",                 CH_URL       }, /* HEAD */
  { TidyAttr_PROMPT,                  "prompt",                  CH_PCDATA    }, /* ISINDEX */
  { TidyAttr_RBSPAN,                  "rbspan",                  CH_NUMBER    }, /* ruby markup */
  { TidyAttr_READONLY,                "readonly",                CH_BOOL      }, /* form fields */
  { TidyAttr_REL,                     "rel",                     CH_LINKTYPES }, 
  { TidyAttr_REV,                     "rev",                     CH_LINKTYPES }, 
  { TidyAttr_RIGHTMARGIN,             "rightmargin",             CH_NUMBER    }, /* used on BODY */
  { TidyAttr_ROLE,                    "role",                    CH_PCDATA    },
  { TidyAttr_ROWS,                    "rows",                    CH_NUMBER    }, /* TEXTAREA */
  { TidyAttr_ROWSPAN,                 "rowspan",                 CH_NUMBER    }, /* table cells */
  { TidyAttr_RULES,                   "rules",                   CH_TRULES    }, /* TABLE */
  { TidyAttr_SCHEME,                  "scheme",                  CH_PCDATA    }, /* META */
  { TidyAttr_SCOPE,                   "scope",                   CH_SCOPE     }, /* table cells */
  { TidyAttr_SCROLLING,               "scrolling",               CH_SCROLL    }, /* yes, no or auto */
  { TidyAttr_SELECTED,                "selected",                CH_BOOL      }, /* OPTION */
  { TidyAttr_SHAPE,                   "shape",                   CH_SHAPE     }, /* AREA, A */
  { TidyAttr_SHOWGRID,                "showgrid",                CH_BOOL      }, /* TABLE Adobe golive */
  { TidyAttr_SHOWGRIDX,               "showgridx",               CH_BOOL      }, /* TABLE Adobe golive*/
  { TidyAttr_SHOWGRIDY,               "showgridy",               CH_BOOL      }, /* TABLE Adobe golive*/
  { TidyAttr_SIZE,                    "size",                    CH_NUMBER    }, /* HR, FONT, BASEFONT, SELECT */
  { TidyAttr_SPAN,                    "span",                    CH_NUMBER    }, /* COL, COLGROUP */
  { TidyAttr_SRC,                     "src",                     CH_URL       }, /* IMG, FRAME, IFRAME */
  { TidyAttr_SRCSET,                  "srcset",                  CH_PCDATA    }, /* IMG (HTML5) */
  { TidyAttr_STANDBY,                 "standby",                 CH_PCDATA    }, /* OBJECT */
  { TidyAttr_START,                   "start",                   CH_NUMBER    }, /* OL */
  { TidyAttr_STYLE,                   "style",                   CH_PCDATA    }, 
  { TidyAttr_SUMMARY,                 "summary",                 CH_PCDATA    }, /* TABLE */
  { TidyAttr_TABINDEX,                "tabindex",                CH_NUMBER    }, /* fields, OBJECT  and A */
  { TidyAttr_TARGET,                  "target",                  CH_TARGET    }, /* names a frame/window */
  { TidyAttr_TEXT,                    "text",                    CH_COLOR     }, /* BODY */
  { TidyAttr_TITLE,                   "title",                   CH_PCDATA    }, /* text tool tip */
  { TidyAttr_TOPMARGIN,               "topmargin",               CH_NUMBER    }, /* used on BODY */
  { TidyAttr_TRANSLATE,               "translate",               CH_BOOL      }, /* HTML5 global attribute */
  { TidyAttr_TYPE,                    "type",                    CH_TYPE      }, /* also used by SPACER */
  { TidyAttr_USEMAP,                  "usemap",                  CH_URL       }, /* things with images */
  { TidyAttr_VALIGN,                  "valign",                  CH_VALIGN    }, 
  { TidyAttr_VALUE,                   "value",                   CH_PCDATA    }, 
  { TidyAttr_VALUETYPE,               "valuetype",               CH_VTYPE     }, /* PARAM: data, ref, object */
  { TidyAttr_VERSION,                 "version",                 CH_PCDATA    }, /* HTML <?xml?> */
  { TidyAttr_VLINK,                   "vlink",                   CH_COLOR     }, /* BODY */
  { TidyAttr_VSPACE,                  "vspace",                  CH_NUMBER    }, /* IMG, OBJECT, APPLET */
  { TidyAttr_WIDTH,                   "width",                   CH_LENGTH    }, /* pixels only for TD/TH */
  { TidyAttr_WRAP,                    "wrap",                    CH_PCDATA    }, /* textarea */
  { TidyAttr_XML_LANG,                "xml:lang",                CH_LANG      }, /* XML language */
  { TidyAttr_XML_SPACE,               "xml:space",               CH_PCDATA    }, /* XML white space */

  /* todo: VERS_ALL is wrong! */
  { TidyAttr_XMLNS,                   "xmlns",                   CH_PCDATA    }, /* name space */
  { TidyAttr_EVENT,                   "event",                   CH_PCDATA    }, /* reserved for <script> */
  { TidyAttr_METHODS,                 "methods",                 CH_PCDATA    }, /* for <a>, never implemented */
  { TidyAttr_N,                       "n",                       CH_PCDATA    }, /* for <nextid> */
  { TidyAttr_SDAFORM,                 "sdaform",                 CH_PCDATA    }, /* SDATA attribute in HTML 2.0 */
  { TidyAttr_SDAPREF,                 "sdapref",                 CH_PCDATA    }, /* SDATA attribute in HTML 2.0 */
  { TidyAttr_SDASUFF,                 "sdasuff",                 CH_PCDATA    }, /* SDATA attribute in HTML 2.0 */
  { TidyAttr_URN,                     "urn",                     CH_PCDATA    }, /* for <a>, never implemented */

  /* HTML5 */
  { TidyAttr_ASYNC,                   "async",                   CH_BOOL     }, /* <script src="..." async> */
  { TidyAttr_AUTOCOMPLETE,            "autocomplete",            CH_PCDATA   },
  { TidyAttr_AUTOFOCUS,               "autofocus",               CH_PCDATA   },
  { TidyAttr_AUTOPLAY,                "autoplay",                CH_PCDATA   },
  { TidyAttr_CHALLENGE,               "challenge",               CH_PCDATA   },
  { TidyAttr_CONTENTEDITABLE,         "contenteditable",         CH_PCDATA   },
  { TidyAttr_CONTEXTMENU,             "contextmenu",             CH_PCDATA   },
  { TidyAttr_CONTROLS,                "controls",                CH_PCDATA   },
  { TidyAttr_CROSSORIGIN,             "crossorigin",             CH_PCDATA   },
  { TidyAttr_DEFAULT,                 "default",                 CH_PCDATA   },
  { TidyAttr_DIRNAME,                 "dirname",                 CH_PCDATA   },
  { TidyAttr_DRAGGABLE,               "draggable",               CH_PCDATA   },
  { TidyAttr_DROPZONE,                "dropzone",                CH_PCDATA   },
  { TidyAttr_FORM,                    "form",                    CH_PCDATA   },
  { TidyAttr_FORMACTION,              "formaction",              CH_PCDATA   },
  { TidyAttr_FORMENCTYPE,             "formenctype",             CH_PCDATA   },
  { TidyAttr_FORMMETHOD,              "formmethod",              CH_PCDATA   },
  { TidyAttr_FORMNOVALIDATE,          "formnovalidate",          CH_PCDATA   },
  { TidyAttr_FORMTARGET,              "formtarget",              CH_PCDATA   },
  { TidyAttr_HIDDEN,                  "hidden",                  CH_PCDATA   },
  { TidyAttr_HIGH,                    "high",                    CH_PCDATA   },
  { TidyAttr_ICON,                    "icon",                    CH_PCDATA   },
  { TidyAttr_KEYTYPE,                 "keytype",                 CH_PCDATA   },
  { TidyAttr_KIND,                    "kind",                    CH_PCDATA   },
  { TidyAttr_LIST,                    "list",                    CH_PCDATA   },
  { TidyAttr_LOOP,                    "loop",                    CH_PCDATA   },
  { TidyAttr_LOW,                     "low",                     CH_PCDATA   },
  { TidyAttr_MANIFEST,                "manifest",                CH_PCDATA   },
  { TidyAttr_MAX,                     "max",                     CH_PCDATA   },
  { TidyAttr_MEDIAGROUP,              "mediagroup",              CH_PCDATA   },
  { TidyAttr_MIN,                     "min",                     CH_PCDATA   },
  { TidyAttr_NOVALIDATE,              "novalidate",              CH_PCDATA   },
  { TidyAttr_OPEN,                    "open",                    CH_PCDATA   },
  { TidyAttr_OPTIMUM,                 "optimum",                 CH_PCDATA   },
  { TidyAttr_OnABORT,                 "onabort",                 CH_PCDATA   },
  { TidyAttr_OnAFTERPRINT,            "onafterprint",            CH_PCDATA   },
  { TidyAttr_OnBEFOREPRINT,           "onbeforeprint",           CH_PCDATA   },
  { TidyAttr_OnCANPLAY,               "oncanplay",               CH_PCDATA   },
  { TidyAttr_OnCANPLAYTHROUGH,        "oncanplaythrough",        CH_PCDATA   },
  { TidyAttr_OnCONTEXTMENU,           "oncontextmenu",           CH_PCDATA   },
  { TidyAttr_OnCUECHANGE,             "oncuechange",             CH_PCDATA   },
  { TidyAttr_OnDRAG,                  "ondrag",                  CH_PCDATA   },
  { TidyAttr_OnDRAGEND,               "ondragend",               CH_PCDATA   },
  { TidyAttr_OnDRAGENTER,             "ondragenter",             CH_PCDATA   },
  { TidyAttr_OnDRAGLEAVE,             "ondragleave",             CH_PCDATA   },
  { TidyAttr_OnDRAGOVER,              "ondragover",              CH_PCDATA   },
  { TidyAttr_OnDRAGSTART,             "ondragstart",             CH_PCDATA   },
  { TidyAttr_OnDROP,                  "ondrop",                  CH_PCDATA   },
  { TidyAttr_OnDURATIONCHANGE,        "ondurationchange",        CH_PCDATA   },
  { TidyAttr_OnEMPTIED,               "onemptied",               CH_PCDATA   },
  { TidyAttr_OnENDED,                 "onended",                 CH_PCDATA   },
  { TidyAttr_OnERROR,                 "onerror",                 CH_PCDATA   },
  { TidyAttr_OnHASHCHANGE,            "onhashchange",            CH_PCDATA   },
  { TidyAttr_OnINPUT,                 "oninput",                 CH_PCDATA   },
  { TidyAttr_OnINVALID,               "oninvalid",               CH_PCDATA   },
  { TidyAttr_OnLOADEDDATA,            "onloadeddata",            CH_PCDATA   },
  { TidyAttr_OnLOADEDMETADATA,        "onloadedmetadata",        CH_PCDATA   },
  { TidyAttr_OnLOADSTART,             "onloadstart",             CH_PCDATA   },
  { TidyAttr_OnMESSAGE,               "onmessage",               CH_PCDATA   },
  { TidyAttr_OnMOUSEWHEEL,            "onmousewheel",            CH_PCDATA   },
  { TidyAttr_OnOFFLINE,               "onoffline",               CH_PCDATA   },
  { TidyAttr_OnONLINE,                "ononline",                CH_PCDATA   },
  { TidyAttr_OnPAGEHIDE,              "onpagehide",              CH_PCDATA   },
  { TidyAttr_OnPAGESHOW,              "onpageshow",              CH_PCDATA   },
  { TidyAttr_OnPAUSE,                 "onpause",                 CH_PCDATA   },
  { TidyAttr_OnPLAY,                  "onplay",                  CH_PCDATA   },
  { TidyAttr_OnPLAYING,               "onplaying",               CH_PCDATA   },
  { TidyAttr_OnPOPSTATE,              "onpopstate",              CH_PCDATA   },
  { TidyAttr_OnPROGRESS,              "onprogress",              CH_PCDATA   },
  { TidyAttr_OnRATECHANGE,            "onratechange",            CH_PCDATA   },
  { TidyAttr_OnREADYSTATECHANGE,      "onreadystatechange",      CH_PCDATA   },
  { TidyAttr_OnREDO,                  "onredo",                  CH_PCDATA   },
  { TidyAttr_OnRESIZE,                "onresize",                CH_PCDATA   },
  { TidyAttr_OnSCROLL,                "onscroll",                CH_PCDATA   },
  { TidyAttr_OnSEEKED,                "onseeked",                CH_PCDATA   },
  { TidyAttr_OnSEEKING,               "onseeking",               CH_PCDATA   },
  { TidyAttr_OnSHOW,                  "onshow",                  CH_PCDATA   },
  { TidyAttr_OnSTALLED,               "onstalled",               CH_PCDATA   },
  { TidyAttr_OnSTORAGE,               "onstorage",               CH_PCDATA   },
  { TidyAttr_OnSUSPEND,               "onsuspend",               CH_PCDATA   },
  { TidyAttr_OnTIMEUPDATE,            "ontimeupdate",            CH_PCDATA   },
  { TidyAttr_OnUNDO,                  "onundo",                  CH_PCDATA   },
  { TidyAttr_OnVOLUMECHANGE,          "onvolumechange",          CH_PCDATA   },
  { TidyAttr_OnWAITING,               "onwaiting",               CH_PCDATA   },
  { TidyAttr_PATTERN,                 "pattern",                 CH_PCDATA   },
  { TidyAttr_PLACEHOLDER,             "placeholder",             CH_PCDATA   },
  { TidyAttr_POSTER,                  "poster",                  CH_PCDATA   },
  { TidyAttr_PRELOAD,                 "preload",                 CH_PCDATA   },
  { TidyAttr_PUBDATE,                 "pubdate",                 CH_PCDATA   },
  { TidyAttr_RADIOGROUP,              "radiogroup",              CH_PCDATA   },
  { TidyAttr_REQUIRED,                "required",                CH_PCDATA   },
  { TidyAttr_REVERSED,                "reversed",                CH_PCDATA   },
  { TidyAttr_SANDBOX,                 "sandbox",                 CH_PCDATA   },
  { TidyAttr_SCOPED,                  "scoped",                  CH_PCDATA   },
  { TidyAttr_SEAMLESS,                "seamless",                CH_PCDATA   },
  { TidyAttr_SIZES,                   "sizes",                   CH_PCDATA   },
  { TidyAttr_SPELLCHECK,              "spellcheck",              CH_PCDATA   },
  { TidyAttr_SRCDOC,                  "srcdoc",                  CH_PCDATA   },
  { TidyAttr_SRCLANG,                 "srclang",                 CH_PCDATA   },
  { TidyAttr_STEP,                    "step",                    CH_PCDATA   },

  /* HTML5 Aria Attributes */
  { TidyAttr_ARIA_ACTIVEDESCENDANT,   "aria-activedescendant",   CH_PCDATA   },
  { TidyAttr_ARIA_ATOMIC,             "aria-atomic",             CH_PCDATA   },
  { TidyAttr_ARIA_AUTOCOMPLETE,       "aria-autocomplete",       CH_PCDATA   },
  { TidyAttr_ARIA_BUSY,               "aria-busy",               CH_PCDATA   },
  { TidyAttr_ARIA_CHECKED,            "aria-checked",            CH_PCDATA   },
  { TidyAttr_ARIA_CONTROLS,           "aria-controls",           CH_PCDATA   },
  { TidyAttr_ARIA_DESCRIBEDBY,        "aria-describedby",        CH_PCDATA   },
  { TidyAttr_ARIA_DISABLED,           "aria-disabled",           CH_PCDATA   },
  { TidyAttr_ARIA_DROPEFFECT,         "aria-dropeffect",         CH_PCDATA   },
  { TidyAttr_ARIA_EXPANDED,           "aria-expanded",           CH_PCDATA   },
  { TidyAttr_ARIA_FLOWTO,             "aria-flowto",             CH_PCDATA   },
  { TidyAttr_ARIA_GRABBED,            "aria-grabbed",            CH_PCDATA   },
  { TidyAttr_ARIA_HASPOPUP,           "aria-haspopup",           CH_PCDATA   },
  { TidyAttr_ARIA_HIDDEN,             "aria-hidden",             CH_PCDATA   },
  { TidyAttr_ARIA_INVALID,            "aria-invalid",            CH_PCDATA   },
  { TidyAttr_ARIA_LABEL,              "aria-label",              CH_PCDATA   },
  { TidyAttr_ARIA_LABELLEDBY,         "aria-labelledby",         CH_PCDATA   },
  { TidyAttr_ARIA_LEVEL,              "aria-level",              CH_PCDATA   },
  { TidyAttr_ARIA_LIVE,               "aria-live",               CH_PCDATA   },
  { TidyAttr_ARIA_MULTILINE,          "aria-multiline",          CH_PCDATA   },
  { TidyAttr_ARIA_MULTISELECTABLE,    "aria-multiselectable",    CH_PCDATA   },
  { TidyAttr_ARIA_ORIENTATION,        "aria-orientation",        CH_PCDATA   },
  { TidyAttr_ARIA_OWNS,               "aria-owns",               CH_PCDATA   },
  { TidyAttr_ARIA_POSINSET,           "aria-posinset",           CH_PCDATA   },
  { TidyAttr_ARIA_PRESSED,            "aria-pressed",            CH_PCDATA   },
  { TidyAttr_ARIA_READONLY,           "aria-readonly",           CH_PCDATA   },
  { TidyAttr_ARIA_RELEVANT,           "aria-relevant",           CH_PCDATA   },
  { TidyAttr_ARIA_REQUIRED,           "aria-required",           CH_PCDATA   },
  { TidyAttr_ARIA_SELECTED,           "aria-selected",           CH_PCDATA   },
  { TidyAttr_ARIA_SETSIZE,            "aria-setsize",            CH_PCDATA   },
  { TidyAttr_ARIA_SORT,               "aria-sort",               CH_PCDATA   },
  { TidyAttr_ARIA_VALUEMAX,           "aria-valuemax",           CH_PCDATA   },
  { TidyAttr_ARIA_VALUEMIN,           "aria-valuemin",           CH_PCDATA   },
  { TidyAttr_ARIA_VALUENOW,           "aria-valuenow",           CH_PCDATA   },
  { TidyAttr_ARIA_VALUETEXT,          "aria-valuetext",          CH_PCDATA   },
  { TidyAttr_X,                       "x",                       CH_PCDATA    }, /* for <svg> */
  { TidyAttr_Y,                       "y",                       CH_PCDATA    }, /* for <svg> */
  { TidyAttr_VIEWBOX,                  "viewbox",                CH_PCDATA    }, /* for <svg> */
  { TidyAttr_PRESERVEASPECTRATIO,      "preserveaspectratio",    CH_PCDATA    }, /* for <svg> */
  { TidyAttr_ZOOMANDPAN,               "zoomandpan",             CH_PCDATA    }, /* for <svg> */
  { TidyAttr_BASEPROFILE,              "baseprofile",            CH_PCDATA    }, /* for <svg> */
  { TidyAttr_CONTENTSCRIPTTYPE,        "contentscripttype",      CH_PCDATA    }, /* for <svg> */
  { TidyAttr_CONTENTSTYLETYPE,         "contentstyletype",       CH_PCDATA    }, /* for <svg> */
  { TidyAttr_DISPLAY,                  "display",                CH_PCDATA   }, /* on MATH tag (html5) */

  /* RDFa Attributes */
  { TidyAttr_ABOUT,                    "about",                  CH_RDFASCURIE },
  { TidyAttr_DATATYPE,                 "datatype",               CH_RDFATERM   },
  { TidyAttr_INLIST,                   "inlist",                 CH_BOOL       },
  { TidyAttr_PREFIX,                   "prefix",                 CH_RDFAPREFIX },
  { TidyAttr_PROPERTY,                 "property",               CH_RDFATERMS  },
  { TidyAttr_RESOURCE,                 "resource",               CH_RDFASCURIE },
  { TidyAttr_TYPEOF,                   "typeof",                 CH_RDFATERMS  },
  { TidyAttr_VOCAB,                    "vocab",                  CH_URL        },

  { TidyAttr_INTEGRITY,                "integrity",              CH_PCDATA   },

  /* Preload spec: https://www.w3.org/TR/preload/ */
  { TidyAttr_AS,                       "as",                     CH_PCDATA   },

  /* for xmlns:xlink in <svg> */
  { TidyAttr_XMLNSXLINK,                "xmlns:xlink",           CH_URL       },

  /* this must be the final entry */
  { N_TIDY_ATTRIBS,                    NULL,                     NULL         }
};

static unsigned int AttributeVersions(Node* node, AttVal* attval)
{
    unsigned int i;

    /* Override or add to items in attrdict.c */
    if (attval && attval->attribute) {
        /* HTML5 data-* attributes can't be added generically; handle here. */
        if (TY_(tmbstrncmp)(attval->attribute, "data-", 5) == 0)
            return (XH50 | HT50);
    }
    /* TODO: maybe this should return VERS_PROPRIETARY instead? */
    if (!attval || !attval->dict)
        return VERS_UNKNOWN;

    if (!(!node || !node->tag || !node->tag->attrvers))
        for (i = 0; node->tag->attrvers[i].attribute; ++i)
            if (node->tag->attrvers[i].attribute == attval->dict->id)
                return node->tag->attrvers[i].versions;

    return VERS_PROPRIETARY;
}


/* return the version of the attribute "id" of element "node" */
unsigned int TY_(NodeAttributeVersions)( Node* node, TidyAttrId id )
{
    unsigned int i;

    if (!node || !node->tag || !node->tag->attrvers)
        return VERS_UNKNOWN;

    for (i = 0; node->tag->attrvers[i].attribute; ++i)
        if (node->tag->attrvers[i].attribute == id)
            return node->tag->attrvers[i].versions;

    return VERS_UNKNOWN;
}

/* returns true if the element is a W3C defined element
 * but the element/attribute combination is not. We're
 * only defining as "proprietary" items that are not in
 * the element's AttrVersion structure.
 */
Bool TY_(AttributeIsProprietary)(Node* node, AttVal* attval)
{
    if (!node || !attval)
        return no;

    if (!node->tag)
        return no;

    if (!(node->tag->versions & VERS_ALL))
        return no;

    if (AttributeVersions(node, attval) & VERS_ALL)
        return no;

    return yes;
}

/* returns true if the element is a W3C defined element
 * but the element/attribute combination is not. We're
 * considering it a mismatch if the document version
 * does not allow the attribute as called out in its
 * AttrVersion structure.
 */
Bool TY_(AttributeIsMismatched)(Node* node, AttVal* attval, TidyDocImpl* doc)
{
    unsigned int doctype;
    
    if (!node || !attval)
        return no;
    
    if (!node->tag)
        return no;
    
    if (!(node->tag->versions & VERS_ALL))
        return no;

    doctype = doc->lexer->versionEmitted == 0 ? doc->lexer->doctype : doc->lexer->versionEmitted;

    if (AttributeVersions(node, attval) & doctype)
        return no;
    
    return yes;
}


/* used by CheckColor() */
struct _colors
{
    ctmbstr name;
    ctmbstr hex;
};

static const struct _colors colors[] =
{
    { "black",   "#000000" },
    { "green",   "#008000" },
    { "silver",  "#C0C0C0" },
    { "lime",    "#00FF00" },
    { "gray",    "#808080" },
    { "olive",   "#808000" },
    { "white",   "#FFFFFF" },
    { "yellow",  "#FFFF00" },
    { "maroon",  "#800000" },
    { "navy",    "#000080" },
    { "red",     "#FF0000" },
    { "blue",    "#0000FF" },
    { "purple",  "#800080" },
    { "teal",    "#008080" },
    { "fuchsia", "#FF00FF" },
    { "aqua",    "#00FFFF" },
    { NULL,      NULL      }
};

static ctmbstr GetColorCode(ctmbstr name)
{
    unsigned int i;

    for (i = 0; colors[i].name; ++i)
        if (TY_(tmbstrcasecmp)(name, colors[i].name) == 0)
            return colors[i].hex;

    return NULL;
}

static ctmbstr GetColorName(ctmbstr code)
{
    unsigned int i;

    for (i = 0; colors[i].name; ++i)
        if (TY_(tmbstrcasecmp)(code, colors[i].hex) == 0)
            return colors[i].name;

    return NULL;
}

static unsigned int attrsHash(ctmbstr s)
{
    unsigned int hashval;

    for (hashval = 0; *s != '\0'; s++)
        hashval = *s + 31*hashval;

    return hashval % ATTRIBUTE_HASH_SIZE;
}

static const Attribute *attrsInstall(TidyDocImpl* doc, TidyAttribImpl * attribs,
                                const Attribute* old)
{
    AttrHash *np;
    unsigned int hashval;

    if (old)
    {
        np = (AttrHash *)TidyDocAlloc(doc, sizeof(*np));
        np->attr = old;

        hashval = attrsHash(old->name);
        np->next = attribs->hashtab[hashval];
        attribs->hashtab[hashval] = np;
    }

    return old;
}

static void attrsRemoveFromHash( TidyDocImpl* doc, TidyAttribImpl *attribs,
                            ctmbstr s )
{
    unsigned int h = attrsHash(s);
    AttrHash *p, *prev = NULL;
    for (p = attribs->hashtab[h]; p && p->attr; p = p->next)
    {
        if (TY_(tmbstrcmp)(s, p->attr->name) == 0)
        {
            AttrHash* next = p->next;
            if ( prev )
                prev->next = next; 
            else
                attribs->hashtab[h] = next;
            TidyDocFree(doc, p);
            return;
        }
        prev = p;
    }
}

static void attrsEmptyHash( TidyDocImpl* doc, TidyAttribImpl * attribs )
{
    AttrHash *dict, *next;
    unsigned int i;

    for (i = 0; i < ATTRIBUTE_HASH_SIZE; ++i)
    {
        dict = attribs->hashtab[i];

        while(dict)
        {
            next = dict->next;
            TidyDocFree(doc, dict);
            dict = next;
        }

        attribs->hashtab[i] = NULL;
    }
}

static const Attribute* attrsLookup(TidyDocImpl* doc,
                               TidyAttribImpl* ARG_UNUSED(attribs),
                               ctmbstr atnam)
{
    const Attribute *np;
    const AttrHash *p;

    if (!atnam)
        return NULL;

    for (p = attribs->hashtab[attrsHash(atnam)]; p && p->attr; p = p->next)
        if (TY_(tmbstrcasecmp)(atnam, p->attr->name) == 0)
            return p->attr;

    for (np = attribute_defs; np && np->name; ++np)
        if (TY_(tmbstrcasecmp)(atnam, np->name) == 0)
            return attrsInstall(doc, attribs, np);

    return NULL;
}


/* Locate attributes by type */
AttVal* TY_(AttrGetById)( Node* node, TidyAttrId id )
{
   AttVal* av;
   for ( av = node->attributes; av; av = av->next )
   {
     if ( AttrIsId(av, id) )
         return av;
   }
   return NULL;
}

/* public method for finding attribute definition by name */
const Attribute* TY_(FindAttribute)( TidyDocImpl* doc, AttVal *attval )
{
    if ( attval )
       return attrsLookup( doc, &doc->attribs, attval->attribute );
    return NULL;
}

AttVal* TY_(GetAttrByName)( Node *node, ctmbstr name )
{
    AttVal *attr;
    for (attr = node->attributes; attr != NULL; attr = attr->next)
    {
        if (attr->attribute && TY_(tmbstrcmp)(attr->attribute, name) == 0)
            break;
    }
    return attr;
}

void TY_(DropAttrByName)( TidyDocImpl* doc, Node *node, ctmbstr name )
{
    AttVal *attr, *prev = NULL, *next;

    for (attr = node->attributes; attr != NULL; prev = attr, attr = next)
    {
        next = attr->next;

        if (attr->attribute && TY_(tmbstrcmp)(attr->attribute, name) == 0)
        {
            if (prev)
                 prev->next = next;
            else
                 node->attributes = next;

            TY_(FreeAttribute)( doc, attr ); 
            break;
        }
    }
}

AttVal* TY_(AddAttribute)( TidyDocImpl* doc,
                           Node *node, ctmbstr name, ctmbstr value )
{
    AttVal *av = TY_(NewAttribute)(doc);
    av->delim = '"';
    av->attribute = TY_(tmbstrdup)(doc->allocator, name);

    if (value)
        av->value = TY_(tmbstrdup)(doc->allocator, value);
    else
        av->value = NULL;

    av->dict = attrsLookup(doc, &doc->attribs, name);

    TY_(InsertAttributeAtEnd)(node, av);
    return av;
}

AttVal* TY_(RepairAttrValue)(TidyDocImpl* doc, Node* node, ctmbstr name, ctmbstr value)
{
    AttVal* old = TY_(GetAttrByName)(node, name);

    if (old)
    {
        if (old->value)
            TidyDocFree(doc, old->value);
        if (value)
            old->value = TY_(tmbstrdup)(doc->allocator, value);
        else
            old->value = NULL;

        return old;
    }
    else
        return TY_(AddAttribute)(doc, node, name, value);
}


void TY_(FreeAttrPriorityList)( TidyDocImpl* doc )
{
    PriorityAttribs *priorities = &(doc->attribs.priorityAttribs);

    if ( priorities->list )
    {
        unsigned int i = 0;
        while ( priorities->list[i] != NULL )
        {
            TidyFree( doc->allocator, priorities->list[i] );
            i++;
        }

        TidyFree( doc->allocator, priorities->list );
    }
}


void TY_(DefinePriorityAttribute)(TidyDocImpl* doc, ctmbstr name)
{
    enum { capacity = 10 };
    PriorityAttribs *priorities = &(doc->attribs.priorityAttribs);

    if ( !priorities->list )
    {
        priorities->list = TidyAlloc(doc->allocator, sizeof(ctmbstr) * capacity );
        priorities->list[0] = NULL;
        priorities->capacity = capacity;
        priorities->count = 0;
    }

    if ( priorities->count >= priorities->capacity )
    {
        priorities->capacity = priorities->capacity * 2;
        priorities->list = TidyRealloc(doc->allocator, priorities->list, sizeof(tmbstr) * priorities->capacity + 1 );
    }

    priorities->list[priorities->count] = TY_(tmbstrdup)( doc->allocator, name);
    priorities->count++;
    priorities->list[priorities->count] = NULL;
}


TidyIterator TY_(getPriorityAttrList)( TidyDocImpl* doc )
{
    PriorityAttribs *priorities = &(doc->attribs.priorityAttribs);
    size_t result = priorities->count > 0 ? 1 : 0;

    return (TidyIterator) result;
}


ctmbstr  TY_(getNextPriorityAttr)( TidyDocImpl* doc, TidyIterator* iter )
{
    PriorityAttribs *priorities = &(doc->attribs.priorityAttribs);
    size_t index;
    ctmbstr result = NULL;
    assert( iter != NULL );
    index = (size_t)*iter;

    if ( index > 0 && index <= priorities->count )
    {
        result = priorities->list[index-1];
        index++;
    }
    *iter = (TidyIterator) ( index <= priorities->count ? index : (size_t)0 );

    return result;
}


static Bool CheckAttrType( TidyDocImpl* doc,
                           ctmbstr attrname, AttrCheck type )
{
    const Attribute* np = attrsLookup( doc, &doc->attribs, attrname );
    return (Bool)( np && np->attrchk == type );
}

Bool TY_(IsUrl)( TidyDocImpl* doc, ctmbstr attrname )
{
    return CheckAttrType( doc, attrname, CH_URL );
}

/*
Bool IsBool( TidyDocImpl* doc, ctmbstr attrname )
{
    return CheckAttrType( doc, attrname, CH_BOOL );
}
*/

Bool TY_(IsScript)( TidyDocImpl* doc, ctmbstr attrname )
{
    return CheckAttrType( doc, attrname, CH_SCRIPT );
}

/* may id or name serve as anchor? */
Bool TY_(IsAnchorElement)( TidyDocImpl* ARG_UNUSED(doc), Node* node)
{
    TidyTagId tid = TagId( node );
    if ( tid == TidyTag_A      ||
         tid == TidyTag_APPLET ||
         tid == TidyTag_FORM   ||
         tid == TidyTag_FRAME  ||
         tid == TidyTag_IFRAME ||
         tid == TidyTag_IMG    ||
         tid == TidyTag_MAP )
        return yes;

    return no;
}

/*
  In CSS1, selectors can contain only the characters A-Z, 0-9,
  and Unicode characters 161-255, plus dash (-); they cannot start
  with a dash or a digit; they can also contain escaped characters
  and any Unicode character as a numeric code (see next item).

  The backslash followed by at most four hexadecimal digits
  (0..9A..F) stands for the Unicode character with that number.

  Any character except a hexadecimal digit can be escaped to remove
  its special meaning, by putting a backslash in front.

  #508936 - CSS class naming for -clean option
*/
Bool TY_(IsCSS1Selector)( ctmbstr buf )
{
    Bool valid = yes;
    int esclen = 0;
    byte c;
    int pos;

    for ( pos=0; valid && (c = *buf++); ++pos )
    {
        if ( c == '\\' )
        {
            esclen = 1;  /* ab\555\444 is 4 chars {'a', 'b', \555, \444} */
        }
        else if ( isdigit( c ) )
        {
            /* Digit not 1st, unless escaped (Max length "\112F") */
            if ( esclen > 0 )
                valid = ( ++esclen < 6 );
            if ( valid )
                valid = ( pos>0 || esclen>0 );
        }
        else
        {
            valid = (
                esclen > 0                       /* Escaped? Anything goes. */
                || ( pos>0 && c == '-' )         /* Dash cannot be 1st char */
                || isalpha(c)                    /* a-z, A-Z anywhere */
                || ( c >= 161 )                  /* Unicode 161-255 anywhere */
            );
            esclen = 0;
        }
    }
    return valid;
}

/* free single anchor */
static void FreeAnchor(TidyDocImpl* doc, Anchor *a)
{
    if ( a )
        TidyDocFree( doc, a->name );
    TidyDocFree( doc, a );
}

static unsigned int anchorNameHash(ctmbstr s)
{
    unsigned int hashval = 0;
    /* Issue #149 - an inferred name can be null. avoid crash */
    if (s) 
    {
        for ( ; *s != '\0'; s++) {
            tmbchar c = TY_(ToLower)( *s );
            hashval = c + 31*hashval;
        }
    }
    return hashval % ANCHOR_HASH_SIZE;
}

/*\
 *  New Service for HTML5
 *  Issue #185 - Treat elements ids as case-sensitive
 *  if in HTML5 modes, make hash of value AS IS!
\*/
static unsigned int anchorNameHash5(ctmbstr s)
{
    unsigned int hashval = 0;
    /* Issue #149 - an inferred name can be null. avoid crash */
    if (s) 
    {
        for ( ; *s != '\0'; s++) {
            tmbchar c = *s;
            hashval = c + 31*hashval;
        }
    }
    return hashval % ANCHOR_HASH_SIZE;
}


/*\ 
 *  removes anchor for specific node 
 *  Issue #185 - Treat elements ids as case-sensitive
 *  if in HTML5 modes, make hash of value AS IS!
\*/
void TY_(RemoveAnchorByNode)( TidyDocImpl* doc, ctmbstr name, Node *node )
{
    TidyAttribImpl* attribs = &doc->attribs;
    Anchor *delme = NULL, *curr, *prev = NULL;
    unsigned int h;
    if (TY_(HTMLVersion)(doc) == HT50)
        h = anchorNameHash5(name);
    else
        h = anchorNameHash(name);

    for ( curr=attribs->anchor_hash[h]; curr!=NULL; curr=curr->next )
    {
        if ( curr->node == node )
        {
            if ( prev )
                prev->next = curr->next;
            else
                attribs->anchor_hash[h] = curr->next;
            delme = curr;
            break;
        }
        prev = curr;
    }
    FreeAnchor( doc, delme );
}

/* initialize new anchor 
   Is. #726 & #185 - HTML5 is case-sensitive
*/
static Anchor* NewAnchor( TidyDocImpl* doc, ctmbstr name, Node* node )
{
    Anchor *a = (Anchor*) TidyDocAlloc( doc, sizeof(Anchor) );

    a->name = TY_(tmbstrdup)( doc->allocator, name );
    if (!TY_(IsHTML5Mode)(doc)) /* Is. #726 - if NOT HTML5, to lowercase */
        a->name = TY_(tmbstrtolower)(a->name);
    a->node = node;
    a->next = NULL;

    return a;
}

/*\
 *  add new anchor to namespace 
 *  Issue #185 - Treat elements ids as case-sensitive
 *  if in HTML5 modes, make hash of value AS IS!
\*/
static Anchor* AddAnchor( TidyDocImpl* doc, ctmbstr name, Node *node )
{
    TidyAttribImpl* attribs = &doc->attribs;
    Anchor *a = NewAnchor( doc, name, node );
    unsigned int h;
    if (TY_(HTMLVersion)(doc) == HT50)
        h = anchorNameHash5(name);
    else
        h = anchorNameHash(name);

    if ( attribs->anchor_hash[h] == NULL)
         attribs->anchor_hash[h] = a;
    else
    {
        Anchor *here =  attribs->anchor_hash[h];
        while (here->next)
            here = here->next;
        here->next = a;
    }

    return attribs->anchor_hash[h];
}

/*\
 *  return node associated with anchor 
 *  Issue #185 - Treat elements ids as case-sensitive
 *  if in HTML5 modes, make hash of value AS IS!
\*/
static Node* GetNodeByAnchor( TidyDocImpl* doc, ctmbstr name )
{
    TidyAttribImpl* attribs = &doc->attribs;
    Anchor *found;
    unsigned int h;
    tmbstr lname = TY_(tmbstrdup)(doc->allocator, name);
    if (TY_(HTMLVersion)(doc) == HT50) {
        h = anchorNameHash5(name);
    }
    else
    {
        h = anchorNameHash(name);
        lname = TY_(tmbstrtolower)(lname);
    }

    for ( found = attribs->anchor_hash[h]; found != NULL; found = found->next )
    {
        if ( TY_(tmbstrcmp)(found->name, lname) == 0 )
            break;
    }
    
    TidyDocFree(doc, lname);
    if ( found )
        return found->node;
    return NULL;
}

/* free all anchors */
void TY_(FreeAnchors)( TidyDocImpl* doc )
{
    TidyAttribImpl* attribs = &doc->attribs;
    Anchor* a;
    unsigned int h;
    for (h = 0; h < ANCHOR_HASH_SIZE; h++) {
        while (NULL != (a = attribs->anchor_hash[h]) )
        {
            attribs->anchor_hash[h] = a->next;
            FreeAnchor(doc, a);
        }
    }
}

/* public method for inititializing attribute dictionary */
void TY_(InitAttrs)( TidyDocImpl* doc )
{
    TidyClearMemory( &doc->attribs, sizeof(TidyAttribImpl) );
#ifdef _DEBUG
    {
      /* Attribute ID is index position in Attribute type lookup table */
      unsigned int ix;
      for ( ix=0; ix < N_TIDY_ATTRIBS; ++ix )
      {
        const Attribute* dict = &attribute_defs[ ix ];
        assert( (unsigned int) dict->id == ix );
      }
    }
#endif
}

/* free all declared attributes */
static void FreeDeclaredAttributes( TidyDocImpl* doc )
{
    TidyAttribImpl* attribs = &doc->attribs;
    Attribute* dict;
    while ( NULL != (dict = attribs->declared_attr_list) )
    {
        attribs->declared_attr_list = dict->next;
        attrsRemoveFromHash( doc, &doc->attribs, dict->name );
        TidyDocFree( doc, dict->name );
        TidyDocFree( doc, dict );
    }
}

void TY_(FreeAttrTable)( TidyDocImpl* doc )
{
    attrsEmptyHash( doc, &doc->attribs );
    TY_(FreeAnchors)( doc );
    FreeDeclaredAttributes( doc );
}

void TY_(AppendToClassAttr)( TidyDocImpl* doc, AttVal *classattr, ctmbstr classname )
{
    unsigned int len = TY_(tmbstrlen)(classattr->value) +
        TY_(tmbstrlen)(classname) + 2;
    tmbstr s = (tmbstr) TidyDocAlloc( doc, len );
    s[0] = '\0';
    if (classattr->value)
    {
        TY_(tmbstrcpy)( s, classattr->value );
        TY_(tmbstrcat)( s, " " );
    }
    TY_(tmbstrcat)( s, classname );
    if (classattr->value)
        TidyDocFree( doc, classattr->value );
    classattr->value = s;
}

/* concatenate styles */
static void AppendToStyleAttr( TidyDocImpl* doc, AttVal *styleattr, ctmbstr styleprop )
{
    /*
    this doesn't handle CSS comments and
    leading/trailing white-space very well
    see http://www.w3.org/TR/css-style-attr
    */
    unsigned int end = TY_(tmbstrlen)(styleattr->value);

    if (end >0 && styleattr->value[end - 1] == ';')
    {
        /* attribute ends with declaration seperator */

        styleattr->value = (tmbstr) TidyDocRealloc(doc, styleattr->value,
            end + TY_(tmbstrlen)(styleprop) + 2);

        TY_(tmbstrcat)(styleattr->value, " ");
        TY_(tmbstrcat)(styleattr->value, styleprop);
    }
    else if (end >0 && styleattr->value[end - 1] == '}')
    {
        /* attribute ends with rule set */

        styleattr->value = (tmbstr) TidyDocRealloc(doc, styleattr->value,
            end + TY_(tmbstrlen)(styleprop) + 6);

        TY_(tmbstrcat)(styleattr->value, " { ");
        TY_(tmbstrcat)(styleattr->value, styleprop);
        TY_(tmbstrcat)(styleattr->value, " }");
    }
    else
    {
        /* attribute ends with property value */

        styleattr->value = (tmbstr) TidyDocRealloc(doc, styleattr->value,
            end + TY_(tmbstrlen)(styleprop) + 3);

        if (end > 0)
            TY_(tmbstrcat)(styleattr->value, "; ");
        TY_(tmbstrcat)(styleattr->value, styleprop);
    }
}

/*
 the same attribute name can't be used
 more than once in each element
*/
static Bool AttrsHaveSameName( AttVal* av1, AttVal* av2)
{
    TidyAttrId id1, id2;

    id1 = AttrId(av1);
    id2 = AttrId(av2);
    if (id1 != TidyAttr_UNKNOWN && id2 != TidyAttr_UNKNOWN)
        return AttrsHaveSameId(av1, av2);
    if (id1 != TidyAttr_UNKNOWN || id2 != TidyAttr_UNKNOWN)
        return no;
    if (av1->attribute && av2->attribute)
        return TY_(tmbstrcmp)(av1->attribute, av2->attribute) == 0;
     return no;
}

void TY_(RepairDuplicateAttributes)( TidyDocImpl* doc, Node *node, Bool isXml )
{
    AttVal *first;

    for (first = node->attributes; first != NULL;)
    {
        AttVal *second;
        Bool firstRedefined = no;

        if (!(first->asp == NULL && first->php == NULL))
        {
            first = first->next;
            continue;
        }

        for (second = first->next; second != NULL;)
        {
            AttVal *temp;

            if (!(second->asp == NULL && second->php == NULL
                  && AttrsHaveSameName(first, second)))
            {
                second = second->next;
                continue;
            }

            /* first and second attribute have same local name */
            /* now determine what to do with this duplicate... */

            if (!isXml
                && attrIsCLASS(first) && cfgBool(doc, TidyJoinClasses)
                && AttrHasValue(first) && AttrHasValue(second))
            {
                /* concatenate classes */

                TY_(AppendToClassAttr)(doc, first, second->value);

                temp = second->next;
                TY_(ReportAttrError)( doc, node, second, JOINING_ATTRIBUTE);
                TY_(RemoveAttribute)( doc, node, second );
                second = temp;
            }
            else if (!isXml
                     && attrIsSTYLE(first) && cfgBool(doc, TidyJoinStyles)
                     && AttrHasValue(first) && AttrHasValue(second))
            {
                AppendToStyleAttr( doc, first, second->value );

                temp = second->next;
                TY_(ReportAttrError)( doc, node, second, JOINING_ATTRIBUTE);
                TY_(RemoveAttribute)( doc, node, second );
                second = temp;
            }
            else if ( cfg(doc, TidyDuplicateAttrs) == TidyKeepLast )
            {
                temp = first->next;
                TY_(ReportAttrError)( doc, node, first, REPEATED_ATTRIBUTE);
                TY_(RemoveAttribute)( doc, node, first );
                firstRedefined = yes;
                first = temp;
                second = second->next;
            }
            else /* TidyDuplicateAttrs == TidyKeepFirst */
            {
                temp = second->next;
                TY_(ReportAttrError)( doc, node, second, REPEATED_ATTRIBUTE);
                TY_(RemoveAttribute)( doc, node, second );
                second = temp;
            }
        }
        if (!firstRedefined)
            first = first->next;
    }
}

/* ignore unknown attributes for proprietary elements */
const Attribute* TY_(CheckAttribute)( TidyDocIm