# This is a test for module Image::Quantize.

use warnings;
use strict;
use Test::More;
use FindBin;
use Image::Quantize::PNG;
use Image::PNG::Libpng ':all';
use Data::Dumper;
my $iq = Image::Quantize::PNG->new ();
ok ($iq);
$iq->speed (10);
my $pngfile = "$FindBin::Bin/test.png";
my $pngin = read_png_file ($pngfile);
my $ihdr = $pngin->get_IHDR ();
is ($ihdr->{height}, 400);
is ($ihdr->{width}, 383);
print "Before quantize\n";
my $pngout = $iq->quantize ($pngin);
print "After quantize\n";
my $ihdrout = $pngout->get_IHDR ();
is ($ihdrout->{height}, 400);
is ($ihdrout->{width}, 383);

my $outfile = "$FindBin::Bin/test-output.png";

$pngout->write_png_file ($outfile);
ok (-f $outfile);
if (-f $outfile) {
    unlink ($outfile);
}

$pngfile = "$FindBin::Bin/mach.png";
$pngin = read_png_file ($pngfile);

# my $ihdr = $pngin->get_IHDR ();
# if ($ihdr->{height} <= 0 || $ihdr->{width} <= 0) {
#     "image dimensions $ihdr->{width} x $ihdr->{height}";
#     exit;
# }

$pngout = $iq->quantize ($pngin);
$outfile = "$FindBin::Bin/mach-output.png";
$pngout->write_png_file ($outfile);
ok (-f $outfile);
if (-f $outfile) {
    unlink ($outfile);
}
done_testing ();
