# This is a test for module Image::Quantize.

use warnings;
use strict;
use Test::More;
use Image::Quantize;

# floating point allowance.

my $eps = 0.0001;

my $iq = Image::Quantize->new ();
ok ($iq);
$iq->max_colors (10);
eval {
    $iq->max_colors (257);
};
ok ($@);

eval {
    $iq->set (dithering_level => 0.5, max_colors => 100);
};
ok (! $@);
if ($@) {
    note ("Failed with error $@");
}

# Test the getter for dithering level.

cmp_ok (abs ($iq->dithering_level () - 0.5), '<', $eps);

is ($iq->max_colors, 100);
is ($iq->get ('max_colors'), 100);

# Test quality set/get

$iq->quality (10, 20);
my ($min, $max) = $iq->quality ();
is ($min, 10);
is ($max, 20);

# Test min_posterization set/get

$iq->min_posterization (4);
my $mp = $iq->min_posterization ();
is ($mp, 4);

TODO: {
    local $TODO = 'This is not implemented yet';
};

# Test switch off dithering level.

$iq->default_dithering_level ();

is ($iq->dithering_level (), undef);

# "quantize" doesn't work without an image format so the following is
# meant to throw an error.

eval {
    $iq->quantize ();
};
ok ($@);

done_testing ();
