use strict;
use warnings;
use ExtUtils::MakeMaker;

my $pm = 'lib/JSON/Repair.pm';
my $pod = 'lib/JSON/Repair.pod';
my $github = 'github.com/benkasminbullock/json-repair';
my $repo = "https://$github";
WriteMakefile (
    NAME => 'JSON::Repair',
    VERSION_FROM => $pm,
    ABSTRACT_FROM => $pod,
    AUTHOR => 'Ben Bullock <bkb@cpan.org>',
    LICENSE => 'perl',
    PREREQ_PM => {
	'JSON::Parse' => '0.47',
	'C::Tokenize' => '0.11',
    },
    META_MERGE => {
	'meta-spec' => {
	    version => 2,
	},
        resources => {
            repository => {
		type => 'git',
		url => "git://$github.git",
		web => $repo,
	    },
            bugtracker => {
		web => "$repo/issues",
	    },
#	    homepage => 'http://',
        },
    },
    MIN_PERL_VERSION => '5.014001',
);
