package Rose::DB::Object::Metadata::Column::DatetimeYearToSecond;

use strict;

use Rose::DB::Object::Metadata::Column::Datetime;
our @ISA = qw(Rose::DB::Object::Metadata::Column::Datetime);

our $VERSION = '0.02';

sub type { 'datetime year to second' }

sub should_inline_value
{
  #my($self, $db, $value) = @_;
  return ($_[1]->validate_datetime_year_to_second_keyword($_[2]) && 
          ($_[1]->driver eq 'Informix' || $_[2] =~ /^\w+\(.*\)$/)) ? 1 : 0;
}

sub parse_value  { shift; shift->parse_datetime_year_to_second@_)  }
sub format_value { shift; shift->format_datetime_year_to_second(@_) }

1;

__END__

=head1 NAME

Rose::DB::Object::Metadata::Column::DatetimeYearToSecond - Datetime year to second column metadata.

=head1 SYNOPSIS

  use Rose::DB::Object::Metadata::Column::DatetimeYearToSecond;

  $col = 
    Rose::DB::Object::Metadata::Column::DatetimeYearToSecond->new(...);

  $col->make_method(...);
  ...

=head1 DESCRIPTION

Objects of this class store and manipulate metadata for "datetime year to second  columns" in a database.  Column metadata objects store information about columns (data type, size, etc.) and are responsible for creating object methods that manipulate column values.

This class inherits from C<Rose::DB::Object::Metadata::Datetime>. Inherited methods that are not overridden will not be documented a second time here.  See the C<Rose::DB::Object::Metadata::Datetime> documentation for more information.

=head1 OBJECT METHODS

=over 4

=item B<method_maker_class>

Returns C<Rose::DB::Object::MakeMethods::Date>.

=item B<method_maker_type>

Returns C<datetime>.

=item B<parse_value DB, VALUE>

Convert VALUE to the equivalent C<DateTime> object suitable for storage in a "datetime year to second" column.  VALUE maybe returned unmodified if it is a valid "datetime year to second" keyword or otherwise has special meaning to the underlying database.  DB is a C<Rose::DB> object that is used as part of the parsing process.  Both arguments are required.

=item B<type>

Returns "datetime year to second".

=back

=head1 AUTHOR

John C. Siracusa (siracusa@mindspring.com)

=head1 COPYRIGHT

Copyright (c) 2005 by John C. Siracusa.  All rights reserved.  This program is
free software; you can redistribute it and/or modify it under the same terms
as Perl itself.
