#!perl -T

BEGIN
{
  unless ( $ENV{ AUTHOR_TESTING } )
  {
    print qq{1..0 # SKIP these tests are for testing by the author\n};
    exit;
  }
}


use 5.006;

#use strict;
#use warnings;
#use Carp;
use feature 'say';
use Data::Dumper;
use Data::Printer;

#$Data::Dumper::Maxdepth = 3;
#use WebService::Google::Client;
use Test::More;

my $DEBUG = 0;    ## makes a lot more noise

=pod

=head1 SYNOPSIS

acl.t - Calendar ACL API Tests

=head2 USAGE

To run in the local directory assuming gapi.json present in source root and in xt/author/calendar directory
  C<prove -I../../../lib acl.t -w -o -v>

=pod

=head1 CALENDAR ACL TESTS

=head2 Assumptions:

=over 2

=item credentials (gapi.json) required to run - if credentials not available then skip all tests

=item credentials (gapi.json) include Calendar scope - if not available then skip all tests

=back

=cut

=head2 VALIDATION CREDENTIAL PRE-REQUISITES OR EXIT 

=cut


=head2 Test $gapi->Calendar->Acl->list

An access control rule granting a user (or a group of users) a specified level of access to a calendar. 
A single access control rule is represented by an ACL resource. The ACL collection for a given calendar contains all 
ACL resources that grant access to that calendar.

=cut

## TODO - refactor the use of ENV for testing out as mozilla will be run as root to enable install
##        and setting these as root is unecessarily fiddly. Alternative - if a gapi.json file
##        exists use it - also skip tests where scope not set - default first available user in gapi.conf


use_ok( 'WebService::Google::Client' );    # || print "Bail out!\n";

#require_ok( 'WebService::Google::Client' );

my $default_file = $ENV{ 'GOOGLE_TOKENSFILE' } || '../../../gapi.json';
my $user         = $ENV{ 'GMAIL_FOR_TESTING' } || '';


#my $gapi = WebService::Google::Client->new( debug => 0 );
#diag("config file = $default_file");
#diag("user = $user");
#note("user = $user"); ## note not to STDERR


subtest 'Test with User Configuration' => sub {
  plan( skip_all => 'No user configuration - set $ENV{GOOGLE_TOKENSFILE}' ) unless -e $default_file;

  ok( 1 == 1, 'Configured WebService::Google::Client User' );
  my $gapi = WebService::Google::Client->new( debug => $DEBUG );

  $gapi->auth_storage->setup( { type => 'jsonfile', path => $default_file } ) || croak( $! );
  my $aref_token_emails = $gapi->auth_storage->storage->get_token_emails_from_storage;
  $user = $aref_token_emails->[0] unless $user;    ## default to the first user if none defined yet
  if ( -e $default_file )
  {
    $gapi->auth_storage->setup( { type => 'jsonfile', path => $default_file } );
    $gapi->user( $user );

    #p($gapi);
    note( "Running tests with user '$user' using '$default_file' credentials" );
  }
  my $acl_rule_id          = undef;
  my $inserted_acl_rule_id = undef;

  # list of rules for primary calendar
  subtest 'Acl->list' => sub {
    my $t = $gapi->Calendar->Acl->list( { calendarId => 'primary', options => { maxResults => 2 } } )->json;

    #diag( Dumper $t->{items} );
    ok( ref( $t->{ items } ) eq 'ARRAY',                "returned an ARRAY" );
    ok( scalar @{ $t->{ items } } == 2,                 "maxResults option is working" );
    ok( scalar @{ $t->{ items } } > 0,                  "ARRAY isn't empty (Acl must have at least one owner)" );
    ok( $t->{ items }[0]{ kind } eq 'calendar#aclRule', "kind seems like OK - calendar#calendarListEntry" );
    $acl_rule_id = $t->{ items }[0]{ id };    # will be like 'user:peter@shotgundriver.com'
    note( "acl_rule_id =  $acl_rule_id" );

  };

  # warn "SETTING ACL_RULE_ID + $acl_rule_id";

=pod
    subtest 'Acl->get' => sub {
        note( "acl_rule_id =  $acl_rule_id" );
        my $t = $gapi->Calendar->Acl->get( { calendarId => 'primary', ruleId => $acl_rule_id } )->json;
        note( Dumper $t );
        note( ref($t) );
        ok( ref($t) eq 'HASH', "returned single item" );
        ok( $t->{kind} eq 'calendar#aclRule', "kind seems like OK - calendar#aclRule" );
        ok( $t->{id} eq $acl_rule_id, "got Acl id with right id (previously listed first)" );
    };

    subtest 'Acl->insert' => sub {
        my $t = $gapi->Calendar->Acl->insert(
            {
                calendarId => 'primary',
                options    => {
                    role  => 'freeBusyReader',
                    scope => { type => 'user', value => 'peter@shotgundriver.com' },
                }
            }
        )->json;
        ok( ref($t) eq 'HASH', "returned single item" );
    };
=cut

};
done_testing();


=pod

=head2 ASSUMPTIONS



=head2 TODO:

=over 2

=item need to check that required scopes are configured in gapi.json

=over 4

=item * email 

=item * profile 

=item * https://www.googleapis.com/auth/plus.profile.emails.read 

=item * https://www.googleapis.com/auth/calendar 

=item * https://www.googleapis.com/auth/contacts.readonly

=back

=item get default email address from config using ConfigJSON::get_token_emails_from_storage() that I created earlier

=back



=cut
