# NAME

WebService::Google::Client - Google API Services Client.

# VERSION

version 0.06

# SYNOPSIS

    use WebService::Google::Client;
    use Data::Dumper;

    my $gapi = WebService::Google::Client->new(debug => 0); # my $gapi = WebService::Google::Client->new(access_token => '');
    my $user = 'peter@pscott.com.au'; # full gmail or G-Suite email

    $gapi->auth_storage->setup({type => 'jsonfile', path => '/path' }); # by default

    $gapi->user($user);       ## allows to select user configuration by google auth'd email address
    $gapi->do_autorefresh(1); ## refresh auth token with refresh token if auth session has expired

    my $r1 = $gapi->Calendar->Events->list({ calendarId => 'primary' })->json;
    carp scalar @{$r1->{items}};

    print Dumper $gapi_agent->Gmail->Users->getProfile( { userId => 'me'  } )->json;

    print $gapi_agent->discovery->chi->root_dir(); ## provides the directory used to hold cached API discovery specs by CHI

To create or modify authorization file with scope and user tokens in current folder run _goauth_ CLI tool

## TYPICAL USAGE ( WITHOUT AUTO-GENERATED CLASSES )

    use feature 'say';
    use WebService::Google::Client;

    my $gapi = WebService::Google::Client->new(debug => 0);
    $gapi->auth_storage->setup({ type => 'jsonfile', path => './gapi.json' }) || croak('Unable to ');
    my $aref_token_emails = $gapi->auth_storage->storage->get_token_emails_from_storage;
    my $user = $aref_token_emails->[0];
    print "Running tests with default user email = $user\n";
    $gapi->user($user);
    $gapi->do_autorefresh;

    my $cl =   $gapi->api_query({
        method => 'get',
        path       => "https://www.googleapis.com/gmail/v1/users/me/messages?q=newer_than:1d;to:$user", 
    });

    if ($cl->code eq '200') ## Mojo::Message::Response
    {
        foreach my $msg ( @{ $cl->json->{messages} } )
        {
            say $cl->to_string;
        }

    }

See unit test in xt folder for more examples and some use cases for specific APIS in the /examples folder

# KEY FEATURES

- Object-oriented calls by API->Resource->method schema. Like $gapi->Calendar->Events->lists ( Under Review )
- Classes are generated dynamically using [Moose::Meta::Class](https://metacpan.org/pod/Moose::Meta::Class) based on Google API Discovery Service ( Under review )
- API Discovery with local caching using CHI File
- OAUTH app credentials (client\_id, client\_secret, users access\_token && refresh\_token) storage stored in local gapi.json file
- Automatic access\_token refresh (if user has refresh\_token) and saving refreshed token to storage
- CLI tool (_goauth_) with lightweight http server to simplify config OAuth2 configuration, sccoping, authorization and obtaining access\_ and refresh\_ tokens

## TODO: 

- DBI and MongoDB not currently implemented
- Refactor tests
- Memoise discovery data
- Option to Configure Auth Storage on new instance creation 

# SEE ALSO

- [Moo::Google](https://metacpan.org/pod/Moo::Google) - The original code base later forked into [WebService::Google](https://metacpan.org/pod/WebService::Google) by Steve Dondley who was unable to collaborate with
- ["/github.com/APIs-guru/google-discovery-to-swagger" in Google Swagger API https:](https://metacpan.org/pod/Google&#x20;Swagger&#x20;API&#x20;https:#github.com-APIs-guru-google-discovery-to-swagger) 

# AUTHORS

- Pavel Serikov <pavelsr@cpan.org>
- Peter Scott <peter@pscott.com.au>

# COPYRIGHT AND LICENSE

This software is copyright (c) 2017-2018 by Pavel Serikov, Peter Scott.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.
