package t::lib::helpers;

use strict;
use warnings;
use Config::Any;
use Exporter qw(import);
use Hash::Merge::Simple qw(merge);
use Test::Modern qw(any array_each re);

our @EXPORT = qw(
  cmp_controlfield
  cmp_datafield
  cmp_record
  cmp_subfield
  create_api
);

sub cmp_controlfield {
  return {
    content => re('.*'),
    tag     => re('^\d+$'),
  };
}

sub cmp_subfield {
  return {
    code    => re('.+'),
    content => re('.*'),
  };
}

sub cmp_datafield {
  return {
    ind1     => re('.*'),
    ind2     => re('.*'),
    subfield => any(cmp_subfield, array_each(cmp_subfield)),
    tag      => re('^\d+$'),
  };
}

sub cmp_record {
  return {
    leader       => re('.*'),
    xmlns        => 'http://www.loc.gov/MARC21/slim',
    controlfield => array_each(cmp_controlfield),
    datafield    => array_each(cmp_datafield),
  };
}

sub create_api {
  my %args = @_;
  return WorldCat::API->new(%args);
}

1;
